# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CompressionRuleArgs', 'CompressionRule']

@pulumi.input_type
class CompressionRuleArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[_builtins.int],
                 brotli: Optional[pulumi.Input[_builtins.str]] = None,
                 gzip: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sequence: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 zstd: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CompressionRule resource.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.str] brotli: Brotli compression. Value range:
        :param pulumi.Input[_builtins.str] gzip: Gzip compression. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] sequence: Order of rule execution. The smaller the value, the higher the priority for execution.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.str] zstd: Zstd compression. Value range:
        """
        pulumi.set(__self__, "site_id", site_id)
        if brotli is not None:
            pulumi.set(__self__, "brotli", brotli)
        if gzip is not None:
            pulumi.set(__self__, "gzip", gzip)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if sequence is not None:
            pulumi.set(__self__, "sequence", sequence)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if zstd is not None:
            pulumi.set(__self__, "zstd", zstd)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def brotli(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Brotli compression. Value range:
        """
        return pulumi.get(self, "brotli")

    @brotli.setter
    def brotli(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "brotli", value)

    @_builtins.property
    @pulumi.getter
    def gzip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gzip compression. Value range:
        """
        return pulumi.get(self, "gzip")

    @gzip.setter
    def gzip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gzip", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter
    def sequence(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Order of rule execution. The smaller the value, the higher the priority for execution.
        """
        return pulumi.get(self, "sequence")

    @sequence.setter
    def sequence(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sequence", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter
    def zstd(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zstd compression. Value range:
        """
        return pulumi.get(self, "zstd")

    @zstd.setter
    def zstd(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zstd", value)


@pulumi.input_type
class _CompressionRuleState:
    def __init__(__self__, *,
                 brotli: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 gzip: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sequence: Optional[pulumi.Input[_builtins.int]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 zstd: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CompressionRule resources.
        :param pulumi.Input[_builtins.str] brotli: Brotli compression. Value range:
        :param pulumi.Input[_builtins.int] config_id: Config Id
        :param pulumi.Input[_builtins.str] gzip: Gzip compression. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] sequence: Order of rule execution. The smaller the value, the higher the priority for execution.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.str] zstd: Zstd compression. Value range:
        """
        if brotli is not None:
            pulumi.set(__self__, "brotli", brotli)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if gzip is not None:
            pulumi.set(__self__, "gzip", gzip)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if sequence is not None:
            pulumi.set(__self__, "sequence", sequence)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if zstd is not None:
            pulumi.set(__self__, "zstd", zstd)

    @_builtins.property
    @pulumi.getter
    def brotli(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Brotli compression. Value range:
        """
        return pulumi.get(self, "brotli")

    @brotli.setter
    def brotli(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "brotli", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Config Id
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter
    def gzip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gzip compression. Value range:
        """
        return pulumi.get(self, "gzip")

    @gzip.setter
    def gzip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gzip", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter
    def sequence(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Order of rule execution. The smaller the value, the higher the priority for execution.
        """
        return pulumi.get(self, "sequence")

    @sequence.setter
    def sequence(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sequence", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter
    def zstd(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zstd compression. Value range:
        """
        return pulumi.get(self, "zstd")

    @zstd.setter
    def zstd(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zstd", value)


@pulumi.type_token("alicloud:esa/compressionRule:CompressionRule")
class CompressionRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brotli: Optional[pulumi.Input[_builtins.str]] = None,
                 gzip: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sequence: Optional[pulumi.Input[_builtins.int]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 zstd: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Compression Rule resource.

        For information about ESA Compression Rule and how to use it, see [What is Compression Rule](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateCompressionRule).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        example = alicloud.esa.Site("example",
            site_name="compression.example.com",
            instance_id=default.sites[0].instance_id,
            coverage="domestic",
            access_type="NS")
        default_compression_rule = alicloud.esa.CompressionRule("default",
            gzip="off",
            brotli="off",
            rule="http.host eq \\"video.example.com\\"",
            site_version=0,
            rule_name="rule_example",
            site_id=example.id,
            zstd="off",
            rule_enable="off")
        ```

        ## Import

        ESA Compression Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/compressionRule:CompressionRule example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] brotli: Brotli compression. Value range:
        :param pulumi.Input[_builtins.str] gzip: Gzip compression. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] sequence: Order of rule execution. The smaller the value, the higher the priority for execution.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.str] zstd: Zstd compression. Value range:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CompressionRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Compression Rule resource.

        For information about ESA Compression Rule and how to use it, see [What is Compression Rule](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateCompressionRule).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        example = alicloud.esa.Site("example",
            site_name="compression.example.com",
            instance_id=default.sites[0].instance_id,
            coverage="domestic",
            access_type="NS")
        default_compression_rule = alicloud.esa.CompressionRule("default",
            gzip="off",
            brotli="off",
            rule="http.host eq \\"video.example.com\\"",
            site_version=0,
            rule_name="rule_example",
            site_id=example.id,
            zstd="off",
            rule_enable="off")
        ```

        ## Import

        ESA Compression Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/compressionRule:CompressionRule example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param CompressionRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CompressionRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brotli: Optional[pulumi.Input[_builtins.str]] = None,
                 gzip: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sequence: Optional[pulumi.Input[_builtins.int]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 zstd: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CompressionRuleArgs.__new__(CompressionRuleArgs)

            __props__.__dict__["brotli"] = brotli
            __props__.__dict__["gzip"] = gzip
            __props__.__dict__["rule"] = rule
            __props__.__dict__["rule_enable"] = rule_enable
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["sequence"] = sequence
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["site_version"] = site_version
            __props__.__dict__["zstd"] = zstd
            __props__.__dict__["config_id"] = None
        super(CompressionRule, __self__).__init__(
            'alicloud:esa/compressionRule:CompressionRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            brotli: Optional[pulumi.Input[_builtins.str]] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            gzip: Optional[pulumi.Input[_builtins.str]] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            sequence: Optional[pulumi.Input[_builtins.int]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            site_version: Optional[pulumi.Input[_builtins.int]] = None,
            zstd: Optional[pulumi.Input[_builtins.str]] = None) -> 'CompressionRule':
        """
        Get an existing CompressionRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] brotli: Brotli compression. Value range:
        :param pulumi.Input[_builtins.int] config_id: Config Id
        :param pulumi.Input[_builtins.str] gzip: Gzip compression. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] sequence: Order of rule execution. The smaller the value, the higher the priority for execution.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.int] site_version: The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        :param pulumi.Input[_builtins.str] zstd: Zstd compression. Value range:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CompressionRuleState.__new__(_CompressionRuleState)

        __props__.__dict__["brotli"] = brotli
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["gzip"] = gzip
        __props__.__dict__["rule"] = rule
        __props__.__dict__["rule_enable"] = rule_enable
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["sequence"] = sequence
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_version"] = site_version
        __props__.__dict__["zstd"] = zstd
        return CompressionRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def brotli(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Brotli compression. Value range:
        """
        return pulumi.get(self, "brotli")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Config Id
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter
    def gzip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Gzip compression. Value range:
        """
        return pulumi.get(self, "gzip")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        """
        return pulumi.get(self, "rule_enable")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def sequence(self) -> pulumi.Output[_builtins.int]:
        """
        Order of rule execution. The smaller the value, the higher the priority for execution.
        """
        return pulumi.get(self, "sequence")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The version number of the site configuration. For sites that have enabled configuration version management, this parameter can be used to specify the effective version of the configuration site, which defaults to version 0.
        """
        return pulumi.get(self, "site_version")

    @_builtins.property
    @pulumi.getter
    def zstd(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Zstd compression. Value range:
        """
        return pulumi.get(self, "zstd")

