# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EdgeContainerAppRecordArgs', 'EdgeContainerAppRecord']

@pulumi.input_type
class EdgeContainerAppRecordArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[_builtins.str],
                 record_name: pulumi.Input[_builtins.str],
                 site_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a EdgeContainerAppRecord resource.
        :param pulumi.Input[_builtins.str] app_id: The application ID
        :param pulumi.Input[_builtins.str] record_name: The associated domain name.
        :param pulumi.Input[_builtins.int] site_id: The website ID.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "record_name", record_name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The application ID
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="recordName")
    def record_name(self) -> pulumi.Input[_builtins.str]:
        """
        The associated domain name.
        """
        return pulumi.get(self, "record_name")

    @record_name.setter
    def record_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "record_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The website ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)


@pulumi.input_type
class _EdgeContainerAppRecordState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 record_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering EdgeContainerAppRecord resources.
        :param pulumi.Input[_builtins.str] app_id: The application ID
        :param pulumi.Input[_builtins.str] create_time: The time when the domain name was added. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] record_name: The associated domain name.
        :param pulumi.Input[_builtins.int] site_id: The website ID.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application ID
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the domain name was added. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The associated domain name.
        """
        return pulumi.get(self, "record_name")

    @record_name.setter
    def record_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The website ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)


@pulumi.type_token("alicloud:esa/edgeContainerAppRecord:EdgeContainerAppRecord")
class EdgeContainerAppRecord(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 record_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Edge Container App Record resource.

        For information about ESA Edge Container App Record and how to use it, see [What is Edge Container App Record](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateEdgeContainerAppRecord).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform.com"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        resource_site_origin_pool_test = alicloud.esa.Site("resource_Site_OriginPool_test",
            site_name=f"gositecdn-{default_integer['result']}.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_edge_container_app = alicloud.esa.EdgeContainerApp("default",
            health_check_host="example.com",
            health_check_type="l7",
            service_port=80,
            health_check_interval=5,
            edge_container_app_name="terraform-app",
            health_check_http_code="http_2xx",
            health_check_uri="/",
            health_check_timeout=3,
            health_check_succ_times=2,
            remarks=name,
            health_check_method="HEAD",
            health_check_port=80,
            health_check_fail_times=5,
            target_port=3000)
        default_edge_container_app_record = alicloud.esa.EdgeContainerAppRecord("default",
            record_name="tf.terraform.com",
            site_id=resource_site_origin_pool_test.id,
            app_id=default_edge_container_app.id)
        ```

        ## Import

        ESA Edge Container App Record can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/edgeContainerAppRecord:EdgeContainerAppRecord example <site_id>:<app_id>:<record_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The application ID
        :param pulumi.Input[_builtins.str] record_name: The associated domain name.
        :param pulumi.Input[_builtins.int] site_id: The website ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeContainerAppRecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Edge Container App Record resource.

        For information about ESA Edge Container App Record and how to use it, see [What is Edge Container App Record](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateEdgeContainerAppRecord).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform.com"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        resource_site_origin_pool_test = alicloud.esa.Site("resource_Site_OriginPool_test",
            site_name=f"gositecdn-{default_integer['result']}.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_edge_container_app = alicloud.esa.EdgeContainerApp("default",
            health_check_host="example.com",
            health_check_type="l7",
            service_port=80,
            health_check_interval=5,
            edge_container_app_name="terraform-app",
            health_check_http_code="http_2xx",
            health_check_uri="/",
            health_check_timeout=3,
            health_check_succ_times=2,
            remarks=name,
            health_check_method="HEAD",
            health_check_port=80,
            health_check_fail_times=5,
            target_port=3000)
        default_edge_container_app_record = alicloud.esa.EdgeContainerAppRecord("default",
            record_name="tf.terraform.com",
            site_id=resource_site_origin_pool_test.id,
            app_id=default_edge_container_app.id)
        ```

        ## Import

        ESA Edge Container App Record can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/edgeContainerAppRecord:EdgeContainerAppRecord example <site_id>:<app_id>:<record_name>
        ```

        :param str resource_name: The name of the resource.
        :param EdgeContainerAppRecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeContainerAppRecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 record_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeContainerAppRecordArgs.__new__(EdgeContainerAppRecordArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            if record_name is None and not opts.urn:
                raise TypeError("Missing required property 'record_name'")
            __props__.__dict__["record_name"] = record_name
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["create_time"] = None
        super(EdgeContainerAppRecord, __self__).__init__(
            'alicloud:esa/edgeContainerAppRecord:EdgeContainerAppRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            record_name: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'EdgeContainerAppRecord':
        """
        Get an existing EdgeContainerAppRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The application ID
        :param pulumi.Input[_builtins.str] create_time: The time when the domain name was added. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] record_name: The associated domain name.
        :param pulumi.Input[_builtins.int] site_id: The website ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeContainerAppRecordState.__new__(_EdgeContainerAppRecordState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["record_name"] = record_name
        __props__.__dict__["site_id"] = site_id
        return EdgeContainerAppRecord(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The application ID
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the domain name was added. The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ss format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="recordName")
    def record_name(self) -> pulumi.Output[_builtins.str]:
        """
        The associated domain name.
        """
        return pulumi.get(self, "record_name")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The website ID.
        """
        return pulumi.get(self, "site_id")

