# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HttpsBasicConfigurationArgs', 'HttpsBasicConfiguration']

@pulumi.input_type
class HttpsBasicConfigurationArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[_builtins.int],
                 ciphersuite: Optional[pulumi.Input[_builtins.str]] = None,
                 ciphersuite_group: Optional[pulumi.Input[_builtins.str]] = None,
                 http2: Optional[pulumi.Input[_builtins.str]] = None,
                 http3: Optional[pulumi.Input[_builtins.str]] = None,
                 https: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_stapling: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tls10: Optional[pulumi.Input[_builtins.str]] = None,
                 tls11: Optional[pulumi.Input[_builtins.str]] = None,
                 tls12: Optional[pulumi.Input[_builtins.str]] = None,
                 tls13: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HttpsBasicConfiguration resource.
        :param pulumi.Input[_builtins.int] site_id: Site ID, which can be obtained by calling the [ListSites](https://next.api.alibabacloud.com/document/ESA/2024-09-10/ListSites) interface.
        :param pulumi.Input[_builtins.str] ciphersuite: Custom cipher suite, indicating the specific encryption algorithm selected when CiphersuiteGroup is set to custom.
        :param pulumi.Input[_builtins.str] ciphersuite_group: Cipher suite group. Default is all cipher suites. Possible values:
               - all: All cipher suites.
               - strict: Strong cipher suites.
               - custom: Custom cipher suites.
        :param pulumi.Input[_builtins.str] http2: Indicates whether HTTP2 is enabled. Default is on. Possible values:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] http3: Whether to enable HTTP3, which is enabled by default. The value can be:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] https: Whether to enable HTTPS. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] ocsp_stapling: Indicates whether OCSP is enabled. Default is off. Possible values:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               -  Match all incoming requests: value set to true
               -  Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
               - on: open.
               - off: close.
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.str] tls10: Whether to enable TLS1.0. Default is disabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls11: Whether to enable TLS1.1. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls12: Whether to enable TLS1.2. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls13: Whether to enable TLS1.3. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        """
        pulumi.set(__self__, "site_id", site_id)
        if ciphersuite is not None:
            pulumi.set(__self__, "ciphersuite", ciphersuite)
        if ciphersuite_group is not None:
            pulumi.set(__self__, "ciphersuite_group", ciphersuite_group)
        if http2 is not None:
            pulumi.set(__self__, "http2", http2)
        if http3 is not None:
            pulumi.set(__self__, "http3", http3)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if ocsp_stapling is not None:
            pulumi.set(__self__, "ocsp_stapling", ocsp_stapling)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if tls10 is not None:
            pulumi.set(__self__, "tls10", tls10)
        if tls11 is not None:
            pulumi.set(__self__, "tls11", tls11)
        if tls12 is not None:
            pulumi.set(__self__, "tls12", tls12)
        if tls13 is not None:
            pulumi.set(__self__, "tls13", tls13)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        Site ID, which can be obtained by calling the [ListSites](https://next.api.alibabacloud.com/document/ESA/2024-09-10/ListSites) interface.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def ciphersuite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom cipher suite, indicating the specific encryption algorithm selected when CiphersuiteGroup is set to custom.
        """
        return pulumi.get(self, "ciphersuite")

    @ciphersuite.setter
    def ciphersuite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ciphersuite", value)

    @_builtins.property
    @pulumi.getter(name="ciphersuiteGroup")
    def ciphersuite_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cipher suite group. Default is all cipher suites. Possible values:
        - all: All cipher suites.
        - strict: Strong cipher suites.
        - custom: Custom cipher suites.
        """
        return pulumi.get(self, "ciphersuite_group")

    @ciphersuite_group.setter
    def ciphersuite_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ciphersuite_group", value)

    @_builtins.property
    @pulumi.getter
    def http2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether HTTP2 is enabled. Default is on. Possible values:
        - on: Enabled.
        - off: Disabled.
        """
        return pulumi.get(self, "http2")

    @http2.setter
    def http2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http2", value)

    @_builtins.property
    @pulumi.getter
    def http3(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable HTTP3, which is enabled by default. The value can be:
        - on: Enabled.
        - off: Disabled.
        """
        return pulumi.get(self, "http3")

    @http3.setter
    def http3(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http3", value)

    @_builtins.property
    @pulumi.getter
    def https(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable HTTPS. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "https")

    @https.setter
    def https(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https", value)

    @_builtins.property
    @pulumi.getter(name="ocspStapling")
    def ocsp_stapling(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether OCSP is enabled. Default is off. Possible values:
        - on: Enabled.
        - off: Disabled.
        """
        return pulumi.get(self, "ocsp_stapling")

    @ocsp_stapling.setter
    def ocsp_stapling(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocsp_stapling", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        -  Match all incoming requests: value set to true
        -  Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        - on: open.
        - off: close.
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter
    def tls10(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable TLS1.0. Default is disabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls10")

    @tls10.setter
    def tls10(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls10", value)

    @_builtins.property
    @pulumi.getter
    def tls11(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable TLS1.1. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls11")

    @tls11.setter
    def tls11(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls11", value)

    @_builtins.property
    @pulumi.getter
    def tls12(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable TLS1.2. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls12")

    @tls12.setter
    def tls12(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls12", value)

    @_builtins.property
    @pulumi.getter
    def tls13(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable TLS1.3. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls13")

    @tls13.setter
    def tls13(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls13", value)


@pulumi.input_type
class _HttpsBasicConfigurationState:
    def __init__(__self__, *,
                 ciphersuite: Optional[pulumi.Input[_builtins.str]] = None,
                 ciphersuite_group: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 http2: Optional[pulumi.Input[_builtins.str]] = None,
                 http3: Optional[pulumi.Input[_builtins.str]] = None,
                 https: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_stapling: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 tls10: Optional[pulumi.Input[_builtins.str]] = None,
                 tls11: Optional[pulumi.Input[_builtins.str]] = None,
                 tls12: Optional[pulumi.Input[_builtins.str]] = None,
                 tls13: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HttpsBasicConfiguration resources.
        :param pulumi.Input[_builtins.str] ciphersuite: Custom cipher suite, indicating the specific encryption algorithm selected when CiphersuiteGroup is set to custom.
        :param pulumi.Input[_builtins.str] ciphersuite_group: Cipher suite group. Default is all cipher suites. Possible values:
               - all: All cipher suites.
               - strict: Strong cipher suites.
               - custom: Custom cipher suites.
        :param pulumi.Input[_builtins.int] config_id: ConfigId of the configuration, which can be obtained by calling the [ListHttpsBasicConfigurations](https://www.alibabacloud.com/help/en/doc-detail/2867470.html) interface.
        :param pulumi.Input[_builtins.str] http2: Indicates whether HTTP2 is enabled. Default is on. Possible values:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] http3: Whether to enable HTTP3, which is enabled by default. The value can be:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] https: Whether to enable HTTPS. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] ocsp_stapling: Indicates whether OCSP is enabled. Default is off. Possible values:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               -  Match all incoming requests: value set to true
               -  Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
               - on: open.
               - off: close.
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: Site ID, which can be obtained by calling the [ListSites](https://next.api.alibabacloud.com/document/ESA/2024-09-10/ListSites) interface.
        :param pulumi.Input[_builtins.str] tls10: Whether to enable TLS1.0. Default is disabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls11: Whether to enable TLS1.1. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls12: Whether to enable TLS1.2. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls13: Whether to enable TLS1.3. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        """
        if ciphersuite is not None:
            pulumi.set(__self__, "ciphersuite", ciphersuite)
        if ciphersuite_group is not None:
            pulumi.set(__self__, "ciphersuite_group", ciphersuite_group)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if http2 is not None:
            pulumi.set(__self__, "http2", http2)
        if http3 is not None:
            pulumi.set(__self__, "http3", http3)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if ocsp_stapling is not None:
            pulumi.set(__self__, "ocsp_stapling", ocsp_stapling)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if tls10 is not None:
            pulumi.set(__self__, "tls10", tls10)
        if tls11 is not None:
            pulumi.set(__self__, "tls11", tls11)
        if tls12 is not None:
            pulumi.set(__self__, "tls12", tls12)
        if tls13 is not None:
            pulumi.set(__self__, "tls13", tls13)

    @_builtins.property
    @pulumi.getter
    def ciphersuite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom cipher suite, indicating the specific encryption algorithm selected when CiphersuiteGroup is set to custom.
        """
        return pulumi.get(self, "ciphersuite")

    @ciphersuite.setter
    def ciphersuite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ciphersuite", value)

    @_builtins.property
    @pulumi.getter(name="ciphersuiteGroup")
    def ciphersuite_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cipher suite group. Default is all cipher suites. Possible values:
        - all: All cipher suites.
        - strict: Strong cipher suites.
        - custom: Custom cipher suites.
        """
        return pulumi.get(self, "ciphersuite_group")

    @ciphersuite_group.setter
    def ciphersuite_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ciphersuite_group", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ConfigId of the configuration, which can be obtained by calling the [ListHttpsBasicConfigurations](https://www.alibabacloud.com/help/en/doc-detail/2867470.html) interface.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter
    def http2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether HTTP2 is enabled. Default is on. Possible values:
        - on: Enabled.
        - off: Disabled.
        """
        return pulumi.get(self, "http2")

    @http2.setter
    def http2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http2", value)

    @_builtins.property
    @pulumi.getter
    def http3(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable HTTP3, which is enabled by default. The value can be:
        - on: Enabled.
        - off: Disabled.
        """
        return pulumi.get(self, "http3")

    @http3.setter
    def http3(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http3", value)

    @_builtins.property
    @pulumi.getter
    def https(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable HTTPS. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "https")

    @https.setter
    def https(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https", value)

    @_builtins.property
    @pulumi.getter(name="ocspStapling")
    def ocsp_stapling(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether OCSP is enabled. Default is off. Possible values:
        - on: Enabled.
        - off: Disabled.
        """
        return pulumi.get(self, "ocsp_stapling")

    @ocsp_stapling.setter
    def ocsp_stapling(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocsp_stapling", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        -  Match all incoming requests: value set to true
        -  Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        - on: open.
        - off: close.
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Site ID, which can be obtained by calling the [ListSites](https://next.api.alibabacloud.com/document/ESA/2024-09-10/ListSites) interface.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def tls10(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable TLS1.0. Default is disabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls10")

    @tls10.setter
    def tls10(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls10", value)

    @_builtins.property
    @pulumi.getter
    def tls11(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable TLS1.1. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls11")

    @tls11.setter
    def tls11(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls11", value)

    @_builtins.property
    @pulumi.getter
    def tls12(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable TLS1.2. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls12")

    @tls12.setter
    def tls12(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls12", value)

    @_builtins.property
    @pulumi.getter
    def tls13(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable TLS1.3. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls13")

    @tls13.setter
    def tls13(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls13", value)


@pulumi.type_token("alicloud:esa/httpsBasicConfiguration:HttpsBasicConfiguration")
class HttpsBasicConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ciphersuite: Optional[pulumi.Input[_builtins.str]] = None,
                 ciphersuite_group: Optional[pulumi.Input[_builtins.str]] = None,
                 http2: Optional[pulumi.Input[_builtins.str]] = None,
                 http3: Optional[pulumi.Input[_builtins.str]] = None,
                 https: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_stapling: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 tls10: Optional[pulumi.Input[_builtins.str]] = None,
                 tls11: Optional[pulumi.Input[_builtins.str]] = None,
                 tls12: Optional[pulumi.Input[_builtins.str]] = None,
                 tls13: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Https Basic Configuration resource.

        For information about ESA Https Basic Configuration and how to use it, see [What is Https Basic Configuration](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateHttpsBasicConfiguration).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.esa.RatePlanInstance("example",
            type="NS",
            auto_renew=False,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            auto_pay=True,
            plan_name="high")
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        resource_http_basic_configuration_set_example = alicloud.esa.Site("resource_HttpBasicConfiguration_set_example",
            site_name=f"gositecdn-{default['result']}.cn",
            instance_id=example.id,
            coverage="overseas",
            access_type="NS")
        default_https_basic_configuration = alicloud.esa.HttpsBasicConfiguration("default",
            https="on",
            rule="true",
            rule_name="example2",
            site_id=resource_http_basic_configuration_set_example.id,
            rule_enable="on")
        ```

        ## Import

        ESA Https Basic Configuration can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/httpsBasicConfiguration:HttpsBasicConfiguration example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ciphersuite: Custom cipher suite, indicating the specific encryption algorithm selected when CiphersuiteGroup is set to custom.
        :param pulumi.Input[_builtins.str] ciphersuite_group: Cipher suite group. Default is all cipher suites. Possible values:
               - all: All cipher suites.
               - strict: Strong cipher suites.
               - custom: Custom cipher suites.
        :param pulumi.Input[_builtins.str] http2: Indicates whether HTTP2 is enabled. Default is on. Possible values:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] http3: Whether to enable HTTP3, which is enabled by default. The value can be:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] https: Whether to enable HTTPS. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] ocsp_stapling: Indicates whether OCSP is enabled. Default is off. Possible values:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               -  Match all incoming requests: value set to true
               -  Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
               - on: open.
               - off: close.
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: Site ID, which can be obtained by calling the [ListSites](https://next.api.alibabacloud.com/document/ESA/2024-09-10/ListSites) interface.
        :param pulumi.Input[_builtins.str] tls10: Whether to enable TLS1.0. Default is disabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls11: Whether to enable TLS1.1. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls12: Whether to enable TLS1.2. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls13: Whether to enable TLS1.3. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HttpsBasicConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Https Basic Configuration resource.

        For information about ESA Https Basic Configuration and how to use it, see [What is Https Basic Configuration](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateHttpsBasicConfiguration).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.esa.RatePlanInstance("example",
            type="NS",
            auto_renew=False,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            auto_pay=True,
            plan_name="high")
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        resource_http_basic_configuration_set_example = alicloud.esa.Site("resource_HttpBasicConfiguration_set_example",
            site_name=f"gositecdn-{default['result']}.cn",
            instance_id=example.id,
            coverage="overseas",
            access_type="NS")
        default_https_basic_configuration = alicloud.esa.HttpsBasicConfiguration("default",
            https="on",
            rule="true",
            rule_name="example2",
            site_id=resource_http_basic_configuration_set_example.id,
            rule_enable="on")
        ```

        ## Import

        ESA Https Basic Configuration can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/httpsBasicConfiguration:HttpsBasicConfiguration example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param HttpsBasicConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HttpsBasicConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ciphersuite: Optional[pulumi.Input[_builtins.str]] = None,
                 ciphersuite_group: Optional[pulumi.Input[_builtins.str]] = None,
                 http2: Optional[pulumi.Input[_builtins.str]] = None,
                 http3: Optional[pulumi.Input[_builtins.str]] = None,
                 https: Optional[pulumi.Input[_builtins.str]] = None,
                 ocsp_stapling: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 tls10: Optional[pulumi.Input[_builtins.str]] = None,
                 tls11: Optional[pulumi.Input[_builtins.str]] = None,
                 tls12: Optional[pulumi.Input[_builtins.str]] = None,
                 tls13: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HttpsBasicConfigurationArgs.__new__(HttpsBasicConfigurationArgs)

            __props__.__dict__["ciphersuite"] = ciphersuite
            __props__.__dict__["ciphersuite_group"] = ciphersuite_group
            __props__.__dict__["http2"] = http2
            __props__.__dict__["http3"] = http3
            __props__.__dict__["https"] = https
            __props__.__dict__["ocsp_stapling"] = ocsp_stapling
            __props__.__dict__["rule"] = rule
            __props__.__dict__["rule_enable"] = rule_enable
            __props__.__dict__["rule_name"] = rule_name
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["tls10"] = tls10
            __props__.__dict__["tls11"] = tls11
            __props__.__dict__["tls12"] = tls12
            __props__.__dict__["tls13"] = tls13
            __props__.__dict__["config_id"] = None
        super(HttpsBasicConfiguration, __self__).__init__(
            'alicloud:esa/httpsBasicConfiguration:HttpsBasicConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ciphersuite: Optional[pulumi.Input[_builtins.str]] = None,
            ciphersuite_group: Optional[pulumi.Input[_builtins.str]] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            http2: Optional[pulumi.Input[_builtins.str]] = None,
            http3: Optional[pulumi.Input[_builtins.str]] = None,
            https: Optional[pulumi.Input[_builtins.str]] = None,
            ocsp_stapling: Optional[pulumi.Input[_builtins.str]] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            tls10: Optional[pulumi.Input[_builtins.str]] = None,
            tls11: Optional[pulumi.Input[_builtins.str]] = None,
            tls12: Optional[pulumi.Input[_builtins.str]] = None,
            tls13: Optional[pulumi.Input[_builtins.str]] = None) -> 'HttpsBasicConfiguration':
        """
        Get an existing HttpsBasicConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ciphersuite: Custom cipher suite, indicating the specific encryption algorithm selected when CiphersuiteGroup is set to custom.
        :param pulumi.Input[_builtins.str] ciphersuite_group: Cipher suite group. Default is all cipher suites. Possible values:
               - all: All cipher suites.
               - strict: Strong cipher suites.
               - custom: Custom cipher suites.
        :param pulumi.Input[_builtins.int] config_id: ConfigId of the configuration, which can be obtained by calling the [ListHttpsBasicConfigurations](https://www.alibabacloud.com/help/en/doc-detail/2867470.html) interface.
        :param pulumi.Input[_builtins.str] http2: Indicates whether HTTP2 is enabled. Default is on. Possible values:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] http3: Whether to enable HTTP3, which is enabled by default. The value can be:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] https: Whether to enable HTTPS. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] ocsp_stapling: Indicates whether OCSP is enabled. Default is off. Possible values:
               - on: Enabled.
               - off: Disabled.
        :param pulumi.Input[_builtins.str] rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               -  Match all incoming requests: value set to true
               -  Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
               - on: open.
               - off: close.
        :param pulumi.Input[_builtins.str] rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param pulumi.Input[_builtins.int] site_id: Site ID, which can be obtained by calling the [ListSites](https://next.api.alibabacloud.com/document/ESA/2024-09-10/ListSites) interface.
        :param pulumi.Input[_builtins.str] tls10: Whether to enable TLS1.0. Default is disabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls11: Whether to enable TLS1.1. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls12: Whether to enable TLS1.2. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        :param pulumi.Input[_builtins.str] tls13: Whether to enable TLS1.3. Default is enabled. Possible values:
               - on: Enable.
               - off: Disable.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HttpsBasicConfigurationState.__new__(_HttpsBasicConfigurationState)

        __props__.__dict__["ciphersuite"] = ciphersuite
        __props__.__dict__["ciphersuite_group"] = ciphersuite_group
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["http2"] = http2
        __props__.__dict__["http3"] = http3
        __props__.__dict__["https"] = https
        __props__.__dict__["ocsp_stapling"] = ocsp_stapling
        __props__.__dict__["rule"] = rule
        __props__.__dict__["rule_enable"] = rule_enable
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["tls10"] = tls10
        __props__.__dict__["tls11"] = tls11
        __props__.__dict__["tls12"] = tls12
        __props__.__dict__["tls13"] = tls13
        return HttpsBasicConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def ciphersuite(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom cipher suite, indicating the specific encryption algorithm selected when CiphersuiteGroup is set to custom.
        """
        return pulumi.get(self, "ciphersuite")

    @_builtins.property
    @pulumi.getter(name="ciphersuiteGroup")
    def ciphersuite_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cipher suite group. Default is all cipher suites. Possible values:
        - all: All cipher suites.
        - strict: Strong cipher suites.
        - custom: Custom cipher suites.
        """
        return pulumi.get(self, "ciphersuite_group")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        ConfigId of the configuration, which can be obtained by calling the [ListHttpsBasicConfigurations](https://www.alibabacloud.com/help/en/doc-detail/2867470.html) interface.
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter
    def http2(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether HTTP2 is enabled. Default is on. Possible values:
        - on: Enabled.
        - off: Disabled.
        """
        return pulumi.get(self, "http2")

    @_builtins.property
    @pulumi.getter
    def http3(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable HTTP3, which is enabled by default. The value can be:
        - on: Enabled.
        - off: Disabled.
        """
        return pulumi.get(self, "http3")

    @_builtins.property
    @pulumi.getter
    def https(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable HTTPS. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "https")

    @_builtins.property
    @pulumi.getter(name="ocspStapling")
    def ocsp_stapling(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether OCSP is enabled. Default is off. Possible values:
        - on: Enabled.
        - off: Disabled.
        """
        return pulumi.get(self, "ocsp_stapling")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        -  Match all incoming requests: value set to true
        -  Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        - on: open.
        - off: close.
        """
        return pulumi.get(self, "rule_enable")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        Site ID, which can be obtained by calling the [ListSites](https://next.api.alibabacloud.com/document/ESA/2024-09-10/ListSites) interface.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter
    def tls10(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable TLS1.0. Default is disabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls10")

    @_builtins.property
    @pulumi.getter
    def tls11(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable TLS1.1. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls11")

    @_builtins.property
    @pulumi.getter
    def tls12(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable TLS1.2. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls12")

    @_builtins.property
    @pulumi.getter
    def tls13(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable TLS1.3. Default is enabled. Possible values:
        - on: Enable.
        - off: Disable.
        """
        return pulumi.get(self, "tls13")

