# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 default_pools: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]],
                 fallback_pool: pulumi.Input[_builtins.int],
                 load_balancer_name: pulumi.Input[_builtins.str],
                 monitor: pulumi.Input['LoadBalancerMonitorArgs'],
                 site_id: pulumi.Input[_builtins.int],
                 steering_policy: pulumi.Input[_builtins.str],
                 adaptive_routing: Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 random_steering: Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']] = None,
                 region_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_region_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] default_pools: List of default pool IDs.
        :param pulumi.Input[_builtins.int] fallback_pool: The fallback pool ID, to which traffic will be redirected if all other pools are unavailable.
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the load balancer must meet the domain name format verification and be a subdomain name under the site.
        :param pulumi.Input['LoadBalancerMonitorArgs'] monitor: Monitor configuration for health check. See `monitor` below.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] steering_policy: Load balancing policy.
        :param pulumi.Input['LoadBalancerAdaptiveRoutingArgs'] adaptive_routing: Cross-pool origin configuration. See `adaptive_routing` below.
        :param pulumi.Input[_builtins.str] description: The detailed description of the load balancer for easy management and identification.
        :param pulumi.Input[_builtins.bool] enabled: Whether the load balancer is enabled.
        :param pulumi.Input['LoadBalancerRandomSteeringArgs'] random_steering: Weighted round-robin configuration, used to control the traffic distribution weights among different pools. See `random_steering` below.
        :param pulumi.Input[_builtins.str] region_pools: Address pools corresponding to primary regions.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]] rules: Rule configuration list, used to define behavior under specific conditions. See `rules` below.
        :param pulumi.Input[_builtins.str] session_affinity: Session persistence. Valid values:
        :param pulumi.Input[_builtins.str] sub_region_pools: Address pools corresponding to secondary regions. When multiple secondary regions share a set of address pools, the keys can be concatenated with commas.
        :param pulumi.Input[_builtins.int] ttl: TTL value, the time-to-live for DNS records. The default value is 30. The value range is 10-600.
        """
        pulumi.set(__self__, "default_pools", default_pools)
        pulumi.set(__self__, "fallback_pool", fallback_pool)
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        pulumi.set(__self__, "monitor", monitor)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "steering_policy", steering_policy)
        if adaptive_routing is not None:
            pulumi.set(__self__, "adaptive_routing", adaptive_routing)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if random_steering is not None:
            pulumi.set(__self__, "random_steering", random_steering)
        if region_pools is not None:
            pulumi.set(__self__, "region_pools", region_pools)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if sub_region_pools is not None:
            pulumi.set(__self__, "sub_region_pools", sub_region_pools)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="defaultPools")
    def default_pools(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]:
        """
        List of default pool IDs.
        """
        return pulumi.get(self, "default_pools")

    @default_pools.setter
    def default_pools(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(self, "default_pools", value)

    @_builtins.property
    @pulumi.getter(name="fallbackPool")
    def fallback_pool(self) -> pulumi.Input[_builtins.int]:
        """
        The fallback pool ID, to which traffic will be redirected if all other pools are unavailable.
        """
        return pulumi.get(self, "fallback_pool")

    @fallback_pool.setter
    def fallback_pool(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "fallback_pool", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the load balancer must meet the domain name format verification and be a subdomain name under the site.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancer_name", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> pulumi.Input['LoadBalancerMonitorArgs']:
        """
        Monitor configuration for health check. See `monitor` below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: pulumi.Input['LoadBalancerMonitorArgs']):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="steeringPolicy")
    def steering_policy(self) -> pulumi.Input[_builtins.str]:
        """
        Load balancing policy.
        """
        return pulumi.get(self, "steering_policy")

    @steering_policy.setter
    def steering_policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "steering_policy", value)

    @_builtins.property
    @pulumi.getter(name="adaptiveRouting")
    def adaptive_routing(self) -> Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]:
        """
        Cross-pool origin configuration. See `adaptive_routing` below.
        """
        return pulumi.get(self, "adaptive_routing")

    @adaptive_routing.setter
    def adaptive_routing(self, value: Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]):
        pulumi.set(self, "adaptive_routing", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detailed description of the load balancer for easy management and identification.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the load balancer is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="randomSteering")
    def random_steering(self) -> Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']]:
        """
        Weighted round-robin configuration, used to control the traffic distribution weights among different pools. See `random_steering` below.
        """
        return pulumi.get(self, "random_steering")

    @random_steering.setter
    def random_steering(self, value: Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']]):
        pulumi.set(self, "random_steering", value)

    @_builtins.property
    @pulumi.getter(name="regionPools")
    def region_pools(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Address pools corresponding to primary regions.
        """
        return pulumi.get(self, "region_pools")

    @region_pools.setter
    def region_pools(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_pools", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]:
        """
        Rule configuration list, used to define behavior under specific conditions. See `rules` below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Session persistence. Valid values:
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_affinity", value)

    @_builtins.property
    @pulumi.getter(name="subRegionPools")
    def sub_region_pools(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Address pools corresponding to secondary regions. When multiple secondary regions share a set of address pools, the keys can be concatenated with commas.
        """
        return pulumi.get(self, "sub_region_pools")

    @sub_region_pools.setter
    def sub_region_pools(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_region_pools", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TTL value, the time-to-live for DNS records. The default value is 30. The value range is 10-600.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 adaptive_routing: Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']] = None,
                 default_pools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fallback_pool: Optional[pulumi.Input[_builtins.int]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.int]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor: Optional[pulumi.Input['LoadBalancerMonitorArgs']] = None,
                 random_steering: Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']] = None,
                 region_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 steering_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_region_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input['LoadBalancerAdaptiveRoutingArgs'] adaptive_routing: Cross-pool origin configuration. See `adaptive_routing` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] default_pools: List of default pool IDs.
        :param pulumi.Input[_builtins.str] description: The detailed description of the load balancer for easy management and identification.
        :param pulumi.Input[_builtins.bool] enabled: Whether the load balancer is enabled.
        :param pulumi.Input[_builtins.int] fallback_pool: The fallback pool ID, to which traffic will be redirected if all other pools are unavailable.
        :param pulumi.Input[_builtins.int] load_balancer_id: The unique identifier ID of the load balancer.
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the load balancer must meet the domain name format verification and be a subdomain name under the site.
        :param pulumi.Input['LoadBalancerMonitorArgs'] monitor: Monitor configuration for health check. See `monitor` below.
        :param pulumi.Input['LoadBalancerRandomSteeringArgs'] random_steering: Weighted round-robin configuration, used to control the traffic distribution weights among different pools. See `random_steering` below.
        :param pulumi.Input[_builtins.str] region_pools: Address pools corresponding to primary regions.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]] rules: Rule configuration list, used to define behavior under specific conditions. See `rules` below.
        :param pulumi.Input[_builtins.str] session_affinity: Session persistence. Valid values:
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] status: The status of the load balancer.
        :param pulumi.Input[_builtins.str] steering_policy: Load balancing policy.
        :param pulumi.Input[_builtins.str] sub_region_pools: Address pools corresponding to secondary regions. When multiple secondary regions share a set of address pools, the keys can be concatenated with commas.
        :param pulumi.Input[_builtins.int] ttl: TTL value, the time-to-live for DNS records. The default value is 30. The value range is 10-600.
        """
        if adaptive_routing is not None:
            pulumi.set(__self__, "adaptive_routing", adaptive_routing)
        if default_pools is not None:
            pulumi.set(__self__, "default_pools", default_pools)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fallback_pool is not None:
            pulumi.set(__self__, "fallback_pool", fallback_pool)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if random_steering is not None:
            pulumi.set(__self__, "random_steering", random_steering)
        if region_pools is not None:
            pulumi.set(__self__, "region_pools", region_pools)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if steering_policy is not None:
            pulumi.set(__self__, "steering_policy", steering_policy)
        if sub_region_pools is not None:
            pulumi.set(__self__, "sub_region_pools", sub_region_pools)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="adaptiveRouting")
    def adaptive_routing(self) -> Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]:
        """
        Cross-pool origin configuration. See `adaptive_routing` below.
        """
        return pulumi.get(self, "adaptive_routing")

    @adaptive_routing.setter
    def adaptive_routing(self, value: Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]):
        pulumi.set(self, "adaptive_routing", value)

    @_builtins.property
    @pulumi.getter(name="defaultPools")
    def default_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of default pool IDs.
        """
        return pulumi.get(self, "default_pools")

    @default_pools.setter
    def default_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "default_pools", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detailed description of the load balancer for easy management and identification.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the load balancer is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="fallbackPool")
    def fallback_pool(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The fallback pool ID, to which traffic will be redirected if all other pools are unavailable.
        """
        return pulumi.get(self, "fallback_pool")

    @fallback_pool.setter
    def fallback_pool(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fallback_pool", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier ID of the load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the load balancer must meet the domain name format verification and be a subdomain name under the site.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_name", value)

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input['LoadBalancerMonitorArgs']]:
        """
        Monitor configuration for health check. See `monitor` below.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input['LoadBalancerMonitorArgs']]):
        pulumi.set(self, "monitor", value)

    @_builtins.property
    @pulumi.getter(name="randomSteering")
    def random_steering(self) -> Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']]:
        """
        Weighted round-robin configuration, used to control the traffic distribution weights among different pools. See `random_steering` below.
        """
        return pulumi.get(self, "random_steering")

    @random_steering.setter
    def random_steering(self, value: Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']]):
        pulumi.set(self, "random_steering", value)

    @_builtins.property
    @pulumi.getter(name="regionPools")
    def region_pools(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Address pools corresponding to primary regions.
        """
        return pulumi.get(self, "region_pools")

    @region_pools.setter
    def region_pools(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_pools", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]:
        """
        Rule configuration list, used to define behavior under specific conditions. See `rules` below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Session persistence. Valid values:
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_affinity", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the load balancer.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="steeringPolicy")
    def steering_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Load balancing policy.
        """
        return pulumi.get(self, "steering_policy")

    @steering_policy.setter
    def steering_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "steering_policy", value)

    @_builtins.property
    @pulumi.getter(name="subRegionPools")
    def sub_region_pools(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Address pools corresponding to secondary regions. When multiple secondary regions share a set of address pools, the keys can be concatenated with commas.
        """
        return pulumi.get(self, "sub_region_pools")

    @sub_region_pools.setter
    def sub_region_pools(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_region_pools", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TTL value, the time-to-live for DNS records. The default value is 30. The value range is 10-600.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("alicloud:esa/loadBalancer:LoadBalancer")
class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive_routing: Optional[pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']]] = None,
                 default_pools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fallback_pool: Optional[pulumi.Input[_builtins.int]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor: Optional[pulumi.Input[Union['LoadBalancerMonitorArgs', 'LoadBalancerMonitorArgsDict']]] = None,
                 random_steering: Optional[pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']]] = None,
                 region_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 steering_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_region_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Load Balancer resource.

        For information about ESA Load Balancer and how to use it, see [What is Load Balancer](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateLoadBalancer).

        > **NOTE:** Available since v1.262.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        resource_site_origin_pool = alicloud.esa.Site("resource_Site_OriginPool",
            site_name=f"{name}{default_integer['result']}.com",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        resource_origin_pool_load_balancer11 = alicloud.esa.OriginPool("resource_OriginPool_LoadBalancer_1_1",
            origins=[{
                "type": "ip_domain",
                "address": "www.example.com",
                "header": "{\\"Host\\":[\\"www.example.com\\"]}",
                "enabled": True,
                "weight": 30,
                "name": "origin1",
            }],
            site_id=resource_site_origin_pool.id,
            origin_pool_name="originpool1",
            enabled=True)
        default_load_balancer = alicloud.esa.LoadBalancer("default",
            load_balancer_name="lb.exampleloadbalancer.top",
            fallback_pool=resource_origin_pool_load_balancer11.origin_pool_id,
            site_id=resource_site_origin_pool.id,
            description=name,
            default_pools=[resource_origin_pool_load_balancer11.origin_pool_id],
            steering_policy="geo",
            monitor={
                "type": "ICMP Ping",
                "timeout": 5,
                "monitoring_region": "ChineseMainland",
                "consecutive_up": 3,
                "consecutive_down": 5,
                "interval": 60,
            })
        ```

        ## Import

        ESA Load Balancer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/loadBalancer:LoadBalancer example <site_id>:<load_balancer_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']] adaptive_routing: Cross-pool origin configuration. See `adaptive_routing` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] default_pools: List of default pool IDs.
        :param pulumi.Input[_builtins.str] description: The detailed description of the load balancer for easy management and identification.
        :param pulumi.Input[_builtins.bool] enabled: Whether the load balancer is enabled.
        :param pulumi.Input[_builtins.int] fallback_pool: The fallback pool ID, to which traffic will be redirected if all other pools are unavailable.
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the load balancer must meet the domain name format verification and be a subdomain name under the site.
        :param pulumi.Input[Union['LoadBalancerMonitorArgs', 'LoadBalancerMonitorArgsDict']] monitor: Monitor configuration for health check. See `monitor` below.
        :param pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']] random_steering: Weighted round-robin configuration, used to control the traffic distribution weights among different pools. See `random_steering` below.
        :param pulumi.Input[_builtins.str] region_pools: Address pools corresponding to primary regions.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]] rules: Rule configuration list, used to define behavior under specific conditions. See `rules` below.
        :param pulumi.Input[_builtins.str] session_affinity: Session persistence. Valid values:
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] steering_policy: Load balancing policy.
        :param pulumi.Input[_builtins.str] sub_region_pools: Address pools corresponding to secondary regions. When multiple secondary regions share a set of address pools, the keys can be concatenated with commas.
        :param pulumi.Input[_builtins.int] ttl: TTL value, the time-to-live for DNS records. The default value is 30. The value range is 10-600.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Load Balancer resource.

        For information about ESA Load Balancer and how to use it, see [What is Load Balancer](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateLoadBalancer).

        > **NOTE:** Available since v1.262.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        resource_site_origin_pool = alicloud.esa.Site("resource_Site_OriginPool",
            site_name=f"{name}{default_integer['result']}.com",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        resource_origin_pool_load_balancer11 = alicloud.esa.OriginPool("resource_OriginPool_LoadBalancer_1_1",
            origins=[{
                "type": "ip_domain",
                "address": "www.example.com",
                "header": "{\\"Host\\":[\\"www.example.com\\"]}",
                "enabled": True,
                "weight": 30,
                "name": "origin1",
            }],
            site_id=resource_site_origin_pool.id,
            origin_pool_name="originpool1",
            enabled=True)
        default_load_balancer = alicloud.esa.LoadBalancer("default",
            load_balancer_name="lb.exampleloadbalancer.top",
            fallback_pool=resource_origin_pool_load_balancer11.origin_pool_id,
            site_id=resource_site_origin_pool.id,
            description=name,
            default_pools=[resource_origin_pool_load_balancer11.origin_pool_id],
            steering_policy="geo",
            monitor={
                "type": "ICMP Ping",
                "timeout": 5,
                "monitoring_region": "ChineseMainland",
                "consecutive_up": 3,
                "consecutive_down": 5,
                "interval": 60,
            })
        ```

        ## Import

        ESA Load Balancer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/loadBalancer:LoadBalancer example <site_id>:<load_balancer_id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive_routing: Optional[pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']]] = None,
                 default_pools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fallback_pool: Optional[pulumi.Input[_builtins.int]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 monitor: Optional[pulumi.Input[Union['LoadBalancerMonitorArgs', 'LoadBalancerMonitorArgsDict']]] = None,
                 random_steering: Optional[pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']]] = None,
                 region_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 steering_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_region_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["adaptive_routing"] = adaptive_routing
            if default_pools is None and not opts.urn:
                raise TypeError("Missing required property 'default_pools'")
            __props__.__dict__["default_pools"] = default_pools
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            if fallback_pool is None and not opts.urn:
                raise TypeError("Missing required property 'fallback_pool'")
            __props__.__dict__["fallback_pool"] = fallback_pool
            if load_balancer_name is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_name'")
            __props__.__dict__["load_balancer_name"] = load_balancer_name
            if monitor is None and not opts.urn:
                raise TypeError("Missing required property 'monitor'")
            __props__.__dict__["monitor"] = monitor
            __props__.__dict__["random_steering"] = random_steering
            __props__.__dict__["region_pools"] = region_pools
            __props__.__dict__["rules"] = rules
            __props__.__dict__["session_affinity"] = session_affinity
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            if steering_policy is None and not opts.urn:
                raise TypeError("Missing required property 'steering_policy'")
            __props__.__dict__["steering_policy"] = steering_policy
            __props__.__dict__["sub_region_pools"] = sub_region_pools
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["load_balancer_id"] = None
            __props__.__dict__["status"] = None
        super(LoadBalancer, __self__).__init__(
            'alicloud:esa/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adaptive_routing: Optional[pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']]] = None,
            default_pools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            fallback_pool: Optional[pulumi.Input[_builtins.int]] = None,
            load_balancer_id: Optional[pulumi.Input[_builtins.int]] = None,
            load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
            monitor: Optional[pulumi.Input[Union['LoadBalancerMonitorArgs', 'LoadBalancerMonitorArgsDict']]] = None,
            random_steering: Optional[pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']]] = None,
            region_pools: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]]] = None,
            session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            steering_policy: Optional[pulumi.Input[_builtins.str]] = None,
            sub_region_pools: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']] adaptive_routing: Cross-pool origin configuration. See `adaptive_routing` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] default_pools: List of default pool IDs.
        :param pulumi.Input[_builtins.str] description: The detailed description of the load balancer for easy management and identification.
        :param pulumi.Input[_builtins.bool] enabled: Whether the load balancer is enabled.
        :param pulumi.Input[_builtins.int] fallback_pool: The fallback pool ID, to which traffic will be redirected if all other pools are unavailable.
        :param pulumi.Input[_builtins.int] load_balancer_id: The unique identifier ID of the load balancer.
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the load balancer must meet the domain name format verification and be a subdomain name under the site.
        :param pulumi.Input[Union['LoadBalancerMonitorArgs', 'LoadBalancerMonitorArgsDict']] monitor: Monitor configuration for health check. See `monitor` below.
        :param pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']] random_steering: Weighted round-robin configuration, used to control the traffic distribution weights among different pools. See `random_steering` below.
        :param pulumi.Input[_builtins.str] region_pools: Address pools corresponding to primary regions.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]] rules: Rule configuration list, used to define behavior under specific conditions. See `rules` below.
        :param pulumi.Input[_builtins.str] session_affinity: Session persistence. Valid values:
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] status: The status of the load balancer.
        :param pulumi.Input[_builtins.str] steering_policy: Load balancing policy.
        :param pulumi.Input[_builtins.str] sub_region_pools: Address pools corresponding to secondary regions. When multiple secondary regions share a set of address pools, the keys can be concatenated with commas.
        :param pulumi.Input[_builtins.int] ttl: TTL value, the time-to-live for DNS records. The default value is 30. The value range is 10-600.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["adaptive_routing"] = adaptive_routing
        __props__.__dict__["default_pools"] = default_pools
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fallback_pool"] = fallback_pool
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["load_balancer_name"] = load_balancer_name
        __props__.__dict__["monitor"] = monitor
        __props__.__dict__["random_steering"] = random_steering
        __props__.__dict__["region_pools"] = region_pools
        __props__.__dict__["rules"] = rules
        __props__.__dict__["session_affinity"] = session_affinity
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["status"] = status
        __props__.__dict__["steering_policy"] = steering_policy
        __props__.__dict__["sub_region_pools"] = sub_region_pools
        __props__.__dict__["ttl"] = ttl
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adaptiveRouting")
    def adaptive_routing(self) -> pulumi.Output['outputs.LoadBalancerAdaptiveRouting']:
        """
        Cross-pool origin configuration. See `adaptive_routing` below.
        """
        return pulumi.get(self, "adaptive_routing")

    @_builtins.property
    @pulumi.getter(name="defaultPools")
    def default_pools(self) -> pulumi.Output[Sequence[_builtins.int]]:
        """
        List of default pool IDs.
        """
        return pulumi.get(self, "default_pools")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The detailed description of the load balancer for easy management and identification.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the load balancer is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="fallbackPool")
    def fallback_pool(self) -> pulumi.Output[_builtins.int]:
        """
        The fallback pool ID, to which traffic will be redirected if all other pools are unavailable.
        """
        return pulumi.get(self, "fallback_pool")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier ID of the load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the load balancer must meet the domain name format verification and be a subdomain name under the site.
        """
        return pulumi.get(self, "load_balancer_name")

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> pulumi.Output['outputs.LoadBalancerMonitor']:
        """
        Monitor configuration for health check. See `monitor` below.
        """
        return pulumi.get(self, "monitor")

    @_builtins.property
    @pulumi.getter(name="randomSteering")
    def random_steering(self) -> pulumi.Output[Optional['outputs.LoadBalancerRandomSteering']]:
        """
        Weighted round-robin configuration, used to control the traffic distribution weights among different pools. See `random_steering` below.
        """
        return pulumi.get(self, "random_steering")

    @_builtins.property
    @pulumi.getter(name="regionPools")
    def region_pools(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Address pools corresponding to primary regions.
        """
        return pulumi.get(self, "region_pools")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerRule']]]:
        """
        Rule configuration list, used to define behavior under specific conditions. See `rules` below.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Session persistence. Valid values:
        """
        return pulumi.get(self, "session_affinity")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the load balancer.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="steeringPolicy")
    def steering_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Load balancing policy.
        """
        return pulumi.get(self, "steering_policy")

    @_builtins.property
    @pulumi.getter(name="subRegionPools")
    def sub_region_pools(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Address pools corresponding to secondary regions. When multiple secondary regions share a set of address pools, the keys can be concatenated with commas.
        """
        return pulumi.get(self, "sub_region_pools")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.int]:
        """
        TTL value, the time-to-live for DNS records. The default value is 30. The value range is 10-600.
        """
        return pulumi.get(self, "ttl")

