# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkOptimizationArgs', 'NetworkOptimization']

@pulumi.input_type
class NetworkOptimizationArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[_builtins.int],
                 grpc: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 smart_routing: Optional[pulumi.Input[_builtins.str]] = None,
                 upload_max_filesize: Optional[pulumi.Input[_builtins.str]] = None,
                 websocket: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkOptimization resource.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        :param pulumi.Input[_builtins.str] grpc: Whether to enable GRPC, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] http2_origin: Whether to enable HTTP2 origin, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content.
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. Values:
        :param pulumi.Input[_builtins.str] rule_name: Rule name.
        :param pulumi.Input[_builtins.int] site_version: Site version number.
        :param pulumi.Input[_builtins.str] smart_routing: Whether to enable smart routing service, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] upload_max_filesize: Maximum upload file size, in MB, value range: 100～500.
        :param pulumi.Input[_builtins.str] websocket: Whether to enable Websocket, default is enabled. Value range:
        """
        pulumi.set(__self__, "site_id", site_id)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http2_origin is not None:
            pulumi.set(__self__, "http2_origin", http2_origin)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if smart_routing is not None:
            pulumi.set(__self__, "smart_routing", smart_routing)
        if upload_max_filesize is not None:
            pulumi.set(__self__, "upload_max_filesize", upload_max_filesize)
        if websocket is not None:
            pulumi.set(__self__, "websocket", websocket)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def grpc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable GRPC, default is disabled. Value range:
        """
        return pulumi.get(self, "grpc")

    @grpc.setter
    def grpc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grpc", value)

    @_builtins.property
    @pulumi.getter(name="http2Origin")
    def http2_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable HTTP2 origin, default is disabled. Value range:
        """
        return pulumi.get(self, "http2_origin")

    @http2_origin.setter
    def http2_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http2_origin", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. Values:
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Site version number.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter(name="smartRouting")
    def smart_routing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable smart routing service, default is disabled. Value range:
        """
        return pulumi.get(self, "smart_routing")

    @smart_routing.setter
    def smart_routing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "smart_routing", value)

    @_builtins.property
    @pulumi.getter(name="uploadMaxFilesize")
    def upload_max_filesize(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum upload file size, in MB, value range: 100～500.
        """
        return pulumi.get(self, "upload_max_filesize")

    @upload_max_filesize.setter
    def upload_max_filesize(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upload_max_filesize", value)

    @_builtins.property
    @pulumi.getter
    def websocket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable Websocket, default is enabled. Value range:
        """
        return pulumi.get(self, "websocket")

    @websocket.setter
    def websocket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "websocket", value)


@pulumi.input_type
class _NetworkOptimizationState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 grpc: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 smart_routing: Optional[pulumi.Input[_builtins.str]] = None,
                 upload_max_filesize: Optional[pulumi.Input[_builtins.str]] = None,
                 websocket: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkOptimization resources.
        :param pulumi.Input[_builtins.int] config_id: ConfigId of the configuration, which can be obtained by calling the ListNetworkOptimizations.
        :param pulumi.Input[_builtins.str] grpc: Whether to enable GRPC, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] http2_origin: Whether to enable HTTP2 origin, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content.
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. Values:
        :param pulumi.Input[_builtins.str] rule_name: Rule name.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        :param pulumi.Input[_builtins.int] site_version: Site version number.
        :param pulumi.Input[_builtins.str] smart_routing: Whether to enable smart routing service, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] upload_max_filesize: Maximum upload file size, in MB, value range: 100～500.
        :param pulumi.Input[_builtins.str] websocket: Whether to enable Websocket, default is enabled. Value range:
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http2_origin is not None:
            pulumi.set(__self__, "http2_origin", http2_origin)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if smart_routing is not None:
            pulumi.set(__self__, "smart_routing", smart_routing)
        if upload_max_filesize is not None:
            pulumi.set(__self__, "upload_max_filesize", upload_max_filesize)
        if websocket is not None:
            pulumi.set(__self__, "websocket", websocket)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ConfigId of the configuration, which can be obtained by calling the ListNetworkOptimizations.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter
    def grpc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable GRPC, default is disabled. Value range:
        """
        return pulumi.get(self, "grpc")

    @grpc.setter
    def grpc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grpc", value)

    @_builtins.property
    @pulumi.getter(name="http2Origin")
    def http2_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable HTTP2 origin, default is disabled. Value range:
        """
        return pulumi.get(self, "http2_origin")

    @http2_origin.setter
    def http2_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http2_origin", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule content.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule switch. Values:
        """
        return pulumi.get(self, "rule_enable")

    @rule_enable.setter
    def rule_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_enable", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Site version number.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter(name="smartRouting")
    def smart_routing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable smart routing service, default is disabled. Value range:
        """
        return pulumi.get(self, "smart_routing")

    @smart_routing.setter
    def smart_routing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "smart_routing", value)

    @_builtins.property
    @pulumi.getter(name="uploadMaxFilesize")
    def upload_max_filesize(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum upload file size, in MB, value range: 100～500.
        """
        return pulumi.get(self, "upload_max_filesize")

    @upload_max_filesize.setter
    def upload_max_filesize(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upload_max_filesize", value)

    @_builtins.property
    @pulumi.getter
    def websocket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable Websocket, default is enabled. Value range:
        """
        return pulumi.get(self, "websocket")

    @websocket.setter
    def websocket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "websocket", value)


@pulumi.type_token("alicloud:esa/networkOptimization:NetworkOptimization")
class NetworkOptimization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 grpc: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 smart_routing: Optional[pulumi.Input[_builtins.str]] = None,
                 upload_max_filesize: Optional[pulumi.Input[_builtins.str]] = None,
                 websocket: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Network Optimization resource.

        For information about ESA Network Optimization and how to use it, see [What is Network Optimization](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateNetworkOptimization).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_site = alicloud.esa.Site("default",
            site_name=f"gositecdn-{default_integer['result']}.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_network_optimization = alicloud.esa.NetworkOptimization("default",
            site_version=0,
            site_id=default_site.id,
            rule_enable="on",
            websocket="off",
            rule="(http.host eq \\"tf.example.com\\")",
            grpc="off",
            http2_origin="off",
            smart_routing="off",
            upload_max_filesize="100",
            rule_name="network_optimization")
        ```

        ## Import

        ESA Network Optimization can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/networkOptimization:NetworkOptimization example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] grpc: Whether to enable GRPC, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] http2_origin: Whether to enable HTTP2 origin, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content.
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. Values:
        :param pulumi.Input[_builtins.str] rule_name: Rule name.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        :param pulumi.Input[_builtins.int] site_version: Site version number.
        :param pulumi.Input[_builtins.str] smart_routing: Whether to enable smart routing service, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] upload_max_filesize: Maximum upload file size, in MB, value range: 100～500.
        :param pulumi.Input[_builtins.str] websocket: Whether to enable Websocket, default is enabled. Value range:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkOptimizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Network Optimization resource.

        For information about ESA Network Optimization and how to use it, see [What is Network Optimization](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateNetworkOptimization).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_site = alicloud.esa.Site("default",
            site_name=f"gositecdn-{default_integer['result']}.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_network_optimization = alicloud.esa.NetworkOptimization("default",
            site_version=0,
            site_id=default_site.id,
            rule_enable="on",
            websocket="off",
            rule="(http.host eq \\"tf.example.com\\")",
            grpc="off",
            http2_origin="off",
            smart_routing="off",
            upload_max_filesize="100",
            rule_name="network_optimization")
        ```

        ## Import

        ESA Network Optimization can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/networkOptimization:NetworkOptimization example <site_id>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param NetworkOptimizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkOptimizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 grpc: Optional[pulumi.Input[_builtins.str]] = None,
                 http2_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 smart_routing: Optional[pulumi.Input[_builtins.str]] = None,
                 upload_max_filesize: Optional[pulumi.Input[_builtins.str]] = None,
                 websocket: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkOptimizationArgs.__new__(NetworkOptimizationArgs)

            __props__.__dict__["grpc"] = grpc
            __props__.__dict__["http2_origin"] = http2_origin
            __props__.__dict__["rule"] = rule
            __props__.__dict__["rule_enable"] = rule_enable
            __props__.__dict__["rule_name"] = rule_name
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["site_version"] = site_version
            __props__.__dict__["smart_routing"] = smart_routing
            __props__.__dict__["upload_max_filesize"] = upload_max_filesize
            __props__.__dict__["websocket"] = websocket
            __props__.__dict__["config_id"] = None
        super(NetworkOptimization, __self__).__init__(
            'alicloud:esa/networkOptimization:NetworkOptimization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            grpc: Optional[pulumi.Input[_builtins.str]] = None,
            http2_origin: Optional[pulumi.Input[_builtins.str]] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            rule_enable: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            site_version: Optional[pulumi.Input[_builtins.int]] = None,
            smart_routing: Optional[pulumi.Input[_builtins.str]] = None,
            upload_max_filesize: Optional[pulumi.Input[_builtins.str]] = None,
            websocket: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkOptimization':
        """
        Get an existing NetworkOptimization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: ConfigId of the configuration, which can be obtained by calling the ListNetworkOptimizations.
        :param pulumi.Input[_builtins.str] grpc: Whether to enable GRPC, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] http2_origin: Whether to enable HTTP2 origin, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] rule: Rule content.
        :param pulumi.Input[_builtins.str] rule_enable: Rule switch. Values:
        :param pulumi.Input[_builtins.str] rule_name: Rule name.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        :param pulumi.Input[_builtins.int] site_version: Site version number.
        :param pulumi.Input[_builtins.str] smart_routing: Whether to enable smart routing service, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] upload_max_filesize: Maximum upload file size, in MB, value range: 100～500.
        :param pulumi.Input[_builtins.str] websocket: Whether to enable Websocket, default is enabled. Value range:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkOptimizationState.__new__(_NetworkOptimizationState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["grpc"] = grpc
        __props__.__dict__["http2_origin"] = http2_origin
        __props__.__dict__["rule"] = rule
        __props__.__dict__["rule_enable"] = rule_enable
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_version"] = site_version
        __props__.__dict__["smart_routing"] = smart_routing
        __props__.__dict__["upload_max_filesize"] = upload_max_filesize
        __props__.__dict__["websocket"] = websocket
        return NetworkOptimization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        ConfigId of the configuration, which can be obtained by calling the ListNetworkOptimizations.
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter
    def grpc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable GRPC, default is disabled. Value range:
        """
        return pulumi.get(self, "grpc")

    @_builtins.property
    @pulumi.getter(name="http2Origin")
    def http2_origin(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable HTTP2 origin, default is disabled. Value range:
        """
        return pulumi.get(self, "http2_origin")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule content.
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule switch. Values:
        """
        return pulumi.get(self, "rule_enable")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rule name.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Site version number.
        """
        return pulumi.get(self, "site_version")

    @_builtins.property
    @pulumi.getter(name="smartRouting")
    def smart_routing(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable smart routing service, default is disabled. Value range:
        """
        return pulumi.get(self, "smart_routing")

    @_builtins.property
    @pulumi.getter(name="uploadMaxFilesize")
    def upload_max_filesize(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Maximum upload file size, in MB, value range: 100～500.
        """
        return pulumi.get(self, "upload_max_filesize")

    @_builtins.property
    @pulumi.getter
    def websocket(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable Websocket, default is enabled. Value range:
        """
        return pulumi.get(self, "websocket")

