# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'HttpRequestHeaderModificationRuleRequestHeaderModification',
    'HttpResponseHeaderModificationRuleResponseHeaderModification',
    'LoadBalancerAdaptiveRouting',
    'LoadBalancerMonitor',
    'LoadBalancerRandomSteering',
    'LoadBalancerRule',
    'LoadBalancerRuleFixedResponse',
    'OriginPoolOrigin',
    'OriginPoolOriginAuthConf',
    'RecordAuthConf',
    'RecordData',
    'SiteDeliveryTaskHttpDelivery',
    'SiteDeliveryTaskHttpDeliveryStandardAuthParam',
    'SiteDeliveryTaskKafkaDelivery',
    'SiteDeliveryTaskOssDelivery',
    'SiteDeliveryTaskS3Delivery',
    'SiteDeliveryTaskSlsDelivery',
    'TransportLayerApplicationRule',
    'WafRuleConfig',
    'WafRuleConfigActions',
    'WafRuleConfigActionsBypass',
    'WafRuleConfigActionsResponse',
    'WafRuleConfigAppPackage',
    'WafRuleConfigAppPackagePackageSign',
    'WafRuleConfigAppSdk',
    'WafRuleConfigAppSdkCustomSign',
    'WafRuleConfigManagedRuleset',
    'WafRuleConfigManagedRulesetManagedRule',
    'WafRuleConfigRateLimit',
    'WafRuleConfigRateLimitCharacteristics',
    'WafRuleConfigRateLimitCharacteristicsCriteria',
    'WafRuleConfigRateLimitCharacteristicsCriteriaCriteria',
    'WafRuleConfigRateLimitCharacteristicsCriteriaCriteriaCriteria',
    'WafRuleConfigRateLimitThreshold',
    'WafRuleConfigRateLimitThresholdResponseStatus',
    'WafRuleConfigSecurityLevel',
    'WafRuleConfigTimer',
    'WafRuleConfigTimerPeriod',
    'WafRuleConfigTimerWeeklyPeriod',
    'WafRuleConfigTimerWeeklyPeriodDailyPeriod',
    'WafRuleShared',
    'WafRuleSharedActions',
    'WafRuleSharedActionsResponse',
    'WafRuleSharedMatch',
    'WafRuleSharedMatchCriteria',
    'WafRuleSharedMatchCriteriaCriteria',
    'WafRuleSharedMatchCriteriaCriteriaCriteria',
    'WaitingRoomHostNameAndPath',
    'GetSitesSiteResult',
]

@pulumi.output_type
class HttpRequestHeaderModificationRuleRequestHeaderModification(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operation: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Request Header Name.
        :param _builtins.str operation: Mode of operation. Value range:
        :param _builtins.str value: Request header value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operation", operation)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Request Header Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        Mode of operation. Value range:
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Request header value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HttpResponseHeaderModificationRuleResponseHeaderModification(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operation: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The response header name.
        :param _builtins.str operation: Operation method. Possible values:
        :param _builtins.str value: The response header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operation", operation)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The response header name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        Operation method. Possible values:
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The response header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadBalancerAdaptiveRouting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverAcrossPools":
            suggest = "failover_across_pools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerAdaptiveRouting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerAdaptiveRouting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerAdaptiveRouting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_across_pools: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool failover_across_pools: Whether to failover across pools.
        """
        if failover_across_pools is not None:
            pulumi.set(__self__, "failover_across_pools", failover_across_pools)

    @_builtins.property
    @pulumi.getter(name="failoverAcrossPools")
    def failover_across_pools(self) -> Optional[_builtins.bool]:
        """
        Whether to failover across pools.
        """
        return pulumi.get(self, "failover_across_pools")


@pulumi.output_type
class LoadBalancerMonitor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consecutiveDown":
            suggest = "consecutive_down"
        elif key == "consecutiveUp":
            suggest = "consecutive_up"
        elif key == "expectedCodes":
            suggest = "expected_codes"
        elif key == "followRedirects":
            suggest = "follow_redirects"
        elif key == "monitoringRegion":
            suggest = "monitoring_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerMonitor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerMonitor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerMonitor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consecutive_down: Optional[_builtins.int] = None,
                 consecutive_up: Optional[_builtins.int] = None,
                 expected_codes: Optional[_builtins.str] = None,
                 follow_redirects: Optional[_builtins.bool] = None,
                 header: Optional[_builtins.str] = None,
                 interval: Optional[_builtins.int] = None,
                 method: Optional[_builtins.str] = None,
                 monitoring_region: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 timeout: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int consecutive_down: The number of consecutive failed health checks before the backend is considered down, for example, 5.
        :param _builtins.int consecutive_up: The number of consecutive successful probes required to consider the target as up, e.g., 3.
        :param _builtins.str expected_codes: Expected status code, such as 200,202, successful HTTP response.
        :param _builtins.bool follow_redirects: Whether to follow the redirect.
        :param _builtins.str header: The HTTP headers to be included in the health check request.
        :param _builtins.int interval: The monitoring interval, such as 60 seconds, checks the frequency.
        :param _builtins.str method: Monitor request methods, such as GET, methods in the HTTP protocol.
        :param _builtins.str monitoring_region: Probe Point Region, default to Global
               - `Global`: Global.
               - `ChineseMainland`: Chinese mainland.
               - `OutsideChineseMainland`: Global (excluding the Chinese mainland).
        :param _builtins.str path: The monitor checks the path, such as/healthcheck, the HTTP request path.
        :param _builtins.int port: The target port.
        :param _builtins.int timeout: The timeout for the health check, in seconds. The value range is 1-10.
        :param _builtins.str type: The type of monitor protocol, such as HTTP, used for health checks. When the value is off, it indicates that no check is performed.
        """
        if consecutive_down is not None:
            pulumi.set(__self__, "consecutive_down", consecutive_down)
        if consecutive_up is not None:
            pulumi.set(__self__, "consecutive_up", consecutive_up)
        if expected_codes is not None:
            pulumi.set(__self__, "expected_codes", expected_codes)
        if follow_redirects is not None:
            pulumi.set(__self__, "follow_redirects", follow_redirects)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if monitoring_region is not None:
            pulumi.set(__self__, "monitoring_region", monitoring_region)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="consecutiveDown")
    def consecutive_down(self) -> Optional[_builtins.int]:
        """
        The number of consecutive failed health checks before the backend is considered down, for example, 5.
        """
        return pulumi.get(self, "consecutive_down")

    @_builtins.property
    @pulumi.getter(name="consecutiveUp")
    def consecutive_up(self) -> Optional[_builtins.int]:
        """
        The number of consecutive successful probes required to consider the target as up, e.g., 3.
        """
        return pulumi.get(self, "consecutive_up")

    @_builtins.property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> Optional[_builtins.str]:
        """
        Expected status code, such as 200,202, successful HTTP response.
        """
        return pulumi.get(self, "expected_codes")

    @_builtins.property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> Optional[_builtins.bool]:
        """
        Whether to follow the redirect.
        """
        return pulumi.get(self, "follow_redirects")

    @_builtins.property
    @pulumi.getter
    def header(self) -> Optional[_builtins.str]:
        """
        The HTTP headers to be included in the health check request.
        """
        return pulumi.get(self, "header")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        The monitoring interval, such as 60 seconds, checks the frequency.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        Monitor request methods, such as GET, methods in the HTTP protocol.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="monitoringRegion")
    def monitoring_region(self) -> Optional[_builtins.str]:
        """
        Probe Point Region, default to Global
        - `Global`: Global.
        - `ChineseMainland`: Chinese mainland.
        - `OutsideChineseMainland`: Global (excluding the Chinese mainland).
        """
        return pulumi.get(self, "monitoring_region")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The monitor checks the path, such as/healthcheck, the HTTP request path.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The target port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        The timeout for the health check, in seconds. The value range is 1-10.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of monitor protocol, such as HTTP, used for health checks. When the value is off, it indicates that no check is performed.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LoadBalancerRandomSteering(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultWeight":
            suggest = "default_weight"
        elif key == "poolWeights":
            suggest = "pool_weights"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerRandomSteering. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerRandomSteering.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerRandomSteering.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_weight: Optional[_builtins.int] = None,
                 pool_weights: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.int default_weight: The default round-robin weight, used for all pools that do not have individually specified weights. The value range is 0-100.
        :param Mapping[str, _builtins.str] pool_weights: Weight configuration for each backend server pool, where the key is the pool ID and the value is the weight coefficient. The weight coefficient represents the proportion of relative traffic distribution.
        """
        if default_weight is not None:
            pulumi.set(__self__, "default_weight", default_weight)
        if pool_weights is not None:
            pulumi.set(__self__, "pool_weights", pool_weights)

    @_builtins.property
    @pulumi.getter(name="defaultWeight")
    def default_weight(self) -> Optional[_builtins.int]:
        """
        The default round-robin weight, used for all pools that do not have individually specified weights. The value range is 0-100.
        """
        return pulumi.get(self, "default_weight")

    @_builtins.property
    @pulumi.getter(name="poolWeights")
    def pool_weights(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Weight configuration for each backend server pool, where the key is the pool ID and the value is the weight coefficient. The weight coefficient represents the proportion of relative traffic distribution.
        """
        return pulumi.get(self, "pool_weights")


@pulumi.output_type
class LoadBalancerRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedResponse":
            suggest = "fixed_response"
        elif key == "ruleEnable":
            suggest = "rule_enable"
        elif key == "ruleName":
            suggest = "rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_response: Optional['outputs.LoadBalancerRuleFixedResponse'] = None,
                 overrides: Optional[_builtins.str] = None,
                 rule: Optional[_builtins.str] = None,
                 rule_enable: Optional[_builtins.str] = None,
                 rule_name: Optional[_builtins.str] = None,
                 sequence: Optional[_builtins.int] = None,
                 terminates: Optional[_builtins.bool] = None):
        """
        :param 'LoadBalancerRuleFixedResponseArgs' fixed_response: Executes a specified response after matching the rule. See `fixed_response` below.
        :param _builtins.str overrides: Modifies the load balancer configuration for the corresponding request after matching the rule. The fields in this configuration will override the corresponding fields in the load balancer configuration.
        :param _builtins.str rule: Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
               - Match all incoming requests: value set to true
               - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        :param _builtins.str rule_enable: Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
               - on: open.
               - off: close.
        :param _builtins.str rule_name: Rule name. When adding global configuration, this parameter does not need to be set.
        :param _builtins.int sequence: Order of rule execution. The smaller the value, the higher the priority for execution.
        :param _builtins.bool terminates: Whether to terminate the execution of subsequent rules.
        """
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_enable is not None:
            pulumi.set(__self__, "rule_enable", rule_enable)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if sequence is not None:
            pulumi.set(__self__, "sequence", sequence)
        if terminates is not None:
            pulumi.set(__self__, "terminates", terminates)

    @_builtins.property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional['outputs.LoadBalancerRuleFixedResponse']:
        """
        Executes a specified response after matching the rule. See `fixed_response` below.
        """
        return pulumi.get(self, "fixed_response")

    @_builtins.property
    @pulumi.getter
    def overrides(self) -> Optional[_builtins.str]:
        """
        Modifies the load balancer configuration for the corresponding request after matching the rule. The fields in this configuration will override the corresponding fields in the load balancer configuration.
        """
        return pulumi.get(self, "overrides")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[_builtins.str]:
        """
        Rule content, using conditional expressions to match user requests. When adding global configuration, this parameter does not need to be set. There are two usage scenarios:
        - Match all incoming requests: value set to true
        - Match specified request: Set the value to a custom expression, for example: (http.host eq \\"video.example.com\\")
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="ruleEnable")
    def rule_enable(self) -> Optional[_builtins.str]:
        """
        Rule switch. When adding global configuration, this parameter does not need to be set. Value range:
        - on: open.
        - off: close.
        """
        return pulumi.get(self, "rule_enable")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[_builtins.str]:
        """
        Rule name. When adding global configuration, this parameter does not need to be set.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def sequence(self) -> Optional[_builtins.int]:
        """
        Order of rule execution. The smaller the value, the higher the priority for execution.
        """
        return pulumi.get(self, "sequence")

    @_builtins.property
    @pulumi.getter
    def terminates(self) -> Optional[_builtins.bool]:
        """
        Whether to terminate the execution of subsequent rules.
        """
        return pulumi.get(self, "terminates")


@pulumi.output_type
class LoadBalancerRuleFixedResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "messageBody":
            suggest = "message_body"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerRuleFixedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerRuleFixedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerRuleFixedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: Optional[_builtins.str] = None,
                 location: Optional[_builtins.str] = None,
                 message_body: Optional[_builtins.str] = None,
                 status_code: Optional[_builtins.int] = None):
        """
        :param _builtins.str content_type: The Content-Type field in the HTTP Header.
        :param _builtins.str location: The location field in the http return.
        :param _builtins.str message_body: The body value of the response.
        :param _builtins.int status_code: Status Code.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if message_body is not None:
            pulumi.set(__self__, "message_body", message_body)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[_builtins.str]:
        """
        The Content-Type field in the HTTP Header.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        The location field in the http return.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> Optional[_builtins.str]:
        """
        The body value of the response.
        """
        return pulumi.get(self, "message_body")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[_builtins.int]:
        """
        Status Code.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class OriginPoolOrigin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authConf":
            suggest = "auth_conf"
        elif key == "originId":
            suggest = "origin_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginPoolOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginPoolOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginPoolOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 auth_conf: Optional['outputs.OriginPoolOriginAuthConf'] = None,
                 enabled: Optional[_builtins.bool] = None,
                 header: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 origin_id: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str address: Origin Address.
        :param 'OriginPoolOriginAuthConfArgs' auth_conf: The authentication information. When the source Station is an OSS or S3 and other source stations need to be authenticated, the authentication-related configuration information needs to be transmitted. See `auth_conf` below.
        :param _builtins.bool enabled: Whether the source station is enabled:
        :param _builtins.str header: The request header that is sent when returning to the source. Only Host is supported.
        :param _builtins.str name: Origin Name.
        :param _builtins.int origin_id: Origin ID.
        :param _builtins.str type: Source station type:
               ip_domain: ip or domain name type origin station;
               - `OSS`:OSS address source station;
               - `S3`:AWS S3 Source station.
        :param _builtins.int weight: Weight, 0-100.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if auth_conf is not None:
            pulumi.set(__self__, "auth_conf", auth_conf)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin_id is not None:
            pulumi.set(__self__, "origin_id", origin_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        Origin Address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="authConf")
    def auth_conf(self) -> Optional['outputs.OriginPoolOriginAuthConf']:
        """
        The authentication information. When the source Station is an OSS or S3 and other source stations need to be authenticated, the authentication-related configuration information needs to be transmitted. See `auth_conf` below.
        """
        return pulumi.get(self, "auth_conf")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the source station is enabled:
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def header(self) -> Optional[_builtins.str]:
        """
        The request header that is sent when returning to the source. Only Host is supported.
        """
        return pulumi.get(self, "header")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Origin Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="originId")
    def origin_id(self) -> Optional[_builtins.int]:
        """
        Origin ID.
        """
        return pulumi.get(self, "origin_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Source station type:
        ip_domain: ip or domain name type origin station;
        - `OSS`:OSS address source station;
        - `S3`:AWS S3 Source station.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        Weight, 0-100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class OriginPoolOriginAuthConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginPoolOriginAuthConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginPoolOriginAuthConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginPoolOriginAuthConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: Optional[_builtins.str] = None,
                 auth_type: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 secret_key: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key: The AccessKey to be passed when AuthType is set to private_cross_account or private.
        :param _builtins.str auth_type: Authentication type.
        :param _builtins.str region: The Region of the source station to be transmitted when the source station is AWS S3.
        :param _builtins.str secret_key: The SecretKey to be passed when AuthType is set to private_cross_account or private.
        :param _builtins.str version: The signature version to be transmitted when the source station is AWS S3.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[_builtins.str]:
        """
        The AccessKey to be passed when AuthType is set to private_cross_account or private.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Authentication type.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The Region of the source station to be transmitted when the source station is AWS S3.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        """
        The SecretKey to be passed when AuthType is set to private_cross_account or private.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The signature version to be transmitted when the source station is AWS S3.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RecordAuthConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordAuthConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordAuthConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordAuthConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: Optional[_builtins.str] = None,
                 auth_type: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 secret_key: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key: The access key of the account to which the origin server belongs. This parameter is required when the SourceType is OSS, and AuthType is private_same_account, or when the SourceType is S3 and AuthType is private.
        :param _builtins.str auth_type: The authentication type of the origin server. Different origins support different authentication types. The type of origin refers to the SourceType parameter in this operation. If the type of origin is OSS or S3, you must specify the authentication type of the origin. Valid values:
        :param _builtins.str region: The region of the origin. If the origin type is S3, you must specify this value. You can get the region information from the official website of S3.
        :param _builtins.str secret_key: The secret access key of the account to which the origin server belongs. This parameter is required when the SourceType is OSS, and AuthType is private_same_account, or when the SourceType is S3 and AuthType is private.
        :param _builtins.str version: The version of the signature algorithm. This parameter is required when the origin type is S3 and AuthType is private. The following two types are supported:
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[_builtins.str]:
        """
        The access key of the account to which the origin server belongs. This parameter is required when the SourceType is OSS, and AuthType is private_same_account, or when the SourceType is S3 and AuthType is private.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        The authentication type of the origin server. Different origins support different authentication types. The type of origin refers to the SourceType parameter in this operation. If the type of origin is OSS or S3, you must specify the authentication type of the origin. Valid values:
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region of the origin. If the origin type is S3, you must specify this value. You can get the region information from the official website of S3.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        """
        The secret access key of the account to which the origin server belongs. This parameter is required when the SourceType is OSS, and AuthType is private_same_account, or when the SourceType is S3 and AuthType is private.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The version of the signature algorithm. This parameter is required when the origin type is S3 and AuthType is private. The following two types are supported:
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RecordData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyTag":
            suggest = "key_tag"
        elif key == "matchingType":
            suggest = "matching_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[_builtins.int] = None,
                 certificate: Optional[_builtins.str] = None,
                 fingerprint: Optional[_builtins.str] = None,
                 flag: Optional[_builtins.int] = None,
                 key_tag: Optional[_builtins.int] = None,
                 matching_type: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None,
                 priority: Optional[_builtins.int] = None,
                 selector: Optional[_builtins.int] = None,
                 tag: Optional[_builtins.str] = None,
                 type: Optional[_builtins.int] = None,
                 usage: Optional[_builtins.int] = None,
                 value: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.int algorithm: The encryption algorithm used for the record, specified within the range from 0 to 255. This parameter is required when you add CERT or SSHFP records.
        :param _builtins.str certificate: The public key of the certificate. This parameter is required when you add CERT, SMIMEA, or TLSA records.
        :param _builtins.str fingerprint: The public key fingerprint of the record. This parameter is required when you add a SSHFP record.
        :param _builtins.int flag: The flag bit of the record. The Flag for a CAA record indicates its priority and how it is processed, specified within the range of 0 to 255. This parameter is required when you add a CAA record.
        :param _builtins.int key_tag: The public key identification for the record, specified within the range of 0 to 65,535. This parameter is required when you add a CAA record.
        :param _builtins.int matching_type: The algorithm policy used to match or validate the certificate, specified within the range 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        :param _builtins.int port: The port of the record, specified within the range of 0 to 65,535. This parameter is required when you add an SRV record.
        :param _builtins.int priority: The priority of the record, specified within the range of 0 to 65,535. A smaller value indicates a higher priority. This parameter is required when you add MX, SRV, and URI records.
        :param _builtins.int selector: The type of certificate or public key, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        :param _builtins.str tag: The label of the record. The Tag of a CAA record indicate its specific type and usage. This parameter is required when you add a CAA record.
        :param _builtins.int type: The certificate type of the record (in CERT records), or the public key type (in SSHFP records). This parameter is required when you add CERT or SSHFP records.
        :param _builtins.int usage: The usage identifier of the record, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        :param _builtins.str value: The record value or part of the record content. This parameter is required when you add A/AAAA, CNAME, NS, MX, TXT, CAA, SRV, and URI records. It has different meanings based on different types of records:
               
               - **A/AAAA**: the IP address(es). Separate multiple IPs with commas (,). You must have at least one IPv4 address.
               - `CNAME`: the target domain name.
               - `NS`: the name servers for the domain name.
               - `MX`: a valid domain name of the target mail server.
               - `TXT`: a valid text string.
               - `CAA`: a valid domain name of the certificate authority.
               - `SRV`: a valid domain name of the target host.
               - `URI`: a valid URI string.
        :param _builtins.int weight: The weight of the record, specified within the range of 0 to 65,535. This parameter is required when you add SRV or URI records.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if flag is not None:
            pulumi.set(__self__, "flag", flag)
        if key_tag is not None:
            pulumi.set(__self__, "key_tag", key_tag)
        if matching_type is not None:
            pulumi.set(__self__, "matching_type", matching_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[_builtins.int]:
        """
        The encryption algorithm used for the record, specified within the range from 0 to 255. This parameter is required when you add CERT or SSHFP records.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[_builtins.str]:
        """
        The public key of the certificate. This parameter is required when you add CERT, SMIMEA, or TLSA records.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[_builtins.str]:
        """
        The public key fingerprint of the record. This parameter is required when you add a SSHFP record.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def flag(self) -> Optional[_builtins.int]:
        """
        The flag bit of the record. The Flag for a CAA record indicates its priority and how it is processed, specified within the range of 0 to 255. This parameter is required when you add a CAA record.
        """
        return pulumi.get(self, "flag")

    @_builtins.property
    @pulumi.getter(name="keyTag")
    def key_tag(self) -> Optional[_builtins.int]:
        """
        The public key identification for the record, specified within the range of 0 to 65,535. This parameter is required when you add a CAA record.
        """
        return pulumi.get(self, "key_tag")

    @_builtins.property
    @pulumi.getter(name="matchingType")
    def matching_type(self) -> Optional[_builtins.int]:
        """
        The algorithm policy used to match or validate the certificate, specified within the range 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        """
        return pulumi.get(self, "matching_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port of the record, specified within the range of 0 to 65,535. This parameter is required when you add an SRV record.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        The priority of the record, specified within the range of 0 to 65,535. A smaller value indicates a higher priority. This parameter is required when you add MX, SRV, and URI records.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional[_builtins.int]:
        """
        The type of certificate or public key, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        The label of the record. The Tag of a CAA record indicate its specific type and usage. This parameter is required when you add a CAA record.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.int]:
        """
        The certificate type of the record (in CERT records), or the public key type (in SSHFP records). This parameter is required when you add CERT or SSHFP records.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[_builtins.int]:
        """
        The usage identifier of the record, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        """
        return pulumi.get(self, "usage")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The record value or part of the record content. This parameter is required when you add A/AAAA, CNAME, NS, MX, TXT, CAA, SRV, and URI records. It has different meanings based on different types of records:

        - **A/AAAA**: the IP address(es). Separate multiple IPs with commas (,). You must have at least one IPv4 address.
        - `CNAME`: the target domain name.
        - `NS`: the name servers for the domain name.
        - `MX`: a valid domain name of the target mail server.
        - `TXT`: a valid text string.
        - `CAA`: a valid domain name of the certificate authority.
        - `SRV`: a valid domain name of the target host.
        - `URI`: a valid URI string.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        The weight of the record, specified within the range of 0 to 65,535. This parameter is required when you add SRV or URI records.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class SiteDeliveryTaskHttpDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destUrl":
            suggest = "dest_url"
        elif key == "headerParam":
            suggest = "header_param"
        elif key == "logBodyPrefix":
            suggest = "log_body_prefix"
        elif key == "logBodySuffix":
            suggest = "log_body_suffix"
        elif key == "maxBatchMb":
            suggest = "max_batch_mb"
        elif key == "maxBatchSize":
            suggest = "max_batch_size"
        elif key == "maxRetry":
            suggest = "max_retry"
        elif key == "queryParam":
            suggest = "query_param"
        elif key == "standardAuthOn":
            suggest = "standard_auth_on"
        elif key == "standardAuthParam":
            suggest = "standard_auth_param"
        elif key == "transformTimeout":
            suggest = "transform_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskHttpDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskHttpDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskHttpDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compress: Optional[_builtins.str] = None,
                 dest_url: Optional[_builtins.str] = None,
                 header_param: Optional[Mapping[str, _builtins.str]] = None,
                 log_body_prefix: Optional[_builtins.str] = None,
                 log_body_suffix: Optional[_builtins.str] = None,
                 max_batch_mb: Optional[_builtins.int] = None,
                 max_batch_size: Optional[_builtins.int] = None,
                 max_retry: Optional[_builtins.int] = None,
                 query_param: Optional[Mapping[str, _builtins.str]] = None,
                 standard_auth_on: Optional[_builtins.bool] = None,
                 standard_auth_param: Optional['outputs.SiteDeliveryTaskHttpDeliveryStandardAuthParam'] = None,
                 transform_timeout: Optional[_builtins.int] = None):
        """
        :param 'SiteDeliveryTaskHttpDeliveryStandardAuthParamArgs' standard_auth_param: See `standard_auth_param` below.
        """
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if dest_url is not None:
            pulumi.set(__self__, "dest_url", dest_url)
        if header_param is not None:
            pulumi.set(__self__, "header_param", header_param)
        if log_body_prefix is not None:
            pulumi.set(__self__, "log_body_prefix", log_body_prefix)
        if log_body_suffix is not None:
            pulumi.set(__self__, "log_body_suffix", log_body_suffix)
        if max_batch_mb is not None:
            pulumi.set(__self__, "max_batch_mb", max_batch_mb)
        if max_batch_size is not None:
            pulumi.set(__self__, "max_batch_size", max_batch_size)
        if max_retry is not None:
            pulumi.set(__self__, "max_retry", max_retry)
        if query_param is not None:
            pulumi.set(__self__, "query_param", query_param)
        if standard_auth_on is not None:
            pulumi.set(__self__, "standard_auth_on", standard_auth_on)
        if standard_auth_param is not None:
            pulumi.set(__self__, "standard_auth_param", standard_auth_param)
        if transform_timeout is not None:
            pulumi.set(__self__, "transform_timeout", transform_timeout)

    @_builtins.property
    @pulumi.getter
    def compress(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compress")

    @_builtins.property
    @pulumi.getter(name="destUrl")
    def dest_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dest_url")

    @_builtins.property
    @pulumi.getter(name="headerParam")
    def header_param(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "header_param")

    @_builtins.property
    @pulumi.getter(name="logBodyPrefix")
    def log_body_prefix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "log_body_prefix")

    @_builtins.property
    @pulumi.getter(name="logBodySuffix")
    def log_body_suffix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "log_body_suffix")

    @_builtins.property
    @pulumi.getter(name="maxBatchMb")
    def max_batch_mb(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_batch_mb")

    @_builtins.property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_batch_size")

    @_builtins.property
    @pulumi.getter(name="maxRetry")
    def max_retry(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_retry")

    @_builtins.property
    @pulumi.getter(name="queryParam")
    def query_param(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "query_param")

    @_builtins.property
    @pulumi.getter(name="standardAuthOn")
    def standard_auth_on(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "standard_auth_on")

    @_builtins.property
    @pulumi.getter(name="standardAuthParam")
    def standard_auth_param(self) -> Optional['outputs.SiteDeliveryTaskHttpDeliveryStandardAuthParam']:
        """
        See `standard_auth_param` below.
        """
        return pulumi.get(self, "standard_auth_param")

    @_builtins.property
    @pulumi.getter(name="transformTimeout")
    def transform_timeout(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "transform_timeout")


@pulumi.output_type
class SiteDeliveryTaskHttpDeliveryStandardAuthParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredTime":
            suggest = "expired_time"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "urlPath":
            suggest = "url_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskHttpDeliveryStandardAuthParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskHttpDeliveryStandardAuthParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskHttpDeliveryStandardAuthParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expired_time: Optional[_builtins.int] = None,
                 private_key: Optional[_builtins.str] = None,
                 url_path: Optional[_builtins.str] = None):
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "url_path")


@pulumi.output_type
class SiteDeliveryTaskKafkaDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machanismType":
            suggest = "machanism_type"
        elif key == "userAuth":
            suggest = "user_auth"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskKafkaDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskKafkaDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskKafkaDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 balancer: Optional[_builtins.str] = None,
                 brokers: Optional[Sequence[_builtins.str]] = None,
                 compress: Optional[_builtins.str] = None,
                 machanism_type: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 topic: Optional[_builtins.str] = None,
                 user_auth: Optional[_builtins.bool] = None,
                 user_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str compress: The compression method. By default, data is not compressed.
        """
        if balancer is not None:
            pulumi.set(__self__, "balancer", balancer)
        if brokers is not None:
            pulumi.set(__self__, "brokers", brokers)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if machanism_type is not None:
            pulumi.set(__self__, "machanism_type", machanism_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)
        if user_auth is not None:
            pulumi.set(__self__, "user_auth", user_auth)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def balancer(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "balancer")

    @_builtins.property
    @pulumi.getter
    def brokers(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "brokers")

    @_builtins.property
    @pulumi.getter
    def compress(self) -> Optional[_builtins.str]:
        """
        The compression method. By default, data is not compressed.
        """
        return pulumi.get(self, "compress")

    @_builtins.property
    @pulumi.getter(name="machanismType")
    def machanism_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "machanism_type")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter(name="userAuth")
    def user_auth(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "user_auth")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class SiteDeliveryTaskOssDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "prefixPath":
            suggest = "prefix_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskOssDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskOssDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskOssDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aliuid: Optional[_builtins.str] = None,
                 bucket_name: Optional[_builtins.str] = None,
                 prefix_path: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str region: The region ID of the service.
        """
        if aliuid is not None:
            pulumi.set(__self__, "aliuid", aliuid)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if prefix_path is not None:
            pulumi.set(__self__, "prefix_path", prefix_path)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def aliuid(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "aliuid")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="prefixPath")
    def prefix_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "prefix_path")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region ID of the service.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class SiteDeliveryTaskS3Delivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketPath":
            suggest = "bucket_path"
        elif key == "prefixPath":
            suggest = "prefix_path"
        elif key == "s3Cmpt":
            suggest = "s3_cmpt"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"
        elif key == "vertifyType":
            suggest = "vertify_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskS3Delivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskS3Delivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskS3Delivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: Optional[_builtins.str] = None,
                 bucket_path: Optional[_builtins.str] = None,
                 endpoint: Optional[_builtins.str] = None,
                 prefix_path: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 s3_cmpt: Optional[_builtins.bool] = None,
                 secret_key: Optional[_builtins.str] = None,
                 server_side_encryption: Optional[_builtins.bool] = None,
                 vertify_type: Optional[_builtins.str] = None):
        """
        :param _builtins.bool server_side_encryption: Server-side encryption
        :param _builtins.str vertify_type: Authentication Type
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if bucket_path is not None:
            pulumi.set(__self__, "bucket_path", bucket_path)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if prefix_path is not None:
            pulumi.set(__self__, "prefix_path", prefix_path)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_cmpt is not None:
            pulumi.set(__self__, "s3_cmpt", s3_cmpt)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if vertify_type is not None:
            pulumi.set(__self__, "vertify_type", vertify_type)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="bucketPath")
    def bucket_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "bucket_path")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="prefixPath")
    def prefix_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "prefix_path")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="s3Cmpt")
    def s3_cmpt(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "s3_cmpt")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[_builtins.bool]:
        """
        Server-side encryption
        """
        return pulumi.get(self, "server_side_encryption")

    @_builtins.property
    @pulumi.getter(name="vertifyType")
    def vertify_type(self) -> Optional[_builtins.str]:
        """
        Authentication Type
        """
        return pulumi.get(self, "vertify_type")


@pulumi.output_type
class SiteDeliveryTaskSlsDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slsLogStore":
            suggest = "sls_log_store"
        elif key == "slsProject":
            suggest = "sls_project"
        elif key == "slsRegion":
            suggest = "sls_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskSlsDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskSlsDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskSlsDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sls_log_store: Optional[_builtins.str] = None,
                 sls_project: Optional[_builtins.str] = None,
                 sls_region: Optional[_builtins.str] = None):
        if sls_log_store is not None:
            pulumi.set(__self__, "sls_log_store", sls_log_store)
        if sls_project is not None:
            pulumi.set(__self__, "sls_project", sls_project)
        if sls_region is not None:
            pulumi.set(__self__, "sls_region", sls_region)

    @_builtins.property
    @pulumi.getter(name="slsLogStore")
    def sls_log_store(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sls_log_store")

    @_builtins.property
    @pulumi.getter(name="slsProject")
    def sls_project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sls_project")

    @_builtins.property
    @pulumi.getter(name="slsRegion")
    def sls_region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sls_region")


@pulumi.output_type
class TransportLayerApplicationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientIpPassThroughMode":
            suggest = "client_ip_pass_through_mode"
        elif key == "edgePort":
            suggest = "edge_port"
        elif key == "sourcePort":
            suggest = "source_port"
        elif key == "sourceType":
            suggest = "source_type"
        elif key == "ruleId":
            suggest = "rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransportLayerApplicationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransportLayerApplicationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransportLayerApplicationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_ip_pass_through_mode: _builtins.str,
                 edge_port: _builtins.str,
                 protocol: _builtins.str,
                 source: _builtins.str,
                 source_port: _builtins.str,
                 source_type: _builtins.str,
                 comment: Optional[_builtins.str] = None,
                 rule_id: Optional[_builtins.int] = None):
        """
        :param _builtins.str client_ip_pass_through_mode: Client IP pass-through protocol, supporting:
        :param _builtins.str edge_port: Edge port. Supports:
               - A single port, such as 80.
               - Port range, such as 81-85, representing ports 81, 82, 83, 84, and 85.
               - Combination of ports and port ranges, separated by commas, such as 80,81-85,90, representing ports 80, 81, 82, 83, 84, 85, and 90.
               
               Edge ports within a single rule and between multiple rules must not overlap.
        :param _builtins.str protocol: Forwarding rule protocol, with values:
               - `TCP`: TCP protocol.
               - `UDP`: UDP protocol.
        :param _builtins.str source: Specific value of the origin, which needs to match the origin type.
        :param _builtins.str source_port: Source Port
        :param _builtins.str source_type: Origin type, supporting:
        :param _builtins.str comment: Comment information for the rule (optional).
        :param _builtins.int rule_id: Rule ID
        """
        pulumi.set(__self__, "client_ip_pass_through_mode", client_ip_pass_through_mode)
        pulumi.set(__self__, "edge_port", edge_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_port", source_port)
        pulumi.set(__self__, "source_type", source_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @_builtins.property
    @pulumi.getter(name="clientIpPassThroughMode")
    def client_ip_pass_through_mode(self) -> _builtins.str:
        """
        Client IP pass-through protocol, supporting:
        """
        return pulumi.get(self, "client_ip_pass_through_mode")

    @_builtins.property
    @pulumi.getter(name="edgePort")
    def edge_port(self) -> _builtins.str:
        """
        Edge port. Supports:
        - A single port, such as 80.
        - Port range, such as 81-85, representing ports 81, 82, 83, 84, and 85.
        - Combination of ports and port ranges, separated by commas, such as 80,81-85,90, representing ports 80, 81, 82, 83, 84, 85, and 90.

        Edge ports within a single rule and between multiple rules must not overlap.
        """
        return pulumi.get(self, "edge_port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Forwarding rule protocol, with values:
        - `TCP`: TCP protocol.
        - `UDP`: UDP protocol.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        Specific value of the origin, which needs to match the origin type.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> _builtins.str:
        """
        Source Port
        """
        return pulumi.get(self, "source_port")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        Origin type, supporting:
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        Comment information for the rule (optional).
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[_builtins.int]:
        """
        Rule ID
        """
        return pulumi.get(self, "rule_id")


@pulumi.output_type
class WafRuleConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appPackage":
            suggest = "app_package"
        elif key == "appSdk":
            suggest = "app_sdk"
        elif key == "managedGroupId":
            suggest = "managed_group_id"
        elif key == "managedList":
            suggest = "managed_list"
        elif key == "managedRulesets":
            suggest = "managed_rulesets"
        elif key == "rateLimit":
            suggest = "rate_limit"
        elif key == "securityLevel":
            suggest = "security_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[_builtins.str] = None,
                 actions: Optional['outputs.WafRuleConfigActions'] = None,
                 app_package: Optional['outputs.WafRuleConfigAppPackage'] = None,
                 app_sdk: Optional['outputs.WafRuleConfigAppSdk'] = None,
                 expression: Optional[_builtins.str] = None,
                 id: Optional[_builtins.int] = None,
                 managed_group_id: Optional[_builtins.int] = None,
                 managed_list: Optional[_builtins.str] = None,
                 managed_rulesets: Optional[Sequence['outputs.WafRuleConfigManagedRuleset']] = None,
                 name: Optional[_builtins.str] = None,
                 notes: Optional[_builtins.str] = None,
                 rate_limit: Optional['outputs.WafRuleConfigRateLimit'] = None,
                 security_level: Optional['outputs.WafRuleConfigSecurityLevel'] = None,
                 sigchls: Optional[Sequence[_builtins.str]] = None,
                 status: Optional[_builtins.str] = None,
                 timer: Optional['outputs.WafRuleConfigTimer'] = None,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: The action performed on requests that match the managed rule.
        :param 'WafRuleConfigActionsArgs' actions: Extended action configurations, including custom responses and bypass settings. See `actions` below.
        :param 'WafRuleConfigAppPackageArgs' app_package: Security mechanism to prevent apps from being repackaged. See `app_package` below.
        :param 'WafRuleConfigAppSdkArgs' app_sdk: Mobile app SDK-related configurations. See `app_sdk` below.
        :param _builtins.str expression: The match expression used to evaluate incoming requests.
        :param _builtins.int id: The ID of the custom error page, which can be obtained by calling the ListPages operation.
        :param _builtins.int managed_group_id: The ID of the managed rule group (deprecated).
        :param _builtins.str managed_list: The name of the managed list applied to this rule.
        :param Sequence['WafRuleConfigManagedRulesetArgs'] managed_rulesets: The managed rulesets referenced by this rule and their configurations. See `managed_rulesets` below.
        :param _builtins.str name: The package name of an authorized application.
        :param _builtins.str notes: Additional notes about this rule.
        :param 'WafRuleConfigRateLimitArgs' rate_limit: Configuration of the rate limiting rule. See `rate_limit` below.
        :param 'WafRuleConfigSecurityLevelArgs' security_level: The overall security protection level of WAF. See `security_level` below.
        :param Sequence[_builtins.str] sigchls: Configuration items for token verification mechanisms.
        :param _builtins.str status: The status of the managed rule: whether it is enabled or disabled.
        :param 'WafRuleConfigTimerArgs' timer: Configuration for the time schedule when the rule takes effect. See `timer` below.
        :param _builtins.str type: The type category of the WAF rule.
        :param _builtins.str value: The value of the custom signature field used for validation.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if app_package is not None:
            pulumi.set(__self__, "app_package", app_package)
        if app_sdk is not None:
            pulumi.set(__self__, "app_sdk", app_sdk)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if managed_group_id is not None:
            pulumi.set(__self__, "managed_group_id", managed_group_id)
        if managed_list is not None:
            pulumi.set(__self__, "managed_list", managed_list)
        if managed_rulesets is not None:
            pulumi.set(__self__, "managed_rulesets", managed_rulesets)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if security_level is not None:
            pulumi.set(__self__, "security_level", security_level)
        if sigchls is not None:
            pulumi.set(__self__, "sigchls", sigchls)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timer is not None:
            pulumi.set(__self__, "timer", timer)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The action performed on requests that match the managed rule.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional['outputs.WafRuleConfigActions']:
        """
        Extended action configurations, including custom responses and bypass settings. See `actions` below.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="appPackage")
    def app_package(self) -> Optional['outputs.WafRuleConfigAppPackage']:
        """
        Security mechanism to prevent apps from being repackaged. See `app_package` below.
        """
        return pulumi.get(self, "app_package")

    @_builtins.property
    @pulumi.getter(name="appSdk")
    def app_sdk(self) -> Optional['outputs.WafRuleConfigAppSdk']:
        """
        Mobile app SDK-related configurations. See `app_sdk` below.
        """
        return pulumi.get(self, "app_sdk")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        The match expression used to evaluate incoming requests.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        The ID of the custom error page, which can be obtained by calling the ListPages operation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedGroupId")
    def managed_group_id(self) -> Optional[_builtins.int]:
        """
        The ID of the managed rule group (deprecated).
        """
        return pulumi.get(self, "managed_group_id")

    @_builtins.property
    @pulumi.getter(name="managedList")
    def managed_list(self) -> Optional[_builtins.str]:
        """
        The name of the managed list applied to this rule.
        """
        return pulumi.get(self, "managed_list")

    @_builtins.property
    @pulumi.getter(name="managedRulesets")
    def managed_rulesets(self) -> Optional[Sequence['outputs.WafRuleConfigManagedRuleset']]:
        """
        The managed rulesets referenced by this rule and their configurations. See `managed_rulesets` below.
        """
        return pulumi.get(self, "managed_rulesets")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The package name of an authorized application.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[_builtins.str]:
        """
        Additional notes about this rule.
        """
        return pulumi.get(self, "notes")

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional['outputs.WafRuleConfigRateLimit']:
        """
        Configuration of the rate limiting rule. See `rate_limit` below.
        """
        return pulumi.get(self, "rate_limit")

    @_builtins.property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> Optional['outputs.WafRuleConfigSecurityLevel']:
        """
        The overall security protection level of WAF. See `security_level` below.
        """
        return pulumi.get(self, "security_level")

    @_builtins.property
    @pulumi.getter
    def sigchls(self) -> Optional[Sequence[_builtins.str]]:
        """
        Configuration items for token verification mechanisms.
        """
        return pulumi.get(self, "sigchls")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the managed rule: whether it is enabled or disabled.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def timer(self) -> Optional['outputs.WafRuleConfigTimer']:
        """
        Configuration for the time schedule when the rule takes effect. See `timer` below.
        """
        return pulumi.get(self, "timer")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type category of the WAF rule.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of the custom signature field used for validation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WafRuleConfigActions(dict):
    def __init__(__self__, *,
                 bypass: Optional['outputs.WafRuleConfigActionsBypass'] = None,
                 response: Optional['outputs.WafRuleConfigActionsResponse'] = None):
        """
        :param 'WafRuleConfigActionsBypassArgs' bypass: The skip configuration specified by the whitelist rule. See `bypass` below.
        """
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @_builtins.property
    @pulumi.getter
    def bypass(self) -> Optional['outputs.WafRuleConfigActionsBypass']:
        """
        The skip configuration specified by the whitelist rule. See `bypass` below.
        """
        return pulumi.get(self, "bypass")

    @_builtins.property
    @pulumi.getter
    def response(self) -> Optional['outputs.WafRuleConfigActionsResponse']:
        return pulumi.get(self, "response")


@pulumi.output_type
class WafRuleConfigActionsBypass(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRules":
            suggest = "custom_rules"
        elif key == "regularRules":
            suggest = "regular_rules"
        elif key == "regularTypes":
            suggest = "regular_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfigActionsBypass. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfigActionsBypass.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfigActionsBypass.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_rules: Optional[Sequence[_builtins.int]] = None,
                 regular_rules: Optional[Sequence[_builtins.int]] = None,
                 regular_types: Optional[Sequence[_builtins.str]] = None,
                 skip: Optional[_builtins.str] = None,
                 tags: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.int] custom_rules: The IDs of custom rules to skip.
        :param Sequence[_builtins.int] regular_rules: The IDs of specific managed rules to skip.
        :param Sequence[_builtins.str] regular_types: The types of managed rules to skip.
        :param _builtins.str skip: The scope that is skipped when requests match conditions defined in the whitelist rule.
        :param Sequence[_builtins.str] tags: The rule categories that are skipped when requests match conditions defined in the whitelist rule.
        """
        if custom_rules is not None:
            pulumi.set(__self__, "custom_rules", custom_rules)
        if regular_rules is not None:
            pulumi.set(__self__, "regular_rules", regular_rules)
        if regular_types is not None:
            pulumi.set(__self__, "regular_types", regular_types)
        if skip is not None:
            pulumi.set(__self__, "skip", skip)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> Optional[Sequence[_builtins.int]]:
        """
        The IDs of custom rules to skip.
        """
        return pulumi.get(self, "custom_rules")

    @_builtins.property
    @pulumi.getter(name="regularRules")
    def regular_rules(self) -> Optional[Sequence[_builtins.int]]:
        """
        The IDs of specific managed rules to skip.
        """
        return pulumi.get(self, "regular_rules")

    @_builtins.property
    @pulumi.getter(name="regularTypes")
    def regular_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        The types of managed rules to skip.
        """
        return pulumi.get(self, "regular_types")

    @_builtins.property
    @pulumi.getter
    def skip(self) -> Optional[_builtins.str]:
        """
        The scope that is skipped when requests match conditions defined in the whitelist rule.
        """
        return pulumi.get(self, "skip")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        The rule categories that are skipped when requests match conditions defined in the whitelist rule.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class WafRuleConfigActionsResponse(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 id: Optional[_builtins.int] = None):
        """
        :param _builtins.int id: The internal unique ID of the WAF rule.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        The internal unique ID of the WAF rule.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class WafRuleConfigAppPackage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "packageSigns":
            suggest = "package_signs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfigAppPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfigAppPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfigAppPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 package_signs: Optional[Sequence['outputs.WafRuleConfigAppPackagePackageSign']] = None):
        """
        :param Sequence['WafRuleConfigAppPackagePackageSignArgs'] package_signs: Security mechanism to prevent apps from being repackaged. See `package_signs` below.
        """
        if package_signs is not None:
            pulumi.set(__self__, "package_signs", package_signs)

    @_builtins.property
    @pulumi.getter(name="packageSigns")
    def package_signs(self) -> Optional[Sequence['outputs.WafRuleConfigAppPackagePackageSign']]:
        """
        Security mechanism to prevent apps from being repackaged. See `package_signs` below.
        """
        return pulumi.get(self, "package_signs")


@pulumi.output_type
class WafRuleConfigAppPackagePackageSign(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 sign: Optional[_builtins.str] = None):
        """
        :param _builtins.str sign: The digital signature of a legitimate app package.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sign is not None:
            pulumi.set(__self__, "sign", sign)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def sign(self) -> Optional[_builtins.str]:
        """
        The digital signature of a legitimate app package.
        """
        return pulumi.get(self, "sign")


@pulumi.output_type
class WafRuleConfigAppSdk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customSign":
            suggest = "custom_sign"
        elif key == "customSignStatus":
            suggest = "custom_sign_status"
        elif key == "featureAbnormals":
            suggest = "feature_abnormals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfigAppSdk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfigAppSdk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfigAppSdk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_sign: Optional['outputs.WafRuleConfigAppSdkCustomSign'] = None,
                 custom_sign_status: Optional[_builtins.str] = None,
                 feature_abnormals: Optional[Sequence[_builtins.str]] = None):
        """
        :param 'WafRuleConfigAppSdkCustomSignArgs' custom_sign: Custom fields used for mobile app signature validation. See `custom_sign` below.
        :param _builtins.str custom_sign_status: Indicates whether the custom signature field validation is enabled.
        :param Sequence[_builtins.str] feature_abnormals: Detected abnormal behaviors of the application.
        """
        if custom_sign is not None:
            pulumi.set(__self__, "custom_sign", custom_sign)
        if custom_sign_status is not None:
            pulumi.set(__self__, "custom_sign_status", custom_sign_status)
        if feature_abnormals is not None:
            pulumi.set(__self__, "feature_abnormals", feature_abnormals)

    @_builtins.property
    @pulumi.getter(name="customSign")
    def custom_sign(self) -> Optional['outputs.WafRuleConfigAppSdkCustomSign']:
        """
        Custom fields used for mobile app signature validation. See `custom_sign` below.
        """
        return pulumi.get(self, "custom_sign")

    @_builtins.property
    @pulumi.getter(name="customSignStatus")
    def custom_sign_status(self) -> Optional[_builtins.str]:
        """
        Indicates whether the custom signature field validation is enabled.
        """
        return pulumi.get(self, "custom_sign_status")

    @_builtins.property
    @pulumi.getter(name="featureAbnormals")
    def feature_abnormals(self) -> Optional[Sequence[_builtins.str]]:
        """
        Detected abnormal behaviors of the application.
        """
        return pulumi.get(self, "feature_abnormals")


@pulumi.output_type
class WafRuleConfigAppSdkCustomSign(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The name of the custom signature field used for validation.
        :param _builtins.str value: The value of the custom signature field used for validation.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The name of the custom signature field used for validation.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of the custom signature field used for validation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WafRuleConfigManagedRuleset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attackType":
            suggest = "attack_type"
        elif key == "managedRules":
            suggest = "managed_rules"
        elif key == "numberEnabled":
            suggest = "number_enabled"
        elif key == "numberTotal":
            suggest = "number_total"
        elif key == "protectionLevel":
            suggest = "protection_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfigManagedRuleset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfigManagedRuleset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfigManagedRuleset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[_builtins.str] = None,
                 attack_type: Optional[_builtins.int] = None,
                 managed_rules: Optional[Sequence['outputs.WafRuleConfigManagedRulesetManagedRule']] = None,
                 number_enabled: Optional[_builtins.int] = None,
                 number_total: Optional[_builtins.int] = None,
                 protection_level: Optional[_builtins.int] = None):
        """
        :param _builtins.int attack_type: The primary attack type targeted by this ruleset.
        :param Sequence['WafRuleConfigManagedRulesetManagedRuleArgs'] managed_rules: The individual managed rules included in this ruleset. See `managed_rules` below.
        :param _builtins.int number_enabled: Number of rules currently enabled.
        :param _builtins.int number_total: Total number of rules in this ruleset.
        :param _builtins.int protection_level: The protection strength level assigned to this ruleset.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if attack_type is not None:
            pulumi.set(__self__, "attack_type", attack_type)
        if managed_rules is not None:
            pulumi.set(__self__, "managed_rules", managed_rules)
        if number_enabled is not None:
            pulumi.set(__self__, "number_enabled", number_enabled)
        if number_total is not None:
            pulumi.set(__self__, "number_total", number_total)
        if protection_level is not None:
            pulumi.set(__self__, "protection_level", protection_level)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="attackType")
    def attack_type(self) -> Optional[_builtins.int]:
        """
        The primary attack type targeted by this ruleset.
        """
        return pulumi.get(self, "attack_type")

    @_builtins.property
    @pulumi.getter(name="managedRules")
    def managed_rules(self) -> Optional[Sequence['outputs.WafRuleConfigManagedRulesetManagedRule']]:
        """
        The individual managed rules included in this ruleset. See `managed_rules` below.
        """
        return pulumi.get(self, "managed_rules")

    @_builtins.property
    @pulumi.getter(name="numberEnabled")
    def number_enabled(self) -> Optional[_builtins.int]:
        """
        Number of rules currently enabled.
        """
        return pulumi.get(self, "number_enabled")

    @_builtins.property
    @pulumi.getter(name="numberTotal")
    def number_total(self) -> Optional[_builtins.int]:
        """
        Total number of rules in this ruleset.
        """
        return pulumi.get(self, "number_total")

    @_builtins.property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> Optional[_builtins.int]:
        """
        The protection strength level assigned to this ruleset.
        """
        return pulumi.get(self, "protection_level")


@pulumi.output_type
class WafRuleConfigManagedRulesetManagedRule(dict):
    def __init__(__self__, *,
                 action: Optional[_builtins.str] = None,
                 id: Optional[_builtins.int] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.int id: The internal unique ID of the WAF rule.
        :param _builtins.str status: The status of the managed rule: whether it is enabled or disabled.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        The internal unique ID of the WAF rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the managed rule: whether it is enabled or disabled.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class WafRuleConfigRateLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onHit":
            suggest = "on_hit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfigRateLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfigRateLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfigRateLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 characteristics: Optional['outputs.WafRuleConfigRateLimitCharacteristics'] = None,
                 interval: Optional[_builtins.int] = None,
                 on_hit: Optional[_builtins.bool] = None,
                 threshold: Optional['outputs.WafRuleConfigRateLimitThreshold'] = None,
                 ttl: Optional[_builtins.int] = None):
        """
        :param 'WafRuleConfigRateLimitCharacteristicsArgs' characteristics: The statistical dimensions to which the rate limiting rule applies. See `characteristics` below.
        :param _builtins.int interval: The statistical interval.
        :param _builtins.bool on_hit: Indicates whether the rule applies to requests that hit the cache.
        :param 'WafRuleConfigRateLimitThresholdArgs' threshold: Threshold settings for the rate limiting rule. See `threshold` below.
        :param _builtins.int ttl: The timeout period for creating the stack used in rate limiting.
        """
        if characteristics is not None:
            pulumi.set(__self__, "characteristics", characteristics)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if on_hit is not None:
            pulumi.set(__self__, "on_hit", on_hit)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def characteristics(self) -> Optional['outputs.WafRuleConfigRateLimitCharacteristics']:
        """
        The statistical dimensions to which the rate limiting rule applies. See `characteristics` below.
        """
        return pulumi.get(self, "characteristics")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        The statistical interval.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="onHit")
    def on_hit(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the rule applies to requests that hit the cache.
        """
        return pulumi.get(self, "on_hit")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional['outputs.WafRuleConfigRateLimitThreshold']:
        """
        Threshold settings for the rate limiting rule. See `threshold` below.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.int]:
        """
        The timeout period for creating the stack used in rate limiting.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class WafRuleConfigRateLimitCharacteristics(dict):
    def __init__(__self__, *,
                 criterias: Optional[Sequence['outputs.WafRuleConfigRateLimitCharacteristicsCriteria']] = None,
                 logic: Optional[_builtins.str] = None):
        if criterias is not None:
            pulumi.set(__self__, "criterias", criterias)
        if logic is not None:
            pulumi.set(__self__, "logic", logic)

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> Optional[Sequence['outputs.WafRuleConfigRateLimitCharacteristicsCriteria']]:
        return pulumi.get(self, "criterias")

    @_builtins.property
    @pulumi.getter
    def logic(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "logic")


@pulumi.output_type
class WafRuleConfigRateLimitCharacteristicsCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfigRateLimitCharacteristicsCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfigRateLimitCharacteristicsCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfigRateLimitCharacteristicsCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criterias: Optional[Sequence['outputs.WafRuleConfigRateLimitCharacteristicsCriteriaCriteria']] = None,
                 logic: Optional[_builtins.str] = None,
                 match_type: Optional[_builtins.str] = None):
        if criterias is not None:
            pulumi.set(__self__, "criterias", criterias)
        if logic is not None:
            pulumi.set(__self__, "logic", logic)
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> Optional[Sequence['outputs.WafRuleConfigRateLimitCharacteristicsCriteriaCriteria']]:
        return pulumi.get(self, "criterias")

    @_builtins.property
    @pulumi.getter
    def logic(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "logic")

    @_builtins.property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_type")


@pulumi.output_type
class WafRuleConfigRateLimitCharacteristicsCriteriaCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfigRateLimitCharacteristicsCriteriaCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfigRateLimitCharacteristicsCriteriaCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfigRateLimitCharacteristicsCriteriaCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criterias: Optional[Sequence['outputs.WafRuleConfigRateLimitCharacteristicsCriteriaCriteriaCriteria']] = None,
                 logic: Optional[_builtins.str] = None,
                 match_type: Optional[_builtins.str] = None):
        if criterias is not None:
            pulumi.set(__self__, "criterias", criterias)
        if logic is not None:
            pulumi.set(__self__, "logic", logic)
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> Optional[Sequence['outputs.WafRuleConfigRateLimitCharacteristicsCriteriaCriteriaCriteria']]:
        return pulumi.get(self, "criterias")

    @_builtins.property
    @pulumi.getter
    def logic(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "logic")

    @_builtins.property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_type")


@pulumi.output_type
class WafRuleConfigRateLimitCharacteristicsCriteriaCriteriaCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfigRateLimitCharacteristicsCriteriaCriteriaCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfigRateLimitCharacteristicsCriteriaCriteriaCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfigRateLimitCharacteristicsCriteriaCriteriaCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_type: Optional[_builtins.str] = None):
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)

    @_builtins.property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_type")


@pulumi.output_type
class WafRuleConfigRateLimitThreshold(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distinctManagedRules":
            suggest = "distinct_managed_rules"
        elif key == "managedRulesBlocked":
            suggest = "managed_rules_blocked"
        elif key == "responseStatus":
            suggest = "response_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfigRateLimitThreshold. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfigRateLimitThreshold.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfigRateLimitThreshold.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distinct_managed_rules: Optional[_builtins.int] = None,
                 managed_rules_blocked: Optional[_builtins.int] = None,
                 request: Optional[_builtins.int] = None,
                 response_status: Optional['outputs.WafRuleConfigRateLimitThresholdResponseStatus'] = None,
                 traffic: Optional[_builtins.str] = None):
        """
        :param _builtins.int distinct_managed_rules: The maximum number of distinct managed rules that can be triggered.
        :param _builtins.int managed_rules_blocked: The maximum number of times that managed rules can be triggered.
        :param _builtins.int request: The maximum number of allowed requests within a time interval.
        :param 'WafRuleConfigRateLimitThresholdResponseStatusArgs' response_status: Limits on the frequency of returning specific HTTP status codes. See `response_status` below.
        :param _builtins.str traffic: The maximum allowed traffic within a time interval (deprecated).
        """
        if distinct_managed_rules is not None:
            pulumi.set(__self__, "distinct_managed_rules", distinct_managed_rules)
        if managed_rules_blocked is not None:
            pulumi.set(__self__, "managed_rules_blocked", managed_rules_blocked)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if response_status is not None:
            pulumi.set(__self__, "response_status", response_status)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)

    @_builtins.property
    @pulumi.getter(name="distinctManagedRules")
    def distinct_managed_rules(self) -> Optional[_builtins.int]:
        """
        The maximum number of distinct managed rules that can be triggered.
        """
        return pulumi.get(self, "distinct_managed_rules")

    @_builtins.property
    @pulumi.getter(name="managedRulesBlocked")
    def managed_rules_blocked(self) -> Optional[_builtins.int]:
        """
        The maximum number of times that managed rules can be triggered.
        """
        return pulumi.get(self, "managed_rules_blocked")

    @_builtins.property
    @pulumi.getter
    def request(self) -> Optional[_builtins.int]:
        """
        The maximum number of allowed requests within a time interval.
        """
        return pulumi.get(self, "request")

    @_builtins.property
    @pulumi.getter(name="responseStatus")
    def response_status(self) -> Optional['outputs.WafRuleConfigRateLimitThresholdResponseStatus']:
        """
        Limits on the frequency of returning specific HTTP status codes. See `response_status` below.
        """
        return pulumi.get(self, "response_status")

    @_builtins.property
    @pulumi.getter
    def traffic(self) -> Optional[_builtins.str]:
        """
        The maximum allowed traffic within a time interval (deprecated).
        """
        return pulumi.get(self, "traffic")


@pulumi.output_type
class WafRuleConfigRateLimitThresholdResponseStatus(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 count: Optional[_builtins.int] = None,
                 ratio: Optional[_builtins.int] = None):
        """
        :param _builtins.int count: The maximum number of times the specified status code can be returned.
        :param _builtins.int ratio: The upper limit of the percentage of occurrences of the specified status code among all responses.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if ratio is not None:
            pulumi.set(__self__, "ratio", ratio)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        The maximum number of times the specified status code can be returned.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def ratio(self) -> Optional[_builtins.int]:
        """
        The upper limit of the percentage of occurrences of the specified status code among all responses.
        """
        return pulumi.get(self, "ratio")


@pulumi.output_type
class WafRuleConfigSecurityLevel(dict):
    def __init__(__self__, *,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: The value of the custom signature field used for validation.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of the custom signature field used for validation.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WafRuleConfigTimer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "weeklyPeriods":
            suggest = "weekly_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfigTimer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfigTimer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfigTimer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 periods: Optional[Sequence['outputs.WafRuleConfigTimerPeriod']] = None,
                 scopes: Optional[_builtins.str] = None,
                 weekly_periods: Optional[Sequence['outputs.WafRuleConfigTimerWeeklyPeriod']] = None,
                 zone: Optional[_builtins.int] = None):
        """
        :param _builtins.str scopes: Timing type:
        :param Sequence['WafRuleConfigTimerWeeklyPeriodArgs'] weekly_periods: Weekly recurring time schedules. See `weekly_periods` below.
        :param _builtins.int zone: The time zone. If it is not specified, the default value is UTC +00:00.  Example: 8 means East Zone 8,-8 means West Zone 8  Range:-12 -+14
        """
        if periods is not None:
            pulumi.set(__self__, "periods", periods)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if weekly_periods is not None:
            pulumi.set(__self__, "weekly_periods", weekly_periods)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def periods(self) -> Optional[Sequence['outputs.WafRuleConfigTimerPeriod']]:
        return pulumi.get(self, "periods")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[_builtins.str]:
        """
        Timing type:
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter(name="weeklyPeriods")
    def weekly_periods(self) -> Optional[Sequence['outputs.WafRuleConfigTimerWeeklyPeriod']]:
        """
        Weekly recurring time schedules. See `weekly_periods` below.
        """
        return pulumi.get(self, "weekly_periods")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.int]:
        """
        The time zone. If it is not specified, the default value is UTC +00:00.  Example: 8 means East Zone 8,-8 means West Zone 8  Range:-12 -+14
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class WafRuleConfigTimerPeriod(dict):
    def __init__(__self__, *,
                 end: Optional[_builtins.str] = None,
                 start: Optional[_builtins.str] = None):
        """
        :param _builtins.str end: End time in HH:mm:ss format
        :param _builtins.str start: Start time in HH:mm:ss format
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def end(self) -> Optional[_builtins.str]:
        """
        End time in HH:mm:ss format
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def start(self) -> Optional[_builtins.str]:
        """
        Start time in HH:mm:ss format
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class WafRuleConfigTimerWeeklyPeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailyPeriods":
            suggest = "daily_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleConfigTimerWeeklyPeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleConfigTimerWeeklyPeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleConfigTimerWeeklyPeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily_periods: Optional[Sequence['outputs.WafRuleConfigTimerWeeklyPeriodDailyPeriod']] = None,
                 days: Optional[_builtins.str] = None):
        """
        :param Sequence['WafRuleConfigTimerWeeklyPeriodDailyPeriodArgs'] daily_periods: Daily effective time periods within a weekly schedule. See `daily_periods` below.
        :param _builtins.str days: Cycle, multiple use comma separated, 1-7 respectively represent Monday-Sunday.  Example: Monday, Wednesday value is "1,3"
        """
        if daily_periods is not None:
            pulumi.set(__self__, "daily_periods", daily_periods)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter(name="dailyPeriods")
    def daily_periods(self) -> Optional[Sequence['outputs.WafRuleConfigTimerWeeklyPeriodDailyPeriod']]:
        """
        Daily effective time periods within a weekly schedule. See `daily_periods` below.
        """
        return pulumi.get(self, "daily_periods")

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.str]:
        """
        Cycle, multiple use comma separated, 1-7 respectively represent Monday-Sunday.  Example: Monday, Wednesday value is "1,3"
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class WafRuleConfigTimerWeeklyPeriodDailyPeriod(dict):
    def __init__(__self__, *,
                 end: Optional[_builtins.str] = None,
                 start: Optional[_builtins.str] = None):
        """
        :param _builtins.str end: End time in HH:mm:ss format
        :param _builtins.str start: Start time in HH:mm:ss format
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def end(self) -> Optional[_builtins.str]:
        """
        End time in HH:mm:ss format
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def start(self) -> Optional[_builtins.str]:
        """
        Start time in HH:mm:ss format
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class WafRuleShared(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crossSiteId":
            suggest = "cross_site_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleShared. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleShared.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleShared.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[_builtins.str] = None,
                 actions: Optional['outputs.WafRuleSharedActions'] = None,
                 cross_site_id: Optional[_builtins.int] = None,
                 expression: Optional[_builtins.str] = None,
                 match: Optional['outputs.WafRuleSharedMatch'] = None,
                 mode: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 target: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: The default action executed under shared configuration.
        :param 'WafRuleSharedActionsArgs' actions: Extended action configurations under shared settings. See `actions` below.
        :param _builtins.int cross_site_id: Specify the cross-domain site ID.
        :param _builtins.str expression: The match expression used in shared configuration.
        :param 'WafRuleSharedMatchArgs' match: Configuration of the request matching logic engine. See `match` below.
        :param _builtins.str mode: The integration mode of the Web SDK:
        :param _builtins.str name: The display name of the ruleset.
        :param _builtins.str target: The target type protected by this rule: web or app.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if cross_site_id is not None:
            pulumi.set(__self__, "cross_site_id", cross_site_id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The default action executed under shared configuration.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional['outputs.WafRuleSharedActions']:
        """
        Extended action configurations under shared settings. See `actions` below.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="crossSiteId")
    def cross_site_id(self) -> Optional[_builtins.int]:
        """
        Specify the cross-domain site ID.
        """
        return pulumi.get(self, "cross_site_id")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        The match expression used in shared configuration.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional['outputs.WafRuleSharedMatch']:
        """
        Configuration of the request matching logic engine. See `match` below.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        The integration mode of the Web SDK:
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The display name of the ruleset.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[_builtins.str]:
        """
        The target type protected by this rule: web or app.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class WafRuleSharedActions(dict):
    def __init__(__self__, *,
                 response: Optional['outputs.WafRuleSharedActionsResponse'] = None):
        if response is not None:
            pulumi.set(__self__, "response", response)

    @_builtins.property
    @pulumi.getter
    def response(self) -> Optional['outputs.WafRuleSharedActionsResponse']:
        return pulumi.get(self, "response")


@pulumi.output_type
class WafRuleSharedActionsResponse(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 id: Optional[_builtins.int] = None):
        """
        :param _builtins.int id: The internal unique ID of the WAF rule.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        The internal unique ID of the WAF rule.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class WafRuleSharedMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleSharedMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleSharedMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleSharedMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criterias: Optional[Sequence['outputs.WafRuleSharedMatchCriteria']] = None,
                 logic: Optional[_builtins.str] = None,
                 match_type: Optional[_builtins.str] = None):
        if criterias is not None:
            pulumi.set(__self__, "criterias", criterias)
        if logic is not None:
            pulumi.set(__self__, "logic", logic)
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> Optional[Sequence['outputs.WafRuleSharedMatchCriteria']]:
        return pulumi.get(self, "criterias")

    @_builtins.property
    @pulumi.getter
    def logic(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "logic")

    @_builtins.property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_type")


@pulumi.output_type
class WafRuleSharedMatchCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleSharedMatchCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleSharedMatchCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleSharedMatchCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criterias: Optional[Sequence['outputs.WafRuleSharedMatchCriteriaCriteria']] = None,
                 logic: Optional[_builtins.str] = None,
                 match_type: Optional[_builtins.str] = None):
        if criterias is not None:
            pulumi.set(__self__, "criterias", criterias)
        if logic is not None:
            pulumi.set(__self__, "logic", logic)
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> Optional[Sequence['outputs.WafRuleSharedMatchCriteriaCriteria']]:
        return pulumi.get(self, "criterias")

    @_builtins.property
    @pulumi.getter
    def logic(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "logic")

    @_builtins.property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_type")


@pulumi.output_type
class WafRuleSharedMatchCriteriaCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleSharedMatchCriteriaCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleSharedMatchCriteriaCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleSharedMatchCriteriaCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criterias: Optional[Sequence['outputs.WafRuleSharedMatchCriteriaCriteriaCriteria']] = None,
                 logic: Optional[_builtins.str] = None,
                 match_type: Optional[_builtins.str] = None):
        if criterias is not None:
            pulumi.set(__self__, "criterias", criterias)
        if logic is not None:
            pulumi.set(__self__, "logic", logic)
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> Optional[Sequence['outputs.WafRuleSharedMatchCriteriaCriteriaCriteria']]:
        return pulumi.get(self, "criterias")

    @_builtins.property
    @pulumi.getter
    def logic(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "logic")

    @_builtins.property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_type")


@pulumi.output_type
class WafRuleSharedMatchCriteriaCriteriaCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WafRuleSharedMatchCriteriaCriteriaCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WafRuleSharedMatchCriteriaCriteriaCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WafRuleSharedMatchCriteriaCriteriaCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_type: Optional[_builtins.str] = None):
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)

    @_builtins.property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_type")


@pulumi.output_type
class WaitingRoomHostNameAndPath(dict):
    def __init__(__self__, *,
                 domain: _builtins.str,
                 path: _builtins.str,
                 subdomain: _builtins.str):
        """
        :param _builtins.str domain: The domain name.
        :param _builtins.str path: The path.
        :param _builtins.str subdomain: The subdomain.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "subdomain", subdomain)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain name.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> _builtins.str:
        """
        The subdomain.
        """
        return pulumi.get(self, "subdomain")


@pulumi.output_type
class GetSitesSiteResult(dict):
    def __init__(__self__, *,
                 access_type: _builtins.str,
                 coverage: _builtins.str,
                 create_time: _builtins.str,
                 id: _builtins.int,
                 instance_id: _builtins.str,
                 modify_time: _builtins.str,
                 name_server_list: _builtins.str,
                 resource_group_id: _builtins.str,
                 site_id: _builtins.int,
                 site_name: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str access_type: Access type. Value:-**NS**: Managed access via NS.-**CNAME**: access through CNAME.
        :param _builtins.str coverage: Acceleration area
        :param _builtins.str create_time: Creation time
        :param _builtins.int id: The ID of the resource supplied above.
        :param _builtins.str instance_id: The ID of the associated package instance.
        :param _builtins.str modify_time: Modification time
        :param _builtins.str name_server_list: Site Resolution Name Server List
        :param _builtins.str resource_group_id: The ID of the resource group
        :param _builtins.int site_id: Site ID
        :param _builtins.str site_name: Site Name
        :param _builtins.str status: The status of the resource
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "coverage", coverage)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "name_server_list", name_server_list)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "site_name", site_name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> _builtins.str:
        """
        Access type. Value:-**NS**: Managed access via NS.-**CNAME**: access through CNAME.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter
    def coverage(self) -> _builtins.str:
        """
        Acceleration area
        """
        return pulumi.get(self, "coverage")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the associated package instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> _builtins.str:
        """
        Modification time
        """
        return pulumi.get(self, "modify_time")

    @_builtins.property
    @pulumi.getter(name="nameServerList")
    def name_server_list(self) -> _builtins.str:
        """
        Site Resolution Name Server List
        """
        return pulumi.get(self, "name_server_list")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> _builtins.int:
        """
        Site ID
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteName")
    def site_name(self) -> _builtins.str:
        """
        Site Name
        """
        return pulumi.get(self, "site_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")


