# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SiteArgs', 'Site']

@pulumi.input_type
class SiteArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 site_name: pulumi.Input[_builtins.str],
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 add_client_geolocation_header: Optional[pulumi.Input[_builtins.str]] = None,
                 add_real_client_ip_header: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_architecture_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 case_insensitive: Optional[pulumi.Input[_builtins.str]] = None,
                 coverage: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 development_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 flatten_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 seo_bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 site_name_exclusive: Optional[pulumi.Input[_builtins.str]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_management: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Site resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the associated package instance.
        :param pulumi.Input[_builtins.str] site_name: The website name.
        :param pulumi.Input[_builtins.str] access_type: The DNS setup. Valid values:
               - `NS`
               - `CNAME`
        :param pulumi.Input[_builtins.str] add_client_geolocation_header: Add visitor geolocation header. Value range:
        :param pulumi.Input[_builtins.str] add_real_client_ip_header: Add the "ali-real-client-ip" header containing the real client IP. Value range:
        :param pulumi.Input[_builtins.str] cache_architecture_mode: Multi-level cache architecture mode. Possible values:
        :param pulumi.Input[_builtins.str] cache_reserve_enable: Site cache hold switch. Value:
        :param pulumi.Input[_builtins.str] cache_reserve_instance_id: The ID of the cache instance.
        :param pulumi.Input[_builtins.str] case_insensitive: Whether the custom CacheTag name ignores case. Value range:
        :param pulumi.Input[_builtins.str] coverage: The service location. Valid values:
        :param pulumi.Input[_builtins.str] cross_border_optimization: Whether to enable mainland China network access optimization, the default is off. Value range:
        :param pulumi.Input[_builtins.str] development_mode: Development mode configuration function switch. Value range:
        :param pulumi.Input[_builtins.str] flatten_mode: CNAME flattening mode. Possible values:
        :param pulumi.Input[_builtins.str] ipv6_enable: Specifies whether to enable IPv6. Valid values:
        :param pulumi.Input[_builtins.str] ipv6_region: The region in which Ipv6 is enabled. The default value is x.x:
               - 'x.x': Global.
               - 'Cn.cn ': Mainland China.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] seo_bypass: Release the search engine crawler configuration. Value:
        :param pulumi.Input[_builtins.str] site_name_exclusive: Specifies whether to enable site hold.After you enable site hold, other accounts cannot add your website domain or its subdomains to ESA. Valid values:
        :param pulumi.Input[_builtins.int] site_version: The version number of the site. For sites with version management enabled, you can use this parameter to specify the site version for which the configuration will take effect, defaulting to version 0.
        :param pulumi.Input[_builtins.str] tag_name: Custom CacheTag name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Resource tags
        :param pulumi.Input[_builtins.bool] version_management: Version management enabled. When true, version management is turned on for the table site.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "site_name", site_name)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if add_client_geolocation_header is not None:
            pulumi.set(__self__, "add_client_geolocation_header", add_client_geolocation_header)
        if add_real_client_ip_header is not None:
            pulumi.set(__self__, "add_real_client_ip_header", add_real_client_ip_header)
        if cache_architecture_mode is not None:
            pulumi.set(__self__, "cache_architecture_mode", cache_architecture_mode)
        if cache_reserve_enable is not None:
            pulumi.set(__self__, "cache_reserve_enable", cache_reserve_enable)
        if cache_reserve_instance_id is not None:
            pulumi.set(__self__, "cache_reserve_instance_id", cache_reserve_instance_id)
        if case_insensitive is not None:
            pulumi.set(__self__, "case_insensitive", case_insensitive)
        if coverage is not None:
            pulumi.set(__self__, "coverage", coverage)
        if cross_border_optimization is not None:
            pulumi.set(__self__, "cross_border_optimization", cross_border_optimization)
        if development_mode is not None:
            pulumi.set(__self__, "development_mode", development_mode)
        if flatten_mode is not None:
            pulumi.set(__self__, "flatten_mode", flatten_mode)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if ipv6_region is not None:
            pulumi.set(__self__, "ipv6_region", ipv6_region)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if seo_bypass is not None:
            pulumi.set(__self__, "seo_bypass", seo_bypass)
        if site_name_exclusive is not None:
            pulumi.set(__self__, "site_name_exclusive", site_name_exclusive)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_management is not None:
            pulumi.set(__self__, "version_management", version_management)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the associated package instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="siteName")
    def site_name(self) -> pulumi.Input[_builtins.str]:
        """
        The website name.
        """
        return pulumi.get(self, "site_name")

    @site_name.setter
    def site_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "site_name", value)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS setup. Valid values:
        - `NS`
        - `CNAME`
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="addClientGeolocationHeader")
    def add_client_geolocation_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Add visitor geolocation header. Value range:
        """
        return pulumi.get(self, "add_client_geolocation_header")

    @add_client_geolocation_header.setter
    def add_client_geolocation_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "add_client_geolocation_header", value)

    @_builtins.property
    @pulumi.getter(name="addRealClientIpHeader")
    def add_real_client_ip_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Add the "ali-real-client-ip" header containing the real client IP. Value range:
        """
        return pulumi.get(self, "add_real_client_ip_header")

    @add_real_client_ip_header.setter
    def add_real_client_ip_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "add_real_client_ip_header", value)

    @_builtins.property
    @pulumi.getter(name="cacheArchitectureMode")
    def cache_architecture_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Multi-level cache architecture mode. Possible values:
        """
        return pulumi.get(self, "cache_architecture_mode")

    @cache_architecture_mode.setter
    def cache_architecture_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_architecture_mode", value)

    @_builtins.property
    @pulumi.getter(name="cacheReserveEnable")
    def cache_reserve_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Site cache hold switch. Value:
        """
        return pulumi.get(self, "cache_reserve_enable")

    @cache_reserve_enable.setter
    def cache_reserve_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_reserve_enable", value)

    @_builtins.property
    @pulumi.getter(name="cacheReserveInstanceId")
    def cache_reserve_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the cache instance.
        """
        return pulumi.get(self, "cache_reserve_instance_id")

    @cache_reserve_instance_id.setter
    def cache_reserve_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_reserve_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the custom CacheTag name ignores case. Value range:
        """
        return pulumi.get(self, "case_insensitive")

    @case_insensitive.setter
    def case_insensitive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "case_insensitive", value)

    @_builtins.property
    @pulumi.getter
    def coverage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service location. Valid values:
        """
        return pulumi.get(self, "coverage")

    @coverage.setter
    def coverage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "coverage", value)

    @_builtins.property
    @pulumi.getter(name="crossBorderOptimization")
    def cross_border_optimization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable mainland China network access optimization, the default is off. Value range:
        """
        return pulumi.get(self, "cross_border_optimization")

    @cross_border_optimization.setter
    def cross_border_optimization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_border_optimization", value)

    @_builtins.property
    @pulumi.getter(name="developmentMode")
    def development_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Development mode configuration function switch. Value range:
        """
        return pulumi.get(self, "development_mode")

    @development_mode.setter
    def development_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "development_mode", value)

    @_builtins.property
    @pulumi.getter(name="flattenMode")
    def flatten_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CNAME flattening mode. Possible values:
        """
        return pulumi.get(self, "flatten_mode")

    @flatten_mode.setter
    def flatten_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flatten_mode", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable IPv6. Valid values:
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Region")
    def ipv6_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which Ipv6 is enabled. The default value is x.x:
        - 'x.x': Global.
        - 'Cn.cn ': Mainland China.
        """
        return pulumi.get(self, "ipv6_region")

    @ipv6_region.setter
    def ipv6_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_region", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="seoBypass")
    def seo_bypass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Release the search engine crawler configuration. Value:
        """
        return pulumi.get(self, "seo_bypass")

    @seo_bypass.setter
    def seo_bypass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "seo_bypass", value)

    @_builtins.property
    @pulumi.getter(name="siteNameExclusive")
    def site_name_exclusive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable site hold.After you enable site hold, other accounts cannot add your website domain or its subdomains to ESA. Valid values:
        """
        return pulumi.get(self, "site_name_exclusive")

    @site_name_exclusive.setter
    def site_name_exclusive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site_name_exclusive", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site. For sites with version management enabled, you can use this parameter to specify the site version for which the configuration will take effect, defaulting to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom CacheTag name.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="versionManagement")
    def version_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Version management enabled. When true, version management is turned on for the table site.
        """
        return pulumi.get(self, "version_management")

    @version_management.setter
    def version_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "version_management", value)


@pulumi.input_type
class _SiteState:
    def __init__(__self__, *,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 add_client_geolocation_header: Optional[pulumi.Input[_builtins.str]] = None,
                 add_real_client_ip_header: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_architecture_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 case_insensitive: Optional[pulumi.Input[_builtins.str]] = None,
                 coverage: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 development_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 flatten_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 seo_bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 site_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_name_exclusive: Optional[pulumi.Input[_builtins.str]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_management: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Site resources.
        :param pulumi.Input[_builtins.str] access_type: The DNS setup. Valid values:
               - `NS`
               - `CNAME`
        :param pulumi.Input[_builtins.str] add_client_geolocation_header: Add visitor geolocation header. Value range:
        :param pulumi.Input[_builtins.str] add_real_client_ip_header: Add the "ali-real-client-ip" header containing the real client IP. Value range:
        :param pulumi.Input[_builtins.str] cache_architecture_mode: Multi-level cache architecture mode. Possible values:
        :param pulumi.Input[_builtins.str] cache_reserve_enable: Site cache hold switch. Value:
        :param pulumi.Input[_builtins.str] cache_reserve_instance_id: The ID of the cache instance.
        :param pulumi.Input[_builtins.str] case_insensitive: Whether the custom CacheTag name ignores case. Value range:
        :param pulumi.Input[_builtins.str] coverage: The service location. Valid values:
        :param pulumi.Input[_builtins.str] create_time: The time when the website was added. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] cross_border_optimization: Whether to enable mainland China network access optimization, the default is off. Value range:
        :param pulumi.Input[_builtins.str] development_mode: Development mode configuration function switch. Value range:
        :param pulumi.Input[_builtins.str] flatten_mode: CNAME flattening mode. Possible values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the associated package instance.
        :param pulumi.Input[_builtins.str] ipv6_enable: Specifies whether to enable IPv6. Valid values:
        :param pulumi.Input[_builtins.str] ipv6_region: The region in which Ipv6 is enabled. The default value is x.x:
               - 'x.x': Global.
               - 'Cn.cn ': Mainland China.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] seo_bypass: Release the search engine crawler configuration. Value:
        :param pulumi.Input[_builtins.str] site_name: The website name.
        :param pulumi.Input[_builtins.str] site_name_exclusive: Specifies whether to enable site hold.After you enable site hold, other accounts cannot add your website domain or its subdomains to ESA. Valid values:
        :param pulumi.Input[_builtins.int] site_version: The version number of the site. For sites with version management enabled, you can use this parameter to specify the site version for which the configuration will take effect, defaulting to version 0.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] tag_name: Custom CacheTag name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Resource tags
        :param pulumi.Input[_builtins.bool] version_management: Version management enabled. When true, version management is turned on for the table site.
        """
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if add_client_geolocation_header is not None:
            pulumi.set(__self__, "add_client_geolocation_header", add_client_geolocation_header)
        if add_real_client_ip_header is not None:
            pulumi.set(__self__, "add_real_client_ip_header", add_real_client_ip_header)
        if cache_architecture_mode is not None:
            pulumi.set(__self__, "cache_architecture_mode", cache_architecture_mode)
        if cache_reserve_enable is not None:
            pulumi.set(__self__, "cache_reserve_enable", cache_reserve_enable)
        if cache_reserve_instance_id is not None:
            pulumi.set(__self__, "cache_reserve_instance_id", cache_reserve_instance_id)
        if case_insensitive is not None:
            pulumi.set(__self__, "case_insensitive", case_insensitive)
        if coverage is not None:
            pulumi.set(__self__, "coverage", coverage)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_border_optimization is not None:
            pulumi.set(__self__, "cross_border_optimization", cross_border_optimization)
        if development_mode is not None:
            pulumi.set(__self__, "development_mode", development_mode)
        if flatten_mode is not None:
            pulumi.set(__self__, "flatten_mode", flatten_mode)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if ipv6_region is not None:
            pulumi.set(__self__, "ipv6_region", ipv6_region)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if seo_bypass is not None:
            pulumi.set(__self__, "seo_bypass", seo_bypass)
        if site_name is not None:
            pulumi.set(__self__, "site_name", site_name)
        if site_name_exclusive is not None:
            pulumi.set(__self__, "site_name_exclusive", site_name_exclusive)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_management is not None:
            pulumi.set(__self__, "version_management", version_management)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS setup. Valid values:
        - `NS`
        - `CNAME`
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="addClientGeolocationHeader")
    def add_client_geolocation_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Add visitor geolocation header. Value range:
        """
        return pulumi.get(self, "add_client_geolocation_header")

    @add_client_geolocation_header.setter
    def add_client_geolocation_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "add_client_geolocation_header", value)

    @_builtins.property
    @pulumi.getter(name="addRealClientIpHeader")
    def add_real_client_ip_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Add the "ali-real-client-ip" header containing the real client IP. Value range:
        """
        return pulumi.get(self, "add_real_client_ip_header")

    @add_real_client_ip_header.setter
    def add_real_client_ip_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "add_real_client_ip_header", value)

    @_builtins.property
    @pulumi.getter(name="cacheArchitectureMode")
    def cache_architecture_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Multi-level cache architecture mode. Possible values:
        """
        return pulumi.get(self, "cache_architecture_mode")

    @cache_architecture_mode.setter
    def cache_architecture_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_architecture_mode", value)

    @_builtins.property
    @pulumi.getter(name="cacheReserveEnable")
    def cache_reserve_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Site cache hold switch. Value:
        """
        return pulumi.get(self, "cache_reserve_enable")

    @cache_reserve_enable.setter
    def cache_reserve_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_reserve_enable", value)

    @_builtins.property
    @pulumi.getter(name="cacheReserveInstanceId")
    def cache_reserve_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the cache instance.
        """
        return pulumi.get(self, "cache_reserve_instance_id")

    @cache_reserve_instance_id.setter
    def cache_reserve_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_reserve_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the custom CacheTag name ignores case. Value range:
        """
        return pulumi.get(self, "case_insensitive")

    @case_insensitive.setter
    def case_insensitive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "case_insensitive", value)

    @_builtins.property
    @pulumi.getter
    def coverage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service location. Valid values:
        """
        return pulumi.get(self, "coverage")

    @coverage.setter
    def coverage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "coverage", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the website was added. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="crossBorderOptimization")
    def cross_border_optimization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable mainland China network access optimization, the default is off. Value range:
        """
        return pulumi.get(self, "cross_border_optimization")

    @cross_border_optimization.setter
    def cross_border_optimization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_border_optimization", value)

    @_builtins.property
    @pulumi.getter(name="developmentMode")
    def development_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Development mode configuration function switch. Value range:
        """
        return pulumi.get(self, "development_mode")

    @development_mode.setter
    def development_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "development_mode", value)

    @_builtins.property
    @pulumi.getter(name="flattenMode")
    def flatten_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CNAME flattening mode. Possible values:
        """
        return pulumi.get(self, "flatten_mode")

    @flatten_mode.setter
    def flatten_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flatten_mode", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated package instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable IPv6. Valid values:
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Region")
    def ipv6_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which Ipv6 is enabled. The default value is x.x:
        - 'x.x': Global.
        - 'Cn.cn ': Mainland China.
        """
        return pulumi.get(self, "ipv6_region")

    @ipv6_region.setter
    def ipv6_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_region", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="seoBypass")
    def seo_bypass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Release the search engine crawler configuration. Value:
        """
        return pulumi.get(self, "seo_bypass")

    @seo_bypass.setter
    def seo_bypass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "seo_bypass", value)

    @_builtins.property
    @pulumi.getter(name="siteName")
    def site_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The website name.
        """
        return pulumi.get(self, "site_name")

    @site_name.setter
    def site_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site_name", value)

    @_builtins.property
    @pulumi.getter(name="siteNameExclusive")
    def site_name_exclusive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable site hold.After you enable site hold, other accounts cannot add your website domain or its subdomains to ESA. Valid values:
        """
        return pulumi.get(self, "site_name_exclusive")

    @site_name_exclusive.setter
    def site_name_exclusive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site_name_exclusive", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version number of the site. For sites with version management enabled, you can use this parameter to specify the site version for which the configuration will take effect, defaulting to version 0.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom CacheTag name.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="versionManagement")
    def version_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Version management enabled. When true, version management is turned on for the table site.
        """
        return pulumi.get(self, "version_management")

    @version_management.setter
    def version_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "version_management", value)


@pulumi.type_token("alicloud:esa/site:Site")
class Site(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 add_client_geolocation_header: Optional[pulumi.Input[_builtins.str]] = None,
                 add_real_client_ip_header: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_architecture_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 case_insensitive: Optional[pulumi.Input[_builtins.str]] = None,
                 coverage: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 development_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 flatten_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 seo_bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 site_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_name_exclusive: Optional[pulumi.Input[_builtins.str]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a ESA Site resource.

        For information about ESA Site and how to use it, see [What is Site](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/user-guide/site-management).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_i_eo_df_u = alicloud.esa.RatePlanInstance("defaultIEoDfU",
            type="NS",
            auto_renew=True,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            auto_pay=True,
            plan_name="basic")
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_site = alicloud.esa.Site("default",
            site_name=f"bcd{default_integer['result']}.com",
            coverage="overseas",
            access_type="NS",
            instance_id=default_i_eo_df_u.id,
            resource_group_id=default.ids[0])
        ```

        ## Import

        ESA Site can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/site:Site example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_type: The DNS setup. Valid values:
               - `NS`
               - `CNAME`
        :param pulumi.Input[_builtins.str] add_client_geolocation_header: Add visitor geolocation header. Value range:
        :param pulumi.Input[_builtins.str] add_real_client_ip_header: Add the "ali-real-client-ip" header containing the real client IP. Value range:
        :param pulumi.Input[_builtins.str] cache_architecture_mode: Multi-level cache architecture mode. Possible values:
        :param pulumi.Input[_builtins.str] cache_reserve_enable: Site cache hold switch. Value:
        :param pulumi.Input[_builtins.str] cache_reserve_instance_id: The ID of the cache instance.
        :param pulumi.Input[_builtins.str] case_insensitive: Whether the custom CacheTag name ignores case. Value range:
        :param pulumi.Input[_builtins.str] coverage: The service location. Valid values:
        :param pulumi.Input[_builtins.str] cross_border_optimization: Whether to enable mainland China network access optimization, the default is off. Value range:
        :param pulumi.Input[_builtins.str] development_mode: Development mode configuration function switch. Value range:
        :param pulumi.Input[_builtins.str] flatten_mode: CNAME flattening mode. Possible values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the associated package instance.
        :param pulumi.Input[_builtins.str] ipv6_enable: Specifies whether to enable IPv6. Valid values:
        :param pulumi.Input[_builtins.str] ipv6_region: The region in which Ipv6 is enabled. The default value is x.x:
               - 'x.x': Global.
               - 'Cn.cn ': Mainland China.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] seo_bypass: Release the search engine crawler configuration. Value:
        :param pulumi.Input[_builtins.str] site_name: The website name.
        :param pulumi.Input[_builtins.str] site_name_exclusive: Specifies whether to enable site hold.After you enable site hold, other accounts cannot add your website domain or its subdomains to ESA. Valid values:
        :param pulumi.Input[_builtins.int] site_version: The version number of the site. For sites with version management enabled, you can use this parameter to specify the site version for which the configuration will take effect, defaulting to version 0.
        :param pulumi.Input[_builtins.str] tag_name: Custom CacheTag name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Resource tags
        :param pulumi.Input[_builtins.bool] version_management: Version management enabled. When true, version management is turned on for the table site.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SiteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Site resource.

        For information about ESA Site and how to use it, see [What is Site](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/user-guide/site-management).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_i_eo_df_u = alicloud.esa.RatePlanInstance("defaultIEoDfU",
            type="NS",
            auto_renew=True,
            period=1,
            payment_type="Subscription",
            coverage="overseas",
            auto_pay=True,
            plan_name="basic")
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_site = alicloud.esa.Site("default",
            site_name=f"bcd{default_integer['result']}.com",
            coverage="overseas",
            access_type="NS",
            instance_id=default_i_eo_df_u.id,
            resource_group_id=default.ids[0])
        ```

        ## Import

        ESA Site can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/site:Site example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SiteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SiteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 add_client_geolocation_header: Optional[pulumi.Input[_builtins.str]] = None,
                 add_real_client_ip_header: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_architecture_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_reserve_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 case_insensitive: Optional[pulumi.Input[_builtins.str]] = None,
                 coverage: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_border_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 development_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 flatten_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 seo_bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 site_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_name_exclusive: Optional[pulumi.Input[_builtins.str]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SiteArgs.__new__(SiteArgs)

            __props__.__dict__["access_type"] = access_type
            __props__.__dict__["add_client_geolocation_header"] = add_client_geolocation_header
            __props__.__dict__["add_real_client_ip_header"] = add_real_client_ip_header
            __props__.__dict__["cache_architecture_mode"] = cache_architecture_mode
            __props__.__dict__["cache_reserve_enable"] = cache_reserve_enable
            __props__.__dict__["cache_reserve_instance_id"] = cache_reserve_instance_id
            __props__.__dict__["case_insensitive"] = case_insensitive
            __props__.__dict__["coverage"] = coverage
            __props__.__dict__["cross_border_optimization"] = cross_border_optimization
            __props__.__dict__["development_mode"] = development_mode
            __props__.__dict__["flatten_mode"] = flatten_mode
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["ipv6_enable"] = ipv6_enable
            __props__.__dict__["ipv6_region"] = ipv6_region
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["seo_bypass"] = seo_bypass
            if site_name is None and not opts.urn:
                raise TypeError("Missing required property 'site_name'")
            __props__.__dict__["site_name"] = site_name
            __props__.__dict__["site_name_exclusive"] = site_name_exclusive
            __props__.__dict__["site_version"] = site_version
            __props__.__dict__["tag_name"] = tag_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version_management"] = version_management
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Site, __self__).__init__(
            'alicloud:esa/site:Site',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_type: Optional[pulumi.Input[_builtins.str]] = None,
            add_client_geolocation_header: Optional[pulumi.Input[_builtins.str]] = None,
            add_real_client_ip_header: Optional[pulumi.Input[_builtins.str]] = None,
            cache_architecture_mode: Optional[pulumi.Input[_builtins.str]] = None,
            cache_reserve_enable: Optional[pulumi.Input[_builtins.str]] = None,
            cache_reserve_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            case_insensitive: Optional[pulumi.Input[_builtins.str]] = None,
            coverage: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            cross_border_optimization: Optional[pulumi.Input[_builtins.str]] = None,
            development_mode: Optional[pulumi.Input[_builtins.str]] = None,
            flatten_mode: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_enable: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            seo_bypass: Optional[pulumi.Input[_builtins.str]] = None,
            site_name: Optional[pulumi.Input[_builtins.str]] = None,
            site_name_exclusive: Optional[pulumi.Input[_builtins.str]] = None,
            site_version: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tag_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version_management: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Site':
        """
        Get an existing Site resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_type: The DNS setup. Valid values:
               - `NS`
               - `CNAME`
        :param pulumi.Input[_builtins.str] add_client_geolocation_header: Add visitor geolocation header. Value range:
        :param pulumi.Input[_builtins.str] add_real_client_ip_header: Add the "ali-real-client-ip" header containing the real client IP. Value range:
        :param pulumi.Input[_builtins.str] cache_architecture_mode: Multi-level cache architecture mode. Possible values:
        :param pulumi.Input[_builtins.str] cache_reserve_enable: Site cache hold switch. Value:
        :param pulumi.Input[_builtins.str] cache_reserve_instance_id: The ID of the cache instance.
        :param pulumi.Input[_builtins.str] case_insensitive: Whether the custom CacheTag name ignores case. Value range:
        :param pulumi.Input[_builtins.str] coverage: The service location. Valid values:
        :param pulumi.Input[_builtins.str] create_time: The time when the website was added. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] cross_border_optimization: Whether to enable mainland China network access optimization, the default is off. Value range:
        :param pulumi.Input[_builtins.str] development_mode: Development mode configuration function switch. Value range:
        :param pulumi.Input[_builtins.str] flatten_mode: CNAME flattening mode. Possible values:
        :param pulumi.Input[_builtins.str] instance_id: The ID of the associated package instance.
        :param pulumi.Input[_builtins.str] ipv6_enable: Specifies whether to enable IPv6. Valid values:
        :param pulumi.Input[_builtins.str] ipv6_region: The region in which Ipv6 is enabled. The default value is x.x:
               - 'x.x': Global.
               - 'Cn.cn ': Mainland China.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] seo_bypass: Release the search engine crawler configuration. Value:
        :param pulumi.Input[_builtins.str] site_name: The website name.
        :param pulumi.Input[_builtins.str] site_name_exclusive: Specifies whether to enable site hold.After you enable site hold, other accounts cannot add your website domain or its subdomains to ESA. Valid values:
        :param pulumi.Input[_builtins.int] site_version: The version number of the site. For sites with version management enabled, you can use this parameter to specify the site version for which the configuration will take effect, defaulting to version 0.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] tag_name: Custom CacheTag name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Resource tags
        :param pulumi.Input[_builtins.bool] version_management: Version management enabled. When true, version management is turned on for the table site.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SiteState.__new__(_SiteState)

        __props__.__dict__["access_type"] = access_type
        __props__.__dict__["add_client_geolocation_header"] = add_client_geolocation_header
        __props__.__dict__["add_real_client_ip_header"] = add_real_client_ip_header
        __props__.__dict__["cache_architecture_mode"] = cache_architecture_mode
        __props__.__dict__["cache_reserve_enable"] = cache_reserve_enable
        __props__.__dict__["cache_reserve_instance_id"] = cache_reserve_instance_id
        __props__.__dict__["case_insensitive"] = case_insensitive
        __props__.__dict__["coverage"] = coverage
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cross_border_optimization"] = cross_border_optimization
        __props__.__dict__["development_mode"] = development_mode
        __props__.__dict__["flatten_mode"] = flatten_mode
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["ipv6_enable"] = ipv6_enable
        __props__.__dict__["ipv6_region"] = ipv6_region
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["seo_bypass"] = seo_bypass
        __props__.__dict__["site_name"] = site_name
        __props__.__dict__["site_name_exclusive"] = site_name_exclusive
        __props__.__dict__["site_version"] = site_version
        __props__.__dict__["status"] = status
        __props__.__dict__["tag_name"] = tag_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version_management"] = version_management
        return Site(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The DNS setup. Valid values:
        - `NS`
        - `CNAME`
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter(name="addClientGeolocationHeader")
    def add_client_geolocation_header(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Add visitor geolocation header. Value range:
        """
        return pulumi.get(self, "add_client_geolocation_header")

    @_builtins.property
    @pulumi.getter(name="addRealClientIpHeader")
    def add_real_client_ip_header(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Add the "ali-real-client-ip" header containing the real client IP. Value range:
        """
        return pulumi.get(self, "add_real_client_ip_header")

    @_builtins.property
    @pulumi.getter(name="cacheArchitectureMode")
    def cache_architecture_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Multi-level cache architecture mode. Possible values:
        """
        return pulumi.get(self, "cache_architecture_mode")

    @_builtins.property
    @pulumi.getter(name="cacheReserveEnable")
    def cache_reserve_enable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Site cache hold switch. Value:
        """
        return pulumi.get(self, "cache_reserve_enable")

    @_builtins.property
    @pulumi.getter(name="cacheReserveInstanceId")
    def cache_reserve_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the cache instance.
        """
        return pulumi.get(self, "cache_reserve_instance_id")

    @_builtins.property
    @pulumi.getter(name="caseInsensitive")
    def case_insensitive(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether the custom CacheTag name ignores case. Value range:
        """
        return pulumi.get(self, "case_insensitive")

    @_builtins.property
    @pulumi.getter
    def coverage(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service location. Valid values:
        """
        return pulumi.get(self, "coverage")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the website was added. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossBorderOptimization")
    def cross_border_optimization(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable mainland China network access optimization, the default is off. Value range:
        """
        return pulumi.get(self, "cross_border_optimization")

    @_builtins.property
    @pulumi.getter(name="developmentMode")
    def development_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Development mode configuration function switch. Value range:
        """
        return pulumi.get(self, "development_mode")

    @_builtins.property
    @pulumi.getter(name="flattenMode")
    def flatten_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        CNAME flattening mode. Possible values:
        """
        return pulumi.get(self, "flatten_mode")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the associated package instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to enable IPv6. Valid values:
        """
        return pulumi.get(self, "ipv6_enable")

    @_builtins.property
    @pulumi.getter(name="ipv6Region")
    def ipv6_region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which Ipv6 is enabled. The default value is x.x:
        - 'x.x': Global.
        - 'Cn.cn ': Mainland China.
        """
        return pulumi.get(self, "ipv6_region")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="seoBypass")
    def seo_bypass(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Release the search engine crawler configuration. Value:
        """
        return pulumi.get(self, "seo_bypass")

    @_builtins.property
    @pulumi.getter(name="siteName")
    def site_name(self) -> pulumi.Output[_builtins.str]:
        """
        The website name.
        """
        return pulumi.get(self, "site_name")

    @_builtins.property
    @pulumi.getter(name="siteNameExclusive")
    def site_name_exclusive(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to enable site hold.After you enable site hold, other accounts cannot add your website domain or its subdomains to ESA. Valid values:
        """
        return pulumi.get(self, "site_name_exclusive")

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The version number of the site. For sites with version management enabled, you can use this parameter to specify the site version for which the configuration will take effect, defaulting to version 0.
        """
        return pulumi.get(self, "site_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom CacheTag name.
        """
        return pulumi.get(self, "tag_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="versionManagement")
    def version_management(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Version management enabled. When true, version management is turned on for the table site.
        """
        return pulumi.get(self, "version_management")

