# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SiteDeliveryTaskArgs', 'SiteDeliveryTask']

@pulumi.input_type
class SiteDeliveryTaskArgs:
    def __init__(__self__, *,
                 business_type: pulumi.Input[_builtins.str],
                 data_center: pulumi.Input[_builtins.str],
                 delivery_type: pulumi.Input[_builtins.str],
                 field_name: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 task_name: pulumi.Input[_builtins.str],
                 discard_rate: Optional[pulumi.Input[_builtins.float]] = None,
                 http_delivery: Optional[pulumi.Input['SiteDeliveryTaskHttpDeliveryArgs']] = None,
                 kafka_delivery: Optional[pulumi.Input['SiteDeliveryTaskKafkaDeliveryArgs']] = None,
                 oss_delivery: Optional[pulumi.Input['SiteDeliveryTaskOssDeliveryArgs']] = None,
                 s3_delivery: Optional[pulumi.Input['SiteDeliveryTaskS3DeliveryArgs']] = None,
                 sls_delivery: Optional[pulumi.Input['SiteDeliveryTaskSlsDeliveryArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SiteDeliveryTask resource.
        :param pulumi.Input[_builtins.str] business_type: Real-time log type. Valid values:
               - `dcdn_log_access_l1 (default)`: access log.
        :param pulumi.Input[_builtins.str] data_center: Data Center. Values:
        :param pulumi.Input[_builtins.str] delivery_type: Delivery Type:
        :param pulumi.Input[_builtins.str] field_name: The list of delivery fields to be modified, separated by commas.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) interface.
        :param pulumi.Input[_builtins.str] task_name: The task name.
        :param pulumi.Input[_builtins.float] discard_rate: If the discard rate is not filled, the default value is 0.
        :param pulumi.Input['SiteDeliveryTaskHttpDeliveryArgs'] http_delivery: HTTP delivery configuration parameters. See `http_delivery` below.
        :param pulumi.Input['SiteDeliveryTaskKafkaDeliveryArgs'] kafka_delivery: Kafka delivery configuration parameters. See `kafka_delivery` below.
        :param pulumi.Input['SiteDeliveryTaskOssDeliveryArgs'] oss_delivery: OSS delivery configuration. See `oss_delivery` below.
        :param pulumi.Input['SiteDeliveryTaskS3DeliveryArgs'] s3_delivery: S3/S3 compatible delivery configuration parameters. See `s3_delivery` below.
        :param pulumi.Input['SiteDeliveryTaskSlsDeliveryArgs'] sls_delivery: SLS delivery configuration. See `sls_delivery` below.
        :param pulumi.Input[_builtins.str] status: Task status, value:
        """
        pulumi.set(__self__, "business_type", business_type)
        pulumi.set(__self__, "data_center", data_center)
        pulumi.set(__self__, "delivery_type", delivery_type)
        pulumi.set(__self__, "field_name", field_name)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "task_name", task_name)
        if discard_rate is not None:
            pulumi.set(__self__, "discard_rate", discard_rate)
        if http_delivery is not None:
            pulumi.set(__self__, "http_delivery", http_delivery)
        if kafka_delivery is not None:
            pulumi.set(__self__, "kafka_delivery", kafka_delivery)
        if oss_delivery is not None:
            pulumi.set(__self__, "oss_delivery", oss_delivery)
        if s3_delivery is not None:
            pulumi.set(__self__, "s3_delivery", s3_delivery)
        if sls_delivery is not None:
            pulumi.set(__self__, "sls_delivery", sls_delivery)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="businessType")
    def business_type(self) -> pulumi.Input[_builtins.str]:
        """
        Real-time log type. Valid values:
        - `dcdn_log_access_l1 (default)`: access log.
        """
        return pulumi.get(self, "business_type")

    @business_type.setter
    def business_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "business_type", value)

    @_builtins.property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> pulumi.Input[_builtins.str]:
        """
        Data Center. Values:
        """
        return pulumi.get(self, "data_center")

    @data_center.setter
    def data_center(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_center", value)

    @_builtins.property
    @pulumi.getter(name="deliveryType")
    def delivery_type(self) -> pulumi.Input[_builtins.str]:
        """
        Delivery Type:
        """
        return pulumi.get(self, "delivery_type")

    @delivery_type.setter
    def delivery_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "delivery_type", value)

    @_builtins.property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> pulumi.Input[_builtins.str]:
        """
        The list of delivery fields to be modified, separated by commas.
        """
        return pulumi.get(self, "field_name")

    @field_name.setter
    def field_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "field_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) interface.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="taskName")
    def task_name(self) -> pulumi.Input[_builtins.str]:
        """
        The task name.
        """
        return pulumi.get(self, "task_name")

    @task_name.setter
    def task_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "task_name", value)

    @_builtins.property
    @pulumi.getter(name="discardRate")
    def discard_rate(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        If the discard rate is not filled, the default value is 0.
        """
        return pulumi.get(self, "discard_rate")

    @discard_rate.setter
    def discard_rate(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "discard_rate", value)

    @_builtins.property
    @pulumi.getter(name="httpDelivery")
    def http_delivery(self) -> Optional[pulumi.Input['SiteDeliveryTaskHttpDeliveryArgs']]:
        """
        HTTP delivery configuration parameters. See `http_delivery` below.
        """
        return pulumi.get(self, "http_delivery")

    @http_delivery.setter
    def http_delivery(self, value: Optional[pulumi.Input['SiteDeliveryTaskHttpDeliveryArgs']]):
        pulumi.set(self, "http_delivery", value)

    @_builtins.property
    @pulumi.getter(name="kafkaDelivery")
    def kafka_delivery(self) -> Optional[pulumi.Input['SiteDeliveryTaskKafkaDeliveryArgs']]:
        """
        Kafka delivery configuration parameters. See `kafka_delivery` below.
        """
        return pulumi.get(self, "kafka_delivery")

    @kafka_delivery.setter
    def kafka_delivery(self, value: Optional[pulumi.Input['SiteDeliveryTaskKafkaDeliveryArgs']]):
        pulumi.set(self, "kafka_delivery", value)

    @_builtins.property
    @pulumi.getter(name="ossDelivery")
    def oss_delivery(self) -> Optional[pulumi.Input['SiteDeliveryTaskOssDeliveryArgs']]:
        """
        OSS delivery configuration. See `oss_delivery` below.
        """
        return pulumi.get(self, "oss_delivery")

    @oss_delivery.setter
    def oss_delivery(self, value: Optional[pulumi.Input['SiteDeliveryTaskOssDeliveryArgs']]):
        pulumi.set(self, "oss_delivery", value)

    @_builtins.property
    @pulumi.getter(name="s3Delivery")
    def s3_delivery(self) -> Optional[pulumi.Input['SiteDeliveryTaskS3DeliveryArgs']]:
        """
        S3/S3 compatible delivery configuration parameters. See `s3_delivery` below.
        """
        return pulumi.get(self, "s3_delivery")

    @s3_delivery.setter
    def s3_delivery(self, value: Optional[pulumi.Input['SiteDeliveryTaskS3DeliveryArgs']]):
        pulumi.set(self, "s3_delivery", value)

    @_builtins.property
    @pulumi.getter(name="slsDelivery")
    def sls_delivery(self) -> Optional[pulumi.Input['SiteDeliveryTaskSlsDeliveryArgs']]:
        """
        SLS delivery configuration. See `sls_delivery` below.
        """
        return pulumi.get(self, "sls_delivery")

    @sls_delivery.setter
    def sls_delivery(self, value: Optional[pulumi.Input['SiteDeliveryTaskSlsDeliveryArgs']]):
        pulumi.set(self, "sls_delivery", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task status, value:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _SiteDeliveryTaskState:
    def __init__(__self__, *,
                 business_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_center: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_type: Optional[pulumi.Input[_builtins.str]] = None,
                 discard_rate: Optional[pulumi.Input[_builtins.float]] = None,
                 field_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_delivery: Optional[pulumi.Input['SiteDeliveryTaskHttpDeliveryArgs']] = None,
                 kafka_delivery: Optional[pulumi.Input['SiteDeliveryTaskKafkaDeliveryArgs']] = None,
                 oss_delivery: Optional[pulumi.Input['SiteDeliveryTaskOssDeliveryArgs']] = None,
                 s3_delivery: Optional[pulumi.Input['SiteDeliveryTaskS3DeliveryArgs']] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 sls_delivery: Optional[pulumi.Input['SiteDeliveryTaskSlsDeliveryArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 task_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SiteDeliveryTask resources.
        :param pulumi.Input[_builtins.str] business_type: Real-time log type. Valid values:
               - `dcdn_log_access_l1 (default)`: access log.
        :param pulumi.Input[_builtins.str] data_center: Data Center. Values:
        :param pulumi.Input[_builtins.str] delivery_type: Delivery Type:
        :param pulumi.Input[_builtins.float] discard_rate: If the discard rate is not filled, the default value is 0.
        :param pulumi.Input[_builtins.str] field_name: The list of delivery fields to be modified, separated by commas.
        :param pulumi.Input['SiteDeliveryTaskHttpDeliveryArgs'] http_delivery: HTTP delivery configuration parameters. See `http_delivery` below.
        :param pulumi.Input['SiteDeliveryTaskKafkaDeliveryArgs'] kafka_delivery: Kafka delivery configuration parameters. See `kafka_delivery` below.
        :param pulumi.Input['SiteDeliveryTaskOssDeliveryArgs'] oss_delivery: OSS delivery configuration. See `oss_delivery` below.
        :param pulumi.Input['SiteDeliveryTaskS3DeliveryArgs'] s3_delivery: S3/S3 compatible delivery configuration parameters. See `s3_delivery` below.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) interface.
        :param pulumi.Input['SiteDeliveryTaskSlsDeliveryArgs'] sls_delivery: SLS delivery configuration. See `sls_delivery` below.
        :param pulumi.Input[_builtins.str] status: Task status, value:
        :param pulumi.Input[_builtins.str] task_name: The task name.
        """
        if business_type is not None:
            pulumi.set(__self__, "business_type", business_type)
        if data_center is not None:
            pulumi.set(__self__, "data_center", data_center)
        if delivery_type is not None:
            pulumi.set(__self__, "delivery_type", delivery_type)
        if discard_rate is not None:
            pulumi.set(__self__, "discard_rate", discard_rate)
        if field_name is not None:
            pulumi.set(__self__, "field_name", field_name)
        if http_delivery is not None:
            pulumi.set(__self__, "http_delivery", http_delivery)
        if kafka_delivery is not None:
            pulumi.set(__self__, "kafka_delivery", kafka_delivery)
        if oss_delivery is not None:
            pulumi.set(__self__, "oss_delivery", oss_delivery)
        if s3_delivery is not None:
            pulumi.set(__self__, "s3_delivery", s3_delivery)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if sls_delivery is not None:
            pulumi.set(__self__, "sls_delivery", sls_delivery)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if task_name is not None:
            pulumi.set(__self__, "task_name", task_name)

    @_builtins.property
    @pulumi.getter(name="businessType")
    def business_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Real-time log type. Valid values:
        - `dcdn_log_access_l1 (default)`: access log.
        """
        return pulumi.get(self, "business_type")

    @business_type.setter
    def business_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_type", value)

    @_builtins.property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Center. Values:
        """
        return pulumi.get(self, "data_center")

    @data_center.setter
    def data_center(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_center", value)

    @_builtins.property
    @pulumi.getter(name="deliveryType")
    def delivery_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Delivery Type:
        """
        return pulumi.get(self, "delivery_type")

    @delivery_type.setter
    def delivery_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_type", value)

    @_builtins.property
    @pulumi.getter(name="discardRate")
    def discard_rate(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        If the discard rate is not filled, the default value is 0.
        """
        return pulumi.get(self, "discard_rate")

    @discard_rate.setter
    def discard_rate(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "discard_rate", value)

    @_builtins.property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of delivery fields to be modified, separated by commas.
        """
        return pulumi.get(self, "field_name")

    @field_name.setter
    def field_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "field_name", value)

    @_builtins.property
    @pulumi.getter(name="httpDelivery")
    def http_delivery(self) -> Optional[pulumi.Input['SiteDeliveryTaskHttpDeliveryArgs']]:
        """
        HTTP delivery configuration parameters. See `http_delivery` below.
        """
        return pulumi.get(self, "http_delivery")

    @http_delivery.setter
    def http_delivery(self, value: Optional[pulumi.Input['SiteDeliveryTaskHttpDeliveryArgs']]):
        pulumi.set(self, "http_delivery", value)

    @_builtins.property
    @pulumi.getter(name="kafkaDelivery")
    def kafka_delivery(self) -> Optional[pulumi.Input['SiteDeliveryTaskKafkaDeliveryArgs']]:
        """
        Kafka delivery configuration parameters. See `kafka_delivery` below.
        """
        return pulumi.get(self, "kafka_delivery")

    @kafka_delivery.setter
    def kafka_delivery(self, value: Optional[pulumi.Input['SiteDeliveryTaskKafkaDeliveryArgs']]):
        pulumi.set(self, "kafka_delivery", value)

    @_builtins.property
    @pulumi.getter(name="ossDelivery")
    def oss_delivery(self) -> Optional[pulumi.Input['SiteDeliveryTaskOssDeliveryArgs']]:
        """
        OSS delivery configuration. See `oss_delivery` below.
        """
        return pulumi.get(self, "oss_delivery")

    @oss_delivery.setter
    def oss_delivery(self, value: Optional[pulumi.Input['SiteDeliveryTaskOssDeliveryArgs']]):
        pulumi.set(self, "oss_delivery", value)

    @_builtins.property
    @pulumi.getter(name="s3Delivery")
    def s3_delivery(self) -> Optional[pulumi.Input['SiteDeliveryTaskS3DeliveryArgs']]:
        """
        S3/S3 compatible delivery configuration parameters. See `s3_delivery` below.
        """
        return pulumi.get(self, "s3_delivery")

    @s3_delivery.setter
    def s3_delivery(self, value: Optional[pulumi.Input['SiteDeliveryTaskS3DeliveryArgs']]):
        pulumi.set(self, "s3_delivery", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) interface.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="slsDelivery")
    def sls_delivery(self) -> Optional[pulumi.Input['SiteDeliveryTaskSlsDeliveryArgs']]:
        """
        SLS delivery configuration. See `sls_delivery` below.
        """
        return pulumi.get(self, "sls_delivery")

    @sls_delivery.setter
    def sls_delivery(self, value: Optional[pulumi.Input['SiteDeliveryTaskSlsDeliveryArgs']]):
        pulumi.set(self, "sls_delivery", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Task status, value:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="taskName")
    def task_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The task name.
        """
        return pulumi.get(self, "task_name")

    @task_name.setter
    def task_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_name", value)


@pulumi.type_token("alicloud:esa/siteDeliveryTask:SiteDeliveryTask")
class SiteDeliveryTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 business_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_center: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_type: Optional[pulumi.Input[_builtins.str]] = None,
                 discard_rate: Optional[pulumi.Input[_builtins.float]] = None,
                 field_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskHttpDeliveryArgs', 'SiteDeliveryTaskHttpDeliveryArgsDict']]] = None,
                 kafka_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskKafkaDeliveryArgs', 'SiteDeliveryTaskKafkaDeliveryArgsDict']]] = None,
                 oss_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskOssDeliveryArgs', 'SiteDeliveryTaskOssDeliveryArgsDict']]] = None,
                 s3_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskS3DeliveryArgs', 'SiteDeliveryTaskS3DeliveryArgsDict']]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 sls_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskSlsDeliveryArgs', 'SiteDeliveryTaskSlsDeliveryArgsDict']]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 task_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Site Delivery Task resource.

        For information about ESA Site Delivery Task and how to use it, see [What is Site Delivery Task](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateSiteDeliveryTask).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        resource_site_http_example = alicloud.esa.Site("resource_Site_http_example",
            site_name="chenxin0116.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_site_delivery_task = alicloud.esa.SiteDeliveryTask("default",
            http_delivery={
                "standard_auth_param": {
                    "private_key": "***",
                    "url_path": "v1/log/upload",
                    "expired_time": 300,
                },
                "transform_timeout": 10,
                "max_retry": 3,
                "max_batch_mb": 5,
                "compress": "gzip",
                "log_body_suffix": "cdnVersion:1.0",
                "standard_auth_on": False,
                "log_body_prefix": "cdnVersion:1.0",
                "dest_url": "http://11.177.129.13:8081",
                "max_batch_size": 1000,
            },
            data_center="oversea",
            discard_rate=0,
            task_name="dcdn-example-task",
            business_type="dcdn_log_access_l1",
            field_name="ConsoleLog,CPUTime,Duration,ErrorCode,ErrorMessage,ResponseSize,ResponseStatus,RoutineName,ClientRequestID,LogTimestamp,FetchStatus,SubRequestID",
            delivery_type="http",
            site_id=resource_site_http_example.id)
        ```

        ## Import

        ESA Site Delivery Task can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/siteDeliveryTask:SiteDeliveryTask example <site_id>:<task_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] business_type: Real-time log type. Valid values:
               - `dcdn_log_access_l1 (default)`: access log.
        :param pulumi.Input[_builtins.str] data_center: Data Center. Values:
        :param pulumi.Input[_builtins.str] delivery_type: Delivery Type:
        :param pulumi.Input[_builtins.float] discard_rate: If the discard rate is not filled, the default value is 0.
        :param pulumi.Input[_builtins.str] field_name: The list of delivery fields to be modified, separated by commas.
        :param pulumi.Input[Union['SiteDeliveryTaskHttpDeliveryArgs', 'SiteDeliveryTaskHttpDeliveryArgsDict']] http_delivery: HTTP delivery configuration parameters. See `http_delivery` below.
        :param pulumi.Input[Union['SiteDeliveryTaskKafkaDeliveryArgs', 'SiteDeliveryTaskKafkaDeliveryArgsDict']] kafka_delivery: Kafka delivery configuration parameters. See `kafka_delivery` below.
        :param pulumi.Input[Union['SiteDeliveryTaskOssDeliveryArgs', 'SiteDeliveryTaskOssDeliveryArgsDict']] oss_delivery: OSS delivery configuration. See `oss_delivery` below.
        :param pulumi.Input[Union['SiteDeliveryTaskS3DeliveryArgs', 'SiteDeliveryTaskS3DeliveryArgsDict']] s3_delivery: S3/S3 compatible delivery configuration parameters. See `s3_delivery` below.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) interface.
        :param pulumi.Input[Union['SiteDeliveryTaskSlsDeliveryArgs', 'SiteDeliveryTaskSlsDeliveryArgsDict']] sls_delivery: SLS delivery configuration. See `sls_delivery` below.
        :param pulumi.Input[_builtins.str] status: Task status, value:
        :param pulumi.Input[_builtins.str] task_name: The task name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SiteDeliveryTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Site Delivery Task resource.

        For information about ESA Site Delivery Task and how to use it, see [What is Site Delivery Task](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateSiteDeliveryTask).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        resource_site_http_example = alicloud.esa.Site("resource_Site_http_example",
            site_name="chenxin0116.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_site_delivery_task = alicloud.esa.SiteDeliveryTask("default",
            http_delivery={
                "standard_auth_param": {
                    "private_key": "***",
                    "url_path": "v1/log/upload",
                    "expired_time": 300,
                },
                "transform_timeout": 10,
                "max_retry": 3,
                "max_batch_mb": 5,
                "compress": "gzip",
                "log_body_suffix": "cdnVersion:1.0",
                "standard_auth_on": False,
                "log_body_prefix": "cdnVersion:1.0",
                "dest_url": "http://11.177.129.13:8081",
                "max_batch_size": 1000,
            },
            data_center="oversea",
            discard_rate=0,
            task_name="dcdn-example-task",
            business_type="dcdn_log_access_l1",
            field_name="ConsoleLog,CPUTime,Duration,ErrorCode,ErrorMessage,ResponseSize,ResponseStatus,RoutineName,ClientRequestID,LogTimestamp,FetchStatus,SubRequestID",
            delivery_type="http",
            site_id=resource_site_http_example.id)
        ```

        ## Import

        ESA Site Delivery Task can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/siteDeliveryTask:SiteDeliveryTask example <site_id>:<task_name>
        ```

        :param str resource_name: The name of the resource.
        :param SiteDeliveryTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SiteDeliveryTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 business_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_center: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_type: Optional[pulumi.Input[_builtins.str]] = None,
                 discard_rate: Optional[pulumi.Input[_builtins.float]] = None,
                 field_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskHttpDeliveryArgs', 'SiteDeliveryTaskHttpDeliveryArgsDict']]] = None,
                 kafka_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskKafkaDeliveryArgs', 'SiteDeliveryTaskKafkaDeliveryArgsDict']]] = None,
                 oss_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskOssDeliveryArgs', 'SiteDeliveryTaskOssDeliveryArgsDict']]] = None,
                 s3_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskS3DeliveryArgs', 'SiteDeliveryTaskS3DeliveryArgsDict']]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 sls_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskSlsDeliveryArgs', 'SiteDeliveryTaskSlsDeliveryArgsDict']]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 task_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SiteDeliveryTaskArgs.__new__(SiteDeliveryTaskArgs)

            if business_type is None and not opts.urn:
                raise TypeError("Missing required property 'business_type'")
            __props__.__dict__["business_type"] = business_type
            if data_center is None and not opts.urn:
                raise TypeError("Missing required property 'data_center'")
            __props__.__dict__["data_center"] = data_center
            if delivery_type is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_type'")
            __props__.__dict__["delivery_type"] = delivery_type
            __props__.__dict__["discard_rate"] = discard_rate
            if field_name is None and not opts.urn:
                raise TypeError("Missing required property 'field_name'")
            __props__.__dict__["field_name"] = field_name
            __props__.__dict__["http_delivery"] = http_delivery
            __props__.__dict__["kafka_delivery"] = kafka_delivery
            __props__.__dict__["oss_delivery"] = oss_delivery
            __props__.__dict__["s3_delivery"] = s3_delivery
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["sls_delivery"] = sls_delivery
            __props__.__dict__["status"] = status
            if task_name is None and not opts.urn:
                raise TypeError("Missing required property 'task_name'")
            __props__.__dict__["task_name"] = task_name
        super(SiteDeliveryTask, __self__).__init__(
            'alicloud:esa/siteDeliveryTask:SiteDeliveryTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            business_type: Optional[pulumi.Input[_builtins.str]] = None,
            data_center: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_type: Optional[pulumi.Input[_builtins.str]] = None,
            discard_rate: Optional[pulumi.Input[_builtins.float]] = None,
            field_name: Optional[pulumi.Input[_builtins.str]] = None,
            http_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskHttpDeliveryArgs', 'SiteDeliveryTaskHttpDeliveryArgsDict']]] = None,
            kafka_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskKafkaDeliveryArgs', 'SiteDeliveryTaskKafkaDeliveryArgsDict']]] = None,
            oss_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskOssDeliveryArgs', 'SiteDeliveryTaskOssDeliveryArgsDict']]] = None,
            s3_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskS3DeliveryArgs', 'SiteDeliveryTaskS3DeliveryArgsDict']]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            sls_delivery: Optional[pulumi.Input[Union['SiteDeliveryTaskSlsDeliveryArgs', 'SiteDeliveryTaskSlsDeliveryArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            task_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'SiteDeliveryTask':
        """
        Get an existing SiteDeliveryTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] business_type: Real-time log type. Valid values:
               - `dcdn_log_access_l1 (default)`: access log.
        :param pulumi.Input[_builtins.str] data_center: Data Center. Values:
        :param pulumi.Input[_builtins.str] delivery_type: Delivery Type:
        :param pulumi.Input[_builtins.float] discard_rate: If the discard rate is not filled, the default value is 0.
        :param pulumi.Input[_builtins.str] field_name: The list of delivery fields to be modified, separated by commas.
        :param pulumi.Input[Union['SiteDeliveryTaskHttpDeliveryArgs', 'SiteDeliveryTaskHttpDeliveryArgsDict']] http_delivery: HTTP delivery configuration parameters. See `http_delivery` below.
        :param pulumi.Input[Union['SiteDeliveryTaskKafkaDeliveryArgs', 'SiteDeliveryTaskKafkaDeliveryArgsDict']] kafka_delivery: Kafka delivery configuration parameters. See `kafka_delivery` below.
        :param pulumi.Input[Union['SiteDeliveryTaskOssDeliveryArgs', 'SiteDeliveryTaskOssDeliveryArgsDict']] oss_delivery: OSS delivery configuration. See `oss_delivery` below.
        :param pulumi.Input[Union['SiteDeliveryTaskS3DeliveryArgs', 'SiteDeliveryTaskS3DeliveryArgsDict']] s3_delivery: S3/S3 compatible delivery configuration parameters. See `s3_delivery` below.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) interface.
        :param pulumi.Input[Union['SiteDeliveryTaskSlsDeliveryArgs', 'SiteDeliveryTaskSlsDeliveryArgsDict']] sls_delivery: SLS delivery configuration. See `sls_delivery` below.
        :param pulumi.Input[_builtins.str] status: Task status, value:
        :param pulumi.Input[_builtins.str] task_name: The task name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SiteDeliveryTaskState.__new__(_SiteDeliveryTaskState)

        __props__.__dict__["business_type"] = business_type
        __props__.__dict__["data_center"] = data_center
        __props__.__dict__["delivery_type"] = delivery_type
        __props__.__dict__["discard_rate"] = discard_rate
        __props__.__dict__["field_name"] = field_name
        __props__.__dict__["http_delivery"] = http_delivery
        __props__.__dict__["kafka_delivery"] = kafka_delivery
        __props__.__dict__["oss_delivery"] = oss_delivery
        __props__.__dict__["s3_delivery"] = s3_delivery
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["sls_delivery"] = sls_delivery
        __props__.__dict__["status"] = status
        __props__.__dict__["task_name"] = task_name
        return SiteDeliveryTask(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="businessType")
    def business_type(self) -> pulumi.Output[_builtins.str]:
        """
        Real-time log type. Valid values:
        - `dcdn_log_access_l1 (default)`: access log.
        """
        return pulumi.get(self, "business_type")

    @_builtins.property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> pulumi.Output[_builtins.str]:
        """
        Data Center. Values:
        """
        return pulumi.get(self, "data_center")

    @_builtins.property
    @pulumi.getter(name="deliveryType")
    def delivery_type(self) -> pulumi.Output[_builtins.str]:
        """
        Delivery Type:
        """
        return pulumi.get(self, "delivery_type")

    @_builtins.property
    @pulumi.getter(name="discardRate")
    def discard_rate(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        If the discard rate is not filled, the default value is 0.
        """
        return pulumi.get(self, "discard_rate")

    @_builtins.property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> pulumi.Output[_builtins.str]:
        """
        The list of delivery fields to be modified, separated by commas.
        """
        return pulumi.get(self, "field_name")

    @_builtins.property
    @pulumi.getter(name="httpDelivery")
    def http_delivery(self) -> pulumi.Output[Optional['outputs.SiteDeliveryTaskHttpDelivery']]:
        """
        HTTP delivery configuration parameters. See `http_delivery` below.
        """
        return pulumi.get(self, "http_delivery")

    @_builtins.property
    @pulumi.getter(name="kafkaDelivery")
    def kafka_delivery(self) -> pulumi.Output[Optional['outputs.SiteDeliveryTaskKafkaDelivery']]:
        """
        Kafka delivery configuration parameters. See `kafka_delivery` below.
        """
        return pulumi.get(self, "kafka_delivery")

    @_builtins.property
    @pulumi.getter(name="ossDelivery")
    def oss_delivery(self) -> pulumi.Output[Optional['outputs.SiteDeliveryTaskOssDelivery']]:
        """
        OSS delivery configuration. See `oss_delivery` below.
        """
        return pulumi.get(self, "oss_delivery")

    @_builtins.property
    @pulumi.getter(name="s3Delivery")
    def s3_delivery(self) -> pulumi.Output[Optional['outputs.SiteDeliveryTaskS3Delivery']]:
        """
        S3/S3 compatible delivery configuration parameters. See `s3_delivery` below.
        """
        return pulumi.get(self, "s3_delivery")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID, which can be obtained by calling the [ListSites](https://help.aliyun.com/document_detail/2850189.html) interface.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="slsDelivery")
    def sls_delivery(self) -> pulumi.Output[Optional['outputs.SiteDeliveryTaskSlsDelivery']]:
        """
        SLS delivery configuration. See `sls_delivery` below.
        """
        return pulumi.get(self, "sls_delivery")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Task status, value:
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="taskName")
    def task_name(self) -> pulumi.Output[_builtins.str]:
        """
        The task name.
        """
        return pulumi.get(self, "task_name")

