# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TransportLayerApplicationArgs', 'TransportLayerApplication']

@pulumi.input_type
class TransportLayerApplicationArgs:
    def __init__(__self__, *,
                 record_name: pulumi.Input[_builtins.str],
                 rules: pulumi.Input[Sequence[pulumi.Input['TransportLayerApplicationRuleArgs']]],
                 site_id: pulumi.Input[_builtins.int],
                 cross_border_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_access_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TransportLayerApplication resource.
        :param pulumi.Input[_builtins.str] record_name: Domain name of the transport layer application
        :param pulumi.Input[Sequence[pulumi.Input['TransportLayerApplicationRuleArgs']]] rules: The list of forwarding rules. Rule details. For each rule, other parameters are required except comments. See `rules` below.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        :param pulumi.Input[_builtins.str] cross_border_optimization: Whether to enable China mainland network access optimization, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] ip_access_rule: IP access rule switch. When enabled, the WAF's IP access rules apply to the transport layer application.
        :param pulumi.Input[_builtins.str] ipv6: IPv6 switch.
        """
        pulumi.set(__self__, "record_name", record_name)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "site_id", site_id)
        if cross_border_optimization is not None:
            pulumi.set(__self__, "cross_border_optimization", cross_border_optimization)
        if ip_access_rule is not None:
            pulumi.set(__self__, "ip_access_rule", ip_access_rule)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)

    @_builtins.property
    @pulumi.getter(name="recordName")
    def record_name(self) -> pulumi.Input[_builtins.str]:
        """
        Domain name of the transport layer application
        """
        return pulumi.get(self, "record_name")

    @record_name.setter
    def record_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "record_name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['TransportLayerApplicationRuleArgs']]]:
        """
        The list of forwarding rules. Rule details. For each rule, other parameters are required except comments. See `rules` below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['TransportLayerApplicationRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="crossBorderOptimization")
    def cross_border_optimization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable China mainland network access optimization, default is disabled. Value range:
        """
        return pulumi.get(self, "cross_border_optimization")

    @cross_border_optimization.setter
    def cross_border_optimization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_border_optimization", value)

    @_builtins.property
    @pulumi.getter(name="ipAccessRule")
    def ip_access_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP access rule switch. When enabled, the WAF's IP access rules apply to the transport layer application.
        """
        return pulumi.get(self, "ip_access_rule")

    @ip_access_rule.setter
    def ip_access_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_access_rule", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 switch.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6", value)


@pulumi.input_type
class _TransportLayerApplicationState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[_builtins.int]] = None,
                 cross_border_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_access_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 record_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['TransportLayerApplicationRuleArgs']]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TransportLayerApplication resources.
        :param pulumi.Input[_builtins.int] application_id: Layer 4 application ID.
        :param pulumi.Input[_builtins.str] cross_border_optimization: Whether to enable China mainland network access optimization, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] ip_access_rule: IP access rule switch. When enabled, the WAF's IP access rules apply to the transport layer application.
        :param pulumi.Input[_builtins.str] ipv6: IPv6 switch.
        :param pulumi.Input[_builtins.str] record_name: Domain name of the transport layer application
        :param pulumi.Input[Sequence[pulumi.Input['TransportLayerApplicationRuleArgs']]] rules: The list of forwarding rules. Rule details. For each rule, other parameters are required except comments. See `rules` below.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        :param pulumi.Input[_builtins.str] status: Status of the transport layer application, modification and deletion are not allowed.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if cross_border_optimization is not None:
            pulumi.set(__self__, "cross_border_optimization", cross_border_optimization)
        if ip_access_rule is not None:
            pulumi.set(__self__, "ip_access_rule", ip_access_rule)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Layer 4 application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="crossBorderOptimization")
    def cross_border_optimization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable China mainland network access optimization, default is disabled. Value range:
        """
        return pulumi.get(self, "cross_border_optimization")

    @cross_border_optimization.setter
    def cross_border_optimization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_border_optimization", value)

    @_builtins.property
    @pulumi.getter(name="ipAccessRule")
    def ip_access_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP access rule switch. When enabled, the WAF's IP access rules apply to the transport layer application.
        """
        return pulumi.get(self, "ip_access_rule")

    @ip_access_rule.setter
    def ip_access_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_access_rule", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 switch.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name of the transport layer application
        """
        return pulumi.get(self, "record_name")

    @record_name.setter
    def record_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportLayerApplicationRuleArgs']]]]:
        """
        The list of forwarding rules. Rule details. For each rule, other parameters are required except comments. See `rules` below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportLayerApplicationRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the transport layer application, modification and deletion are not allowed.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:esa/transportLayerApplication:TransportLayerApplication")
class TransportLayerApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cross_border_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_access_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 record_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportLayerApplicationRuleArgs', 'TransportLayerApplicationRuleArgsDict']]]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Import

        ESA Transport Layer Application can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/transportLayerApplication:TransportLayerApplication example <site_id>:<application_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cross_border_optimization: Whether to enable China mainland network access optimization, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] ip_access_rule: IP access rule switch. When enabled, the WAF's IP access rules apply to the transport layer application.
        :param pulumi.Input[_builtins.str] ipv6: IPv6 switch.
        :param pulumi.Input[_builtins.str] record_name: Domain name of the transport layer application
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportLayerApplicationRuleArgs', 'TransportLayerApplicationRuleArgsDict']]]] rules: The list of forwarding rules. Rule details. For each rule, other parameters are required except comments. See `rules` below.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransportLayerApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ESA Transport Layer Application can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/transportLayerApplication:TransportLayerApplication example <site_id>:<application_id>
        ```

        :param str resource_name: The name of the resource.
        :param TransportLayerApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransportLayerApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cross_border_optimization: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_access_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6: Optional[pulumi.Input[_builtins.str]] = None,
                 record_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportLayerApplicationRuleArgs', 'TransportLayerApplicationRuleArgsDict']]]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransportLayerApplicationArgs.__new__(TransportLayerApplicationArgs)

            __props__.__dict__["cross_border_optimization"] = cross_border_optimization
            __props__.__dict__["ip_access_rule"] = ip_access_rule
            __props__.__dict__["ipv6"] = ipv6
            if record_name is None and not opts.urn:
                raise TypeError("Missing required property 'record_name'")
            __props__.__dict__["record_name"] = record_name
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["application_id"] = None
            __props__.__dict__["status"] = None
        super(TransportLayerApplication, __self__).__init__(
            'alicloud:esa/transportLayerApplication:TransportLayerApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[_builtins.int]] = None,
            cross_border_optimization: Optional[pulumi.Input[_builtins.str]] = None,
            ip_access_rule: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6: Optional[pulumi.Input[_builtins.str]] = None,
            record_name: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportLayerApplicationRuleArgs', 'TransportLayerApplicationRuleArgsDict']]]]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'TransportLayerApplication':
        """
        Get an existing TransportLayerApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] application_id: Layer 4 application ID.
        :param pulumi.Input[_builtins.str] cross_border_optimization: Whether to enable China mainland network access optimization, default is disabled. Value range:
        :param pulumi.Input[_builtins.str] ip_access_rule: IP access rule switch. When enabled, the WAF's IP access rules apply to the transport layer application.
        :param pulumi.Input[_builtins.str] ipv6: IPv6 switch.
        :param pulumi.Input[_builtins.str] record_name: Domain name of the transport layer application
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportLayerApplicationRuleArgs', 'TransportLayerApplicationRuleArgsDict']]]] rules: The list of forwarding rules. Rule details. For each rule, other parameters are required except comments. See `rules` below.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        :param pulumi.Input[_builtins.str] status: Status of the transport layer application, modification and deletion are not allowed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransportLayerApplicationState.__new__(_TransportLayerApplicationState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["cross_border_optimization"] = cross_border_optimization
        __props__.__dict__["ip_access_rule"] = ip_access_rule
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["record_name"] = record_name
        __props__.__dict__["rules"] = rules
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["status"] = status
        return TransportLayerApplication(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.int]:
        """
        Layer 4 application ID.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="crossBorderOptimization")
    def cross_border_optimization(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable China mainland network access optimization, default is disabled. Value range:
        """
        return pulumi.get(self, "cross_border_optimization")

    @_builtins.property
    @pulumi.getter(name="ipAccessRule")
    def ip_access_rule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IP access rule switch. When enabled, the WAF's IP access rules apply to the transport layer application.
        """
        return pulumi.get(self, "ip_access_rule")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IPv6 switch.
        """
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter(name="recordName")
    def record_name(self) -> pulumi.Output[_builtins.str]:
        """
        Domain name of the transport layer application
        """
        return pulumi.get(self, "record_name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.TransportLayerApplicationRule']]:
        """
        The list of forwarding rules. Rule details. For each rule, other parameters are required except comments. See `rules` below.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the transport layer application, modification and deletion are not allowed.
        """
        return pulumi.get(self, "status")

