# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WafRuleArgs', 'WafRule']

@pulumi.input_type
class WafRuleArgs:
    def __init__(__self__, *,
                 phase: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 config: Optional[pulumi.Input['WafRuleConfigArgs']] = None,
                 ruleset_id: Optional[pulumi.Input[_builtins.int]] = None,
                 shared: Optional[pulumi.Input['WafRuleSharedArgs']] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a WafRule resource.
        :param pulumi.Input[_builtins.str] phase: The phase in which the WAF processes this rule.
        :param pulumi.Input[_builtins.int] site_id: The unique identifier of the website, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input['WafRuleConfigArgs'] config: The specific configuration of the WAF rule. See `config` below.
        :param pulumi.Input[_builtins.int] ruleset_id: The ID of the WAF ruleset, which can be obtained by calling the [ListWafRulesets](https://www.alibabacloud.com/help/en/doc-detail/2850233.html) operation.
        :param pulumi.Input['WafRuleSharedArgs'] shared: Shared configuration attributes used across multiple rules. **Note: The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.** See `shared` below.
        :param pulumi.Input[_builtins.int] site_version: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        pulumi.set(__self__, "phase", phase)
        pulumi.set(__self__, "site_id", site_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if ruleset_id is not None:
            pulumi.set(__self__, "ruleset_id", ruleset_id)
        if shared is not None:
            pulumi.set(__self__, "shared", shared)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)

    @_builtins.property
    @pulumi.getter
    def phase(self) -> pulumi.Input[_builtins.str]:
        """
        The phase in which the WAF processes this rule.
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "phase", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The unique identifier of the website, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['WafRuleConfigArgs']]:
        """
        The specific configuration of the WAF rule. See `config` below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['WafRuleConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="rulesetId")
    def ruleset_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the WAF ruleset, which can be obtained by calling the [ListWafRulesets](https://www.alibabacloud.com/help/en/doc-detail/2850233.html) operation.
        """
        return pulumi.get(self, "ruleset_id")

    @ruleset_id.setter
    def ruleset_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ruleset_id", value)

    @_builtins.property
    @pulumi.getter
    def shared(self) -> Optional[pulumi.Input['WafRuleSharedArgs']]:
        """
        Shared configuration attributes used across multiple rules. **Note: The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.** See `shared` below.
        """
        return pulumi.get(self, "shared")

    @shared.setter
    def shared(self, value: Optional[pulumi.Input['WafRuleSharedArgs']]):
        pulumi.set(self, "shared", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)


@pulumi.input_type
class _WafRuleState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['WafRuleConfigArgs']] = None,
                 phase: Optional[pulumi.Input[_builtins.str]] = None,
                 ruleset_id: Optional[pulumi.Input[_builtins.int]] = None,
                 shared: Optional[pulumi.Input['WafRuleSharedArgs']] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 waf_rule_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering WafRule resources.
        :param pulumi.Input['WafRuleConfigArgs'] config: The specific configuration of the WAF rule. See `config` below.
        :param pulumi.Input[_builtins.str] phase: The phase in which the WAF processes this rule.
        :param pulumi.Input[_builtins.int] ruleset_id: The ID of the WAF ruleset, which can be obtained by calling the [ListWafRulesets](https://www.alibabacloud.com/help/en/doc-detail/2850233.html) operation.
        :param pulumi.Input['WafRuleSharedArgs'] shared: Shared configuration attributes used across multiple rules. **Note: The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.** See `shared` below.
        :param pulumi.Input[_builtins.int] site_id: The unique identifier of the website, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] waf_rule_id: The unique identifier of the WAF rule.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if ruleset_id is not None:
            pulumi.set(__self__, "ruleset_id", ruleset_id)
        if shared is not None:
            pulumi.set(__self__, "shared", shared)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_version is not None:
            pulumi.set(__self__, "site_version", site_version)
        if waf_rule_id is not None:
            pulumi.set(__self__, "waf_rule_id", waf_rule_id)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['WafRuleConfigArgs']]:
        """
        The specific configuration of the WAF rule. See `config` below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['WafRuleConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def phase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The phase in which the WAF processes this rule.
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phase", value)

    @_builtins.property
    @pulumi.getter(name="rulesetId")
    def ruleset_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the WAF ruleset, which can be obtained by calling the [ListWafRulesets](https://www.alibabacloud.com/help/en/doc-detail/2850233.html) operation.
        """
        return pulumi.get(self, "ruleset_id")

    @ruleset_id.setter
    def ruleset_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ruleset_id", value)

    @_builtins.property
    @pulumi.getter
    def shared(self) -> Optional[pulumi.Input['WafRuleSharedArgs']]:
        """
        Shared configuration attributes used across multiple rules. **Note: The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.** See `shared` below.
        """
        return pulumi.get(self, "shared")

    @shared.setter
    def shared(self, value: Optional[pulumi.Input['WafRuleSharedArgs']]):
        pulumi.set(self, "shared", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier of the website, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_version")

    @site_version.setter
    def site_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_version", value)

    @_builtins.property
    @pulumi.getter(name="wafRuleId")
    def waf_rule_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier of the WAF rule.
        """
        return pulumi.get(self, "waf_rule_id")

    @waf_rule_id.setter
    def waf_rule_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "waf_rule_id", value)


@pulumi.type_token("alicloud:esa/wafRule:WafRule")
class WafRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['WafRuleConfigArgs', 'WafRuleConfigArgsDict']]] = None,
                 phase: Optional[pulumi.Input[_builtins.str]] = None,
                 ruleset_id: Optional[pulumi.Input[_builtins.int]] = None,
                 shared: Optional[pulumi.Input[Union['WafRuleSharedArgs', 'WafRuleSharedArgsDict']]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Waf Rule resource.

        The detailed configuration of a Web Application Firewall (WAF) rule.

        For information about ESA Waf Rule and how to use it, see [What is Waf Rule](https://next.api.alibabacloud.com/document/ESA/2024-09-10/BatchCreateWafRules).

        > **NOTE:** Available since v1.261.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_waf_ruleset = alicloud.esa.WafRuleset("default",
            site_id=default.sites[0].site_id,
            phase="http_custom",
            site_version=0)
        default_waf_rule = alicloud.esa.WafRule("default",
            ruleset_id=default_waf_ruleset.ruleset_id,
            phase="http_custom",
            config={
                "status": "on",
                "action": "deny",
                "expression": "(http.host in {\\"123.example.top\\"})",
                "actions": {
                    "response": {
                        "id": 0,
                        "code": 403,
                    },
                },
                "name": "111",
            },
            site_version=0,
            site_id=default.sites[0].site_id)
        ```

        ## Import

        ESA Waf Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/wafRule:WafRule example <site_id>:<waf_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WafRuleConfigArgs', 'WafRuleConfigArgsDict']] config: The specific configuration of the WAF rule. See `config` below.
        :param pulumi.Input[_builtins.str] phase: The phase in which the WAF processes this rule.
        :param pulumi.Input[_builtins.int] ruleset_id: The ID of the WAF ruleset, which can be obtained by calling the [ListWafRulesets](https://www.alibabacloud.com/help/en/doc-detail/2850233.html) operation.
        :param pulumi.Input[Union['WafRuleSharedArgs', 'WafRuleSharedArgsDict']] shared: Shared configuration attributes used across multiple rules. **Note: The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.** See `shared` below.
        :param pulumi.Input[_builtins.int] site_id: The unique identifier of the website, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WafRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Waf Rule resource.

        The detailed configuration of a Web Application Firewall (WAF) rule.

        For information about ESA Waf Rule and how to use it, see [What is Waf Rule](https://next.api.alibabacloud.com/document/ESA/2024-09-10/BatchCreateWafRules).

        > **NOTE:** Available since v1.261.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_waf_ruleset = alicloud.esa.WafRuleset("default",
            site_id=default.sites[0].site_id,
            phase="http_custom",
            site_version=0)
        default_waf_rule = alicloud.esa.WafRule("default",
            ruleset_id=default_waf_ruleset.ruleset_id,
            phase="http_custom",
            config={
                "status": "on",
                "action": "deny",
                "expression": "(http.host in {\\"123.example.top\\"})",
                "actions": {
                    "response": {
                        "id": 0,
                        "code": 403,
                    },
                },
                "name": "111",
            },
            site_version=0,
            site_id=default.sites[0].site_id)
        ```

        ## Import

        ESA Waf Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/wafRule:WafRule example <site_id>:<waf_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param WafRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WafRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['WafRuleConfigArgs', 'WafRuleConfigArgsDict']]] = None,
                 phase: Optional[pulumi.Input[_builtins.str]] = None,
                 ruleset_id: Optional[pulumi.Input[_builtins.int]] = None,
                 shared: Optional[pulumi.Input[Union['WafRuleSharedArgs', 'WafRuleSharedArgsDict']]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 site_version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WafRuleArgs.__new__(WafRuleArgs)

            __props__.__dict__["config"] = config
            if phase is None and not opts.urn:
                raise TypeError("Missing required property 'phase'")
            __props__.__dict__["phase"] = phase
            __props__.__dict__["ruleset_id"] = ruleset_id
            __props__.__dict__["shared"] = shared
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["site_version"] = site_version
            __props__.__dict__["waf_rule_id"] = None
        super(WafRule, __self__).__init__(
            'alicloud:esa/wafRule:WafRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['WafRuleConfigArgs', 'WafRuleConfigArgsDict']]] = None,
            phase: Optional[pulumi.Input[_builtins.str]] = None,
            ruleset_id: Optional[pulumi.Input[_builtins.int]] = None,
            shared: Optional[pulumi.Input[Union['WafRuleSharedArgs', 'WafRuleSharedArgsDict']]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            site_version: Optional[pulumi.Input[_builtins.int]] = None,
            waf_rule_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'WafRule':
        """
        Get an existing WafRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WafRuleConfigArgs', 'WafRuleConfigArgsDict']] config: The specific configuration of the WAF rule. See `config` below.
        :param pulumi.Input[_builtins.str] phase: The phase in which the WAF processes this rule.
        :param pulumi.Input[_builtins.int] ruleset_id: The ID of the WAF ruleset, which can be obtained by calling the [ListWafRulesets](https://www.alibabacloud.com/help/en/doc-detail/2850233.html) operation.
        :param pulumi.Input[Union['WafRuleSharedArgs', 'WafRuleSharedArgsDict']] shared: Shared configuration attributes used across multiple rules. **Note: The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.** See `shared` below.
        :param pulumi.Input[_builtins.int] site_id: The unique identifier of the website, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] site_version: The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        :param pulumi.Input[_builtins.int] waf_rule_id: The unique identifier of the WAF rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WafRuleState.__new__(_WafRuleState)

        __props__.__dict__["config"] = config
        __props__.__dict__["phase"] = phase
        __props__.__dict__["ruleset_id"] = ruleset_id
        __props__.__dict__["shared"] = shared
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_version"] = site_version
        __props__.__dict__["waf_rule_id"] = waf_rule_id
        return WafRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional['outputs.WafRuleConfig']]:
        """
        The specific configuration of the WAF rule. See `config` below.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def phase(self) -> pulumi.Output[_builtins.str]:
        """
        The phase in which the WAF processes this rule.
        """
        return pulumi.get(self, "phase")

    @_builtins.property
    @pulumi.getter(name="rulesetId")
    def ruleset_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of the WAF ruleset, which can be obtained by calling the [ListWafRulesets](https://www.alibabacloud.com/help/en/doc-detail/2850233.html) operation.
        """
        return pulumi.get(self, "ruleset_id")

    @_builtins.property
    @pulumi.getter
    def shared(self) -> pulumi.Output[Optional['outputs.WafRuleShared']]:
        """
        Shared configuration attributes used across multiple rules. **Note: The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.** See `shared` below.
        """
        return pulumi.get(self, "shared")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier of the website, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteVersion")
    def site_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The website ID, which can be obtained by calling the [ListSites](https://www.alibabacloud.com/help/en/doc-detail/2850189.html) operation.
        """
        return pulumi.get(self, "site_version")

    @_builtins.property
    @pulumi.getter(name="wafRuleId")
    def waf_rule_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier of the WAF rule.
        """
        return pulumi.get(self, "waf_rule_id")

