# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AlbServerGroupAttachmentArgs', 'AlbServerGroupAttachment']

@pulumi.input_type
class AlbServerGroupAttachmentArgs:
    def __init__(__self__, *,
                 alb_server_group_id: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int],
                 scaling_group_id: pulumi.Input[_builtins.str],
                 weight: pulumi.Input[_builtins.int],
                 force_attach: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a AlbServerGroupAttachment resource.
        :param pulumi.Input[_builtins.str] alb_server_group_id: ID of Alb Server Group.
        :param pulumi.Input[_builtins.int] port: The port will be used for Alb Server Group backend server.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group.
        :param pulumi.Input[_builtins.int] weight: The weight of an ECS instance attached to the Alb Server Group.
        :param pulumi.Input[_builtins.bool] force_attach: If instances of scaling group are attached/removed from slb backend server when attach/detach alb
               server group from scaling group. Default to false.
        """
        pulumi.set(__self__, "alb_server_group_id", alb_server_group_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "weight", weight)
        if force_attach is not None:
            pulumi.set(__self__, "force_attach", force_attach)

    @_builtins.property
    @pulumi.getter(name="albServerGroupId")
    def alb_server_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of Alb Server Group.
        """
        return pulumi.get(self, "alb_server_group_id")

    @alb_server_group_id.setter
    def alb_server_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alb_server_group_id", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The port will be used for Alb Server Group backend server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> pulumi.Input[_builtins.int]:
        """
        The weight of an ECS instance attached to the Alb Server Group.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "weight", value)

    @_builtins.property
    @pulumi.getter(name="forceAttach")
    def force_attach(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If instances of scaling group are attached/removed from slb backend server when attach/detach alb
        server group from scaling group. Default to false.
        """
        return pulumi.get(self, "force_attach")

    @force_attach.setter
    def force_attach(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_attach", value)


@pulumi.input_type
class _AlbServerGroupAttachmentState:
    def __init__(__self__, *,
                 alb_server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_attach: Optional[pulumi.Input[_builtins.bool]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering AlbServerGroupAttachment resources.
        :param pulumi.Input[_builtins.str] alb_server_group_id: ID of Alb Server Group.
        :param pulumi.Input[_builtins.bool] force_attach: If instances of scaling group are attached/removed from slb backend server when attach/detach alb
               server group from scaling group. Default to false.
        :param pulumi.Input[_builtins.int] port: The port will be used for Alb Server Group backend server.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group.
        :param pulumi.Input[_builtins.int] weight: The weight of an ECS instance attached to the Alb Server Group.
        """
        if alb_server_group_id is not None:
            pulumi.set(__self__, "alb_server_group_id", alb_server_group_id)
        if force_attach is not None:
            pulumi.set(__self__, "force_attach", force_attach)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="albServerGroupId")
    def alb_server_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of Alb Server Group.
        """
        return pulumi.get(self, "alb_server_group_id")

    @alb_server_group_id.setter
    def alb_server_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alb_server_group_id", value)

    @_builtins.property
    @pulumi.getter(name="forceAttach")
    def force_attach(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If instances of scaling group are attached/removed from slb backend server when attach/detach alb
        server group from scaling group. Default to false.
        """
        return pulumi.get(self, "force_attach")

    @force_attach.setter
    def force_attach(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_attach", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port will be used for Alb Server Group backend server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The weight of an ECS instance attached to the Alb Server Group.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.type_token("alicloud:ess/albServerGroupAttachment:AlbServerGroupAttachment")
class AlbServerGroupAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alb_server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_attach: Optional[pulumi.Input[_builtins.bool]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Attaches/Detaches alb server group to a specified scaling group.

        For information about alb server group attachment, see [AttachAlbServerGroups](https://www.alibabacloud.com/help/en/doc-detail/266800.html).

        > **NOTE:** If scaling group's network type is `VPC`, the alb server groups must be in the same `VPC`.

        > **NOTE:** Alb server group attachment is defined uniquely by `scaling_group_id`, `alb_server_group_id`, `port`.

        > **NOTE:** Resource `ess.AlbServerGroupAttachment` don't support modification.

        > **NOTE:** Available since v1.158.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=my_name,
            vpc_id=default_network.id)
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=0,
            max_size=2,
            scaling_group_name=my_name,
            default_cooldown=200,
            removal_policies=["OldestInstance"],
            vswitch_ids=[default_switch.id])
        default_scaling_configuration = alicloud.ess.ScalingConfiguration("default",
            scaling_group_id=default_scaling_group.id,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_group_id=default_security_group.id,
            force_delete=True,
            active=True,
            enable=True)
        default_server_group = alicloud.alb.ServerGroup("default",
            server_group_name=my_name,
            vpc_id=default_network.id,
            health_check_config={
                "health_check_enabled": False,
            },
            sticky_session_config={
                "sticky_session_enabled": True,
                "cookie": "tf-example",
                "sticky_session_type": "Server",
            })
        default_alb_server_group_attachment = alicloud.ess.AlbServerGroupAttachment("default",
            scaling_group_id=default_scaling_configuration.scaling_group_id,
            alb_server_group_id=default_server_group.id,
            port=9000,
            weight=50,
            force_attach=True)
        ```

        ## Import

        ESS alb server groups can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/albServerGroupAttachment:AlbServerGroupAttachment example asg-xxx:sgp-xxx:5000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alb_server_group_id: ID of Alb Server Group.
        :param pulumi.Input[_builtins.bool] force_attach: If instances of scaling group are attached/removed from slb backend server when attach/detach alb
               server group from scaling group. Default to false.
        :param pulumi.Input[_builtins.int] port: The port will be used for Alb Server Group backend server.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group.
        :param pulumi.Input[_builtins.int] weight: The weight of an ECS instance attached to the Alb Server Group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlbServerGroupAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attaches/Detaches alb server group to a specified scaling group.

        For information about alb server group attachment, see [AttachAlbServerGroups](https://www.alibabacloud.com/help/en/doc-detail/266800.html).

        > **NOTE:** If scaling group's network type is `VPC`, the alb server groups must be in the same `VPC`.

        > **NOTE:** Alb server group attachment is defined uniquely by `scaling_group_id`, `alb_server_group_id`, `port`.

        > **NOTE:** Resource `ess.AlbServerGroupAttachment` don't support modification.

        > **NOTE:** Available since v1.158.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=my_name,
            vpc_id=default_network.id)
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=0,
            max_size=2,
            scaling_group_name=my_name,
            default_cooldown=200,
            removal_policies=["OldestInstance"],
            vswitch_ids=[default_switch.id])
        default_scaling_configuration = alicloud.ess.ScalingConfiguration("default",
            scaling_group_id=default_scaling_group.id,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_group_id=default_security_group.id,
            force_delete=True,
            active=True,
            enable=True)
        default_server_group = alicloud.alb.ServerGroup("default",
            server_group_name=my_name,
            vpc_id=default_network.id,
            health_check_config={
                "health_check_enabled": False,
            },
            sticky_session_config={
                "sticky_session_enabled": True,
                "cookie": "tf-example",
                "sticky_session_type": "Server",
            })
        default_alb_server_group_attachment = alicloud.ess.AlbServerGroupAttachment("default",
            scaling_group_id=default_scaling_configuration.scaling_group_id,
            alb_server_group_id=default_server_group.id,
            port=9000,
            weight=50,
            force_attach=True)
        ```

        ## Import

        ESS alb server groups can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/albServerGroupAttachment:AlbServerGroupAttachment example asg-xxx:sgp-xxx:5000
        ```

        :param str resource_name: The name of the resource.
        :param AlbServerGroupAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlbServerGroupAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alb_server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_attach: Optional[pulumi.Input[_builtins.bool]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlbServerGroupAttachmentArgs.__new__(AlbServerGroupAttachmentArgs)

            if alb_server_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'alb_server_group_id'")
            __props__.__dict__["alb_server_group_id"] = alb_server_group_id
            __props__.__dict__["force_attach"] = force_attach
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            if weight is None and not opts.urn:
                raise TypeError("Missing required property 'weight'")
            __props__.__dict__["weight"] = weight
        super(AlbServerGroupAttachment, __self__).__init__(
            'alicloud:ess/albServerGroupAttachment:AlbServerGroupAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alb_server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_attach: Optional[pulumi.Input[_builtins.bool]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            weight: Optional[pulumi.Input[_builtins.int]] = None) -> 'AlbServerGroupAttachment':
        """
        Get an existing AlbServerGroupAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alb_server_group_id: ID of Alb Server Group.
        :param pulumi.Input[_builtins.bool] force_attach: If instances of scaling group are attached/removed from slb backend server when attach/detach alb
               server group from scaling group. Default to false.
        :param pulumi.Input[_builtins.int] port: The port will be used for Alb Server Group backend server.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group.
        :param pulumi.Input[_builtins.int] weight: The weight of an ECS instance attached to the Alb Server Group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlbServerGroupAttachmentState.__new__(_AlbServerGroupAttachmentState)

        __props__.__dict__["alb_server_group_id"] = alb_server_group_id
        __props__.__dict__["force_attach"] = force_attach
        __props__.__dict__["port"] = port
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["weight"] = weight
        return AlbServerGroupAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="albServerGroupId")
    def alb_server_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of Alb Server Group.
        """
        return pulumi.get(self, "alb_server_group_id")

    @_builtins.property
    @pulumi.getter(name="forceAttach")
    def force_attach(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If instances of scaling group are attached/removed from slb backend server when attach/detach alb
        server group from scaling group. Default to false.
        """
        return pulumi.get(self, "force_attach")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The port will be used for Alb Server Group backend server.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> pulumi.Output[_builtins.int]:
        """
        The weight of an ECS instance attached to the Alb Server Group.
        """
        return pulumi.get(self, "weight")

