# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceRefreshArgs', 'InstanceRefresh']

@pulumi.input_type
class InstanceRefreshArgs:
    def __init__(__self__, *,
                 scaling_group_id: pulumi.Input[_builtins.str],
                 checkpoint_pause_time: Optional[pulumi.Input[_builtins.int]] = None,
                 checkpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshCheckpointArgs']]]] = None,
                 desired_configuration_containers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationContainerArgs']]]] = None,
                 desired_configuration_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_configuration_launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_configuration_launch_template_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs']]]] = None,
                 desired_configuration_launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_healthy_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 min_healthy_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 skip_matching: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceRefresh resource.
        :param pulumi.Input[_builtins.str] scaling_group_id: The ID of the scaling group.
        :param pulumi.Input[_builtins.int] checkpoint_pause_time: The duration of the pause when the task reaches a checkpoint. Unit: minutes.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceRefreshCheckpointArgs']]] checkpoints: The checkpoints for the refresh task. The task automatically pauses for the duration specified by CheckpointPauseTime when the percentage of new instances reaches a specified value. See `checkpoints` below for details.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationContainerArgs']]] desired_configuration_containers: The list of containers in the instance. See `desired_configuration_containers` below for details.
        :param pulumi.Input[_builtins.str] desired_configuration_image_id: The ID of the image file. This is the image resource used for automatic instance creation.
        :param pulumi.Input[_builtins.str] desired_configuration_launch_template_id: The ID of the launch template. The scaling group uses this template to obtain launch configuration information.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs']]] desired_configuration_launch_template_overrides: The instance type information in the launch template overrides. See `desired_configuration_launch_template_overrides` below for details.
        :param pulumi.Input[_builtins.str] desired_configuration_launch_template_version: The version of the launch template.
        :param pulumi.Input[_builtins.int] max_healthy_percentage: The percentage by which the number of instances in the scaling group can exceed the group's capacity during the instance refresh.
        :param pulumi.Input[_builtins.int] min_healthy_percentage: The percentage of instances that must be healthy in the scaling group during the instance refresh. The value is a percentage of the scaling group's capacity.
        :param pulumi.Input[_builtins.bool] skip_matching: Indicates whether to skip instances that match the desired configuration.
        :param pulumi.Input[_builtins.str] status: The current status of the instance refresh task. Possible values:
               - Pending: The instance refresh task is created and waiting to be scheduled.
               - InProgress: The instance refresh task is in progress.
               - Paused: The instance refresh task is paused.
               - CheckpointPause: The task is paused because it has reached a checkpoint (Checkpoint.Percentage).
               - Failed: The instance refresh task failed.
               - Successful: The instance refresh task was successful.
               - Cancelling: The instance refresh task is being canceled.
               - RollbackInProgress: The instance refresh task is being rolled back.
               - RollbackSuccessful: The instance refresh task was rolled back successfully. Set RollbackSuccessful to rollback the instance refresh task.
               - RollbackFailed: The rollback of the instance refresh task failed.
               - Cancelled:  The instance refresh task is canceled. Set Cancelled to cancel the instance refresh task.
        """
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if checkpoint_pause_time is not None:
            pulumi.set(__self__, "checkpoint_pause_time", checkpoint_pause_time)
        if checkpoints is not None:
            pulumi.set(__self__, "checkpoints", checkpoints)
        if desired_configuration_containers is not None:
            pulumi.set(__self__, "desired_configuration_containers", desired_configuration_containers)
        if desired_configuration_image_id is not None:
            pulumi.set(__self__, "desired_configuration_image_id", desired_configuration_image_id)
        if desired_configuration_launch_template_id is not None:
            pulumi.set(__self__, "desired_configuration_launch_template_id", desired_configuration_launch_template_id)
        if desired_configuration_launch_template_overrides is not None:
            pulumi.set(__self__, "desired_configuration_launch_template_overrides", desired_configuration_launch_template_overrides)
        if desired_configuration_launch_template_version is not None:
            pulumi.set(__self__, "desired_configuration_launch_template_version", desired_configuration_launch_template_version)
        if max_healthy_percentage is not None:
            pulumi.set(__self__, "max_healthy_percentage", max_healthy_percentage)
        if min_healthy_percentage is not None:
            pulumi.set(__self__, "min_healthy_percentage", min_healthy_percentage)
        if skip_matching is not None:
            pulumi.set(__self__, "skip_matching", skip_matching)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="checkpointPauseTime")
    def checkpoint_pause_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of the pause when the task reaches a checkpoint. Unit: minutes.
        """
        return pulumi.get(self, "checkpoint_pause_time")

    @checkpoint_pause_time.setter
    def checkpoint_pause_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "checkpoint_pause_time", value)

    @_builtins.property
    @pulumi.getter
    def checkpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshCheckpointArgs']]]]:
        """
        The checkpoints for the refresh task. The task automatically pauses for the duration specified by CheckpointPauseTime when the percentage of new instances reaches a specified value. See `checkpoints` below for details.
        """
        return pulumi.get(self, "checkpoints")

    @checkpoints.setter
    def checkpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshCheckpointArgs']]]]):
        pulumi.set(self, "checkpoints", value)

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationContainers")
    def desired_configuration_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationContainerArgs']]]]:
        """
        The list of containers in the instance. See `desired_configuration_containers` below for details.
        """
        return pulumi.get(self, "desired_configuration_containers")

    @desired_configuration_containers.setter
    def desired_configuration_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationContainerArgs']]]]):
        pulumi.set(self, "desired_configuration_containers", value)

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationImageId")
    def desired_configuration_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the image file. This is the image resource used for automatic instance creation.
        """
        return pulumi.get(self, "desired_configuration_image_id")

    @desired_configuration_image_id.setter
    def desired_configuration_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_configuration_image_id", value)

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationLaunchTemplateId")
    def desired_configuration_launch_template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the launch template. The scaling group uses this template to obtain launch configuration information.
        """
        return pulumi.get(self, "desired_configuration_launch_template_id")

    @desired_configuration_launch_template_id.setter
    def desired_configuration_launch_template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_configuration_launch_template_id", value)

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationLaunchTemplateOverrides")
    def desired_configuration_launch_template_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs']]]]:
        """
        The instance type information in the launch template overrides. See `desired_configuration_launch_template_overrides` below for details.
        """
        return pulumi.get(self, "desired_configuration_launch_template_overrides")

    @desired_configuration_launch_template_overrides.setter
    def desired_configuration_launch_template_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs']]]]):
        pulumi.set(self, "desired_configuration_launch_template_overrides", value)

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationLaunchTemplateVersion")
    def desired_configuration_launch_template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the launch template.
        """
        return pulumi.get(self, "desired_configuration_launch_template_version")

    @desired_configuration_launch_template_version.setter
    def desired_configuration_launch_template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_configuration_launch_template_version", value)

    @_builtins.property
    @pulumi.getter(name="maxHealthyPercentage")
    def max_healthy_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage by which the number of instances in the scaling group can exceed the group's capacity during the instance refresh.
        """
        return pulumi.get(self, "max_healthy_percentage")

    @max_healthy_percentage.setter
    def max_healthy_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_healthy_percentage", value)

    @_builtins.property
    @pulumi.getter(name="minHealthyPercentage")
    def min_healthy_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of instances that must be healthy in the scaling group during the instance refresh. The value is a percentage of the scaling group's capacity.
        """
        return pulumi.get(self, "min_healthy_percentage")

    @min_healthy_percentage.setter
    def min_healthy_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_healthy_percentage", value)

    @_builtins.property
    @pulumi.getter(name="skipMatching")
    def skip_matching(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to skip instances that match the desired configuration.
        """
        return pulumi.get(self, "skip_matching")

    @skip_matching.setter
    def skip_matching(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_matching", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the instance refresh task. Possible values:
        - Pending: The instance refresh task is created and waiting to be scheduled.
        - InProgress: The instance refresh task is in progress.
        - Paused: The instance refresh task is paused.
        - CheckpointPause: The task is paused because it has reached a checkpoint (Checkpoint.Percentage).
        - Failed: The instance refresh task failed.
        - Successful: The instance refresh task was successful.
        - Cancelling: The instance refresh task is being canceled.
        - RollbackInProgress: The instance refresh task is being rolled back.
        - RollbackSuccessful: The instance refresh task was rolled back successfully. Set RollbackSuccessful to rollback the instance refresh task.
        - RollbackFailed: The rollback of the instance refresh task failed.
        - Cancelled:  The instance refresh task is canceled. Set Cancelled to cancel the instance refresh task.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _InstanceRefreshState:
    def __init__(__self__, *,
                 checkpoint_pause_time: Optional[pulumi.Input[_builtins.int]] = None,
                 checkpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshCheckpointArgs']]]] = None,
                 desired_configuration_containers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationContainerArgs']]]] = None,
                 desired_configuration_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_configuration_launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_configuration_launch_template_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs']]]] = None,
                 desired_configuration_launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_healthy_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 min_healthy_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_matching: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceRefresh resources.
        :param pulumi.Input[_builtins.int] checkpoint_pause_time: The duration of the pause when the task reaches a checkpoint. Unit: minutes.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceRefreshCheckpointArgs']]] checkpoints: The checkpoints for the refresh task. The task automatically pauses for the duration specified by CheckpointPauseTime when the percentage of new instances reaches a specified value. See `checkpoints` below for details.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationContainerArgs']]] desired_configuration_containers: The list of containers in the instance. See `desired_configuration_containers` below for details.
        :param pulumi.Input[_builtins.str] desired_configuration_image_id: The ID of the image file. This is the image resource used for automatic instance creation.
        :param pulumi.Input[_builtins.str] desired_configuration_launch_template_id: The ID of the launch template. The scaling group uses this template to obtain launch configuration information.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs']]] desired_configuration_launch_template_overrides: The instance type information in the launch template overrides. See `desired_configuration_launch_template_overrides` below for details.
        :param pulumi.Input[_builtins.str] desired_configuration_launch_template_version: The version of the launch template.
        :param pulumi.Input[_builtins.int] max_healthy_percentage: The percentage by which the number of instances in the scaling group can exceed the group's capacity during the instance refresh.
        :param pulumi.Input[_builtins.int] min_healthy_percentage: The percentage of instances that must be healthy in the scaling group during the instance refresh. The value is a percentage of the scaling group's capacity.
        :param pulumi.Input[_builtins.str] scaling_group_id: The ID of the scaling group.
        :param pulumi.Input[_builtins.bool] skip_matching: Indicates whether to skip instances that match the desired configuration.
        :param pulumi.Input[_builtins.str] status: The current status of the instance refresh task. Possible values:
               - Pending: The instance refresh task is created and waiting to be scheduled.
               - InProgress: The instance refresh task is in progress.
               - Paused: The instance refresh task is paused.
               - CheckpointPause: The task is paused because it has reached a checkpoint (Checkpoint.Percentage).
               - Failed: The instance refresh task failed.
               - Successful: The instance refresh task was successful.
               - Cancelling: The instance refresh task is being canceled.
               - RollbackInProgress: The instance refresh task is being rolled back.
               - RollbackSuccessful: The instance refresh task was rolled back successfully. Set RollbackSuccessful to rollback the instance refresh task.
               - RollbackFailed: The rollback of the instance refresh task failed.
               - Cancelled:  The instance refresh task is canceled. Set Cancelled to cancel the instance refresh task.
        """
        if checkpoint_pause_time is not None:
            pulumi.set(__self__, "checkpoint_pause_time", checkpoint_pause_time)
        if checkpoints is not None:
            pulumi.set(__self__, "checkpoints", checkpoints)
        if desired_configuration_containers is not None:
            pulumi.set(__self__, "desired_configuration_containers", desired_configuration_containers)
        if desired_configuration_image_id is not None:
            pulumi.set(__self__, "desired_configuration_image_id", desired_configuration_image_id)
        if desired_configuration_launch_template_id is not None:
            pulumi.set(__self__, "desired_configuration_launch_template_id", desired_configuration_launch_template_id)
        if desired_configuration_launch_template_overrides is not None:
            pulumi.set(__self__, "desired_configuration_launch_template_overrides", desired_configuration_launch_template_overrides)
        if desired_configuration_launch_template_version is not None:
            pulumi.set(__self__, "desired_configuration_launch_template_version", desired_configuration_launch_template_version)
        if max_healthy_percentage is not None:
            pulumi.set(__self__, "max_healthy_percentage", max_healthy_percentage)
        if min_healthy_percentage is not None:
            pulumi.set(__self__, "min_healthy_percentage", min_healthy_percentage)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if skip_matching is not None:
            pulumi.set(__self__, "skip_matching", skip_matching)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="checkpointPauseTime")
    def checkpoint_pause_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of the pause when the task reaches a checkpoint. Unit: minutes.
        """
        return pulumi.get(self, "checkpoint_pause_time")

    @checkpoint_pause_time.setter
    def checkpoint_pause_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "checkpoint_pause_time", value)

    @_builtins.property
    @pulumi.getter
    def checkpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshCheckpointArgs']]]]:
        """
        The checkpoints for the refresh task. The task automatically pauses for the duration specified by CheckpointPauseTime when the percentage of new instances reaches a specified value. See `checkpoints` below for details.
        """
        return pulumi.get(self, "checkpoints")

    @checkpoints.setter
    def checkpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshCheckpointArgs']]]]):
        pulumi.set(self, "checkpoints", value)

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationContainers")
    def desired_configuration_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationContainerArgs']]]]:
        """
        The list of containers in the instance. See `desired_configuration_containers` below for details.
        """
        return pulumi.get(self, "desired_configuration_containers")

    @desired_configuration_containers.setter
    def desired_configuration_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationContainerArgs']]]]):
        pulumi.set(self, "desired_configuration_containers", value)

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationImageId")
    def desired_configuration_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the image file. This is the image resource used for automatic instance creation.
        """
        return pulumi.get(self, "desired_configuration_image_id")

    @desired_configuration_image_id.setter
    def desired_configuration_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_configuration_image_id", value)

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationLaunchTemplateId")
    def desired_configuration_launch_template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the launch template. The scaling group uses this template to obtain launch configuration information.
        """
        return pulumi.get(self, "desired_configuration_launch_template_id")

    @desired_configuration_launch_template_id.setter
    def desired_configuration_launch_template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_configuration_launch_template_id", value)

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationLaunchTemplateOverrides")
    def desired_configuration_launch_template_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs']]]]:
        """
        The instance type information in the launch template overrides. See `desired_configuration_launch_template_overrides` below for details.
        """
        return pulumi.get(self, "desired_configuration_launch_template_overrides")

    @desired_configuration_launch_template_overrides.setter
    def desired_configuration_launch_template_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs']]]]):
        pulumi.set(self, "desired_configuration_launch_template_overrides", value)

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationLaunchTemplateVersion")
    def desired_configuration_launch_template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the launch template.
        """
        return pulumi.get(self, "desired_configuration_launch_template_version")

    @desired_configuration_launch_template_version.setter
    def desired_configuration_launch_template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_configuration_launch_template_version", value)

    @_builtins.property
    @pulumi.getter(name="maxHealthyPercentage")
    def max_healthy_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage by which the number of instances in the scaling group can exceed the group's capacity during the instance refresh.
        """
        return pulumi.get(self, "max_healthy_percentage")

    @max_healthy_percentage.setter
    def max_healthy_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_healthy_percentage", value)

    @_builtins.property
    @pulumi.getter(name="minHealthyPercentage")
    def min_healthy_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of instances that must be healthy in the scaling group during the instance refresh. The value is a percentage of the scaling group's capacity.
        """
        return pulumi.get(self, "min_healthy_percentage")

    @min_healthy_percentage.setter
    def min_healthy_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_healthy_percentage", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="skipMatching")
    def skip_matching(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to skip instances that match the desired configuration.
        """
        return pulumi.get(self, "skip_matching")

    @skip_matching.setter
    def skip_matching(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_matching", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the instance refresh task. Possible values:
        - Pending: The instance refresh task is created and waiting to be scheduled.
        - InProgress: The instance refresh task is in progress.
        - Paused: The instance refresh task is paused.
        - CheckpointPause: The task is paused because it has reached a checkpoint (Checkpoint.Percentage).
        - Failed: The instance refresh task failed.
        - Successful: The instance refresh task was successful.
        - Cancelling: The instance refresh task is being canceled.
        - RollbackInProgress: The instance refresh task is being rolled back.
        - RollbackSuccessful: The instance refresh task was rolled back successfully. Set RollbackSuccessful to rollback the instance refresh task.
        - RollbackFailed: The rollback of the instance refresh task failed.
        - Cancelled:  The instance refresh task is canceled. Set Cancelled to cancel the instance refresh task.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:ess/instanceRefresh:InstanceRefresh")
class InstanceRefresh(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint_pause_time: Optional[pulumi.Input[_builtins.int]] = None,
                 checkpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshCheckpointArgs', 'InstanceRefreshCheckpointArgsDict']]]]] = None,
                 desired_configuration_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshDesiredConfigurationContainerArgs', 'InstanceRefreshDesiredConfigurationContainerArgsDict']]]]] = None,
                 desired_configuration_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_configuration_launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_configuration_launch_template_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs', 'InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgsDict']]]]] = None,
                 desired_configuration_launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_healthy_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 min_healthy_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_matching: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ESS instance refresh can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/instanceRefresh:InstanceRefresh example ir-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] checkpoint_pause_time: The duration of the pause when the task reaches a checkpoint. Unit: minutes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshCheckpointArgs', 'InstanceRefreshCheckpointArgsDict']]]] checkpoints: The checkpoints for the refresh task. The task automatically pauses for the duration specified by CheckpointPauseTime when the percentage of new instances reaches a specified value. See `checkpoints` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshDesiredConfigurationContainerArgs', 'InstanceRefreshDesiredConfigurationContainerArgsDict']]]] desired_configuration_containers: The list of containers in the instance. See `desired_configuration_containers` below for details.
        :param pulumi.Input[_builtins.str] desired_configuration_image_id: The ID of the image file. This is the image resource used for automatic instance creation.
        :param pulumi.Input[_builtins.str] desired_configuration_launch_template_id: The ID of the launch template. The scaling group uses this template to obtain launch configuration information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs', 'InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgsDict']]]] desired_configuration_launch_template_overrides: The instance type information in the launch template overrides. See `desired_configuration_launch_template_overrides` below for details.
        :param pulumi.Input[_builtins.str] desired_configuration_launch_template_version: The version of the launch template.
        :param pulumi.Input[_builtins.int] max_healthy_percentage: The percentage by which the number of instances in the scaling group can exceed the group's capacity during the instance refresh.
        :param pulumi.Input[_builtins.int] min_healthy_percentage: The percentage of instances that must be healthy in the scaling group during the instance refresh. The value is a percentage of the scaling group's capacity.
        :param pulumi.Input[_builtins.str] scaling_group_id: The ID of the scaling group.
        :param pulumi.Input[_builtins.bool] skip_matching: Indicates whether to skip instances that match the desired configuration.
        :param pulumi.Input[_builtins.str] status: The current status of the instance refresh task. Possible values:
               - Pending: The instance refresh task is created and waiting to be scheduled.
               - InProgress: The instance refresh task is in progress.
               - Paused: The instance refresh task is paused.
               - CheckpointPause: The task is paused because it has reached a checkpoint (Checkpoint.Percentage).
               - Failed: The instance refresh task failed.
               - Successful: The instance refresh task was successful.
               - Cancelling: The instance refresh task is being canceled.
               - RollbackInProgress: The instance refresh task is being rolled back.
               - RollbackSuccessful: The instance refresh task was rolled back successfully. Set RollbackSuccessful to rollback the instance refresh task.
               - RollbackFailed: The rollback of the instance refresh task failed.
               - Cancelled:  The instance refresh task is canceled. Set Cancelled to cancel the instance refresh task.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceRefreshArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ESS instance refresh can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/instanceRefresh:InstanceRefresh example ir-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param InstanceRefreshArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceRefreshArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint_pause_time: Optional[pulumi.Input[_builtins.int]] = None,
                 checkpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshCheckpointArgs', 'InstanceRefreshCheckpointArgsDict']]]]] = None,
                 desired_configuration_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshDesiredConfigurationContainerArgs', 'InstanceRefreshDesiredConfigurationContainerArgsDict']]]]] = None,
                 desired_configuration_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_configuration_launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_configuration_launch_template_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs', 'InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgsDict']]]]] = None,
                 desired_configuration_launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_healthy_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 min_healthy_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_matching: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceRefreshArgs.__new__(InstanceRefreshArgs)

            __props__.__dict__["checkpoint_pause_time"] = checkpoint_pause_time
            __props__.__dict__["checkpoints"] = checkpoints
            __props__.__dict__["desired_configuration_containers"] = desired_configuration_containers
            __props__.__dict__["desired_configuration_image_id"] = desired_configuration_image_id
            __props__.__dict__["desired_configuration_launch_template_id"] = desired_configuration_launch_template_id
            __props__.__dict__["desired_configuration_launch_template_overrides"] = desired_configuration_launch_template_overrides
            __props__.__dict__["desired_configuration_launch_template_version"] = desired_configuration_launch_template_version
            __props__.__dict__["max_healthy_percentage"] = max_healthy_percentage
            __props__.__dict__["min_healthy_percentage"] = min_healthy_percentage
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            __props__.__dict__["skip_matching"] = skip_matching
            __props__.__dict__["status"] = status
        super(InstanceRefresh, __self__).__init__(
            'alicloud:ess/instanceRefresh:InstanceRefresh',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checkpoint_pause_time: Optional[pulumi.Input[_builtins.int]] = None,
            checkpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshCheckpointArgs', 'InstanceRefreshCheckpointArgsDict']]]]] = None,
            desired_configuration_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshDesiredConfigurationContainerArgs', 'InstanceRefreshDesiredConfigurationContainerArgsDict']]]]] = None,
            desired_configuration_image_id: Optional[pulumi.Input[_builtins.str]] = None,
            desired_configuration_launch_template_id: Optional[pulumi.Input[_builtins.str]] = None,
            desired_configuration_launch_template_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs', 'InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgsDict']]]]] = None,
            desired_configuration_launch_template_version: Optional[pulumi.Input[_builtins.str]] = None,
            max_healthy_percentage: Optional[pulumi.Input[_builtins.int]] = None,
            min_healthy_percentage: Optional[pulumi.Input[_builtins.int]] = None,
            scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            skip_matching: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceRefresh':
        """
        Get an existing InstanceRefresh resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] checkpoint_pause_time: The duration of the pause when the task reaches a checkpoint. Unit: minutes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshCheckpointArgs', 'InstanceRefreshCheckpointArgsDict']]]] checkpoints: The checkpoints for the refresh task. The task automatically pauses for the duration specified by CheckpointPauseTime when the percentage of new instances reaches a specified value. See `checkpoints` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshDesiredConfigurationContainerArgs', 'InstanceRefreshDesiredConfigurationContainerArgsDict']]]] desired_configuration_containers: The list of containers in the instance. See `desired_configuration_containers` below for details.
        :param pulumi.Input[_builtins.str] desired_configuration_image_id: The ID of the image file. This is the image resource used for automatic instance creation.
        :param pulumi.Input[_builtins.str] desired_configuration_launch_template_id: The ID of the launch template. The scaling group uses this template to obtain launch configuration information.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgs', 'InstanceRefreshDesiredConfigurationLaunchTemplateOverrideArgsDict']]]] desired_configuration_launch_template_overrides: The instance type information in the launch template overrides. See `desired_configuration_launch_template_overrides` below for details.
        :param pulumi.Input[_builtins.str] desired_configuration_launch_template_version: The version of the launch template.
        :param pulumi.Input[_builtins.int] max_healthy_percentage: The percentage by which the number of instances in the scaling group can exceed the group's capacity during the instance refresh.
        :param pulumi.Input[_builtins.int] min_healthy_percentage: The percentage of instances that must be healthy in the scaling group during the instance refresh. The value is a percentage of the scaling group's capacity.
        :param pulumi.Input[_builtins.str] scaling_group_id: The ID of the scaling group.
        :param pulumi.Input[_builtins.bool] skip_matching: Indicates whether to skip instances that match the desired configuration.
        :param pulumi.Input[_builtins.str] status: The current status of the instance refresh task. Possible values:
               - Pending: The instance refresh task is created and waiting to be scheduled.
               - InProgress: The instance refresh task is in progress.
               - Paused: The instance refresh task is paused.
               - CheckpointPause: The task is paused because it has reached a checkpoint (Checkpoint.Percentage).
               - Failed: The instance refresh task failed.
               - Successful: The instance refresh task was successful.
               - Cancelling: The instance refresh task is being canceled.
               - RollbackInProgress: The instance refresh task is being rolled back.
               - RollbackSuccessful: The instance refresh task was rolled back successfully. Set RollbackSuccessful to rollback the instance refresh task.
               - RollbackFailed: The rollback of the instance refresh task failed.
               - Cancelled:  The instance refresh task is canceled. Set Cancelled to cancel the instance refresh task.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceRefreshState.__new__(_InstanceRefreshState)

        __props__.__dict__["checkpoint_pause_time"] = checkpoint_pause_time
        __props__.__dict__["checkpoints"] = checkpoints
        __props__.__dict__["desired_configuration_containers"] = desired_configuration_containers
        __props__.__dict__["desired_configuration_image_id"] = desired_configuration_image_id
        __props__.__dict__["desired_configuration_launch_template_id"] = desired_configuration_launch_template_id
        __props__.__dict__["desired_configuration_launch_template_overrides"] = desired_configuration_launch_template_overrides
        __props__.__dict__["desired_configuration_launch_template_version"] = desired_configuration_launch_template_version
        __props__.__dict__["max_healthy_percentage"] = max_healthy_percentage
        __props__.__dict__["min_healthy_percentage"] = min_healthy_percentage
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["skip_matching"] = skip_matching
        __props__.__dict__["status"] = status
        return InstanceRefresh(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="checkpointPauseTime")
    def checkpoint_pause_time(self) -> pulumi.Output[_builtins.int]:
        """
        The duration of the pause when the task reaches a checkpoint. Unit: minutes.
        """
        return pulumi.get(self, "checkpoint_pause_time")

    @_builtins.property
    @pulumi.getter
    def checkpoints(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceRefreshCheckpoint']]]:
        """
        The checkpoints for the refresh task. The task automatically pauses for the duration specified by CheckpointPauseTime when the percentage of new instances reaches a specified value. See `checkpoints` below for details.
        """
        return pulumi.get(self, "checkpoints")

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationContainers")
    def desired_configuration_containers(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceRefreshDesiredConfigurationContainer']]]:
        """
        The list of containers in the instance. See `desired_configuration_containers` below for details.
        """
        return pulumi.get(self, "desired_configuration_containers")

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationImageId")
    def desired_configuration_image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the image file. This is the image resource used for automatic instance creation.
        """
        return pulumi.get(self, "desired_configuration_image_id")

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationLaunchTemplateId")
    def desired_configuration_launch_template_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the launch template. The scaling group uses this template to obtain launch configuration information.
        """
        return pulumi.get(self, "desired_configuration_launch_template_id")

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationLaunchTemplateOverrides")
    def desired_configuration_launch_template_overrides(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceRefreshDesiredConfigurationLaunchTemplateOverride']]]:
        """
        The instance type information in the launch template overrides. See `desired_configuration_launch_template_overrides` below for details.
        """
        return pulumi.get(self, "desired_configuration_launch_template_overrides")

    @_builtins.property
    @pulumi.getter(name="desiredConfigurationLaunchTemplateVersion")
    def desired_configuration_launch_template_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version of the launch template.
        """
        return pulumi.get(self, "desired_configuration_launch_template_version")

    @_builtins.property
    @pulumi.getter(name="maxHealthyPercentage")
    def max_healthy_percentage(self) -> pulumi.Output[_builtins.int]:
        """
        The percentage by which the number of instances in the scaling group can exceed the group's capacity during the instance refresh.
        """
        return pulumi.get(self, "max_healthy_percentage")

    @_builtins.property
    @pulumi.getter(name="minHealthyPercentage")
    def min_healthy_percentage(self) -> pulumi.Output[_builtins.int]:
        """
        The percentage of instances that must be healthy in the scaling group during the instance refresh. The value is a percentage of the scaling group's capacity.
        """
        return pulumi.get(self, "min_healthy_percentage")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter(name="skipMatching")
    def skip_matching(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether to skip instances that match the desired configuration.
        """
        return pulumi.get(self, "skip_matching")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the instance refresh task. Possible values:
        - Pending: The instance refresh task is created and waiting to be scheduled.
        - InProgress: The instance refresh task is in progress.
        - Paused: The instance refresh task is paused.
        - CheckpointPause: The task is paused because it has reached a checkpoint (Checkpoint.Percentage).
        - Failed: The instance refresh task failed.
        - Successful: The instance refresh task was successful.
        - Cancelling: The instance refresh task is being canceled.
        - RollbackInProgress: The instance refresh task is being rolled back.
        - RollbackSuccessful: The instance refresh task was rolled back successfully. Set RollbackSuccessful to rollback the instance refresh task.
        - RollbackFailed: The rollback of the instance refresh task failed.
        - Cancelled:  The instance refresh task is canceled. Set Cancelled to cancel the instance refresh task.
        """
        return pulumi.get(self, "status")

