# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AlarmExpression',
    'EciScalingConfigurationAcrRegistryInfo',
    'EciScalingConfigurationContainer',
    'EciScalingConfigurationContainerEnvironmentVar',
    'EciScalingConfigurationContainerPort',
    'EciScalingConfigurationContainerVolumeMount',
    'EciScalingConfigurationDnsConfigOption',
    'EciScalingConfigurationHostAlias',
    'EciScalingConfigurationImageRegistryCredential',
    'EciScalingConfigurationInitContainer',
    'EciScalingConfigurationInitContainerEnvironmentVar',
    'EciScalingConfigurationInitContainerPort',
    'EciScalingConfigurationInitContainerVolumeMount',
    'EciScalingConfigurationSecurityContextSysctl',
    'EciScalingConfigurationVolume',
    'EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath',
    'InstanceRefreshCheckpoint',
    'InstanceRefreshDesiredConfigurationContainer',
    'InstanceRefreshDesiredConfigurationContainerEnvironmentVar',
    'InstanceRefreshDesiredConfigurationLaunchTemplateOverride',
    'ScalingConfigurationCustomPriority',
    'ScalingConfigurationDataDisk',
    'ScalingConfigurationInstancePatternInfo',
    'ScalingConfigurationInstanceTypeOverride',
    'ScalingConfigurationNetworkInterface',
    'ScalingConfigurationSpotPriceLimit',
    'ScalingGroupAlbServerGroup',
    'ScalingGroupLaunchTemplateOverride',
    'ScalingGroupVServerGroupsVserverGroup',
    'ScalingGroupVServerGroupsVserverGroupVserverAttribute',
    'ScalingRuleAlarmDimension',
    'ScalingRuleHybridMetric',
    'ScalingRuleHybridMetricDimension',
    'ScalingRuleStepAdjustment',
    'GetAlarmsAlarmResult',
    'GetLifecycleHooksHookResult',
    'GetNotificationsNotificationResult',
    'GetScalingConfigurationsConfigurationResult',
    'GetScalingConfigurationsConfigurationDataDiskResult',
    'GetScalingConfigurationsConfigurationInstancePatternInfoResult',
    'GetScalingConfigurationsConfigurationSpotPriceLimitResult',
    'GetScalingGroupsGroupResult',
    'GetScalingGroupsGroupLaunchTemplateOverrideResult',
    'GetScalingRulesRuleResult',
    'GetScalingRulesRuleHybridMetricResult',
    'GetScalingRulesRuleHybridMetricDimensionResult',
    'GetScalingRulesRuleStepAdjustmentResult',
    'GetScheduledTasksTaskResult',
]

@pulumi.output_type
class AlarmExpression(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmExpression. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmExpression.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmExpression.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparison_operator: Optional[_builtins.str] = None,
                 metric_name: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 statistics: Optional[_builtins.str] = None,
                 threshold: Optional[_builtins.float] = None):
        """
        :param _builtins.str comparison_operator: The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Supported value: >=, <=, >, <. Defaults to >=.
        :param _builtins.str metric_name: The name for the alarm's associated metric. See `dimensions` below for details.
        :param _builtins.int period: The period in seconds over which the specified statistic is applied. Supported value: 60, 120, 300, 900. Defaults to 300.
        :param _builtins.str statistics: The statistic to apply to the alarm's associated metric. Supported value: Average, Minimum, Maximum. Defaults to Average.
        :param _builtins.float threshold: The value against which the specified statistics is compared.
        """
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if statistics is not None:
            pulumi.set(__self__, "statistics", statistics)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional[_builtins.str]:
        """
        The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Supported value: >=, <=, >, <. Defaults to >=.
        """
        return pulumi.get(self, "comparison_operator")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[_builtins.str]:
        """
        The name for the alarm's associated metric. See `dimensions` below for details.
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        The period in seconds over which the specified statistic is applied. Supported value: 60, 120, 300, 900. Defaults to 300.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> Optional[_builtins.str]:
        """
        The statistic to apply to the alarm's associated metric. Supported value: Average, Minimum, Maximum. Defaults to Average.
        """
        return pulumi.get(self, "statistics")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[_builtins.float]:
        """
        The value against which the specified statistics is compared.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class EciScalingConfigurationAcrRegistryInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "instanceName":
            suggest = "instance_name"
        elif key == "regionId":
            suggest = "region_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationAcrRegistryInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationAcrRegistryInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationAcrRegistryInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domains: Optional[Sequence[_builtins.str]] = None,
                 instance_id: Optional[_builtins.str] = None,
                 instance_name: Optional[_builtins.str] = None,
                 region_id: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] domains: Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
               when `acr_registry_info` is configured.
        :param _builtins.str instance_id: The ID of Container Registry Enterprise Edition instance. It is required
               when `acr_registry_info` is configured.
        :param _builtins.str instance_name: The name of Container Registry Enterprise Edition instance. It is required when `acr_registry_info` is
               configured.
        :param _builtins.str region_id: The region ID of Container Registry Enterprise Edition instance. It is required
               when `acr_registry_info` is configured.
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[_builtins.str]]:
        """
        Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
        when `acr_registry_info` is configured.
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of Container Registry Enterprise Edition instance. It is required
        when `acr_registry_info` is configured.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[_builtins.str]:
        """
        The name of Container Registry Enterprise Edition instance. It is required when `acr_registry_info` is
        configured.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[_builtins.str]:
        """
        The region ID of Container Registry Enterprise Edition instance. It is required
        when `acr_registry_info` is configured.
        """
        return pulumi.get(self, "region_id")


@pulumi.output_type
class EciScalingConfigurationContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentVars":
            suggest = "environment_vars"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "lifecyclePreStopHandlerExecs":
            suggest = "lifecycle_pre_stop_handler_execs"
        elif key == "livenessProbeExecCommands":
            suggest = "liveness_probe_exec_commands"
        elif key == "livenessProbeFailureThreshold":
            suggest = "liveness_probe_failure_threshold"
        elif key == "livenessProbeHttpGetPath":
            suggest = "liveness_probe_http_get_path"
        elif key == "livenessProbeHttpGetPort":
            suggest = "liveness_probe_http_get_port"
        elif key == "livenessProbeHttpGetScheme":
            suggest = "liveness_probe_http_get_scheme"
        elif key == "livenessProbeInitialDelaySeconds":
            suggest = "liveness_probe_initial_delay_seconds"
        elif key == "livenessProbePeriodSeconds":
            suggest = "liveness_probe_period_seconds"
        elif key == "livenessProbeSuccessThreshold":
            suggest = "liveness_probe_success_threshold"
        elif key == "livenessProbeTcpSocketPort":
            suggest = "liveness_probe_tcp_socket_port"
        elif key == "livenessProbeTimeoutSeconds":
            suggest = "liveness_probe_timeout_seconds"
        elif key == "readinessProbeExecCommands":
            suggest = "readiness_probe_exec_commands"
        elif key == "readinessProbeFailureThreshold":
            suggest = "readiness_probe_failure_threshold"
        elif key == "readinessProbeHttpGetPath":
            suggest = "readiness_probe_http_get_path"
        elif key == "readinessProbeHttpGetPort":
            suggest = "readiness_probe_http_get_port"
        elif key == "readinessProbeHttpGetScheme":
            suggest = "readiness_probe_http_get_scheme"
        elif key == "readinessProbeInitialDelaySeconds":
            suggest = "readiness_probe_initial_delay_seconds"
        elif key == "readinessProbePeriodSeconds":
            suggest = "readiness_probe_period_seconds"
        elif key == "readinessProbeSuccessThreshold":
            suggest = "readiness_probe_success_threshold"
        elif key == "readinessProbeTcpSocketPort":
            suggest = "readiness_probe_tcp_socket_port"
        elif key == "readinessProbeTimeoutSeconds":
            suggest = "readiness_probe_timeout_seconds"
        elif key == "securityContextCapabilityAdds":
            suggest = "security_context_capability_adds"
        elif key == "securityContextReadOnlyRootFileSystem":
            suggest = "security_context_read_only_root_file_system"
        elif key == "securityContextRunAsUser":
            suggest = "security_context_run_as_user"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 cpu: Optional[_builtins.float] = None,
                 environment_vars: Optional[Sequence['outputs.EciScalingConfigurationContainerEnvironmentVar']] = None,
                 gpu: Optional[_builtins.int] = None,
                 image: Optional[_builtins.str] = None,
                 image_pull_policy: Optional[_builtins.str] = None,
                 lifecycle_pre_stop_handler_execs: Optional[Sequence[_builtins.str]] = None,
                 liveness_probe_exec_commands: Optional[Sequence[_builtins.str]] = None,
                 liveness_probe_failure_threshold: Optional[_builtins.int] = None,
                 liveness_probe_http_get_path: Optional[_builtins.str] = None,
                 liveness_probe_http_get_port: Optional[_builtins.int] = None,
                 liveness_probe_http_get_scheme: Optional[_builtins.str] = None,
                 liveness_probe_initial_delay_seconds: Optional[_builtins.int] = None,
                 liveness_probe_period_seconds: Optional[_builtins.int] = None,
                 liveness_probe_success_threshold: Optional[_builtins.int] = None,
                 liveness_probe_tcp_socket_port: Optional[_builtins.int] = None,
                 liveness_probe_timeout_seconds: Optional[_builtins.int] = None,
                 memory: Optional[_builtins.float] = None,
                 name: Optional[_builtins.str] = None,
                 ports: Optional[Sequence['outputs.EciScalingConfigurationContainerPort']] = None,
                 readiness_probe_exec_commands: Optional[Sequence[_builtins.str]] = None,
                 readiness_probe_failure_threshold: Optional[_builtins.int] = None,
                 readiness_probe_http_get_path: Optional[_builtins.str] = None,
                 readiness_probe_http_get_port: Optional[_builtins.int] = None,
                 readiness_probe_http_get_scheme: Optional[_builtins.str] = None,
                 readiness_probe_initial_delay_seconds: Optional[_builtins.int] = None,
                 readiness_probe_period_seconds: Optional[_builtins.int] = None,
                 readiness_probe_success_threshold: Optional[_builtins.int] = None,
                 readiness_probe_tcp_socket_port: Optional[_builtins.int] = None,
                 readiness_probe_timeout_seconds: Optional[_builtins.int] = None,
                 security_context_capability_adds: Optional[Sequence[_builtins.str]] = None,
                 security_context_read_only_root_file_system: Optional[_builtins.bool] = None,
                 security_context_run_as_user: Optional[_builtins.int] = None,
                 stdin: Optional[_builtins.bool] = None,
                 tty: Optional[_builtins.bool] = None,
                 volume_mounts: Optional[Sequence['outputs.EciScalingConfigurationContainerVolumeMount']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] args: The arguments passed to the commands.
        :param Sequence[_builtins.str] commands: The commands run by the init container.
        :param _builtins.float cpu: The amount of CPU resources allocated to the container.
        :param Sequence['EciScalingConfigurationContainerEnvironmentVarArgs'] environment_vars: The structure of environmentVars.
               See `environment_vars` below for details.
        :param _builtins.int gpu: The number GPUs.
        :param _builtins.str image: The image of the container.
        :param _builtins.str image_pull_policy: The restart policy of the image.
        :param Sequence[_builtins.str] lifecycle_pre_stop_handler_execs: The commands to be executed in containers when you use the CLI to specify the preStop callback function.
        :param Sequence[_builtins.str] liveness_probe_exec_commands: Commands that you want to run in containers when you use the CLI to perform liveness probes.
        :param _builtins.int liveness_probe_failure_threshold: The minimum number of consecutive failures for the liveness probe to be considered failed after having been successful. Default value: 3.
        :param _builtins.str liveness_probe_http_get_path: The path to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        :param _builtins.int liveness_probe_http_get_port: The port to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        :param _builtins.str liveness_probe_http_get_scheme: The protocol type of HTTP GET requests when you use HTTP requests for liveness probes.Valid values:HTTP and HTTPS.
        :param _builtins.int liveness_probe_initial_delay_seconds: The number of seconds after container has started before liveness probes are initiated.
        :param _builtins.int liveness_probe_period_seconds: The interval at which the liveness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        :param _builtins.int liveness_probe_success_threshold: The minimum number of consecutive successes for the liveness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        :param _builtins.int liveness_probe_tcp_socket_port: The port detected by TCP sockets when you use TCP sockets to perform liveness probes.
        :param _builtins.int liveness_probe_timeout_seconds: The timeout period for the liveness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        :param _builtins.float memory: The amount of memory resources allocated to the container.
        :param _builtins.str name: The name of the mounted volume.
        :param Sequence['EciScalingConfigurationContainerPortArgs'] ports: The structure of port. See `ports` below for details.
        :param Sequence[_builtins.str] readiness_probe_exec_commands: Commands that you want to run in containers when you use the CLI to perform readiness probes.
        :param _builtins.int readiness_probe_failure_threshold: The minimum number of consecutive failures for the readiness probe to be considered failed after having been successful. Default value: 3.
        :param _builtins.str readiness_probe_http_get_path: The path to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        :param _builtins.int readiness_probe_http_get_port: The port to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        :param _builtins.str readiness_probe_http_get_scheme: The protocol type of HTTP GET requests when you use HTTP requests for readiness probes. Valid values: HTTP and HTTPS.
        :param _builtins.int readiness_probe_initial_delay_seconds: The number of seconds after container N has started before readiness probes are initiated.
        :param _builtins.int readiness_probe_period_seconds: The interval at which the readiness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        :param _builtins.int readiness_probe_success_threshold: The minimum number of consecutive successes for the readiness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        :param _builtins.int readiness_probe_tcp_socket_port: The port detected by Transmission Control Protocol (TCP) sockets when you use TCP sockets to perform readiness probes.
        :param _builtins.int readiness_probe_timeout_seconds: The timeout period for the readiness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        :param Sequence[_builtins.str] security_context_capability_adds: Grant certain permissions to processes within container. Optional values:
               - NET_ADMIN: Allow network management tasks to be performed.
               - NET_RAW: Allow raw sockets.
        :param _builtins.bool security_context_read_only_root_file_system: Mounts the container's root filesystem as read-only.
        :param _builtins.int security_context_run_as_user: Specifies user ID  under which all processes run.
        :param _builtins.bool stdin: Specifies whether container N allocates buffer resources to standard input streams during its active runtime. If you do not specify this parameter, an end-of-file (EOF) error occurs.
        :param _builtins.bool tty: Specifies whether to enable the Interaction feature. Valid values: true, false.
        :param Sequence['EciScalingConfigurationContainerVolumeMountArgs'] volume_mounts: The structure of volumeMounts. 
               See `volume_mounts` below for details.
        :param _builtins.str working_dir: The working directory of the container.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if lifecycle_pre_stop_handler_execs is not None:
            pulumi.set(__self__, "lifecycle_pre_stop_handler_execs", lifecycle_pre_stop_handler_execs)
        if liveness_probe_exec_commands is not None:
            pulumi.set(__self__, "liveness_probe_exec_commands", liveness_probe_exec_commands)
        if liveness_probe_failure_threshold is not None:
            pulumi.set(__self__, "liveness_probe_failure_threshold", liveness_probe_failure_threshold)
        if liveness_probe_http_get_path is not None:
            pulumi.set(__self__, "liveness_probe_http_get_path", liveness_probe_http_get_path)
        if liveness_probe_http_get_port is not None:
            pulumi.set(__self__, "liveness_probe_http_get_port", liveness_probe_http_get_port)
        if liveness_probe_http_get_scheme is not None:
            pulumi.set(__self__, "liveness_probe_http_get_scheme", liveness_probe_http_get_scheme)
        if liveness_probe_initial_delay_seconds is not None:
            pulumi.set(__self__, "liveness_probe_initial_delay_seconds", liveness_probe_initial_delay_seconds)
        if liveness_probe_period_seconds is not None:
            pulumi.set(__self__, "liveness_probe_period_seconds", liveness_probe_period_seconds)
        if liveness_probe_success_threshold is not None:
            pulumi.set(__self__, "liveness_probe_success_threshold", liveness_probe_success_threshold)
        if liveness_probe_tcp_socket_port is not None:
            pulumi.set(__self__, "liveness_probe_tcp_socket_port", liveness_probe_tcp_socket_port)
        if liveness_probe_timeout_seconds is not None:
            pulumi.set(__self__, "liveness_probe_timeout_seconds", liveness_probe_timeout_seconds)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probe_exec_commands is not None:
            pulumi.set(__self__, "readiness_probe_exec_commands", readiness_probe_exec_commands)
        if readiness_probe_failure_threshold is not None:
            pulumi.set(__self__, "readiness_probe_failure_threshold", readiness_probe_failure_threshold)
        if readiness_probe_http_get_path is not None:
            pulumi.set(__self__, "readiness_probe_http_get_path", readiness_probe_http_get_path)
        if readiness_probe_http_get_port is not None:
            pulumi.set(__self__, "readiness_probe_http_get_port", readiness_probe_http_get_port)
        if readiness_probe_http_get_scheme is not None:
            pulumi.set(__self__, "readiness_probe_http_get_scheme", readiness_probe_http_get_scheme)
        if readiness_probe_initial_delay_seconds is not None:
            pulumi.set(__self__, "readiness_probe_initial_delay_seconds", readiness_probe_initial_delay_seconds)
        if readiness_probe_period_seconds is not None:
            pulumi.set(__self__, "readiness_probe_period_seconds", readiness_probe_period_seconds)
        if readiness_probe_success_threshold is not None:
            pulumi.set(__self__, "readiness_probe_success_threshold", readiness_probe_success_threshold)
        if readiness_probe_tcp_socket_port is not None:
            pulumi.set(__self__, "readiness_probe_tcp_socket_port", readiness_probe_tcp_socket_port)
        if readiness_probe_timeout_seconds is not None:
            pulumi.set(__self__, "readiness_probe_timeout_seconds", readiness_probe_timeout_seconds)
        if security_context_capability_adds is not None:
            pulumi.set(__self__, "security_context_capability_adds", security_context_capability_adds)
        if security_context_read_only_root_file_system is not None:
            pulumi.set(__self__, "security_context_read_only_root_file_system", security_context_read_only_root_file_system)
        if security_context_run_as_user is not None:
            pulumi.set(__self__, "security_context_run_as_user", security_context_run_as_user)
        if stdin is not None:
            pulumi.set(__self__, "stdin", stdin)
        if tty is not None:
            pulumi.set(__self__, "tty", tty)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments passed to the commands.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        The commands run by the init container.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.float]:
        """
        The amount of CPU resources allocated to the container.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[Sequence['outputs.EciScalingConfigurationContainerEnvironmentVar']]:
        """
        The structure of environmentVars.
        See `environment_vars` below for details.
        """
        return pulumi.get(self, "environment_vars")

    @_builtins.property
    @pulumi.getter
    def gpu(self) -> Optional[_builtins.int]:
        """
        The number GPUs.
        """
        return pulumi.get(self, "gpu")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[_builtins.str]:
        """
        The restart policy of the image.
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter(name="lifecyclePreStopHandlerExecs")
    def lifecycle_pre_stop_handler_execs(self) -> Optional[Sequence[_builtins.str]]:
        """
        The commands to be executed in containers when you use the CLI to specify the preStop callback function.
        """
        return pulumi.get(self, "lifecycle_pre_stop_handler_execs")

    @_builtins.property
    @pulumi.getter(name="livenessProbeExecCommands")
    def liveness_probe_exec_commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        Commands that you want to run in containers when you use the CLI to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_exec_commands")

    @_builtins.property
    @pulumi.getter(name="livenessProbeFailureThreshold")
    def liveness_probe_failure_threshold(self) -> Optional[_builtins.int]:
        """
        The minimum number of consecutive failures for the liveness probe to be considered failed after having been successful. Default value: 3.
        """
        return pulumi.get(self, "liveness_probe_failure_threshold")

    @_builtins.property
    @pulumi.getter(name="livenessProbeHttpGetPath")
    def liveness_probe_http_get_path(self) -> Optional[_builtins.str]:
        """
        The path to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_http_get_path")

    @_builtins.property
    @pulumi.getter(name="livenessProbeHttpGetPort")
    def liveness_probe_http_get_port(self) -> Optional[_builtins.int]:
        """
        The port to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_http_get_port")

    @_builtins.property
    @pulumi.getter(name="livenessProbeHttpGetScheme")
    def liveness_probe_http_get_scheme(self) -> Optional[_builtins.str]:
        """
        The protocol type of HTTP GET requests when you use HTTP requests for liveness probes.Valid values:HTTP and HTTPS.
        """
        return pulumi.get(self, "liveness_probe_http_get_scheme")

    @_builtins.property
    @pulumi.getter(name="livenessProbeInitialDelaySeconds")
    def liveness_probe_initial_delay_seconds(self) -> Optional[_builtins.int]:
        """
        The number of seconds after container has started before liveness probes are initiated.
        """
        return pulumi.get(self, "liveness_probe_initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="livenessProbePeriodSeconds")
    def liveness_probe_period_seconds(self) -> Optional[_builtins.int]:
        """
        The interval at which the liveness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        """
        return pulumi.get(self, "liveness_probe_period_seconds")

    @_builtins.property
    @pulumi.getter(name="livenessProbeSuccessThreshold")
    def liveness_probe_success_threshold(self) -> Optional[_builtins.int]:
        """
        The minimum number of consecutive successes for the liveness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        """
        return pulumi.get(self, "liveness_probe_success_threshold")

    @_builtins.property
    @pulumi.getter(name="livenessProbeTcpSocketPort")
    def liveness_probe_tcp_socket_port(self) -> Optional[_builtins.int]:
        """
        The port detected by TCP sockets when you use TCP sockets to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_tcp_socket_port")

    @_builtins.property
    @pulumi.getter(name="livenessProbeTimeoutSeconds")
    def liveness_probe_timeout_seconds(self) -> Optional[_builtins.int]:
        """
        The timeout period for the liveness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        """
        return pulumi.get(self, "liveness_probe_timeout_seconds")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.float]:
        """
        The amount of memory resources allocated to the container.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.EciScalingConfigurationContainerPort']]:
        """
        The structure of port. See `ports` below for details.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter(name="readinessProbeExecCommands")
    def readiness_probe_exec_commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        Commands that you want to run in containers when you use the CLI to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_exec_commands")

    @_builtins.property
    @pulumi.getter(name="readinessProbeFailureThreshold")
    def readiness_probe_failure_threshold(self) -> Optional[_builtins.int]:
        """
        The minimum number of consecutive failures for the readiness probe to be considered failed after having been successful. Default value: 3.
        """
        return pulumi.get(self, "readiness_probe_failure_threshold")

    @_builtins.property
    @pulumi.getter(name="readinessProbeHttpGetPath")
    def readiness_probe_http_get_path(self) -> Optional[_builtins.str]:
        """
        The path to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_http_get_path")

    @_builtins.property
    @pulumi.getter(name="readinessProbeHttpGetPort")
    def readiness_probe_http_get_port(self) -> Optional[_builtins.int]:
        """
        The port to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_http_get_port")

    @_builtins.property
    @pulumi.getter(name="readinessProbeHttpGetScheme")
    def readiness_probe_http_get_scheme(self) -> Optional[_builtins.str]:
        """
        The protocol type of HTTP GET requests when you use HTTP requests for readiness probes. Valid values: HTTP and HTTPS.
        """
        return pulumi.get(self, "readiness_probe_http_get_scheme")

    @_builtins.property
    @pulumi.getter(name="readinessProbeInitialDelaySeconds")
    def readiness_probe_initial_delay_seconds(self) -> Optional[_builtins.int]:
        """
        The number of seconds after container N has started before readiness probes are initiated.
        """
        return pulumi.get(self, "readiness_probe_initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="readinessProbePeriodSeconds")
    def readiness_probe_period_seconds(self) -> Optional[_builtins.int]:
        """
        The interval at which the readiness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        """
        return pulumi.get(self, "readiness_probe_period_seconds")

    @_builtins.property
    @pulumi.getter(name="readinessProbeSuccessThreshold")
    def readiness_probe_success_threshold(self) -> Optional[_builtins.int]:
        """
        The minimum number of consecutive successes for the readiness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        """
        return pulumi.get(self, "readiness_probe_success_threshold")

    @_builtins.property
    @pulumi.getter(name="readinessProbeTcpSocketPort")
    def readiness_probe_tcp_socket_port(self) -> Optional[_builtins.int]:
        """
        The port detected by Transmission Control Protocol (TCP) sockets when you use TCP sockets to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_tcp_socket_port")

    @_builtins.property
    @pulumi.getter(name="readinessProbeTimeoutSeconds")
    def readiness_probe_timeout_seconds(self) -> Optional[_builtins.int]:
        """
        The timeout period for the readiness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        """
        return pulumi.get(self, "readiness_probe_timeout_seconds")

    @_builtins.property
    @pulumi.getter(name="securityContextCapabilityAdds")
    def security_context_capability_adds(self) -> Optional[Sequence[_builtins.str]]:
        """
        Grant certain permissions to processes within container. Optional values:
        - NET_ADMIN: Allow network management tasks to be performed.
        - NET_RAW: Allow raw sockets.
        """
        return pulumi.get(self, "security_context_capability_adds")

    @_builtins.property
    @pulumi.getter(name="securityContextReadOnlyRootFileSystem")
    def security_context_read_only_root_file_system(self) -> Optional[_builtins.bool]:
        """
        Mounts the container's root filesystem as read-only.
        """
        return pulumi.get(self, "security_context_read_only_root_file_system")

    @_builtins.property
    @pulumi.getter(name="securityContextRunAsUser")
    def security_context_run_as_user(self) -> Optional[_builtins.int]:
        """
        Specifies user ID  under which all processes run.
        """
        return pulumi.get(self, "security_context_run_as_user")

    @_builtins.property
    @pulumi.getter
    def stdin(self) -> Optional[_builtins.bool]:
        """
        Specifies whether container N allocates buffer resources to standard input streams during its active runtime. If you do not specify this parameter, an end-of-file (EOF) error occurs.
        """
        return pulumi.get(self, "stdin")

    @_builtins.property
    @pulumi.getter
    def tty(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable the Interaction feature. Valid values: true, false.
        """
        return pulumi.get(self, "tty")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.EciScalingConfigurationContainerVolumeMount']]:
        """
        The structure of volumeMounts. 
        See `volume_mounts` below for details.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class EciScalingConfigurationContainerEnvironmentVar(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldRefFieldPath":
            suggest = "field_ref_field_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationContainerEnvironmentVar. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationContainerEnvironmentVar.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationContainerEnvironmentVar.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_ref_field_path: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        if field_ref_field_path is not None:
            pulumi.set(__self__, "field_ref_field_path", field_ref_field_path)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="fieldRefFieldPath")
    def field_ref_field_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "field_ref_field_path")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class EciScalingConfigurationContainerPort(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class EciScalingConfigurationContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "mountPropagation":
            suggest = "mount_propagation"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: Optional[_builtins.str] = None,
                 mount_propagation: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 sub_path: Optional[_builtins.str] = None):
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if mount_propagation is not None:
            pulumi.set(__self__, "mount_propagation", mount_propagation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter(name="mountPropagation")
    def mount_propagation(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "mount_propagation")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class EciScalingConfigurationDnsConfigOption(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The option name.
        :param _builtins.str value: The option value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The option name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The option value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EciScalingConfigurationHostAlias(dict):
    def __init__(__self__, *,
                 hostnames: Optional[Sequence[_builtins.str]] = None,
                 ip: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] hostnames: Adds a host name.
        :param _builtins.str ip: Adds an IP address.
        """
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[Sequence[_builtins.str]]:
        """
        Adds a host name.
        """
        return pulumi.get(self, "hostnames")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        Adds an IP address.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class EciScalingConfigurationImageRegistryCredential(dict):
    def __init__(__self__, *,
                 password: Optional[_builtins.str] = None,
                 server: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str password: The password used to log on to the image repository. It is required
               when `image_registry_credential` is configured.
        :param _builtins.str server: The address of the image repository. It is required when `image_registry_credential` is
               configured.
        :param _builtins.str username: The username used to log on to the image repository. It is required
               when `image_registry_credential` is configured.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password used to log on to the image repository. It is required
        when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[_builtins.str]:
        """
        The address of the image repository. It is required when `image_registry_credential` is
        configured.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The username used to log on to the image repository. It is required
        when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class EciScalingConfigurationInitContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentVars":
            suggest = "environment_vars"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "securityContextCapabilityAdds":
            suggest = "security_context_capability_adds"
        elif key == "securityContextReadOnlyRootFileSystem":
            suggest = "security_context_read_only_root_file_system"
        elif key == "securityContextRunAsUser":
            suggest = "security_context_run_as_user"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationInitContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationInitContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationInitContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 cpu: Optional[_builtins.float] = None,
                 environment_vars: Optional[Sequence['outputs.EciScalingConfigurationInitContainerEnvironmentVar']] = None,
                 gpu: Optional[_builtins.int] = None,
                 image: Optional[_builtins.str] = None,
                 image_pull_policy: Optional[_builtins.str] = None,
                 memory: Optional[_builtins.float] = None,
                 name: Optional[_builtins.str] = None,
                 ports: Optional[Sequence['outputs.EciScalingConfigurationInitContainerPort']] = None,
                 security_context_capability_adds: Optional[Sequence[_builtins.str]] = None,
                 security_context_read_only_root_file_system: Optional[_builtins.bool] = None,
                 security_context_run_as_user: Optional[_builtins.int] = None,
                 volume_mounts: Optional[Sequence['outputs.EciScalingConfigurationInitContainerVolumeMount']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] args: The arguments passed to the commands.
        :param Sequence[_builtins.str] commands: The commands run by the init container.
        :param _builtins.float cpu: The amount of CPU resources allocated to the container.
        :param Sequence['EciScalingConfigurationInitContainerEnvironmentVarArgs'] environment_vars: The structure of environmentVars. 
               See `environment_vars` below for details.
        :param _builtins.int gpu: The number GPUs.
        :param _builtins.str image: The image of the container.
        :param _builtins.str image_pull_policy: The restart policy of the image.
        :param _builtins.float memory: The amount of memory resources allocated to the container.
        :param _builtins.str name: The name of the mounted volume.
        :param Sequence['EciScalingConfigurationInitContainerPortArgs'] ports: The structure of port. See `ports` below for details.
        :param Sequence[_builtins.str] security_context_capability_adds: Grant certain permissions to processes within container. Optional values:
               - NET_ADMIN: Allow network management tasks to be performed.
               - NET_RAW: Allow raw sockets.
        :param _builtins.bool security_context_read_only_root_file_system: Mounts the container's root filesystem as read-only.
        :param _builtins.int security_context_run_as_user: Specifies user ID  under which all processes run.
        :param Sequence['EciScalingConfigurationInitContainerVolumeMountArgs'] volume_mounts: The structure of volumeMounts. See `volume_mounts` below for details.
        :param _builtins.str working_dir: The working directory of the container.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if security_context_capability_adds is not None:
            pulumi.set(__self__, "security_context_capability_adds", security_context_capability_adds)
        if security_context_read_only_root_file_system is not None:
            pulumi.set(__self__, "security_context_read_only_root_file_system", security_context_read_only_root_file_system)
        if security_context_run_as_user is not None:
            pulumi.set(__self__, "security_context_run_as_user", security_context_run_as_user)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments passed to the commands.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        The commands run by the init container.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.float]:
        """
        The amount of CPU resources allocated to the container.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[Sequence['outputs.EciScalingConfigurationInitContainerEnvironmentVar']]:
        """
        The structure of environmentVars. 
        See `environment_vars` below for details.
        """
        return pulumi.get(self, "environment_vars")

    @_builtins.property
    @pulumi.getter
    def gpu(self) -> Optional[_builtins.int]:
        """
        The number GPUs.
        """
        return pulumi.get(self, "gpu")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[_builtins.str]:
        """
        The restart policy of the image.
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.float]:
        """
        The amount of memory resources allocated to the container.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.EciScalingConfigurationInitContainerPort']]:
        """
        The structure of port. See `ports` below for details.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter(name="securityContextCapabilityAdds")
    def security_context_capability_adds(self) -> Optional[Sequence[_builtins.str]]:
        """
        Grant certain permissions to processes within container. Optional values:
        - NET_ADMIN: Allow network management tasks to be performed.
        - NET_RAW: Allow raw sockets.
        """
        return pulumi.get(self, "security_context_capability_adds")

    @_builtins.property
    @pulumi.getter(name="securityContextReadOnlyRootFileSystem")
    def security_context_read_only_root_file_system(self) -> Optional[_builtins.bool]:
        """
        Mounts the container's root filesystem as read-only.
        """
        return pulumi.get(self, "security_context_read_only_root_file_system")

    @_builtins.property
    @pulumi.getter(name="securityContextRunAsUser")
    def security_context_run_as_user(self) -> Optional[_builtins.int]:
        """
        Specifies user ID  under which all processes run.
        """
        return pulumi.get(self, "security_context_run_as_user")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.EciScalingConfigurationInitContainerVolumeMount']]:
        """
        The structure of volumeMounts. See `volume_mounts` below for details.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class EciScalingConfigurationInitContainerEnvironmentVar(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldRefFieldPath":
            suggest = "field_ref_field_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationInitContainerEnvironmentVar. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationInitContainerEnvironmentVar.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationInitContainerEnvironmentVar.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_ref_field_path: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        if field_ref_field_path is not None:
            pulumi.set(__self__, "field_ref_field_path", field_ref_field_path)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="fieldRefFieldPath")
    def field_ref_field_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "field_ref_field_path")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class EciScalingConfigurationInitContainerPort(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class EciScalingConfigurationInitContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "mountPropagation":
            suggest = "mount_propagation"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationInitContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationInitContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationInitContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: Optional[_builtins.str] = None,
                 mount_propagation: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 sub_path: Optional[_builtins.str] = None):
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if mount_propagation is not None:
            pulumi.set(__self__, "mount_propagation", mount_propagation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter(name="mountPropagation")
    def mount_propagation(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "mount_propagation")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class EciScalingConfigurationSecurityContextSysctl(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The system name of the security context in which the elastic container instance is run.
        :param _builtins.str value: The system value of the security context in which the elastic container instance is run.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The system name of the security context in which the elastic container instance is run.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The system value of the security context in which the elastic container instance is run.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EciScalingConfigurationVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configFileVolumeConfigFileToPaths":
            suggest = "config_file_volume_config_file_to_paths"
        elif key == "configFileVolumeDefaultMode":
            suggest = "config_file_volume_default_mode"
        elif key == "diskVolumeDiskId":
            suggest = "disk_volume_disk_id"
        elif key == "diskVolumeDiskSize":
            suggest = "disk_volume_disk_size"
        elif key == "diskVolumeFsType":
            suggest = "disk_volume_fs_type"
        elif key == "emptyDirVolumeMedium":
            suggest = "empty_dir_volume_medium"
        elif key == "emptyDirVolumeSizeLimit":
            suggest = "empty_dir_volume_size_limit"
        elif key == "flexVolumeDriver":
            suggest = "flex_volume_driver"
        elif key == "flexVolumeFsType":
            suggest = "flex_volume_fs_type"
        elif key == "flexVolumeOptions":
            suggest = "flex_volume_options"
        elif key == "hostPathVolumePath":
            suggest = "host_path_volume_path"
        elif key == "hostPathVolumeType":
            suggest = "host_path_volume_type"
        elif key == "nfsVolumePath":
            suggest = "nfs_volume_path"
        elif key == "nfsVolumeReadOnly":
            suggest = "nfs_volume_read_only"
        elif key == "nfsVolumeServer":
            suggest = "nfs_volume_server"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_file_volume_config_file_to_paths: Optional[Sequence['outputs.EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath']] = None,
                 config_file_volume_default_mode: Optional[_builtins.int] = None,
                 disk_volume_disk_id: Optional[_builtins.str] = None,
                 disk_volume_disk_size: Optional[_builtins.int] = None,
                 disk_volume_fs_type: Optional[_builtins.str] = None,
                 empty_dir_volume_medium: Optional[_builtins.str] = None,
                 empty_dir_volume_size_limit: Optional[_builtins.str] = None,
                 flex_volume_driver: Optional[_builtins.str] = None,
                 flex_volume_fs_type: Optional[_builtins.str] = None,
                 flex_volume_options: Optional[_builtins.str] = None,
                 host_path_volume_path: Optional[_builtins.str] = None,
                 host_path_volume_type: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 nfs_volume_path: Optional[_builtins.str] = None,
                 nfs_volume_read_only: Optional[_builtins.bool] = None,
                 nfs_volume_server: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param Sequence['EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs'] config_file_volume_config_file_to_paths: ConfigFileVolumeConfigFileToPaths.
               See `config_file_volume_config_file_to_paths` below for details.
        :param _builtins.int config_file_volume_default_mode: The default permissions on the ConfigFileVolume.
        :param _builtins.str disk_volume_disk_id: The ID of DiskVolume.
        :param _builtins.int disk_volume_disk_size: The disk size of DiskVolume.
        :param _builtins.str disk_volume_fs_type: The system type of DiskVolume.
        :param _builtins.str empty_dir_volume_medium: The storage medium of the EmptyDirVolume. If you leave this parameter empty, the file system of the node is used as the storage medium. If you set this parameter to memory, the memory is used as the storage medium.
        :param _builtins.str empty_dir_volume_size_limit: The storage size of the EmptyDirVolume. Unit: GiB or MiB.
        :param _builtins.str flex_volume_driver: The name of the FlexVolume driver.
        :param _builtins.str flex_volume_fs_type: The type of the mounted file system. The default value is determined by the script
               of FlexVolume.
        :param _builtins.str flex_volume_options: The list of FlexVolume objects. Each object is a key-value pair contained in a JSON
               string.
        :param _builtins.str host_path_volume_path: The absolute path on the host.
        :param _builtins.str host_path_volume_type: The type of the host path. Examples: File, Directory, and Socket.
        :param _builtins.str name: The name of the volume.
        :param _builtins.str nfs_volume_path: The path to the NFS volume.
        :param _builtins.bool nfs_volume_read_only: The nfs volume read only. Default to `false`.
        :param _builtins.str nfs_volume_server: The address of the NFS server.
               
               > **NOTE:** Every volume mounted must have a name and type attributes.
        :param _builtins.str type: The type of the volume.
        """
        if config_file_volume_config_file_to_paths is not None:
            pulumi.set(__self__, "config_file_volume_config_file_to_paths", config_file_volume_config_file_to_paths)
        if config_file_volume_default_mode is not None:
            pulumi.set(__self__, "config_file_volume_default_mode", config_file_volume_default_mode)
        if disk_volume_disk_id is not None:
            pulumi.set(__self__, "disk_volume_disk_id", disk_volume_disk_id)
        if disk_volume_disk_size is not None:
            pulumi.set(__self__, "disk_volume_disk_size", disk_volume_disk_size)
        if disk_volume_fs_type is not None:
            pulumi.set(__self__, "disk_volume_fs_type", disk_volume_fs_type)
        if empty_dir_volume_medium is not None:
            pulumi.set(__self__, "empty_dir_volume_medium", empty_dir_volume_medium)
        if empty_dir_volume_size_limit is not None:
            pulumi.set(__self__, "empty_dir_volume_size_limit", empty_dir_volume_size_limit)
        if flex_volume_driver is not None:
            pulumi.set(__self__, "flex_volume_driver", flex_volume_driver)
        if flex_volume_fs_type is not None:
            pulumi.set(__self__, "flex_volume_fs_type", flex_volume_fs_type)
        if flex_volume_options is not None:
            pulumi.set(__self__, "flex_volume_options", flex_volume_options)
        if host_path_volume_path is not None:
            pulumi.set(__self__, "host_path_volume_path", host_path_volume_path)
        if host_path_volume_type is not None:
            pulumi.set(__self__, "host_path_volume_type", host_path_volume_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_volume_path is not None:
            pulumi.set(__self__, "nfs_volume_path", nfs_volume_path)
        if nfs_volume_read_only is not None:
            pulumi.set(__self__, "nfs_volume_read_only", nfs_volume_read_only)
        if nfs_volume_server is not None:
            pulumi.set(__self__, "nfs_volume_server", nfs_volume_server)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="configFileVolumeConfigFileToPaths")
    def config_file_volume_config_file_to_paths(self) -> Optional[Sequence['outputs.EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath']]:
        """
        ConfigFileVolumeConfigFileToPaths.
        See `config_file_volume_config_file_to_paths` below for details.
        """
        return pulumi.get(self, "config_file_volume_config_file_to_paths")

    @_builtins.property
    @pulumi.getter(name="configFileVolumeDefaultMode")
    def config_file_volume_default_mode(self) -> Optional[_builtins.int]:
        """
        The default permissions on the ConfigFileVolume.
        """
        return pulumi.get(self, "config_file_volume_default_mode")

    @_builtins.property
    @pulumi.getter(name="diskVolumeDiskId")
    def disk_volume_disk_id(self) -> Optional[_builtins.str]:
        """
        The ID of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_disk_id")

    @_builtins.property
    @pulumi.getter(name="diskVolumeDiskSize")
    def disk_volume_disk_size(self) -> Optional[_builtins.int]:
        """
        The disk size of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_disk_size")

    @_builtins.property
    @pulumi.getter(name="diskVolumeFsType")
    def disk_volume_fs_type(self) -> Optional[_builtins.str]:
        """
        The system type of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_fs_type")

    @_builtins.property
    @pulumi.getter(name="emptyDirVolumeMedium")
    def empty_dir_volume_medium(self) -> Optional[_builtins.str]:
        """
        The storage medium of the EmptyDirVolume. If you leave this parameter empty, the file system of the node is used as the storage medium. If you set this parameter to memory, the memory is used as the storage medium.
        """
        return pulumi.get(self, "empty_dir_volume_medium")

    @_builtins.property
    @pulumi.getter(name="emptyDirVolumeSizeLimit")
    def empty_dir_volume_size_limit(self) -> Optional[_builtins.str]:
        """
        The storage size of the EmptyDirVolume. Unit: GiB or MiB.
        """
        return pulumi.get(self, "empty_dir_volume_size_limit")

    @_builtins.property
    @pulumi.getter(name="flexVolumeDriver")
    def flex_volume_driver(self) -> Optional[_builtins.str]:
        """
        The name of the FlexVolume driver.
        """
        return pulumi.get(self, "flex_volume_driver")

    @_builtins.property
    @pulumi.getter(name="flexVolumeFsType")
    def flex_volume_fs_type(self) -> Optional[_builtins.str]:
        """
        The type of the mounted file system. The default value is determined by the script
        of FlexVolume.
        """
        return pulumi.get(self, "flex_volume_fs_type")

    @_builtins.property
    @pulumi.getter(name="flexVolumeOptions")
    def flex_volume_options(self) -> Optional[_builtins.str]:
        """
        The list of FlexVolume objects. Each object is a key-value pair contained in a JSON
        string.
        """
        return pulumi.get(self, "flex_volume_options")

    @_builtins.property
    @pulumi.getter(name="hostPathVolumePath")
    def host_path_volume_path(self) -> Optional[_builtins.str]:
        """
        The absolute path on the host.
        """
        return pulumi.get(self, "host_path_volume_path")

    @_builtins.property
    @pulumi.getter(name="hostPathVolumeType")
    def host_path_volume_type(self) -> Optional[_builtins.str]:
        """
        The type of the host path. Examples: File, Directory, and Socket.
        """
        return pulumi.get(self, "host_path_volume_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nfsVolumePath")
    def nfs_volume_path(self) -> Optional[_builtins.str]:
        """
        The path to the NFS volume.
        """
        return pulumi.get(self, "nfs_volume_path")

    @_builtins.property
    @pulumi.getter(name="nfsVolumeReadOnly")
    def nfs_volume_read_only(self) -> Optional[_builtins.bool]:
        """
        The nfs volume read only. Default to `false`.
        """
        return pulumi.get(self, "nfs_volume_read_only")

    @_builtins.property
    @pulumi.getter(name="nfsVolumeServer")
    def nfs_volume_server(self) -> Optional[_builtins.str]:
        """
        The address of the NFS server.

        > **NOTE:** Every volume mounted must have a name and type attributes.
        """
        return pulumi.get(self, "nfs_volume_server")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the volume.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath(dict):
    def __init__(__self__, *,
                 content: Optional[_builtins.str] = None,
                 mode: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str content: The content of the configuration file. Maximum size: 32 KB.
        :param _builtins.int mode: The permissions on the ConfigFileVolume directory.
        :param _builtins.str path: The relative file path.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[_builtins.str]:
        """
        The content of the configuration file. Maximum size: 32 KB.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        The permissions on the ConfigFileVolume directory.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The relative file path.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class InstanceRefreshCheckpoint(dict):
    def __init__(__self__, *,
                 percentage: Optional[_builtins.int] = None):
        """
        :param _builtins.int percentage: The percentage of new instances out of the total instances in the scaling group. The task automatically pauses when this percentage is reached.
        """
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)

    @_builtins.property
    @pulumi.getter
    def percentage(self) -> Optional[_builtins.int]:
        """
        The percentage of new instances out of the total instances in the scaling group. The task automatically pauses when this percentage is reached.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class InstanceRefreshDesiredConfigurationContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentVars":
            suggest = "environment_vars"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceRefreshDesiredConfigurationContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceRefreshDesiredConfigurationContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceRefreshDesiredConfigurationContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 environment_vars: Optional[Sequence['outputs.InstanceRefreshDesiredConfigurationContainerEnvironmentVar']] = None,
                 image: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] args: The arguments for the container startup command.
        :param Sequence[_builtins.str] commands: The container startup command.
        :param Sequence['InstanceRefreshDesiredConfigurationContainerEnvironmentVarArgs'] environment_vars: Information about the environment variables. See `environment_vars` below for details.
        :param _builtins.str image: The container image.
        :param _builtins.str name: The custom name of the container.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        The arguments for the container startup command.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        The container startup command.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[Sequence['outputs.InstanceRefreshDesiredConfigurationContainerEnvironmentVar']]:
        """
        Information about the environment variables. See `environment_vars` below for details.
        """
        return pulumi.get(self, "environment_vars")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        The container image.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The custom name of the container.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstanceRefreshDesiredConfigurationContainerEnvironmentVar(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldRefFieldPath":
            suggest = "field_ref_field_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceRefreshDesiredConfigurationContainerEnvironmentVar. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceRefreshDesiredConfigurationContainerEnvironmentVar.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceRefreshDesiredConfigurationContainerEnvironmentVar.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_ref_field_path: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str field_ref_field_path: This parameter is not available for use.
        :param _builtins.str key: The name of the environment variable.
        :param _builtins.str value: The value of the environment variable.
        """
        if field_ref_field_path is not None:
            pulumi.set(__self__, "field_ref_field_path", field_ref_field_path)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="fieldRefFieldPath")
    def field_ref_field_path(self) -> Optional[_builtins.str]:
        """
        This parameter is not available for use.
        """
        return pulumi.get(self, "field_ref_field_path")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstanceRefreshDesiredConfigurationLaunchTemplateOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceRefreshDesiredConfigurationLaunchTemplateOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceRefreshDesiredConfigurationLaunchTemplateOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceRefreshDesiredConfigurationLaunchTemplateOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance_type: The specified instance type, which overwrites the instance type in the launch template.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[_builtins.str]:
        """
        The specified instance type, which overwrites the instance type in the launch template.
        """
        return pulumi.get(self, "instance_type")


@pulumi.output_type
class ScalingConfigurationCustomPriority(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingConfigurationCustomPriority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingConfigurationCustomPriority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingConfigurationCustomPriority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[_builtins.str] = None,
                 vswitch_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str instance_type: This parameter takes effect only if you set Scaling Policy to Priority Policy and the instance type specified by CustomPriorities.N.InstanceType is contained in the scaling configuration.
        :param _builtins.str vswitch_id: This parameter takes effect only if you set Scaling Policy to Priority Policy and the vSwitch specified by CustomPriorities.N.VswitchId is included in the vSwitch list of your scaling group.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[_builtins.str]:
        """
        This parameter takes effect only if you set Scaling Policy to Priority Policy and the instance type specified by CustomPriorities.N.InstanceType is contained in the scaling configuration.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        This parameter takes effect only if you set Scaling Policy to Priority Policy and the vSwitch specified by CustomPriorities.N.VswitchId is included in the vSwitch list of your scaling group.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class ScalingConfigurationDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoSnapshotPolicyId":
            suggest = "auto_snapshot_policy_id"
        elif key == "deleteWithInstance":
            suggest = "delete_with_instance"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "performanceLevel":
            suggest = "performance_level"
        elif key == "provisionedIops":
            suggest = "provisioned_iops"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingConfigurationDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingConfigurationDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingConfigurationDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_snapshot_policy_id: Optional[_builtins.str] = None,
                 category: Optional[_builtins.str] = None,
                 delete_with_instance: Optional[_builtins.bool] = None,
                 description: Optional[_builtins.str] = None,
                 device: Optional[_builtins.str] = None,
                 encrypted: Optional[_builtins.bool] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 performance_level: Optional[_builtins.str] = None,
                 provisioned_iops: Optional[_builtins.int] = None,
                 size: Optional[_builtins.int] = None,
                 snapshot_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str auto_snapshot_policy_id: The id of auto snapshot policy for data disk.
        :param _builtins.str category: Category of data disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd` , `cloud_essd` and `cloud`.
        :param _builtins.bool delete_with_instance: Whether to delete data disks attached on ecs when release ecs instance. Optional value: `true` or `false`, default to `true`.
        :param _builtins.str description: The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param _builtins.str device: The mount point of data disk N. Valid values of N: 1 to 16. If this parameter is not specified, the system automatically allocates a mount point to created ECS instances. The name of the mount point ranges from /dev/xvdb to /dev/xvdz in alphabetical order.
        :param _builtins.bool encrypted: Specifies whether data disk N is to be encrypted. Valid values of N: 1 to 16. Valid values: `true`: encrypted, `false`: not encrypted. Default value: `false`.
        :param _builtins.str kms_key_id: The CMK ID for data disk N. Valid values of N: 1 to 16.
        :param _builtins.str name: The name of data disk N. Valid values of N: 1 to 16. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        :param _builtins.str performance_level: The performance level of the ESSD used as data disk.
        :param _builtins.int provisioned_iops: IOPS measures the number of read and write operations that an Elastic Block Storage (EBS) device can process per second.
        :param _builtins.int size: Size of data disk, in GB. The value ranges [5,2000] for a cloud disk, [5,1024] for an ephemeral disk, [5,800] for an ephemeral_ssd disk, [20,32768] for cloud_efficiency, cloud_ssd, cloud_essd disk.
        :param _builtins.str snapshot_id: Snapshot used for creating the data disk. If this parameter is specified, the size parameter is neglected, and the size of the created disk is the size of the snapshot.
        """
        if auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if provisioned_iops is not None:
            pulumi.set(__self__, "provisioned_iops", provisioned_iops)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @_builtins.property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> Optional[_builtins.str]:
        """
        The id of auto snapshot policy for data disk.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        """
        Category of data disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd` , `cloud_essd` and `cloud`.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[_builtins.bool]:
        """
        Whether to delete data disks attached on ecs when release ecs instance. Optional value: `true` or `false`, default to `true`.
        """
        return pulumi.get(self, "delete_with_instance")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Attribute device has been deprecated on disk attachment resource. Suggest to remove it from your template.""")
    def device(self) -> Optional[_builtins.str]:
        """
        The mount point of data disk N. Valid values of N: 1 to 16. If this parameter is not specified, the system automatically allocates a mount point to created ECS instances. The name of the mount point ranges from /dev/xvdb to /dev/xvdz in alphabetical order.
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[_builtins.bool]:
        """
        Specifies whether data disk N is to be encrypted. Valid values of N: 1 to 16. Valid values: `true`: encrypted, `false`: not encrypted. Default value: `false`.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        The CMK ID for data disk N. Valid values of N: 1 to 16.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of data disk N. Valid values of N: 1 to 16. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[_builtins.str]:
        """
        The performance level of the ESSD used as data disk.
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> Optional[_builtins.int]:
        """
        IOPS measures the number of read and write operations that an Elastic Block Storage (EBS) device can process per second.
        """
        return pulumi.get(self, "provisioned_iops")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        Size of data disk, in GB. The value ranges [5,2000] for a cloud disk, [5,1024] for an ephemeral disk, [5,800] for an ephemeral_ssd disk, [20,32768] for cloud_efficiency, cloud_ssd, cloud_essd disk.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[_builtins.str]:
        """
        Snapshot used for creating the data disk. If this parameter is specified, the size parameter is neglected, and the size of the created disk is the size of the snapshot.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class ScalingConfigurationInstancePatternInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "burstablePerformance":
            suggest = "burstable_performance"
        elif key == "excludedInstanceTypes":
            suggest = "excluded_instance_types"
        elif key == "instanceFamilyLevel":
            suggest = "instance_family_level"
        elif key == "maxPrice":
            suggest = "max_price"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingConfigurationInstancePatternInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingConfigurationInstancePatternInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingConfigurationInstancePatternInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architectures: Optional[Sequence[_builtins.str]] = None,
                 burstable_performance: Optional[_builtins.str] = None,
                 cores: Optional[_builtins.int] = None,
                 excluded_instance_types: Optional[Sequence[_builtins.str]] = None,
                 instance_family_level: Optional[_builtins.str] = None,
                 max_price: Optional[_builtins.float] = None,
                 memory: Optional[_builtins.float] = None):
        """
        :param Sequence[_builtins.str] architectures: Architecture N of instance type N. Valid values: X86, Heterogeneous, BareMetal, Arm, SuperComputeCluster.
        :param _builtins.str burstable_performance: Specifies whether to include burstable instance types.  Valid values: Exclude, Include, Required.
        :param _builtins.int cores: The number of vCPUs that are specified for an instance type in instancePatternInfo.
        :param Sequence[_builtins.str] excluded_instance_types: Instance type N that you want to exclude. You can use wildcard characters, such as an asterisk (*), to exclude an instance type or an instance family.
        :param _builtins.str instance_family_level: The instance family level in instancePatternInfo.
        :param _builtins.float max_price: The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
        :param _builtins.float memory: The memory size that is specified for an instance type in instancePatternInfo.
        """
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if burstable_performance is not None:
            pulumi.set(__self__, "burstable_performance", burstable_performance)
        if cores is not None:
            pulumi.set(__self__, "cores", cores)
        if excluded_instance_types is not None:
            pulumi.set(__self__, "excluded_instance_types", excluded_instance_types)
        if instance_family_level is not None:
            pulumi.set(__self__, "instance_family_level", instance_family_level)
        if max_price is not None:
            pulumi.set(__self__, "max_price", max_price)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @_builtins.property
    @pulumi.getter
    def architectures(self) -> Optional[Sequence[_builtins.str]]:
        """
        Architecture N of instance type N. Valid values: X86, Heterogeneous, BareMetal, Arm, SuperComputeCluster.
        """
        return pulumi.get(self, "architectures")

    @_builtins.property
    @pulumi.getter(name="burstablePerformance")
    def burstable_performance(self) -> Optional[_builtins.str]:
        """
        Specifies whether to include burstable instance types.  Valid values: Exclude, Include, Required.
        """
        return pulumi.get(self, "burstable_performance")

    @_builtins.property
    @pulumi.getter
    def cores(self) -> Optional[_builtins.int]:
        """
        The number of vCPUs that are specified for an instance type in instancePatternInfo.
        """
        return pulumi.get(self, "cores")

    @_builtins.property
    @pulumi.getter(name="excludedInstanceTypes")
    def excluded_instance_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Instance type N that you want to exclude. You can use wildcard characters, such as an asterisk (*), to exclude an instance type or an instance family.
        """
        return pulumi.get(self, "excluded_instance_types")

    @_builtins.property
    @pulumi.getter(name="instanceFamilyLevel")
    def instance_family_level(self) -> Optional[_builtins.str]:
        """
        The instance family level in instancePatternInfo.
        """
        return pulumi.get(self, "instance_family_level")

    @_builtins.property
    @pulumi.getter(name="maxPrice")
    def max_price(self) -> Optional[_builtins.float]:
        """
        The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
        """
        return pulumi.get(self, "max_price")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.float]:
        """
        The memory size that is specified for an instance type in instancePatternInfo.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class ScalingConfigurationInstanceTypeOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingConfigurationInstanceTypeOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingConfigurationInstanceTypeOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingConfigurationInstanceTypeOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[_builtins.str] = None,
                 weighted_capacity: Optional[_builtins.int] = None):
        """
        :param _builtins.str instance_type: The is specified for an instance type in instanceTypeOverride.
        :param _builtins.int weighted_capacity: The weight of instance type in instanceTypeOverride.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[_builtins.str]:
        """
        The is specified for an instance type in instanceTypeOverride.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[_builtins.int]:
        """
        The weight of instance type in instanceTypeOverride.
        """
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class ScalingConfigurationNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "ipv6AddressCount":
            suggest = "ipv6_address_count"
        elif key == "networkInterfaceTrafficMode":
            suggest = "network_interface_traffic_mode"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingConfigurationNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingConfigurationNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingConfigurationNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[_builtins.str] = None,
                 ipv6_address_count: Optional[_builtins.int] = None,
                 network_interface_traffic_mode: Optional[_builtins.str] = None,
                 security_group_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str instance_type: The ENI type. If you specify NetworkInterfaces.N, specify at least one primary ENI. You cannot specify SecurityGroupId or SecurityGroupIds.N. Valid values: Primary, Secondary.
        :param _builtins.int ipv6_address_count: The number of randomly generated IPv6 addresses that you want to assign to primary ENI N.
        :param _builtins.str network_interface_traffic_mode: The communication mode of the ENI. Valid values: Standard, HighPerformance.
        :param Sequence[_builtins.str] security_group_ids: The ID of security group N to which ENI N belongs.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if network_interface_traffic_mode is not None:
            pulumi.set(__self__, "network_interface_traffic_mode", network_interface_traffic_mode)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[_builtins.str]:
        """
        The ENI type. If you specify NetworkInterfaces.N, specify at least one primary ENI. You cannot specify SecurityGroupId or SecurityGroupIds.N. Valid values: Primary, Secondary.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[_builtins.int]:
        """
        The number of randomly generated IPv6 addresses that you want to assign to primary ENI N.
        """
        return pulumi.get(self, "ipv6_address_count")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceTrafficMode")
    def network_interface_traffic_mode(self) -> Optional[_builtins.str]:
        """
        The communication mode of the ENI. Valid values: Standard, HighPerformance.
        """
        return pulumi.get(self, "network_interface_traffic_mode")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The ID of security group N to which ENI N belongs.
        """
        return pulumi.get(self, "security_group_ids")


@pulumi.output_type
class ScalingConfigurationSpotPriceLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "priceLimit":
            suggest = "price_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingConfigurationSpotPriceLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingConfigurationSpotPriceLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingConfigurationSpotPriceLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[_builtins.str] = None,
                 price_limit: Optional[_builtins.float] = None):
        """
        :param _builtins.str instance_type: Resource type of an ECS instance.
        :param _builtins.float price_limit: Price limit hourly of instance type, 2 decimals is allowed at most.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if price_limit is not None:
            pulumi.set(__self__, "price_limit", price_limit)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[_builtins.str]:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="priceLimit")
    def price_limit(self) -> Optional[_builtins.float]:
        """
        Price limit hourly of instance type, 2 decimals is allowed at most.
        """
        return pulumi.get(self, "price_limit")


@pulumi.output_type
class ScalingGroupAlbServerGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "albServerGroupId":
            suggest = "alb_server_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingGroupAlbServerGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingGroupAlbServerGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingGroupAlbServerGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alb_server_group_id: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str alb_server_group_id: The ID of ALB server group.
        :param _builtins.int port: The port number used by an ECS instance after Auto Scaling adds the ECS instance to ALB server group.
        :param _builtins.int weight: The weight of the ECS instance as a backend server after Auto Scaling adds the ECS instance to ALB server group.
        """
        if alb_server_group_id is not None:
            pulumi.set(__self__, "alb_server_group_id", alb_server_group_id)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="albServerGroupId")
    def alb_server_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of ALB server group.
        """
        return pulumi.get(self, "alb_server_group_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port number used by an ECS instance after Auto Scaling adds the ECS instance to ALB server group.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        The weight of the ECS instance as a backend server after Auto Scaling adds the ECS instance to ALB server group.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ScalingGroupLaunchTemplateOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "spotPriceLimit":
            suggest = "spot_price_limit"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingGroupLaunchTemplateOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingGroupLaunchTemplateOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingGroupLaunchTemplateOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[_builtins.str] = None,
                 spot_price_limit: Optional[_builtins.float] = None,
                 weighted_capacity: Optional[_builtins.int] = None):
        """
        :param _builtins.str instance_type: The instance type in launchTemplateOverride.
        :param _builtins.float spot_price_limit: The maximum bid price of instance type in launchTemplateOverride.
               
               
               > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.
               
               > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.
               
               > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
        :param _builtins.int weighted_capacity: The weight of the instance type in launchTemplateOverride.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[_builtins.str]:
        """
        The instance type in launchTemplateOverride.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[_builtins.float]:
        """
        The maximum bid price of instance type in launchTemplateOverride.


        > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.

        > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.

        > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
        """
        return pulumi.get(self, "spot_price_limit")

    @_builtins.property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[_builtins.int]:
        """
        The weight of the instance type in launchTemplateOverride.
        """
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class ScalingGroupVServerGroupsVserverGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadbalancerId":
            suggest = "loadbalancer_id"
        elif key == "vserverAttributes":
            suggest = "vserver_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingGroupVServerGroupsVserverGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingGroupVServerGroupsVserverGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingGroupVServerGroupsVserverGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 loadbalancer_id: _builtins.str,
                 vserver_attributes: Sequence['outputs.ScalingGroupVServerGroupsVserverGroupVserverAttribute']):
        """
        :param _builtins.str loadbalancer_id: Loadbalancer server ID of VServer Group.
        :param Sequence['ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs'] vserver_attributes: A list of VServer Group attributes. See `vserver_attributes` below.
        """
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "vserver_attributes", vserver_attributes)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> _builtins.str:
        """
        Loadbalancer server ID of VServer Group.
        """
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter(name="vserverAttributes")
    def vserver_attributes(self) -> Sequence['outputs.ScalingGroupVServerGroupsVserverGroupVserverAttribute']:
        """
        A list of VServer Group attributes. See `vserver_attributes` below.
        """
        return pulumi.get(self, "vserver_attributes")


@pulumi.output_type
class ScalingGroupVServerGroupsVserverGroupVserverAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vserverGroupId":
            suggest = "vserver_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingGroupVServerGroupsVserverGroupVserverAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingGroupVServerGroupsVserverGroupVserverAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingGroupVServerGroupsVserverGroupVserverAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 vserver_group_id: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.int port: The port will be used for VServer Group backend server.
        :param _builtins.str vserver_group_id: ID of VServer Group.
        :param _builtins.int weight: The weight of an ECS instance attached to the VServer Group.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "vserver_group_id", vserver_group_id)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port will be used for VServer Group backend server.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="vserverGroupId")
    def vserver_group_id(self) -> _builtins.str:
        """
        ID of VServer Group.
        """
        return pulumi.get(self, "vserver_group_id")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        The weight of an ECS instance attached to the VServer Group.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ScalingRuleAlarmDimension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionKey":
            suggest = "dimension_key"
        elif key == "dimensionValue":
            suggest = "dimension_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingRuleAlarmDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingRuleAlarmDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingRuleAlarmDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_key: Optional[_builtins.str] = None,
                 dimension_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str dimension_key: The dimension key of the metric.
        :param _builtins.str dimension_value: The dimension value of the metric.
        """
        if dimension_key is not None:
            pulumi.set(__self__, "dimension_key", dimension_key)
        if dimension_value is not None:
            pulumi.set(__self__, "dimension_value", dimension_value)

    @_builtins.property
    @pulumi.getter(name="dimensionKey")
    def dimension_key(self) -> Optional[_builtins.str]:
        """
        The dimension key of the metric.
        """
        return pulumi.get(self, "dimension_key")

    @_builtins.property
    @pulumi.getter(name="dimensionValue")
    def dimension_value(self) -> Optional[_builtins.str]:
        """
        The dimension value of the metric.
        """
        return pulumi.get(self, "dimension_value")


@pulumi.output_type
class ScalingRuleHybridMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingRuleHybridMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingRuleHybridMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingRuleHybridMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Sequence['outputs.ScalingRuleHybridMetricDimension']] = None,
                 expression: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 metric_name: Optional[_builtins.str] = None,
                 statistic: Optional[_builtins.str] = None):
        """
        :param Sequence['ScalingRuleHybridMetricDimensionArgs'] dimensions: The structure of volumeMounts.
               See `dimensions` below for details.
        :param _builtins.str expression: The metric expression that consists of multiple Hybrid Cloud Monitoring metrics. It calculates a result used to trigger scaling events. The expression must comply with the Reverse Polish Notation (RPN) specification, and the operators can only be + - × /.
        :param _builtins.str id: The reference ID of the metric in the metric expression.
        :param _builtins.str metric_name: The name of the Hybrid Cloud Monitoring metric.
        :param _builtins.str statistic: The statistical method of the metric value. Valid values: Average, Minimum, Maximum.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ScalingRuleHybridMetricDimension']]:
        """
        The structure of volumeMounts.
        See `dimensions` below for details.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        The metric expression that consists of multiple Hybrid Cloud Monitoring metrics. It calculates a result used to trigger scaling events. The expression must comply with the Reverse Polish Notation (RPN) specification, and the operators can only be + - × /.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The reference ID of the metric in the metric expression.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[_builtins.str]:
        """
        The name of the Hybrid Cloud Monitoring metric.
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter
    def statistic(self) -> Optional[_builtins.str]:
        """
        The statistical method of the metric value. Valid values: Average, Minimum, Maximum.
        """
        return pulumi.get(self, "statistic")


@pulumi.output_type
class ScalingRuleHybridMetricDimension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionKey":
            suggest = "dimension_key"
        elif key == "dimensionValue":
            suggest = "dimension_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingRuleHybridMetricDimension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingRuleHybridMetricDimension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingRuleHybridMetricDimension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_key: Optional[_builtins.str] = None,
                 dimension_value: Optional[_builtins.str] = None):
        if dimension_key is not None:
            pulumi.set(__self__, "dimension_key", dimension_key)
        if dimension_value is not None:
            pulumi.set(__self__, "dimension_value", dimension_value)

    @_builtins.property
    @pulumi.getter(name="dimensionKey")
    def dimension_key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dimension_key")

    @_builtins.property
    @pulumi.getter(name="dimensionValue")
    def dimension_value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dimension_value")


@pulumi.output_type
class ScalingRuleStepAdjustment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricIntervalLowerBound":
            suggest = "metric_interval_lower_bound"
        elif key == "metricIntervalUpperBound":
            suggest = "metric_interval_upper_bound"
        elif key == "scalingAdjustment":
            suggest = "scaling_adjustment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingRuleStepAdjustment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingRuleStepAdjustment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingRuleStepAdjustment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_interval_lower_bound: Optional[_builtins.str] = None,
                 metric_interval_upper_bound: Optional[_builtins.str] = None,
                 scaling_adjustment: Optional[_builtins.int] = None):
        """
        :param _builtins.str metric_interval_lower_bound: The lower bound of step.
        :param _builtins.str metric_interval_upper_bound: The upper bound of step.
        :param _builtins.int scaling_adjustment: The adjust value of step.
        """
        if metric_interval_lower_bound is not None:
            pulumi.set(__self__, "metric_interval_lower_bound", metric_interval_lower_bound)
        if metric_interval_upper_bound is not None:
            pulumi.set(__self__, "metric_interval_upper_bound", metric_interval_upper_bound)
        if scaling_adjustment is not None:
            pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)

    @_builtins.property
    @pulumi.getter(name="metricIntervalLowerBound")
    def metric_interval_lower_bound(self) -> Optional[_builtins.str]:
        """
        The lower bound of step.
        """
        return pulumi.get(self, "metric_interval_lower_bound")

    @_builtins.property
    @pulumi.getter(name="metricIntervalUpperBound")
    def metric_interval_upper_bound(self) -> Optional[_builtins.str]:
        """
        The upper bound of step.
        """
        return pulumi.get(self, "metric_interval_upper_bound")

    @_builtins.property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> Optional[_builtins.int]:
        """
        The adjust value of step.
        """
        return pulumi.get(self, "scaling_adjustment")


@pulumi.output_type
class GetAlarmsAlarmResult(dict):
    def __init__(__self__, *,
                 alarm_actions: Sequence[_builtins.str],
                 cloud_monitor_group_id: _builtins.int,
                 comparison_operator: _builtins.str,
                 description: _builtins.str,
                 dimensions: Mapping[str, _builtins.str],
                 enable: _builtins.bool,
                 evaluation_count: _builtins.int,
                 id: _builtins.str,
                 metric_name: _builtins.str,
                 metric_type: _builtins.str,
                 name: _builtins.str,
                 period: _builtins.int,
                 scaling_group_id: _builtins.str,
                 state: _builtins.str,
                 statistics: _builtins.str,
                 threshold: _builtins.str):
        """
        :param Sequence[_builtins.str] alarm_actions: The list of actions to execute when this alarm transition into an ALARM state. Each action is specified as ess scaling rule ari.
        :param _builtins.int cloud_monitor_group_id: Defines the application group id defined by CMS which is assigned when you upload custom metric to CMS, only available for custom metirc.
        :param _builtins.str comparison_operator: The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand.
        :param _builtins.str description: The description for the alarm.
        :param Mapping[str, _builtins.str] dimensions: The dimension map for the alarm's associated metric.
        :param _builtins.bool enable: Whether to enable specific ess alarm.
        :param _builtins.int evaluation_count: The number of times that needs to satisfies comparison condition before transition into ALARM state.
        :param _builtins.str id: The id of alarm.
        :param _builtins.str metric_name: The name for the alarm's associated metric.
        :param _builtins.str metric_type: The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
        :param _builtins.str name: The name for ess alarm.
        :param _builtins.int period: The period in seconds over which the specified statistic is applied.
        :param _builtins.str scaling_group_id: Scaling group id the alarms belong to.
        :param _builtins.str state: The state of alarm task.
        :param _builtins.str statistics: The statistic to apply to the alarm's associated metric.
        :param _builtins.str threshold: The value against which the specified statistics is compared.
        """
        pulumi.set(__self__, "alarm_actions", alarm_actions)
        pulumi.set(__self__, "cloud_monitor_group_id", cloud_monitor_group_id)
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "evaluation_count", evaluation_count)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "metric_type", metric_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "statistics", statistics)
        pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Sequence[_builtins.str]:
        """
        The list of actions to execute when this alarm transition into an ALARM state. Each action is specified as ess scaling rule ari.
        """
        return pulumi.get(self, "alarm_actions")

    @_builtins.property
    @pulumi.getter(name="cloudMonitorGroupId")
    def cloud_monitor_group_id(self) -> _builtins.int:
        """
        Defines the application group id defined by CMS which is assigned when you upload custom metric to CMS, only available for custom metirc.
        """
        return pulumi.get(self, "cloud_monitor_group_id")

    @_builtins.property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> _builtins.str:
        """
        The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand.
        """
        return pulumi.get(self, "comparison_operator")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description for the alarm.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Mapping[str, _builtins.str]:
        """
        The dimension map for the alarm's associated metric.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        """
        Whether to enable specific ess alarm.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="evaluationCount")
    def evaluation_count(self) -> _builtins.int:
        """
        The number of times that needs to satisfies comparison condition before transition into ALARM state.
        """
        return pulumi.get(self, "evaluation_count")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of alarm.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> _builtins.str:
        """
        The name for the alarm's associated metric.
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> _builtins.str:
        """
        The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
        """
        return pulumi.get(self, "metric_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name for ess alarm.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> _builtins.int:
        """
        The period in seconds over which the specified statistic is applied.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> _builtins.str:
        """
        Scaling group id the alarms belong to.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of alarm task.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def statistics(self) -> _builtins.str:
        """
        The statistic to apply to the alarm's associated metric.
        """
        return pulumi.get(self, "statistics")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.str:
        """
        The value against which the specified statistics is compared.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetLifecycleHooksHookResult(dict):
    def __init__(__self__, *,
                 default_result: _builtins.str,
                 heartbeat_timeout: _builtins.int,
                 id: _builtins.str,
                 lifecycle_transition: _builtins.str,
                 name: _builtins.str,
                 notification_arn: _builtins.str,
                 notification_metadata: _builtins.str,
                 scaling_group_id: _builtins.str):
        """
        :param _builtins.str default_result: Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses.
        :param _builtins.int heartbeat_timeout: Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter.
        :param _builtins.str id: ID of the lifecycle hook.
        :param _builtins.str lifecycle_transition: Type of Scaling activity attached to lifecycle hook.
        :param _builtins.str name: Name of the lifecycle hook.
        :param _builtins.str notification_arn: The Arn of notification target.
        :param _builtins.str notification_metadata: Additional information that you want to include when Auto Scaling sends a message to the notification target.
        :param _builtins.str scaling_group_id: Scaling group id the lifecycle hooks belong to.
        """
        pulumi.set(__self__, "default_result", default_result)
        pulumi.set(__self__, "heartbeat_timeout", heartbeat_timeout)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_transition", lifecycle_transition)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notification_arn", notification_arn)
        pulumi.set(__self__, "notification_metadata", notification_metadata)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)

    @_builtins.property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> _builtins.str:
        """
        Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses.
        """
        return pulumi.get(self, "default_result")

    @_builtins.property
    @pulumi.getter(name="heartbeatTimeout")
    def heartbeat_timeout(self) -> _builtins.int:
        """
        Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter.
        """
        return pulumi.get(self, "heartbeat_timeout")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the lifecycle hook.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleTransition")
    def lifecycle_transition(self) -> _builtins.str:
        """
        Type of Scaling activity attached to lifecycle hook.
        """
        return pulumi.get(self, "lifecycle_transition")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the lifecycle hook.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationArn")
    def notification_arn(self) -> _builtins.str:
        """
        The Arn of notification target.
        """
        return pulumi.get(self, "notification_arn")

    @_builtins.property
    @pulumi.getter(name="notificationMetadata")
    def notification_metadata(self) -> _builtins.str:
        """
        Additional information that you want to include when Auto Scaling sends a message to the notification target.
        """
        return pulumi.get(self, "notification_metadata")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> _builtins.str:
        """
        Scaling group id the lifecycle hooks belong to.
        """
        return pulumi.get(self, "scaling_group_id")


@pulumi.output_type
class GetNotificationsNotificationResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 notification_arn: _builtins.str,
                 notification_types: Sequence[_builtins.str],
                 scaling_group_id: _builtins.str):
        """
        :param _builtins.str id: ID of the notification.
        :param _builtins.str notification_arn: The Alibaba Cloud Resource Name (ARN) for the notification object.
        :param Sequence[_builtins.str] notification_types: The notification types of Auto Scaling events and resource changes.
        :param _builtins.str scaling_group_id: Scaling group id the notifications belong to.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "notification_arn", notification_arn)
        pulumi.set(__self__, "notification_types", notification_types)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the notification.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="notificationArn")
    def notification_arn(self) -> _builtins.str:
        """
        The Alibaba Cloud Resource Name (ARN) for the notification object.
        """
        return pulumi.get(self, "notification_arn")

    @_builtins.property
    @pulumi.getter(name="notificationTypes")
    def notification_types(self) -> Sequence[_builtins.str]:
        """
        The notification types of Auto Scaling events and resource changes.
        """
        return pulumi.get(self, "notification_types")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> _builtins.str:
        """
        Scaling group id the notifications belong to.
        """
        return pulumi.get(self, "scaling_group_id")


@pulumi.output_type
class GetScalingConfigurationsConfigurationResult(dict):
    def __init__(__self__, *,
                 creation_time: _builtins.str,
                 credit_specification: _builtins.str,
                 data_disks: Sequence['outputs.GetScalingConfigurationsConfigurationDataDiskResult'],
                 host_name: _builtins.str,
                 id: _builtins.str,
                 image_id: _builtins.str,
                 instance_name: _builtins.str,
                 instance_pattern_infos: Sequence['outputs.GetScalingConfigurationsConfigurationInstancePatternInfoResult'],
                 instance_type: _builtins.str,
                 internet_charge_type: _builtins.str,
                 internet_max_bandwidth_in: _builtins.int,
                 internet_max_bandwidth_out: _builtins.int,
                 lifecycle_state: _builtins.str,
                 name: _builtins.str,
                 scaling_group_id: _builtins.str,
                 security_group_id: _builtins.str,
                 spot_price_limits: Sequence['outputs.GetScalingConfigurationsConfigurationSpotPriceLimitResult'],
                 spot_strategy: _builtins.str,
                 system_disk_category: _builtins.str,
                 system_disk_performance_level: _builtins.str,
                 system_disk_size: _builtins.int):
        """
        :param _builtins.str creation_time: Creation time of the scaling configuration.
        :param _builtins.str credit_specification: Performance mode of the t5 burstable instance.
        :param Sequence['GetScalingConfigurationsConfigurationDataDiskArgs'] data_disks: Data disks of the scaling configuration.
        :param _builtins.str host_name: (Optional,Available since v1.143.0) Hostname of an ECS instance.
        :param _builtins.str id: ID of the scaling rule.
        :param _builtins.str image_id: Image ID of the scaling configuration.
        :param _builtins.str instance_name: (Optional,Available since v1.143.0) InstanceName of an ECS instance.
        :param Sequence['GetScalingConfigurationsConfigurationInstancePatternInfoArgs'] instance_pattern_infos: (Optional, Available since v1.240.0) intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.
        :param _builtins.str instance_type: Resource type of an ECS instance.
        :param _builtins.str internet_charge_type: Internet charge type of the scaling configuration.
        :param _builtins.int internet_max_bandwidth_in: Internet max bandwidth in of the scaling configuration.
        :param _builtins.int internet_max_bandwidth_out: Internet max bandwidth of the scaling configuration.
        :param _builtins.str lifecycle_state: Lifecycle state of the scaling configuration.
        :param _builtins.str name: Name of the scaling configuration.
        :param _builtins.str scaling_group_id: Scaling group id the scaling configurations belong to.
        :param _builtins.str security_group_id: Security group ID of the scaling configuration.
        :param Sequence['GetScalingConfigurationsConfigurationSpotPriceLimitArgs'] spot_price_limits: (Optional, Available since v1.151.0) The maximum price hourly for instance types.
        :param _builtins.str spot_strategy: (Optional, Available since v1.151.0) The spot strategy for a Pay-As-You-Go instance.
        :param _builtins.str system_disk_category: System disk category of the scaling configuration.
        :param _builtins.str system_disk_performance_level: The performance level of the ESSD used as the system disk.
        :param _builtins.int system_disk_size: System disk size of the scaling configuration.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "credit_specification", credit_specification)
        pulumi.set(__self__, "data_disks", data_disks)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_pattern_infos", instance_pattern_infos)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "spot_price_limits", spot_price_limits)
        pulumi.set(__self__, "spot_strategy", spot_strategy)
        pulumi.set(__self__, "system_disk_category", system_disk_category)
        pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        pulumi.set(__self__, "system_disk_size", system_disk_size)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        Creation time of the scaling configuration.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> _builtins.str:
        """
        Performance mode of the t5 burstable instance.
        """
        return pulumi.get(self, "credit_specification")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Sequence['outputs.GetScalingConfigurationsConfigurationDataDiskResult']:
        """
        Data disks of the scaling configuration.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        (Optional,Available since v1.143.0) Hostname of an ECS instance.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the scaling rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        Image ID of the scaling configuration.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        (Optional,Available since v1.143.0) InstanceName of an ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instancePatternInfos")
    def instance_pattern_infos(self) -> Sequence['outputs.GetScalingConfigurationsConfigurationInstancePatternInfoResult']:
        """
        (Optional, Available since v1.240.0) intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.
        """
        return pulumi.get(self, "instance_pattern_infos")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> _builtins.str:
        """
        Internet charge type of the scaling configuration.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> _builtins.int:
        """
        Internet max bandwidth in of the scaling configuration.
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> _builtins.int:
        """
        Internet max bandwidth of the scaling configuration.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> _builtins.str:
        """
        Lifecycle state of the scaling configuration.
        """
        return pulumi.get(self, "lifecycle_state")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the scaling configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> _builtins.str:
        """
        Scaling group id the scaling configurations belong to.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        Security group ID of the scaling configuration.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> Sequence['outputs.GetScalingConfigurationsConfigurationSpotPriceLimitResult']:
        """
        (Optional, Available since v1.151.0) The maximum price hourly for instance types.
        """
        return pulumi.get(self, "spot_price_limits")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> _builtins.str:
        """
        (Optional, Available since v1.151.0) The spot strategy for a Pay-As-You-Go instance.
        """
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> _builtins.str:
        """
        System disk category of the scaling configuration.
        """
        return pulumi.get(self, "system_disk_category")

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> _builtins.str:
        """
        The performance level of the ESSD used as the system disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> _builtins.int:
        """
        System disk size of the scaling configuration.
        """
        return pulumi.get(self, "system_disk_size")


@pulumi.output_type
class GetScalingConfigurationsConfigurationDataDiskResult(dict):
    def __init__(__self__, *,
                 category: _builtins.str,
                 delete_with_instance: _builtins.bool,
                 device: _builtins.str,
                 performance_level: _builtins.str,
                 size: _builtins.int,
                 snapshot_id: _builtins.str):
        """
        :param _builtins.str category: Category of data disk.
        :param _builtins.bool delete_with_instance: Delete_with_instance attribute of data disk.
        :param _builtins.str device: Device attribute of data disk.
        :param _builtins.str performance_level: The performance level of the ESSD used as data disk.
        :param _builtins.int size: Size of data disk.
        :param _builtins.str snapshot_id: Size of data disk.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "performance_level", performance_level)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "snapshot_id", snapshot_id)

    @_builtins.property
    @pulumi.getter
    def category(self) -> _builtins.str:
        """
        Category of data disk.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> _builtins.bool:
        """
        Delete_with_instance attribute of data disk.
        """
        return pulumi.get(self, "delete_with_instance")

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        Device attribute of data disk.
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> _builtins.str:
        """
        The performance level of the ESSD used as data disk.
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Size of data disk.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> _builtins.str:
        """
        Size of data disk.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class GetScalingConfigurationsConfigurationInstancePatternInfoResult(dict):
    def __init__(__self__, *,
                 architectures: Sequence[_builtins.str],
                 burstable_performance: _builtins.str,
                 cores: _builtins.int,
                 excluded_instance_types: Sequence[_builtins.str],
                 instance_family_level: _builtins.str,
                 max_price: _builtins.float,
                 memory: _builtins.float):
        """
        :param Sequence[_builtins.str] architectures: Architecture N of instance type N. Valid values: X86, Heterogeneous, BareMetal, Arm, SuperComputeCluster.
        :param _builtins.str burstable_performance: Specifies whether to include burstable instance types.  Valid values: Exclude, Include, Required.
        :param _builtins.int cores: The number of vCPUs that are specified for an instance type in instancePatternInfo.
        :param Sequence[_builtins.str] excluded_instance_types: Instance type N that you want to exclude. You can use wildcard characters, such as an asterisk (*), to exclude an instance type or an instance family.
        :param _builtins.str instance_family_level: The instance family level in instancePatternInfo.
        :param _builtins.float max_price: The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
        :param _builtins.float memory: The memory size that is specified for an instance type in instancePatternInfo.
        """
        pulumi.set(__self__, "architectures", architectures)
        pulumi.set(__self__, "burstable_performance", burstable_performance)
        pulumi.set(__self__, "cores", cores)
        pulumi.set(__self__, "excluded_instance_types", excluded_instance_types)
        pulumi.set(__self__, "instance_family_level", instance_family_level)
        pulumi.set(__self__, "max_price", max_price)
        pulumi.set(__self__, "memory", memory)

    @_builtins.property
    @pulumi.getter
    def architectures(self) -> Sequence[_builtins.str]:
        """
        Architecture N of instance type N. Valid values: X86, Heterogeneous, BareMetal, Arm, SuperComputeCluster.
        """
        return pulumi.get(self, "architectures")

    @_builtins.property
    @pulumi.getter(name="burstablePerformance")
    def burstable_performance(self) -> _builtins.str:
        """
        Specifies whether to include burstable instance types.  Valid values: Exclude, Include, Required.
        """
        return pulumi.get(self, "burstable_performance")

    @_builtins.property
    @pulumi.getter
    def cores(self) -> _builtins.int:
        """
        The number of vCPUs that are specified for an instance type in instancePatternInfo.
        """
        return pulumi.get(self, "cores")

    @_builtins.property
    @pulumi.getter(name="excludedInstanceTypes")
    def excluded_instance_types(self) -> Sequence[_builtins.str]:
        """
        Instance type N that you want to exclude. You can use wildcard characters, such as an asterisk (*), to exclude an instance type or an instance family.
        """
        return pulumi.get(self, "excluded_instance_types")

    @_builtins.property
    @pulumi.getter(name="instanceFamilyLevel")
    def instance_family_level(self) -> _builtins.str:
        """
        The instance family level in instancePatternInfo.
        """
        return pulumi.get(self, "instance_family_level")

    @_builtins.property
    @pulumi.getter(name="maxPrice")
    def max_price(self) -> _builtins.float:
        """
        The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
        """
        return pulumi.get(self, "max_price")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.float:
        """
        The memory size that is specified for an instance type in instancePatternInfo.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class GetScalingConfigurationsConfigurationSpotPriceLimitResult(dict):
    def __init__(__self__, *,
                 instance_type: _builtins.str,
                 price_limit: _builtins.float):
        """
        :param _builtins.str instance_type: Resource type of an ECS instance.
        :param _builtins.float price_limit: Price limit hourly of instance type.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "price_limit", price_limit)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="priceLimit")
    def price_limit(self) -> _builtins.float:
        """
        Price limit hourly of instance type.
        """
        return pulumi.get(self, "price_limit")


@pulumi.output_type
class GetScalingGroupsGroupResult(dict):
    def __init__(__self__, *,
                 active_capacity: _builtins.int,
                 active_scaling_configuration: _builtins.str,
                 allocation_strategy: _builtins.str,
                 az_balance: _builtins.bool,
                 capacity_options_compensate_with_on_demand: _builtins.bool,
                 capacity_options_on_demand_base_capacity: _builtins.int,
                 capacity_options_on_demand_percentage_above_base_capacity: _builtins.int,
                 capacity_options_spot_auto_replace_on_demand: _builtins.bool,
                 compensate_with_on_demand: _builtins.bool,
                 cooldown_time: _builtins.int,
                 creation_time: _builtins.str,
                 db_instance_ids: Sequence[_builtins.str],
                 desired_capacity: _builtins.int,
                 enable_desired_capacity: _builtins.bool,
                 group_deletion_protection: _builtins.bool,
                 group_type: _builtins.str,
                 health_check_type: _builtins.str,
                 id: _builtins.str,
                 init_capacity: _builtins.int,
                 launch_template_id: _builtins.str,
                 launch_template_overrides: Sequence['outputs.GetScalingGroupsGroupLaunchTemplateOverrideResult'],
                 launch_template_version: _builtins.str,
                 lifecycle_state: _builtins.str,
                 load_balancer_ids: Sequence[_builtins.str],
                 max_instance_lifetime: _builtins.int,
                 max_size: _builtins.int,
                 min_size: _builtins.int,
                 modification_time: _builtins.str,
                 monitor_group_id: _builtins.str,
                 multi_az_policy: _builtins.str,
                 name: _builtins.str,
                 on_demand_base_capacity: _builtins.int,
                 on_demand_percentage_above_base_capacity: _builtins.int,
                 pending_capacity: _builtins.int,
                 pending_wait_capacity: _builtins.int,
                 protected_capacity: _builtins.int,
                 region_id: _builtins.str,
                 removal_policies: Sequence[_builtins.str],
                 removing_capacity: _builtins.int,
                 removing_wait_capacity: _builtins.int,
                 resource_group_id: _builtins.str,
                 scaling_policy: _builtins.str,
                 spot_allocation_strategy: _builtins.str,
                 spot_capacity: _builtins.int,
                 spot_instance_pools: _builtins.int,
                 spot_instance_remedy: _builtins.bool,
                 standby_capacity: _builtins.int,
                 stop_instance_timeout: _builtins.int,
                 stopped_capacity: _builtins.int,
                 suspended_processes: Sequence[_builtins.str],
                 system_suspended: _builtins.bool,
                 tags: Mapping[str, _builtins.str],
                 total_capacity: _builtins.int,
                 total_instance_count: _builtins.int,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 vswitch_ids: Sequence[_builtins.str]):
        """
        :param _builtins.int active_capacity: Number of active instances in scaling group.
        :param _builtins.str active_scaling_configuration: Active scaling configuration for scaling group.
        :param _builtins.str allocation_strategy: (Available since v1.242.0) The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The allocation policy applies to pay-as-you-go and preemptible instances.
        :param _builtins.bool az_balance: (Available since v1.242.0) Indicates whether instances in the scaling group are evenly distributed across multiple zones.
        :param _builtins.bool capacity_options_compensate_with_on_demand: (Available since v1.249.0) Indicates whether pay-as-you-go instances can be automatically created to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is available only if you set MultiAZPolicy to COST_OPTIMIZED. Valid values: true, false.
        :param _builtins.int capacity_options_on_demand_base_capacity: (Available since v1.249.0) The minimum number of pay-as-you-go instances required in the scaling group. When the actual number of pay-as-you-go instances drops below the minimum threshold, Auto Scaling preferentially creates pay-as-you-go instances. Valid values: 0 to 1000.
        :param _builtins.int capacity_options_on_demand_percentage_above_base_capacity: (Available since v1.249.0) The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. OnDemandBaseCapacity specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group. Valid values: 0 to 100.
        :param _builtins.bool capacity_options_spot_auto_replace_on_demand: (Available since v1.249.0) Indicates whether pay-as-you-go instances can be replaced with preemptible instances. If you specify CompensateWithOnDemand, it may result in a higher percentage of pay-as-you-go instances compared to the value of OnDemandPercentageAboveBaseCapacity. If you specify this parameter, Auto Scaling preferentially deploys preemptible instances to replace the surplus pay-as-you-go instances when preemptible instance types are available. If you specify CompensateWithOnDemand, Auto Scaling creates pay-as-you-go instances when preemptible instance types are insufficient. To avoid retaining these pay-as-you-go instances for extended periods, Auto Scaling attempts to replace them with preemptible instances when sufficient preemptible instance types become available. Valid values: true, false.
        :param _builtins.bool compensate_with_on_demand: (Available since v1.249.0) Indicates whether pay-as-you-go instances can be automatically created to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is available only if you set MultiAZPolicy to COST_OPTIMIZED. Valid values: true, false.
        :param _builtins.int cooldown_time: Default cooldown time of scaling group.
        :param _builtins.str creation_time: Creation time of scaling group.
        :param Sequence[_builtins.str] db_instance_ids: Db instances id which the ECS instance attached to.
        :param _builtins.int desired_capacity: (Available since v1.242.0) The expected number of ECS instances in the scaling group. Auto Scaling automatically maintains the expected number of ECS instances that you specified.
        :param _builtins.bool enable_desired_capacity: (Available since v1.242.0) Indicates whether the Expected Number of Instances feature is enabled.
        :param _builtins.bool group_deletion_protection: Whether the scaling group deletion protection is enabled.
        :param _builtins.str group_type: (Available since v1.242.0) The type of the instances in the scaling group.
        :param _builtins.str health_check_type: The health check method of the scaling group.
        :param _builtins.str id: ID of the scaling group.
        :param _builtins.int init_capacity: (Available since v1.242.0) The number of instances that are in the Initialized state and ready to be scaled out in the scaling group.
        :param _builtins.str launch_template_id: Active launch template ID for scaling group.
        :param Sequence['GetScalingGroupsGroupLaunchTemplateOverrideArgs'] launch_template_overrides: (Available since v1.249.0) The instance types that are specified by using the Extend Launch Template feature.
        :param _builtins.str launch_template_version: Version of active launch template.
        :param _builtins.str lifecycle_state: Lifecycle state of scaling group.
        :param Sequence[_builtins.str] load_balancer_ids: Slb instances id which the ECS instance attached to.
        :param _builtins.int max_instance_lifetime: (Available since v1.242.0) The maximum life span of each instance in the scaling group. Unit: seconds.
        :param _builtins.int max_size: The maximum number of ECS instances.
        :param _builtins.int min_size: The minimum number of ECS instances.
        :param _builtins.str modification_time: The modification time.
        :param _builtins.str monitor_group_id: (Available since v1.242.0) The ID of the CloudMonitor application group that is associated with the scaling group.
        :param _builtins.str multi_az_policy: (Available since v1.242.0) The scaling policy of the multi-zone scaling group of the ECS type.
        :param _builtins.str name: Name of the scaling group.
        :param _builtins.int on_demand_base_capacity: (Available since v1.242.0) The lower limit of the number of pay-as-you-go instances in the scaling group.
        :param _builtins.int on_demand_percentage_above_base_capacity: (Available since v1.242.0) The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. OnDemandBaseCapacity specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group.
        :param _builtins.int pending_capacity: (Available since v1.242.0) The number of ECS instances that are being added to the scaling group and still being configured.
        :param _builtins.int pending_wait_capacity: (Available since v1.242.0) The number of ECS instances that are in the Pending Add state in the scaling group.
        :param _builtins.int protected_capacity: (Available since v1.242.0) The number of ECS instances that are in the Protected state in the scaling group.
        :param _builtins.str region_id: Region ID the scaling group belongs to.
        :param Sequence[_builtins.str] removal_policies: Removal policy used to select the ECS instance to remove from the scaling group.
        :param _builtins.int removing_capacity: (Available since v1.242.0) The number of ECS instances that are being removed from the scaling group.
        :param _builtins.int removing_wait_capacity: (Available since v1.242.0) The number of ECS instances that are in the Pending Remove state in the scaling group.
        :param _builtins.str resource_group_id: (Available since v1.242.0) The ID of the resource group to which the scaling group that you want to query belongs.
        :param _builtins.str scaling_policy: (Available since v1.242.0) The reclaim mode of the scaling group.
        :param _builtins.str spot_allocation_strategy: (Available since v1.242.0) The allocation policy of preemptible instances. This parameter indicates the method used by Auto Scaling to select instance types to create the required number of preemptible instances. This parameter takes effect only if you set multi_az_policy to COMPOSABLE.
        :param _builtins.int spot_capacity: (Available since v1.242.0) The number of preemptible instances in the scaling group.
        :param _builtins.int spot_instance_pools: (Available since v1.242.0) The number of instance types. Auto Scaling creates preemptible instances of multiple instance types that are provided at the lowest price.
        :param _builtins.bool spot_instance_remedy: (Available since v1.242.0) Indicates whether supplementation of preemptible instances is enabled. If this parameter is set to true, Auto Scaling creates an instance to replace a preemptible instance when Auto Scaling receives a system message indicating that the preemptible instance is to be reclaimed.
        :param _builtins.int standby_capacity: (Available since v1.242.0) The number of instances that are in the Standby state in the scaling group.
        :param _builtins.int stop_instance_timeout: (Available since v1.242.0) The period of time that is required by an ECS instance to enter the Stopped state during the scale-in process. Unit: seconds.
        :param _builtins.int stopped_capacity: (Available since v1.242.0) The number of instances that are in Economical Mode in the scaling group.
        :param Sequence[_builtins.str] suspended_processes: The Process in suspension.
        :param _builtins.bool system_suspended: (Available since v1.242.0) Indicates whether Auto Scaling stops executing the scaling operation in the scaling group.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param _builtins.int total_capacity: Number of instances in scaling group.
        :param _builtins.int total_instance_count: The number of all ECS instances in the scaling group.
        :param _builtins.str vpc_id: The ID of the VPC to which the scaling group belongs.
        :param _builtins.str vswitch_id: The ID of the vSwitch to which the scaling group belongs.
        :param Sequence[_builtins.str] vswitch_ids: Vswitches id in which the ECS instance launched.
        """
        pulumi.set(__self__, "active_capacity", active_capacity)
        pulumi.set(__self__, "active_scaling_configuration", active_scaling_configuration)
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        pulumi.set(__self__, "az_balance", az_balance)
        pulumi.set(__self__, "capacity_options_compensate_with_on_demand", capacity_options_compensate_with_on_demand)
        pulumi.set(__self__, "capacity_options_on_demand_base_capacity", capacity_options_on_demand_base_capacity)
        pulumi.set(__self__, "capacity_options_on_demand_percentage_above_base_capacity", capacity_options_on_demand_percentage_above_base_capacity)
        pulumi.set(__self__, "capacity_options_spot_auto_replace_on_demand", capacity_options_spot_auto_replace_on_demand)
        pulumi.set(__self__, "compensate_with_on_demand", compensate_with_on_demand)
        pulumi.set(__self__, "cooldown_time", cooldown_time)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "db_instance_ids", db_instance_ids)
        pulumi.set(__self__, "desired_capacity", desired_capacity)
        pulumi.set(__self__, "enable_desired_capacity", enable_desired_capacity)
        pulumi.set(__self__, "group_deletion_protection", group_deletion_protection)
        pulumi.set(__self__, "group_type", group_type)
        pulumi.set(__self__, "health_check_type", health_check_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "init_capacity", init_capacity)
        pulumi.set(__self__, "launch_template_id", launch_template_id)
        pulumi.set(__self__, "launch_template_overrides", launch_template_overrides)
        pulumi.set(__self__, "launch_template_version", launch_template_version)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "load_balancer_ids", load_balancer_ids)
        pulumi.set(__self__, "max_instance_lifetime", max_instance_lifetime)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "modification_time", modification_time)
        pulumi.set(__self__, "monitor_group_id", monitor_group_id)
        pulumi.set(__self__, "multi_az_policy", multi_az_policy)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        pulumi.set(__self__, "pending_capacity", pending_capacity)
        pulumi.set(__self__, "pending_wait_capacity", pending_wait_capacity)
        pulumi.set(__self__, "protected_capacity", protected_capacity)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "removal_policies", removal_policies)
        pulumi.set(__self__, "removing_capacity", removing_capacity)
        pulumi.set(__self__, "removing_wait_capacity", removing_wait_capacity)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "scaling_policy", scaling_policy)
        pulumi.set(__self__, "spot_allocation_strategy", spot_allocation_strategy)
        pulumi.set(__self__, "spot_capacity", spot_capacity)
        pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        pulumi.set(__self__, "standby_capacity", standby_capacity)
        pulumi.set(__self__, "stop_instance_timeout", stop_instance_timeout)
        pulumi.set(__self__, "stopped_capacity", stopped_capacity)
        pulumi.set(__self__, "suspended_processes", suspended_processes)
        pulumi.set(__self__, "system_suspended", system_suspended)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "total_capacity", total_capacity)
        pulumi.set(__self__, "total_instance_count", total_instance_count)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @_builtins.property
    @pulumi.getter(name="activeCapacity")
    def active_capacity(self) -> _builtins.int:
        """
        Number of active instances in scaling group.
        """
        return pulumi.get(self, "active_capacity")

    @_builtins.property
    @pulumi.getter(name="activeScalingConfiguration")
    def active_scaling_configuration(self) -> _builtins.str:
        """
        Active scaling configuration for scaling group.
        """
        return pulumi.get(self, "active_scaling_configuration")

    @_builtins.property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> _builtins.str:
        """
        (Available since v1.242.0) The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The allocation policy applies to pay-as-you-go and preemptible instances.
        """
        return pulumi.get(self, "allocation_strategy")

    @_builtins.property
    @pulumi.getter(name="azBalance")
    def az_balance(self) -> _builtins.bool:
        """
        (Available since v1.242.0) Indicates whether instances in the scaling group are evenly distributed across multiple zones.
        """
        return pulumi.get(self, "az_balance")

    @_builtins.property
    @pulumi.getter(name="capacityOptionsCompensateWithOnDemand")
    def capacity_options_compensate_with_on_demand(self) -> _builtins.bool:
        """
        (Available since v1.249.0) Indicates whether pay-as-you-go instances can be automatically created to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is available only if you set MultiAZPolicy to COST_OPTIMIZED. Valid values: true, false.
        """
        return pulumi.get(self, "capacity_options_compensate_with_on_demand")

    @_builtins.property
    @pulumi.getter(name="capacityOptionsOnDemandBaseCapacity")
    def capacity_options_on_demand_base_capacity(self) -> _builtins.int:
        """
        (Available since v1.249.0) The minimum number of pay-as-you-go instances required in the scaling group. When the actual number of pay-as-you-go instances drops below the minimum threshold, Auto Scaling preferentially creates pay-as-you-go instances. Valid values: 0 to 1000.
        """
        return pulumi.get(self, "capacity_options_on_demand_base_capacity")

    @_builtins.property
    @pulumi.getter(name="capacityOptionsOnDemandPercentageAboveBaseCapacity")
    def capacity_options_on_demand_percentage_above_base_capacity(self) -> _builtins.int:
        """
        (Available since v1.249.0) The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. OnDemandBaseCapacity specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group. Valid values: 0 to 100.
        """
        return pulumi.get(self, "capacity_options_on_demand_percentage_above_base_capacity")

    @_builtins.property
    @pulumi.getter(name="capacityOptionsSpotAutoReplaceOnDemand")
    def capacity_options_spot_auto_replace_on_demand(self) -> _builtins.bool:
        """
        (Available since v1.249.0) Indicates whether pay-as-you-go instances can be replaced with preemptible instances. If you specify CompensateWithOnDemand, it may result in a higher percentage of pay-as-you-go instances compared to the value of OnDemandPercentageAboveBaseCapacity. If you specify this parameter, Auto Scaling preferentially deploys preemptible instances to replace the surplus pay-as-you-go instances when preemptible instance types are available. If you specify CompensateWithOnDemand, Auto Scaling creates pay-as-you-go instances when preemptible instance types are insufficient. To avoid retaining these pay-as-you-go instances for extended periods, Auto Scaling attempts to replace them with preemptible instances when sufficient preemptible instance types become available. Valid values: true, false.
        """
        return pulumi.get(self, "capacity_options_spot_auto_replace_on_demand")

    @_builtins.property
    @pulumi.getter(name="compensateWithOnDemand")
    def compensate_with_on_demand(self) -> _builtins.bool:
        """
        (Available since v1.249.0) Indicates whether pay-as-you-go instances can be automatically created to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is available only if you set MultiAZPolicy to COST_OPTIMIZED. Valid values: true, false.
        """
        return pulumi.get(self, "compensate_with_on_demand")

    @_builtins.property
    @pulumi.getter(name="cooldownTime")
    def cooldown_time(self) -> _builtins.int:
        """
        Default cooldown time of scaling group.
        """
        return pulumi.get(self, "cooldown_time")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        Creation time of scaling group.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="dbInstanceIds")
    def db_instance_ids(self) -> Sequence[_builtins.str]:
        """
        Db instances id which the ECS instance attached to.
        """
        return pulumi.get(self, "db_instance_ids")

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The expected number of ECS instances in the scaling group. Auto Scaling automatically maintains the expected number of ECS instances that you specified.
        """
        return pulumi.get(self, "desired_capacity")

    @_builtins.property
    @pulumi.getter(name="enableDesiredCapacity")
    def enable_desired_capacity(self) -> _builtins.bool:
        """
        (Available since v1.242.0) Indicates whether the Expected Number of Instances feature is enabled.
        """
        return pulumi.get(self, "enable_desired_capacity")

    @_builtins.property
    @pulumi.getter(name="groupDeletionProtection")
    def group_deletion_protection(self) -> _builtins.bool:
        """
        Whether the scaling group deletion protection is enabled.
        """
        return pulumi.get(self, "group_deletion_protection")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> _builtins.str:
        """
        (Available since v1.242.0) The type of the instances in the scaling group.
        """
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> _builtins.str:
        """
        The health check method of the scaling group.
        """
        return pulumi.get(self, "health_check_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the scaling group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="initCapacity")
    def init_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The number of instances that are in the Initialized state and ready to be scaled out in the scaling group.
        """
        return pulumi.get(self, "init_capacity")

    @_builtins.property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> _builtins.str:
        """
        Active launch template ID for scaling group.
        """
        return pulumi.get(self, "launch_template_id")

    @_builtins.property
    @pulumi.getter(name="launchTemplateOverrides")
    def launch_template_overrides(self) -> Sequence['outputs.GetScalingGroupsGroupLaunchTemplateOverrideResult']:
        """
        (Available since v1.249.0) The instance types that are specified by using the Extend Launch Template feature.
        """
        return pulumi.get(self, "launch_template_overrides")

    @_builtins.property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> _builtins.str:
        """
        Version of active launch template.
        """
        return pulumi.get(self, "launch_template_version")

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> _builtins.str:
        """
        Lifecycle state of scaling group.
        """
        return pulumi.get(self, "lifecycle_state")

    @_builtins.property
    @pulumi.getter(name="loadBalancerIds")
    def load_balancer_ids(self) -> Sequence[_builtins.str]:
        """
        Slb instances id which the ECS instance attached to.
        """
        return pulumi.get(self, "load_balancer_ids")

    @_builtins.property
    @pulumi.getter(name="maxInstanceLifetime")
    def max_instance_lifetime(self) -> _builtins.int:
        """
        (Available since v1.242.0) The maximum life span of each instance in the scaling group. Unit: seconds.
        """
        return pulumi.get(self, "max_instance_lifetime")

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> _builtins.int:
        """
        The maximum number of ECS instances.
        """
        return pulumi.get(self, "max_size")

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> _builtins.int:
        """
        The minimum number of ECS instances.
        """
        return pulumi.get(self, "min_size")

    @_builtins.property
    @pulumi.getter(name="modificationTime")
    def modification_time(self) -> _builtins.str:
        """
        The modification time.
        """
        return pulumi.get(self, "modification_time")

    @_builtins.property
    @pulumi.getter(name="monitorGroupId")
    def monitor_group_id(self) -> _builtins.str:
        """
        (Available since v1.242.0) The ID of the CloudMonitor application group that is associated with the scaling group.
        """
        return pulumi.get(self, "monitor_group_id")

    @_builtins.property
    @pulumi.getter(name="multiAzPolicy")
    def multi_az_policy(self) -> _builtins.str:
        """
        (Available since v1.242.0) The scaling policy of the multi-zone scaling group of the ECS type.
        """
        return pulumi.get(self, "multi_az_policy")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the scaling group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The lower limit of the number of pay-as-you-go instances in the scaling group.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @_builtins.property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. OnDemandBaseCapacity specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @_builtins.property
    @pulumi.getter(name="pendingCapacity")
    def pending_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The number of ECS instances that are being added to the scaling group and still being configured.
        """
        return pulumi.get(self, "pending_capacity")

    @_builtins.property
    @pulumi.getter(name="pendingWaitCapacity")
    def pending_wait_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The number of ECS instances that are in the Pending Add state in the scaling group.
        """
        return pulumi.get(self, "pending_wait_capacity")

    @_builtins.property
    @pulumi.getter(name="protectedCapacity")
    def protected_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The number of ECS instances that are in the Protected state in the scaling group.
        """
        return pulumi.get(self, "protected_capacity")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        Region ID the scaling group belongs to.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="removalPolicies")
    def removal_policies(self) -> Sequence[_builtins.str]:
        """
        Removal policy used to select the ECS instance to remove from the scaling group.
        """
        return pulumi.get(self, "removal_policies")

    @_builtins.property
    @pulumi.getter(name="removingCapacity")
    def removing_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The number of ECS instances that are being removed from the scaling group.
        """
        return pulumi.get(self, "removing_capacity")

    @_builtins.property
    @pulumi.getter(name="removingWaitCapacity")
    def removing_wait_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The number of ECS instances that are in the Pending Remove state in the scaling group.
        """
        return pulumi.get(self, "removing_wait_capacity")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        (Available since v1.242.0) The ID of the resource group to which the scaling group that you want to query belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> _builtins.str:
        """
        (Available since v1.242.0) The reclaim mode of the scaling group.
        """
        return pulumi.get(self, "scaling_policy")

    @_builtins.property
    @pulumi.getter(name="spotAllocationStrategy")
    def spot_allocation_strategy(self) -> _builtins.str:
        """
        (Available since v1.242.0) The allocation policy of preemptible instances. This parameter indicates the method used by Auto Scaling to select instance types to create the required number of preemptible instances. This parameter takes effect only if you set multi_az_policy to COMPOSABLE.
        """
        return pulumi.get(self, "spot_allocation_strategy")

    @_builtins.property
    @pulumi.getter(name="spotCapacity")
    def spot_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The number of preemptible instances in the scaling group.
        """
        return pulumi.get(self, "spot_capacity")

    @_builtins.property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> _builtins.int:
        """
        (Available since v1.242.0) The number of instance types. Auto Scaling creates preemptible instances of multiple instance types that are provided at the lowest price.
        """
        return pulumi.get(self, "spot_instance_pools")

    @_builtins.property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> _builtins.bool:
        """
        (Available since v1.242.0) Indicates whether supplementation of preemptible instances is enabled. If this parameter is set to true, Auto Scaling creates an instance to replace a preemptible instance when Auto Scaling receives a system message indicating that the preemptible instance is to be reclaimed.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @_builtins.property
    @pulumi.getter(name="standbyCapacity")
    def standby_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The number of instances that are in the Standby state in the scaling group.
        """
        return pulumi.get(self, "standby_capacity")

    @_builtins.property
    @pulumi.getter(name="stopInstanceTimeout")
    def stop_instance_timeout(self) -> _builtins.int:
        """
        (Available since v1.242.0) The period of time that is required by an ECS instance to enter the Stopped state during the scale-in process. Unit: seconds.
        """
        return pulumi.get(self, "stop_instance_timeout")

    @_builtins.property
    @pulumi.getter(name="stoppedCapacity")
    def stopped_capacity(self) -> _builtins.int:
        """
        (Available since v1.242.0) The number of instances that are in Economical Mode in the scaling group.
        """
        return pulumi.get(self, "stopped_capacity")

    @_builtins.property
    @pulumi.getter(name="suspendedProcesses")
    def suspended_processes(self) -> Sequence[_builtins.str]:
        """
        The Process in suspension.
        """
        return pulumi.get(self, "suspended_processes")

    @_builtins.property
    @pulumi.getter(name="systemSuspended")
    def system_suspended(self) -> _builtins.bool:
        """
        (Available since v1.242.0) Indicates whether Auto Scaling stops executing the scaling operation in the scaling group.
        """
        return pulumi.get(self, "system_suspended")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalCapacity")
    def total_capacity(self) -> _builtins.int:
        """
        Number of instances in scaling group.
        """
        return pulumi.get(self, "total_capacity")

    @_builtins.property
    @pulumi.getter(name="totalInstanceCount")
    def total_instance_count(self) -> _builtins.int:
        """
        The number of all ECS instances in the scaling group.
        """
        return pulumi.get(self, "total_instance_count")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC to which the scaling group belongs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The ID of the vSwitch to which the scaling group belongs.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[_builtins.str]:
        """
        Vswitches id in which the ECS instance launched.
        """
        return pulumi.get(self, "vswitch_ids")


@pulumi.output_type
class GetScalingGroupsGroupLaunchTemplateOverrideResult(dict):
    def __init__(__self__, *,
                 instance_type: _builtins.str,
                 spot_price_limit: _builtins.float,
                 weighted_capacity: _builtins.int):
        """
        :param _builtins.str instance_type: (Available since v1.249.0) The instance type. The instance type that is specified by this parameter overwrites the instance type that is specified in the launch template.
        :param _builtins.float spot_price_limit: (Available since v1.249.0) The maximum bid price of instance type N that is specified by LaunchTemplateOverride.N.InstanceType. You can specify N instance types by using the Extend Launch Template feature. Valid values of N: 1 to 10.
        :param _builtins.int weighted_capacity: (Available since v1.249.0) The weight of the instance type. The value of this parameter indicates the capacity of a single instance of the specified instance type in the scaling group. A greater weight indicates that a smaller number of instances of the specified instance type are required to reach the expected capacity.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        (Available since v1.249.0) The instance type. The instance type that is specified by this parameter overwrites the instance type that is specified in the launch template.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> _builtins.float:
        """
        (Available since v1.249.0) The maximum bid price of instance type N that is specified by LaunchTemplateOverride.N.InstanceType. You can specify N instance types by using the Extend Launch Template feature. Valid values of N: 1 to 10.
        """
        return pulumi.get(self, "spot_price_limit")

    @_builtins.property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> _builtins.int:
        """
        (Available since v1.249.0) The weight of the instance type. The value of this parameter indicates the capacity of a single instance of the specified instance type in the scaling group. A greater weight indicates that a smaller number of instances of the specified instance type are required to reach the expected capacity.
        """
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class GetScalingRulesRuleResult(dict):
    def __init__(__self__, *,
                 adjustment_type: _builtins.str,
                 adjustment_value: _builtins.int,
                 cooldown: _builtins.int,
                 disable_scale_in: _builtins.bool,
                 estimated_instance_warmup: _builtins.int,
                 hybrid_metrics: Sequence['outputs.GetScalingRulesRuleHybridMetricResult'],
                 hybrid_monitor_namespace: _builtins.str,
                 id: _builtins.str,
                 initial_max_size: _builtins.int,
                 metric_name: _builtins.str,
                 metric_type: _builtins.str,
                 min_adjustment_magnitude: _builtins.int,
                 name: _builtins.str,
                 predictive_scaling_mode: _builtins.str,
                 predictive_task_buffer_time: _builtins.int,
                 predictive_value_behavior: _builtins.str,
                 predictive_value_buffer: _builtins.int,
                 scale_in_evaluation_count: _builtins.int,
                 scale_out_evaluation_count: _builtins.int,
                 scaling_group_id: _builtins.str,
                 scaling_rule_ari: _builtins.str,
                 step_adjustments: Sequence['outputs.GetScalingRulesRuleStepAdjustmentResult'],
                 target_value: _builtins.float,
                 type: _builtins.str):
        """
        :param _builtins.str adjustment_type: Adjustment type of the scaling rule.
        :param _builtins.int adjustment_value: Adjustment value of the scaling rule.
        :param _builtins.int cooldown: Cooldown time of the scaling rule.
        :param _builtins.bool disable_scale_in: (Available since v1.250.0) Indicates whether scale-in is disabled. This parameter is available only if you set ScalingRuleType to TargetTrackingScalingRule. Valid values: true, false.
        :param _builtins.int estimated_instance_warmup: (Available since v1.250.0) The warm-up period during which a series of preparation measures are taken on new instances. Auto Scaling does not monitor the metric data of instances that are being warmed up.
        :param Sequence['GetScalingRulesRuleHybridMetricArgs'] hybrid_metrics: (Available since v1.250.0) The Hybrid Cloud Monitoring metrics.
        :param _builtins.str hybrid_monitor_namespace: (Available since v1.250.0) The ID of the Hybrid Cloud Monitoring namespace.
        :param _builtins.str id: (Available since v1.250.0) The reference ID of the metric in the metric expression.
        :param _builtins.int initial_max_size: (Available since v1.242.0) The maximum number of ECS instances that can be added to the scaling group.
        :param _builtins.str metric_name: (Available since v1.250.0) The name of the Hybrid Cloud Monitoring metric.
        :param _builtins.str metric_type: (Available since v1.250.0) The type of the event-triggered task that is associated with the scaling rule.
        :param _builtins.int min_adjustment_magnitude: Min adjustment magnitude of scaling rule.
        :param _builtins.str name: Name of the scaling rule.
        :param _builtins.str predictive_scaling_mode: (Available since v1.242.0) The mode of the predictive scaling rule.
        :param _builtins.int predictive_task_buffer_time: (Available since v1.242.0) The amount of buffer time before the prediction task is executed. By default, all prediction tasks that are automatically created by a predictive scaling rule are executed on the hour. You can set a buffer time to execute prediction tasks and prepare resources in advance.
        :param _builtins.str predictive_value_behavior: (Available since v1.242.0) The action on the predicted maximum value.
        :param _builtins.int predictive_value_buffer: (Available since v1.242.0) The ratio based on which the predicted value is increased if you set predictive_value_behavior to PredictiveValueOverrideMaxWithBuffer. If the predicted value that is increased by this ratio is greater than the initial maximum capacity, the increased value is used as the maximum value for prediction tasks.
        :param _builtins.int scale_in_evaluation_count: (Available since v1.250.0) After you create a target tracking scaling rule, an event-triggered task is automatically created and associated with the scaling rule. This parameter defines the number of consecutive times the alert condition must be satisfied before the event-triggered task initiates a scale-in operation.
        :param _builtins.int scale_out_evaluation_count: (Available since v1.250.0) After you create a target tracking scaling rule, an event-triggered task is automatically created and associated with the scaling rule. This parameter defines the number of consecutive times the alert condition must be satisfied before the event-triggered task initiates a scale-out operation.
        :param _builtins.str scaling_group_id: Scaling group id the scaling rules belong to.
        :param _builtins.str scaling_rule_ari: Ari of scaling rule.
        :param Sequence['GetScalingRulesRuleStepAdjustmentArgs'] step_adjustments: (Available since v1.250.0) The step adjustments of the step scaling rule.
        :param _builtins.float target_value: (Available since v1.242.0) The target value of the metric.
        :param _builtins.str type: Type of scaling rule.
        """
        pulumi.set(__self__, "adjustment_type", adjustment_type)
        pulumi.set(__self__, "adjustment_value", adjustment_value)
        pulumi.set(__self__, "cooldown", cooldown)
        pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        pulumi.set(__self__, "estimated_instance_warmup", estimated_instance_warmup)
        pulumi.set(__self__, "hybrid_metrics", hybrid_metrics)
        pulumi.set(__self__, "hybrid_monitor_namespace", hybrid_monitor_namespace)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "initial_max_size", initial_max_size)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "metric_type", metric_type)
        pulumi.set(__self__, "min_adjustment_magnitude", min_adjustment_magnitude)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "predictive_scaling_mode", predictive_scaling_mode)
        pulumi.set(__self__, "predictive_task_buffer_time", predictive_task_buffer_time)
        pulumi.set(__self__, "predictive_value_behavior", predictive_value_behavior)
        pulumi.set(__self__, "predictive_value_buffer", predictive_value_buffer)
        pulumi.set(__self__, "scale_in_evaluation_count", scale_in_evaluation_count)
        pulumi.set(__self__, "scale_out_evaluation_count", scale_out_evaluation_count)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "scaling_rule_ari", scaling_rule_ari)
        pulumi.set(__self__, "step_adjustments", step_adjustments)
        pulumi.set(__self__, "target_value", target_value)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> _builtins.str:
        """
        Adjustment type of the scaling rule.
        """
        return pulumi.get(self, "adjustment_type")

    @_builtins.property
    @pulumi.getter(name="adjustmentValue")
    def adjustment_value(self) -> _builtins.int:
        """
        Adjustment value of the scaling rule.
        """
        return pulumi.get(self, "adjustment_value")

    @_builtins.property
    @pulumi.getter
    def cooldown(self) -> _builtins.int:
        """
        Cooldown time of the scaling rule.
        """
        return pulumi.get(self, "cooldown")

    @_builtins.property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> _builtins.bool:
        """
        (Available since v1.250.0) Indicates whether scale-in is disabled. This parameter is available only if you set ScalingRuleType to TargetTrackingScalingRule. Valid values: true, false.
        """
        return pulumi.get(self, "disable_scale_in")

    @_builtins.property
    @pulumi.getter(name="estimatedInstanceWarmup")
    def estimated_instance_warmup(self) -> _builtins.int:
        """
        (Available since v1.250.0) The warm-up period during which a series of preparation measures are taken on new instances. Auto Scaling does not monitor the metric data of instances that are being warmed up.
        """
        return pulumi.get(self, "estimated_instance_warmup")

    @_builtins.property
    @pulumi.getter(name="hybridMetrics")
    def hybrid_metrics(self) -> Sequence['outputs.GetScalingRulesRuleHybridMetricResult']:
        """
        (Available since v1.250.0) The Hybrid Cloud Monitoring metrics.
        """
        return pulumi.get(self, "hybrid_metrics")

    @_builtins.property
    @pulumi.getter(name="hybridMonitorNamespace")
    def hybrid_monitor_namespace(self) -> _builtins.str:
        """
        (Available since v1.250.0) The ID of the Hybrid Cloud Monitoring namespace.
        """
        return pulumi.get(self, "hybrid_monitor_namespace")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (Available since v1.250.0) The reference ID of the metric in the metric expression.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="initialMaxSize")
    def initial_max_size(self) -> _builtins.int:
        """
        (Available since v1.242.0) The maximum number of ECS instances that can be added to the scaling group.
        """
        return pulumi.get(self, "initial_max_size")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> _builtins.str:
        """
        (Available since v1.250.0) The name of the Hybrid Cloud Monitoring metric.
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> _builtins.str:
        """
        (Available since v1.250.0) The type of the event-triggered task that is associated with the scaling rule.
        """
        return pulumi.get(self, "metric_type")

    @_builtins.property
    @pulumi.getter(name="minAdjustmentMagnitude")
    def min_adjustment_magnitude(self) -> _builtins.int:
        """
        Min adjustment magnitude of scaling rule.
        """
        return pulumi.get(self, "min_adjustment_magnitude")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the scaling rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="predictiveScalingMode")
    def predictive_scaling_mode(self) -> _builtins.str:
        """
        (Available since v1.242.0) The mode of the predictive scaling rule.
        """
        return pulumi.get(self, "predictive_scaling_mode")

    @_builtins.property
    @pulumi.getter(name="predictiveTaskBufferTime")
    def predictive_task_buffer_time(self) -> _builtins.int:
        """
        (Available since v1.242.0) The amount of buffer time before the prediction task is executed. By default, all prediction tasks that are automatically created by a predictive scaling rule are executed on the hour. You can set a buffer time to execute prediction tasks and prepare resources in advance.
        """
        return pulumi.get(self, "predictive_task_buffer_time")

    @_builtins.property
    @pulumi.getter(name="predictiveValueBehavior")
    def predictive_value_behavior(self) -> _builtins.str:
        """
        (Available since v1.242.0) The action on the predicted maximum value.
        """
        return pulumi.get(self, "predictive_value_behavior")

    @_builtins.property
    @pulumi.getter(name="predictiveValueBuffer")
    def predictive_value_buffer(self) -> _builtins.int:
        """
        (Available since v1.242.0) The ratio based on which the predicted value is increased if you set predictive_value_behavior to PredictiveValueOverrideMaxWithBuffer. If the predicted value that is increased by this ratio is greater than the initial maximum capacity, the increased value is used as the maximum value for prediction tasks.
        """
        return pulumi.get(self, "predictive_value_buffer")

    @_builtins.property
    @pulumi.getter(name="scaleInEvaluationCount")
    def scale_in_evaluation_count(self) -> _builtins.int:
        """
        (Available since v1.250.0) After you create a target tracking scaling rule, an event-triggered task is automatically created and associated with the scaling rule. This parameter defines the number of consecutive times the alert condition must be satisfied before the event-triggered task initiates a scale-in operation.
        """
        return pulumi.get(self, "scale_in_evaluation_count")

    @_builtins.property
    @pulumi.getter(name="scaleOutEvaluationCount")
    def scale_out_evaluation_count(self) -> _builtins.int:
        """
        (Available since v1.250.0) After you create a target tracking scaling rule, an event-triggered task is automatically created and associated with the scaling rule. This parameter defines the number of consecutive times the alert condition must be satisfied before the event-triggered task initiates a scale-out operation.
        """
        return pulumi.get(self, "scale_out_evaluation_count")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> _builtins.str:
        """
        Scaling group id the scaling rules belong to.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter(name="scalingRuleAri")
    def scaling_rule_ari(self) -> _builtins.str:
        """
        Ari of scaling rule.
        """
        return pulumi.get(self, "scaling_rule_ari")

    @_builtins.property
    @pulumi.getter(name="stepAdjustments")
    def step_adjustments(self) -> Sequence['outputs.GetScalingRulesRuleStepAdjustmentResult']:
        """
        (Available since v1.250.0) The step adjustments of the step scaling rule.
        """
        return pulumi.get(self, "step_adjustments")

    @_builtins.property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> _builtins.float:
        """
        (Available since v1.242.0) The target value of the metric.
        """
        return pulumi.get(self, "target_value")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of scaling rule.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetScalingRulesRuleHybridMetricResult(dict):
    def __init__(__self__, *,
                 dimensions: Sequence['outputs.GetScalingRulesRuleHybridMetricDimensionResult'],
                 expression: _builtins.str,
                 id: _builtins.str,
                 metric_name: _builtins.str,
                 statistic: _builtins.str):
        """
        :param Sequence['GetScalingRulesRuleHybridMetricDimensionArgs'] dimensions: (Available since v1.250.0) The metric dimensions. You can use this parameter to specify the monitored resources.
        :param _builtins.str expression: (Available since v1.250.0) The metric expression that consists of multiple Hybrid Cloud Monitoring metrics. It calculates a result used to trigger scaling events. The expression is written in Reverse Polish Notation (RPN) format and includes only the following operators: +, -, *, /.
        :param _builtins.str id: (Available since v1.250.0) The reference ID of the metric in the metric expression.
        :param _builtins.str metric_name: (Available since v1.250.0) The name of the Hybrid Cloud Monitoring metric.
        :param _builtins.str statistic: (Available since v1.250.0) The statistical method of the metric data.
        """
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "statistic", statistic)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetScalingRulesRuleHybridMetricDimensionResult']:
        """
        (Available since v1.250.0) The metric dimensions. You can use this parameter to specify the monitored resources.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        (Available since v1.250.0) The metric expression that consists of multiple Hybrid Cloud Monitoring metrics. It calculates a result used to trigger scaling events. The expression is written in Reverse Polish Notation (RPN) format and includes only the following operators: +, -, *, /.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (Available since v1.250.0) The reference ID of the metric in the metric expression.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> _builtins.str:
        """
        (Available since v1.250.0) The name of the Hybrid Cloud Monitoring metric.
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter
    def statistic(self) -> _builtins.str:
        """
        (Available since v1.250.0) The statistical method of the metric data.
        """
        return pulumi.get(self, "statistic")


@pulumi.output_type
class GetScalingRulesRuleHybridMetricDimensionResult(dict):
    def __init__(__self__, *,
                 dimension_key: _builtins.str,
                 dimension_value: _builtins.str):
        """
        :param _builtins.str dimension_key: (Available since v1.250.0) The dimension key of the metric.
        :param _builtins.str dimension_value: (Available since v1.250.0) The dimension value of the metric.
        """
        pulumi.set(__self__, "dimension_key", dimension_key)
        pulumi.set(__self__, "dimension_value", dimension_value)

    @_builtins.property
    @pulumi.getter(name="dimensionKey")
    def dimension_key(self) -> _builtins.str:
        """
        (Available since v1.250.0) The dimension key of the metric.
        """
        return pulumi.get(self, "dimension_key")

    @_builtins.property
    @pulumi.getter(name="dimensionValue")
    def dimension_value(self) -> _builtins.str:
        """
        (Available since v1.250.0) The dimension value of the metric.
        """
        return pulumi.get(self, "dimension_value")


@pulumi.output_type
class GetScalingRulesRuleStepAdjustmentResult(dict):
    def __init__(__self__, *,
                 metric_interval_lower_bound: _builtins.str,
                 metric_interval_upper_bound: _builtins.str,
                 scaling_adjustment: _builtins.int):
        """
        :param _builtins.str metric_interval_lower_bound: (Available since v1.250.0) The lower limit of each step adjustment. Valid values: -9.999999E18 to 9.999999E18.
        :param _builtins.str metric_interval_upper_bound: (Available since v1.250.0) The upper limit of each step adjustment. Valid values: -9.999999E18 to 9.999999E18.
        :param _builtins.int scaling_adjustment: (Available since v1.250.0) The number of instances that are scaled in each step adjustment.
        """
        pulumi.set(__self__, "metric_interval_lower_bound", metric_interval_lower_bound)
        pulumi.set(__self__, "metric_interval_upper_bound", metric_interval_upper_bound)
        pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)

    @_builtins.property
    @pulumi.getter(name="metricIntervalLowerBound")
    def metric_interval_lower_bound(self) -> _builtins.str:
        """
        (Available since v1.250.0) The lower limit of each step adjustment. Valid values: -9.999999E18 to 9.999999E18.
        """
        return pulumi.get(self, "metric_interval_lower_bound")

    @_builtins.property
    @pulumi.getter(name="metricIntervalUpperBound")
    def metric_interval_upper_bound(self) -> _builtins.str:
        """
        (Available since v1.250.0) The upper limit of each step adjustment. Valid values: -9.999999E18 to 9.999999E18.
        """
        return pulumi.get(self, "metric_interval_upper_bound")

    @_builtins.property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> _builtins.int:
        """
        (Available since v1.250.0) The number of instances that are scaled in each step adjustment.
        """
        return pulumi.get(self, "scaling_adjustment")


@pulumi.output_type
class GetScheduledTasksTaskResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 launch_expiration_time: _builtins.int,
                 launch_time: _builtins.str,
                 max_value: _builtins.int,
                 min_value: _builtins.int,
                 name: _builtins.str,
                 recurrence_end_time: _builtins.str,
                 recurrence_type: _builtins.str,
                 recurrence_value: _builtins.str,
                 scheduled_action: _builtins.str,
                 task_enabled: _builtins.bool):
        """
        :param _builtins.str description: Description of the scheduled task.
        :param _builtins.str id: ID of the scheduled task id.
        :param _builtins.int launch_expiration_time: The time period during which a failed scheduled task is retried.
        :param _builtins.str launch_time: The time at which the scheduled task is triggered.
        :param _builtins.str name: Name of the scheduled task name.
        :param _builtins.str recurrence_end_time: Specifies the end time after which the scheduled task is no longer repeated.
        :param _builtins.str recurrence_type: Specifies the recurrence type of the scheduled task.
        :param _builtins.str recurrence_value: Specifies how often a scheduled task recurs.
        :param _builtins.str scheduled_action: The operation to be performed when a scheduled task is triggered.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "launch_expiration_time", launch_expiration_time)
        pulumi.set(__self__, "launch_time", launch_time)
        pulumi.set(__self__, "max_value", max_value)
        pulumi.set(__self__, "min_value", min_value)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recurrence_end_time", recurrence_end_time)
        pulumi.set(__self__, "recurrence_type", recurrence_type)
        pulumi.set(__self__, "recurrence_value", recurrence_value)
        pulumi.set(__self__, "scheduled_action", scheduled_action)
        pulumi.set(__self__, "task_enabled", task_enabled)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the scheduled task.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the scheduled task id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="launchExpirationTime")
    def launch_expiration_time(self) -> _builtins.int:
        """
        The time period during which a failed scheduled task is retried.
        """
        return pulumi.get(self, "launch_expiration_time")

    @_builtins.property
    @pulumi.getter(name="launchTime")
    def launch_time(self) -> _builtins.str:
        """
        The time at which the scheduled task is triggered.
        """
        return pulumi.get(self, "launch_time")

    @_builtins.property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> _builtins.int:
        return pulumi.get(self, "max_value")

    @_builtins.property
    @pulumi.getter(name="minValue")
    def min_value(self) -> _builtins.int:
        return pulumi.get(self, "min_value")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the scheduled task name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recurrenceEndTime")
    def recurrence_end_time(self) -> _builtins.str:
        """
        Specifies the end time after which the scheduled task is no longer repeated.
        """
        return pulumi.get(self, "recurrence_end_time")

    @_builtins.property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> _builtins.str:
        """
        Specifies the recurrence type of the scheduled task.
        """
        return pulumi.get(self, "recurrence_type")

    @_builtins.property
    @pulumi.getter(name="recurrenceValue")
    def recurrence_value(self) -> _builtins.str:
        """
        Specifies how often a scheduled task recurs.
        """
        return pulumi.get(self, "recurrence_value")

    @_builtins.property
    @pulumi.getter(name="scheduledAction")
    def scheduled_action(self) -> _builtins.str:
        """
        The operation to be performed when a scheduled task is triggered.
        """
        return pulumi.get(self, "scheduled_action")

    @_builtins.property
    @pulumi.getter(name="taskEnabled")
    def task_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "task_enabled")


