# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouterExpressConnectRouterArgs', 'RouterExpressConnectRouter']

@pulumi.input_type
class RouterExpressConnectRouterArgs:
    def __init__(__self__, *,
                 alibaba_side_asn: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_name: Optional[pulumi.Input[_builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input['RouterExpressConnectRouterRegionArgs']]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RouterExpressConnectRouter resource.
        :param pulumi.Input[_builtins.int] alibaba_side_asn: ASN representing resources.
        :param pulumi.Input[_builtins.str] description: Represents the description of the leased line gateway.
        :param pulumi.Input[_builtins.str] ecr_name: Name of the Gateway representing the leased line.
        :param pulumi.Input[Sequence[pulumi.Input['RouterExpressConnectRouterRegionArgs']]] regions: List of regions representing leased line gateways. See `regions` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the ECR instance belongs.
               - A string consisting of letters, numbers, hyphens (-), and underscores (_), and the string length can be 0 to 64 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        pulumi.set(__self__, "alibaba_side_asn", alibaba_side_asn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ecr_name is not None:
            pulumi.set(__self__, "ecr_name", ecr_name)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="alibabaSideAsn")
    def alibaba_side_asn(self) -> pulumi.Input[_builtins.int]:
        """
        ASN representing resources.
        """
        return pulumi.get(self, "alibaba_side_asn")

    @alibaba_side_asn.setter
    def alibaba_side_asn(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "alibaba_side_asn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents the description of the leased line gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ecrName")
    def ecr_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Gateway representing the leased line.
        """
        return pulumi.get(self, "ecr_name")

    @ecr_name.setter
    def ecr_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecr_name", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterExpressConnectRouterRegionArgs']]]]:
        """
        List of regions representing leased line gateways. See `regions` below.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterExpressConnectRouterRegionArgs']]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the ECR instance belongs.
        - A string consisting of letters, numbers, hyphens (-), and underscores (_), and the string length can be 0 to 64 characters.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RouterExpressConnectRouterState:
    def __init__(__self__, *,
                 alibaba_side_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_name: Optional[pulumi.Input[_builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input['RouterExpressConnectRouterRegionArgs']]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering RouterExpressConnectRouter resources.
        :param pulumi.Input[_builtins.int] alibaba_side_asn: ASN representing resources.
        :param pulumi.Input[_builtins.str] create_time: Represents the creation time of the resource.
        :param pulumi.Input[_builtins.str] description: Represents the description of the leased line gateway.
        :param pulumi.Input[_builtins.str] ecr_name: Name of the Gateway representing the leased line.
        :param pulumi.Input[Sequence[pulumi.Input['RouterExpressConnectRouterRegionArgs']]] regions: List of regions representing leased line gateways. See `regions` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the ECR instance belongs.
               - A string consisting of letters, numbers, hyphens (-), and underscores (_), and the string length can be 0 to 64 characters.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        if alibaba_side_asn is not None:
            pulumi.set(__self__, "alibaba_side_asn", alibaba_side_asn)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ecr_name is not None:
            pulumi.set(__self__, "ecr_name", ecr_name)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="alibabaSideAsn")
    def alibaba_side_asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ASN representing resources.
        """
        return pulumi.get(self, "alibaba_side_asn")

    @alibaba_side_asn.setter
    def alibaba_side_asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "alibaba_side_asn", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents the creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents the description of the leased line gateway.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ecrName")
    def ecr_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Gateway representing the leased line.
        """
        return pulumi.get(self, "ecr_name")

    @ecr_name.setter
    def ecr_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecr_name", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterExpressConnectRouterRegionArgs']]]]:
        """
        List of regions representing leased line gateways. See `regions` below.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterExpressConnectRouterRegionArgs']]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the ECR instance belongs.
        - A string consisting of letters, numbers, hyphens (-), and underscores (_), and the string length can be 0 to 64 characters.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:expressconnect/routerExpressConnectRouter:RouterExpressConnectRouter")
class RouterExpressConnectRouter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alibaba_side_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_name: Optional[pulumi.Input[_builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterExpressConnectRouterRegionArgs', 'RouterExpressConnectRouterRegionArgsDict']]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Import

        Express Connect Router Express Connect Router can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/routerExpressConnectRouter:RouterExpressConnectRouter example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] alibaba_side_asn: ASN representing resources.
        :param pulumi.Input[_builtins.str] description: Represents the description of the leased line gateway.
        :param pulumi.Input[_builtins.str] ecr_name: Name of the Gateway representing the leased line.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterExpressConnectRouterRegionArgs', 'RouterExpressConnectRouterRegionArgsDict']]]] regions: List of regions representing leased line gateways. See `regions` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the ECR instance belongs.
               - A string consisting of letters, numbers, hyphens (-), and underscores (_), and the string length can be 0 to 64 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterExpressConnectRouterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Express Connect Router Express Connect Router can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/routerExpressConnectRouter:RouterExpressConnectRouter example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RouterExpressConnectRouterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterExpressConnectRouterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alibaba_side_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_name: Optional[pulumi.Input[_builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterExpressConnectRouterRegionArgs', 'RouterExpressConnectRouterRegionArgsDict']]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterExpressConnectRouterArgs.__new__(RouterExpressConnectRouterArgs)

            if alibaba_side_asn is None and not opts.urn:
                raise TypeError("Missing required property 'alibaba_side_asn'")
            __props__.__dict__["alibaba_side_asn"] = alibaba_side_asn
            __props__.__dict__["description"] = description
            __props__.__dict__["ecr_name"] = ecr_name
            __props__.__dict__["regions"] = regions
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(RouterExpressConnectRouter, __self__).__init__(
            'alicloud:expressconnect/routerExpressConnectRouter:RouterExpressConnectRouter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alibaba_side_asn: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ecr_name: Optional[pulumi.Input[_builtins.str]] = None,
            regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterExpressConnectRouterRegionArgs', 'RouterExpressConnectRouterRegionArgsDict']]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'RouterExpressConnectRouter':
        """
        Get an existing RouterExpressConnectRouter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] alibaba_side_asn: ASN representing resources.
        :param pulumi.Input[_builtins.str] create_time: Represents the creation time of the resource.
        :param pulumi.Input[_builtins.str] description: Represents the description of the leased line gateway.
        :param pulumi.Input[_builtins.str] ecr_name: Name of the Gateway representing the leased line.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterExpressConnectRouterRegionArgs', 'RouterExpressConnectRouterRegionArgsDict']]]] regions: List of regions representing leased line gateways. See `regions` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the ECR instance belongs.
               - A string consisting of letters, numbers, hyphens (-), and underscores (_), and the string length can be 0 to 64 characters.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterExpressConnectRouterState.__new__(_RouterExpressConnectRouterState)

        __props__.__dict__["alibaba_side_asn"] = alibaba_side_asn
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["ecr_name"] = ecr_name
        __props__.__dict__["regions"] = regions
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return RouterExpressConnectRouter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alibabaSideAsn")
    def alibaba_side_asn(self) -> pulumi.Output[_builtins.int]:
        """
        ASN representing resources.
        """
        return pulumi.get(self, "alibaba_side_asn")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Represents the creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Represents the description of the leased line gateway.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ecrName")
    def ecr_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the Gateway representing the leased line.
        """
        return pulumi.get(self, "ecr_name")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Sequence['outputs.RouterExpressConnectRouterRegion']]:
        """
        List of regions representing leased line gateways. See `regions` below.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which the ECR instance belongs.
        - A string consisting of letters, numbers, hyphens (-), and underscores (_), and the string length can be 0 to 64 characters.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

