# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TrafficQosAssociationArgs', 'TrafficQosAssociation']

@pulumi.input_type
class TrafficQosAssociationArgs:
    def __init__(__self__, *,
                 qos_id: pulumi.Input[_builtins.str],
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TrafficQosAssociation resource.
        :param pulumi.Input[_builtins.str] qos_id: The QoS policy ID.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the associated instance.
        :param pulumi.Input[_builtins.str] instance_type: The type of the associated instance. Value: **physical connection** physical connection.
        """
        pulumi.set(__self__, "qos_id", qos_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)

    @_builtins.property
    @pulumi.getter(name="qosId")
    def qos_id(self) -> pulumi.Input[_builtins.str]:
        """
        The QoS policy ID.
        """
        return pulumi.get(self, "qos_id")

    @qos_id.setter
    def qos_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "qos_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the associated instance. Value: **physical connection** physical connection.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)


@pulumi.input_type
class _TrafficQosAssociationState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TrafficQosAssociation resources.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the associated instance.
        :param pulumi.Input[_builtins.str] instance_type: The type of the associated instance. Value: **physical connection** physical connection.
        :param pulumi.Input[_builtins.str] qos_id: The QoS policy ID.
        :param pulumi.Input[_builtins.str] status: The status of the associated instance. Value:
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if qos_id is not None:
            pulumi.set(__self__, "qos_id", qos_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the associated instance. Value: **physical connection** physical connection.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="qosId")
    def qos_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The QoS policy ID.
        """
        return pulumi.get(self, "qos_id")

    @qos_id.setter
    def qos_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qos_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the associated instance. Value:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:expressconnect/trafficQosAssociation:TrafficQosAssociation")
class TrafficQosAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Express Connect Traffic Qos Association resource. Express Connect QoS associated resources.

        For information about Express Connect Traffic Qos Association and how to use it, see [What is Traffic Qos Association](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/ModifyExpressConnectTrafficQos).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
        create_qos = alicloud.expressconnect.TrafficQos("createQos",
            qos_name=name,
            qos_description="terraform-example")
        associate_qos = alicloud.expressconnect.TrafficQosAssociation("associateQos",
            instance_id=default.ids[1],
            qos_id=create_qos.id,
            instance_type="PHYSICALCONNECTION")
        ```

        ## Import

        Express Connect Traffic Qos Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/trafficQosAssociation:TrafficQosAssociation example <qos_id>:<instance_id>:<instance_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the associated instance.
        :param pulumi.Input[_builtins.str] instance_type: The type of the associated instance. Value: **physical connection** physical connection.
        :param pulumi.Input[_builtins.str] qos_id: The QoS policy ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrafficQosAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Traffic Qos Association resource. Express Connect QoS associated resources.

        For information about Express Connect Traffic Qos Association and how to use it, see [What is Traffic Qos Association](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/ModifyExpressConnectTrafficQos).

        > **NOTE:** Available since v1.224.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
        create_qos = alicloud.expressconnect.TrafficQos("createQos",
            qos_name=name,
            qos_description="terraform-example")
        associate_qos = alicloud.expressconnect.TrafficQosAssociation("associateQos",
            instance_id=default.ids[1],
            qos_id=create_qos.id,
            instance_type="PHYSICALCONNECTION")
        ```

        ## Import

        Express Connect Traffic Qos Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/trafficQosAssociation:TrafficQosAssociation example <qos_id>:<instance_id>:<instance_type>
        ```

        :param str resource_name: The name of the resource.
        :param TrafficQosAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrafficQosAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrafficQosAssociationArgs.__new__(TrafficQosAssociationArgs)

            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["instance_type"] = instance_type
            if qos_id is None and not opts.urn:
                raise TypeError("Missing required property 'qos_id'")
            __props__.__dict__["qos_id"] = qos_id
            __props__.__dict__["status"] = None
        super(TrafficQosAssociation, __self__).__init__(
            'alicloud:expressconnect/trafficQosAssociation:TrafficQosAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            qos_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'TrafficQosAssociation':
        """
        Get an existing TrafficQosAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the associated instance.
        :param pulumi.Input[_builtins.str] instance_type: The type of the associated instance. Value: **physical connection** physical connection.
        :param pulumi.Input[_builtins.str] qos_id: The QoS policy ID.
        :param pulumi.Input[_builtins.str] status: The status of the associated instance. Value:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrafficQosAssociationState.__new__(_TrafficQosAssociationState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["qos_id"] = qos_id
        __props__.__dict__["status"] = status
        return TrafficQosAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the associated instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the associated instance. Value: **physical connection** physical connection.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="qosId")
    def qos_id(self) -> pulumi.Output[_builtins.str]:
        """
        The QoS policy ID.
        """
        return pulumi.get(self, "qos_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the associated instance. Value:
        """
        return pulumi.get(self, "status")

