# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V3CustomDomainArgs', 'V3CustomDomain']

@pulumi.input_type
class V3CustomDomainArgs:
    def __init__(__self__, *,
                 auth_config: Optional[pulumi.Input['V3CustomDomainAuthConfigArgs']] = None,
                 cert_config: Optional[pulumi.Input['V3CustomDomainCertConfigArgs']] = None,
                 custom_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 route_config: Optional[pulumi.Input['V3CustomDomainRouteConfigArgs']] = None,
                 tls_config: Optional[pulumi.Input['V3CustomDomainTlsConfigArgs']] = None,
                 waf_config: Optional[pulumi.Input['V3CustomDomainWafConfigArgs']] = None):
        """
        The set of arguments for constructing a V3CustomDomain resource.
        :param pulumi.Input['V3CustomDomainAuthConfigArgs'] auth_config: Permission authentication configuration See `auth_config` below.
        :param pulumi.Input['V3CustomDomainCertConfigArgs'] cert_config: HTTPS certificate information See `cert_config` below.
        :param pulumi.Input[_builtins.str] custom_domain_name: The name of the resource
        :param pulumi.Input[_builtins.str] protocol: The protocol type supported by the domain name. HTTP: only HTTP protocol is supported. HTTPS: only HTTPS is supported. HTTP,HTTPS: Supports HTTP and HTTPS protocols.
        :param pulumi.Input['V3CustomDomainRouteConfigArgs'] route_config: Route matching rule configuration See `route_config` below.
        :param pulumi.Input['V3CustomDomainTlsConfigArgs'] tls_config: TLS configuration information See `tls_config` below.
        :param pulumi.Input['V3CustomDomainWafConfigArgs'] waf_config: Web application firewall configuration information See `waf_config` below.
        """
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if cert_config is not None:
            pulumi.set(__self__, "cert_config", cert_config)
        if custom_domain_name is not None:
            pulumi.set(__self__, "custom_domain_name", custom_domain_name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if route_config is not None:
            pulumi.set(__self__, "route_config", route_config)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)
        if waf_config is not None:
            pulumi.set(__self__, "waf_config", waf_config)

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['V3CustomDomainAuthConfigArgs']]:
        """
        Permission authentication configuration See `auth_config` below.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['V3CustomDomainAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @_builtins.property
    @pulumi.getter(name="certConfig")
    def cert_config(self) -> Optional[pulumi.Input['V3CustomDomainCertConfigArgs']]:
        """
        HTTPS certificate information See `cert_config` below.
        """
        return pulumi.get(self, "cert_config")

    @cert_config.setter
    def cert_config(self, value: Optional[pulumi.Input['V3CustomDomainCertConfigArgs']]):
        pulumi.set(self, "cert_config", value)

    @_builtins.property
    @pulumi.getter(name="customDomainName")
    def custom_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "custom_domain_name")

    @custom_domain_name.setter
    def custom_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain_name", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol type supported by the domain name. HTTP: only HTTP protocol is supported. HTTPS: only HTTPS is supported. HTTP,HTTPS: Supports HTTP and HTTPS protocols.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="routeConfig")
    def route_config(self) -> Optional[pulumi.Input['V3CustomDomainRouteConfigArgs']]:
        """
        Route matching rule configuration See `route_config` below.
        """
        return pulumi.get(self, "route_config")

    @route_config.setter
    def route_config(self, value: Optional[pulumi.Input['V3CustomDomainRouteConfigArgs']]):
        pulumi.set(self, "route_config", value)

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['V3CustomDomainTlsConfigArgs']]:
        """
        TLS configuration information See `tls_config` below.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['V3CustomDomainTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)

    @_builtins.property
    @pulumi.getter(name="wafConfig")
    def waf_config(self) -> Optional[pulumi.Input['V3CustomDomainWafConfigArgs']]:
        """
        Web application firewall configuration information See `waf_config` below.
        """
        return pulumi.get(self, "waf_config")

    @waf_config.setter
    def waf_config(self, value: Optional[pulumi.Input['V3CustomDomainWafConfigArgs']]):
        pulumi.set(self, "waf_config", value)


@pulumi.input_type
class _V3CustomDomainState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_config: Optional[pulumi.Input['V3CustomDomainAuthConfigArgs']] = None,
                 cert_config: Optional[pulumi.Input['V3CustomDomainCertConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 route_config: Optional[pulumi.Input['V3CustomDomainRouteConfigArgs']] = None,
                 subdomain_count: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_config: Optional[pulumi.Input['V3CustomDomainTlsConfigArgs']] = None,
                 waf_config: Optional[pulumi.Input['V3CustomDomainWafConfigArgs']] = None):
        """
        Input properties used for looking up and filtering V3CustomDomain resources.
        :param pulumi.Input[_builtins.str] account_id: (Available since v1.234.0) The ID of your Alibaba Cloud account (primary account).
        :param pulumi.Input[_builtins.str] api_version: (Available since v1.234.0) API version of Function Compute
        :param pulumi.Input['V3CustomDomainAuthConfigArgs'] auth_config: Permission authentication configuration See `auth_config` below.
        :param pulumi.Input['V3CustomDomainCertConfigArgs'] cert_config: HTTPS certificate information See `cert_config` below.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] custom_domain_name: The name of the resource
        :param pulumi.Input[_builtins.str] last_modified_time: (Available since v1.234.0) The last time the custom domain name was Updated
        :param pulumi.Input[_builtins.str] protocol: The protocol type supported by the domain name. HTTP: only HTTP protocol is supported. HTTPS: only HTTPS is supported. HTTP,HTTPS: Supports HTTP and HTTPS protocols.
        :param pulumi.Input['V3CustomDomainRouteConfigArgs'] route_config: Route matching rule configuration See `route_config` below.
        :param pulumi.Input[_builtins.str] subdomain_count: (Available since v1.234.0) Number of subdomains
        :param pulumi.Input['V3CustomDomainTlsConfigArgs'] tls_config: TLS configuration information See `tls_config` below.
        :param pulumi.Input['V3CustomDomainWafConfigArgs'] waf_config: Web application firewall configuration information See `waf_config` below.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if cert_config is not None:
            pulumi.set(__self__, "cert_config", cert_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_domain_name is not None:
            pulumi.set(__self__, "custom_domain_name", custom_domain_name)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if route_config is not None:
            pulumi.set(__self__, "route_config", route_config)
        if subdomain_count is not None:
            pulumi.set(__self__, "subdomain_count", subdomain_count)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)
        if waf_config is not None:
            pulumi.set(__self__, "waf_config", waf_config)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) The ID of your Alibaba Cloud account (primary account).
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) API version of Function Compute
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_version", value)

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['V3CustomDomainAuthConfigArgs']]:
        """
        Permission authentication configuration See `auth_config` below.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['V3CustomDomainAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @_builtins.property
    @pulumi.getter(name="certConfig")
    def cert_config(self) -> Optional[pulumi.Input['V3CustomDomainCertConfigArgs']]:
        """
        HTTPS certificate information See `cert_config` below.
        """
        return pulumi.get(self, "cert_config")

    @cert_config.setter
    def cert_config(self, value: Optional[pulumi.Input['V3CustomDomainCertConfigArgs']]):
        pulumi.set(self, "cert_config", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customDomainName")
    def custom_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "custom_domain_name")

    @custom_domain_name.setter
    def custom_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) The last time the custom domain name was Updated
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol type supported by the domain name. HTTP: only HTTP protocol is supported. HTTPS: only HTTPS is supported. HTTP,HTTPS: Supports HTTP and HTTPS protocols.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="routeConfig")
    def route_config(self) -> Optional[pulumi.Input['V3CustomDomainRouteConfigArgs']]:
        """
        Route matching rule configuration See `route_config` below.
        """
        return pulumi.get(self, "route_config")

    @route_config.setter
    def route_config(self, value: Optional[pulumi.Input['V3CustomDomainRouteConfigArgs']]):
        pulumi.set(self, "route_config", value)

    @_builtins.property
    @pulumi.getter(name="subdomainCount")
    def subdomain_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.234.0) Number of subdomains
        """
        return pulumi.get(self, "subdomain_count")

    @subdomain_count.setter
    def subdomain_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subdomain_count", value)

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['V3CustomDomainTlsConfigArgs']]:
        """
        TLS configuration information See `tls_config` below.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['V3CustomDomainTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)

    @_builtins.property
    @pulumi.getter(name="wafConfig")
    def waf_config(self) -> Optional[pulumi.Input['V3CustomDomainWafConfigArgs']]:
        """
        Web application firewall configuration information See `waf_config` below.
        """
        return pulumi.get(self, "waf_config")

    @waf_config.setter
    def waf_config(self, value: Optional[pulumi.Input['V3CustomDomainWafConfigArgs']]):
        pulumi.set(self, "waf_config", value)


@pulumi.type_token("alicloud:fc/v3CustomDomain:V3CustomDomain")
class V3CustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_config: Optional[pulumi.Input[Union['V3CustomDomainAuthConfigArgs', 'V3CustomDomainAuthConfigArgsDict']]] = None,
                 cert_config: Optional[pulumi.Input[Union['V3CustomDomainCertConfigArgs', 'V3CustomDomainCertConfigArgsDict']]] = None,
                 custom_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 route_config: Optional[pulumi.Input[Union['V3CustomDomainRouteConfigArgs', 'V3CustomDomainRouteConfigArgsDict']]] = None,
                 tls_config: Optional[pulumi.Input[Union['V3CustomDomainTlsConfigArgs', 'V3CustomDomainTlsConfigArgsDict']]] = None,
                 waf_config: Optional[pulumi.Input[Union['V3CustomDomainWafConfigArgs', 'V3CustomDomainWafConfigArgsDict']]] = None,
                 __props__=None):
        """
        Provides a FCV3 Custom Domain resource.

        Custom Domain names allow users to access FC functions through custom domain names, providing convenience for building Web services using function compute.
        You can bind a custom domain name to Function Compute and set different paths to different functions of different services.

        For information about FCV3 Custom Domain and how to use it, see [What is Custom Domain](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-getcustomdomain).

        > **NOTE:** This content is a technical preview, and should not be relied on in a production environment.

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "flask-07ap.fcv3.1511928242963727.cn-shanghai.fc.devsapp.net"
        function_name1 = config.get("functionName1")
        if function_name1 is None:
            function_name1 = "terraform-custom-domain-t1"
        auth_config = config.get("authConfig")
        if auth_config is None:
            auth_config = \"\"\"{
            "jwks": {
                "keys": [
                    {
                        "p": "8AdUVeldoE4LueFuzEF_C8tvJ7NhlkzS58Gz9KJTPXPr5DADSUVLWJCr5OdFE79q513SneT0UhGo-JfQ1lNMoNv5-YZ1AxIo9fZUEPIe-KyX9ttaglpzCAUE3TeKdm5J-_HZQzBPKbyUwJHAILNgB2-4IBZZwK7LAfbmfi9TmFM",
                        "kty": "RSA",
                        "q": "x8m5ydXwC8AAp9I-hOnUAx6yQJz1Nx-jXPCfn--XdHpJuNcuwRQsuUCSRQs_h3SoCI3qZZdzswQnPrtHFxgUJtQFuMj-QZpyMnebDb81rmczl2KPVUtaVDVagJEF6U9Ov3PfrLhvHUEv5u7p6s4Z6maBUaByfFlhEVPv4_ao8Us",
                        "d": "bjIQAKD2e65gwJ38_Sqq_EmLFuMMey3gjDv1bSCHFH8fyONJTq-utrZfvspz6EegRwW2mSHW9kq87hRwIBW9y7ED5N4KG5gHDjyh57BRE0SKv0Dz1igtKLyp-nl8-aHc1DbONwr1d7tZfFt255TxIN8cPTakXOp2Av_ztql_JotVUGK8eHmXNJFlvq5tc180sKWMHNSNsCUhQgcB1TWb_gwcqxdsIWPsLZI491XKeTGQ98J7z5h6R1cTC97lfJZ0vNtJahd2jHd3WfTUDj5-untMKyZpYYak2Vr8xtFz8H6Q5Rsz8uX_7gtEqYH2CMjPdbXcebrnD1igRSJMYiP0lQ",
                        "e": "AQAB",
                        "use": "sig",
                        "qi": "MTCCRu8AcvvjbHms7V_sDFO7wX0YNyvOJAAbuTmHvQbJ0NDeDta-f-hi8cjkMk7Fpk2hej158E5gDyO62UG99wHZSbmHT34MvIdmhQ5mnbL-5KK9rxde0nayO1ebGepD_GJThPAg9iskzeWpCg5X2etNo2bHoG_ZLQGXj2BQ1VM",
                        "dp": "J4_ttKNcTTnP8PlZO81n1VfYoGCOqylKceyZbq76rVxX-yp2wDLtslFWI8qCtjiMtEnglynPo19JzH-pakocjT70us4Qp0rs-W16ebiOpko8WfHZvzaNUzsQjC3FYrPW-fHo74wc4DI3Cm57jmhCYbdmT9OfQ4UL7Oz3HMFMNAU",
                        "alg": "RS256",
                        "dq": "H4-VgvYB-sk1EU3cRIDv1iJWRHDHKBMeaoM0pD5kLalX1hRgNW4rdoRl1vRk79AU720D11Kqm2APlxBctaA_JrcdxEg0KkbsvV45p11KbKeu9b5DKFVECsN27ZJ7XZUCuqnibtWf7_4pRBD_8PDoFShmS2_ORiiUdflNjzSbEas",
                        "n": "u1LWgoomekdOMfB1lEe96OHehd4XRNCbZRm96RqwOYTTc28Sc_U5wKV2umDzolfoI682ct2BNnRRahYgZPhbOCzHYM6i8sRXjz9Ghx3QHw9zrYACtArwQxrTFiejbfzDPGdPrMQg7T8wjtLtkSyDmCzeXpbIdwmxuLyt_ahLfHelr94kEksMDa42V4Fi5bMW4cCLjlEKzBEHGmFdT8UbLPCvpgsM84JK63e5ifdeI9NdadbC8ZMiR--dFCujT7AgRRyMzxgdn2l-nZJ2ZaYzbLUtAW5_U2kfRVkDNa8d1g__2V5zjU6nfLJ1S2MoXMgRgDPeHpEehZVu2kNaSFvDUQ"
                    }
                ]
            },
            "tokenLookup": "header:auth",
            "claimPassBy": "header:name:name"
        }
        \"\"\"
        certificate = config.get("certificate")
        if certificate is None:
            certificate = \"\"\"-----BEGIN CERTIFICATE-----
        MIIDRjCCAq+gAwIBAgIJAJn3ox4K13PoMA0GCSqGSIb3DQEBBQUAMHYxCzAJBgNV
        BAYTAkNOMQswCQYDVQQIEwJCSjELMAkGA1UEBxMCQkoxDDAKBgNVBAoTA0FMSTEP
        MA0GA1UECxMGQUxJWVVOMQ0wCwYDVQQDEwR0ZXN0MR8wHQYJKoZIhvcNAQkBFhB0
        ZXN0QGhvdG1haWwuY29tMB4XDTE0MTEyNDA2MDQyNVoXDTI0MTEyMTA2MDQyNVow
        djELMAkGA1UEBhMCQ04xCzAJBgNVBAgTAkJKMQswCQYDVQQHEwJCSjEMMAoGA1UE
        ChMDQUxJMQ8wDQYDVQQLEwZBTElZVU4xDTALBgNVBAMTBHRlc3QxHzAdBgkqhkiG
        9w0BCQEWEHRlc3RAaG90bWFpbC5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJ
        AoGBAM7SS3e9+Nj0HKAsRuIDNSsS3UK6b+62YQb2uuhKrp1HMrOx61WSDR2qkAnB
        coG00Uz38EE+9DLYNUVQBK7aSgLP5M1Ak4wr4GqGyCgjejzzh3DshUzLCCy2rook
        KOyRTlPX+Q5l7rE1fcSNzgepcae5i2sE1XXXzLRIDIvQxcspAgMBAAGjgdswgdgw
        HQYDVR0OBBYEFBdy+OuMsvbkV7R14f0OyoLoh2z4MIGoBgNVHSMEgaAwgZ2AFBdy
        +OuMsvbkV7R14f0OyoLoh2z4oXqkeDB2MQswCQYDVQQGEwJDTjELMAkGA1UECBMC
        QkoxCzAJBgNVBAcTAkJKMQwwCgYDVQQKEwNBTEkxDzANBgNVBAsTBkFMSVlVTjEN
        MAsGA1UEAxMEdGVzdDEfMB0GCSqGSIb3DQEJARYQdGVzdEBob3RtYWlsLmNvbYIJ
        AJn3ox4K13PoMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADgYEAY7KOsnyT
        cQzfhiiG7ASjiPakw5wXoycHt5GCvLG5htp2TKVzgv9QTliA3gtfv6oV4zRZx7X1
        Ofi6hVgErtHaXJheuPVeW6eAW8mHBoEfvDAfU3y9waYrtUevSl07643bzKL6v+Qd
        DUBTxOAvSYfXTtI90EAxEG/bJJyOm5LqoiA=
        -----END CERTIFICATE-----
        \"\"\"
        private_key = config.get("privateKey")
        if private_key is None:
            private_key = \"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIICXAIBAAKBgQDO0kt3vfjY9BygLEbiAzUrEt1Cum/utmEG9rroSq6dRzKzsetV
        kg0dqpAJwXKBtNFM9/BBPvQy2DVFUASu2koCz+TNQJOMK+BqhsgoI3o884dw7IVM
        ywgstq6KJCjskU5T1/kOZe6xNX3Ejc4HqXGnuYtrBNV118y0SAyL0MXLKQIDAQAB
        AoGAfe3NxbsGKhN42o4bGsKZPQDfeCHMxayGp5bTd10BtQIE/ST4BcJH+ihAS7Bd
        6FwQlKzivNd4GP1MckemklCXfsVckdL94e8ZbJl23GdWul3v8V+KndJHqv5zVJmP
        hwWoKimwIBTb2s0ctVryr2f18N4hhyFw1yGp0VxclGHkjgECQQD9CvllsnOwHpP4
        MdrDHbdb29QrobKyKW8pPcDd+sth+kP6Y8MnCVuAKXCKj5FeIsgVtfluPOsZjPzz
        71QQWS1dAkEA0T0KXO8gaBQwJhIoo/w6hy5JGZnrNSpOPp5xvJuMAafs2eyvmhJm
        Ev9SN/Pf2VYa1z6FEnBaLOVD6hf6YQIsPQJAX/CZPoW6dzwgvimo1/GcY6eleiWE
        qygqjWhsh71e/3bz7yuEAnj5yE3t7Zshcp+dXR3xxGo0eSuLfLFxHgGxwQJAAxf8
        9DzQ5NkPkTCJi0sqbl8/03IUKTgT6hcbpWdDXa7m8J3wRr3o5nUB+TPQ5nzAbthM
        zWX931YQeACcwhxvHQJBAN5mTzzJD4w4Ma6YTaNHyXakdYfyAWrOkPIWZxfhMfXe
        DrlNdiysTI4Dd1dLeErVpjsckAaOW/JDG5PCSwkaMxk=
        -----END RSA PRIVATE KEY-----
        \"\"\"
        default = alicloud.fc.V3CustomDomain("default",
            custom_domain_name=name,
            route_config={
                "routes": [
                    {
                        "function_name": function_name1,
                        "rewrite_config": {
                            "regex_rules": [
                                {
                                    "match": "/api/*",
                                    "replacement": "$1",
                                },
                                {
                                    "match": "/api1/*",
                                    "replacement": "$1",
                                },
                                {
                                    "match": "/api2/*",
                                    "replacement": "$1",
                                },
                            ],
                            "wildcard_rules": [
                                {
                                    "match": "^/api1/.+?/(.*)",
                                    "replacement": "/api/v1/$1",
                                },
                                {
                                    "match": "^/api2/.+?/(.*)",
                                    "replacement": "/api/v2/$1",
                                },
                                {
                                    "match": "^/api2/.+?/(.*)",
                                    "replacement": "/api/v3/$1",
                                },
                            ],
                            "equal_rules": [
                                {
                                    "match": "/old",
                                    "replacement": "/new",
                                },
                                {
                                    "replacement": "/new1",
                                    "match": "/old1",
                                },
                                {
                                    "match": "/old2",
                                    "replacement": "/new2",
                                },
                            ],
                        },
                        "methods": [
                            "GET",
                            "POST",
                            "DELETE",
                            "HEAD",
                        ],
                        "path": "/a",
                        "qualifier": "LATEST",
                    },
                    {
                        "function_name": function_name1,
                        "methods": ["GET"],
                        "path": "/b",
                        "qualifier": "LATEST",
                    },
                    {
                        "function_name": function_name1,
                        "methods": ["POST"],
                        "path": "/c",
                        "qualifier": "1",
                    },
                ],
            },
            auth_config={
                "auth_type": "jwt",
                "auth_info": auth_config,
            },
            protocol="HTTP,HTTPS",
            cert_config={
                "cert_name": "cert-name",
                "certificate": certificate,
                "private_key": private_key,
            },
            tls_config={
                "cipher_suites": [
                    "TLS_RSA_WITH_AES_128_CBC_SHA",
                    "TLS_RSA_WITH_AES_256_CBC_SHA",
                    "TLS_RSA_WITH_AES_128_GCM_SHA256",
                    "TLS_RSA_WITH_AES_256_GCM_SHA384",
                ],
                "max_version": "TLSv1.3",
                "min_version": "TLSv1.0",
            },
            waf_config={
                "enable_waf": False,
            })
        ```

        ## Import

        FCV3 Custom Domain can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3CustomDomain:V3CustomDomain example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['V3CustomDomainAuthConfigArgs', 'V3CustomDomainAuthConfigArgsDict']] auth_config: Permission authentication configuration See `auth_config` below.
        :param pulumi.Input[Union['V3CustomDomainCertConfigArgs', 'V3CustomDomainCertConfigArgsDict']] cert_config: HTTPS certificate information See `cert_config` below.
        :param pulumi.Input[_builtins.str] custom_domain_name: The name of the resource
        :param pulumi.Input[_builtins.str] protocol: The protocol type supported by the domain name. HTTP: only HTTP protocol is supported. HTTPS: only HTTPS is supported. HTTP,HTTPS: Supports HTTP and HTTPS protocols.
        :param pulumi.Input[Union['V3CustomDomainRouteConfigArgs', 'V3CustomDomainRouteConfigArgsDict']] route_config: Route matching rule configuration See `route_config` below.
        :param pulumi.Input[Union['V3CustomDomainTlsConfigArgs', 'V3CustomDomainTlsConfigArgsDict']] tls_config: TLS configuration information See `tls_config` below.
        :param pulumi.Input[Union['V3CustomDomainWafConfigArgs', 'V3CustomDomainWafConfigArgsDict']] waf_config: Web application firewall configuration information See `waf_config` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[V3CustomDomainArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a FCV3 Custom Domain resource.

        Custom Domain names allow users to access FC functions through custom domain names, providing convenience for building Web services using function compute.
        You can bind a custom domain name to Function Compute and set different paths to different functions of different services.

        For information about FCV3 Custom Domain and how to use it, see [What is Custom Domain](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-getcustomdomain).

        > **NOTE:** This content is a technical preview, and should not be relied on in a production environment.

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "flask-07ap.fcv3.1511928242963727.cn-shanghai.fc.devsapp.net"
        function_name1 = config.get("functionName1")
        if function_name1 is None:
            function_name1 = "terraform-custom-domain-t1"
        auth_config = config.get("authConfig")
        if auth_config is None:
            auth_config = \"\"\"{
            "jwks": {
                "keys": [
                    {
                        "p": "8AdUVeldoE4LueFuzEF_C8tvJ7NhlkzS58Gz9KJTPXPr5DADSUVLWJCr5OdFE79q513SneT0UhGo-JfQ1lNMoNv5-YZ1AxIo9fZUEPIe-KyX9ttaglpzCAUE3TeKdm5J-_HZQzBPKbyUwJHAILNgB2-4IBZZwK7LAfbmfi9TmFM",
                        "kty": "RSA",
                        "q": "x8m5ydXwC8AAp9I-hOnUAx6yQJz1Nx-jXPCfn--XdHpJuNcuwRQsuUCSRQs_h3SoCI3qZZdzswQnPrtHFxgUJtQFuMj-QZpyMnebDb81rmczl2KPVUtaVDVagJEF6U9Ov3PfrLhvHUEv5u7p6s4Z6maBUaByfFlhEVPv4_ao8Us",
                        "d": "bjIQAKD2e65gwJ38_Sqq_EmLFuMMey3gjDv1bSCHFH8fyONJTq-utrZfvspz6EegRwW2mSHW9kq87hRwIBW9y7ED5N4KG5gHDjyh57BRE0SKv0Dz1igtKLyp-nl8-aHc1DbONwr1d7tZfFt255TxIN8cPTakXOp2Av_ztql_JotVUGK8eHmXNJFlvq5tc180sKWMHNSNsCUhQgcB1TWb_gwcqxdsIWPsLZI491XKeTGQ98J7z5h6R1cTC97lfJZ0vNtJahd2jHd3WfTUDj5-untMKyZpYYak2Vr8xtFz8H6Q5Rsz8uX_7gtEqYH2CMjPdbXcebrnD1igRSJMYiP0lQ",
                        "e": "AQAB",
                        "use": "sig",
                        "qi": "MTCCRu8AcvvjbHms7V_sDFO7wX0YNyvOJAAbuTmHvQbJ0NDeDta-f-hi8cjkMk7Fpk2hej158E5gDyO62UG99wHZSbmHT34MvIdmhQ5mnbL-5KK9rxde0nayO1ebGepD_GJThPAg9iskzeWpCg5X2etNo2bHoG_ZLQGXj2BQ1VM",
                        "dp": "J4_ttKNcTTnP8PlZO81n1VfYoGCOqylKceyZbq76rVxX-yp2wDLtslFWI8qCtjiMtEnglynPo19JzH-pakocjT70us4Qp0rs-W16ebiOpko8WfHZvzaNUzsQjC3FYrPW-fHo74wc4DI3Cm57jmhCYbdmT9OfQ4UL7Oz3HMFMNAU",
                        "alg": "RS256",
                        "dq": "H4-VgvYB-sk1EU3cRIDv1iJWRHDHKBMeaoM0pD5kLalX1hRgNW4rdoRl1vRk79AU720D11Kqm2APlxBctaA_JrcdxEg0KkbsvV45p11KbKeu9b5DKFVECsN27ZJ7XZUCuqnibtWf7_4pRBD_8PDoFShmS2_ORiiUdflNjzSbEas",
                        "n": "u1LWgoomekdOMfB1lEe96OHehd4XRNCbZRm96RqwOYTTc28Sc_U5wKV2umDzolfoI682ct2BNnRRahYgZPhbOCzHYM6i8sRXjz9Ghx3QHw9zrYACtArwQxrTFiejbfzDPGdPrMQg7T8wjtLtkSyDmCzeXpbIdwmxuLyt_ahLfHelr94kEksMDa42V4Fi5bMW4cCLjlEKzBEHGmFdT8UbLPCvpgsM84JK63e5ifdeI9NdadbC8ZMiR--dFCujT7AgRRyMzxgdn2l-nZJ2ZaYzbLUtAW5_U2kfRVkDNa8d1g__2V5zjU6nfLJ1S2MoXMgRgDPeHpEehZVu2kNaSFvDUQ"
                    }
                ]
            },
            "tokenLookup": "header:auth",
            "claimPassBy": "header:name:name"
        }
        \"\"\"
        certificate = config.get("certificate")
        if certificate is None:
            certificate = \"\"\"-----BEGIN CERTIFICATE-----
        MIIDRjCCAq+gAwIBAgIJAJn3ox4K13PoMA0GCSqGSIb3DQEBBQUAMHYxCzAJBgNV
        BAYTAkNOMQswCQYDVQQIEwJCSjELMAkGA1UEBxMCQkoxDDAKBgNVBAoTA0FMSTEP
        MA0GA1UECxMGQUxJWVVOMQ0wCwYDVQQDEwR0ZXN0MR8wHQYJKoZIhvcNAQkBFhB0
        ZXN0QGhvdG1haWwuY29tMB4XDTE0MTEyNDA2MDQyNVoXDTI0MTEyMTA2MDQyNVow
        djELMAkGA1UEBhMCQ04xCzAJBgNVBAgTAkJKMQswCQYDVQQHEwJCSjEMMAoGA1UE
        ChMDQUxJMQ8wDQYDVQQLEwZBTElZVU4xDTALBgNVBAMTBHRlc3QxHzAdBgkqhkiG
        9w0BCQEWEHRlc3RAaG90bWFpbC5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJ
        AoGBAM7SS3e9+Nj0HKAsRuIDNSsS3UK6b+62YQb2uuhKrp1HMrOx61WSDR2qkAnB
        coG00Uz38EE+9DLYNUVQBK7aSgLP5M1Ak4wr4GqGyCgjejzzh3DshUzLCCy2rook
        KOyRTlPX+Q5l7rE1fcSNzgepcae5i2sE1XXXzLRIDIvQxcspAgMBAAGjgdswgdgw
        HQYDVR0OBBYEFBdy+OuMsvbkV7R14f0OyoLoh2z4MIGoBgNVHSMEgaAwgZ2AFBdy
        +OuMsvbkV7R14f0OyoLoh2z4oXqkeDB2MQswCQYDVQQGEwJDTjELMAkGA1UECBMC
        QkoxCzAJBgNVBAcTAkJKMQwwCgYDVQQKEwNBTEkxDzANBgNVBAsTBkFMSVlVTjEN
        MAsGA1UEAxMEdGVzdDEfMB0GCSqGSIb3DQEJARYQdGVzdEBob3RtYWlsLmNvbYIJ
        AJn3ox4K13PoMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADgYEAY7KOsnyT
        cQzfhiiG7ASjiPakw5wXoycHt5GCvLG5htp2TKVzgv9QTliA3gtfv6oV4zRZx7X1
        Ofi6hVgErtHaXJheuPVeW6eAW8mHBoEfvDAfU3y9waYrtUevSl07643bzKL6v+Qd
        DUBTxOAvSYfXTtI90EAxEG/bJJyOm5LqoiA=
        -----END CERTIFICATE-----
        \"\"\"
        private_key = config.get("privateKey")
        if private_key is None:
            private_key = \"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIICXAIBAAKBgQDO0kt3vfjY9BygLEbiAzUrEt1Cum/utmEG9rroSq6dRzKzsetV
        kg0dqpAJwXKBtNFM9/BBPvQy2DVFUASu2koCz+TNQJOMK+BqhsgoI3o884dw7IVM
        ywgstq6KJCjskU5T1/kOZe6xNX3Ejc4HqXGnuYtrBNV118y0SAyL0MXLKQIDAQAB
        AoGAfe3NxbsGKhN42o4bGsKZPQDfeCHMxayGp5bTd10BtQIE/ST4BcJH+ihAS7Bd
        6FwQlKzivNd4GP1MckemklCXfsVckdL94e8ZbJl23GdWul3v8V+KndJHqv5zVJmP
        hwWoKimwIBTb2s0ctVryr2f18N4hhyFw1yGp0VxclGHkjgECQQD9CvllsnOwHpP4
        MdrDHbdb29QrobKyKW8pPcDd+sth+kP6Y8MnCVuAKXCKj5FeIsgVtfluPOsZjPzz
        71QQWS1dAkEA0T0KXO8gaBQwJhIoo/w6hy5JGZnrNSpOPp5xvJuMAafs2eyvmhJm
        Ev9SN/Pf2VYa1z6FEnBaLOVD6hf6YQIsPQJAX/CZPoW6dzwgvimo1/GcY6eleiWE
        qygqjWhsh71e/3bz7yuEAnj5yE3t7Zshcp+dXR3xxGo0eSuLfLFxHgGxwQJAAxf8
        9DzQ5NkPkTCJi0sqbl8/03IUKTgT6hcbpWdDXa7m8J3wRr3o5nUB+TPQ5nzAbthM
        zWX931YQeACcwhxvHQJBAN5mTzzJD4w4Ma6YTaNHyXakdYfyAWrOkPIWZxfhMfXe
        DrlNdiysTI4Dd1dLeErVpjsckAaOW/JDG5PCSwkaMxk=
        -----END RSA PRIVATE KEY-----
        \"\"\"
        default = alicloud.fc.V3CustomDomain("default",
            custom_domain_name=name,
            route_config={
                "routes": [
                    {
                        "function_name": function_name1,
                        "rewrite_config": {
                            "regex_rules": [
                                {
                                    "match": "/api/*",
                                    "replacement": "$1",
                                },
                                {
                                    "match": "/api1/*",
                                    "replacement": "$1",
                                },
                                {
                                    "match": "/api2/*",
                                    "replacement": "$1",
                                },
                            ],
                            "wildcard_rules": [
                                {
                                    "match": "^/api1/.+?/(.*)",
                                    "replacement": "/api/v1/$1",
                                },
                                {
                                    "match": "^/api2/.+?/(.*)",
                                    "replacement": "/api/v2/$1",
                                },
                                {
                                    "match": "^/api2/.+?/(.*)",
                                    "replacement": "/api/v3/$1",
                                },
                            ],
                            "equal_rules": [
                                {
                                    "match": "/old",
                                    "replacement": "/new",
                                },
                                {
                                    "replacement": "/new1",
                                    "match": "/old1",
                                },
                                {
                                    "match": "/old2",
                                    "replacement": "/new2",
                                },
                            ],
                        },
                        "methods": [
                            "GET",
                            "POST",
                            "DELETE",
                            "HEAD",
                        ],
                        "path": "/a",
                        "qualifier": "LATEST",
                    },
                    {
                        "function_name": function_name1,
                        "methods": ["GET"],
                        "path": "/b",
                        "qualifier": "LATEST",
                    },
                    {
                        "function_name": function_name1,
                        "methods": ["POST"],
                        "path": "/c",
                        "qualifier": "1",
                    },
                ],
            },
            auth_config={
                "auth_type": "jwt",
                "auth_info": auth_config,
            },
            protocol="HTTP,HTTPS",
            cert_config={
                "cert_name": "cert-name",
                "certificate": certificate,
                "private_key": private_key,
            },
            tls_config={
                "cipher_suites": [
                    "TLS_RSA_WITH_AES_128_CBC_SHA",
                    "TLS_RSA_WITH_AES_256_CBC_SHA",
                    "TLS_RSA_WITH_AES_128_GCM_SHA256",
                    "TLS_RSA_WITH_AES_256_GCM_SHA384",
                ],
                "max_version": "TLSv1.3",
                "min_version": "TLSv1.0",
            },
            waf_config={
                "enable_waf": False,
            })
        ```

        ## Import

        FCV3 Custom Domain can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3CustomDomain:V3CustomDomain example <id>
        ```

        :param str resource_name: The name of the resource.
        :param V3CustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V3CustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_config: Optional[pulumi.Input[Union['V3CustomDomainAuthConfigArgs', 'V3CustomDomainAuthConfigArgsDict']]] = None,
                 cert_config: Optional[pulumi.Input[Union['V3CustomDomainCertConfigArgs', 'V3CustomDomainCertConfigArgsDict']]] = None,
                 custom_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 route_config: Optional[pulumi.Input[Union['V3CustomDomainRouteConfigArgs', 'V3CustomDomainRouteConfigArgsDict']]] = None,
                 tls_config: Optional[pulumi.Input[Union['V3CustomDomainTlsConfigArgs', 'V3CustomDomainTlsConfigArgsDict']]] = None,
                 waf_config: Optional[pulumi.Input[Union['V3CustomDomainWafConfigArgs', 'V3CustomDomainWafConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V3CustomDomainArgs.__new__(V3CustomDomainArgs)

            __props__.__dict__["auth_config"] = auth_config
            __props__.__dict__["cert_config"] = cert_config
            __props__.__dict__["custom_domain_name"] = custom_domain_name
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["route_config"] = route_config
            __props__.__dict__["tls_config"] = tls_config
            __props__.__dict__["waf_config"] = waf_config
            __props__.__dict__["account_id"] = None
            __props__.__dict__["api_version"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["subdomain_count"] = None
        super(V3CustomDomain, __self__).__init__(
            'alicloud:fc/v3CustomDomain:V3CustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            api_version: Optional[pulumi.Input[_builtins.str]] = None,
            auth_config: Optional[pulumi.Input[Union['V3CustomDomainAuthConfigArgs', 'V3CustomDomainAuthConfigArgsDict']]] = None,
            cert_config: Optional[pulumi.Input[Union['V3CustomDomainCertConfigArgs', 'V3CustomDomainCertConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            custom_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            route_config: Optional[pulumi.Input[Union['V3CustomDomainRouteConfigArgs', 'V3CustomDomainRouteConfigArgsDict']]] = None,
            subdomain_count: Optional[pulumi.Input[_builtins.str]] = None,
            tls_config: Optional[pulumi.Input[Union['V3CustomDomainTlsConfigArgs', 'V3CustomDomainTlsConfigArgsDict']]] = None,
            waf_config: Optional[pulumi.Input[Union['V3CustomDomainWafConfigArgs', 'V3CustomDomainWafConfigArgsDict']]] = None) -> 'V3CustomDomain':
        """
        Get an existing V3CustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: (Available since v1.234.0) The ID of your Alibaba Cloud account (primary account).
        :param pulumi.Input[_builtins.str] api_version: (Available since v1.234.0) API version of Function Compute
        :param pulumi.Input[Union['V3CustomDomainAuthConfigArgs', 'V3CustomDomainAuthConfigArgsDict']] auth_config: Permission authentication configuration See `auth_config` below.
        :param pulumi.Input[Union['V3CustomDomainCertConfigArgs', 'V3CustomDomainCertConfigArgsDict']] cert_config: HTTPS certificate information See `cert_config` below.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] custom_domain_name: The name of the resource
        :param pulumi.Input[_builtins.str] last_modified_time: (Available since v1.234.0) The last time the custom domain name was Updated
        :param pulumi.Input[_builtins.str] protocol: The protocol type supported by the domain name. HTTP: only HTTP protocol is supported. HTTPS: only HTTPS is supported. HTTP,HTTPS: Supports HTTP and HTTPS protocols.
        :param pulumi.Input[Union['V3CustomDomainRouteConfigArgs', 'V3CustomDomainRouteConfigArgsDict']] route_config: Route matching rule configuration See `route_config` below.
        :param pulumi.Input[_builtins.str] subdomain_count: (Available since v1.234.0) Number of subdomains
        :param pulumi.Input[Union['V3CustomDomainTlsConfigArgs', 'V3CustomDomainTlsConfigArgsDict']] tls_config: TLS configuration information See `tls_config` below.
        :param pulumi.Input[Union['V3CustomDomainWafConfigArgs', 'V3CustomDomainWafConfigArgsDict']] waf_config: Web application firewall configuration information See `waf_config` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V3CustomDomainState.__new__(_V3CustomDomainState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["auth_config"] = auth_config
        __props__.__dict__["cert_config"] = cert_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_domain_name"] = custom_domain_name
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["route_config"] = route_config
        __props__.__dict__["subdomain_count"] = subdomain_count
        __props__.__dict__["tls_config"] = tls_config
        __props__.__dict__["waf_config"] = waf_config
        return V3CustomDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) The ID of your Alibaba Cloud account (primary account).
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) API version of Function Compute
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> pulumi.Output[Optional['outputs.V3CustomDomainAuthConfig']]:
        """
        Permission authentication configuration See `auth_config` below.
        """
        return pulumi.get(self, "auth_config")

    @_builtins.property
    @pulumi.getter(name="certConfig")
    def cert_config(self) -> pulumi.Output['outputs.V3CustomDomainCertConfig']:
        """
        HTTPS certificate information See `cert_config` below.
        """
        return pulumi.get(self, "cert_config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customDomainName")
    def custom_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "custom_domain_name")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) The last time the custom domain name was Updated
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The protocol type supported by the domain name. HTTP: only HTTP protocol is supported. HTTPS: only HTTPS is supported. HTTP,HTTPS: Supports HTTP and HTTPS protocols.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="routeConfig")
    def route_config(self) -> pulumi.Output[Optional['outputs.V3CustomDomainRouteConfig']]:
        """
        Route matching rule configuration See `route_config` below.
        """
        return pulumi.get(self, "route_config")

    @_builtins.property
    @pulumi.getter(name="subdomainCount")
    def subdomain_count(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.234.0) Number of subdomains
        """
        return pulumi.get(self, "subdomain_count")

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> pulumi.Output['outputs.V3CustomDomainTlsConfig']:
        """
        TLS configuration information See `tls_config` below.
        """
        return pulumi.get(self, "tls_config")

    @_builtins.property
    @pulumi.getter(name="wafConfig")
    def waf_config(self) -> pulumi.Output[Optional['outputs.V3CustomDomainWafConfig']]:
        """
        Web application firewall configuration information See `waf_config` below.
        """
        return pulumi.get(self, "waf_config")

