# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V3FunctionArgs', 'V3Function']

@pulumi.input_type
class V3FunctionArgs:
    def __init__(__self__, *,
                 handler: pulumi.Input[_builtins.str],
                 runtime: pulumi.Input[_builtins.str],
                 code: Optional[pulumi.Input['V3FunctionCodeArgs']] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 custom_container_config: Optional[pulumi.Input['V3FunctionCustomContainerConfigArgs']] = None,
                 custom_dns: Optional[pulumi.Input['V3FunctionCustomDnsArgs']] = None,
                 custom_runtime_config: Optional[pulumi.Input['V3FunctionCustomRuntimeConfigArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_config: Optional[pulumi.Input['V3FunctionGpuConfigArgs']] = None,
                 instance_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_lifecycle_config: Optional[pulumi.Input['V3FunctionInstanceLifecycleConfigArgs']] = None,
                 internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 invocation_restriction: Optional[pulumi.Input['V3FunctionInvocationRestrictionArgs']] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input['V3FunctionLogConfigArgs']] = None,
                 memory_size: Optional[pulumi.Input[_builtins.int]] = None,
                 nas_config: Optional[pulumi.Input['V3FunctionNasConfigArgs']] = None,
                 oss_mount_config: Optional[pulumi.Input['V3FunctionOssMountConfigArgs']] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity_config: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_config: Optional[pulumi.Input['V3FunctionVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a V3Function resource.
        :param pulumi.Input[_builtins.str] handler: Function Handler: the call entry for the function compute system to run your function.
        :param pulumi.Input[_builtins.str] runtime: Function runtime type.
        :param pulumi.Input['V3FunctionCodeArgs'] code: Function code ZIP package. code and customContainerConfig. See `code` below.
        :param pulumi.Input[_builtins.float] cpu: The CPU specification of the function. The unit is vCPU, which is a multiple of the 0.05 vCPU.
        :param pulumi.Input['V3FunctionCustomContainerConfigArgs'] custom_container_config: The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
        :param pulumi.Input['V3FunctionCustomDnsArgs'] custom_dns: Function custom DNS configuration See `custom_dns` below.
        :param pulumi.Input['V3FunctionCustomRuntimeConfigArgs'] custom_runtime_config: Customize the runtime configuration. See `custom_runtime_config` below.
        :param pulumi.Input[_builtins.str] description: The description of the function. The function compute system does not use this attribute value, but we recommend that you set a concise and clear description for the function.
        :param pulumi.Input[_builtins.int] disk_size: The disk specification of the function, in MB. The optional value is 512 MB or 10240MB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: The environment variable set for the function, you can get the value of the environment variable in the function.
        :param pulumi.Input[_builtins.str] function_name: The function name. Consists of uppercase and lowercase letters, digits (0 to 9), underscores (_), and dashes (-). It must begin with an English letter (a ~ z), (A ~ Z), or an underscore (_). Case sensitive. The length is 1~128 characters.
        :param pulumi.Input['V3FunctionGpuConfigArgs'] gpu_config: Function GPU configuration. See `gpu_config` below.
        :param pulumi.Input[_builtins.int] instance_concurrency: Maximum instance concurrency.
        :param pulumi.Input[_builtins.str] instance_isolation_mode: Instance isolation mode
        :param pulumi.Input['V3FunctionInstanceLifecycleConfigArgs'] instance_lifecycle_config: Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
        :param pulumi.Input[_builtins.bool] internet_access: Allow function to access public network
        :param pulumi.Input['V3FunctionInvocationRestrictionArgs'] invocation_restriction: Invocation Restriction Detail See `invocation_restriction` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] layers: The list of layers.
        :param pulumi.Input['V3FunctionLogConfigArgs'] log_config: The logs generated by the function are written to the configured Logstore. See `log_config` below.
        :param pulumi.Input[_builtins.int] memory_size: The memory specification of the function. The unit is MB. The memory size is a multiple of 64MB. The minimum value is 128MB and the maximum value is 32GB. At the same time, the ratio of cpu to memorySize (calculated by GB) should be between 1:1 and 1:4.
        :param pulumi.Input['V3FunctionNasConfigArgs'] nas_config: NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
        :param pulumi.Input['V3FunctionOssMountConfigArgs'] oss_mount_config: OSS mount configuration See `oss_mount_config` below.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID.
        :param pulumi.Input[_builtins.str] role: The user is authorized to the RAM role of function compute. After the configuration, function compute will assume this role to generate temporary access credentials. In the function, you can use the temporary access credentials of the role to access the specified Alibaba cloud service, such as OSS and OTS
        :param pulumi.Input[_builtins.str] session_affinity: The affinity policy of the function compute call request. To implement the request affinity of the MCP SSE protocol, set it to MCP_SSE. If Cookie affinity is used, it can be set to GENERATED_COOKIE. If Header affinity is used, it can be set to HEADER_FIELD. If it is not set or set to NONE, the affinity effect is not set, and the request is routed according to the default scheduling policy of the function calculation system.
        :param pulumi.Input[_builtins.str] session_affinity_config: When you set the sessionAffinity affinity type, you need to set the relevant affinity configuration. For example, the MCP_SSE affinity needs to fill in the mcpssessionaffinityconfig configuration. The Cookie affinity needs to be filled with the CookieSessionAffinityConfig configuration, and the Header Field affinity needs to be filled with the HeaderFieldSessionAffinityConfig configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.int] timeout: The maximum running time of the function, in seconds.
        :param pulumi.Input['V3FunctionVpcConfigArgs'] vpc_config: VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
        """
        pulumi.set(__self__, "handler", handler)
        pulumi.set(__self__, "runtime", runtime)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if custom_container_config is not None:
            pulumi.set(__self__, "custom_container_config", custom_container_config)
        if custom_dns is not None:
            pulumi.set(__self__, "custom_dns", custom_dns)
        if custom_runtime_config is not None:
            pulumi.set(__self__, "custom_runtime_config", custom_runtime_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if gpu_config is not None:
            pulumi.set(__self__, "gpu_config", gpu_config)
        if instance_concurrency is not None:
            pulumi.set(__self__, "instance_concurrency", instance_concurrency)
        if instance_isolation_mode is not None:
            pulumi.set(__self__, "instance_isolation_mode", instance_isolation_mode)
        if instance_lifecycle_config is not None:
            pulumi.set(__self__, "instance_lifecycle_config", instance_lifecycle_config)
        if internet_access is not None:
            pulumi.set(__self__, "internet_access", internet_access)
        if invocation_restriction is not None:
            pulumi.set(__self__, "invocation_restriction", invocation_restriction)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if nas_config is not None:
            pulumi.set(__self__, "nas_config", nas_config)
        if oss_mount_config is not None:
            pulumi.set(__self__, "oss_mount_config", oss_mount_config)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if session_affinity_config is not None:
            pulumi.set(__self__, "session_affinity_config", session_affinity_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @_builtins.property
    @pulumi.getter
    def handler(self) -> pulumi.Input[_builtins.str]:
        """
        Function Handler: the call entry for the function compute system to run your function.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "handler", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[_builtins.str]:
        """
        Function runtime type.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input['V3FunctionCodeArgs']]:
        """
        Function code ZIP package. code and customContainerConfig. See `code` below.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input['V3FunctionCodeArgs']]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The CPU specification of the function. The unit is vCPU, which is a multiple of the 0.05 vCPU.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="customContainerConfig")
    def custom_container_config(self) -> Optional[pulumi.Input['V3FunctionCustomContainerConfigArgs']]:
        """
        The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
        """
        return pulumi.get(self, "custom_container_config")

    @custom_container_config.setter
    def custom_container_config(self, value: Optional[pulumi.Input['V3FunctionCustomContainerConfigArgs']]):
        pulumi.set(self, "custom_container_config", value)

    @_builtins.property
    @pulumi.getter(name="customDns")
    def custom_dns(self) -> Optional[pulumi.Input['V3FunctionCustomDnsArgs']]:
        """
        Function custom DNS configuration See `custom_dns` below.
        """
        return pulumi.get(self, "custom_dns")

    @custom_dns.setter
    def custom_dns(self, value: Optional[pulumi.Input['V3FunctionCustomDnsArgs']]):
        pulumi.set(self, "custom_dns", value)

    @_builtins.property
    @pulumi.getter(name="customRuntimeConfig")
    def custom_runtime_config(self) -> Optional[pulumi.Input['V3FunctionCustomRuntimeConfigArgs']]:
        """
        Customize the runtime configuration. See `custom_runtime_config` below.
        """
        return pulumi.get(self, "custom_runtime_config")

    @custom_runtime_config.setter
    def custom_runtime_config(self, value: Optional[pulumi.Input['V3FunctionCustomRuntimeConfigArgs']]):
        pulumi.set(self, "custom_runtime_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the function. The function compute system does not use this attribute value, but we recommend that you set a concise and clear description for the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The disk specification of the function, in MB. The optional value is 512 MB or 10240MB.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The environment variable set for the function, you can get the value of the environment variable in the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The function name. Consists of uppercase and lowercase letters, digits (0 to 9), underscores (_), and dashes (-). It must begin with an English letter (a ~ z), (A ~ Z), or an underscore (_). Case sensitive. The length is 1~128 characters.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="gpuConfig")
    def gpu_config(self) -> Optional[pulumi.Input['V3FunctionGpuConfigArgs']]:
        """
        Function GPU configuration. See `gpu_config` below.
        """
        return pulumi.get(self, "gpu_config")

    @gpu_config.setter
    def gpu_config(self, value: Optional[pulumi.Input['V3FunctionGpuConfigArgs']]):
        pulumi.set(self, "gpu_config", value)

    @_builtins.property
    @pulumi.getter(name="instanceConcurrency")
    def instance_concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum instance concurrency.
        """
        return pulumi.get(self, "instance_concurrency")

    @instance_concurrency.setter
    def instance_concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_concurrency", value)

    @_builtins.property
    @pulumi.getter(name="instanceIsolationMode")
    def instance_isolation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance isolation mode
        """
        return pulumi.get(self, "instance_isolation_mode")

    @instance_isolation_mode.setter
    def instance_isolation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_isolation_mode", value)

    @_builtins.property
    @pulumi.getter(name="instanceLifecycleConfig")
    def instance_lifecycle_config(self) -> Optional[pulumi.Input['V3FunctionInstanceLifecycleConfigArgs']]:
        """
        Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
        """
        return pulumi.get(self, "instance_lifecycle_config")

    @instance_lifecycle_config.setter
    def instance_lifecycle_config(self, value: Optional[pulumi.Input['V3FunctionInstanceLifecycleConfigArgs']]):
        pulumi.set(self, "instance_lifecycle_config", value)

    @_builtins.property
    @pulumi.getter(name="internetAccess")
    def internet_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow function to access public network
        """
        return pulumi.get(self, "internet_access")

    @internet_access.setter
    def internet_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_access", value)

    @_builtins.property
    @pulumi.getter(name="invocationRestriction")
    def invocation_restriction(self) -> Optional[pulumi.Input['V3FunctionInvocationRestrictionArgs']]:
        """
        Invocation Restriction Detail See `invocation_restriction` below.
        """
        return pulumi.get(self, "invocation_restriction")

    @invocation_restriction.setter
    def invocation_restriction(self, value: Optional[pulumi.Input['V3FunctionInvocationRestrictionArgs']]):
        pulumi.set(self, "invocation_restriction", value)

    @_builtins.property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of layers.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "layers", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['V3FunctionLogConfigArgs']]:
        """
        The logs generated by the function are written to the configured Logstore. See `log_config` below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['V3FunctionLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory specification of the function. The unit is MB. The memory size is a multiple of 64MB. The minimum value is 128MB and the maximum value is 32GB. At the same time, the ratio of cpu to memorySize (calculated by GB) should be between 1:1 and 1:4.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size", value)

    @_builtins.property
    @pulumi.getter(name="nasConfig")
    def nas_config(self) -> Optional[pulumi.Input['V3FunctionNasConfigArgs']]:
        """
        NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
        """
        return pulumi.get(self, "nas_config")

    @nas_config.setter
    def nas_config(self, value: Optional[pulumi.Input['V3FunctionNasConfigArgs']]):
        pulumi.set(self, "nas_config", value)

    @_builtins.property
    @pulumi.getter(name="ossMountConfig")
    def oss_mount_config(self) -> Optional[pulumi.Input['V3FunctionOssMountConfigArgs']]:
        """
        OSS mount configuration See `oss_mount_config` below.
        """
        return pulumi.get(self, "oss_mount_config")

    @oss_mount_config.setter
    def oss_mount_config(self, value: Optional[pulumi.Input['V3FunctionOssMountConfigArgs']]):
        pulumi.set(self, "oss_mount_config", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user is authorized to the RAM role of function compute. After the configuration, function compute will assume this role to generate temporary access credentials. In the function, you can use the temporary access credentials of the role to access the specified Alibaba cloud service, such as OSS and OTS
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The affinity policy of the function compute call request. To implement the request affinity of the MCP SSE protocol, set it to MCP_SSE. If Cookie affinity is used, it can be set to GENERATED_COOKIE. If Header affinity is used, it can be set to HEADER_FIELD. If it is not set or set to NONE, the affinity effect is not set, and the request is routed according to the default scheduling policy of the function calculation system.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_affinity", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinityConfig")
    def session_affinity_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When you set the sessionAffinity affinity type, you need to set the relevant affinity configuration. For example, the MCP_SSE affinity needs to fill in the mcpssessionaffinityconfig configuration. The Cookie affinity needs to be filled with the CookieSessionAffinityConfig configuration, and the Header Field affinity needs to be filled with the HeaderFieldSessionAffinityConfig configuration.
        """
        return pulumi.get(self, "session_affinity_config")

    @session_affinity_config.setter
    def session_affinity_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_affinity_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum running time of the function, in seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['V3FunctionVpcConfigArgs']]:
        """
        VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['V3FunctionVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.input_type
class _V3FunctionState:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input['V3FunctionCodeArgs']] = None,
                 code_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_container_config: Optional[pulumi.Input['V3FunctionCustomContainerConfigArgs']] = None,
                 custom_dns: Optional[pulumi.Input['V3FunctionCustomDnsArgs']] = None,
                 custom_runtime_config: Optional[pulumi.Input['V3FunctionCustomRuntimeConfigArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 function_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 function_id: Optional[pulumi.Input[_builtins.str]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_config: Optional[pulumi.Input['V3FunctionGpuConfigArgs']] = None,
                 handler: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_lifecycle_config: Optional[pulumi.Input['V3FunctionInstanceLifecycleConfigArgs']] = None,
                 internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 invocation_restriction: Optional[pulumi.Input['V3FunctionInvocationRestrictionArgs']] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
                 last_update_status: Optional[pulumi.Input[_builtins.str]] = None,
                 last_update_status_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 last_update_status_reason_code: Optional[pulumi.Input[_builtins.str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input['V3FunctionLogConfigArgs']] = None,
                 memory_size: Optional[pulumi.Input[_builtins.int]] = None,
                 nas_config: Optional[pulumi.Input['V3FunctionNasConfigArgs']] = None,
                 oss_mount_config: Optional[pulumi.Input['V3FunctionOssMountConfigArgs']] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity_config: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 state_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 state_reason_code: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tracing_config: Optional[pulumi.Input['V3FunctionTracingConfigArgs']] = None,
                 vpc_config: Optional[pulumi.Input['V3FunctionVpcConfigArgs']] = None):
        """
        Input properties used for looking up and filtering V3Function resources.
        :param pulumi.Input['V3FunctionCodeArgs'] code: Function code ZIP package. code and customContainerConfig. See `code` below.
        :param pulumi.Input[_builtins.int] code_size: The code package size of the function returned by the system, in byte Example : 1024
        :param pulumi.Input[_builtins.float] cpu: The CPU specification of the function. The unit is vCPU, which is a multiple of the 0.05 vCPU.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the function.
        :param pulumi.Input['V3FunctionCustomContainerConfigArgs'] custom_container_config: The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
        :param pulumi.Input['V3FunctionCustomDnsArgs'] custom_dns: Function custom DNS configuration See `custom_dns` below.
        :param pulumi.Input['V3FunctionCustomRuntimeConfigArgs'] custom_runtime_config: Customize the runtime configuration. See `custom_runtime_config` below.
        :param pulumi.Input[_builtins.str] description: The description of the function. The function compute system does not use this attribute value, but we recommend that you set a concise and clear description for the function.
        :param pulumi.Input[_builtins.int] disk_size: The disk specification of the function, in MB. The optional value is 512 MB or 10240MB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: The environment variable set for the function, you can get the value of the environment variable in the function.
        :param pulumi.Input[_builtins.str] function_arn: ARN of function
        :param pulumi.Input[_builtins.str] function_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] function_name: The function name. Consists of uppercase and lowercase letters, digits (0 to 9), underscores (_), and dashes (-). It must begin with an English letter (a ~ z), (A ~ Z), or an underscore (_). Case sensitive. The length is 1~128 characters.
        :param pulumi.Input['V3FunctionGpuConfigArgs'] gpu_config: Function GPU configuration. See `gpu_config` below.
        :param pulumi.Input[_builtins.str] handler: Function Handler: the call entry for the function compute system to run your function.
        :param pulumi.Input[_builtins.int] instance_concurrency: Maximum instance concurrency.
        :param pulumi.Input[_builtins.str] instance_isolation_mode: Instance isolation mode
        :param pulumi.Input['V3FunctionInstanceLifecycleConfigArgs'] instance_lifecycle_config: Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
        :param pulumi.Input[_builtins.bool] internet_access: Allow function to access public network
        :param pulumi.Input['V3FunctionInvocationRestrictionArgs'] invocation_restriction: Invocation Restriction Detail See `invocation_restriction` below.
        :param pulumi.Input[_builtins.str] last_modified_time: Last time the function was Updated
        :param pulumi.Input[_builtins.str] last_update_status: The status of the last function update operation. When the function is created successfully, the value is Successful. Optional values are Successful, Failed, and InProgress.
        :param pulumi.Input[_builtins.str] last_update_status_reason: The reason that caused the last function to update the Operation State to the current value
        :param pulumi.Input[_builtins.str] last_update_status_reason_code: Status code of the reason that caused the last function update operation status to the current value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] layers: The list of layers.
        :param pulumi.Input['V3FunctionLogConfigArgs'] log_config: The logs generated by the function are written to the configured Logstore. See `log_config` below.
        :param pulumi.Input[_builtins.int] memory_size: The memory specification of the function. The unit is MB. The memory size is a multiple of 64MB. The minimum value is 128MB and the maximum value is 32GB. At the same time, the ratio of cpu to memorySize (calculated by GB) should be between 1:1 and 1:4.
        :param pulumi.Input['V3FunctionNasConfigArgs'] nas_config: NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
        :param pulumi.Input['V3FunctionOssMountConfigArgs'] oss_mount_config: OSS mount configuration See `oss_mount_config` below.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID.
        :param pulumi.Input[_builtins.str] role: The user is authorized to the RAM role of function compute. After the configuration, function compute will assume this role to generate temporary access credentials. In the function, you can use the temporary access credentials of the role to access the specified Alibaba cloud service, such as OSS and OTS
        :param pulumi.Input[_builtins.str] runtime: Function runtime type.
        :param pulumi.Input[_builtins.str] session_affinity: The affinity policy of the function compute call request. To implement the request affinity of the MCP SSE protocol, set it to MCP_SSE. If Cookie affinity is used, it can be set to GENERATED_COOKIE. If Header affinity is used, it can be set to HEADER_FIELD. If it is not set or set to NONE, the affinity effect is not set, and the request is routed according to the default scheduling policy of the function calculation system.
        :param pulumi.Input[_builtins.str] session_affinity_config: When you set the sessionAffinity affinity type, you need to set the relevant affinity configuration. For example, the MCP_SSE affinity needs to fill in the mcpssessionaffinityconfig configuration. The Cookie affinity needs to be filled with the CookieSessionAffinityConfig configuration, and the Header Field affinity needs to be filled with the HeaderFieldSessionAffinityConfig configuration.
        :param pulumi.Input[_builtins.str] state: Function Status
        :param pulumi.Input[_builtins.str] state_reason: The reason why the function is in the current state
        :param pulumi.Input[_builtins.str] state_reason_code: The status code of the reason the function is in the current state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.int] timeout: The maximum running time of the function, in seconds.
        :param pulumi.Input['V3FunctionTracingConfigArgs'] tracing_config: Tracing configuration
        :param pulumi.Input['V3FunctionVpcConfigArgs'] vpc_config: VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if code_size is not None:
            pulumi.set(__self__, "code_size", code_size)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_container_config is not None:
            pulumi.set(__self__, "custom_container_config", custom_container_config)
        if custom_dns is not None:
            pulumi.set(__self__, "custom_dns", custom_dns)
        if custom_runtime_config is not None:
            pulumi.set(__self__, "custom_runtime_config", custom_runtime_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if gpu_config is not None:
            pulumi.set(__self__, "gpu_config", gpu_config)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if instance_concurrency is not None:
            pulumi.set(__self__, "instance_concurrency", instance_concurrency)
        if instance_isolation_mode is not None:
            pulumi.set(__self__, "instance_isolation_mode", instance_isolation_mode)
        if instance_lifecycle_config is not None:
            pulumi.set(__self__, "instance_lifecycle_config", instance_lifecycle_config)
        if internet_access is not None:
            pulumi.set(__self__, "internet_access", internet_access)
        if invocation_restriction is not None:
            pulumi.set(__self__, "invocation_restriction", invocation_restriction)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if last_update_status is not None:
            pulumi.set(__self__, "last_update_status", last_update_status)
        if last_update_status_reason is not None:
            pulumi.set(__self__, "last_update_status_reason", last_update_status_reason)
        if last_update_status_reason_code is not None:
            pulumi.set(__self__, "last_update_status_reason_code", last_update_status_reason_code)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if nas_config is not None:
            pulumi.set(__self__, "nas_config", nas_config)
        if oss_mount_config is not None:
            pulumi.set(__self__, "oss_mount_config", oss_mount_config)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if session_affinity_config is not None:
            pulumi.set(__self__, "session_affinity_config", session_affinity_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_reason is not None:
            pulumi.set(__self__, "state_reason", state_reason)
        if state_reason_code is not None:
            pulumi.set(__self__, "state_reason_code", state_reason_code)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tracing_config is not None:
            pulumi.set(__self__, "tracing_config", tracing_config)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input['V3FunctionCodeArgs']]:
        """
        Function code ZIP package. code and customContainerConfig. See `code` below.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input['V3FunctionCodeArgs']]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter(name="codeSize")
    def code_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The code package size of the function returned by the system, in byte Example : 1024
        """
        return pulumi.get(self, "code_size")

    @code_size.setter
    def code_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "code_size", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The CPU specification of the function. The unit is vCPU, which is a multiple of the 0.05 vCPU.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the function.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customContainerConfig")
    def custom_container_config(self) -> Optional[pulumi.Input['V3FunctionCustomContainerConfigArgs']]:
        """
        The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
        """
        return pulumi.get(self, "custom_container_config")

    @custom_container_config.setter
    def custom_container_config(self, value: Optional[pulumi.Input['V3FunctionCustomContainerConfigArgs']]):
        pulumi.set(self, "custom_container_config", value)

    @_builtins.property
    @pulumi.getter(name="customDns")
    def custom_dns(self) -> Optional[pulumi.Input['V3FunctionCustomDnsArgs']]:
        """
        Function custom DNS configuration See `custom_dns` below.
        """
        return pulumi.get(self, "custom_dns")

    @custom_dns.setter
    def custom_dns(self, value: Optional[pulumi.Input['V3FunctionCustomDnsArgs']]):
        pulumi.set(self, "custom_dns", value)

    @_builtins.property
    @pulumi.getter(name="customRuntimeConfig")
    def custom_runtime_config(self) -> Optional[pulumi.Input['V3FunctionCustomRuntimeConfigArgs']]:
        """
        Customize the runtime configuration. See `custom_runtime_config` below.
        """
        return pulumi.get(self, "custom_runtime_config")

    @custom_runtime_config.setter
    def custom_runtime_config(self, value: Optional[pulumi.Input['V3FunctionCustomRuntimeConfigArgs']]):
        pulumi.set(self, "custom_runtime_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the function. The function compute system does not use this attribute value, but we recommend that you set a concise and clear description for the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The disk specification of the function, in MB. The optional value is 512 MB or 10240MB.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The environment variable set for the function, you can get the value of the environment variable in the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of function
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_arn", value)

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "function_id")

    @function_id.setter
    def function_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_id", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The function name. Consists of uppercase and lowercase letters, digits (0 to 9), underscores (_), and dashes (-). It must begin with an English letter (a ~ z), (A ~ Z), or an underscore (_). Case sensitive. The length is 1~128 characters.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="gpuConfig")
    def gpu_config(self) -> Optional[pulumi.Input['V3FunctionGpuConfigArgs']]:
        """
        Function GPU configuration. See `gpu_config` below.
        """
        return pulumi.get(self, "gpu_config")

    @gpu_config.setter
    def gpu_config(self, value: Optional[pulumi.Input['V3FunctionGpuConfigArgs']]):
        pulumi.set(self, "gpu_config", value)

    @_builtins.property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Function Handler: the call entry for the function compute system to run your function.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "handler", value)

    @_builtins.property
    @pulumi.getter(name="instanceConcurrency")
    def instance_concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum instance concurrency.
        """
        return pulumi.get(self, "instance_concurrency")

    @instance_concurrency.setter
    def instance_concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_concurrency", value)

    @_builtins.property
    @pulumi.getter(name="instanceIsolationMode")
    def instance_isolation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance isolation mode
        """
        return pulumi.get(self, "instance_isolation_mode")

    @instance_isolation_mode.setter
    def instance_isolation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_isolation_mode", value)

    @_builtins.property
    @pulumi.getter(name="instanceLifecycleConfig")
    def instance_lifecycle_config(self) -> Optional[pulumi.Input['V3FunctionInstanceLifecycleConfigArgs']]:
        """
        Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
        """
        return pulumi.get(self, "instance_lifecycle_config")

    @instance_lifecycle_config.setter
    def instance_lifecycle_config(self, value: Optional[pulumi.Input['V3FunctionInstanceLifecycleConfigArgs']]):
        pulumi.set(self, "instance_lifecycle_config", value)

    @_builtins.property
    @pulumi.getter(name="internetAccess")
    def internet_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow function to access public network
        """
        return pulumi.get(self, "internet_access")

    @internet_access.setter
    def internet_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_access", value)

    @_builtins.property
    @pulumi.getter(name="invocationRestriction")
    def invocation_restriction(self) -> Optional[pulumi.Input['V3FunctionInvocationRestrictionArgs']]:
        """
        Invocation Restriction Detail See `invocation_restriction` below.
        """
        return pulumi.get(self, "invocation_restriction")

    @invocation_restriction.setter
    def invocation_restriction(self, value: Optional[pulumi.Input['V3FunctionInvocationRestrictionArgs']]):
        pulumi.set(self, "invocation_restriction", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last time the function was Updated
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdateStatus")
    def last_update_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the last function update operation. When the function is created successfully, the value is Successful. Optional values are Successful, Failed, and InProgress.
        """
        return pulumi.get(self, "last_update_status")

    @last_update_status.setter
    def last_update_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_update_status", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdateStatusReason")
    def last_update_status_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason that caused the last function to update the Operation State to the current value
        """
        return pulumi.get(self, "last_update_status_reason")

    @last_update_status_reason.setter
    def last_update_status_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_update_status_reason", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdateStatusReasonCode")
    def last_update_status_reason_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status code of the reason that caused the last function update operation status to the current value
        """
        return pulumi.get(self, "last_update_status_reason_code")

    @last_update_status_reason_code.setter
    def last_update_status_reason_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_update_status_reason_code", value)

    @_builtins.property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of layers.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "layers", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['V3FunctionLogConfigArgs']]:
        """
        The logs generated by the function are written to the configured Logstore. See `log_config` below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['V3FunctionLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The memory specification of the function. The unit is MB. The memory size is a multiple of 64MB. The minimum value is 128MB and the maximum value is 32GB. At the same time, the ratio of cpu to memorySize (calculated by GB) should be between 1:1 and 1:4.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size", value)

    @_builtins.property
    @pulumi.getter(name="nasConfig")
    def nas_config(self) -> Optional[pulumi.Input['V3FunctionNasConfigArgs']]:
        """
        NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
        """
        return pulumi.get(self, "nas_config")

    @nas_config.setter
    def nas_config(self, value: Optional[pulumi.Input['V3FunctionNasConfigArgs']]):
        pulumi.set(self, "nas_config", value)

    @_builtins.property
    @pulumi.getter(name="ossMountConfig")
    def oss_mount_config(self) -> Optional[pulumi.Input['V3FunctionOssMountConfigArgs']]:
        """
        OSS mount configuration See `oss_mount_config` below.
        """
        return pulumi.get(self, "oss_mount_config")

    @oss_mount_config.setter
    def oss_mount_config(self, value: Optional[pulumi.Input['V3FunctionOssMountConfigArgs']]):
        pulumi.set(self, "oss_mount_config", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user is authorized to the RAM role of function compute. After the configuration, function compute will assume this role to generate temporary access credentials. In the function, you can use the temporary access credentials of the role to access the specified Alibaba cloud service, such as OSS and OTS
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Function runtime type.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The affinity policy of the function compute call request. To implement the request affinity of the MCP SSE protocol, set it to MCP_SSE. If Cookie affinity is used, it can be set to GENERATED_COOKIE. If Header affinity is used, it can be set to HEADER_FIELD. If it is not set or set to NONE, the affinity effect is not set, and the request is routed according to the default scheduling policy of the function calculation system.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_affinity", value)

    @_builtins.property
    @pulumi.getter(name="sessionAffinityConfig")
    def session_affinity_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When you set the sessionAffinity affinity type, you need to set the relevant affinity configuration. For example, the MCP_SSE affinity needs to fill in the mcpssessionaffinityconfig configuration. The Cookie affinity needs to be filled with the CookieSessionAffinityConfig configuration, and the Header Field affinity needs to be filled with the HeaderFieldSessionAffinityConfig configuration.
        """
        return pulumi.get(self, "session_affinity_config")

    @session_affinity_config.setter
    def session_affinity_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "session_affinity_config", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Function Status
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason why the function is in the current state
        """
        return pulumi.get(self, "state_reason")

    @state_reason.setter
    def state_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_reason", value)

    @_builtins.property
    @pulumi.getter(name="stateReasonCode")
    def state_reason_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status code of the reason the function is in the current state.
        """
        return pulumi.get(self, "state_reason_code")

    @state_reason_code.setter
    def state_reason_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_reason_code", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum running time of the function, in seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> Optional[pulumi.Input['V3FunctionTracingConfigArgs']]:
        """
        Tracing configuration
        """
        return pulumi.get(self, "tracing_config")

    @tracing_config.setter
    def tracing_config(self, value: Optional[pulumi.Input['V3FunctionTracingConfigArgs']]):
        pulumi.set(self, "tracing_config", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['V3FunctionVpcConfigArgs']]:
        """
        VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['V3FunctionVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.type_token("alicloud:fc/v3Function:V3Function")
class V3Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code: Optional[pulumi.Input[Union['V3FunctionCodeArgs', 'V3FunctionCodeArgsDict']]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 custom_container_config: Optional[pulumi.Input[Union['V3FunctionCustomContainerConfigArgs', 'V3FunctionCustomContainerConfigArgsDict']]] = None,
                 custom_dns: Optional[pulumi.Input[Union['V3FunctionCustomDnsArgs', 'V3FunctionCustomDnsArgsDict']]] = None,
                 custom_runtime_config: Optional[pulumi.Input[Union['V3FunctionCustomRuntimeConfigArgs', 'V3FunctionCustomRuntimeConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_config: Optional[pulumi.Input[Union['V3FunctionGpuConfigArgs', 'V3FunctionGpuConfigArgsDict']]] = None,
                 handler: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_lifecycle_config: Optional[pulumi.Input[Union['V3FunctionInstanceLifecycleConfigArgs', 'V3FunctionInstanceLifecycleConfigArgsDict']]] = None,
                 internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 invocation_restriction: Optional[pulumi.Input[Union['V3FunctionInvocationRestrictionArgs', 'V3FunctionInvocationRestrictionArgsDict']]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input[Union['V3FunctionLogConfigArgs', 'V3FunctionLogConfigArgsDict']]] = None,
                 memory_size: Optional[pulumi.Input[_builtins.int]] = None,
                 nas_config: Optional[pulumi.Input[Union['V3FunctionNasConfigArgs', 'V3FunctionNasConfigArgsDict']]] = None,
                 oss_mount_config: Optional[pulumi.Input[Union['V3FunctionOssMountConfigArgs', 'V3FunctionOssMountConfigArgsDict']]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity_config: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_config: Optional[pulumi.Input[Union['V3FunctionVpcConfigArgs', 'V3FunctionVpcConfigArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Function Compute Service V3 (FCV3) Function resource.

        The resource scheduling and running of Function Compute is based on functions. The FC function consists of function code and function configuration.

        For information about Function Compute Service V3 (FCV3) Function and how to use it, see [What is Function](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-getfunction).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Uuid("default")
        default_bucket = alicloud.oss.Bucket("default", bucket=f"{name}-{default['result']}")
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.bucket,
            key="FCV3Py39.zip",
            content="print('hello')")
        default_v3_function = alicloud.fc.V3Function("default",
            description="Create",
            memory_size=512,
            layers=["acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3"],
            timeout=3,
            runtime="custom.debian10",
            handler="index.handler",
            disk_size=512,
            custom_runtime_config={
                "commands": [
                    "python",
                    "-c",
                    "example",
                ],
                "args": [
                    "app.py",
                    "xx",
                    "x",
                ],
                "port": 9000,
                "health_check_config": {
                    "http_get_url": "/ready",
                    "initial_delay_seconds": 1,
                    "period_seconds": 10,
                    "success_threshold": 1,
                    "timeout_seconds": 1,
                    "failure_threshold": 3,
                },
            },
            log_config={
                "log_begin_rule": "None",
            },
            code={
                "oss_bucket_name": default_bucket.bucket,
                "oss_object_name": default_bucket_object.key,
                "checksum": "4270285996107335518",
            },
            instance_lifecycle_config={
                "initializer": {
                    "timeout": 1,
                    "handler": "index.init",
                },
                "pre_stop": {
                    "timeout": 1,
                    "handler": "index.stop",
                },
            },
            cpu=0.5,
            instance_concurrency=2,
            function_name=f"{name}-{default['result']}",
            environment_variables={
                "EnvKey": "EnvVal",
            },
            internet_access=True)
        ```

        ## Import

        Function Compute Service V3 (FCV3) Function can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3Function:V3Function example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['V3FunctionCodeArgs', 'V3FunctionCodeArgsDict']] code: Function code ZIP package. code and customContainerConfig. See `code` below.
        :param pulumi.Input[_builtins.float] cpu: The CPU specification of the function. The unit is vCPU, which is a multiple of the 0.05 vCPU.
        :param pulumi.Input[Union['V3FunctionCustomContainerConfigArgs', 'V3FunctionCustomContainerConfigArgsDict']] custom_container_config: The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
        :param pulumi.Input[Union['V3FunctionCustomDnsArgs', 'V3FunctionCustomDnsArgsDict']] custom_dns: Function custom DNS configuration See `custom_dns` below.
        :param pulumi.Input[Union['V3FunctionCustomRuntimeConfigArgs', 'V3FunctionCustomRuntimeConfigArgsDict']] custom_runtime_config: Customize the runtime configuration. See `custom_runtime_config` below.
        :param pulumi.Input[_builtins.str] description: The description of the function. The function compute system does not use this attribute value, but we recommend that you set a concise and clear description for the function.
        :param pulumi.Input[_builtins.int] disk_size: The disk specification of the function, in MB. The optional value is 512 MB or 10240MB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: The environment variable set for the function, you can get the value of the environment variable in the function.
        :param pulumi.Input[_builtins.str] function_name: The function name. Consists of uppercase and lowercase letters, digits (0 to 9), underscores (_), and dashes (-). It must begin with an English letter (a ~ z), (A ~ Z), or an underscore (_). Case sensitive. The length is 1~128 characters.
        :param pulumi.Input[Union['V3FunctionGpuConfigArgs', 'V3FunctionGpuConfigArgsDict']] gpu_config: Function GPU configuration. See `gpu_config` below.
        :param pulumi.Input[_builtins.str] handler: Function Handler: the call entry for the function compute system to run your function.
        :param pulumi.Input[_builtins.int] instance_concurrency: Maximum instance concurrency.
        :param pulumi.Input[_builtins.str] instance_isolation_mode: Instance isolation mode
        :param pulumi.Input[Union['V3FunctionInstanceLifecycleConfigArgs', 'V3FunctionInstanceLifecycleConfigArgsDict']] instance_lifecycle_config: Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
        :param pulumi.Input[_builtins.bool] internet_access: Allow function to access public network
        :param pulumi.Input[Union['V3FunctionInvocationRestrictionArgs', 'V3FunctionInvocationRestrictionArgsDict']] invocation_restriction: Invocation Restriction Detail See `invocation_restriction` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] layers: The list of layers.
        :param pulumi.Input[Union['V3FunctionLogConfigArgs', 'V3FunctionLogConfigArgsDict']] log_config: The logs generated by the function are written to the configured Logstore. See `log_config` below.
        :param pulumi.Input[_builtins.int] memory_size: The memory specification of the function. The unit is MB. The memory size is a multiple of 64MB. The minimum value is 128MB and the maximum value is 32GB. At the same time, the ratio of cpu to memorySize (calculated by GB) should be between 1:1 and 1:4.
        :param pulumi.Input[Union['V3FunctionNasConfigArgs', 'V3FunctionNasConfigArgsDict']] nas_config: NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
        :param pulumi.Input[Union['V3FunctionOssMountConfigArgs', 'V3FunctionOssMountConfigArgsDict']] oss_mount_config: OSS mount configuration See `oss_mount_config` below.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID.
        :param pulumi.Input[_builtins.str] role: The user is authorized to the RAM role of function compute. After the configuration, function compute will assume this role to generate temporary access credentials. In the function, you can use the temporary access credentials of the role to access the specified Alibaba cloud service, such as OSS and OTS
        :param pulumi.Input[_builtins.str] runtime: Function runtime type.
        :param pulumi.Input[_builtins.str] session_affinity: The affinity policy of the function compute call request. To implement the request affinity of the MCP SSE protocol, set it to MCP_SSE. If Cookie affinity is used, it can be set to GENERATED_COOKIE. If Header affinity is used, it can be set to HEADER_FIELD. If it is not set or set to NONE, the affinity effect is not set, and the request is routed according to the default scheduling policy of the function calculation system.
        :param pulumi.Input[_builtins.str] session_affinity_config: When you set the sessionAffinity affinity type, you need to set the relevant affinity configuration. For example, the MCP_SSE affinity needs to fill in the mcpssessionaffinityconfig configuration. The Cookie affinity needs to be filled with the CookieSessionAffinityConfig configuration, and the Header Field affinity needs to be filled with the HeaderFieldSessionAffinityConfig configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.int] timeout: The maximum running time of the function, in seconds.
        :param pulumi.Input[Union['V3FunctionVpcConfigArgs', 'V3FunctionVpcConfigArgsDict']] vpc_config: VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V3FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Function Compute Service V3 (FCV3) Function resource.

        The resource scheduling and running of Function Compute is based on functions. The FC function consists of function code and function configuration.

        For information about Function Compute Service V3 (FCV3) Function and how to use it, see [What is Function](https://www.alibabacloud.com/help/en/functioncompute/developer-reference/api-fc-2023-03-30-getfunction).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Uuid("default")
        default_bucket = alicloud.oss.Bucket("default", bucket=f"{name}-{default['result']}")
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.bucket,
            key="FCV3Py39.zip",
            content="print('hello')")
        default_v3_function = alicloud.fc.V3Function("default",
            description="Create",
            memory_size=512,
            layers=["acs:fc:cn-shanghai:official:layers/Python39-Aliyun-SDK/versions/3"],
            timeout=3,
            runtime="custom.debian10",
            handler="index.handler",
            disk_size=512,
            custom_runtime_config={
                "commands": [
                    "python",
                    "-c",
                    "example",
                ],
                "args": [
                    "app.py",
                    "xx",
                    "x",
                ],
                "port": 9000,
                "health_check_config": {
                    "http_get_url": "/ready",
                    "initial_delay_seconds": 1,
                    "period_seconds": 10,
                    "success_threshold": 1,
                    "timeout_seconds": 1,
                    "failure_threshold": 3,
                },
            },
            log_config={
                "log_begin_rule": "None",
            },
            code={
                "oss_bucket_name": default_bucket.bucket,
                "oss_object_name": default_bucket_object.key,
                "checksum": "4270285996107335518",
            },
            instance_lifecycle_config={
                "initializer": {
                    "timeout": 1,
                    "handler": "index.init",
                },
                "pre_stop": {
                    "timeout": 1,
                    "handler": "index.stop",
                },
            },
            cpu=0.5,
            instance_concurrency=2,
            function_name=f"{name}-{default['result']}",
            environment_variables={
                "EnvKey": "EnvVal",
            },
            internet_access=True)
        ```

        ## Import

        Function Compute Service V3 (FCV3) Function can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3Function:V3Function example <id>
        ```

        :param str resource_name: The name of the resource.
        :param V3FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V3FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code: Optional[pulumi.Input[Union['V3FunctionCodeArgs', 'V3FunctionCodeArgsDict']]] = None,
                 cpu: Optional[pulumi.Input[_builtins.float]] = None,
                 custom_container_config: Optional[pulumi.Input[Union['V3FunctionCustomContainerConfigArgs', 'V3FunctionCustomContainerConfigArgsDict']]] = None,
                 custom_dns: Optional[pulumi.Input[Union['V3FunctionCustomDnsArgs', 'V3FunctionCustomDnsArgsDict']]] = None,
                 custom_runtime_config: Optional[pulumi.Input[Union['V3FunctionCustomRuntimeConfigArgs', 'V3FunctionCustomRuntimeConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gpu_config: Optional[pulumi.Input[Union['V3FunctionGpuConfigArgs', 'V3FunctionGpuConfigArgsDict']]] = None,
                 handler: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_lifecycle_config: Optional[pulumi.Input[Union['V3FunctionInstanceLifecycleConfigArgs', 'V3FunctionInstanceLifecycleConfigArgsDict']]] = None,
                 internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 invocation_restriction: Optional[pulumi.Input[Union['V3FunctionInvocationRestrictionArgs', 'V3FunctionInvocationRestrictionArgsDict']]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input[Union['V3FunctionLogConfigArgs', 'V3FunctionLogConfigArgsDict']]] = None,
                 memory_size: Optional[pulumi.Input[_builtins.int]] = None,
                 nas_config: Optional[pulumi.Input[Union['V3FunctionNasConfigArgs', 'V3FunctionNasConfigArgsDict']]] = None,
                 oss_mount_config: Optional[pulumi.Input[Union['V3FunctionOssMountConfigArgs', 'V3FunctionOssMountConfigArgsDict']]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
                 session_affinity_config: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_config: Optional[pulumi.Input[Union['V3FunctionVpcConfigArgs', 'V3FunctionVpcConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V3FunctionArgs.__new__(V3FunctionArgs)

            __props__.__dict__["code"] = code
            __props__.__dict__["cpu"] = cpu
            __props__.__dict__["custom_container_config"] = custom_container_config
            __props__.__dict__["custom_dns"] = custom_dns
            __props__.__dict__["custom_runtime_config"] = custom_runtime_config
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_size"] = disk_size
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["gpu_config"] = gpu_config
            if handler is None and not opts.urn:
                raise TypeError("Missing required property 'handler'")
            __props__.__dict__["handler"] = handler
            __props__.__dict__["instance_concurrency"] = instance_concurrency
            __props__.__dict__["instance_isolation_mode"] = instance_isolation_mode
            __props__.__dict__["instance_lifecycle_config"] = instance_lifecycle_config
            __props__.__dict__["internet_access"] = internet_access
            __props__.__dict__["invocation_restriction"] = invocation_restriction
            __props__.__dict__["layers"] = layers
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["memory_size"] = memory_size
            __props__.__dict__["nas_config"] = nas_config
            __props__.__dict__["oss_mount_config"] = oss_mount_config
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["role"] = role
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["session_affinity"] = session_affinity
            __props__.__dict__["session_affinity_config"] = session_affinity_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["code_size"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["function_arn"] = None
            __props__.__dict__["function_id"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["last_update_status"] = None
            __props__.__dict__["last_update_status_reason"] = None
            __props__.__dict__["last_update_status_reason_code"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_reason"] = None
            __props__.__dict__["state_reason_code"] = None
            __props__.__dict__["tracing_config"] = None
        super(V3Function, __self__).__init__(
            'alicloud:fc/v3Function:V3Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            code: Optional[pulumi.Input[Union['V3FunctionCodeArgs', 'V3FunctionCodeArgsDict']]] = None,
            code_size: Optional[pulumi.Input[_builtins.int]] = None,
            cpu: Optional[pulumi.Input[_builtins.float]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            custom_container_config: Optional[pulumi.Input[Union['V3FunctionCustomContainerConfigArgs', 'V3FunctionCustomContainerConfigArgsDict']]] = None,
            custom_dns: Optional[pulumi.Input[Union['V3FunctionCustomDnsArgs', 'V3FunctionCustomDnsArgsDict']]] = None,
            custom_runtime_config: Optional[pulumi.Input[Union['V3FunctionCustomRuntimeConfigArgs', 'V3FunctionCustomRuntimeConfigArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            function_arn: Optional[pulumi.Input[_builtins.str]] = None,
            function_id: Optional[pulumi.Input[_builtins.str]] = None,
            function_name: Optional[pulumi.Input[_builtins.str]] = None,
            gpu_config: Optional[pulumi.Input[Union['V3FunctionGpuConfigArgs', 'V3FunctionGpuConfigArgsDict']]] = None,
            handler: Optional[pulumi.Input[_builtins.str]] = None,
            instance_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
            instance_isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
            instance_lifecycle_config: Optional[pulumi.Input[Union['V3FunctionInstanceLifecycleConfigArgs', 'V3FunctionInstanceLifecycleConfigArgsDict']]] = None,
            internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
            invocation_restriction: Optional[pulumi.Input[Union['V3FunctionInvocationRestrictionArgs', 'V3FunctionInvocationRestrictionArgsDict']]] = None,
            last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
            last_update_status: Optional[pulumi.Input[_builtins.str]] = None,
            last_update_status_reason: Optional[pulumi.Input[_builtins.str]] = None,
            last_update_status_reason_code: Optional[pulumi.Input[_builtins.str]] = None,
            layers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            log_config: Optional[pulumi.Input[Union['V3FunctionLogConfigArgs', 'V3FunctionLogConfigArgsDict']]] = None,
            memory_size: Optional[pulumi.Input[_builtins.int]] = None,
            nas_config: Optional[pulumi.Input[Union['V3FunctionNasConfigArgs', 'V3FunctionNasConfigArgsDict']]] = None,
            oss_mount_config: Optional[pulumi.Input[Union['V3FunctionOssMountConfigArgs', 'V3FunctionOssMountConfigArgsDict']]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            runtime: Optional[pulumi.Input[_builtins.str]] = None,
            session_affinity: Optional[pulumi.Input[_builtins.str]] = None,
            session_affinity_config: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            state_reason: Optional[pulumi.Input[_builtins.str]] = None,
            state_reason_code: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            tracing_config: Optional[pulumi.Input[Union['V3FunctionTracingConfigArgs', 'V3FunctionTracingConfigArgsDict']]] = None,
            vpc_config: Optional[pulumi.Input[Union['V3FunctionVpcConfigArgs', 'V3FunctionVpcConfigArgsDict']]] = None) -> 'V3Function':
        """
        Get an existing V3Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['V3FunctionCodeArgs', 'V3FunctionCodeArgsDict']] code: Function code ZIP package. code and customContainerConfig. See `code` below.
        :param pulumi.Input[_builtins.int] code_size: The code package size of the function returned by the system, in byte Example : 1024
        :param pulumi.Input[_builtins.float] cpu: The CPU specification of the function. The unit is vCPU, which is a multiple of the 0.05 vCPU.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the function.
        :param pulumi.Input[Union['V3FunctionCustomContainerConfigArgs', 'V3FunctionCustomContainerConfigArgsDict']] custom_container_config: The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
        :param pulumi.Input[Union['V3FunctionCustomDnsArgs', 'V3FunctionCustomDnsArgsDict']] custom_dns: Function custom DNS configuration See `custom_dns` below.
        :param pulumi.Input[Union['V3FunctionCustomRuntimeConfigArgs', 'V3FunctionCustomRuntimeConfigArgsDict']] custom_runtime_config: Customize the runtime configuration. See `custom_runtime_config` below.
        :param pulumi.Input[_builtins.str] description: The description of the function. The function compute system does not use this attribute value, but we recommend that you set a concise and clear description for the function.
        :param pulumi.Input[_builtins.int] disk_size: The disk specification of the function, in MB. The optional value is 512 MB or 10240MB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: The environment variable set for the function, you can get the value of the environment variable in the function.
        :param pulumi.Input[_builtins.str] function_arn: ARN of function
        :param pulumi.Input[_builtins.str] function_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] function_name: The function name. Consists of uppercase and lowercase letters, digits (0 to 9), underscores (_), and dashes (-). It must begin with an English letter (a ~ z), (A ~ Z), or an underscore (_). Case sensitive. The length is 1~128 characters.
        :param pulumi.Input[Union['V3FunctionGpuConfigArgs', 'V3FunctionGpuConfigArgsDict']] gpu_config: Function GPU configuration. See `gpu_config` below.
        :param pulumi.Input[_builtins.str] handler: Function Handler: the call entry for the function compute system to run your function.
        :param pulumi.Input[_builtins.int] instance_concurrency: Maximum instance concurrency.
        :param pulumi.Input[_builtins.str] instance_isolation_mode: Instance isolation mode
        :param pulumi.Input[Union['V3FunctionInstanceLifecycleConfigArgs', 'V3FunctionInstanceLifecycleConfigArgsDict']] instance_lifecycle_config: Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
        :param pulumi.Input[_builtins.bool] internet_access: Allow function to access public network
        :param pulumi.Input[Union['V3FunctionInvocationRestrictionArgs', 'V3FunctionInvocationRestrictionArgsDict']] invocation_restriction: Invocation Restriction Detail See `invocation_restriction` below.
        :param pulumi.Input[_builtins.str] last_modified_time: Last time the function was Updated
        :param pulumi.Input[_builtins.str] last_update_status: The status of the last function update operation. When the function is created successfully, the value is Successful. Optional values are Successful, Failed, and InProgress.
        :param pulumi.Input[_builtins.str] last_update_status_reason: The reason that caused the last function to update the Operation State to the current value
        :param pulumi.Input[_builtins.str] last_update_status_reason_code: Status code of the reason that caused the last function update operation status to the current value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] layers: The list of layers.
        :param pulumi.Input[Union['V3FunctionLogConfigArgs', 'V3FunctionLogConfigArgsDict']] log_config: The logs generated by the function are written to the configured Logstore. See `log_config` below.
        :param pulumi.Input[_builtins.int] memory_size: The memory specification of the function. The unit is MB. The memory size is a multiple of 64MB. The minimum value is 128MB and the maximum value is 32GB. At the same time, the ratio of cpu to memorySize (calculated by GB) should be between 1:1 and 1:4.
        :param pulumi.Input[Union['V3FunctionNasConfigArgs', 'V3FunctionNasConfigArgsDict']] nas_config: NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
        :param pulumi.Input[Union['V3FunctionOssMountConfigArgs', 'V3FunctionOssMountConfigArgsDict']] oss_mount_config: OSS mount configuration See `oss_mount_config` below.
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID.
        :param pulumi.Input[_builtins.str] role: The user is authorized to the RAM role of function compute. After the configuration, function compute will assume this role to generate temporary access credentials. In the function, you can use the temporary access credentials of the role to access the specified Alibaba cloud service, such as OSS and OTS
        :param pulumi.Input[_builtins.str] runtime: Function runtime type.
        :param pulumi.Input[_builtins.str] session_affinity: The affinity policy of the function compute call request. To implement the request affinity of the MCP SSE protocol, set it to MCP_SSE. If Cookie affinity is used, it can be set to GENERATED_COOKIE. If Header affinity is used, it can be set to HEADER_FIELD. If it is not set or set to NONE, the affinity effect is not set, and the request is routed according to the default scheduling policy of the function calculation system.
        :param pulumi.Input[_builtins.str] session_affinity_config: When you set the sessionAffinity affinity type, you need to set the relevant affinity configuration. For example, the MCP_SSE affinity needs to fill in the mcpssessionaffinityconfig configuration. The Cookie affinity needs to be filled with the CookieSessionAffinityConfig configuration, and the Header Field affinity needs to be filled with the HeaderFieldSessionAffinityConfig configuration.
        :param pulumi.Input[_builtins.str] state: Function Status
        :param pulumi.Input[_builtins.str] state_reason: The reason why the function is in the current state
        :param pulumi.Input[_builtins.str] state_reason_code: The status code of the reason the function is in the current state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.int] timeout: The maximum running time of the function, in seconds.
        :param pulumi.Input[Union['V3FunctionTracingConfigArgs', 'V3FunctionTracingConfigArgsDict']] tracing_config: Tracing configuration
        :param pulumi.Input[Union['V3FunctionVpcConfigArgs', 'V3FunctionVpcConfigArgsDict']] vpc_config: VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V3FunctionState.__new__(_V3FunctionState)

        __props__.__dict__["code"] = code
        __props__.__dict__["code_size"] = code_size
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_container_config"] = custom_container_config
        __props__.__dict__["custom_dns"] = custom_dns
        __props__.__dict__["custom_runtime_config"] = custom_runtime_config
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_size"] = disk_size
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["function_arn"] = function_arn
        __props__.__dict__["function_id"] = function_id
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["gpu_config"] = gpu_config
        __props__.__dict__["handler"] = handler
        __props__.__dict__["instance_concurrency"] = instance_concurrency
        __props__.__dict__["instance_isolation_mode"] = instance_isolation_mode
        __props__.__dict__["instance_lifecycle_config"] = instance_lifecycle_config
        __props__.__dict__["internet_access"] = internet_access
        __props__.__dict__["invocation_restriction"] = invocation_restriction
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["last_update_status"] = last_update_status
        __props__.__dict__["last_update_status_reason"] = last_update_status_reason
        __props__.__dict__["last_update_status_reason_code"] = last_update_status_reason_code
        __props__.__dict__["layers"] = layers
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["memory_size"] = memory_size
        __props__.__dict__["nas_config"] = nas_config
        __props__.__dict__["oss_mount_config"] = oss_mount_config
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["role"] = role
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["session_affinity"] = session_affinity
        __props__.__dict__["session_affinity_config"] = session_affinity_config
        __props__.__dict__["state"] = state
        __props__.__dict__["state_reason"] = state_reason
        __props__.__dict__["state_reason_code"] = state_reason_code
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["tracing_config"] = tracing_config
        __props__.__dict__["vpc_config"] = vpc_config
        return V3Function(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def code(self) -> pulumi.Output[Optional['outputs.V3FunctionCode']]:
        """
        Function code ZIP package. code and customContainerConfig. See `code` below.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="codeSize")
    def code_size(self) -> pulumi.Output[_builtins.int]:
        """
        The code package size of the function returned by the system, in byte Example : 1024
        """
        return pulumi.get(self, "code_size")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[_builtins.float]:
        """
        The CPU specification of the function. The unit is vCPU, which is a multiple of the 0.05 vCPU.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the function.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customContainerConfig")
    def custom_container_config(self) -> pulumi.Output[Optional['outputs.V3FunctionCustomContainerConfig']]:
        """
        The configuration of the custom container runtime. After the configuration is successful, the function can use the custom container image to execute the function. code and customContainerConfig. See `custom_container_config` below.
        """
        return pulumi.get(self, "custom_container_config")

    @_builtins.property
    @pulumi.getter(name="customDns")
    def custom_dns(self) -> pulumi.Output[Optional['outputs.V3FunctionCustomDns']]:
        """
        Function custom DNS configuration See `custom_dns` below.
        """
        return pulumi.get(self, "custom_dns")

    @_builtins.property
    @pulumi.getter(name="customRuntimeConfig")
    def custom_runtime_config(self) -> pulumi.Output[Optional['outputs.V3FunctionCustomRuntimeConfig']]:
        """
        Customize the runtime configuration. See `custom_runtime_config` below.
        """
        return pulumi.get(self, "custom_runtime_config")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the function. The function compute system does not use this attribute value, but we recommend that you set a concise and clear description for the function.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[_builtins.int]:
        """
        The disk specification of the function, in MB. The optional value is 512 MB or 10240MB.
        """
        return pulumi.get(self, "disk_size")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The environment variable set for the function, you can get the value of the environment variable in the function.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of function
        """
        return pulumi.get(self, "function_arn")

    @_builtins.property
    @pulumi.getter(name="functionId")
    def function_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "function_id")

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[_builtins.str]:
        """
        The function name. Consists of uppercase and lowercase letters, digits (0 to 9), underscores (_), and dashes (-). It must begin with an English letter (a ~ z), (A ~ Z), or an underscore (_). Case sensitive. The length is 1~128 characters.
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter(name="gpuConfig")
    def gpu_config(self) -> pulumi.Output[Optional['outputs.V3FunctionGpuConfig']]:
        """
        Function GPU configuration. See `gpu_config` below.
        """
        return pulumi.get(self, "gpu_config")

    @_builtins.property
    @pulumi.getter
    def handler(self) -> pulumi.Output[_builtins.str]:
        """
        Function Handler: the call entry for the function compute system to run your function.
        """
        return pulumi.get(self, "handler")

    @_builtins.property
    @pulumi.getter(name="instanceConcurrency")
    def instance_concurrency(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum instance concurrency.
        """
        return pulumi.get(self, "instance_concurrency")

    @_builtins.property
    @pulumi.getter(name="instanceIsolationMode")
    def instance_isolation_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance isolation mode
        """
        return pulumi.get(self, "instance_isolation_mode")

    @_builtins.property
    @pulumi.getter(name="instanceLifecycleConfig")
    def instance_lifecycle_config(self) -> pulumi.Output[Optional['outputs.V3FunctionInstanceLifecycleConfig']]:
        """
        Instance lifecycle callback method configuration. See `instance_lifecycle_config` below.
        """
        return pulumi.get(self, "instance_lifecycle_config")

    @_builtins.property
    @pulumi.getter(name="internetAccess")
    def internet_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Allow function to access public network
        """
        return pulumi.get(self, "internet_access")

    @_builtins.property
    @pulumi.getter(name="invocationRestriction")
    def invocation_restriction(self) -> pulumi.Output[Optional['outputs.V3FunctionInvocationRestriction']]:
        """
        Invocation Restriction Detail See `invocation_restriction` below.
        """
        return pulumi.get(self, "invocation_restriction")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[_builtins.str]:
        """
        Last time the function was Updated
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter(name="lastUpdateStatus")
    def last_update_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the last function update operation. When the function is created successfully, the value is Successful. Optional values are Successful, Failed, and InProgress.
        """
        return pulumi.get(self, "last_update_status")

    @_builtins.property
    @pulumi.getter(name="lastUpdateStatusReason")
    def last_update_status_reason(self) -> pulumi.Output[_builtins.str]:
        """
        The reason that caused the last function to update the Operation State to the current value
        """
        return pulumi.get(self, "last_update_status_reason")

    @_builtins.property
    @pulumi.getter(name="lastUpdateStatusReasonCode")
    def last_update_status_reason_code(self) -> pulumi.Output[_builtins.str]:
        """
        Status code of the reason that caused the last function update operation status to the current value
        """
        return pulumi.get(self, "last_update_status_reason_code")

    @_builtins.property
    @pulumi.getter
    def layers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of layers.
        """
        return pulumi.get(self, "layers")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.V3FunctionLogConfig']]:
        """
        The logs generated by the function are written to the configured Logstore. See `log_config` below.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> pulumi.Output[_builtins.int]:
        """
        The memory specification of the function. The unit is MB. The memory size is a multiple of 64MB. The minimum value is 128MB and the maximum value is 32GB. At the same time, the ratio of cpu to memorySize (calculated by GB) should be between 1:1 and 1:4.
        """
        return pulumi.get(self, "memory_size")

    @_builtins.property
    @pulumi.getter(name="nasConfig")
    def nas_config(self) -> pulumi.Output['outputs.V3FunctionNasConfig']:
        """
        NAS configuration. After this parameter is configured, the function can access the specified NAS resource. See `nas_config` below.
        """
        return pulumi.get(self, "nas_config")

    @_builtins.property
    @pulumi.getter(name="ossMountConfig")
    def oss_mount_config(self) -> pulumi.Output['outputs.V3FunctionOssMountConfig']:
        """
        OSS mount configuration See `oss_mount_config` below.
        """
        return pulumi.get(self, "oss_mount_config")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user is authorized to the RAM role of function compute. After the configuration, function compute will assume this role to generate temporary access credentials. In the function, you can use the temporary access credentials of the role to access the specified Alibaba cloud service, such as OSS and OTS
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[_builtins.str]:
        """
        Function runtime type.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The affinity policy of the function compute call request. To implement the request affinity of the MCP SSE protocol, set it to MCP_SSE. If Cookie affinity is used, it can be set to GENERATED_COOKIE. If Header affinity is used, it can be set to HEADER_FIELD. If it is not set or set to NONE, the affinity effect is not set, and the request is routed according to the default scheduling policy of the function calculation system.
        """
        return pulumi.get(self, "session_affinity")

    @_builtins.property
    @pulumi.getter(name="sessionAffinityConfig")
    def session_affinity_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When you set the sessionAffinity affinity type, you need to set the relevant affinity configuration. For example, the MCP_SSE affinity needs to fill in the mcpssessionaffinityconfig configuration. The Cookie affinity needs to be filled with the CookieSessionAffinityConfig configuration, and the Header Field affinity needs to be filled with the HeaderFieldSessionAffinityConfig configuration.
        """
        return pulumi.get(self, "session_affinity_config")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Function Status
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> pulumi.Output[_builtins.str]:
        """
        The reason why the function is in the current state
        """
        return pulumi.get(self, "state_reason")

    @_builtins.property
    @pulumi.getter(name="stateReasonCode")
    def state_reason_code(self) -> pulumi.Output[_builtins.str]:
        """
        The status code of the reason the function is in the current state.
        """
        return pulumi.get(self, "state_reason_code")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum running time of the function, in seconds.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> pulumi.Output['outputs.V3FunctionTracingConfig']:
        """
        Tracing configuration
        """
        return pulumi.get(self, "tracing_config")

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output['outputs.V3FunctionVpcConfig']:
        """
        VPC configuration. After this parameter is configured, the function can access the specified VPC resources. See `vpc_config` below.
        """
        return pulumi.get(self, "vpc_config")

