# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AdditionalCertificateArgs', 'AdditionalCertificate']

@pulumi.input_type
class AdditionalCertificateArgs:
    def __init__(__self__, *,
                 accelerator_id: pulumi.Input[_builtins.str],
                 certificate_id: pulumi.Input[_builtins.str],
                 domain: pulumi.Input[_builtins.str],
                 listener_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a AdditionalCertificate resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the GA instance.
        :param pulumi.Input[_builtins.str] certificate_id: The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        :param pulumi.Input[_builtins.str] domain: The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "listener_id", listener_id)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "accelerator_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_id", value)


@pulumi.input_type
class _AdditionalCertificateState:
    def __init__(__self__, *,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AdditionalCertificate resources.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the GA instance.
        :param pulumi.Input[_builtins.str] certificate_id: The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        :param pulumi.Input[_builtins.str] domain: The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        if accelerator_id is not None:
            pulumi.set(__self__, "accelerator_id", accelerator_id)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accelerator_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)


@pulumi.type_token("alicloud:ga/additionalCertificate:AdditionalCertificate")
class AdditionalCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Global Accelerator (GA) Additional Certificate resource.

        For information about Global Accelerator (GA) Additional Certificate and how to use it, see [What is Additional Certificate](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-associateadditionalcertificateswithlistener).

        > **NOTE:** Available since v1.150.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.ga.get_accelerators(status="active")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30,
            bandwidth_package_name=name,
            auto_pay=True,
            auto_use_coupon=True)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
            accelerator_id=default.ids[0],
            bandwidth_package_id=default_bandwidth_package.id)
        default_service_certificate = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_service_certificate.append(alicloud.cas.ServiceCertificate(f"default-{range['value']}",
                certificate_name=std.join(separator="-",
                    input=[
                        name,
                        range["value"],
                    ]).result,
                cert=\"\"\"-----BEGIN CERTIFICATE-----
        MIID7zCCAtegAwIBAgIRAKi2/Fx1cUTyhV839x42ockwDQYJKoZIhvcNAQELBQAw
        XjELMAkGA1UEBhMCQ04xDjAMBgNVBAoTBU15U1NMMSswKQYDVQQLEyJNeVNTTCBU
        ZXN0IFJTQSAtIEZvciB0ZXN0IHVzZSBvbmx5MRIwEAYDVQQDEwlNeVNTTC5jb20w
        HhcNMjMwODA5MDQ1NDU3WhcNMjYwODA4MDQ1NDU3WjAsMQswCQYDVQQGEwJDTjEd
        MBsGA1UEAxMUYWxpY2xvdWQtcHJvdmlkZXIuY24wggEiMA0GCSqGSIb3DQEBAQUA
        A4IBDwAwggEKAoIBAQDdkot9e0pMCTPAtA29Sz5sF+aPT/l9+3sOnQeJ1kKLNkqK
        iQgwADexoAqlmTaZM03gh/GnkqPw9gxN/fJHWdVzxE03Fs8bKgMdS6cf0v/xArrQ
        zm6N4vmsbuE8SX2eu303PAsyBMqPByTODZ5i+5LkZcrxMFQsbA3xnBouzS5e+T+a
        7YTyyVv5WDy871/sdRAYTfnUttdnqkKGeMKgQgRlJ2pDk5/k2iwmQmSh/wbk465+
        1U5w2npPYGPvGAkzl7RRc4/VckqlV8P0cmgguqIRyllJwFEnvcpqpOHTxBOBq9iZ
        4b/h7ynrfB/GbAw574eSEl0gzLBW60bT9YedbTeXAgMBAAGjgdkwgdYwDgYDVR0P
        AQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAfBgNVHSME
        GDAWgBQogSYF0TQaP8FzD7uTzxUcPwO/fzBjBggrBgEFBQcBAQRXMFUwIQYIKwYB
        BQUHMAGGFWh0dHA6Ly9vY3NwLm15c3NsLmNvbTAwBggrBgEFBQcwAoYkaHR0cDov
        L2NhLm15c3NsLmNvbS9teXNzbHRlc3Ryc2EuY3J0MB8GA1UdEQQYMBaCFGFsaWNs
        b3VkLXByb3ZpZGVyLmNuMA0GCSqGSIb3DQEBCwUAA4IBAQCwUBeznv6cAjcTLCDb
        SSvgkM9HFcbWnuGS8Nf5P4YfmSs52VuHZyjzwphjAU6B/danI/nMdZe52PXyvjVV
        02Y8ld/tMpqPV5SpaOadLtdg6TGBNJieOAt9doM8WNEgq/JycAL9ivIOjChUetZf
        ZEV7HDIgiHSpqAPWMZYL71MS/p5zYkyOnPqmGyLNdi1neotwVCQopQXRNC2iLlVV
        yQONfXH5iijqr1iTWkB0ESK/xBt1PB655PlTjzFQUOovE1SyoQS8K3u7TP6+BqtD
        G9TYNTNZvxl5I/iU/KdWVip+qJbxRA8Skc8gHkkzeIEStw3l5cjnrp9h7EhnhkOh
        ltGN
        -----END CERTIFICATE-----
        \"\"\",
                key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIIEpQIBAAKCAQEA3ZKLfXtKTAkzwLQNvUs+bBfmj0/5fft7Dp0HidZCizZKiokI
        MAA3saAKpZk2mTNN4Ifxp5Kj8PYMTf3yR1nVc8RNNxbPGyoDHUunH9L/8QK60M5u
        jeL5rG7hPEl9nrt9NzwLMgTKjwckzg2eYvuS5GXK8TBULGwN8ZwaLs0uXvk/mu2E
        8slb+Vg8vO9f7HUQGE351LbXZ6pChnjCoEIEZSdqQ5Of5NosJkJkof8G5OOuftVO
        cNp6T2Bj7xgJM5e0UXOP1XJKpVfD9HJoILqiEcpZScBRJ73KaqTh08QTgavYmeG/
        4e8p63wfxmwMOe+HkhJdIMywVutG0/WHnW03lwIDAQABAoIBAQCe5rHS09B8pzzO
        PlJ8JrIlox5eOOScTPX7jPITD+25GL5si8mrYvyODlCUYkSdqgV3uQa9PpUEAfDh
        HfXa5boGxAj8MQdmW8LQB6lbUV7r4SFJDkKKzvRvjTVKnwnQBHXQXudIf9ckq+Lh
        QzMLmY/G7JmWTyqOkQ+O7nx4g/11bcU7uQrQdvWPfc0+IiT1TYQdyLQ/Chlj3RF/
        iwF8ZL2sfKF+Z5O49+Q6cXvUcQOvqtkIXbQijayyVNBMJwDB7aOZRA7JBNj9/ib6
        N0iTo81dJVz/nnpbWRaFTVinIsDF1heDfQ1qDx06T/Mpi6pjoWjRUcyIHEbZJTel
        0nXDJD1BAoGBAPZB/PN8MP+o9gkf2jnoU9LzctDJrQwD1J2XElq4RomimPIMqDQP
        5TRAJThf0O0X4Mv2n9EzV457OpJL+fz9htRWEYogWl9bkbzZ1AoX4K/acuGeawTT
        YEhPjJ2ZETsBsCeDkDDuHHzYwRQv+EfoXH36z9PBDxG1ZDb7kWwAILXdAoGBAOZW
        jXG7m4I7cxUtXGtjwydh4K7nwH/5QoH2m928HM2AT48eQCl3CMQ089+qeJGgfHQv
        GyVOO/FGhcFsFi10FMQ7IlwWgZODg64qnrNhi4zbV1M2wKem1T2dlEpkd82EFdnS
        GYRIEkFORMxEDyzx3Th2TajpWC8YKKG3Tnm0bQ4DAoGBAIZTEEswHvoVi78GZN7Z
        X3/d028X0xCOtlcPpK9ffPpuesbtKILdeMS7iJHrkecB81jOOfa+7q+FgDl0v/PD
        xtvj5sVVSHZjWGeO2h53T9QccDWpV+7V7dsDqUv9xmxNS20CUpCeEWP4R7lfQSrY
        EDuXp+11jWa3buae6n/iwfTxAoGABEYW2cVhXUk9GWd+D4AKXvCx+ozSRY2abk7l
        FXgoEKgQ0db92ccboohY/g1rr0gLBxzYpBiPhCqK0MvwnWdJ+1odiRfhz5rhFpoz
        16A3tqVbOXAKoxG1Yy9JURgMIQQSY7hCQPIVZKDPJfsdTPgv4pxPVJL/z9/i4R1F
        l3yBiYECgYEA0+vpzL24nHZYdwgBF4qbmYhv8baRi07/BNgV1+d6vESuO/MwwoE/
        2UZ9Drf5yoX2Bvi5/vVMbyc7cSluO7icPBkl0D8F7E3x0v5mzwPxtpR8BTRoJKOL
        /rMdLscMz2VQsL5DJd/9OZg60fHRaRtWtV0afXzL5zUxnfDLot24IG4=
        -----END RSA PRIVATE KEY-----
        \"\"\"))
        default_listener = alicloud.ga.Listener("default",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            name=name,
            protocol="HTTPS",
            port_ranges=[{
                "from_port": 8080,
                "to_port": 8080,
            }],
            certificates=[{
                "id": std.join_output(separator="-",
                    input=[
                        default_service_certificate[1].id,
                        region,
                    ]).apply(lambda invoke: invoke.result),
            }])
        domain = "alicloud-provider.cn"
        default_additional_certificate = alicloud.ga.AdditionalCertificate("default",
            certificate_id=std.join_output(separator="-",
                input=[
                    default_service_certificate[1].id,
                    region,
                ]).apply(lambda invoke: invoke.result),
            domain=domain,
            accelerator_id=default_listener.accelerator_id,
            listener_id=default_listener.id)
        ```

        ## Import

        Global Accelerator (GA) Additional Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/additionalCertificate:AdditionalCertificate example <accelerator_id>:<listener_id>:<domain>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the GA instance.
        :param pulumi.Input[_builtins.str] certificate_id: The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        :param pulumi.Input[_builtins.str] domain: The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdditionalCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Global Accelerator (GA) Additional Certificate resource.

        For information about Global Accelerator (GA) Additional Certificate and how to use it, see [What is Additional Certificate](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-associateadditionalcertificateswithlistener).

        > **NOTE:** Available since v1.150.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.ga.get_accelerators(status="active")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("default",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30,
            bandwidth_package_name=name,
            auto_pay=True,
            auto_use_coupon=True)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("default",
            accelerator_id=default.ids[0],
            bandwidth_package_id=default_bandwidth_package.id)
        default_service_certificate = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_service_certificate.append(alicloud.cas.ServiceCertificate(f"default-{range['value']}",
                certificate_name=std.join(separator="-",
                    input=[
                        name,
                        range["value"],
                    ]).result,
                cert=\"\"\"-----BEGIN CERTIFICATE-----
        MIID7zCCAtegAwIBAgIRAKi2/Fx1cUTyhV839x42ockwDQYJKoZIhvcNAQELBQAw
        XjELMAkGA1UEBhMCQ04xDjAMBgNVBAoTBU15U1NMMSswKQYDVQQLEyJNeVNTTCBU
        ZXN0IFJTQSAtIEZvciB0ZXN0IHVzZSBvbmx5MRIwEAYDVQQDEwlNeVNTTC5jb20w
        HhcNMjMwODA5MDQ1NDU3WhcNMjYwODA4MDQ1NDU3WjAsMQswCQYDVQQGEwJDTjEd
        MBsGA1UEAxMUYWxpY2xvdWQtcHJvdmlkZXIuY24wggEiMA0GCSqGSIb3DQEBAQUA
        A4IBDwAwggEKAoIBAQDdkot9e0pMCTPAtA29Sz5sF+aPT/l9+3sOnQeJ1kKLNkqK
        iQgwADexoAqlmTaZM03gh/GnkqPw9gxN/fJHWdVzxE03Fs8bKgMdS6cf0v/xArrQ
        zm6N4vmsbuE8SX2eu303PAsyBMqPByTODZ5i+5LkZcrxMFQsbA3xnBouzS5e+T+a
        7YTyyVv5WDy871/sdRAYTfnUttdnqkKGeMKgQgRlJ2pDk5/k2iwmQmSh/wbk465+
        1U5w2npPYGPvGAkzl7RRc4/VckqlV8P0cmgguqIRyllJwFEnvcpqpOHTxBOBq9iZ
        4b/h7ynrfB/GbAw574eSEl0gzLBW60bT9YedbTeXAgMBAAGjgdkwgdYwDgYDVR0P
        AQH/BAQDAgWgMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAfBgNVHSME
        GDAWgBQogSYF0TQaP8FzD7uTzxUcPwO/fzBjBggrBgEFBQcBAQRXMFUwIQYIKwYB
        BQUHMAGGFWh0dHA6Ly9vY3NwLm15c3NsLmNvbTAwBggrBgEFBQcwAoYkaHR0cDov
        L2NhLm15c3NsLmNvbS9teXNzbHRlc3Ryc2EuY3J0MB8GA1UdEQQYMBaCFGFsaWNs
        b3VkLXByb3ZpZGVyLmNuMA0GCSqGSIb3DQEBCwUAA4IBAQCwUBeznv6cAjcTLCDb
        SSvgkM9HFcbWnuGS8Nf5P4YfmSs52VuHZyjzwphjAU6B/danI/nMdZe52PXyvjVV
        02Y8ld/tMpqPV5SpaOadLtdg6TGBNJieOAt9doM8WNEgq/JycAL9ivIOjChUetZf
        ZEV7HDIgiHSpqAPWMZYL71MS/p5zYkyOnPqmGyLNdi1neotwVCQopQXRNC2iLlVV
        yQONfXH5iijqr1iTWkB0ESK/xBt1PB655PlTjzFQUOovE1SyoQS8K3u7TP6+BqtD
        G9TYNTNZvxl5I/iU/KdWVip+qJbxRA8Skc8gHkkzeIEStw3l5cjnrp9h7EhnhkOh
        ltGN
        -----END CERTIFICATE-----
        \"\"\",
                key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIIEpQIBAAKCAQEA3ZKLfXtKTAkzwLQNvUs+bBfmj0/5fft7Dp0HidZCizZKiokI
        MAA3saAKpZk2mTNN4Ifxp5Kj8PYMTf3yR1nVc8RNNxbPGyoDHUunH9L/8QK60M5u
        jeL5rG7hPEl9nrt9NzwLMgTKjwckzg2eYvuS5GXK8TBULGwN8ZwaLs0uXvk/mu2E
        8slb+Vg8vO9f7HUQGE351LbXZ6pChnjCoEIEZSdqQ5Of5NosJkJkof8G5OOuftVO
        cNp6T2Bj7xgJM5e0UXOP1XJKpVfD9HJoILqiEcpZScBRJ73KaqTh08QTgavYmeG/
        4e8p63wfxmwMOe+HkhJdIMywVutG0/WHnW03lwIDAQABAoIBAQCe5rHS09B8pzzO
        PlJ8JrIlox5eOOScTPX7jPITD+25GL5si8mrYvyODlCUYkSdqgV3uQa9PpUEAfDh
        HfXa5boGxAj8MQdmW8LQB6lbUV7r4SFJDkKKzvRvjTVKnwnQBHXQXudIf9ckq+Lh
        QzMLmY/G7JmWTyqOkQ+O7nx4g/11bcU7uQrQdvWPfc0+IiT1TYQdyLQ/Chlj3RF/
        iwF8ZL2sfKF+Z5O49+Q6cXvUcQOvqtkIXbQijayyVNBMJwDB7aOZRA7JBNj9/ib6
        N0iTo81dJVz/nnpbWRaFTVinIsDF1heDfQ1qDx06T/Mpi6pjoWjRUcyIHEbZJTel
        0nXDJD1BAoGBAPZB/PN8MP+o9gkf2jnoU9LzctDJrQwD1J2XElq4RomimPIMqDQP
        5TRAJThf0O0X4Mv2n9EzV457OpJL+fz9htRWEYogWl9bkbzZ1AoX4K/acuGeawTT
        YEhPjJ2ZETsBsCeDkDDuHHzYwRQv+EfoXH36z9PBDxG1ZDb7kWwAILXdAoGBAOZW
        jXG7m4I7cxUtXGtjwydh4K7nwH/5QoH2m928HM2AT48eQCl3CMQ089+qeJGgfHQv
        GyVOO/FGhcFsFi10FMQ7IlwWgZODg64qnrNhi4zbV1M2wKem1T2dlEpkd82EFdnS
        GYRIEkFORMxEDyzx3Th2TajpWC8YKKG3Tnm0bQ4DAoGBAIZTEEswHvoVi78GZN7Z
        X3/d028X0xCOtlcPpK9ffPpuesbtKILdeMS7iJHrkecB81jOOfa+7q+FgDl0v/PD
        xtvj5sVVSHZjWGeO2h53T9QccDWpV+7V7dsDqUv9xmxNS20CUpCeEWP4R7lfQSrY
        EDuXp+11jWa3buae6n/iwfTxAoGABEYW2cVhXUk9GWd+D4AKXvCx+ozSRY2abk7l
        FXgoEKgQ0db92ccboohY/g1rr0gLBxzYpBiPhCqK0MvwnWdJ+1odiRfhz5rhFpoz
        16A3tqVbOXAKoxG1Yy9JURgMIQQSY7hCQPIVZKDPJfsdTPgv4pxPVJL/z9/i4R1F
        l3yBiYECgYEA0+vpzL24nHZYdwgBF4qbmYhv8baRi07/BNgV1+d6vESuO/MwwoE/
        2UZ9Drf5yoX2Bvi5/vVMbyc7cSluO7icPBkl0D8F7E3x0v5mzwPxtpR8BTRoJKOL
        /rMdLscMz2VQsL5DJd/9OZg60fHRaRtWtV0afXzL5zUxnfDLot24IG4=
        -----END RSA PRIVATE KEY-----
        \"\"\"))
        default_listener = alicloud.ga.Listener("default",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            name=name,
            protocol="HTTPS",
            port_ranges=[{
                "from_port": 8080,
                "to_port": 8080,
            }],
            certificates=[{
                "id": std.join_output(separator="-",
                    input=[
                        default_service_certificate[1].id,
                        region,
                    ]).apply(lambda invoke: invoke.result),
            }])
        domain = "alicloud-provider.cn"
        default_additional_certificate = alicloud.ga.AdditionalCertificate("default",
            certificate_id=std.join_output(separator="-",
                input=[
                    default_service_certificate[1].id,
                    region,
                ]).apply(lambda invoke: invoke.result),
            domain=domain,
            accelerator_id=default_listener.accelerator_id,
            listener_id=default_listener.id)
        ```

        ## Import

        Global Accelerator (GA) Additional Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ga/additionalCertificate:AdditionalCertificate example <accelerator_id>:<listener_id>:<domain>
        ```

        :param str resource_name: The name of the resource.
        :param AdditionalCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdditionalCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdditionalCertificateArgs.__new__(AdditionalCertificateArgs)

            if accelerator_id is None and not opts.urn:
                raise TypeError("Missing required property 'accelerator_id'")
            __props__.__dict__["accelerator_id"] = accelerator_id
            if certificate_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_id'")
            __props__.__dict__["certificate_id"] = certificate_id
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
        super(AdditionalCertificate, __self__).__init__(
            'alicloud:ga/additionalCertificate:AdditionalCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AdditionalCertificate':
        """
        Get an existing AdditionalCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accelerator_id: The ID of the GA instance.
        :param pulumi.Input[_builtins.str] certificate_id: The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        :param pulumi.Input[_builtins.str] domain: The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdditionalCertificateState.__new__(_AdditionalCertificateState)

        __props__.__dict__["accelerator_id"] = accelerator_id
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["domain"] = domain
        __props__.__dict__["listener_id"] = listener_id
        return AdditionalCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Certificate ID. **NOTE:** From version 1.209.1, `certificate_id` can be modified.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name specified by the certificate. **NOTE:** You can associate each domain name with only one additional certificate.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the listener. **NOTE:** Only HTTPS listeners support this parameter.
        """
        return pulumi.get(self, "listener_id")

