# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['JdbcDataSourceArgs', 'JdbcDataSource']

@pulumi.input_type
class JdbcDataSourceArgs:
    def __init__(__self__, *,
                 db_instance_id: pulumi.Input[_builtins.str],
                 jdbc_user_name: pulumi.Input[_builtins.str],
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a JdbcDataSource resource.
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] jdbc_user_name: The name of the database account.
        :param pulumi.Input[_builtins.str] data_source_description: Data Source Description
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: Data Source Type
        :param pulumi.Input[_builtins.str] jdbc_connection_string: The JDBC connection string.
        :param pulumi.Input[_builtins.str] jdbc_password: The password of the database account.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "jdbc_user_name", jdbc_user_name)
        if data_source_description is not None:
            pulumi.set(__self__, "data_source_description", data_source_description)
        if data_source_name is not None:
            pulumi.set(__self__, "data_source_name", data_source_name)
        if data_source_type is not None:
            pulumi.set(__self__, "data_source_type", data_source_type)
        if jdbc_connection_string is not None:
            pulumi.set(__self__, "jdbc_connection_string", jdbc_connection_string)
        if jdbc_password is not None:
            pulumi.set(__self__, "jdbc_password", jdbc_password)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="jdbcUserName")
    def jdbc_user_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the database account.
        """
        return pulumi.get(self, "jdbc_user_name")

    @jdbc_user_name.setter
    def jdbc_user_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "jdbc_user_name", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceDescription")
    def data_source_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Description
        """
        return pulumi.get(self, "data_source_description")

    @data_source_description.setter
    def data_source_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_description", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_name", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Type
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="jdbcConnectionString")
    def jdbc_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JDBC connection string.
        """
        return pulumi.get(self, "jdbc_connection_string")

    @jdbc_connection_string.setter
    def jdbc_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jdbc_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="jdbcPassword")
    def jdbc_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the database account.
        """
        return pulumi.get(self, "jdbc_password")

    @jdbc_password.setter
    def jdbc_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jdbc_password", value)


@pulumi.input_type
class _JdbcDataSourceState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_password: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering JdbcDataSource resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] data_source_description: Data Source Description
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: Data Source Type
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] jdbc_connection_string: The JDBC connection string.
        :param pulumi.Input[_builtins.str] jdbc_password: The password of the database account.
        :param pulumi.Input[_builtins.str] jdbc_user_name: The name of the database account.
        :param pulumi.Input[_builtins.str] status: Data Source Status
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_source_description is not None:
            pulumi.set(__self__, "data_source_description", data_source_description)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if data_source_name is not None:
            pulumi.set(__self__, "data_source_name", data_source_name)
        if data_source_type is not None:
            pulumi.set(__self__, "data_source_type", data_source_type)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if jdbc_connection_string is not None:
            pulumi.set(__self__, "jdbc_connection_string", jdbc_connection_string)
        if jdbc_password is not None:
            pulumi.set(__self__, "jdbc_password", jdbc_password)
        if jdbc_user_name is not None:
            pulumi.set(__self__, "jdbc_user_name", jdbc_user_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceDescription")
    def data_source_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Description
        """
        return pulumi.get(self, "data_source_description")

    @data_source_description.setter
    def data_source_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_description", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_name", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Type
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="jdbcConnectionString")
    def jdbc_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JDBC connection string.
        """
        return pulumi.get(self, "jdbc_connection_string")

    @jdbc_connection_string.setter
    def jdbc_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jdbc_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="jdbcPassword")
    def jdbc_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the database account.
        """
        return pulumi.get(self, "jdbc_password")

    @jdbc_password.setter
    def jdbc_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jdbc_password", value)

    @_builtins.property
    @pulumi.getter(name="jdbcUserName")
    def jdbc_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database account.
        """
        return pulumi.get(self, "jdbc_user_name")

    @jdbc_user_name.setter
    def jdbc_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jdbc_user_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:gpdb/jdbcDataSource:JdbcDataSource")
class JdbcDataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_password: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a GPDB Jdbc Data Source resource.

        For information about GPDB Jdbc Data Source and how to use it, see [What is Jdbc Data Source](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createjdbcdatasource).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id="cn-beijing-h")
        defaulttuq_tm_m = alicloud.gpdb.Instance("defaulttuqTmM",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=default_get_switches.ids[0],
            storage_size=50,
            master_cu=4,
            vpc_id=default_get_networks.ids[0],
            db_instance_mode="StorageElastic",
            engine="gpdb",
            db_instance_category="Basic")
        defaultsk1ea_s = alicloud.gpdb.Account("defaultsk1eaS",
            account_description="example_001",
            db_instance_id=defaulttuq_tm_m.id,
            account_name="example_001",
            account_password="example_001")
        default_r_xkf_kl = alicloud.gpdb.ExternalDataService("defaultRXkfKL",
            service_name=name,
            db_instance_id=defaulttuq_tm_m.id,
            service_description="myexample",
            service_spec="8")
        default_jdbc_data_source = alicloud.gpdb.JdbcDataSource("default",
            jdbc_connection_string="jdbc:mysql://rm-2ze327yr44c61183c.mysql.rds.aliyuncs.com:3306/example_001",
            data_source_description="myexample",
            db_instance_id=defaulttuq_tm_m.id,
            jdbc_password="example_001",
            data_source_name=default_r_xkf_kl.service_name,
            data_source_type="mysql",
            jdbc_user_name="example_001")
        ```

        ## Import

        GPDB Jdbc Data Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/jdbcDataSource:JdbcDataSource example <db_instance_id>:<data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_source_description: Data Source Description
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: Data Source Type
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] jdbc_connection_string: The JDBC connection string.
        :param pulumi.Input[_builtins.str] jdbc_password: The password of the database account.
        :param pulumi.Input[_builtins.str] jdbc_user_name: The name of the database account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JdbcDataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GPDB Jdbc Data Source resource.

        For information about GPDB Jdbc Data Source and how to use it, see [What is Jdbc Data Source](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createjdbcdatasource).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id="cn-beijing-h")
        defaulttuq_tm_m = alicloud.gpdb.Instance("defaulttuqTmM",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=default_get_switches.ids[0],
            storage_size=50,
            master_cu=4,
            vpc_id=default_get_networks.ids[0],
            db_instance_mode="StorageElastic",
            engine="gpdb",
            db_instance_category="Basic")
        defaultsk1ea_s = alicloud.gpdb.Account("defaultsk1eaS",
            account_description="example_001",
            db_instance_id=defaulttuq_tm_m.id,
            account_name="example_001",
            account_password="example_001")
        default_r_xkf_kl = alicloud.gpdb.ExternalDataService("defaultRXkfKL",
            service_name=name,
            db_instance_id=defaulttuq_tm_m.id,
            service_description="myexample",
            service_spec="8")
        default_jdbc_data_source = alicloud.gpdb.JdbcDataSource("default",
            jdbc_connection_string="jdbc:mysql://rm-2ze327yr44c61183c.mysql.rds.aliyuncs.com:3306/example_001",
            data_source_description="myexample",
            db_instance_id=defaulttuq_tm_m.id,
            jdbc_password="example_001",
            data_source_name=default_r_xkf_kl.service_name,
            data_source_type="mysql",
            jdbc_user_name="example_001")
        ```

        ## Import

        GPDB Jdbc Data Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/jdbcDataSource:JdbcDataSource example <db_instance_id>:<data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param JdbcDataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JdbcDataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_password: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JdbcDataSourceArgs.__new__(JdbcDataSourceArgs)

            __props__.__dict__["data_source_description"] = data_source_description
            __props__.__dict__["data_source_name"] = data_source_name
            __props__.__dict__["data_source_type"] = data_source_type
            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            __props__.__dict__["jdbc_connection_string"] = jdbc_connection_string
            __props__.__dict__["jdbc_password"] = jdbc_password
            if jdbc_user_name is None and not opts.urn:
                raise TypeError("Missing required property 'jdbc_user_name'")
            __props__.__dict__["jdbc_user_name"] = jdbc_user_name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["data_source_id"] = None
            __props__.__dict__["status"] = None
        super(JdbcDataSource, __self__).__init__(
            'alicloud:gpdb/jdbcDataSource:JdbcDataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_description: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            jdbc_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            jdbc_password: Optional[pulumi.Input[_builtins.str]] = None,
            jdbc_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'JdbcDataSource':
        """
        Get an existing JdbcDataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] data_source_description: Data Source Description
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] data_source_type: Data Source Type
        :param pulumi.Input[_builtins.str] db_instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] jdbc_connection_string: The JDBC connection string.
        :param pulumi.Input[_builtins.str] jdbc_password: The password of the database account.
        :param pulumi.Input[_builtins.str] jdbc_user_name: The name of the database account.
        :param pulumi.Input[_builtins.str] status: Data Source Status
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JdbcDataSourceState.__new__(_JdbcDataSourceState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_source_description"] = data_source_description
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["data_source_name"] = data_source_name
        __props__.__dict__["data_source_type"] = data_source_type
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["jdbc_connection_string"] = jdbc_connection_string
        __props__.__dict__["jdbc_password"] = jdbc_password
        __props__.__dict__["jdbc_user_name"] = jdbc_user_name
        __props__.__dict__["status"] = status
        return JdbcDataSource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataSourceDescription")
    def data_source_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Data Source Description
        """
        return pulumi.get(self, "data_source_description")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[_builtins.str]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Data Source Type
        """
        return pulumi.get(self, "data_source_type")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="jdbcConnectionString")
    def jdbc_connection_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The JDBC connection string.
        """
        return pulumi.get(self, "jdbc_connection_string")

    @_builtins.property
    @pulumi.getter(name="jdbcPassword")
    def jdbc_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the database account.
        """
        return pulumi.get(self, "jdbc_password")

    @_builtins.property
    @pulumi.getter(name="jdbcUserName")
    def jdbc_user_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the database account.
        """
        return pulumi.get(self, "jdbc_user_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Data Source Status
        """
        return pulumi.get(self, "status")

