# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DbInstancePlanPlanConfig',
    'DbInstancePlanPlanConfigPause',
    'DbInstancePlanPlanConfigResume',
    'DbInstancePlanPlanConfigScaleDown',
    'DbInstancePlanPlanConfigScaleIn',
    'DbInstancePlanPlanConfigScaleOut',
    'DbInstancePlanPlanConfigScaleUp',
    'InstanceIpWhitelist',
    'InstanceParameter',
    'GetAccountsAccountResult',
    'GetDataBackupsBackupResult',
    'GetDbInstancePlansPlanResult',
    'GetDbInstancePlansPlanPlanConfigResult',
    'GetDbInstancePlansPlanPlanConfigPauseResult',
    'GetDbInstancePlansPlanPlanConfigResumeResult',
    'GetDbInstancePlansPlanPlanConfigScaleInResult',
    'GetDbInstancePlansPlanPlanConfigScaleOutResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceIpWhitelistResult',
    'GetLogBackupsLogbackupResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class DbInstancePlanPlanConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleDown":
            suggest = "scale_down"
        elif key == "scaleIn":
            suggest = "scale_in"
        elif key == "scaleOut":
            suggest = "scale_out"
        elif key == "scaleUp":
            suggest = "scale_up"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstancePlanPlanConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstancePlanPlanConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstancePlanPlanConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pause: Optional['outputs.DbInstancePlanPlanConfigPause'] = None,
                 resume: Optional['outputs.DbInstancePlanPlanConfigResume'] = None,
                 scale_down: Optional['outputs.DbInstancePlanPlanConfigScaleDown'] = None,
                 scale_in: Optional['outputs.DbInstancePlanPlanConfigScaleIn'] = None,
                 scale_out: Optional['outputs.DbInstancePlanPlanConfigScaleOut'] = None,
                 scale_up: Optional['outputs.DbInstancePlanPlanConfigScaleUp'] = None):
        """
        :param 'DbInstancePlanPlanConfigPauseArgs' pause: Pause instance plan config. See `pause` below.
        :param 'DbInstancePlanPlanConfigResumeArgs' resume: Resume instance plan config. See `resume` below.
        :param 'DbInstancePlanPlanConfigScaleDownArgs' scale_down: Scale down instance plan config. See `scale_down` below.
        :param 'DbInstancePlanPlanConfigScaleInArgs' scale_in: Scale In instance plan config. See `scale_in` below.
        :param 'DbInstancePlanPlanConfigScaleOutArgs' scale_out: Scale out instance plan config. See `scale_out` below.
        :param 'DbInstancePlanPlanConfigScaleUpArgs' scale_up: Scale up instance plan config. See `scale_up` below.
        """
        if pause is not None:
            pulumi.set(__self__, "pause", pause)
        if resume is not None:
            pulumi.set(__self__, "resume", resume)
        if scale_down is not None:
            pulumi.set(__self__, "scale_down", scale_down)
        if scale_in is not None:
            pulumi.set(__self__, "scale_in", scale_in)
        if scale_out is not None:
            pulumi.set(__self__, "scale_out", scale_out)
        if scale_up is not None:
            pulumi.set(__self__, "scale_up", scale_up)

    @_builtins.property
    @pulumi.getter
    def pause(self) -> Optional['outputs.DbInstancePlanPlanConfigPause']:
        """
        Pause instance plan config. See `pause` below.
        """
        return pulumi.get(self, "pause")

    @_builtins.property
    @pulumi.getter
    def resume(self) -> Optional['outputs.DbInstancePlanPlanConfigResume']:
        """
        Resume instance plan config. See `resume` below.
        """
        return pulumi.get(self, "resume")

    @_builtins.property
    @pulumi.getter(name="scaleDown")
    def scale_down(self) -> Optional['outputs.DbInstancePlanPlanConfigScaleDown']:
        """
        Scale down instance plan config. See `scale_down` below.
        """
        return pulumi.get(self, "scale_down")

    @_builtins.property
    @pulumi.getter(name="scaleIn")
    def scale_in(self) -> Optional['outputs.DbInstancePlanPlanConfigScaleIn']:
        """
        Scale In instance plan config. See `scale_in` below.
        """
        return pulumi.get(self, "scale_in")

    @_builtins.property
    @pulumi.getter(name="scaleOut")
    def scale_out(self) -> Optional['outputs.DbInstancePlanPlanConfigScaleOut']:
        """
        Scale out instance plan config. See `scale_out` below.
        """
        return pulumi.get(self, "scale_out")

    @_builtins.property
    @pulumi.getter(name="scaleUp")
    def scale_up(self) -> Optional['outputs.DbInstancePlanPlanConfigScaleUp']:
        """
        Scale up instance plan config. See `scale_up` below.
        """
        return pulumi.get(self, "scale_up")


@pulumi.output_type
class DbInstancePlanPlanConfigPause(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeTime":
            suggest = "execute_time"
        elif key == "planCronTime":
            suggest = "plan_cron_time"
        elif key == "planTaskStatus":
            suggest = "plan_task_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstancePlanPlanConfigPause. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstancePlanPlanConfigPause.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstancePlanPlanConfigPause.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_time: Optional[_builtins.str] = None,
                 plan_cron_time: Optional[_builtins.str] = None,
                 plan_task_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str execute_time: The executed time of the Plan.
        :param _builtins.str plan_cron_time: The Cron Time of the plan.
        :param _builtins.str plan_task_status: (Available since v1.231.0) The status of the plan task.
        """
        if execute_time is not None:
            pulumi.set(__self__, "execute_time", execute_time)
        if plan_cron_time is not None:
            pulumi.set(__self__, "plan_cron_time", plan_cron_time)
        if plan_task_status is not None:
            pulumi.set(__self__, "plan_task_status", plan_task_status)

    @_builtins.property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> Optional[_builtins.str]:
        """
        The executed time of the Plan.
        """
        return pulumi.get(self, "execute_time")

    @_builtins.property
    @pulumi.getter(name="planCronTime")
    def plan_cron_time(self) -> Optional[_builtins.str]:
        """
        The Cron Time of the plan.
        """
        return pulumi.get(self, "plan_cron_time")

    @_builtins.property
    @pulumi.getter(name="planTaskStatus")
    def plan_task_status(self) -> Optional[_builtins.str]:
        """
        (Available since v1.231.0) The status of the plan task.
        """
        return pulumi.get(self, "plan_task_status")


@pulumi.output_type
class DbInstancePlanPlanConfigResume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeTime":
            suggest = "execute_time"
        elif key == "planCronTime":
            suggest = "plan_cron_time"
        elif key == "planTaskStatus":
            suggest = "plan_task_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstancePlanPlanConfigResume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstancePlanPlanConfigResume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstancePlanPlanConfigResume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_time: Optional[_builtins.str] = None,
                 plan_cron_time: Optional[_builtins.str] = None,
                 plan_task_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str execute_time: The executed time of the Plan.
        :param _builtins.str plan_cron_time: The Cron Time of the plan.
        :param _builtins.str plan_task_status: (Available since v1.231.0) The status of the plan task.
        """
        if execute_time is not None:
            pulumi.set(__self__, "execute_time", execute_time)
        if plan_cron_time is not None:
            pulumi.set(__self__, "plan_cron_time", plan_cron_time)
        if plan_task_status is not None:
            pulumi.set(__self__, "plan_task_status", plan_task_status)

    @_builtins.property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> Optional[_builtins.str]:
        """
        The executed time of the Plan.
        """
        return pulumi.get(self, "execute_time")

    @_builtins.property
    @pulumi.getter(name="planCronTime")
    def plan_cron_time(self) -> Optional[_builtins.str]:
        """
        The Cron Time of the plan.
        """
        return pulumi.get(self, "plan_cron_time")

    @_builtins.property
    @pulumi.getter(name="planTaskStatus")
    def plan_task_status(self) -> Optional[_builtins.str]:
        """
        (Available since v1.231.0) The status of the plan task.
        """
        return pulumi.get(self, "plan_task_status")


@pulumi.output_type
class DbInstancePlanPlanConfigScaleDown(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeTime":
            suggest = "execute_time"
        elif key == "instanceSpec":
            suggest = "instance_spec"
        elif key == "planCronTime":
            suggest = "plan_cron_time"
        elif key == "planTaskStatus":
            suggest = "plan_task_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstancePlanPlanConfigScaleDown. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstancePlanPlanConfigScaleDown.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstancePlanPlanConfigScaleDown.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_time: Optional[_builtins.str] = None,
                 instance_spec: Optional[_builtins.str] = None,
                 plan_cron_time: Optional[_builtins.str] = None,
                 plan_task_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str execute_time: The executed time of the Plan.
        :param _builtins.str instance_spec: The specification of segment nodes of the Plan.
        :param _builtins.str plan_cron_time: The Cron Time of the plan.
        :param _builtins.str plan_task_status: (Available since v1.231.0) The status of the plan task.
        """
        if execute_time is not None:
            pulumi.set(__self__, "execute_time", execute_time)
        if instance_spec is not None:
            pulumi.set(__self__, "instance_spec", instance_spec)
        if plan_cron_time is not None:
            pulumi.set(__self__, "plan_cron_time", plan_cron_time)
        if plan_task_status is not None:
            pulumi.set(__self__, "plan_task_status", plan_task_status)

    @_builtins.property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> Optional[_builtins.str]:
        """
        The executed time of the Plan.
        """
        return pulumi.get(self, "execute_time")

    @_builtins.property
    @pulumi.getter(name="instanceSpec")
    def instance_spec(self) -> Optional[_builtins.str]:
        """
        The specification of segment nodes of the Plan.
        """
        return pulumi.get(self, "instance_spec")

    @_builtins.property
    @pulumi.getter(name="planCronTime")
    def plan_cron_time(self) -> Optional[_builtins.str]:
        """
        The Cron Time of the plan.
        """
        return pulumi.get(self, "plan_cron_time")

    @_builtins.property
    @pulumi.getter(name="planTaskStatus")
    def plan_task_status(self) -> Optional[_builtins.str]:
        """
        (Available since v1.231.0) The status of the plan task.
        """
        return pulumi.get(self, "plan_task_status")


@pulumi.output_type
class DbInstancePlanPlanConfigScaleIn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeTime":
            suggest = "execute_time"
        elif key == "planCronTime":
            suggest = "plan_cron_time"
        elif key == "planTaskStatus":
            suggest = "plan_task_status"
        elif key == "segmentNodeNum":
            suggest = "segment_node_num"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstancePlanPlanConfigScaleIn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstancePlanPlanConfigScaleIn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstancePlanPlanConfigScaleIn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_time: Optional[_builtins.str] = None,
                 plan_cron_time: Optional[_builtins.str] = None,
                 plan_task_status: Optional[_builtins.str] = None,
                 segment_node_num: Optional[_builtins.str] = None):
        """
        :param _builtins.str execute_time: The executed time of the Plan.
        :param _builtins.str plan_cron_time: The Cron Time of the plan.
        :param _builtins.str plan_task_status: (Available since v1.231.0) The status of the plan task.
        :param _builtins.str segment_node_num: The segment Node Num of the Plan.
        """
        if execute_time is not None:
            pulumi.set(__self__, "execute_time", execute_time)
        if plan_cron_time is not None:
            pulumi.set(__self__, "plan_cron_time", plan_cron_time)
        if plan_task_status is not None:
            pulumi.set(__self__, "plan_task_status", plan_task_status)
        if segment_node_num is not None:
            pulumi.set(__self__, "segment_node_num", segment_node_num)

    @_builtins.property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> Optional[_builtins.str]:
        """
        The executed time of the Plan.
        """
        return pulumi.get(self, "execute_time")

    @_builtins.property
    @pulumi.getter(name="planCronTime")
    def plan_cron_time(self) -> Optional[_builtins.str]:
        """
        The Cron Time of the plan.
        """
        return pulumi.get(self, "plan_cron_time")

    @_builtins.property
    @pulumi.getter(name="planTaskStatus")
    def plan_task_status(self) -> Optional[_builtins.str]:
        """
        (Available since v1.231.0) The status of the plan task.
        """
        return pulumi.get(self, "plan_task_status")

    @_builtins.property
    @pulumi.getter(name="segmentNodeNum")
    def segment_node_num(self) -> Optional[_builtins.str]:
        """
        The segment Node Num of the Plan.
        """
        return pulumi.get(self, "segment_node_num")


@pulumi.output_type
class DbInstancePlanPlanConfigScaleOut(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeTime":
            suggest = "execute_time"
        elif key == "planCronTime":
            suggest = "plan_cron_time"
        elif key == "planTaskStatus":
            suggest = "plan_task_status"
        elif key == "segmentNodeNum":
            suggest = "segment_node_num"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstancePlanPlanConfigScaleOut. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstancePlanPlanConfigScaleOut.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstancePlanPlanConfigScaleOut.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_time: Optional[_builtins.str] = None,
                 plan_cron_time: Optional[_builtins.str] = None,
                 plan_task_status: Optional[_builtins.str] = None,
                 segment_node_num: Optional[_builtins.str] = None):
        """
        :param _builtins.str execute_time: The executed time of the Plan.
        :param _builtins.str plan_cron_time: The Cron Time of the plan.
        :param _builtins.str plan_task_status: (Available since v1.231.0) The status of the plan task.
        :param _builtins.str segment_node_num: The segment Node Num of the Plan.
        """
        if execute_time is not None:
            pulumi.set(__self__, "execute_time", execute_time)
        if plan_cron_time is not None:
            pulumi.set(__self__, "plan_cron_time", plan_cron_time)
        if plan_task_status is not None:
            pulumi.set(__self__, "plan_task_status", plan_task_status)
        if segment_node_num is not None:
            pulumi.set(__self__, "segment_node_num", segment_node_num)

    @_builtins.property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> Optional[_builtins.str]:
        """
        The executed time of the Plan.
        """
        return pulumi.get(self, "execute_time")

    @_builtins.property
    @pulumi.getter(name="planCronTime")
    def plan_cron_time(self) -> Optional[_builtins.str]:
        """
        The Cron Time of the plan.
        """
        return pulumi.get(self, "plan_cron_time")

    @_builtins.property
    @pulumi.getter(name="planTaskStatus")
    def plan_task_status(self) -> Optional[_builtins.str]:
        """
        (Available since v1.231.0) The status of the plan task.
        """
        return pulumi.get(self, "plan_task_status")

    @_builtins.property
    @pulumi.getter(name="segmentNodeNum")
    def segment_node_num(self) -> Optional[_builtins.str]:
        """
        The segment Node Num of the Plan.
        """
        return pulumi.get(self, "segment_node_num")


@pulumi.output_type
class DbInstancePlanPlanConfigScaleUp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeTime":
            suggest = "execute_time"
        elif key == "instanceSpec":
            suggest = "instance_spec"
        elif key == "planCronTime":
            suggest = "plan_cron_time"
        elif key == "planTaskStatus":
            suggest = "plan_task_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstancePlanPlanConfigScaleUp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstancePlanPlanConfigScaleUp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstancePlanPlanConfigScaleUp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_time: Optional[_builtins.str] = None,
                 instance_spec: Optional[_builtins.str] = None,
                 plan_cron_time: Optional[_builtins.str] = None,
                 plan_task_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str execute_time: The executed time of the Plan.
        :param _builtins.str instance_spec: The specification of segment nodes of the Plan.
        :param _builtins.str plan_cron_time: The Cron Time of the plan.
        :param _builtins.str plan_task_status: (Available since v1.231.0) The status of the plan task.
        """
        if execute_time is not None:
            pulumi.set(__self__, "execute_time", execute_time)
        if instance_spec is not None:
            pulumi.set(__self__, "instance_spec", instance_spec)
        if plan_cron_time is not None:
            pulumi.set(__self__, "plan_cron_time", plan_cron_time)
        if plan_task_status is not None:
            pulumi.set(__self__, "plan_task_status", plan_task_status)

    @_builtins.property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> Optional[_builtins.str]:
        """
        The executed time of the Plan.
        """
        return pulumi.get(self, "execute_time")

    @_builtins.property
    @pulumi.getter(name="instanceSpec")
    def instance_spec(self) -> Optional[_builtins.str]:
        """
        The specification of segment nodes of the Plan.
        """
        return pulumi.get(self, "instance_spec")

    @_builtins.property
    @pulumi.getter(name="planCronTime")
    def plan_cron_time(self) -> Optional[_builtins.str]:
        """
        The Cron Time of the plan.
        """
        return pulumi.get(self, "plan_cron_time")

    @_builtins.property
    @pulumi.getter(name="planTaskStatus")
    def plan_task_status(self) -> Optional[_builtins.str]:
        """
        (Available since v1.231.0) The status of the plan task.
        """
        return pulumi.get(self, "plan_task_status")


@pulumi.output_type
class InstanceIpWhitelist(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipGroupAttribute":
            suggest = "ip_group_attribute"
        elif key == "ipGroupName":
            suggest = "ip_group_name"
        elif key == "securityIpList":
            suggest = "security_ip_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceIpWhitelist. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceIpWhitelist.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceIpWhitelist.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_group_attribute: Optional[_builtins.str] = None,
                 ip_group_name: Optional[_builtins.str] = None,
                 security_ip_list: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_group_attribute: The value of this parameter is empty by default. The attribute of the whitelist group. 
               If the value contains `hidden`, this white list item will not output.
        :param _builtins.str ip_group_name: IP whitelist group name.
        :param _builtins.str security_ip_list: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]). System default to `["127.0.0.1"]`.
        """
        if ip_group_attribute is not None:
            pulumi.set(__self__, "ip_group_attribute", ip_group_attribute)
        if ip_group_name is not None:
            pulumi.set(__self__, "ip_group_name", ip_group_name)
        if security_ip_list is not None:
            pulumi.set(__self__, "security_ip_list", security_ip_list)

    @_builtins.property
    @pulumi.getter(name="ipGroupAttribute")
    def ip_group_attribute(self) -> Optional[_builtins.str]:
        """
        The value of this parameter is empty by default. The attribute of the whitelist group. 
        If the value contains `hidden`, this white list item will not output.
        """
        return pulumi.get(self, "ip_group_attribute")

    @_builtins.property
    @pulumi.getter(name="ipGroupName")
    def ip_group_name(self) -> Optional[_builtins.str]:
        """
        IP whitelist group name.
        """
        return pulumi.get(self, "ip_group_name")

    @_builtins.property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> Optional[_builtins.str]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]). System default to `["127.0.0.1"]`.
        """
        return pulumi.get(self, "security_ip_list")


@pulumi.output_type
class InstanceParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "forceRestartInstance":
            suggest = "force_restart_instance"
        elif key == "isChangeableConfig":
            suggest = "is_changeable_config"
        elif key == "optionalRange":
            suggest = "optional_range"
        elif key == "parameterDescription":
            suggest = "parameter_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str,
                 default_value: Optional[_builtins.str] = None,
                 force_restart_instance: Optional[_builtins.str] = None,
                 is_changeable_config: Optional[_builtins.str] = None,
                 optional_range: Optional[_builtins.str] = None,
                 parameter_description: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the parameter.
        :param _builtins.str value: The value of the parameter.
        :param _builtins.str default_value: (Available since v1.231.0) The default value of the parameter.
        :param _builtins.str force_restart_instance: (Available since v1.231.0) Whether to force restart the instance to config the parameter.
        :param _builtins.str is_changeable_config: (Available since v1.231.0) Whether the parameter is changeable.
        :param _builtins.str optional_range: (Available since v1.231.0) The optional range of the parameter.
        :param _builtins.str parameter_description: (Available since v1.231.0) The description of the parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if force_restart_instance is not None:
            pulumi.set(__self__, "force_restart_instance", force_restart_instance)
        if is_changeable_config is not None:
            pulumi.set(__self__, "is_changeable_config", is_changeable_config)
        if optional_range is not None:
            pulumi.set(__self__, "optional_range", optional_range)
        if parameter_description is not None:
            pulumi.set(__self__, "parameter_description", parameter_description)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the parameter.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[_builtins.str]:
        """
        (Available since v1.231.0) The default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter(name="forceRestartInstance")
    def force_restart_instance(self) -> Optional[_builtins.str]:
        """
        (Available since v1.231.0) Whether to force restart the instance to config the parameter.
        """
        return pulumi.get(self, "force_restart_instance")

    @_builtins.property
    @pulumi.getter(name="isChangeableConfig")
    def is_changeable_config(self) -> Optional[_builtins.str]:
        """
        (Available since v1.231.0) Whether the parameter is changeable.
        """
        return pulumi.get(self, "is_changeable_config")

    @_builtins.property
    @pulumi.getter(name="optionalRange")
    def optional_range(self) -> Optional[_builtins.str]:
        """
        (Available since v1.231.0) The optional range of the parameter.
        """
        return pulumi.get(self, "optional_range")

    @_builtins.property
    @pulumi.getter(name="parameterDescription")
    def parameter_description(self) -> Optional[_builtins.str]:
        """
        (Available since v1.231.0) The description of the parameter.
        """
        return pulumi.get(self, "parameter_description")


@pulumi.output_type
class GetAccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_description: _builtins.str,
                 account_name: _builtins.str,
                 db_instance_id: _builtins.str,
                 id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str account_description: The description of the account.
        :param _builtins.str account_name: The name of the account.
        :param _builtins.str db_instance_id: The ID of the instance.
        :param _builtins.str id: The ID of the Account. Its value is same as Queue Name.
        :param _builtins.str status: The status of the account. Valid values: `Active`, `Creating` and `Deleting`.
        """
        pulumi.set(__self__, "account_description", account_description)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> _builtins.str:
        """
        The description of the account.
        """
        return pulumi.get(self, "account_description")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        The name of the account.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Account. Its value is same as Queue Name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the account. Valid values: `Active`, `Creating` and `Deleting`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDataBackupsBackupResult(dict):
    def __init__(__self__, *,
                 backup_end_time: _builtins.str,
                 backup_end_time_local: _builtins.str,
                 backup_method: _builtins.str,
                 backup_mode: _builtins.str,
                 backup_set_id: _builtins.str,
                 backup_size: _builtins.int,
                 backup_start_time: _builtins.str,
                 backup_start_time_local: _builtins.str,
                 bakset_name: _builtins.str,
                 consistent_time: _builtins.int,
                 data_type: _builtins.str,
                 db_instance_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str backup_end_time: The backup end time. Format: yyyy-MM-ddTHH:mm:ssZ(UTC time).
        :param _builtins.str backup_end_time_local: The end time of the backup (local time).
        :param _builtins.str backup_method: Backup method. Value Description:-**Physical**: Physical backup.-**Snapshot**: the Snapshot backup.
        :param _builtins.str backup_mode: Backup mode.Full Backup Value Description:-**Automated**: The system is automatically backed up.-**Manual**: Manual backup.Recovery point value description:-**Automated**: The recovery point after a full backup.-**Manual**: The recovery point triggered manually by the user.-**Period**: The recovery point triggered periodically because of the backup policy.
        :param _builtins.str backup_set_id: The ID of the backup set.
        :param _builtins.int backup_size: The size of the backup file. Unit: Byte.
        :param _builtins.str backup_start_time: The backup start time. Format: yyyy-MM-ddTHH:mm:ssZ(UTC time).
        :param _builtins.str backup_start_time_local: The start time of the backup (local time).
        :param _builtins.str bakset_name: The name of the recovery point or full backup set.
        :param _builtins.int consistent_time: -Full backup: Returns the timestamp of the consistent point in time.-Recoverable point: Returns the timestamp of the recoverable point in time.
        :param _builtins.str data_type: The backup type. Value Description:-**DATA**: Full backup.-**RESTOREPOI**: Recoverable point.
        :param _builtins.str db_instance_id: The instance ID.
        :param _builtins.str status: Backup set status. Value Description:-Success: The backup has been completed.-Failed: Backup Failed.If not, return all.
        """
        pulumi.set(__self__, "backup_end_time", backup_end_time)
        pulumi.set(__self__, "backup_end_time_local", backup_end_time_local)
        pulumi.set(__self__, "backup_method", backup_method)
        pulumi.set(__self__, "backup_mode", backup_mode)
        pulumi.set(__self__, "backup_set_id", backup_set_id)
        pulumi.set(__self__, "backup_size", backup_size)
        pulumi.set(__self__, "backup_start_time", backup_start_time)
        pulumi.set(__self__, "backup_start_time_local", backup_start_time_local)
        pulumi.set(__self__, "bakset_name", bakset_name)
        pulumi.set(__self__, "consistent_time", consistent_time)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="backupEndTime")
    def backup_end_time(self) -> _builtins.str:
        """
        The backup end time. Format: yyyy-MM-ddTHH:mm:ssZ(UTC time).
        """
        return pulumi.get(self, "backup_end_time")

    @_builtins.property
    @pulumi.getter(name="backupEndTimeLocal")
    def backup_end_time_local(self) -> _builtins.str:
        """
        The end time of the backup (local time).
        """
        return pulumi.get(self, "backup_end_time_local")

    @_builtins.property
    @pulumi.getter(name="backupMethod")
    def backup_method(self) -> _builtins.str:
        """
        Backup method. Value Description:-**Physical**: Physical backup.-**Snapshot**: the Snapshot backup.
        """
        return pulumi.get(self, "backup_method")

    @_builtins.property
    @pulumi.getter(name="backupMode")
    def backup_mode(self) -> _builtins.str:
        """
        Backup mode.Full Backup Value Description:-**Automated**: The system is automatically backed up.-**Manual**: Manual backup.Recovery point value description:-**Automated**: The recovery point after a full backup.-**Manual**: The recovery point triggered manually by the user.-**Period**: The recovery point triggered periodically because of the backup policy.
        """
        return pulumi.get(self, "backup_mode")

    @_builtins.property
    @pulumi.getter(name="backupSetId")
    def backup_set_id(self) -> _builtins.str:
        """
        The ID of the backup set.
        """
        return pulumi.get(self, "backup_set_id")

    @_builtins.property
    @pulumi.getter(name="backupSize")
    def backup_size(self) -> _builtins.int:
        """
        The size of the backup file. Unit: Byte.
        """
        return pulumi.get(self, "backup_size")

    @_builtins.property
    @pulumi.getter(name="backupStartTime")
    def backup_start_time(self) -> _builtins.str:
        """
        The backup start time. Format: yyyy-MM-ddTHH:mm:ssZ(UTC time).
        """
        return pulumi.get(self, "backup_start_time")

    @_builtins.property
    @pulumi.getter(name="backupStartTimeLocal")
    def backup_start_time_local(self) -> _builtins.str:
        """
        The start time of the backup (local time).
        """
        return pulumi.get(self, "backup_start_time_local")

    @_builtins.property
    @pulumi.getter(name="baksetName")
    def bakset_name(self) -> _builtins.str:
        """
        The name of the recovery point or full backup set.
        """
        return pulumi.get(self, "bakset_name")

    @_builtins.property
    @pulumi.getter(name="consistentTime")
    def consistent_time(self) -> _builtins.int:
        """
        -Full backup: Returns the timestamp of the consistent point in time.-Recoverable point: Returns the timestamp of the recoverable point in time.
        """
        return pulumi.get(self, "consistent_time")

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> _builtins.str:
        """
        The backup type. Value Description:-**DATA**: Full backup.-**RESTOREPOI**: Recoverable point.
        """
        return pulumi.get(self, "data_type")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The instance ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Backup set status. Value Description:-Success: The backup has been completed.-Failed: Backup Failed.If not, return all.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDbInstancePlansPlanResult(dict):
    def __init__(__self__, *,
                 db_instance_plan_name: _builtins.str,
                 id: _builtins.str,
                 plan_configs: Sequence['outputs.GetDbInstancePlansPlanPlanConfigResult'],
                 plan_desc: _builtins.str,
                 plan_end_date: _builtins.str,
                 plan_id: _builtins.str,
                 plan_schedule_type: _builtins.str,
                 plan_start_date: _builtins.str,
                 plan_type: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str db_instance_plan_name: The name of the Plan.
        :param _builtins.str id: The ID of the resource. The value formats as `<db_instance_id>:<plan_id>`.
        :param Sequence['GetDbInstancePlansPlanPlanConfigArgs'] plan_configs: Plan configuration information.
        :param _builtins.str plan_end_date: The end time of the Plan.
        :param _builtins.str plan_id: The ID of DB Instance Plan.
        :param _builtins.str plan_schedule_type: Plan scheduling type. Valid values: `Postpone`, `Regular`.
        :param _builtins.str plan_start_date: The start time of the Plan.
        :param _builtins.str plan_type: The type of the Plan. Valid values: `PauseResume`, `Resize`.
        :param _builtins.str status: The Status of the Plan.
        """
        pulumi.set(__self__, "db_instance_plan_name", db_instance_plan_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "plan_configs", plan_configs)
        pulumi.set(__self__, "plan_desc", plan_desc)
        pulumi.set(__self__, "plan_end_date", plan_end_date)
        pulumi.set(__self__, "plan_id", plan_id)
        pulumi.set(__self__, "plan_schedule_type", plan_schedule_type)
        pulumi.set(__self__, "plan_start_date", plan_start_date)
        pulumi.set(__self__, "plan_type", plan_type)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="dbInstancePlanName")
    def db_instance_plan_name(self) -> _builtins.str:
        """
        The name of the Plan.
        """
        return pulumi.get(self, "db_instance_plan_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource. The value formats as `<db_instance_id>:<plan_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="planConfigs")
    def plan_configs(self) -> Sequence['outputs.GetDbInstancePlansPlanPlanConfigResult']:
        """
        Plan configuration information.
        """
        return pulumi.get(self, "plan_configs")

    @_builtins.property
    @pulumi.getter(name="planDesc")
    def plan_desc(self) -> _builtins.str:
        return pulumi.get(self, "plan_desc")

    @_builtins.property
    @pulumi.getter(name="planEndDate")
    def plan_end_date(self) -> _builtins.str:
        """
        The end time of the Plan.
        """
        return pulumi.get(self, "plan_end_date")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> _builtins.str:
        """
        The ID of DB Instance Plan.
        """
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter(name="planScheduleType")
    def plan_schedule_type(self) -> _builtins.str:
        """
        Plan scheduling type. Valid values: `Postpone`, `Regular`.
        """
        return pulumi.get(self, "plan_schedule_type")

    @_builtins.property
    @pulumi.getter(name="planStartDate")
    def plan_start_date(self) -> _builtins.str:
        """
        The start time of the Plan.
        """
        return pulumi.get(self, "plan_start_date")

    @_builtins.property
    @pulumi.getter(name="planType")
    def plan_type(self) -> _builtins.str:
        """
        The type of the Plan. Valid values: `PauseResume`, `Resize`.
        """
        return pulumi.get(self, "plan_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The Status of the Plan.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDbInstancePlansPlanPlanConfigResult(dict):
    def __init__(__self__, *,
                 pauses: Sequence['outputs.GetDbInstancePlansPlanPlanConfigPauseResult'],
                 resumes: Sequence['outputs.GetDbInstancePlansPlanPlanConfigResumeResult'],
                 scale_ins: Sequence['outputs.GetDbInstancePlansPlanPlanConfigScaleInResult'],
                 scale_outs: Sequence['outputs.GetDbInstancePlansPlanPlanConfigScaleOutResult']):
        """
        :param Sequence['GetDbInstancePlansPlanPlanConfigPauseArgs'] pauses: Pause instance plan config.
        :param Sequence['GetDbInstancePlansPlanPlanConfigResumeArgs'] resumes: Resume instance plan config.
        :param Sequence['GetDbInstancePlansPlanPlanConfigScaleInArgs'] scale_ins: Scale In instance plan config.
        :param Sequence['GetDbInstancePlansPlanPlanConfigScaleOutArgs'] scale_outs: Scale out instance plan config.
        """
        pulumi.set(__self__, "pauses", pauses)
        pulumi.set(__self__, "resumes", resumes)
        pulumi.set(__self__, "scale_ins", scale_ins)
        pulumi.set(__self__, "scale_outs", scale_outs)

    @_builtins.property
    @pulumi.getter
    def pauses(self) -> Sequence['outputs.GetDbInstancePlansPlanPlanConfigPauseResult']:
        """
        Pause instance plan config.
        """
        return pulumi.get(self, "pauses")

    @_builtins.property
    @pulumi.getter
    def resumes(self) -> Sequence['outputs.GetDbInstancePlansPlanPlanConfigResumeResult']:
        """
        Resume instance plan config.
        """
        return pulumi.get(self, "resumes")

    @_builtins.property
    @pulumi.getter(name="scaleIns")
    def scale_ins(self) -> Sequence['outputs.GetDbInstancePlansPlanPlanConfigScaleInResult']:
        """
        Scale In instance plan config.
        """
        return pulumi.get(self, "scale_ins")

    @_builtins.property
    @pulumi.getter(name="scaleOuts")
    def scale_outs(self) -> Sequence['outputs.GetDbInstancePlansPlanPlanConfigScaleOutResult']:
        """
        Scale out instance plan config.
        """
        return pulumi.get(self, "scale_outs")


@pulumi.output_type
class GetDbInstancePlansPlanPlanConfigPauseResult(dict):
    def __init__(__self__, *,
                 execute_time: _builtins.str,
                 plan_cron_time: _builtins.str,
                 plan_task_status: _builtins.str):
        """
        :param _builtins.str execute_time: The executed time of the Plan.
        :param _builtins.str plan_cron_time: The Cron Time of the plan.
        :param _builtins.str plan_task_status: The Status of the plan Task.
        """
        pulumi.set(__self__, "execute_time", execute_time)
        pulumi.set(__self__, "plan_cron_time", plan_cron_time)
        pulumi.set(__self__, "plan_task_status", plan_task_status)

    @_builtins.property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> _builtins.str:
        """
        The executed time of the Plan.
        """
        return pulumi.get(self, "execute_time")

    @_builtins.property
    @pulumi.getter(name="planCronTime")
    def plan_cron_time(self) -> _builtins.str:
        """
        The Cron Time of the plan.
        """
        return pulumi.get(self, "plan_cron_time")

    @_builtins.property
    @pulumi.getter(name="planTaskStatus")
    def plan_task_status(self) -> _builtins.str:
        """
        The Status of the plan Task.
        """
        return pulumi.get(self, "plan_task_status")


@pulumi.output_type
class GetDbInstancePlansPlanPlanConfigResumeResult(dict):
    def __init__(__self__, *,
                 execute_time: _builtins.str,
                 plan_cron_time: _builtins.str,
                 plan_task_status: _builtins.str):
        """
        :param _builtins.str execute_time: The executed time of the Plan.
        :param _builtins.str plan_cron_time: The Cron Time of the plan.
        :param _builtins.str plan_task_status: The Status of the plan Task.
        """
        pulumi.set(__self__, "execute_time", execute_time)
        pulumi.set(__self__, "plan_cron_time", plan_cron_time)
        pulumi.set(__self__, "plan_task_status", plan_task_status)

    @_builtins.property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> _builtins.str:
        """
        The executed time of the Plan.
        """
        return pulumi.get(self, "execute_time")

    @_builtins.property
    @pulumi.getter(name="planCronTime")
    def plan_cron_time(self) -> _builtins.str:
        """
        The Cron Time of the plan.
        """
        return pulumi.get(self, "plan_cron_time")

    @_builtins.property
    @pulumi.getter(name="planTaskStatus")
    def plan_task_status(self) -> _builtins.str:
        """
        The Status of the plan Task.
        """
        return pulumi.get(self, "plan_task_status")


@pulumi.output_type
class GetDbInstancePlansPlanPlanConfigScaleInResult(dict):
    def __init__(__self__, *,
                 execute_time: _builtins.str,
                 plan_cron_time: _builtins.str,
                 plan_task_status: _builtins.str,
                 segment_node_num: _builtins.str):
        """
        :param _builtins.str execute_time: The executed time of the Plan.
        :param _builtins.str plan_cron_time: The Cron Time of the plan.
        :param _builtins.str plan_task_status: The Status of the plan Task.
        :param _builtins.str segment_node_num: The segment Node Num of the Plan.
        """
        pulumi.set(__self__, "execute_time", execute_time)
        pulumi.set(__self__, "plan_cron_time", plan_cron_time)
        pulumi.set(__self__, "plan_task_status", plan_task_status)
        pulumi.set(__self__, "segment_node_num", segment_node_num)

    @_builtins.property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> _builtins.str:
        """
        The executed time of the Plan.
        """
        return pulumi.get(self, "execute_time")

    @_builtins.property
    @pulumi.getter(name="planCronTime")
    def plan_cron_time(self) -> _builtins.str:
        """
        The Cron Time of the plan.
        """
        return pulumi.get(self, "plan_cron_time")

    @_builtins.property
    @pulumi.getter(name="planTaskStatus")
    def plan_task_status(self) -> _builtins.str:
        """
        The Status of the plan Task.
        """
        return pulumi.get(self, "plan_task_status")

    @_builtins.property
    @pulumi.getter(name="segmentNodeNum")
    def segment_node_num(self) -> _builtins.str:
        """
        The segment Node Num of the Plan.
        """
        return pulumi.get(self, "segment_node_num")


@pulumi.output_type
class GetDbInstancePlansPlanPlanConfigScaleOutResult(dict):
    def __init__(__self__, *,
                 execute_time: _builtins.str,
                 plan_cron_time: _builtins.str,
                 plan_task_status: _builtins.str,
                 segment_node_num: _builtins.str):
        """
        :param _builtins.str execute_time: The executed time of the Plan.
        :param _builtins.str plan_cron_time: The Cron Time of the plan.
        :param _builtins.str plan_task_status: The Status of the plan Task.
        :param _builtins.str segment_node_num: The segment Node Num of the Plan.
        """
        pulumi.set(__self__, "execute_time", execute_time)
        pulumi.set(__self__, "plan_cron_time", plan_cron_time)
        pulumi.set(__self__, "plan_task_status", plan_task_status)
        pulumi.set(__self__, "segment_node_num", segment_node_num)

    @_builtins.property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> _builtins.str:
        """
        The executed time of the Plan.
        """
        return pulumi.get(self, "execute_time")

    @_builtins.property
    @pulumi.getter(name="planCronTime")
    def plan_cron_time(self) -> _builtins.str:
        """
        The Cron Time of the plan.
        """
        return pulumi.get(self, "plan_cron_time")

    @_builtins.property
    @pulumi.getter(name="planTaskStatus")
    def plan_task_status(self) -> _builtins.str:
        """
        The Status of the plan Task.
        """
        return pulumi.get(self, "plan_task_status")

    @_builtins.property
    @pulumi.getter(name="segmentNodeNum")
    def segment_node_num(self) -> _builtins.str:
        """
        The segment Node Num of the Plan.
        """
        return pulumi.get(self, "segment_node_num")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 charge_type: _builtins.str,
                 connection_string: _builtins.str,
                 cpu_cores: _builtins.str,
                 create_time: _builtins.str,
                 creation_time: _builtins.str,
                 db_instance_category: _builtins.str,
                 db_instance_class: _builtins.str,
                 db_instance_id: _builtins.str,
                 db_instance_mode: _builtins.str,
                 description: _builtins.str,
                 engine: _builtins.str,
                 engine_version: _builtins.str,
                 id: _builtins.str,
                 instance_network_type: _builtins.str,
                 ip_whitelists: Sequence['outputs.GetInstancesInstanceIpWhitelistResult'],
                 maintain_end_time: _builtins.str,
                 maintain_start_time: _builtins.str,
                 master_node_num: _builtins.str,
                 memory_size: _builtins.str,
                 payment_type: _builtins.str,
                 region_id: _builtins.str,
                 seg_node_num: _builtins.str,
                 status: _builtins.str,
                 storage_size: _builtins.int,
                 storage_type: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str availability_zone: Instance availability zone.
        :param _builtins.str connection_string: The connection string of the instance.
        :param _builtins.str cpu_cores: The number of CPU cores of the computing node. Unit: Core.
        :param _builtins.str create_time: The time when the instance was created. The time is in the YYYY-MM-DDThh:mm:ssZ format, such as 2011-05-30T12:11:4Z.
        :param _builtins.str db_instance_category: The db instance category. Valid values: `HighAvailability`, `Basic`.
        :param _builtins.str db_instance_class: The db instance class.
        :param _builtins.str db_instance_id: The db instance id.
        :param _builtins.str db_instance_mode: The db instance mode. Valid values: `StorageElastic`, `Serverless`, `Classic`.
        :param _builtins.str description: The description of the instance.
        :param _builtins.str engine: The database engine used by the instance.
        :param _builtins.str engine_version: The version of the database engine used by the instance.
        :param _builtins.str id: The ID of the db Instance.
        :param _builtins.str instance_network_type: The network type of the instance.
        :param Sequence['GetInstancesInstanceIpWhitelistArgs'] ip_whitelists: The ip whitelist.
        :param _builtins.str maintain_end_time: The end time of the maintenance window for the instance.
        :param _builtins.str maintain_start_time: The start time of the maintenance window for the instance.
        :param _builtins.str master_node_num: The number of Master nodes. Valid values: 1 to 2. if it is not filled in, the default value is 1 Master node.
        :param _builtins.str memory_size: The memory size of the compute node.
        :param _builtins.str payment_type: The billing method of the instance. Valid values: `Subscription`, `PayAsYouGo`.
        :param _builtins.str region_id: Region ID the instance belongs to.
        :param _builtins.str seg_node_num: Calculate the number of nodes. The value range of the high-availability version of the storage elastic mode is 4 to 512, and the value must be a multiple of 4. The value range of the basic version of the storage elastic mode is 2 to 512, and the value must be a multiple of 2. The-Serverless version has a value range of 2 to 512. The value must be a multiple of 2.
        :param _builtins.str status: The status of the instance. Valid values: `Creating`, `DBInstanceClassChanging`, `DBInstanceNetTypeChanging`, `Deleting`, `EngineVersionUpgrading`, `GuardDBInstanceCreating`, `GuardSwitching`, `Importing`, `ImportingFromOtherInstance`, `Rebooting`, `Restoring`, `Running`, `Transfering`, `TransferingToOtherInstance`.
        :param _builtins.int storage_size: The storage capacity. Unit: GB. Value: `50` to `4000`.
        :param _builtins.str storage_type: The type of disks. Valid values: `cloud_essd`, `cloud_efficiency`.
        :param Mapping[str, _builtins.str] tags: The tags of the instance.
        :param _builtins.str vpc_id: The ID of the VPC。.
        :param _builtins.str vswitch_id: The vswitch id.
        :param _builtins.str zone_id: The zone ID of the instance.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "cpu_cores", cpu_cores)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "db_instance_category", db_instance_category)
        pulumi.set(__self__, "db_instance_class", db_instance_class)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "db_instance_mode", db_instance_mode)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_network_type", instance_network_type)
        pulumi.set(__self__, "ip_whitelists", ip_whitelists)
        pulumi.set(__self__, "maintain_end_time", maintain_end_time)
        pulumi.set(__self__, "maintain_start_time", maintain_start_time)
        pulumi.set(__self__, "master_node_num", master_node_num)
        pulumi.set(__self__, "memory_size", memory_size)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "seg_node_num", seg_node_num)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_size", storage_size)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        Instance availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> _builtins.str:
        return pulumi.get(self, "charge_type")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> _builtins.str:
        """
        The connection string of the instance.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="cpuCores")
    def cpu_cores(self) -> _builtins.str:
        """
        The number of CPU cores of the computing node. Unit: Core.
        """
        return pulumi.get(self, "cpu_cores")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the instance was created. The time is in the YYYY-MM-DDThh:mm:ssZ format, such as 2011-05-30T12:11:4Z.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="dbInstanceCategory")
    def db_instance_category(self) -> _builtins.str:
        """
        The db instance category. Valid values: `HighAvailability`, `Basic`.
        """
        return pulumi.get(self, "db_instance_category")

    @_builtins.property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> _builtins.str:
        """
        The db instance class.
        """
        return pulumi.get(self, "db_instance_class")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The db instance id.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="dbInstanceMode")
    def db_instance_mode(self) -> _builtins.str:
        """
        The db instance mode. Valid values: `StorageElastic`, `Serverless`, `Classic`.
        """
        return pulumi.get(self, "db_instance_mode")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        The database engine used by the instance.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        The version of the database engine used by the instance.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the db Instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceNetworkType")
    def instance_network_type(self) -> _builtins.str:
        """
        The network type of the instance.
        """
        return pulumi.get(self, "instance_network_type")

    @_builtins.property
    @pulumi.getter(name="ipWhitelists")
    def ip_whitelists(self) -> Sequence['outputs.GetInstancesInstanceIpWhitelistResult']:
        """
        The ip whitelist.
        """
        return pulumi.get(self, "ip_whitelists")

    @_builtins.property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> _builtins.str:
        """
        The end time of the maintenance window for the instance.
        """
        return pulumi.get(self, "maintain_end_time")

    @_builtins.property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> _builtins.str:
        """
        The start time of the maintenance window for the instance.
        """
        return pulumi.get(self, "maintain_start_time")

    @_builtins.property
    @pulumi.getter(name="masterNodeNum")
    def master_node_num(self) -> _builtins.str:
        """
        The number of Master nodes. Valid values: 1 to 2. if it is not filled in, the default value is 1 Master node.
        """
        return pulumi.get(self, "master_node_num")

    @_builtins.property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> _builtins.str:
        """
        The memory size of the compute node.
        """
        return pulumi.get(self, "memory_size")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The billing method of the instance. Valid values: `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        Region ID the instance belongs to.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="segNodeNum")
    def seg_node_num(self) -> _builtins.str:
        """
        Calculate the number of nodes. The value range of the high-availability version of the storage elastic mode is 4 to 512, and the value must be a multiple of 4. The value range of the basic version of the storage elastic mode is 2 to 512, and the value must be a multiple of 2. The-Serverless version has a value range of 2 to 512. The value must be a multiple of 2.
        """
        return pulumi.get(self, "seg_node_num")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the instance. Valid values: `Creating`, `DBInstanceClassChanging`, `DBInstanceNetTypeChanging`, `Deleting`, `EngineVersionUpgrading`, `GuardDBInstanceCreating`, `GuardSwitching`, `Importing`, `ImportingFromOtherInstance`, `Rebooting`, `Restoring`, `Running`, `Transfering`, `TransferingToOtherInstance`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> _builtins.int:
        """
        The storage capacity. Unit: GB. Value: `50` to `4000`.
        """
        return pulumi.get(self, "storage_size")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        """
        The type of disks. Valid values: `cloud_essd`, `cloud_efficiency`.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tags of the instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC。.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetInstancesInstanceIpWhitelistResult(dict):
    def __init__(__self__, *,
                 ip_group_attribute: _builtins.str,
                 ip_group_name: _builtins.str,
                 security_ip_list: _builtins.str):
        """
        :param _builtins.str ip_group_attribute: The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
        :param _builtins.str ip_group_name: IP whitelist group name
        :param _builtins.str security_ip_list: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]). System default to `["127.0.0.1"]`.
        """
        pulumi.set(__self__, "ip_group_attribute", ip_group_attribute)
        pulumi.set(__self__, "ip_group_name", ip_group_name)
        pulumi.set(__self__, "security_ip_list", security_ip_list)

    @_builtins.property
    @pulumi.getter(name="ipGroupAttribute")
    def ip_group_attribute(self) -> _builtins.str:
        """
        The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
        """
        return pulumi.get(self, "ip_group_attribute")

    @_builtins.property
    @pulumi.getter(name="ipGroupName")
    def ip_group_name(self) -> _builtins.str:
        """
        IP whitelist group name
        """
        return pulumi.get(self, "ip_group_name")

    @_builtins.property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> _builtins.str:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]). System default to `["127.0.0.1"]`.
        """
        return pulumi.get(self, "security_ip_list")


@pulumi.output_type
class GetLogBackupsLogbackupResult(dict):
    def __init__(__self__, *,
                 db_instance_id: _builtins.str,
                 log_backup_id: _builtins.str,
                 log_file_name: _builtins.str,
                 log_file_size: _builtins.int,
                 log_time: _builtins.str,
                 record_total: _builtins.int,
                 segment_name: _builtins.str):
        """
        :param _builtins.str db_instance_id: The ID of the Master node of the instance.
        :param _builtins.str log_backup_id: The first ID of the resource
        :param _builtins.str log_file_name: Log file name (OSS path).
        :param _builtins.int log_file_size: Size of the backup log file. Unit: Byte.
        :param _builtins.str log_time: The log timestamp.
        :param _builtins.int record_total: Total number of records.
        :param _builtins.str segment_name: The node name.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "log_backup_id", log_backup_id)
        pulumi.set(__self__, "log_file_name", log_file_name)
        pulumi.set(__self__, "log_file_size", log_file_size)
        pulumi.set(__self__, "log_time", log_time)
        pulumi.set(__self__, "record_total", record_total)
        pulumi.set(__self__, "segment_name", segment_name)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The ID of the Master node of the instance.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="logBackupId")
    def log_backup_id(self) -> _builtins.str:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "log_backup_id")

    @_builtins.property
    @pulumi.getter(name="logFileName")
    def log_file_name(self) -> _builtins.str:
        """
        Log file name (OSS path).
        """
        return pulumi.get(self, "log_file_name")

    @_builtins.property
    @pulumi.getter(name="logFileSize")
    def log_file_size(self) -> _builtins.int:
        """
        Size of the backup log file. Unit: Byte.
        """
        return pulumi.get(self, "log_file_size")

    @_builtins.property
    @pulumi.getter(name="logTime")
    def log_time(self) -> _builtins.str:
        """
        The log timestamp.
        """
        return pulumi.get(self, "log_time")

    @_builtins.property
    @pulumi.getter(name="recordTotal")
    def record_total(self) -> _builtins.int:
        """
        Total number of records.
        """
        return pulumi.get(self, "record_total")

    @_builtins.property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> _builtins.str:
        """
        The node name.
        """
        return pulumi.get(self, "segment_name")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 multi_zone_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str id: ID of the zone.
        :param Sequence[_builtins.str] multi_zone_ids: A list of zone ids in which the multi zone.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multi_zone_ids", multi_zone_ids)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the zone.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="multiZoneIds")
    def multi_zone_ids(self) -> Sequence[_builtins.str]:
        """
        A list of zone ids in which the multi zone.
        """
        return pulumi.get(self, "multi_zone_ids")


