# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RemoteAdbDataSourceArgs', 'RemoteAdbDataSource']

@pulumi.input_type
class RemoteAdbDataSourceArgs:
    def __init__(__self__, *,
                 local_database: pulumi.Input[_builtins.str],
                 local_db_instance_id: pulumi.Input[_builtins.str],
                 manager_user_name: pulumi.Input[_builtins.str],
                 manager_user_password: pulumi.Input[_builtins.str],
                 remote_database: pulumi.Input[_builtins.str],
                 remote_db_instance_id: pulumi.Input[_builtins.str],
                 user_name: pulumi.Input[_builtins.str],
                 user_password: pulumi.Input[_builtins.str],
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RemoteAdbDataSource resource.
        :param pulumi.Input[_builtins.str] local_database: The database of the local instance which connection data.
        :param pulumi.Input[_builtins.str] local_db_instance_id: The instanceId of the local instance which connection data.
        :param pulumi.Input[_builtins.str] manager_user_name: The Management user name of the local instance.
        :param pulumi.Input[_builtins.str] manager_user_password: Password of the Manager user of the local instance
        :param pulumi.Input[_builtins.str] remote_database: The database of the remote instance which provide data.
        :param pulumi.Input[_builtins.str] remote_db_instance_id: The instanceId of the remote instance which provide data.
        :param pulumi.Input[_builtins.str] user_name: The user name used to connect to the remote instance
        :param pulumi.Input[_builtins.str] user_password: The user password used to connect to the remote instance
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        """
        pulumi.set(__self__, "local_database", local_database)
        pulumi.set(__self__, "local_db_instance_id", local_db_instance_id)
        pulumi.set(__self__, "manager_user_name", manager_user_name)
        pulumi.set(__self__, "manager_user_password", manager_user_password)
        pulumi.set(__self__, "remote_database", remote_database)
        pulumi.set(__self__, "remote_db_instance_id", remote_db_instance_id)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_password", user_password)
        if data_source_name is not None:
            pulumi.set(__self__, "data_source_name", data_source_name)

    @_builtins.property
    @pulumi.getter(name="localDatabase")
    def local_database(self) -> pulumi.Input[_builtins.str]:
        """
        The database of the local instance which connection data.
        """
        return pulumi.get(self, "local_database")

    @local_database.setter
    def local_database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "local_database", value)

    @_builtins.property
    @pulumi.getter(name="localDbInstanceId")
    def local_db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instanceId of the local instance which connection data.
        """
        return pulumi.get(self, "local_db_instance_id")

    @local_db_instance_id.setter
    def local_db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "local_db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="managerUserName")
    def manager_user_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Management user name of the local instance.
        """
        return pulumi.get(self, "manager_user_name")

    @manager_user_name.setter
    def manager_user_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "manager_user_name", value)

    @_builtins.property
    @pulumi.getter(name="managerUserPassword")
    def manager_user_password(self) -> pulumi.Input[_builtins.str]:
        """
        Password of the Manager user of the local instance
        """
        return pulumi.get(self, "manager_user_password")

    @manager_user_password.setter
    def manager_user_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "manager_user_password", value)

    @_builtins.property
    @pulumi.getter(name="remoteDatabase")
    def remote_database(self) -> pulumi.Input[_builtins.str]:
        """
        The database of the remote instance which provide data.
        """
        return pulumi.get(self, "remote_database")

    @remote_database.setter
    def remote_database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remote_database", value)

    @_builtins.property
    @pulumi.getter(name="remoteDbInstanceId")
    def remote_db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instanceId of the remote instance which provide data.
        """
        return pulumi.get(self, "remote_db_instance_id")

    @remote_db_instance_id.setter
    def remote_db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remote_db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[_builtins.str]:
        """
        The user name used to connect to the remote instance
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> pulumi.Input[_builtins.str]:
        """
        The user password used to connect to the remote instance
        """
        return pulumi.get(self, "user_password")

    @user_password.setter
    def user_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_password", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_name", value)


@pulumi.input_type
class _RemoteAdbDataSourceState:
    def __init__(__self__, *,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 local_database: Optional[pulumi.Input[_builtins.str]] = None,
                 local_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_user_password: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_adb_data_source_id: Optional[pulumi.Input[_builtins.int]] = None,
                 remote_database: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RemoteAdbDataSource resources.
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] local_database: The database of the local instance which connection data.
        :param pulumi.Input[_builtins.str] local_db_instance_id: The instanceId of the local instance which connection data.
        :param pulumi.Input[_builtins.str] manager_user_name: The Management user name of the local instance.
        :param pulumi.Input[_builtins.str] manager_user_password: Password of the Manager user of the local instance
        :param pulumi.Input[_builtins.int] remote_adb_data_source_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] remote_database: The database of the remote instance which provide data.
        :param pulumi.Input[_builtins.str] remote_db_instance_id: The instanceId of the remote instance which provide data.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] user_name: The user name used to connect to the remote instance
        :param pulumi.Input[_builtins.str] user_password: The user password used to connect to the remote instance
        """
        if data_source_name is not None:
            pulumi.set(__self__, "data_source_name", data_source_name)
        if local_database is not None:
            pulumi.set(__self__, "local_database", local_database)
        if local_db_instance_id is not None:
            pulumi.set(__self__, "local_db_instance_id", local_db_instance_id)
        if manager_user_name is not None:
            pulumi.set(__self__, "manager_user_name", manager_user_name)
        if manager_user_password is not None:
            pulumi.set(__self__, "manager_user_password", manager_user_password)
        if remote_adb_data_source_id is not None:
            pulumi.set(__self__, "remote_adb_data_source_id", remote_adb_data_source_id)
        if remote_database is not None:
            pulumi.set(__self__, "remote_database", remote_database)
        if remote_db_instance_id is not None:
            pulumi.set(__self__, "remote_db_instance_id", remote_db_instance_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if user_password is not None:
            pulumi.set(__self__, "user_password", user_password)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_name", value)

    @_builtins.property
    @pulumi.getter(name="localDatabase")
    def local_database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database of the local instance which connection data.
        """
        return pulumi.get(self, "local_database")

    @local_database.setter
    def local_database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_database", value)

    @_builtins.property
    @pulumi.getter(name="localDbInstanceId")
    def local_db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instanceId of the local instance which connection data.
        """
        return pulumi.get(self, "local_db_instance_id")

    @local_db_instance_id.setter
    def local_db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="managerUserName")
    def manager_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Management user name of the local instance.
        """
        return pulumi.get(self, "manager_user_name")

    @manager_user_name.setter
    def manager_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manager_user_name", value)

    @_builtins.property
    @pulumi.getter(name="managerUserPassword")
    def manager_user_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password of the Manager user of the local instance
        """
        return pulumi.get(self, "manager_user_password")

    @manager_user_password.setter
    def manager_user_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manager_user_password", value)

    @_builtins.property
    @pulumi.getter(name="remoteAdbDataSourceId")
    def remote_adb_data_source_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "remote_adb_data_source_id")

    @remote_adb_data_source_id.setter
    def remote_adb_data_source_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "remote_adb_data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="remoteDatabase")
    def remote_database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database of the remote instance which provide data.
        """
        return pulumi.get(self, "remote_database")

    @remote_database.setter
    def remote_database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_database", value)

    @_builtins.property
    @pulumi.getter(name="remoteDbInstanceId")
    def remote_db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instanceId of the remote instance which provide data.
        """
        return pulumi.get(self, "remote_db_instance_id")

    @remote_db_instance_id.setter
    def remote_db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_db_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user name used to connect to the remote instance
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user password used to connect to the remote instance
        """
        return pulumi.get(self, "user_password")

    @user_password.setter
    def user_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_password", value)


@pulumi.type_token("alicloud:gpdb/remoteAdbDataSource:RemoteAdbDataSource")
class RemoteAdbDataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 local_database: Optional[pulumi.Input[_builtins.str]] = None,
                 local_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_user_password: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_database: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a GPDB Remote ADB Data Source resource.

        RemoteADBDataSource is the data external table call method between greenplums, which will be used for data external table access between ADB-PG.

        For information about GPDB Remote ADB Data Source and how to use it, see [What is Remote ADB Data Source](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createremoteadbdatasource).

        > **NOTE:** Available since v1.227.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default4_mf0n_y = alicloud.vpc.Network("default4Mf0nY", cidr_block="192.168.0.0/16")
        defaultw_sa_vpf = alicloud.vpc.Switch("defaultwSAVpf",
            vpc_id=default4_mf0n_y.id,
            zone_id="cn-beijing-h",
            cidr_block="192.168.1.0/24")
        default_et_ez_mf = alicloud.gpdb.Instance("defaultEtEzMF",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=defaultw_sa_vpf.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default4_mf0n_y.id,
            db_instance_mode="StorageElastic",
            engine="gpdb")
        default_ey7t9t = alicloud.gpdb.Instance("defaultEY7t9t",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=defaultw_sa_vpf.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default4_mf0n_y.id,
            db_instance_mode="StorageElastic",
            engine="gpdb")
        default26qp_eo = alicloud.gpdb.Account("default26qpEo",
            account_description="example_001",
            db_instance_id=default_et_ez_mf.id,
            account_name="example_001",
            account_password="example_001")
        defaultw_xe_pof = alicloud.gpdb.Account("defaultwXePof",
            account_description="example_001",
            db_instance_id=default_ey7t9t.id,
            account_name="example_001",
            account_password="example_001")
        default_remote_adb_data_source = alicloud.gpdb.RemoteAdbDataSource("default",
            remote_database="example_001",
            manager_user_name="example_001",
            user_name="example_001",
            remote_db_instance_id=defaultw_xe_pof.db_instance_id,
            local_database="example_001",
            data_source_name="myexample",
            user_password="example_001",
            manager_user_password="example_001",
            local_db_instance_id=default_et_ez_mf.id)
        ```

        ## Import

        GPDB Remote ADB Data Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/remoteAdbDataSource:RemoteAdbDataSource example <local_db_instance_id>:<remote_adb_data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] local_database: The database of the local instance which connection data.
        :param pulumi.Input[_builtins.str] local_db_instance_id: The instanceId of the local instance which connection data.
        :param pulumi.Input[_builtins.str] manager_user_name: The Management user name of the local instance.
        :param pulumi.Input[_builtins.str] manager_user_password: Password of the Manager user of the local instance
        :param pulumi.Input[_builtins.str] remote_database: The database of the remote instance which provide data.
        :param pulumi.Input[_builtins.str] remote_db_instance_id: The instanceId of the remote instance which provide data.
        :param pulumi.Input[_builtins.str] user_name: The user name used to connect to the remote instance
        :param pulumi.Input[_builtins.str] user_password: The user password used to connect to the remote instance
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RemoteAdbDataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GPDB Remote ADB Data Source resource.

        RemoteADBDataSource is the data external table call method between greenplums, which will be used for data external table access between ADB-PG.

        For information about GPDB Remote ADB Data Source and how to use it, see [What is Remote ADB Data Source](https://www.alibabacloud.com/help/en/analyticdb/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createremoteadbdatasource).

        > **NOTE:** Available since v1.227.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default4_mf0n_y = alicloud.vpc.Network("default4Mf0nY", cidr_block="192.168.0.0/16")
        defaultw_sa_vpf = alicloud.vpc.Switch("defaultwSAVpf",
            vpc_id=default4_mf0n_y.id,
            zone_id="cn-beijing-h",
            cidr_block="192.168.1.0/24")
        default_et_ez_mf = alicloud.gpdb.Instance("defaultEtEzMF",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=defaultw_sa_vpf.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default4_mf0n_y.id,
            db_instance_mode="StorageElastic",
            engine="gpdb")
        default_ey7t9t = alicloud.gpdb.Instance("defaultEY7t9t",
            instance_spec="2C8G",
            description=name,
            seg_node_num=2,
            seg_storage_type="cloud_essd",
            instance_network_type="VPC",
            db_instance_category="Basic",
            payment_type="PayAsYouGo",
            ssl_enabled=0,
            engine_version="6.0",
            zone_id="cn-beijing-h",
            vswitch_id=defaultw_sa_vpf.id,
            storage_size=50,
            master_cu=4,
            vpc_id=default4_mf0n_y.id,
            db_instance_mode="StorageElastic",
            engine="gpdb")
        default26qp_eo = alicloud.gpdb.Account("default26qpEo",
            account_description="example_001",
            db_instance_id=default_et_ez_mf.id,
            account_name="example_001",
            account_password="example_001")
        defaultw_xe_pof = alicloud.gpdb.Account("defaultwXePof",
            account_description="example_001",
            db_instance_id=default_ey7t9t.id,
            account_name="example_001",
            account_password="example_001")
        default_remote_adb_data_source = alicloud.gpdb.RemoteAdbDataSource("default",
            remote_database="example_001",
            manager_user_name="example_001",
            user_name="example_001",
            remote_db_instance_id=defaultw_xe_pof.db_instance_id,
            local_database="example_001",
            data_source_name="myexample",
            user_password="example_001",
            manager_user_password="example_001",
            local_db_instance_id=default_et_ez_mf.id)
        ```

        ## Import

        GPDB Remote ADB Data Source can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/remoteAdbDataSource:RemoteAdbDataSource example <local_db_instance_id>:<remote_adb_data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param RemoteAdbDataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RemoteAdbDataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
                 local_database: Optional[pulumi.Input[_builtins.str]] = None,
                 local_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_user_password: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_database: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RemoteAdbDataSourceArgs.__new__(RemoteAdbDataSourceArgs)

            __props__.__dict__["data_source_name"] = data_source_name
            if local_database is None and not opts.urn:
                raise TypeError("Missing required property 'local_database'")
            __props__.__dict__["local_database"] = local_database
            if local_db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'local_db_instance_id'")
            __props__.__dict__["local_db_instance_id"] = local_db_instance_id
            if manager_user_name is None and not opts.urn:
                raise TypeError("Missing required property 'manager_user_name'")
            __props__.__dict__["manager_user_name"] = manager_user_name
            if manager_user_password is None and not opts.urn:
                raise TypeError("Missing required property 'manager_user_password'")
            __props__.__dict__["manager_user_password"] = None if manager_user_password is None else pulumi.Output.secret(manager_user_password)
            if remote_database is None and not opts.urn:
                raise TypeError("Missing required property 'remote_database'")
            __props__.__dict__["remote_database"] = remote_database
            if remote_db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'remote_db_instance_id'")
            __props__.__dict__["remote_db_instance_id"] = remote_db_instance_id
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            if user_password is None and not opts.urn:
                raise TypeError("Missing required property 'user_password'")
            __props__.__dict__["user_password"] = None if user_password is None else pulumi.Output.secret(user_password)
            __props__.__dict__["remote_adb_data_source_id"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["managerUserPassword", "userPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RemoteAdbDataSource, __self__).__init__(
            'alicloud:gpdb/remoteAdbDataSource:RemoteAdbDataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_source_name: Optional[pulumi.Input[_builtins.str]] = None,
            local_database: Optional[pulumi.Input[_builtins.str]] = None,
            local_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            manager_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            manager_user_password: Optional[pulumi.Input[_builtins.str]] = None,
            remote_adb_data_source_id: Optional[pulumi.Input[_builtins.int]] = None,
            remote_database: Optional[pulumi.Input[_builtins.str]] = None,
            remote_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None,
            user_password: Optional[pulumi.Input[_builtins.str]] = None) -> 'RemoteAdbDataSource':
        """
        Get an existing RemoteAdbDataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_source_name: Data Source Name
        :param pulumi.Input[_builtins.str] local_database: The database of the local instance which connection data.
        :param pulumi.Input[_builtins.str] local_db_instance_id: The instanceId of the local instance which connection data.
        :param pulumi.Input[_builtins.str] manager_user_name: The Management user name of the local instance.
        :param pulumi.Input[_builtins.str] manager_user_password: Password of the Manager user of the local instance
        :param pulumi.Input[_builtins.int] remote_adb_data_source_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] remote_database: The database of the remote instance which provide data.
        :param pulumi.Input[_builtins.str] remote_db_instance_id: The instanceId of the remote instance which provide data.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] user_name: The user name used to connect to the remote instance
        :param pulumi.Input[_builtins.str] user_password: The user password used to connect to the remote instance
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RemoteAdbDataSourceState.__new__(_RemoteAdbDataSourceState)

        __props__.__dict__["data_source_name"] = data_source_name
        __props__.__dict__["local_database"] = local_database
        __props__.__dict__["local_db_instance_id"] = local_db_instance_id
        __props__.__dict__["manager_user_name"] = manager_user_name
        __props__.__dict__["manager_user_password"] = manager_user_password
        __props__.__dict__["remote_adb_data_source_id"] = remote_adb_data_source_id
        __props__.__dict__["remote_database"] = remote_database
        __props__.__dict__["remote_db_instance_id"] = remote_db_instance_id
        __props__.__dict__["status"] = status
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["user_password"] = user_password
        return RemoteAdbDataSource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Data Source Name
        """
        return pulumi.get(self, "data_source_name")

    @_builtins.property
    @pulumi.getter(name="localDatabase")
    def local_database(self) -> pulumi.Output[_builtins.str]:
        """
        The database of the local instance which connection data.
        """
        return pulumi.get(self, "local_database")

    @_builtins.property
    @pulumi.getter(name="localDbInstanceId")
    def local_db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instanceId of the local instance which connection data.
        """
        return pulumi.get(self, "local_db_instance_id")

    @_builtins.property
    @pulumi.getter(name="managerUserName")
    def manager_user_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Management user name of the local instance.
        """
        return pulumi.get(self, "manager_user_name")

    @_builtins.property
    @pulumi.getter(name="managerUserPassword")
    def manager_user_password(self) -> pulumi.Output[_builtins.str]:
        """
        Password of the Manager user of the local instance
        """
        return pulumi.get(self, "manager_user_password")

    @_builtins.property
    @pulumi.getter(name="remoteAdbDataSourceId")
    def remote_adb_data_source_id(self) -> pulumi.Output[_builtins.int]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "remote_adb_data_source_id")

    @_builtins.property
    @pulumi.getter(name="remoteDatabase")
    def remote_database(self) -> pulumi.Output[_builtins.str]:
        """
        The database of the remote instance which provide data.
        """
        return pulumi.get(self, "remote_database")

    @_builtins.property
    @pulumi.getter(name="remoteDbInstanceId")
    def remote_db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instanceId of the remote instance which provide data.
        """
        return pulumi.get(self, "remote_db_instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user name used to connect to the remote instance
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> pulumi.Output[_builtins.str]:
        """
        The user password used to connect to the remote instance
        """
        return pulumi.get(self, "user_password")

