# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'LoadBalancerZoneMappingArgs',
    'LoadBalancerZoneMappingArgsDict',
    'LoadBalancerZoneMappingLoadBalancerAddressArgs',
    'LoadBalancerZoneMappingLoadBalancerAddressArgsDict',
    'ServerGroupConnectionDrainConfigArgs',
    'ServerGroupConnectionDrainConfigArgsDict',
    'ServerGroupHealthCheckConfigArgs',
    'ServerGroupHealthCheckConfigArgsDict',
    'ServerGroupServerArgs',
    'ServerGroupServerArgsDict',
]

MYPY = False

if not MYPY:
    class LoadBalancerZoneMappingArgsDict(TypedDict):
        vswitch_id: pulumi.Input[_builtins.str]
        """
        The ID of the vSwitch in the zone. You can specify only one vSwitch (subnet) in each zone of a GWLB instance.
        """
        zone_id: pulumi.Input[_builtins.str]
        """
        The zone ID. You can call the DescribeZones operation to query the most recent zone list.
        """
        load_balancer_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingLoadBalancerAddressArgsDict']]]]
        """
        The information about the IP addresses used by the GWLB instance.
        """
elif False:
    LoadBalancerZoneMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerZoneMappingArgs:
    def __init__(__self__, *,
                 vswitch_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 load_balancer_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingLoadBalancerAddressArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch in the zone. You can specify only one vSwitch (subnet) in each zone of a GWLB instance.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID. You can call the DescribeZones operation to query the most recent zone list.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingLoadBalancerAddressArgs']]] load_balancer_addresses: The information about the IP addresses used by the GWLB instance.
        """
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if load_balancer_addresses is not None:
            pulumi.set(__self__, "load_balancer_addresses", load_balancer_addresses)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the vSwitch in the zone. You can specify only one vSwitch (subnet) in each zone of a GWLB instance.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The zone ID. You can call the DescribeZones operation to query the most recent zone list.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerAddresses")
    def load_balancer_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingLoadBalancerAddressArgs']]]]:
        """
        The information about the IP addresses used by the GWLB instance.
        """
        return pulumi.get(self, "load_balancer_addresses")

    @load_balancer_addresses.setter
    def load_balancer_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingLoadBalancerAddressArgs']]]]):
        pulumi.set(self, "load_balancer_addresses", value)


if not MYPY:
    class LoadBalancerZoneMappingLoadBalancerAddressArgsDict(TypedDict):
        eni_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the elastic network interface (ENI) used by the GWLB instance.
        """
        private_ipv4_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The private IPv4 address.
        """
elif False:
    LoadBalancerZoneMappingLoadBalancerAddressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerZoneMappingLoadBalancerAddressArgs:
    def __init__(__self__, *,
                 eni_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] eni_id: The ID of the elastic network interface (ENI) used by the GWLB instance.
        :param pulumi.Input[_builtins.str] private_ipv4_address: The private IPv4 address.
        """
        if eni_id is not None:
            pulumi.set(__self__, "eni_id", eni_id)
        if private_ipv4_address is not None:
            pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)

    @_builtins.property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the elastic network interface (ENI) used by the GWLB instance.
        """
        return pulumi.get(self, "eni_id")

    @eni_id.setter
    def eni_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eni_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "private_ipv4_address")

    @private_ipv4_address.setter
    def private_ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ipv4_address", value)


if not MYPY:
    class ServerGroupConnectionDrainConfigArgsDict(TypedDict):
        connection_drain_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates whether connection draining is enabled. Valid values:
        """
        connection_drain_timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        The timeout period of connection draining.

        Unit: seconds

        Valid values: `1` to `3600`.

        Default value: `300`.
        """
elif False:
    ServerGroupConnectionDrainConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerGroupConnectionDrainConfigArgs:
    def __init__(__self__, *,
                 connection_drain_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_drain_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.bool] connection_drain_enabled: Indicates whether connection draining is enabled. Valid values:
        :param pulumi.Input[_builtins.int] connection_drain_timeout: The timeout period of connection draining.
               
               Unit: seconds
               
               Valid values: `1` to `3600`.
               
               Default value: `300`.
        """
        if connection_drain_enabled is not None:
            pulumi.set(__self__, "connection_drain_enabled", connection_drain_enabled)
        if connection_drain_timeout is not None:
            pulumi.set(__self__, "connection_drain_timeout", connection_drain_timeout)

    @_builtins.property
    @pulumi.getter(name="connectionDrainEnabled")
    def connection_drain_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether connection draining is enabled. Valid values:
        """
        return pulumi.get(self, "connection_drain_enabled")

    @connection_drain_enabled.setter
    def connection_drain_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "connection_drain_enabled", value)

    @_builtins.property
    @pulumi.getter(name="connectionDrainTimeout")
    def connection_drain_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period of connection draining.

        Unit: seconds

        Valid values: `1` to `3600`.

        Default value: `300`.
        """
        return pulumi.get(self, "connection_drain_timeout")

    @connection_drain_timeout.setter
    def connection_drain_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connection_drain_timeout", value)


if not MYPY:
    class ServerGroupHealthCheckConfigArgsDict(TypedDict):
        health_check_connect_port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The backend server port that is used for health checks.

        Valid values: `1` to `65535`.

        Default value: `80`.
        """
        health_check_connect_timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum timeout period of a health check response.

        Unit: seconds

        Valid values: `1` to `300`.

        Default value: `5`.
        """
        health_check_domain: NotRequired[pulumi.Input[_builtins.str]]
        """
        The domain name that you want to use for health checks. Valid values:

        *   **$SERVER_IP** (default): the private IP address of a backend server.
        """
        health_check_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether to enable the health check feature. Valid values:
        """
        health_check_http_codes: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The HTTP status codes that the system returns for health checks.
        """
        health_check_interval: NotRequired[pulumi.Input[_builtins.int]]
        """
        The interval at which health checks are performed.

        Unit: seconds

        Valid values: `1` to `50`.

        Default value: `10`.
        """
        health_check_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URL that is used for health checks.

        The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: \\_ ; ~ ! ( ) \\* \\[ ] @ $ ^ : ' , + =

        The URL must start with a forward slash (/).

        > **NOTE:**  This parameter takes effect only if you set `HealthCheckProtocol` to `HTTP`.
        """
        health_check_protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        The protocol that is used for health checks. Valid values:

        - `TCP`: TCP health checks send TCP SYN packets to a backend server to check whether the port of the backend server is reachable.
        - `HTTP`: HTTP health checks simulate a process that uses a web browser to access resources by sending HEAD or GET requests to an instance. These requests are used to check whether the instance is healthy.
        """
        healthy_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. In this case, the health status changes from `fail` to `success`.

        Valid values: `2` to `10`.

        Default value: `2`.
        """
        unhealthy_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. In this case, the health status changes from `success` to `fail`.

        Valid values: `2` to `10`.

        Default value: `2`.
        """
elif False:
    ServerGroupHealthCheckConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerGroupHealthCheckConfigArgs:
    def __init__(__self__, *,
                 health_check_connect_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_connect_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_http_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_path: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] health_check_connect_port: The backend server port that is used for health checks.
               
               Valid values: `1` to `65535`.
               
               Default value: `80`.
        :param pulumi.Input[_builtins.int] health_check_connect_timeout: The maximum timeout period of a health check response.
               
               Unit: seconds
               
               Valid values: `1` to `300`.
               
               Default value: `5`.
        :param pulumi.Input[_builtins.str] health_check_domain: The domain name that you want to use for health checks. Valid values:
               
               *   **$SERVER_IP** (default): the private IP address of a backend server.
        :param pulumi.Input[_builtins.bool] health_check_enabled: Specifies whether to enable the health check feature. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] health_check_http_codes: The HTTP status codes that the system returns for health checks.
        :param pulumi.Input[_builtins.int] health_check_interval: The interval at which health checks are performed.
               
               Unit: seconds
               
               Valid values: `1` to `50`.
               
               Default value: `10`.
        :param pulumi.Input[_builtins.str] health_check_path: The URL that is used for health checks.
               
               The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: \\_ ; ~ ! ( ) \\* \\[ ] @ $ ^ : ' , + =
               
               The URL must start with a forward slash (/).
               
               > **NOTE:**  This parameter takes effect only if you set `HealthCheckProtocol` to `HTTP`.
        :param pulumi.Input[_builtins.str] health_check_protocol: The protocol that is used for health checks. Valid values:
               
               - `TCP`: TCP health checks send TCP SYN packets to a backend server to check whether the port of the backend server is reachable.
               - `HTTP`: HTTP health checks simulate a process that uses a web browser to access resources by sending HEAD or GET requests to an instance. These requests are used to check whether the instance is healthy.
        :param pulumi.Input[_builtins.int] healthy_threshold: The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. In this case, the health status changes from `fail` to `success`.
               
               Valid values: `2` to `10`.
               
               Default value: `2`.
        :param pulumi.Input[_builtins.int] unhealthy_threshold: The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. In this case, the health status changes from `success` to `fail`.
               
               Valid values: `2` to `10`.
               
               Default value: `2`.
        """
        if health_check_connect_port is not None:
            pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        if health_check_connect_timeout is not None:
            pulumi.set(__self__, "health_check_connect_timeout", health_check_connect_timeout)
        if health_check_domain is not None:
            pulumi.set(__self__, "health_check_domain", health_check_domain)
        if health_check_enabled is not None:
            pulumi.set(__self__, "health_check_enabled", health_check_enabled)
        if health_check_http_codes is not None:
            pulumi.set(__self__, "health_check_http_codes", health_check_http_codes)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The backend server port that is used for health checks.

        Valid values: `1` to `65535`.

        Default value: `80`.
        """
        return pulumi.get(self, "health_check_connect_port")

    @health_check_connect_port.setter
    def health_check_connect_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_connect_port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectTimeout")
    def health_check_connect_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum timeout period of a health check response.

        Unit: seconds

        Valid values: `1` to `300`.

        Default value: `5`.
        """
        return pulumi.get(self, "health_check_connect_timeout")

    @health_check_connect_timeout.setter
    def health_check_connect_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_connect_timeout", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name that you want to use for health checks. Valid values:

        *   **$SERVER_IP** (default): the private IP address of a backend server.
        """
        return pulumi.get(self, "health_check_domain")

    @health_check_domain.setter
    def health_check_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_domain", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckEnabled")
    def health_check_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the health check feature. Valid values:
        """
        return pulumi.get(self, "health_check_enabled")

    @health_check_enabled.setter
    def health_check_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "health_check_enabled", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpCodes")
    def health_check_http_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The HTTP status codes that the system returns for health checks.
        """
        return pulumi.get(self, "health_check_http_codes")

    @health_check_http_codes.setter
    def health_check_http_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "health_check_http_codes", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The interval at which health checks are performed.

        Unit: seconds

        Valid values: `1` to `50`.

        Default value: `10`.
        """
        return pulumi.get(self, "health_check_interval")

    @health_check_interval.setter
    def health_check_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_interval", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL that is used for health checks.

        The URL must be 1 to 80 characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.), percent signs (%), question marks (?), number signs (#), and ampersands (&). The URL can also contain the following extended characters: \\_ ; ~ ! ( ) \\* \\[ ] @ $ ^ : ' , + =

        The URL must start with a forward slash (/).

        > **NOTE:**  This parameter takes effect only if you set `HealthCheckProtocol` to `HTTP`.
        """
        return pulumi.get(self, "health_check_path")

    @health_check_path.setter
    def health_check_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_path", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol that is used for health checks. Valid values:

        - `TCP`: TCP health checks send TCP SYN packets to a backend server to check whether the port of the backend server is reachable.
        - `HTTP`: HTTP health checks simulate a process that uses a web browser to access resources by sending HEAD or GET requests to an instance. These requests are used to check whether the instance is healthy.
        """
        return pulumi.get(self, "health_check_protocol")

    @health_check_protocol.setter
    def health_check_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_protocol", value)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of times that an unhealthy backend server must consecutively pass health checks before it is declared healthy. In this case, the health status changes from `fail` to `success`.

        Valid values: `2` to `10`.

        Default value: `2`.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "healthy_threshold", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of times that a healthy backend server must consecutively fail health checks before it is declared unhealthy. In this case, the health status changes from `success` to `fail`.

        Valid values: `2` to `10`.

        Default value: `2`.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "unhealthy_threshold", value)


if not MYPY:
    class ServerGroupServerArgsDict(TypedDict):
        server_id: pulumi.Input[_builtins.str]
        """
        The backend server ID.

        - If the server group is of the `Instance` type, set this parameter to the IDs of servers of the `Ecs`, `Eni`, or `Eci` type.
        - If the server group is of the `Ip` type, set ServerId to IP addresses.
        """
        server_type: pulumi.Input[_builtins.str]
        """
        The type of the backend server. Valid values:

        - `Ecs`: Elastic Compute Service (ECS) instance
        - `Eni`: elastic network interface (ENI)
        - `Eci`: elastic container instance
        - `Ip`: IP address
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Optional, Computed, Int) The port that is used by the backend server.
        """
        server_group_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The server group ID.
        """
        server_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP address of the backend server.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the status of the backend server.
        """
elif False:
    ServerGroupServerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerGroupServerArgs:
    def __init__(__self__, *,
                 server_id: pulumi.Input[_builtins.str],
                 server_type: pulumi.Input[_builtins.str],
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] server_id: The backend server ID.
               
               - If the server group is of the `Instance` type, set this parameter to the IDs of servers of the `Ecs`, `Eni`, or `Eci` type.
               - If the server group is of the `Ip` type, set ServerId to IP addresses.
        :param pulumi.Input[_builtins.str] server_type: The type of the backend server. Valid values:
               
               - `Ecs`: Elastic Compute Service (ECS) instance
               - `Eni`: elastic network interface (ENI)
               - `Eci`: elastic container instance
               - `Ip`: IP address
        :param pulumi.Input[_builtins.int] port: (Optional, Computed, Int) The port that is used by the backend server.
        :param pulumi.Input[_builtins.str] server_group_id: The server group ID.
        :param pulumi.Input[_builtins.str] server_ip: The IP address of the backend server.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the backend server.
        """
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "server_type", server_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)
        if server_ip is not None:
            pulumi.set(__self__, "server_ip", server_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The backend server ID.

        - If the server group is of the `Instance` type, set this parameter to the IDs of servers of the `Ecs`, `Eni`, or `Eci` type.
        - If the server group is of the `Ip` type, set ServerId to IP addresses.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="serverType")
    def server_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the backend server. Valid values:

        - `Ecs`: Elastic Compute Service (ECS) instance
        - `Eni`: elastic network interface (ENI)
        - `Eci`: elastic container instance
        - `Ip`: IP address
        """
        return pulumi.get(self, "server_type")

    @server_type.setter
    def server_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_type", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Optional, Computed, Int) The port that is used by the backend server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server group ID.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serverIp")
    def server_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the backend server.
        """
        return pulumi.get(self, "server_ip")

    @server_ip.setter
    def server_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_ip", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the status of the backend server.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


