# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 load_balancer_id: pulumi.Input[_builtins.str],
                 server_group_id: pulumi.Input[_builtins.str],
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[_builtins.str] load_balancer_id: The GWLB instance ID.
        :param pulumi.Input[_builtins.str] server_group_id: The server group ID.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.str] listener_description: The description of the listener.
               
               The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags. You can specify at most 20 tags in each call.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "server_group_id", server_group_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if listener_description is not None:
            pulumi.set(__self__, "listener_description", listener_description)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The GWLB instance ID.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The server group ID.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_group_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the listener.

        The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        """
        return pulumi.get(self, "listener_description")

    @listener_description.setter
    def listener_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_description", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags. You can specify at most 20 tags in each call.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.str] listener_description: The description of the listener.
               
               The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        :param pulumi.Input[_builtins.str] load_balancer_id: The GWLB instance ID.
        :param pulumi.Input[_builtins.str] region_id: The region ID.
        :param pulumi.Input[_builtins.str] server_group_id: The server group ID.
        :param pulumi.Input[_builtins.str] status: The status of the listener.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags. You can specify at most 20 tags in each call.
        """
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if listener_description is not None:
            pulumi.set(__self__, "listener_description", listener_description)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the listener.

        The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        """
        return pulumi.get(self, "listener_description")

    @listener_description.setter
    def listener_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_description", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GWLB instance ID.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server group ID.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the listener.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags. You can specify at most 20 tags in each call.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:gwlb/listener:Listener")
class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a GWLB Listener resource.

        For information about GWLB Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/slb/gateway-based-load-balancing-gwlb/developer-reference/api-gwlb-2024-04-15-createlistener).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        zone_id1 = config.get("zoneId1")
        if zone_id1 is None:
            zone_id1 = "cn-wulanchabu-b"
        default = alicloud.resourcemanager.get_resource_groups()
        default_network = alicloud.vpc.Network("default",
            cidr_block="10.0.0.0/8",
            vpc_name=name)
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            zone_id=zone_id1,
            cidr_block="10.0.0.0/24",
            vswitch_name=std.format(input="%s1",
                args=[name]).result)
        default_load_balancer = alicloud.gwlb.LoadBalancer("default",
            vpc_id=default_network.id,
            load_balancer_name=std.format(input="%s3",
                args=[name]).result,
            zone_mappings=[{
                "vswitch_id": default_switch.id,
                "zone_id": zone_id1,
            }],
            address_ip_version="Ipv4")
        default_server_group = alicloud.gwlb.ServerGroup("default",
            protocol="GENEVE",
            server_group_name="tfaccgwlb62413",
            server_group_type="Ip",
            servers=[
                {
                    "server_id": "10.0.0.1",
                    "server_ip": "10.0.0.1",
                    "server_type": "Ip",
                },
                {
                    "server_id": "10.0.0.2",
                    "server_ip": "10.0.0.2",
                    "server_type": "Ip",
                },
                {
                    "server_id": "10.0.0.3",
                    "server_ip": "10.0.0.3",
                    "server_type": "Ip",
                },
            ],
            connection_drain_config={
                "connection_drain_enabled": True,
                "connection_drain_timeout": 1,
            },
            resource_group_id=default.ids[0],
            dry_run=False,
            health_check_config={
                "health_check_protocol": "HTTP",
                "health_check_http_codes": [
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
                "health_check_interval": 10,
                "health_check_path": "/health-check",
                "unhealthy_threshold": 2,
                "health_check_connect_port": 80,
                "health_check_connect_timeout": 5,
                "health_check_domain": "www.domain.com",
                "health_check_enabled": True,
                "healthy_threshold": 2,
            },
            vpc_id=default_network.id,
            scheduler="5TCH")
        default_listener = alicloud.gwlb.Listener("default",
            listener_description="example-tf-lsn",
            server_group_id=default_server_group.id,
            load_balancer_id=default_load_balancer.id)
        ```

        ## Import

        GWLB Listener can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gwlb/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.str] listener_description: The description of the listener.
               
               The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        :param pulumi.Input[_builtins.str] load_balancer_id: The GWLB instance ID.
        :param pulumi.Input[_builtins.str] server_group_id: The server group ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags. You can specify at most 20 tags in each call.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GWLB Listener resource.

        For information about GWLB Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/slb/gateway-based-load-balancing-gwlb/developer-reference/api-gwlb-2024-04-15-createlistener).

        > **NOTE:** Available since v1.234.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        zone_id1 = config.get("zoneId1")
        if zone_id1 is None:
            zone_id1 = "cn-wulanchabu-b"
        default = alicloud.resourcemanager.get_resource_groups()
        default_network = alicloud.vpc.Network("default",
            cidr_block="10.0.0.0/8",
            vpc_name=name)
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            zone_id=zone_id1,
            cidr_block="10.0.0.0/24",
            vswitch_name=std.format(input="%s1",
                args=[name]).result)
        default_load_balancer = alicloud.gwlb.LoadBalancer("default",
            vpc_id=default_network.id,
            load_balancer_name=std.format(input="%s3",
                args=[name]).result,
            zone_mappings=[{
                "vswitch_id": default_switch.id,
                "zone_id": zone_id1,
            }],
            address_ip_version="Ipv4")
        default_server_group = alicloud.gwlb.ServerGroup("default",
            protocol="GENEVE",
            server_group_name="tfaccgwlb62413",
            server_group_type="Ip",
            servers=[
                {
                    "server_id": "10.0.0.1",
                    "server_ip": "10.0.0.1",
                    "server_type": "Ip",
                },
                {
                    "server_id": "10.0.0.2",
                    "server_ip": "10.0.0.2",
                    "server_type": "Ip",
                },
                {
                    "server_id": "10.0.0.3",
                    "server_ip": "10.0.0.3",
                    "server_type": "Ip",
                },
            ],
            connection_drain_config={
                "connection_drain_enabled": True,
                "connection_drain_timeout": 1,
            },
            resource_group_id=default.ids[0],
            dry_run=False,
            health_check_config={
                "health_check_protocol": "HTTP",
                "health_check_http_codes": [
                    "http_2xx",
                    "http_3xx",
                    "http_4xx",
                ],
                "health_check_interval": 10,
                "health_check_path": "/health-check",
                "unhealthy_threshold": 2,
                "health_check_connect_port": 80,
                "health_check_connect_timeout": 5,
                "health_check_domain": "www.domain.com",
                "health_check_enabled": True,
                "healthy_threshold": 2,
            },
            vpc_id=default_network.id,
            scheduler="5TCH")
        default_listener = alicloud.gwlb.Listener("default",
            listener_description="example-tf-lsn",
            server_group_id=default_server_group.id,
            load_balancer_id=default_load_balancer.id)
        ```

        ## Import

        GWLB Listener can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gwlb/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_description: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["listener_description"] = listener_description
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            if server_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_group_id'")
            __props__.__dict__["server_group_id"] = server_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(Listener, __self__).__init__(
            'alicloud:gwlb/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            listener_description: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.str] listener_description: The description of the listener.
               
               The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        :param pulumi.Input[_builtins.str] load_balancer_id: The GWLB instance ID.
        :param pulumi.Input[_builtins.str] region_id: The region ID.
        :param pulumi.Input[_builtins.str] server_group_id: The server group ID.
        :param pulumi.Input[_builtins.str] status: The status of the listener.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags. You can specify at most 20 tags in each call.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["listener_description"] = listener_description
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["server_group_id"] = server_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Listener(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to perform a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="listenerDescription")
    def listener_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the listener.

        The description must be 2 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\\_), and hyphens (-).
        """
        return pulumi.get(self, "listener_description")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The GWLB instance ID.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The server group ID.
        """
        return pulumi.get(self, "server_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the listener.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags. You can specify at most 20 tags in each call.
        """
        return pulumi.get(self, "tags")

