# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyBindingArgs', 'PolicyBinding']

@pulumi.input_type
class PolicyBindingArgs:
    def __init__(__self__, *,
                 advanced_options: Optional[pulumi.Input['PolicyBindingAdvancedOptionsArgs']] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_binding_description: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 speed_limit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PolicyBinding resource.
        :param pulumi.Input['PolicyBindingAdvancedOptionsArgs'] advanced_options: Backup Advanced Options See `advanced_options` below.
        :param pulumi.Input[_builtins.str] cross_account_role_name: Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the name of the cross-account authorization role of the data source, and the management account uses this role to access the data source.
        :param pulumi.Input[_builtins.str] cross_account_type: Cross-account type, supported
        :param pulumi.Input[_builtins.int] cross_account_user_id: Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the ID of the actual account to which the data source belongs.
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.bool] disabled: Whether the policy is effective for the data source.
               - true: Pause
               - false: not paused
        :param pulumi.Input[_builtins.str] exclude: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates a file type that does not need to be backed up. All files of this type are not backed up. A maximum of 255 characters is supported.
        :param pulumi.Input[_builtins.str] include: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates the file types to be backed up, and all files of these types are backed up. A maximum of 255 characters is supported.
        :param pulumi.Input[_builtins.str] policy_binding_description: Resource Description
        :param pulumi.Input[_builtins.str] policy_id: The policy ID.
        :param pulumi.Input[_builtins.str] source: When SourceType is OSS, a prefix is specified to be backed up. If it is not specified, the entire root directory of the Bucket is backed up.
        :param pulumi.Input[_builtins.str] source_type: Data source type, value range:
               - `UDM_ECS`: indicates the ECS instance backup.
               - `OSS`: indicates an OSS backup.
               - `NAS`: indicates an Alibaba Cloud NAS Backup. When you bind a file system to a policy, Cloud Backup automatically creates a mount point for the file system. If you no longer need the mount point, delete it manually.
               - `ECS_FILE`: indicates that the ECS file is backed up.
               - `File`: indicates a local File backup.
               - `OTS`: (Available since v1.260.1) indicates the Tablestore backup.
        :param pulumi.Input[_builtins.str] speed_limit: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates backup flow control. The format is {start}{end}{bandwidth}. Multiple flow control configurations use partitioning, and no overlap in configuration time is allowed. start: start hour. end: end of hour. bandwidth: limit rate, in KB/s.
        """
        if advanced_options is not None:
            pulumi.set(__self__, "advanced_options", advanced_options)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if policy_binding_description is not None:
            pulumi.set(__self__, "policy_binding_description", policy_binding_description)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if speed_limit is not None:
            pulumi.set(__self__, "speed_limit", speed_limit)

    @_builtins.property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> Optional[pulumi.Input['PolicyBindingAdvancedOptionsArgs']]:
        """
        Backup Advanced Options See `advanced_options` below.
        """
        return pulumi.get(self, "advanced_options")

    @advanced_options.setter
    def advanced_options(self, value: Optional[pulumi.Input['PolicyBindingAdvancedOptionsArgs']]):
        pulumi.set(self, "advanced_options", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the name of the cross-account authorization role of the data source, and the management account uses this role to access the data source.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cross-account type, supported
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the ID of the actual account to which the data source belongs.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the policy is effective for the data source.
        - true: Pause
        - false: not paused
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def exclude(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates a file type that does not need to be backed up. All files of this type are not backed up. A maximum of 255 characters is supported.
        """
        return pulumi.get(self, "exclude")

    @exclude.setter
    def exclude(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude", value)

    @_builtins.property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates the file types to be backed up, and all files of these types are backed up. A maximum of 255 characters is supported.
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include", value)

    @_builtins.property
    @pulumi.getter(name="policyBindingDescription")
    def policy_binding_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Description
        """
        return pulumi.get(self, "policy_binding_description")

    @policy_binding_description.setter
    def policy_binding_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_binding_description", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When SourceType is OSS, a prefix is specified to be backed up. If it is not specified, the entire root directory of the Bucket is backed up.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data source type, value range:
        - `UDM_ECS`: indicates the ECS instance backup.
        - `OSS`: indicates an OSS backup.
        - `NAS`: indicates an Alibaba Cloud NAS Backup. When you bind a file system to a policy, Cloud Backup automatically creates a mount point for the file system. If you no longer need the mount point, delete it manually.
        - `ECS_FILE`: indicates that the ECS file is backed up.
        - `File`: indicates a local File backup.
        - `OTS`: (Available since v1.260.1) indicates the Tablestore backup.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="speedLimit")
    def speed_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates backup flow control. The format is {start}{end}{bandwidth}. Multiple flow control configurations use partitioning, and no overlap in configuration time is allowed. start: start hour. end: end of hour. bandwidth: limit rate, in KB/s.
        """
        return pulumi.get(self, "speed_limit")

    @speed_limit.setter
    def speed_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "speed_limit", value)


@pulumi.input_type
class _PolicyBindingState:
    def __init__(__self__, *,
                 advanced_options: Optional[pulumi.Input['PolicyBindingAdvancedOptionsArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_binding_description: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 speed_limit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PolicyBinding resources.
        :param pulumi.Input['PolicyBindingAdvancedOptionsArgs'] advanced_options: Backup Advanced Options See `advanced_options` below.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] cross_account_role_name: Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the name of the cross-account authorization role of the data source, and the management account uses this role to access the data source.
        :param pulumi.Input[_builtins.str] cross_account_type: Cross-account type, supported
        :param pulumi.Input[_builtins.int] cross_account_user_id: Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the ID of the actual account to which the data source belongs.
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.bool] disabled: Whether the policy is effective for the data source.
               - true: Pause
               - false: not paused
        :param pulumi.Input[_builtins.str] exclude: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates a file type that does not need to be backed up. All files of this type are not backed up. A maximum of 255 characters is supported.
        :param pulumi.Input[_builtins.str] include: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates the file types to be backed up, and all files of these types are backed up. A maximum of 255 characters is supported.
        :param pulumi.Input[_builtins.str] policy_binding_description: Resource Description
        :param pulumi.Input[_builtins.str] policy_id: The policy ID.
        :param pulumi.Input[_builtins.str] source: When SourceType is OSS, a prefix is specified to be backed up. If it is not specified, the entire root directory of the Bucket is backed up.
        :param pulumi.Input[_builtins.str] source_type: Data source type, value range:
               - `UDM_ECS`: indicates the ECS instance backup.
               - `OSS`: indicates an OSS backup.
               - `NAS`: indicates an Alibaba Cloud NAS Backup. When you bind a file system to a policy, Cloud Backup automatically creates a mount point for the file system. If you no longer need the mount point, delete it manually.
               - `ECS_FILE`: indicates that the ECS file is backed up.
               - `File`: indicates a local File backup.
               - `OTS`: (Available since v1.260.1) indicates the Tablestore backup.
        :param pulumi.Input[_builtins.str] speed_limit: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates backup flow control. The format is {start}{end}{bandwidth}. Multiple flow control configurations use partitioning, and no overlap in configuration time is allowed. start: start hour. end: end of hour. bandwidth: limit rate, in KB/s.
        """
        if advanced_options is not None:
            pulumi.set(__self__, "advanced_options", advanced_options)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if exclude is not None:
            pulumi.set(__self__, "exclude", exclude)
        if include is not None:
            pulumi.set(__self__, "include", include)
        if policy_binding_description is not None:
            pulumi.set(__self__, "policy_binding_description", policy_binding_description)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if speed_limit is not None:
            pulumi.set(__self__, "speed_limit", speed_limit)

    @_builtins.property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> Optional[pulumi.Input['PolicyBindingAdvancedOptionsArgs']]:
        """
        Backup Advanced Options See `advanced_options` below.
        """
        return pulumi.get(self, "advanced_options")

    @advanced_options.setter
    def advanced_options(self, value: Optional[pulumi.Input['PolicyBindingAdvancedOptionsArgs']]):
        pulumi.set(self, "advanced_options", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the name of the cross-account authorization role of the data source, and the management account uses this role to access the data source.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cross-account type, supported
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the ID of the actual account to which the data source belongs.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the policy is effective for the data source.
        - true: Pause
        - false: not paused
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def exclude(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates a file type that does not need to be backed up. All files of this type are not backed up. A maximum of 255 characters is supported.
        """
        return pulumi.get(self, "exclude")

    @exclude.setter
    def exclude(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude", value)

    @_builtins.property
    @pulumi.getter
    def include(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates the file types to be backed up, and all files of these types are backed up. A maximum of 255 characters is supported.
        """
        return pulumi.get(self, "include")

    @include.setter
    def include(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "include", value)

    @_builtins.property
    @pulumi.getter(name="policyBindingDescription")
    def policy_binding_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Description
        """
        return pulumi.get(self, "policy_binding_description")

    @policy_binding_description.setter
    def policy_binding_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_binding_description", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy ID.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When SourceType is OSS, a prefix is specified to be backed up. If it is not specified, the entire root directory of the Bucket is backed up.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data source type, value range:
        - `UDM_ECS`: indicates the ECS instance backup.
        - `OSS`: indicates an OSS backup.
        - `NAS`: indicates an Alibaba Cloud NAS Backup. When you bind a file system to a policy, Cloud Backup automatically creates a mount point for the file system. If you no longer need the mount point, delete it manually.
        - `ECS_FILE`: indicates that the ECS file is backed up.
        - `File`: indicates a local File backup.
        - `OTS`: (Available since v1.260.1) indicates the Tablestore backup.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="speedLimit")
    def speed_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates backup flow control. The format is {start}{end}{bandwidth}. Multiple flow control configurations use partitioning, and no overlap in configuration time is allowed. start: start hour. end: end of hour. bandwidth: limit rate, in KB/s.
        """
        return pulumi.get(self, "speed_limit")

    @speed_limit.setter
    def speed_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "speed_limit", value)


@pulumi.type_token("alicloud:hbr/policyBinding:PolicyBinding")
class PolicyBinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_options: Optional[pulumi.Input[Union['PolicyBindingAdvancedOptionsArgs', 'PolicyBindingAdvancedOptionsArgsDict']]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_binding_description: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a HBR Policy Binding resource.

        For information about HBR Policy Binding and how to use it, see [What is Policy Binding](https://www.alibabacloud.com/help/en/cloud-backup/developer-reference/api-hbr-2017-09-08-createpolicybindings).

        > **NOTE:** Available since v1.221.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            max=99999,
            min=10000)
        defaultyk84_hc = alicloud.hbr.Vault("defaultyk84Hc",
            vault_type="STANDARD",
            vault_name=f"example-value-{default['result']}")
        defaultoq_wv_hq = alicloud.hbr.Policy("defaultoqWvHQ",
            policy_name=f"example-value-{default['result']}",
            rules=[{
                "rule_type": "BACKUP",
                "backup_type": "COMPLETE",
                "schedule": "I|1631685600|P1D",
                "retention": 7,
                "archive_days": 0,
                "vault_id": defaultyk84_hc.id,
            }],
            policy_description="policy example")
        default_ktt2_xy = alicloud.oss.Bucket("defaultKtt2XY",
            storage_class="Standard",
            bucket=f"example-value-{default['result']}")
        default_policy_binding = alicloud.hbr.PolicyBinding("default",
            source_type="OSS",
            disabled=False,
            policy_id=defaultoq_wv_hq.id,
            data_source_id=default_ktt2_xy.bucket,
            policy_binding_description="policy binding example (update)",
            source="prefix-example-update/")
        ```

        ## Import

        HBR Policy Binding can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/policyBinding:PolicyBinding example <policy_id>:<source_type>:<data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PolicyBindingAdvancedOptionsArgs', 'PolicyBindingAdvancedOptionsArgsDict']] advanced_options: Backup Advanced Options See `advanced_options` below.
        :param pulumi.Input[_builtins.str] cross_account_role_name: Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the name of the cross-account authorization role of the data source, and the management account uses this role to access the data source.
        :param pulumi.Input[_builtins.str] cross_account_type: Cross-account type, supported
        :param pulumi.Input[_builtins.int] cross_account_user_id: Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the ID of the actual account to which the data source belongs.
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.bool] disabled: Whether the policy is effective for the data source.
               - true: Pause
               - false: not paused
        :param pulumi.Input[_builtins.str] exclude: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates a file type that does not need to be backed up. All files of this type are not backed up. A maximum of 255 characters is supported.
        :param pulumi.Input[_builtins.str] include: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates the file types to be backed up, and all files of these types are backed up. A maximum of 255 characters is supported.
        :param pulumi.Input[_builtins.str] policy_binding_description: Resource Description
        :param pulumi.Input[_builtins.str] policy_id: The policy ID.
        :param pulumi.Input[_builtins.str] source: When SourceType is OSS, a prefix is specified to be backed up. If it is not specified, the entire root directory of the Bucket is backed up.
        :param pulumi.Input[_builtins.str] source_type: Data source type, value range:
               - `UDM_ECS`: indicates the ECS instance backup.
               - `OSS`: indicates an OSS backup.
               - `NAS`: indicates an Alibaba Cloud NAS Backup. When you bind a file system to a policy, Cloud Backup automatically creates a mount point for the file system. If you no longer need the mount point, delete it manually.
               - `ECS_FILE`: indicates that the ECS file is backed up.
               - `File`: indicates a local File backup.
               - `OTS`: (Available since v1.260.1) indicates the Tablestore backup.
        :param pulumi.Input[_builtins.str] speed_limit: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates backup flow control. The format is {start}{end}{bandwidth}. Multiple flow control configurations use partitioning, and no overlap in configuration time is allowed. start: start hour. end: end of hour. bandwidth: limit rate, in KB/s.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PolicyBindingArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a HBR Policy Binding resource.

        For information about HBR Policy Binding and how to use it, see [What is Policy Binding](https://www.alibabacloud.com/help/en/cloud-backup/developer-reference/api-hbr-2017-09-08-createpolicybindings).

        > **NOTE:** Available since v1.221.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            max=99999,
            min=10000)
        defaultyk84_hc = alicloud.hbr.Vault("defaultyk84Hc",
            vault_type="STANDARD",
            vault_name=f"example-value-{default['result']}")
        defaultoq_wv_hq = alicloud.hbr.Policy("defaultoqWvHQ",
            policy_name=f"example-value-{default['result']}",
            rules=[{
                "rule_type": "BACKUP",
                "backup_type": "COMPLETE",
                "schedule": "I|1631685600|P1D",
                "retention": 7,
                "archive_days": 0,
                "vault_id": defaultyk84_hc.id,
            }],
            policy_description="policy example")
        default_ktt2_xy = alicloud.oss.Bucket("defaultKtt2XY",
            storage_class="Standard",
            bucket=f"example-value-{default['result']}")
        default_policy_binding = alicloud.hbr.PolicyBinding("default",
            source_type="OSS",
            disabled=False,
            policy_id=defaultoq_wv_hq.id,
            data_source_id=default_ktt2_xy.bucket,
            policy_binding_description="policy binding example (update)",
            source="prefix-example-update/")
        ```

        ## Import

        HBR Policy Binding can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/policyBinding:PolicyBinding example <policy_id>:<source_type>:<data_source_id>
        ```

        :param str resource_name: The name of the resource.
        :param PolicyBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_options: Optional[pulumi.Input[Union['PolicyBindingAdvancedOptionsArgs', 'PolicyBindingAdvancedOptionsArgsDict']]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclude: Optional[pulumi.Input[_builtins.str]] = None,
                 include: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_binding_description: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 speed_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyBindingArgs.__new__(PolicyBindingArgs)

            __props__.__dict__["advanced_options"] = advanced_options
            __props__.__dict__["cross_account_role_name"] = cross_account_role_name
            __props__.__dict__["cross_account_type"] = cross_account_type
            __props__.__dict__["cross_account_user_id"] = cross_account_user_id
            __props__.__dict__["data_source_id"] = data_source_id
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["exclude"] = exclude
            __props__.__dict__["include"] = include
            __props__.__dict__["policy_binding_description"] = policy_binding_description
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["source"] = source
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["speed_limit"] = speed_limit
            __props__.__dict__["create_time"] = None
        super(PolicyBinding, __self__).__init__(
            'alicloud:hbr/policyBinding:PolicyBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_options: Optional[pulumi.Input[Union['PolicyBindingAdvancedOptionsArgs', 'PolicyBindingAdvancedOptionsArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
            data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            exclude: Optional[pulumi.Input[_builtins.str]] = None,
            include: Optional[pulumi.Input[_builtins.str]] = None,
            policy_binding_description: Optional[pulumi.Input[_builtins.str]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None,
            speed_limit: Optional[pulumi.Input[_builtins.str]] = None) -> 'PolicyBinding':
        """
        Get an existing PolicyBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PolicyBindingAdvancedOptionsArgs', 'PolicyBindingAdvancedOptionsArgsDict']] advanced_options: Backup Advanced Options See `advanced_options` below.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] cross_account_role_name: Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the name of the cross-account authorization role of the data source, and the management account uses this role to access the data source.
        :param pulumi.Input[_builtins.str] cross_account_type: Cross-account type, supported
        :param pulumi.Input[_builtins.int] cross_account_user_id: Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the ID of the actual account to which the data source belongs.
        :param pulumi.Input[_builtins.str] data_source_id: The data source ID.
        :param pulumi.Input[_builtins.bool] disabled: Whether the policy is effective for the data source.
               - true: Pause
               - false: not paused
        :param pulumi.Input[_builtins.str] exclude: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates a file type that does not need to be backed up. All files of this type are not backed up. A maximum of 255 characters is supported.
        :param pulumi.Input[_builtins.str] include: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates the file types to be backed up, and all files of these types are backed up. A maximum of 255 characters is supported.
        :param pulumi.Input[_builtins.str] policy_binding_description: Resource Description
        :param pulumi.Input[_builtins.str] policy_id: The policy ID.
        :param pulumi.Input[_builtins.str] source: When SourceType is OSS, a prefix is specified to be backed up. If it is not specified, the entire root directory of the Bucket is backed up.
        :param pulumi.Input[_builtins.str] source_type: Data source type, value range:
               - `UDM_ECS`: indicates the ECS instance backup.
               - `OSS`: indicates an OSS backup.
               - `NAS`: indicates an Alibaba Cloud NAS Backup. When you bind a file system to a policy, Cloud Backup automatically creates a mount point for the file system. If you no longer need the mount point, delete it manually.
               - `ECS_FILE`: indicates that the ECS file is backed up.
               - `File`: indicates a local File backup.
               - `OTS`: (Available since v1.260.1) indicates the Tablestore backup.
        :param pulumi.Input[_builtins.str] speed_limit: This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates backup flow control. The format is {start}{end}{bandwidth}. Multiple flow control configurations use partitioning, and no overlap in configuration time is allowed. start: start hour. end: end of hour. bandwidth: limit rate, in KB/s.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyBindingState.__new__(_PolicyBindingState)

        __props__.__dict__["advanced_options"] = advanced_options
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cross_account_role_name"] = cross_account_role_name
        __props__.__dict__["cross_account_type"] = cross_account_type
        __props__.__dict__["cross_account_user_id"] = cross_account_user_id
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["exclude"] = exclude
        __props__.__dict__["include"] = include
        __props__.__dict__["policy_binding_description"] = policy_binding_description
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["source"] = source
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["speed_limit"] = speed_limit
        return PolicyBinding(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> pulumi.Output['outputs.PolicyBindingAdvancedOptions']:
        """
        Backup Advanced Options See `advanced_options` below.
        """
        return pulumi.get(self, "advanced_options")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the name of the cross-account authorization role of the data source, and the management account uses this role to access the data source.
        """
        return pulumi.get(self, "cross_account_role_name")

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> pulumi.Output[_builtins.str]:
        """
        Cross-account type, supported
        """
        return pulumi.get(self, "cross_account_type")

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Valid only when CrossAccountType = CROSS_ACCOUNT, indicating the ID of the actual account to which the data source belongs.
        """
        return pulumi.get(self, "cross_account_user_id")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[_builtins.str]:
        """
        The data source ID.
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the policy is effective for the data source.
        - true: Pause
        - false: not paused
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def exclude(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates a file type that does not need to be backed up. All files of this type are not backed up. A maximum of 255 characters is supported.
        """
        return pulumi.get(self, "exclude")

    @_builtins.property
    @pulumi.getter
    def include(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates the file types to be backed up, and all files of these types are backed up. A maximum of 255 characters is supported.
        """
        return pulumi.get(self, "include")

    @_builtins.property
    @pulumi.getter(name="policyBindingDescription")
    def policy_binding_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource Description
        """
        return pulumi.get(self, "policy_binding_description")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The policy ID.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When SourceType is OSS, a prefix is specified to be backed up. If it is not specified, the entire root directory of the Bucket is backed up.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[_builtins.str]:
        """
        Data source type, value range:
        - `UDM_ECS`: indicates the ECS instance backup.
        - `OSS`: indicates an OSS backup.
        - `NAS`: indicates an Alibaba Cloud NAS Backup. When you bind a file system to a policy, Cloud Backup automatically creates a mount point for the file system. If you no longer need the mount point, delete it manually.
        - `ECS_FILE`: indicates that the ECS file is backed up.
        - `File`: indicates a local File backup.
        - `OTS`: (Available since v1.260.1) indicates the Tablestore backup.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="speedLimit")
    def speed_limit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This parameter is required only when the value of SourceType is ECS_FILE or File. Indicates backup flow control. The format is {start}{end}{bandwidth}. Multiple flow control configurations use partitioning, and no overlap in configuration time is allowed. start: start hour. end: end of hour. bandwidth: limit rate, in KB/s.
        """
        return pulumi.get(self, "speed_limit")

