# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuditLogConfigArgs', 'AuditLogConfig']

@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 db_audit: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a AuditLogConfig resource.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID, Call the Describeinstances Get.
        :param pulumi.Input[_builtins.bool] db_audit: Indicates Whether to Enable the Audit Log.  Valid value: 
               * true: Default Value, Open.
               * false: Closed.
               
               Note: When the Instance for the Cluster Architecture Or Read/Write Split Architecture, at the Same Time to Open Or Close the Data Node and the Proxy Node of the Audit Log Doesn't Support Separate Open.
        :param pulumi.Input[_builtins.int] retention: Audit Log Retention Period Value: 1~365. 
               
               > **NOTE:** When the Instance dbaudit Value Is Set to True, This Parameter Entry into Force. The Parameter Setting of the Current Region of All a Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance for a Data Entry into Force.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if db_audit is not None:
            pulumi.set(__self__, "db_audit", db_audit)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Instance ID, Call the Describeinstances Get.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="dbAudit")
    def db_audit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates Whether to Enable the Audit Log.  Valid value: 
        * true: Default Value, Open.
        * false: Closed.

        Note: When the Instance for the Cluster Architecture Or Read/Write Split Architecture, at the Same Time to Open Or Close the Data Node and the Proxy Node of the Audit Log Doesn't Support Separate Open.
        """
        return pulumi.get(self, "db_audit")

    @db_audit.setter
    def db_audit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "db_audit", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Audit Log Retention Period Value: 1~365. 

        > **NOTE:** When the Instance dbaudit Value Is Set to True, This Parameter Entry into Force. The Parameter Setting of the Current Region of All a Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance for a Data Entry into Force.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention", value)


@pulumi.input_type
class _AuditLogConfigState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 db_audit: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuditLogConfig resources.
        :param pulumi.Input[_builtins.str] create_time: Instance Creation Time.
        :param pulumi.Input[_builtins.bool] db_audit: Indicates Whether to Enable the Audit Log.  Valid value: 
               * true: Default Value, Open.
               * false: Closed.
               
               Note: When the Instance for the Cluster Architecture Or Read/Write Split Architecture, at the Same Time to Open Or Close the Data Node and the Proxy Node of the Audit Log Doesn't Support Separate Open.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID, Call the Describeinstances Get.
        :param pulumi.Input[_builtins.int] retention: Audit Log Retention Period Value: 1~365. 
               
               > **NOTE:** When the Instance dbaudit Value Is Set to True, This Parameter Entry into Force. The Parameter Setting of the Current Region of All a Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance for a Data Entry into Force.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if db_audit is not None:
            pulumi.set(__self__, "db_audit", db_audit)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance Creation Time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dbAudit")
    def db_audit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates Whether to Enable the Audit Log.  Valid value: 
        * true: Default Value, Open.
        * false: Closed.

        Note: When the Instance for the Cluster Architecture Or Read/Write Split Architecture, at the Same Time to Open Or Close the Data Node and the Proxy Node of the Audit Log Doesn't Support Separate Open.
        """
        return pulumi.get(self, "db_audit")

    @db_audit.setter
    def db_audit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "db_audit", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID, Call the Describeinstances Get.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Audit Log Retention Period Value: 1~365. 

        > **NOTE:** When the Instance dbaudit Value Is Set to True, This Parameter Entry into Force. The Parameter Setting of the Current Region of All a Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance for a Data Entry into Force.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:kvstore/auditLogConfig:AuditLogConfig")
class AuditLogConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_audit: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Tair (Redis OSS-Compatible) And Memcache (KVStore) Audit Log Config resource.

        > **NOTE:** Available since v1.130.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.kvstore.get_zones()
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_instance = alicloud.kvstore.Instance("default",
            db_instance_name=name,
            vswitch_id=default_switch.id,
            resource_group_id=default_get_resource_groups.ids[0],
            zone_id=default.zones[0].id,
            instance_class="redis.master.large.default",
            instance_type="Redis",
            engine_version="5.0",
            security_ips=["10.23.12.24"],
            config={
                "appendonly": "yes",
                "lazyfree-lazy-eviction": "yes",
            },
            tags={
                "Created": "TF",
                "For": "example",
            })
        example = alicloud.kvstore.AuditLogConfig("example",
            instance_id=default_instance.id,
            db_audit=True,
            retention=1)
        ```

        ## Import

        Tair (Redis OSS-Compatible) And Memcache (KVStore) Audit Log Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kvstore/auditLogConfig:AuditLogConfig example <instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] db_audit: Indicates Whether to Enable the Audit Log.  Valid value: 
               * true: Default Value, Open.
               * false: Closed.
               
               Note: When the Instance for the Cluster Architecture Or Read/Write Split Architecture, at the Same Time to Open Or Close the Data Node and the Proxy Node of the Audit Log Doesn't Support Separate Open.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID, Call the Describeinstances Get.
        :param pulumi.Input[_builtins.int] retention: Audit Log Retention Period Value: 1~365. 
               
               > **NOTE:** When the Instance dbaudit Value Is Set to True, This Parameter Entry into Force. The Parameter Setting of the Current Region of All a Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance for a Data Entry into Force.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuditLogConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Tair (Redis OSS-Compatible) And Memcache (KVStore) Audit Log Config resource.

        > **NOTE:** Available since v1.130.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.kvstore.get_zones()
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_instance = alicloud.kvstore.Instance("default",
            db_instance_name=name,
            vswitch_id=default_switch.id,
            resource_group_id=default_get_resource_groups.ids[0],
            zone_id=default.zones[0].id,
            instance_class="redis.master.large.default",
            instance_type="Redis",
            engine_version="5.0",
            security_ips=["10.23.12.24"],
            config={
                "appendonly": "yes",
                "lazyfree-lazy-eviction": "yes",
            },
            tags={
                "Created": "TF",
                "For": "example",
            })
        example = alicloud.kvstore.AuditLogConfig("example",
            instance_id=default_instance.id,
            db_audit=True,
            retention=1)
        ```

        ## Import

        Tair (Redis OSS-Compatible) And Memcache (KVStore) Audit Log Config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kvstore/auditLogConfig:AuditLogConfig example <instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param AuditLogConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuditLogConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_audit: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuditLogConfigArgs.__new__(AuditLogConfigArgs)

            __props__.__dict__["db_audit"] = db_audit
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["retention"] = retention
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(AuditLogConfig, __self__).__init__(
            'alicloud:kvstore/auditLogConfig:AuditLogConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            db_audit: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            retention: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuditLogConfig':
        """
        Get an existing AuditLogConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Instance Creation Time.
        :param pulumi.Input[_builtins.bool] db_audit: Indicates Whether to Enable the Audit Log.  Valid value: 
               * true: Default Value, Open.
               * false: Closed.
               
               Note: When the Instance for the Cluster Architecture Or Read/Write Split Architecture, at the Same Time to Open Or Close the Data Node and the Proxy Node of the Audit Log Doesn't Support Separate Open.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID, Call the Describeinstances Get.
        :param pulumi.Input[_builtins.int] retention: Audit Log Retention Period Value: 1~365. 
               
               > **NOTE:** When the Instance dbaudit Value Is Set to True, This Parameter Entry into Force. The Parameter Setting of the Current Region of All a Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance for a Data Entry into Force.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuditLogConfigState.__new__(_AuditLogConfigState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["db_audit"] = db_audit
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["retention"] = retention
        __props__.__dict__["status"] = status
        return AuditLogConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Instance Creation Time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dbAudit")
    def db_audit(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates Whether to Enable the Audit Log.  Valid value: 
        * true: Default Value, Open.
        * false: Closed.

        Note: When the Instance for the Cluster Architecture Or Read/Write Split Architecture, at the Same Time to Open Or Close the Data Node and the Proxy Node of the Audit Log Doesn't Support Separate Open.
        """
        return pulumi.get(self, "db_audit")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance ID, Call the Describeinstances Get.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Audit Log Retention Period Value: 1~365. 

        > **NOTE:** When the Instance dbaudit Value Is Set to True, This Parameter Entry into Force. The Parameter Setting of the Current Region of All a Tair (Redis OSS-Compatible) And Memcache (KVStore) Instance for a Data Entry into Force.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

