# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 business_info: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 coupon_no: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_release_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_auto_upgrade_open: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 order_type: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_connection_port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 slave_read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 srcdb_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to renewal a KVStore DBInstance automatically or not. It is valid when payment_type is `PrePaid`. Default value: `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an KVStore DBInstance, in the unit of the month. It is valid when payment_type is `PrePaid`. Valid values: [1~12]. Default value: `1`.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Specifies whether to use a coupon. Default value: `false`.
        :param pulumi.Input[_builtins.str] availability_zone: It has been deprecated from provider version 1.101.0 and `zone_id` instead.
        :param pulumi.Input[_builtins.str] backup_id: The ID of the backup file of the source instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_periods: Backup period.
        :param pulumi.Input[_builtins.str] backup_time: Backup time, the format is HH:mmZ-HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.int] bandwidth: The total bandwidth of the instance. **NOTE:** From version 1.232.0, `bandwidth` can be set. If the instance is a cluster instance, `bandwidth` must be divisible by the number of `shard_count` in the instance, and if the instance is a read/write splitting instance, `bandwidth` cannot be set.
        :param pulumi.Input[_builtins.str] business_info: The ID of the event or the business information.
        :param pulumi.Input[_builtins.int] capacity: The storage capacity of the KVStore DBInstance. Unit: MB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
        :param pulumi.Input[_builtins.str] connection_string_prefix: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] coupon_no: The coupon code. **NOTE:** The default value `youhuiquan_promotion_option_id_for_blank` removed since v1.216.0, this can cause your status file to change even if it has not been modified, so please review your change plan before apply change plan.
        :param pulumi.Input[_builtins.str] db_instance_name: The name of KVStore DBInstance. It is a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of the dedicated cluster. This parameter is required when you create a Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance in a dedicated cluster.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to precheck the request. Valid values:
        :param pulumi.Input[_builtins.str] effective_time: The time when the database is switched after the instance is migrated, or when the major version is upgraded, or when the instance class is upgraded. Valid values:
               - `Immediately` (Default): The configurations are immediately changed.
               - `MaintainTime`: The configurations are changed within the maintenance window. You can set `maintain_start_time` and `maintain_end_time` to change the maintenance window.
        :param pulumi.Input[_builtins.int] enable_backup_log: Turn on or off incremental backup. Valid values: `1`, `0`. Default value: `0`
        :param pulumi.Input[_builtins.bool] enable_public: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] encryption_key: The Custom key ID, which you can get by calling DescribeEncryptionKeyList.If this parameter is not passed, the key is automatically generated by the key management service. To create a custom key, you can call the CreateKey interface of the key management service.
        :param pulumi.Input[_builtins.str] encryption_name: The Encryption algorithm, default AES-CTR-256.Note that this parameter is only available when the TDEStatus parameter is Enabled.
        :param pulumi.Input[_builtins.str] engine_version: The engine version of the KVStore DBInstance. Valid values: ["2.8", "4.0", "5.0", "6.0", "7.0"]. Default value: `5.0`.
               **NOTE:** When `instance_type = Memcache`, the `engine_version` only supports "4.0".
        :param pulumi.Input[_builtins.bool] force_upgrade: Specifies whether to forcibly change the type. Default value: `true`.
        :param pulumi.Input[_builtins.bool] global_instance: Whether to create a distributed cache. Default value: `false`.
        :param pulumi.Input[_builtins.str] global_instance_id: The ID of distributed cache.
        :param pulumi.Input[_builtins.str] instance_charge_type: It has been deprecated from provider version 1.101.0 and `payment_type` instead.
        :param pulumi.Input[_builtins.str] instance_class: Type of the applied Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance. It can be retrieved by data source kvstore_get_instance_classes
               or referring to help-docs [Instance type table](https://www.alibabacloud.com/help/doc-detail/26350.htm).
        :param pulumi.Input[_builtins.str] instance_name: It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
        :param pulumi.Input[_builtins.bool] instance_release_protection: Whether to open the release protection.
        :param pulumi.Input[_builtins.str] instance_type: The engine type of the KVStore DBInstance. Valid values: `Redis` or `Memcache`. Default value: `Redis`.
        :param pulumi.Input[_builtins.str] is_auto_upgrade_open: Specifies whether to enable automatic minor version update. Valid values:
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] node_type: Node type, valid values:
               - `MASTER_SLAVE`: High availability (dual copies)
               - `STAND_ALONE`: Single copy
        :param pulumi.Input[_builtins.str] order_type: Specifies a change type when you change the configuration of a subscription instance. Valid values: `UPGRADE`, `DOWNGRADE`. Default value: `UPGRADE`. `UPGRADE` means upgrades the configuration of a subscription instance. `DOWNGRADE` means downgrades the configuration of a subscription instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]] parameters: It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
        :param pulumi.Input[_builtins.str] password: The password of the KVStore DBInstance. The password that is used to connect to the instance. The password must be 8 to 32 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, special characters, and digits. Special characters include: `! @ # $ % ^ & * ( ) _ + - =`
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the KVStore DBInstance. Valid values: `PrePaid`, `PostPaid`. Default value: `PostPaid`.
        :param pulumi.Input[_builtins.str] period: The duration that you will buy KVStore DBInstance (in month). It is valid when payment_type is `PrePaid`. Valid values: `[1~9]`, `12`, `24`, `36`.
        :param pulumi.Input[_builtins.int] port: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] private_connection_port: Private network connection port, used to modify the private network connection port.
        :param pulumi.Input[_builtins.str] private_connection_prefix: Private network connection prefix, used to modify the private network connection address. Only supports updating private network connections for existing instance.
        :param pulumi.Input[_builtins.str] private_ip: The internal IP address of the instance.
        :param pulumi.Input[_builtins.int] read_only_count: The number of read replicas in the primary zone. Valid values: `1` to `9`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of resource group which the resource belongs.
        :param pulumi.Input[_builtins.str] restore_time: The point in time of a backup file.
        :param pulumi.Input[_builtins.str] role_arn: The Specify the global resource descriptor ARN (Alibaba Cloud Resource Name) information of the role to be authorized, and use the related key management services after the authorization is completed, in the format: `acs:ram::$accountID:role/$roleName`.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary zone to which you want to migrate the Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance.
               > **NOTE:** If you specify this parameter, the master node and replica node of the instance can be deployed in different zones and disaster recovery is implemented across zones. The instance can withstand failures in data centers.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of security groups. Separate multiple security group IDs with commas (,), such as `sg-***,sg-***,sg-***`.
        :param pulumi.Input[_builtins.str] security_ip_group_attribute: The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
        :param pulumi.Input[_builtins.str] security_ip_group_name: The name of the whitelist group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
        :param pulumi.Input[_builtins.int] shard_count: The number of data shards. This parameter is available only if you create a cluster instance that uses cloud disks. You can use this parameter to specify a custom number of data shards. **NOTE:** From version 1.216.0, `shard_count` can be modified.
        :param pulumi.Input[_builtins.int] slave_read_only_count: The number of read replicas in the secondary zone. **NOTE:**: When you create a multi-zone read/write splitting instance, you must specify both `secondary_zone_id` and `slave_read_only_count`.
               > **NOTE:** The sum of `read_only_count` and `slave_read_only_count` cannot be greater than `9`.
        :param pulumi.Input[_builtins.str] srcdb_instance_id: The ID of the source instance.
        :param pulumi.Input[_builtins.str] ssl_enable: Modifies the SSL status. Valid values: `Disable`, `Enable` and `Update`.
               **NOTE:** This functionality is supported by Cluster mode (Redis 2.8, 4.0, 5.0) and Standard mode( Redis 2.8 only).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] tde_status: Specifies whether to enable TDE. Valid values: `Enabled`.
               **NOTE:**: TDE cannot be disabled after it is enabled. Before you enable it, evaluate whether this feature affects.
               your business. For more information, see [Enable TDE](https://www.alibabacloud.com/help/en/redis/user-guide/enable-tde).
        :param pulumi.Input[_builtins.str] vpc_auth_mode: Only meaningful if instance_type is `Redis` and network type is VPC. Valid values: `Close`, `Open`. Default value: `Open`. `Close` means the redis instance can be accessed without authentication. `Open` means authentication is required.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of VSwitch.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if auto_use_coupon is not None:
            pulumi.set(__self__, "auto_use_coupon", auto_use_coupon)
        if availability_zone is not None:
            warnings.warn("""Field 'availability_zone' has been deprecated from version 1.101.0. Use 'zone_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""availability_zone is deprecated: Field 'availability_zone' has been deprecated from version 1.101.0. Use 'zone_id' instead.""")
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if backup_periods is not None:
            pulumi.set(__self__, "backup_periods", backup_periods)
        if backup_time is not None:
            pulumi.set(__self__, "backup_time", backup_time)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if business_info is not None:
            pulumi.set(__self__, "business_info", business_info)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if connection_string_prefix is not None:
            warnings.warn("""Field 'connection_string_prefix' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""", DeprecationWarning)
            pulumi.log.warn("""connection_string_prefix is deprecated: Field 'connection_string_prefix' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if coupon_no is not None:
            pulumi.set(__self__, "coupon_no", coupon_no)
        if db_instance_name is not None:
            pulumi.set(__self__, "db_instance_name", db_instance_name)
        if dedicated_host_group_id is not None:
            pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if enable_backup_log is not None:
            pulumi.set(__self__, "enable_backup_log", enable_backup_log)
        if enable_public is not None:
            warnings.warn("""Field 'enable_public' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""", DeprecationWarning)
            pulumi.log.warn("""enable_public is deprecated: Field 'enable_public' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
        if enable_public is not None:
            pulumi.set(__self__, "enable_public", enable_public)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_name is not None:
            pulumi.set(__self__, "encryption_name", encryption_name)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force_upgrade is not None:
            pulumi.set(__self__, "force_upgrade", force_upgrade)
        if global_instance is not None:
            pulumi.set(__self__, "global_instance", global_instance)
        if global_instance_id is not None:
            pulumi.set(__self__, "global_instance_id", global_instance_id)
        if instance_charge_type is not None:
            warnings.warn("""Field 'instance_charge_type' has been deprecated from version 1.101.0. Use 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated from version 1.101.0. Use 'payment_type' instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if instance_name is not None:
            warnings.warn("""Field `instance_name` has been deprecated from version 1.101.0. Use `db_instance_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_name is deprecated: Field `instance_name` has been deprecated from version 1.101.0. Use `db_instance_name` instead.""")
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_release_protection is not None:
            pulumi.set(__self__, "instance_release_protection", instance_release_protection)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if is_auto_upgrade_open is not None:
            pulumi.set(__self__, "is_auto_upgrade_open", is_auto_upgrade_open)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if maintain_end_time is not None:
            pulumi.set(__self__, "maintain_end_time", maintain_end_time)
        if maintain_start_time is not None:
            pulumi.set(__self__, "maintain_start_time", maintain_start_time)
        if node_type is not None:
            warnings.warn("""Field 'node_type' has been deprecated from version 1.120.1""", DeprecationWarning)
            pulumi.log.warn("""node_type is deprecated: Field 'node_type' has been deprecated from version 1.120.1""")
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if order_type is not None:
            pulumi.set(__self__, "order_type", order_type)
        if parameters is not None:
            warnings.warn("""Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.""", DeprecationWarning)
            pulumi.log.warn("""parameters is deprecated: Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.""")
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_connection_port is not None:
            pulumi.set(__self__, "private_connection_port", private_connection_port)
        if private_connection_prefix is not None:
            pulumi.set(__self__, "private_connection_prefix", private_connection_prefix)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if read_only_count is not None:
            pulumi.set(__self__, "read_only_count", read_only_count)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restore_time is not None:
            pulumi.set(__self__, "restore_time", restore_time)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if secondary_zone_id is not None:
            pulumi.set(__self__, "secondary_zone_id", secondary_zone_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_ip_group_attribute is not None:
            pulumi.set(__self__, "security_ip_group_attribute", security_ip_group_attribute)
        if security_ip_group_name is not None:
            pulumi.set(__self__, "security_ip_group_name", security_ip_group_name)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if slave_read_only_count is not None:
            pulumi.set(__self__, "slave_read_only_count", slave_read_only_count)
        if srcdb_instance_id is not None:
            pulumi.set(__self__, "srcdb_instance_id", srcdb_instance_id)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tde_status is not None:
            pulumi.set(__self__, "tde_status", tde_status)
        if vpc_auth_mode is not None:
            pulumi.set(__self__, "vpc_auth_mode", vpc_auth_mode)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to renewal a KVStore DBInstance automatically or not. It is valid when payment_type is `PrePaid`. Default value: `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto-renewal period of an KVStore DBInstance, in the unit of the month. It is valid when payment_type is `PrePaid`. Valid values: [1~12]. Default value: `1`.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use a coupon. Default value: `false`.
        """
        return pulumi.get(self, "auto_use_coupon")

    @auto_use_coupon.setter
    def auto_use_coupon(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_use_coupon", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    @_utilities.deprecated("""Field 'availability_zone' has been deprecated from version 1.101.0. Use 'zone_id' instead.""")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from provider version 1.101.0 and `zone_id` instead.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the backup file of the source instance.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter(name="backupPeriods")
    def backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Backup period.
        """
        return pulumi.get(self, "backup_periods")

    @backup_periods.setter
    def backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="backupTime")
    def backup_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup time, the format is HH:mmZ-HH:mmZ (UTC time).
        """
        return pulumi.get(self, "backup_time")

    @backup_time.setter
    def backup_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_time", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total bandwidth of the instance. **NOTE:** From version 1.232.0, `bandwidth` can be set. If the instance is a cluster instance, `bandwidth` must be divisible by the number of `shard_count` in the instance, and if the instance is a read/write splitting instance, `bandwidth` cannot be set.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="businessInfo")
    def business_info(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the event or the business information.
        """
        return pulumi.get(self, "business_info")

    @business_info.setter
    def business_info(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_info", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The storage capacity of the KVStore DBInstance. Unit: MB.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    @_utilities.deprecated("""Field 'connection_string_prefix' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
    def connection_string_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="couponNo")
    def coupon_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The coupon code. **NOTE:** The default value `youhuiquan_promotion_option_id_for_blank` removed since v1.216.0, this can cause your status file to change even if it has not been modified, so please review your change plan before apply change plan.
        """
        return pulumi.get(self, "coupon_no")

    @coupon_no.setter
    def coupon_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "coupon_no", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceName")
    def db_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of KVStore DBInstance. It is a string of 2 to 256 characters.
        """
        return pulumi.get(self, "db_instance_name")

    @db_instance_name.setter
    def db_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated cluster. This parameter is required when you create a Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance in a dedicated cluster.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @dedicated_host_group_id.setter
    def dedicated_host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_host_group_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to precheck the request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the database is switched after the instance is migrated, or when the major version is upgraded, or when the instance class is upgraded. Valid values:
        - `Immediately` (Default): The configurations are immediately changed.
        - `MaintainTime`: The configurations are changed within the maintenance window. You can set `maintain_start_time` and `maintain_end_time` to change the maintenance window.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="enableBackupLog")
    def enable_backup_log(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Turn on or off incremental backup. Valid values: `1`, `0`. Default value: `0`
        """
        return pulumi.get(self, "enable_backup_log")

    @enable_backup_log.setter
    def enable_backup_log(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enable_backup_log", value)

    @_builtins.property
    @pulumi.getter(name="enablePublic")
    @_utilities.deprecated("""Field 'enable_public' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
    def enable_public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        """
        return pulumi.get(self, "enable_public")

    @enable_public.setter
    def enable_public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Custom key ID, which you can get by calling DescribeEncryptionKeyList.If this parameter is not passed, the key is automatically generated by the key management service. To create a custom key, you can call the CreateKey interface of the key management service.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="encryptionName")
    def encryption_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Encryption algorithm, default AES-CTR-256.Note that this parameter is only available when the TDEStatus parameter is Enabled.
        """
        return pulumi.get(self, "encryption_name")

    @encryption_name.setter
    def encryption_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_name", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The engine version of the KVStore DBInstance. Valid values: ["2.8", "4.0", "5.0", "6.0", "7.0"]. Default value: `5.0`.
        **NOTE:** When `instance_type = Memcache`, the `engine_version` only supports "4.0".
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="forceUpgrade")
    def force_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcibly change the type. Default value: `true`.
        """
        return pulumi.get(self, "force_upgrade")

    @force_upgrade.setter
    def force_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="globalInstance")
    def global_instance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create a distributed cache. Default value: `false`.
        """
        return pulumi.get(self, "global_instance")

    @global_instance.setter
    def global_instance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "global_instance", value)

    @_builtins.property
    @pulumi.getter(name="globalInstanceId")
    def global_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of distributed cache.
        """
        return pulumi.get(self, "global_instance_id")

    @global_instance_id.setter
    def global_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated from version 1.101.0. Use 'payment_type' instead.""")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from provider version 1.101.0 and `payment_type` instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the applied Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance. It can be retrieved by data source kvstore_get_instance_classes
        or referring to help-docs [Instance type table](https://www.alibabacloud.com/help/doc-detail/26350.htm).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    @_utilities.deprecated("""Field `instance_name` has been deprecated from version 1.101.0. Use `db_instance_name` instead.""")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceReleaseProtection")
    def instance_release_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to open the release protection.
        """
        return pulumi.get(self, "instance_release_protection")

    @instance_release_protection.setter
    def instance_release_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "instance_release_protection", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The engine type of the KVStore DBInstance. Valid values: `Redis` or `Memcache`. Default value: `Redis`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="isAutoUpgradeOpen")
    def is_auto_upgrade_open(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable automatic minor version update. Valid values:
        """
        return pulumi.get(self, "is_auto_upgrade_open")

    @is_auto_upgrade_open.setter
    def is_auto_upgrade_open(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_auto_upgrade_open", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_end_time")

    @maintain_end_time.setter
    def maintain_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end_time", value)

    @_builtins.property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_start_time")

    @maintain_start_time.setter
    def maintain_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_start_time", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    @_utilities.deprecated("""Field 'node_type' has been deprecated from version 1.120.1""")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node type, valid values:
        - `MASTER_SLAVE`: High availability (dual copies)
        - `STAND_ALONE`: Single copy
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="orderType")
    def order_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a change type when you change the configuration of a subscription instance. Valid values: `UPGRADE`, `DOWNGRADE`. Default value: `UPGRADE`. `UPGRADE` means upgrades the configuration of a subscription instance. `DOWNGRADE` means downgrades the configuration of a subscription instance.
        """
        return pulumi.get(self, "order_type")

    @order_type.setter
    def order_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "order_type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.""")
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]:
        """
        It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the KVStore DBInstance. The password that is used to connect to the instance. The password must be 8 to 32 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, special characters, and digits. Special characters include: `! @ # $ % ^ & * ( ) _ + - =`
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the KVStore DBInstance. Valid values: `PrePaid`, `PostPaid`. Default value: `PostPaid`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The duration that you will buy KVStore DBInstance (in month). It is valid when payment_type is `PrePaid`. Valid values: `[1~9]`, `12`, `24`, `36`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="privateConnectionPort")
    def private_connection_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private network connection port, used to modify the private network connection port.
        """
        return pulumi.get(self, "private_connection_port")

    @private_connection_port.setter
    def private_connection_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_connection_port", value)

    @_builtins.property
    @pulumi.getter(name="privateConnectionPrefix")
    def private_connection_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private network connection prefix, used to modify the private network connection address. Only supports updating private network connections for existing instance.
        """
        return pulumi.get(self, "private_connection_prefix")

    @private_connection_prefix.setter
    def private_connection_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_connection_prefix", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal IP address of the instance.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="readOnlyCount")
    def read_only_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of read replicas in the primary zone. Valid values: `1` to `9`.
        """
        return pulumi.get(self, "read_only_count")

    @read_only_count.setter
    def read_only_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_only_count", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of resource group which the resource belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time of a backup file.
        """
        return pulumi.get(self, "restore_time")

    @restore_time.setter
    def restore_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_time", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Specify the global resource descriptor ARN (Alibaba Cloud Resource Name) information of the role to be authorized, and use the related key management services after the authorization is completed, in the format: `acs:ram::$accountID:role/$roleName`.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the secondary zone to which you want to migrate the Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance.
        > **NOTE:** If you specify this parameter, the master node and replica node of the instance can be deployed in different zones and disaster recovery is implemented across zones. The instance can withstand failures in data centers.
        """
        return pulumi.get(self, "secondary_zone_id")

    @secondary_zone_id.setter
    def secondary_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of security groups. Separate multiple security group IDs with commas (,), such as `sg-***,sg-***,sg-***`.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityIpGroupAttribute")
    def security_ip_group_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
        """
        return pulumi.get(self, "security_ip_group_attribute")

    @security_ip_group_attribute.setter
    def security_ip_group_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_group_attribute", value)

    @_builtins.property
    @pulumi.getter(name="securityIpGroupName")
    def security_ip_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the whitelist group.
        """
        return pulumi.get(self, "security_ip_group_name")

    @security_ip_group_name.setter
    def security_ip_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_ips", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of data shards. This parameter is available only if you create a cluster instance that uses cloud disks. You can use this parameter to specify a custom number of data shards. **NOTE:** From version 1.216.0, `shard_count` can be modified.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="slaveReadOnlyCount")
    def slave_read_only_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of read replicas in the secondary zone. **NOTE:**: When you create a multi-zone read/write splitting instance, you must specify both `secondary_zone_id` and `slave_read_only_count`.
        > **NOTE:** The sum of `read_only_count` and `slave_read_only_count` cannot be greater than `9`.
        """
        return pulumi.get(self, "slave_read_only_count")

    @slave_read_only_count.setter
    def slave_read_only_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slave_read_only_count", value)

    @_builtins.property
    @pulumi.getter(name="srcdbInstanceId")
    def srcdb_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source instance.
        """
        return pulumi.get(self, "srcdb_instance_id")

    @srcdb_instance_id.setter
    def srcdb_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "srcdb_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Modifies the SSL status. Valid values: `Disable`, `Enable` and `Update`.
        **NOTE:** This functionality is supported by Cluster mode (Redis 2.8, 4.0, 5.0) and Standard mode( Redis 2.8 only).
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable TDE. Valid values: `Enabled`.
        **NOTE:**: TDE cannot be disabled after it is enabled. Before you enable it, evaluate whether this feature affects.
        your business. For more information, see [Enable TDE](https://www.alibabacloud.com/help/en/redis/user-guide/enable-tde).
        """
        return pulumi.get(self, "tde_status")

    @tde_status.setter
    def tde_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tde_status", value)

    @_builtins.property
    @pulumi.getter(name="vpcAuthMode")
    def vpc_auth_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only meaningful if instance_type is `Redis` and network type is VPC. Valid values: `Close`, `Open`. Default value: `Open`. `Close` means the redis instance can be accessed without authentication. `Open` means authentication is required.
        """
        return pulumi.get(self, "vpc_auth_mode")

    @vpc_auth_mode.setter
    def vpc_auth_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_auth_mode", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 business_info: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 connection_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 coupon_no: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_name: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_release_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_auto_upgrade_open: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 order_type: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_connection_port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 qps: Optional[pulumi.Input[_builtins.int]] = None,
                 read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 slave_read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 srcdb_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to renewal a KVStore DBInstance automatically or not. It is valid when payment_type is `PrePaid`. Default value: `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an KVStore DBInstance, in the unit of the month. It is valid when payment_type is `PrePaid`. Valid values: [1~12]. Default value: `1`.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Specifies whether to use a coupon. Default value: `false`.
        :param pulumi.Input[_builtins.str] availability_zone: It has been deprecated from provider version 1.101.0 and `zone_id` instead.
        :param pulumi.Input[_builtins.str] backup_id: The ID of the backup file of the source instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_periods: Backup period.
        :param pulumi.Input[_builtins.str] backup_time: Backup time, the format is HH:mmZ-HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.int] bandwidth: The total bandwidth of the instance. **NOTE:** From version 1.232.0, `bandwidth` can be set. If the instance is a cluster instance, `bandwidth` must be divisible by the number of `shard_count` in the instance, and if the instance is a read/write splitting instance, `bandwidth` cannot be set.
        :param pulumi.Input[_builtins.str] business_info: The ID of the event or the business information.
        :param pulumi.Input[_builtins.int] capacity: The storage capacity of the KVStore DBInstance. Unit: MB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
        :param pulumi.Input[_builtins.str] connection_domain: Intranet connection address of the KVStore instance.
        :param pulumi.Input[_builtins.str] connection_string: Indicates whether the address is a private endpoint.
        :param pulumi.Input[_builtins.str] connection_string_prefix: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] coupon_no: The coupon code. **NOTE:** The default value `youhuiquan_promotion_option_id_for_blank` removed since v1.216.0, this can cause your status file to change even if it has not been modified, so please review your change plan before apply change plan.
        :param pulumi.Input[_builtins.str] db_instance_name: The name of KVStore DBInstance. It is a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of the dedicated cluster. This parameter is required when you create a Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance in a dedicated cluster.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to precheck the request. Valid values:
        :param pulumi.Input[_builtins.str] effective_time: The time when the database is switched after the instance is migrated, or when the major version is upgraded, or when the instance class is upgraded. Valid values:
               - `Immediately` (Default): The configurations are immediately changed.
               - `MaintainTime`: The configurations are changed within the maintenance window. You can set `maintain_start_time` and `maintain_end_time` to change the maintenance window.
        :param pulumi.Input[_builtins.int] enable_backup_log: Turn on or off incremental backup. Valid values: `1`, `0`. Default value: `0`
        :param pulumi.Input[_builtins.bool] enable_public: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] encryption_key: The Custom key ID, which you can get by calling DescribeEncryptionKeyList.If this parameter is not passed, the key is automatically generated by the key management service. To create a custom key, you can call the CreateKey interface of the key management service.
        :param pulumi.Input[_builtins.str] encryption_name: The Encryption algorithm, default AES-CTR-256.Note that this parameter is only available when the TDEStatus parameter is Enabled.
        :param pulumi.Input[_builtins.str] end_time: The expiration time of the prepaid instance.
        :param pulumi.Input[_builtins.str] engine_version: The engine version of the KVStore DBInstance. Valid values: ["2.8", "4.0", "5.0", "6.0", "7.0"]. Default value: `5.0`.
               **NOTE:** When `instance_type = Memcache`, the `engine_version` only supports "4.0".
        :param pulumi.Input[_builtins.bool] force_upgrade: Specifies whether to forcibly change the type. Default value: `true`.
        :param pulumi.Input[_builtins.bool] global_instance: Whether to create a distributed cache. Default value: `false`.
        :param pulumi.Input[_builtins.str] global_instance_id: The ID of distributed cache.
        :param pulumi.Input[_builtins.str] instance_charge_type: It has been deprecated from provider version 1.101.0 and `payment_type` instead.
        :param pulumi.Input[_builtins.str] instance_class: Type of the applied Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance. It can be retrieved by data source kvstore_get_instance_classes
               or referring to help-docs [Instance type table](https://www.alibabacloud.com/help/doc-detail/26350.htm).
        :param pulumi.Input[_builtins.str] instance_name: It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
        :param pulumi.Input[_builtins.bool] instance_release_protection: Whether to open the release protection.
        :param pulumi.Input[_builtins.str] instance_type: The engine type of the KVStore DBInstance. Valid values: `Redis` or `Memcache`. Default value: `Redis`.
        :param pulumi.Input[_builtins.str] is_auto_upgrade_open: Specifies whether to enable automatic minor version update. Valid values:
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] node_type: Node type, valid values:
               - `MASTER_SLAVE`: High availability (dual copies)
               - `STAND_ALONE`: Single copy
        :param pulumi.Input[_builtins.str] order_type: Specifies a change type when you change the configuration of a subscription instance. Valid values: `UPGRADE`, `DOWNGRADE`. Default value: `UPGRADE`. `UPGRADE` means upgrades the configuration of a subscription instance. `DOWNGRADE` means downgrades the configuration of a subscription instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]] parameters: It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
        :param pulumi.Input[_builtins.str] password: The password of the KVStore DBInstance. The password that is used to connect to the instance. The password must be 8 to 32 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, special characters, and digits. Special characters include: `! @ # $ % ^ & * ( ) _ + - =`
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the KVStore DBInstance. Valid values: `PrePaid`, `PostPaid`. Default value: `PostPaid`.
        :param pulumi.Input[_builtins.str] period: The duration that you will buy KVStore DBInstance (in month). It is valid when payment_type is `PrePaid`. Valid values: `[1~9]`, `12`, `24`, `36`.
        :param pulumi.Input[_builtins.int] port: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] private_connection_port: Private network connection port, used to modify the private network connection port.
        :param pulumi.Input[_builtins.str] private_connection_prefix: Private network connection prefix, used to modify the private network connection address. Only supports updating private network connections for existing instance.
        :param pulumi.Input[_builtins.str] private_ip: The internal IP address of the instance.
        :param pulumi.Input[_builtins.int] qps: Theoretical maximum QPS value.
        :param pulumi.Input[_builtins.int] read_only_count: The number of read replicas in the primary zone. Valid values: `1` to `9`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of resource group which the resource belongs.
        :param pulumi.Input[_builtins.str] restore_time: The point in time of a backup file.
        :param pulumi.Input[_builtins.str] role_arn: The Specify the global resource descriptor ARN (Alibaba Cloud Resource Name) information of the role to be authorized, and use the related key management services after the authorization is completed, in the format: `acs:ram::$accountID:role/$roleName`.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary zone to which you want to migrate the Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance.
               > **NOTE:** If you specify this parameter, the master node and replica node of the instance can be deployed in different zones and disaster recovery is implemented across zones. The instance can withstand failures in data centers.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of security groups. Separate multiple security group IDs with commas (,), such as `sg-***,sg-***,sg-***`.
        :param pulumi.Input[_builtins.str] security_ip_group_attribute: The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
        :param pulumi.Input[_builtins.str] security_ip_group_name: The name of the whitelist group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
        :param pulumi.Input[_builtins.int] shard_count: The number of data shards. This parameter is available only if you create a cluster instance that uses cloud disks. You can use this parameter to specify a custom number of data shards. **NOTE:** From version 1.216.0, `shard_count` can be modified.
        :param pulumi.Input[_builtins.int] slave_read_only_count: The number of read replicas in the secondary zone. **NOTE:**: When you create a multi-zone read/write splitting instance, you must specify both `secondary_zone_id` and `slave_read_only_count`.
               > **NOTE:** The sum of `read_only_count` and `slave_read_only_count` cannot be greater than `9`.
        :param pulumi.Input[_builtins.str] srcdb_instance_id: The ID of the source instance.
        :param pulumi.Input[_builtins.str] ssl_enable: Modifies the SSL status. Valid values: `Disable`, `Enable` and `Update`.
               **NOTE:** This functionality is supported by Cluster mode (Redis 2.8, 4.0, 5.0) and Standard mode( Redis 2.8 only).
        :param pulumi.Input[_builtins.str] status: The status of KVStore DBInstance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] tde_status: Specifies whether to enable TDE. Valid values: `Enabled`.
               **NOTE:**: TDE cannot be disabled after it is enabled. Before you enable it, evaluate whether this feature affects.
               your business. For more information, see [Enable TDE](https://www.alibabacloud.com/help/en/redis/user-guide/enable-tde).
        :param pulumi.Input[_builtins.str] vpc_auth_mode: Only meaningful if instance_type is `Redis` and network type is VPC. Valid values: `Close`, `Open`. Default value: `Open`. `Close` means the redis instance can be accessed without authentication. `Open` means authentication is required.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of VSwitch.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if auto_use_coupon is not None:
            pulumi.set(__self__, "auto_use_coupon", auto_use_coupon)
        if availability_zone is not None:
            warnings.warn("""Field 'availability_zone' has been deprecated from version 1.101.0. Use 'zone_id' instead.""", DeprecationWarning)
            pulumi.log.warn("""availability_zone is deprecated: Field 'availability_zone' has been deprecated from version 1.101.0. Use 'zone_id' instead.""")
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if backup_periods is not None:
            pulumi.set(__self__, "backup_periods", backup_periods)
        if backup_time is not None:
            pulumi.set(__self__, "backup_time", backup_time)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if business_info is not None:
            pulumi.set(__self__, "business_info", business_info)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if connection_domain is not None:
            pulumi.set(__self__, "connection_domain", connection_domain)
        if connection_string is not None:
            warnings.warn("""Field 'connection_string' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""", DeprecationWarning)
            pulumi.log.warn("""connection_string is deprecated: Field 'connection_string' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_string_prefix is not None:
            warnings.warn("""Field 'connection_string_prefix' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""", DeprecationWarning)
            pulumi.log.warn("""connection_string_prefix is deprecated: Field 'connection_string_prefix' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if coupon_no is not None:
            pulumi.set(__self__, "coupon_no", coupon_no)
        if db_instance_name is not None:
            pulumi.set(__self__, "db_instance_name", db_instance_name)
        if dedicated_host_group_id is not None:
            pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if enable_backup_log is not None:
            pulumi.set(__self__, "enable_backup_log", enable_backup_log)
        if enable_public is not None:
            warnings.warn("""Field 'enable_public' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""", DeprecationWarning)
            pulumi.log.warn("""enable_public is deprecated: Field 'enable_public' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
        if enable_public is not None:
            pulumi.set(__self__, "enable_public", enable_public)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_name is not None:
            pulumi.set(__self__, "encryption_name", encryption_name)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force_upgrade is not None:
            pulumi.set(__self__, "force_upgrade", force_upgrade)
        if global_instance is not None:
            pulumi.set(__self__, "global_instance", global_instance)
        if global_instance_id is not None:
            pulumi.set(__self__, "global_instance_id", global_instance_id)
        if instance_charge_type is not None:
            warnings.warn("""Field 'instance_charge_type' has been deprecated from version 1.101.0. Use 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated from version 1.101.0. Use 'payment_type' instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if instance_name is not None:
            warnings.warn("""Field `instance_name` has been deprecated from version 1.101.0. Use `db_instance_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_name is deprecated: Field `instance_name` has been deprecated from version 1.101.0. Use `db_instance_name` instead.""")
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_release_protection is not None:
            pulumi.set(__self__, "instance_release_protection", instance_release_protection)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if is_auto_upgrade_open is not None:
            pulumi.set(__self__, "is_auto_upgrade_open", is_auto_upgrade_open)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if maintain_end_time is not None:
            pulumi.set(__self__, "maintain_end_time", maintain_end_time)
        if maintain_start_time is not None:
            pulumi.set(__self__, "maintain_start_time", maintain_start_time)
        if node_type is not None:
            warnings.warn("""Field 'node_type' has been deprecated from version 1.120.1""", DeprecationWarning)
            pulumi.log.warn("""node_type is deprecated: Field 'node_type' has been deprecated from version 1.120.1""")
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if order_type is not None:
            pulumi.set(__self__, "order_type", order_type)
        if parameters is not None:
            warnings.warn("""Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.""", DeprecationWarning)
            pulumi.log.warn("""parameters is deprecated: Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.""")
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_connection_port is not None:
            pulumi.set(__self__, "private_connection_port", private_connection_port)
        if private_connection_prefix is not None:
            pulumi.set(__self__, "private_connection_prefix", private_connection_prefix)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if qps is not None:
            pulumi.set(__self__, "qps", qps)
        if read_only_count is not None:
            pulumi.set(__self__, "read_only_count", read_only_count)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restore_time is not None:
            pulumi.set(__self__, "restore_time", restore_time)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if secondary_zone_id is not None:
            pulumi.set(__self__, "secondary_zone_id", secondary_zone_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_ip_group_attribute is not None:
            pulumi.set(__self__, "security_ip_group_attribute", security_ip_group_attribute)
        if security_ip_group_name is not None:
            pulumi.set(__self__, "security_ip_group_name", security_ip_group_name)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if slave_read_only_count is not None:
            pulumi.set(__self__, "slave_read_only_count", slave_read_only_count)
        if srcdb_instance_id is not None:
            pulumi.set(__self__, "srcdb_instance_id", srcdb_instance_id)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tde_status is not None:
            pulumi.set(__self__, "tde_status", tde_status)
        if vpc_auth_mode is not None:
            pulumi.set(__self__, "vpc_auth_mode", vpc_auth_mode)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to renewal a KVStore DBInstance automatically or not. It is valid when payment_type is `PrePaid`. Default value: `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto-renewal period of an KVStore DBInstance, in the unit of the month. It is valid when payment_type is `PrePaid`. Valid values: [1~12]. Default value: `1`.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use a coupon. Default value: `false`.
        """
        return pulumi.get(self, "auto_use_coupon")

    @auto_use_coupon.setter
    def auto_use_coupon(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_use_coupon", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    @_utilities.deprecated("""Field 'availability_zone' has been deprecated from version 1.101.0. Use 'zone_id' instead.""")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from provider version 1.101.0 and `zone_id` instead.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the backup file of the source instance.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter(name="backupPeriods")
    def backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Backup period.
        """
        return pulumi.get(self, "backup_periods")

    @backup_periods.setter
    def backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "backup_periods", value)

    @_builtins.property
    @pulumi.getter(name="backupTime")
    def backup_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup time, the format is HH:mmZ-HH:mmZ (UTC time).
        """
        return pulumi.get(self, "backup_time")

    @backup_time.setter
    def backup_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_time", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total bandwidth of the instance. **NOTE:** From version 1.232.0, `bandwidth` can be set. If the instance is a cluster instance, `bandwidth` must be divisible by the number of `shard_count` in the instance, and if the instance is a read/write splitting instance, `bandwidth` cannot be set.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="businessInfo")
    def business_info(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the event or the business information.
        """
        return pulumi.get(self, "business_info")

    @business_info.setter
    def business_info(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "business_info", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The storage capacity of the KVStore DBInstance. Unit: MB.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="connectionDomain")
    def connection_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Intranet connection address of the KVStore instance.
        """
        return pulumi.get(self, "connection_domain")

    @connection_domain.setter
    def connection_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_domain", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    @_utilities.deprecated("""Field 'connection_string' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the address is a private endpoint.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    @_utilities.deprecated("""Field 'connection_string_prefix' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
    def connection_string_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="couponNo")
    def coupon_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The coupon code. **NOTE:** The default value `youhuiquan_promotion_option_id_for_blank` removed since v1.216.0, this can cause your status file to change even if it has not been modified, so please review your change plan before apply change plan.
        """
        return pulumi.get(self, "coupon_no")

    @coupon_no.setter
    def coupon_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "coupon_no", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceName")
    def db_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of KVStore DBInstance. It is a string of 2 to 256 characters.
        """
        return pulumi.get(self, "db_instance_name")

    @db_instance_name.setter
    def db_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated cluster. This parameter is required when you create a Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance in a dedicated cluster.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @dedicated_host_group_id.setter
    def dedicated_host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_host_group_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to precheck the request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the database is switched after the instance is migrated, or when the major version is upgraded, or when the instance class is upgraded. Valid values:
        - `Immediately` (Default): The configurations are immediately changed.
        - `MaintainTime`: The configurations are changed within the maintenance window. You can set `maintain_start_time` and `maintain_end_time` to change the maintenance window.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="enableBackupLog")
    def enable_backup_log(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Turn on or off incremental backup. Valid values: `1`, `0`. Default value: `0`
        """
        return pulumi.get(self, "enable_backup_log")

    @enable_backup_log.setter
    def enable_backup_log(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "enable_backup_log", value)

    @_builtins.property
    @pulumi.getter(name="enablePublic")
    @_utilities.deprecated("""Field 'enable_public' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
    def enable_public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        """
        return pulumi.get(self, "enable_public")

    @enable_public.setter
    def enable_public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Custom key ID, which you can get by calling DescribeEncryptionKeyList.If this parameter is not passed, the key is automatically generated by the key management service. To create a custom key, you can call the CreateKey interface of the key management service.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="encryptionName")
    def encryption_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Encryption algorithm, default AES-CTR-256.Note that this parameter is only available when the TDEStatus parameter is Enabled.
        """
        return pulumi.get(self, "encryption_name")

    @encryption_name.setter
    def encryption_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_name", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of the prepaid instance.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The engine version of the KVStore DBInstance. Valid values: ["2.8", "4.0", "5.0", "6.0", "7.0"]. Default value: `5.0`.
        **NOTE:** When `instance_type = Memcache`, the `engine_version` only supports "4.0".
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="forceUpgrade")
    def force_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcibly change the type. Default value: `true`.
        """
        return pulumi.get(self, "force_upgrade")

    @force_upgrade.setter
    def force_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="globalInstance")
    def global_instance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create a distributed cache. Default value: `false`.
        """
        return pulumi.get(self, "global_instance")

    @global_instance.setter
    def global_instance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "global_instance", value)

    @_builtins.property
    @pulumi.getter(name="globalInstanceId")
    def global_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of distributed cache.
        """
        return pulumi.get(self, "global_instance_id")

    @global_instance_id.setter
    def global_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated from version 1.101.0. Use 'payment_type' instead.""")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from provider version 1.101.0 and `payment_type` instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the applied Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance. It can be retrieved by data source kvstore_get_instance_classes
        or referring to help-docs [Instance type table](https://www.alibabacloud.com/help/doc-detail/26350.htm).
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    @_utilities.deprecated("""Field `instance_name` has been deprecated from version 1.101.0. Use `db_instance_name` instead.""")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceReleaseProtection")
    def instance_release_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to open the release protection.
        """
        return pulumi.get(self, "instance_release_protection")

    @instance_release_protection.setter
    def instance_release_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "instance_release_protection", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The engine type of the KVStore DBInstance. Valid values: `Redis` or `Memcache`. Default value: `Redis`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="isAutoUpgradeOpen")
    def is_auto_upgrade_open(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable automatic minor version update. Valid values:
        """
        return pulumi.get(self, "is_auto_upgrade_open")

    @is_auto_upgrade_open.setter
    def is_auto_upgrade_open(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_auto_upgrade_open", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_end_time")

    @maintain_end_time.setter
    def maintain_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end_time", value)

    @_builtins.property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_start_time")

    @maintain_start_time.setter
    def maintain_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_start_time", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    @_utilities.deprecated("""Field 'node_type' has been deprecated from version 1.120.1""")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node type, valid values:
        - `MASTER_SLAVE`: High availability (dual copies)
        - `STAND_ALONE`: Single copy
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="orderType")
    def order_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a change type when you change the configuration of a subscription instance. Valid values: `UPGRADE`, `DOWNGRADE`. Default value: `UPGRADE`. `UPGRADE` means upgrades the configuration of a subscription instance. `DOWNGRADE` means downgrades the configuration of a subscription instance.
        """
        return pulumi.get(self, "order_type")

    @order_type.setter
    def order_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "order_type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.""")
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]:
        """
        It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the KVStore DBInstance. The password that is used to connect to the instance. The password must be 8 to 32 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, special characters, and digits. Special characters include: `! @ # $ % ^ & * ( ) _ + - =`
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the KVStore DBInstance. Valid values: `PrePaid`, `PostPaid`. Default value: `PostPaid`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The duration that you will buy KVStore DBInstance (in month). It is valid when payment_type is `PrePaid`. Valid values: `[1~9]`, `12`, `24`, `36`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="privateConnectionPort")
    def private_connection_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private network connection port, used to modify the private network connection port.
        """
        return pulumi.get(self, "private_connection_port")

    @private_connection_port.setter
    def private_connection_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_connection_port", value)

    @_builtins.property
    @pulumi.getter(name="privateConnectionPrefix")
    def private_connection_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private network connection prefix, used to modify the private network connection address. Only supports updating private network connections for existing instance.
        """
        return pulumi.get(self, "private_connection_prefix")

    @private_connection_prefix.setter
    def private_connection_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_connection_prefix", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal IP address of the instance.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter
    def qps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Theoretical maximum QPS value.
        """
        return pulumi.get(self, "qps")

    @qps.setter
    def qps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "qps", value)

    @_builtins.property
    @pulumi.getter(name="readOnlyCount")
    def read_only_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of read replicas in the primary zone. Valid values: `1` to `9`.
        """
        return pulumi.get(self, "read_only_count")

    @read_only_count.setter
    def read_only_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_only_count", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of resource group which the resource belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time of a backup file.
        """
        return pulumi.get(self, "restore_time")

    @restore_time.setter
    def restore_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "restore_time", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Specify the global resource descriptor ARN (Alibaba Cloud Resource Name) information of the role to be authorized, and use the related key management services after the authorization is completed, in the format: `acs:ram::$accountID:role/$roleName`.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the secondary zone to which you want to migrate the Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance.
        > **NOTE:** If you specify this parameter, the master node and replica node of the instance can be deployed in different zones and disaster recovery is implemented across zones. The instance can withstand failures in data centers.
        """
        return pulumi.get(self, "secondary_zone_id")

    @secondary_zone_id.setter
    def secondary_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of security groups. Separate multiple security group IDs with commas (,), such as `sg-***,sg-***,sg-***`.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityIpGroupAttribute")
    def security_ip_group_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
        """
        return pulumi.get(self, "security_ip_group_attribute")

    @security_ip_group_attribute.setter
    def security_ip_group_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_group_attribute", value)

    @_builtins.property
    @pulumi.getter(name="securityIpGroupName")
    def security_ip_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the whitelist group.
        """
        return pulumi.get(self, "security_ip_group_name")

    @security_ip_group_name.setter
    def security_ip_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_ips", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of data shards. This parameter is available only if you create a cluster instance that uses cloud disks. You can use this parameter to specify a custom number of data shards. **NOTE:** From version 1.216.0, `shard_count` can be modified.
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="slaveReadOnlyCount")
    def slave_read_only_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of read replicas in the secondary zone. **NOTE:**: When you create a multi-zone read/write splitting instance, you must specify both `secondary_zone_id` and `slave_read_only_count`.
        > **NOTE:** The sum of `read_only_count` and `slave_read_only_count` cannot be greater than `9`.
        """
        return pulumi.get(self, "slave_read_only_count")

    @slave_read_only_count.setter
    def slave_read_only_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slave_read_only_count", value)

    @_builtins.property
    @pulumi.getter(name="srcdbInstanceId")
    def srcdb_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the source instance.
        """
        return pulumi.get(self, "srcdb_instance_id")

    @srcdb_instance_id.setter
    def srcdb_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "srcdb_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Modifies the SSL status. Valid values: `Disable`, `Enable` and `Update`.
        **NOTE:** This functionality is supported by Cluster mode (Redis 2.8, 4.0, 5.0) and Standard mode( Redis 2.8 only).
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of KVStore DBInstance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable TDE. Valid values: `Enabled`.
        **NOTE:**: TDE cannot be disabled after it is enabled. Before you enable it, evaluate whether this feature affects.
        your business. For more information, see [Enable TDE](https://www.alibabacloud.com/help/en/redis/user-guide/enable-tde).
        """
        return pulumi.get(self, "tde_status")

    @tde_status.setter
    def tde_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tde_status", value)

    @_builtins.property
    @pulumi.getter(name="vpcAuthMode")
    def vpc_auth_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only meaningful if instance_type is `Redis` and network type is VPC. Valid values: `Close`, `Open`. Default value: `Open`. `Close` means the redis instance can be accessed without authentication. `Open` means authentication is required.
        """
        return pulumi.get(self, "vpc_auth_mode")

    @vpc_auth_mode.setter
    def vpc_auth_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_auth_mode", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:kvstore/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 business_info: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 coupon_no: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_release_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_auto_upgrade_open: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 order_type: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_connection_port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 slave_read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 srcdb_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        KVStore instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kvstore/instance:Instance example r-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to renewal a KVStore DBInstance automatically or not. It is valid when payment_type is `PrePaid`. Default value: `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an KVStore DBInstance, in the unit of the month. It is valid when payment_type is `PrePaid`. Valid values: [1~12]. Default value: `1`.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Specifies whether to use a coupon. Default value: `false`.
        :param pulumi.Input[_builtins.str] availability_zone: It has been deprecated from provider version 1.101.0 and `zone_id` instead.
        :param pulumi.Input[_builtins.str] backup_id: The ID of the backup file of the source instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_periods: Backup period.
        :param pulumi.Input[_builtins.str] backup_time: Backup time, the format is HH:mmZ-HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.int] bandwidth: The total bandwidth of the instance. **NOTE:** From version 1.232.0, `bandwidth` can be set. If the instance is a cluster instance, `bandwidth` must be divisible by the number of `shard_count` in the instance, and if the instance is a read/write splitting instance, `bandwidth` cannot be set.
        :param pulumi.Input[_builtins.str] business_info: The ID of the event or the business information.
        :param pulumi.Input[_builtins.int] capacity: The storage capacity of the KVStore DBInstance. Unit: MB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
        :param pulumi.Input[_builtins.str] connection_string_prefix: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] coupon_no: The coupon code. **NOTE:** The default value `youhuiquan_promotion_option_id_for_blank` removed since v1.216.0, this can cause your status file to change even if it has not been modified, so please review your change plan before apply change plan.
        :param pulumi.Input[_builtins.str] db_instance_name: The name of KVStore DBInstance. It is a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of the dedicated cluster. This parameter is required when you create a Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance in a dedicated cluster.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to precheck the request. Valid values:
        :param pulumi.Input[_builtins.str] effective_time: The time when the database is switched after the instance is migrated, or when the major version is upgraded, or when the instance class is upgraded. Valid values:
               - `Immediately` (Default): The configurations are immediately changed.
               - `MaintainTime`: The configurations are changed within the maintenance window. You can set `maintain_start_time` and `maintain_end_time` to change the maintenance window.
        :param pulumi.Input[_builtins.int] enable_backup_log: Turn on or off incremental backup. Valid values: `1`, `0`. Default value: `0`
        :param pulumi.Input[_builtins.bool] enable_public: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] encryption_key: The Custom key ID, which you can get by calling DescribeEncryptionKeyList.If this parameter is not passed, the key is automatically generated by the key management service. To create a custom key, you can call the CreateKey interface of the key management service.
        :param pulumi.Input[_builtins.str] encryption_name: The Encryption algorithm, default AES-CTR-256.Note that this parameter is only available when the TDEStatus parameter is Enabled.
        :param pulumi.Input[_builtins.str] engine_version: The engine version of the KVStore DBInstance. Valid values: ["2.8", "4.0", "5.0", "6.0", "7.0"]. Default value: `5.0`.
               **NOTE:** When `instance_type = Memcache`, the `engine_version` only supports "4.0".
        :param pulumi.Input[_builtins.bool] force_upgrade: Specifies whether to forcibly change the type. Default value: `true`.
        :param pulumi.Input[_builtins.bool] global_instance: Whether to create a distributed cache. Default value: `false`.
        :param pulumi.Input[_builtins.str] global_instance_id: The ID of distributed cache.
        :param pulumi.Input[_builtins.str] instance_charge_type: It has been deprecated from provider version 1.101.0 and `payment_type` instead.
        :param pulumi.Input[_builtins.str] instance_class: Type of the applied Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance. It can be retrieved by data source kvstore_get_instance_classes
               or referring to help-docs [Instance type table](https://www.alibabacloud.com/help/doc-detail/26350.htm).
        :param pulumi.Input[_builtins.str] instance_name: It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
        :param pulumi.Input[_builtins.bool] instance_release_protection: Whether to open the release protection.
        :param pulumi.Input[_builtins.str] instance_type: The engine type of the KVStore DBInstance. Valid values: `Redis` or `Memcache`. Default value: `Redis`.
        :param pulumi.Input[_builtins.str] is_auto_upgrade_open: Specifies whether to enable automatic minor version update. Valid values:
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] node_type: Node type, valid values:
               - `MASTER_SLAVE`: High availability (dual copies)
               - `STAND_ALONE`: Single copy
        :param pulumi.Input[_builtins.str] order_type: Specifies a change type when you change the configuration of a subscription instance. Valid values: `UPGRADE`, `DOWNGRADE`. Default value: `UPGRADE`. `UPGRADE` means upgrades the configuration of a subscription instance. `DOWNGRADE` means downgrades the configuration of a subscription instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]] parameters: It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
        :param pulumi.Input[_builtins.str] password: The password of the KVStore DBInstance. The password that is used to connect to the instance. The password must be 8 to 32 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, special characters, and digits. Special characters include: `! @ # $ % ^ & * ( ) _ + - =`
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the KVStore DBInstance. Valid values: `PrePaid`, `PostPaid`. Default value: `PostPaid`.
        :param pulumi.Input[_builtins.str] period: The duration that you will buy KVStore DBInstance (in month). It is valid when payment_type is `PrePaid`. Valid values: `[1~9]`, `12`, `24`, `36`.
        :param pulumi.Input[_builtins.int] port: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] private_connection_port: Private network connection port, used to modify the private network connection port.
        :param pulumi.Input[_builtins.str] private_connection_prefix: Private network connection prefix, used to modify the private network connection address. Only supports updating private network connections for existing instance.
        :param pulumi.Input[_builtins.str] private_ip: The internal IP address of the instance.
        :param pulumi.Input[_builtins.int] read_only_count: The number of read replicas in the primary zone. Valid values: `1` to `9`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of resource group which the resource belongs.
        :param pulumi.Input[_builtins.str] restore_time: The point in time of a backup file.
        :param pulumi.Input[_builtins.str] role_arn: The Specify the global resource descriptor ARN (Alibaba Cloud Resource Name) information of the role to be authorized, and use the related key management services after the authorization is completed, in the format: `acs:ram::$accountID:role/$roleName`.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary zone to which you want to migrate the Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance.
               > **NOTE:** If you specify this parameter, the master node and replica node of the instance can be deployed in different zones and disaster recovery is implemented across zones. The instance can withstand failures in data centers.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of security groups. Separate multiple security group IDs with commas (,), such as `sg-***,sg-***,sg-***`.
        :param pulumi.Input[_builtins.str] security_ip_group_attribute: The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
        :param pulumi.Input[_builtins.str] security_ip_group_name: The name of the whitelist group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
        :param pulumi.Input[_builtins.int] shard_count: The number of data shards. This parameter is available only if you create a cluster instance that uses cloud disks. You can use this parameter to specify a custom number of data shards. **NOTE:** From version 1.216.0, `shard_count` can be modified.
        :param pulumi.Input[_builtins.int] slave_read_only_count: The number of read replicas in the secondary zone. **NOTE:**: When you create a multi-zone read/write splitting instance, you must specify both `secondary_zone_id` and `slave_read_only_count`.
               > **NOTE:** The sum of `read_only_count` and `slave_read_only_count` cannot be greater than `9`.
        :param pulumi.Input[_builtins.str] srcdb_instance_id: The ID of the source instance.
        :param pulumi.Input[_builtins.str] ssl_enable: Modifies the SSL status. Valid values: `Disable`, `Enable` and `Update`.
               **NOTE:** This functionality is supported by Cluster mode (Redis 2.8, 4.0, 5.0) and Standard mode( Redis 2.8 only).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] tde_status: Specifies whether to enable TDE. Valid values: `Enabled`.
               **NOTE:**: TDE cannot be disabled after it is enabled. Before you enable it, evaluate whether this feature affects.
               your business. For more information, see [Enable TDE](https://www.alibabacloud.com/help/en/redis/user-guide/enable-tde).
        :param pulumi.Input[_builtins.str] vpc_auth_mode: Only meaningful if instance_type is `Redis` and network type is VPC. Valid values: `Close`, `Open`. Default value: `Open`. `Close` means the redis instance can be accessed without authentication. `Open` means authentication is required.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of VSwitch.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        KVStore instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kvstore/instance:Instance example r-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_time: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 business_info: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 coupon_no: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_backup_log: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_release_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_auto_upgrade_open: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 order_type: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_connection_port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 slave_read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
                 srcdb_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["auto_use_coupon"] = auto_use_coupon
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_id"] = backup_id
            __props__.__dict__["backup_periods"] = backup_periods
            __props__.__dict__["backup_time"] = backup_time
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["business_info"] = business_info
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["config"] = config
            __props__.__dict__["connection_string_prefix"] = connection_string_prefix
            __props__.__dict__["coupon_no"] = coupon_no
            __props__.__dict__["db_instance_name"] = db_instance_name
            __props__.__dict__["dedicated_host_group_id"] = dedicated_host_group_id
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["effective_time"] = effective_time
            __props__.__dict__["enable_backup_log"] = enable_backup_log
            __props__.__dict__["enable_public"] = enable_public
            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["encryption_name"] = encryption_name
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["force_upgrade"] = force_upgrade
            __props__.__dict__["global_instance"] = global_instance
            __props__.__dict__["global_instance_id"] = global_instance_id
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_release_protection"] = instance_release_protection
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["is_auto_upgrade_open"] = is_auto_upgrade_open
            __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["maintain_end_time"] = maintain_end_time
            __props__.__dict__["maintain_start_time"] = maintain_start_time
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["order_type"] = order_type
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["port"] = port
            __props__.__dict__["private_connection_port"] = private_connection_port
            __props__.__dict__["private_connection_prefix"] = private_connection_prefix
            __props__.__dict__["private_ip"] = private_ip
            __props__.__dict__["read_only_count"] = read_only_count
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["restore_time"] = restore_time
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["secondary_zone_id"] = secondary_zone_id
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_ip_group_attribute"] = security_ip_group_attribute
            __props__.__dict__["security_ip_group_name"] = security_ip_group_name
            __props__.__dict__["security_ips"] = security_ips
            __props__.__dict__["shard_count"] = shard_count
            __props__.__dict__["slave_read_only_count"] = slave_read_only_count
            __props__.__dict__["srcdb_instance_id"] = srcdb_instance_id
            __props__.__dict__["ssl_enable"] = ssl_enable
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tde_status"] = tde_status
            __props__.__dict__["vpc_auth_mode"] = vpc_auth_mode
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["connection_domain"] = None
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["qps"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'alicloud:kvstore/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            auto_use_coupon: Optional[pulumi.Input[_builtins.bool]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            backup_id: Optional[pulumi.Input[_builtins.str]] = None,
            backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backup_time: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            business_info: Optional[pulumi.Input[_builtins.str]] = None,
            capacity: Optional[pulumi.Input[_builtins.int]] = None,
            config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            connection_domain: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            coupon_no: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            effective_time: Optional[pulumi.Input[_builtins.str]] = None,
            enable_backup_log: Optional[pulumi.Input[_builtins.int]] = None,
            enable_public: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_name: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            force_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
            global_instance: Optional[pulumi.Input[_builtins.bool]] = None,
            global_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_class: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_release_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            is_auto_upgrade_open: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            maintain_end_time: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            node_type: Optional[pulumi.Input[_builtins.str]] = None,
            order_type: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            private_connection_port: Optional[pulumi.Input[_builtins.str]] = None,
            private_connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            qps: Optional[pulumi.Input[_builtins.int]] = None,
            read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            restore_time: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_ip_group_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            security_ip_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            shard_count: Optional[pulumi.Input[_builtins.int]] = None,
            slave_read_only_count: Optional[pulumi.Input[_builtins.int]] = None,
            srcdb_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_enable: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tde_status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to renewal a KVStore DBInstance automatically or not. It is valid when payment_type is `PrePaid`. Default value: `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an KVStore DBInstance, in the unit of the month. It is valid when payment_type is `PrePaid`. Valid values: [1~12]. Default value: `1`.
        :param pulumi.Input[_builtins.bool] auto_use_coupon: Specifies whether to use a coupon. Default value: `false`.
        :param pulumi.Input[_builtins.str] availability_zone: It has been deprecated from provider version 1.101.0 and `zone_id` instead.
        :param pulumi.Input[_builtins.str] backup_id: The ID of the backup file of the source instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] backup_periods: Backup period.
        :param pulumi.Input[_builtins.str] backup_time: Backup time, the format is HH:mmZ-HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.int] bandwidth: The total bandwidth of the instance. **NOTE:** From version 1.232.0, `bandwidth` can be set. If the instance is a cluster instance, `bandwidth` must be divisible by the number of `shard_count` in the instance, and if the instance is a read/write splitting instance, `bandwidth` cannot be set.
        :param pulumi.Input[_builtins.str] business_info: The ID of the event or the business information.
        :param pulumi.Input[_builtins.int] capacity: The storage capacity of the KVStore DBInstance. Unit: MB.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] config: The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
        :param pulumi.Input[_builtins.str] connection_domain: Intranet connection address of the KVStore instance.
        :param pulumi.Input[_builtins.str] connection_string: Indicates whether the address is a private endpoint.
        :param pulumi.Input[_builtins.str] connection_string_prefix: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] coupon_no: The coupon code. **NOTE:** The default value `youhuiquan_promotion_option_id_for_blank` removed since v1.216.0, this can cause your status file to change even if it has not been modified, so please review your change plan before apply change plan.
        :param pulumi.Input[_builtins.str] db_instance_name: The name of KVStore DBInstance. It is a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of the dedicated cluster. This parameter is required when you create a Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance in a dedicated cluster.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to precheck the request. Valid values:
        :param pulumi.Input[_builtins.str] effective_time: The time when the database is switched after the instance is migrated, or when the major version is upgraded, or when the instance class is upgraded. Valid values:
               - `Immediately` (Default): The configurations are immediately changed.
               - `MaintainTime`: The configurations are changed within the maintenance window. You can set `maintain_start_time` and `maintain_end_time` to change the maintenance window.
        :param pulumi.Input[_builtins.int] enable_backup_log: Turn on or off incremental backup. Valid values: `1`, `0`. Default value: `0`
        :param pulumi.Input[_builtins.bool] enable_public: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] encryption_key: The Custom key ID, which you can get by calling DescribeEncryptionKeyList.If this parameter is not passed, the key is automatically generated by the key management service. To create a custom key, you can call the CreateKey interface of the key management service.
        :param pulumi.Input[_builtins.str] encryption_name: The Encryption algorithm, default AES-CTR-256.Note that this parameter is only available when the TDEStatus parameter is Enabled.
        :param pulumi.Input[_builtins.str] end_time: The expiration time of the prepaid instance.
        :param pulumi.Input[_builtins.str] engine_version: The engine version of the KVStore DBInstance. Valid values: ["2.8", "4.0", "5.0", "6.0", "7.0"]. Default value: `5.0`.
               **NOTE:** When `instance_type = Memcache`, the `engine_version` only supports "4.0".
        :param pulumi.Input[_builtins.bool] force_upgrade: Specifies whether to forcibly change the type. Default value: `true`.
        :param pulumi.Input[_builtins.bool] global_instance: Whether to create a distributed cache. Default value: `false`.
        :param pulumi.Input[_builtins.str] global_instance_id: The ID of distributed cache.
        :param pulumi.Input[_builtins.str] instance_charge_type: It has been deprecated from provider version 1.101.0 and `payment_type` instead.
        :param pulumi.Input[_builtins.str] instance_class: Type of the applied Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance. It can be retrieved by data source kvstore_get_instance_classes
               or referring to help-docs [Instance type table](https://www.alibabacloud.com/help/doc-detail/26350.htm).
        :param pulumi.Input[_builtins.str] instance_name: It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
        :param pulumi.Input[_builtins.bool] instance_release_protection: Whether to open the release protection.
        :param pulumi.Input[_builtins.str] instance_type: The engine type of the KVStore DBInstance. Valid values: `Redis` or `Memcache`. Default value: `Redis`.
        :param pulumi.Input[_builtins.str] is_auto_upgrade_open: Specifies whether to enable automatic minor version update. Valid values:
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[_builtins.str] maintain_end_time: The end time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] maintain_start_time: The start time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        :param pulumi.Input[_builtins.str] node_type: Node type, valid values:
               - `MASTER_SLAVE`: High availability (dual copies)
               - `STAND_ALONE`: Single copy
        :param pulumi.Input[_builtins.str] order_type: Specifies a change type when you change the configuration of a subscription instance. Valid values: `UPGRADE`, `DOWNGRADE`. Default value: `UPGRADE`. `UPGRADE` means upgrades the configuration of a subscription instance. `DOWNGRADE` means downgrades the configuration of a subscription instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]] parameters: It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
        :param pulumi.Input[_builtins.str] password: The password of the KVStore DBInstance. The password that is used to connect to the instance. The password must be 8 to 32 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, special characters, and digits. Special characters include: `! @ # $ % ^ & * ( ) _ + - =`
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the KVStore DBInstance. Valid values: `PrePaid`, `PostPaid`. Default value: `PostPaid`.
        :param pulumi.Input[_builtins.str] period: The duration that you will buy KVStore DBInstance (in month). It is valid when payment_type is `PrePaid`. Valid values: `[1~9]`, `12`, `24`, `36`.
        :param pulumi.Input[_builtins.int] port: It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        :param pulumi.Input[_builtins.str] private_connection_port: Private network connection port, used to modify the private network connection port.
        :param pulumi.Input[_builtins.str] private_connection_prefix: Private network connection prefix, used to modify the private network connection address. Only supports updating private network connections for existing instance.
        :param pulumi.Input[_builtins.str] private_ip: The internal IP address of the instance.
        :param pulumi.Input[_builtins.int] qps: Theoretical maximum QPS value.
        :param pulumi.Input[_builtins.int] read_only_count: The number of read replicas in the primary zone. Valid values: `1` to `9`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of resource group which the resource belongs.
        :param pulumi.Input[_builtins.str] restore_time: The point in time of a backup file.
        :param pulumi.Input[_builtins.str] role_arn: The Specify the global resource descriptor ARN (Alibaba Cloud Resource Name) information of the role to be authorized, and use the related key management services after the authorization is completed, in the format: `acs:ram::$accountID:role/$roleName`.
        :param pulumi.Input[_builtins.str] secondary_zone_id: The ID of the secondary zone to which you want to migrate the Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance.
               > **NOTE:** If you specify this parameter, the master node and replica node of the instance can be deployed in different zones and disaster recovery is implemented across zones. The instance can withstand failures in data centers.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of security groups. Separate multiple security group IDs with commas (,), such as `sg-***,sg-***,sg-***`.
        :param pulumi.Input[_builtins.str] security_ip_group_attribute: The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
        :param pulumi.Input[_builtins.str] security_ip_group_name: The name of the whitelist group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
        :param pulumi.Input[_builtins.int] shard_count: The number of data shards. This parameter is available only if you create a cluster instance that uses cloud disks. You can use this parameter to specify a custom number of data shards. **NOTE:** From version 1.216.0, `shard_count` can be modified.
        :param pulumi.Input[_builtins.int] slave_read_only_count: The number of read replicas in the secondary zone. **NOTE:**: When you create a multi-zone read/write splitting instance, you must specify both `secondary_zone_id` and `slave_read_only_count`.
               > **NOTE:** The sum of `read_only_count` and `slave_read_only_count` cannot be greater than `9`.
        :param pulumi.Input[_builtins.str] srcdb_instance_id: The ID of the source instance.
        :param pulumi.Input[_builtins.str] ssl_enable: Modifies the SSL status. Valid values: `Disable`, `Enable` and `Update`.
               **NOTE:** This functionality is supported by Cluster mode (Redis 2.8, 4.0, 5.0) and Standard mode( Redis 2.8 only).
        :param pulumi.Input[_builtins.str] status: The status of KVStore DBInstance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] tde_status: Specifies whether to enable TDE. Valid values: `Enabled`.
               **NOTE:**: TDE cannot be disabled after it is enabled. Before you enable it, evaluate whether this feature affects.
               your business. For more information, see [Enable TDE](https://www.alibabacloud.com/help/en/redis/user-guide/enable-tde).
        :param pulumi.Input[_builtins.str] vpc_auth_mode: Only meaningful if instance_type is `Redis` and network type is VPC. Valid values: `Close`, `Open`. Default value: `Open`. `Close` means the redis instance can be accessed without authentication. `Open` means authentication is required.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of VSwitch.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["auto_use_coupon"] = auto_use_coupon
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["backup_periods"] = backup_periods
        __props__.__dict__["backup_time"] = backup_time
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["business_info"] = business_info
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["config"] = config
        __props__.__dict__["connection_domain"] = connection_domain
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["connection_string_prefix"] = connection_string_prefix
        __props__.__dict__["coupon_no"] = coupon_no
        __props__.__dict__["db_instance_name"] = db_instance_name
        __props__.__dict__["dedicated_host_group_id"] = dedicated_host_group_id
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["effective_time"] = effective_time
        __props__.__dict__["enable_backup_log"] = enable_backup_log
        __props__.__dict__["enable_public"] = enable_public
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["encryption_name"] = encryption_name
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["force_upgrade"] = force_upgrade
        __props__.__dict__["global_instance"] = global_instance
        __props__.__dict__["global_instance_id"] = global_instance_id
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_release_protection"] = instance_release_protection
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["is_auto_upgrade_open"] = is_auto_upgrade_open
        __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
        __props__.__dict__["kms_encryption_context"] = kms_encryption_context
        __props__.__dict__["maintain_end_time"] = maintain_end_time
        __props__.__dict__["maintain_start_time"] = maintain_start_time
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["order_type"] = order_type
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["password"] = password
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["port"] = port
        __props__.__dict__["private_connection_port"] = private_connection_port
        __props__.__dict__["private_connection_prefix"] = private_connection_prefix
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["qps"] = qps
        __props__.__dict__["read_only_count"] = read_only_count
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["restore_time"] = restore_time
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["secondary_zone_id"] = secondary_zone_id
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_ip_group_attribute"] = security_ip_group_attribute
        __props__.__dict__["security_ip_group_name"] = security_ip_group_name
        __props__.__dict__["security_ips"] = security_ips
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["slave_read_only_count"] = slave_read_only_count
        __props__.__dict__["srcdb_instance_id"] = srcdb_instance_id
        __props__.__dict__["ssl_enable"] = ssl_enable
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tde_status"] = tde_status
        __props__.__dict__["vpc_auth_mode"] = vpc_auth_mode
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to renewal a KVStore DBInstance automatically or not. It is valid when payment_type is `PrePaid`. Default value: `false`.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Auto-renewal period of an KVStore DBInstance, in the unit of the month. It is valid when payment_type is `PrePaid`. Valid values: [1~12]. Default value: `1`.
        """
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to use a coupon. Default value: `false`.
        """
        return pulumi.get(self, "auto_use_coupon")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    @_utilities.deprecated("""Field 'availability_zone' has been deprecated from version 1.101.0. Use 'zone_id' instead.""")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        It has been deprecated from provider version 1.101.0 and `zone_id` instead.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the backup file of the source instance.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="backupPeriods")
    def backup_periods(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Backup period.
        """
        return pulumi.get(self, "backup_periods")

    @_builtins.property
    @pulumi.getter(name="backupTime")
    def backup_time(self) -> pulumi.Output[_builtins.str]:
        """
        Backup time, the format is HH:mmZ-HH:mmZ (UTC time).
        """
        return pulumi.get(self, "backup_time")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The total bandwidth of the instance. **NOTE:** From version 1.232.0, `bandwidth` can be set. If the instance is a cluster instance, `bandwidth` must be divisible by the number of `shard_count` in the instance, and if the instance is a read/write splitting instance, `bandwidth` cannot be set.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="businessInfo")
    def business_info(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the event or the business information.
        """
        return pulumi.get(self, "business_info")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[_builtins.int]:
        """
        The storage capacity of the KVStore DBInstance. Unit: MB.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The configuration of the KVStore DBInstance. Available parameters can refer to the latest docs [Instance configurations table](https://www.alibabacloud.com/help/en/redis/user-guide/supported-parameters).
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="connectionDomain")
    def connection_domain(self) -> pulumi.Output[_builtins.str]:
        """
        Intranet connection address of the KVStore instance.
        """
        return pulumi.get(self, "connection_domain")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    @_utilities.deprecated("""Field 'connection_string' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates whether the address is a private endpoint.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    @_utilities.deprecated("""Field 'connection_string_prefix' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
    def connection_string_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        """
        return pulumi.get(self, "connection_string_prefix")

    @_builtins.property
    @pulumi.getter(name="couponNo")
    def coupon_no(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The coupon code. **NOTE:** The default value `youhuiquan_promotion_option_id_for_blank` removed since v1.216.0, this can cause your status file to change even if it has not been modified, so please review your change plan before apply change plan.
        """
        return pulumi.get(self, "coupon_no")

    @_builtins.property
    @pulumi.getter(name="dbInstanceName")
    def db_instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of KVStore DBInstance. It is a string of 2 to 256 characters.
        """
        return pulumi.get(self, "db_instance_name")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the dedicated cluster. This parameter is required when you create a Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance in a dedicated cluster.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to precheck the request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time when the database is switched after the instance is migrated, or when the major version is upgraded, or when the instance class is upgraded. Valid values:
        - `Immediately` (Default): The configurations are immediately changed.
        - `MaintainTime`: The configurations are changed within the maintenance window. You can set `maintain_start_time` and `maintain_end_time` to change the maintenance window.
        """
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter(name="enableBackupLog")
    def enable_backup_log(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Turn on or off incremental backup. Valid values: `1`, `0`. Default value: `0`
        """
        return pulumi.get(self, "enable_backup_log")

    @_builtins.property
    @pulumi.getter(name="enablePublic")
    @_utilities.deprecated("""Field 'enable_public' has been deprecated from version 1.101.0. Please use resource 'alicloud_kvstore_connection' instead.""")
    def enable_public(self) -> pulumi.Output[_builtins.bool]:
        """
        It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        """
        return pulumi.get(self, "enable_public")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Custom key ID, which you can get by calling DescribeEncryptionKeyList.If this parameter is not passed, the key is automatically generated by the key management service. To create a custom key, you can call the CreateKey interface of the key management service.
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="encryptionName")
    def encryption_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Encryption algorithm, default AES-CTR-256.Note that this parameter is only available when the TDEStatus parameter is Enabled.
        """
        return pulumi.get(self, "encryption_name")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[_builtins.str]:
        """
        The expiration time of the prepaid instance.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        The engine version of the KVStore DBInstance. Valid values: ["2.8", "4.0", "5.0", "6.0", "7.0"]. Default value: `5.0`.
        **NOTE:** When `instance_type = Memcache`, the `engine_version` only supports "4.0".
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="forceUpgrade")
    def force_upgrade(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to forcibly change the type. Default value: `true`.
        """
        return pulumi.get(self, "force_upgrade")

    @_builtins.property
    @pulumi.getter(name="globalInstance")
    def global_instance(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to create a distributed cache. Default value: `false`.
        """
        return pulumi.get(self, "global_instance")

    @_builtins.property
    @pulumi.getter(name="globalInstanceId")
    def global_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of distributed cache.
        """
        return pulumi.get(self, "global_instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated from version 1.101.0. Use 'payment_type' instead.""")
    def instance_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        It has been deprecated from provider version 1.101.0 and `payment_type` instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of the applied Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance. It can be retrieved by data source kvstore_get_instance_classes
        or referring to help-docs [Instance type table](https://www.alibabacloud.com/help/doc-detail/26350.htm).
        """
        return pulumi.get(self, "instance_class")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    @_utilities.deprecated("""Field `instance_name` has been deprecated from version 1.101.0. Use `db_instance_name` instead.""")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        It has been deprecated from provider version 1.101.0 and `db_instance_name` instead.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceReleaseProtection")
    def instance_release_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to open the release protection.
        """
        return pulumi.get(self, "instance_release_protection")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The engine type of the KVStore DBInstance. Valid values: `Redis` or `Memcache`. Default value: `Redis`.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="isAutoUpgradeOpen")
    def is_auto_upgrade_open(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to enable automatic minor version update. Valid values:
        """
        return pulumi.get(self, "is_auto_upgrade_open")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @_builtins.property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> pulumi.Output[_builtins.str]:
        """
        The end time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_end_time")

    @_builtins.property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> pulumi.Output[_builtins.str]:
        """
        The start time of the operation and maintenance time period of the KVStore DBInstance, in the format of HH:mmZ (UTC time).
        """
        return pulumi.get(self, "maintain_start_time")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    @_utilities.deprecated("""Field 'node_type' has been deprecated from version 1.120.1""")
    def node_type(self) -> pulumi.Output[_builtins.str]:
        """
        Node type, valid values:
        - `MASTER_SLAVE`: High availability (dual copies)
        - `STAND_ALONE`: Single copy
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="orderType")
    def order_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a change type when you change the configuration of a subscription instance. Valid values: `UPGRADE`, `DOWNGRADE`. Default value: `UPGRADE`. `UPGRADE` means upgrades the configuration of a subscription instance. `DOWNGRADE` means downgrades the configuration of a subscription instance.
        """
        return pulumi.get(self, "order_type")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'parameters' has been deprecated from version 1.101.0. Use 'config' instead.""")
    def parameters(self) -> pulumi.Output[Sequence['outputs.InstanceParameter']]:
        """
        It has been deprecated from provider version 1.101.0 and `config` instead. See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the KVStore DBInstance. The password that is used to connect to the instance. The password must be 8 to 32 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, special characters, and digits. Special characters include: `! @ # $ % ^ & * ( ) _ + - =`
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method of the KVStore DBInstance. Valid values: `PrePaid`, `PostPaid`. Default value: `PostPaid`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The duration that you will buy KVStore DBInstance (in month). It is valid when payment_type is `PrePaid`. Valid values: `[1~9]`, `12`, `24`, `36`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        It has been deprecated from provider version 1.101.0 and resource `kvstore.Connection` instead.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="privateConnectionPort")
    def private_connection_port(self) -> pulumi.Output[_builtins.str]:
        """
        Private network connection port, used to modify the private network connection port.
        """
        return pulumi.get(self, "private_connection_port")

    @_builtins.property
    @pulumi.getter(name="privateConnectionPrefix")
    def private_connection_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Private network connection prefix, used to modify the private network connection address. Only supports updating private network connections for existing instance.
        """
        return pulumi.get(self, "private_connection_prefix")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The internal IP address of the instance.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter
    def qps(self) -> pulumi.Output[_builtins.int]:
        """
        Theoretical maximum QPS value.
        """
        return pulumi.get(self, "qps")

    @_builtins.property
    @pulumi.getter(name="readOnlyCount")
    def read_only_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of read replicas in the primary zone. Valid values: `1` to `9`.
        """
        return pulumi.get(self, "read_only_count")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of resource group which the resource belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The point in time of a backup file.
        """
        return pulumi.get(self, "restore_time")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Specify the global resource descriptor ARN (Alibaba Cloud Resource Name) information of the role to be authorized, and use the related key management services after the authorization is completed, in the format: `acs:ram::$accountID:role/$roleName`.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the secondary zone to which you want to migrate the Tair (Redis OSS-Compatible) And Memcache (KVStore) Classic Instance.
        > **NOTE:** If you specify this parameter, the master node and replica node of the instance can be deployed in different zones and disaster recovery is implemented across zones. The instance can withstand failures in data centers.
        """
        return pulumi.get(self, "secondary_zone_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of security groups. Separate multiple security group IDs with commas (,), such as `sg-***,sg-***,sg-***`.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityIpGroupAttribute")
    def security_ip_group_attribute(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The value of this parameter is empty by default. The attribute of the whitelist group. The console does not display the whitelist group whose value of this parameter is hidden.
        """
        return pulumi.get(self, "security_ip_group_attribute")

    @_builtins.property
    @pulumi.getter(name="securityIpGroupName")
    def security_ip_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the whitelist group.
        """
        return pulumi.get(self, "security_ip_group_name")

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IP addresses in the whitelist group. The maximum number of IP addresses in the whitelist group is 1000.
        """
        return pulumi.get(self, "security_ips")

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of data shards. This parameter is available only if you create a cluster instance that uses cloud disks. You can use this parameter to specify a custom number of data shards. **NOTE:** From version 1.216.0, `shard_count` can be modified.
        """
        return pulumi.get(self, "shard_count")

    @_builtins.property
    @pulumi.getter(name="slaveReadOnlyCount")
    def slave_read_only_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of read replicas in the secondary zone. **NOTE:**: When you create a multi-zone read/write splitting instance, you must specify both `secondary_zone_id` and `slave_read_only_count`.
        > **NOTE:** The sum of `read_only_count` and `slave_read_only_count` cannot be greater than `9`.
        """
        return pulumi.get(self, "slave_read_only_count")

    @_builtins.property
    @pulumi.getter(name="srcdbInstanceId")
    def srcdb_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the source instance.
        """
        return pulumi.get(self, "srcdb_instance_id")

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> pulumi.Output[_builtins.str]:
        """
        Modifies the SSL status. Valid values: `Disable`, `Enable` and `Update`.
        **NOTE:** This functionality is supported by Cluster mode (Redis 2.8, 4.0, 5.0) and Standard mode( Redis 2.8 only).
        """
        return pulumi.get(self, "ssl_enable")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of KVStore DBInstance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to enable TDE. Valid values: `Enabled`.
        **NOTE:**: TDE cannot be disabled after it is enabled. Before you enable it, evaluate whether this feature affects.
        your business. For more information, see [Enable TDE](https://www.alibabacloud.com/help/en/redis/user-guide/enable-tde).
        """
        return pulumi.get(self, "tde_status")

    @_builtins.property
    @pulumi.getter(name="vpcAuthMode")
    def vpc_auth_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Only meaningful if instance_type is `Redis` and network type is VPC. Valid values: `Close`, `Open`. Default value: `Open`. `Close` means the redis instance can be accessed without authentication. `Open` means authentication is required.
        """
        return pulumi.get(self, "vpc_auth_mode")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")

