# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceV2Args', 'InstanceV2']

@pulumi.input_type
class InstanceV2Args:
    def __init__(__self__, *,
                 arch_version: pulumi.Input[_builtins.str],
                 engine_lists: pulumi.Input[Sequence[pulumi.Input['InstanceV2EngineListArgs']]],
                 instance_alias: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 arbiter_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arbiter_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
                 cloud_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cloud_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 standby_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 standby_zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceV2 resource.
        :param pulumi.Input[_builtins.str] arch_version: Deployment Scenario
               
               > **NOTE:**  Enumeration value
               
               > **NOTE:**  - 1.0 Single AZ
               
               > **NOTE:**  - 2.0 Multi-AZ Basic
               
               > **NOTE:**  - 3.0 Multi-AZ High Availability Edition
               
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceV2EngineListArgs']]] engine_lists: Engine List See `engine_list` below.
        :param pulumi.Input[_builtins.str] instance_alias: Instance name
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] vpc_id: VpcId
        :param pulumi.Input[_builtins.str] vswitch_id: VswitchId
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        :param pulumi.Input[_builtins.str] arbiter_vswitch_id: Coordination Zone VswitchId
        :param pulumi.Input[_builtins.str] arbiter_zone_id: Coordination Zone ZoneId
        :param pulumi.Input[_builtins.str] auto_renew_duration: Automatic renewal duration. Unit: Month.
               
               Value range: `1` to **12 * *.
               
               > **NOTE:**  This item takes effect only when `AutoRenewal` is **true.
               
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.bool] auto_renewal: Whether the instance is automatically renewed. Enumerated values:
        :param pulumi.Input[_builtins.int] cloud_storage_size: > **NOTE:**  Cloud storage capacity in GB
        :param pulumi.Input[_builtins.str] cloud_storage_type: > **NOTE:** >
               
               > **NOTE:**  - StandardStorage: Standard cloud storage
               
               > **NOTE:**  - PerformanceStorage: performance-based cloud storage
               
               > **NOTE:** - capacity storage: Capacity-based cloud storage
        :param pulumi.Input[_builtins.str] deletion_protection: Whether to enable deletion protection
        :param pulumi.Input[_builtins.int] duration: The specified duration when the resource is purchased. Only the subscription instances are valid.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] pricing_cycle: Purchase duration unit: Month, Year
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] primary_vswitch_id: Primary zone VswitchId
        :param pulumi.Input[_builtins.str] primary_zone_id: Primary zone ZoneID
        :param pulumi.Input[_builtins.str] standby_vswitch_id: Standby zone VswitchId
        :param pulumi.Input[_builtins.str] standby_zone_id: Standby zone ZoneID
        """
        pulumi.set(__self__, "arch_version", arch_version)
        pulumi.set(__self__, "engine_lists", engine_lists)
        pulumi.set(__self__, "instance_alias", instance_alias)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if arbiter_vswitch_id is not None:
            pulumi.set(__self__, "arbiter_vswitch_id", arbiter_vswitch_id)
        if arbiter_zone_id is not None:
            pulumi.set(__self__, "arbiter_zone_id", arbiter_zone_id)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_renewal is not None:
            pulumi.set(__self__, "auto_renewal", auto_renewal)
        if cloud_storage_size is not None:
            pulumi.set(__self__, "cloud_storage_size", cloud_storage_size)
        if cloud_storage_type is not None:
            pulumi.set(__self__, "cloud_storage_type", cloud_storage_type)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if primary_vswitch_id is not None:
            pulumi.set(__self__, "primary_vswitch_id", primary_vswitch_id)
        if primary_zone_id is not None:
            pulumi.set(__self__, "primary_zone_id", primary_zone_id)
        if standby_vswitch_id is not None:
            pulumi.set(__self__, "standby_vswitch_id", standby_vswitch_id)
        if standby_zone_id is not None:
            pulumi.set(__self__, "standby_zone_id", standby_zone_id)

    @_builtins.property
    @pulumi.getter(name="archVersion")
    def arch_version(self) -> pulumi.Input[_builtins.str]:
        """
        Deployment Scenario

        > **NOTE:**  Enumeration value

        > **NOTE:**  - 1.0 Single AZ

        > **NOTE:**  - 2.0 Multi-AZ Basic

        > **NOTE:**  - 3.0 Multi-AZ High Availability Edition


        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "arch_version")

    @arch_version.setter
    def arch_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "arch_version", value)

    @_builtins.property
    @pulumi.getter(name="engineLists")
    def engine_lists(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceV2EngineListArgs']]]:
        """
        Engine List See `engine_list` below.
        """
        return pulumi.get(self, "engine_lists")

    @engine_lists.setter
    def engine_lists(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceV2EngineListArgs']]]):
        pulumi.set(self, "engine_lists", value)

    @_builtins.property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> pulumi.Input[_builtins.str]:
        """
        Instance name
        """
        return pulumi.get(self, "instance_alias")

    @instance_alias.setter
    def instance_alias(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_alias", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        VpcId
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        VswitchId
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The zone ID  of the resource
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="arbiterVswitchId")
    def arbiter_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Coordination Zone VswitchId
        """
        return pulumi.get(self, "arbiter_vswitch_id")

    @arbiter_vswitch_id.setter
    def arbiter_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arbiter_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="arbiterZoneId")
    def arbiter_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Coordination Zone ZoneId
        """
        return pulumi.get(self, "arbiter_zone_id")

    @arbiter_zone_id.setter
    def arbiter_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arbiter_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal duration. Unit: Month.

        Value range: `1` to **12 * *.

        > **NOTE:**  This item takes effect only when `AutoRenewal` is **true.


        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew_duration", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewal")
    def auto_renewal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the instance is automatically renewed. Enumerated values:
        """
        return pulumi.get(self, "auto_renewal")

    @auto_renewal.setter
    def auto_renewal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renewal", value)

    @_builtins.property
    @pulumi.getter(name="cloudStorageSize")
    def cloud_storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        > **NOTE:**  Cloud storage capacity in GB
        """
        return pulumi.get(self, "cloud_storage_size")

    @cloud_storage_size.setter
    def cloud_storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cloud_storage_size", value)

    @_builtins.property
    @pulumi.getter(name="cloudStorageType")
    def cloud_storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        > **NOTE:** >

        > **NOTE:**  - StandardStorage: Standard cloud storage

        > **NOTE:**  - PerformanceStorage: performance-based cloud storage

        > **NOTE:** - capacity storage: Capacity-based cloud storage
        """
        return pulumi.get(self, "cloud_storage_type")

    @cloud_storage_type.setter
    def cloud_storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_storage_type", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable deletion protection
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The specified duration when the resource is purchased. Only the subscription instances are valid.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Purchase duration unit: Month, Year

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="primaryVswitchId")
    def primary_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary zone VswitchId
        """
        return pulumi.get(self, "primary_vswitch_id")

    @primary_vswitch_id.setter
    def primary_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="primaryZoneId")
    def primary_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary zone ZoneID
        """
        return pulumi.get(self, "primary_zone_id")

    @primary_zone_id.setter
    def primary_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="standbyVswitchId")
    def standby_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Standby zone VswitchId
        """
        return pulumi.get(self, "standby_vswitch_id")

    @standby_vswitch_id.setter
    def standby_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "standby_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="standbyZoneId")
    def standby_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Standby zone ZoneID
        """
        return pulumi.get(self, "standby_zone_id")

    @standby_zone_id.setter
    def standby_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "standby_zone_id", value)


@pulumi.input_type
class _InstanceV2State:
    def __init__(__self__, *,
                 arbiter_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arbiter_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arch_version: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
                 cloud_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cloud_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_lists: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceV2EngineListArgs']]]] = None,
                 instance_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 standby_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 standby_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceV2 resources.
        :param pulumi.Input[_builtins.str] arbiter_vswitch_id: Coordination Zone VswitchId
        :param pulumi.Input[_builtins.str] arbiter_zone_id: Coordination Zone ZoneId
        :param pulumi.Input[_builtins.str] arch_version: Deployment Scenario
               
               > **NOTE:**  Enumeration value
               
               > **NOTE:**  - 1.0 Single AZ
               
               > **NOTE:**  - 2.0 Multi-AZ Basic
               
               > **NOTE:**  - 3.0 Multi-AZ High Availability Edition
               
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] auto_renew_duration: Automatic renewal duration. Unit: Month.
               
               Value range: `1` to **12 * *.
               
               > **NOTE:**  This item takes effect only when `AutoRenewal` is **true.
               
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.bool] auto_renewal: Whether the instance is automatically renewed. Enumerated values:
        :param pulumi.Input[_builtins.int] cloud_storage_size: > **NOTE:**  Cloud storage capacity in GB
        :param pulumi.Input[_builtins.str] cloud_storage_type: > **NOTE:** >
               
               > **NOTE:**  - StandardStorage: Standard cloud storage
               
               > **NOTE:**  - PerformanceStorage: performance-based cloud storage
               
               > **NOTE:** - capacity storage: Capacity-based cloud storage
        :param pulumi.Input[_builtins.str] deletion_protection: Whether to enable deletion protection
        :param pulumi.Input[_builtins.int] duration: The specified duration when the resource is purchased. Only the subscription instances are valid.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceV2EngineListArgs']]] engine_lists: Engine List See `engine_list` below.
        :param pulumi.Input[_builtins.str] instance_alias: Instance name
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] pricing_cycle: Purchase duration unit: Month, Year
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] primary_vswitch_id: Primary zone VswitchId
        :param pulumi.Input[_builtins.str] primary_zone_id: Primary zone ZoneID
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] standby_vswitch_id: Standby zone VswitchId
        :param pulumi.Input[_builtins.str] standby_zone_id: Standby zone ZoneID
        :param pulumi.Input[_builtins.str] vpc_id: VpcId
        :param pulumi.Input[_builtins.str] vswitch_id: VswitchId
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        """
        if arbiter_vswitch_id is not None:
            pulumi.set(__self__, "arbiter_vswitch_id", arbiter_vswitch_id)
        if arbiter_zone_id is not None:
            pulumi.set(__self__, "arbiter_zone_id", arbiter_zone_id)
        if arch_version is not None:
            pulumi.set(__self__, "arch_version", arch_version)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_renewal is not None:
            pulumi.set(__self__, "auto_renewal", auto_renewal)
        if cloud_storage_size is not None:
            pulumi.set(__self__, "cloud_storage_size", cloud_storage_size)
        if cloud_storage_type is not None:
            pulumi.set(__self__, "cloud_storage_type", cloud_storage_type)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if engine_lists is not None:
            pulumi.set(__self__, "engine_lists", engine_lists)
        if instance_alias is not None:
            pulumi.set(__self__, "instance_alias", instance_alias)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if primary_vswitch_id is not None:
            pulumi.set(__self__, "primary_vswitch_id", primary_vswitch_id)
        if primary_zone_id is not None:
            pulumi.set(__self__, "primary_zone_id", primary_zone_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if standby_vswitch_id is not None:
            pulumi.set(__self__, "standby_vswitch_id", standby_vswitch_id)
        if standby_zone_id is not None:
            pulumi.set(__self__, "standby_zone_id", standby_zone_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="arbiterVswitchId")
    def arbiter_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Coordination Zone VswitchId
        """
        return pulumi.get(self, "arbiter_vswitch_id")

    @arbiter_vswitch_id.setter
    def arbiter_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arbiter_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="arbiterZoneId")
    def arbiter_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Coordination Zone ZoneId
        """
        return pulumi.get(self, "arbiter_zone_id")

    @arbiter_zone_id.setter
    def arbiter_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arbiter_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="archVersion")
    def arch_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment Scenario

        > **NOTE:**  Enumeration value

        > **NOTE:**  - 1.0 Single AZ

        > **NOTE:**  - 2.0 Multi-AZ Basic

        > **NOTE:**  - 3.0 Multi-AZ High Availability Edition


        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "arch_version")

    @arch_version.setter
    def arch_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arch_version", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal duration. Unit: Month.

        Value range: `1` to **12 * *.

        > **NOTE:**  This item takes effect only when `AutoRenewal` is **true.


        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew_duration", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewal")
    def auto_renewal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the instance is automatically renewed. Enumerated values:
        """
        return pulumi.get(self, "auto_renewal")

    @auto_renewal.setter
    def auto_renewal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renewal", value)

    @_builtins.property
    @pulumi.getter(name="cloudStorageSize")
    def cloud_storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        > **NOTE:**  Cloud storage capacity in GB
        """
        return pulumi.get(self, "cloud_storage_size")

    @cloud_storage_size.setter
    def cloud_storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cloud_storage_size", value)

    @_builtins.property
    @pulumi.getter(name="cloudStorageType")
    def cloud_storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        > **NOTE:** >

        > **NOTE:**  - StandardStorage: Standard cloud storage

        > **NOTE:**  - PerformanceStorage: performance-based cloud storage

        > **NOTE:** - capacity storage: Capacity-based cloud storage
        """
        return pulumi.get(self, "cloud_storage_type")

    @cloud_storage_type.setter
    def cloud_storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_storage_type", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable deletion protection
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The specified duration when the resource is purchased. Only the subscription instances are valid.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="engineLists")
    def engine_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceV2EngineListArgs']]]]:
        """
        Engine List See `engine_list` below.
        """
        return pulumi.get(self, "engine_lists")

    @engine_lists.setter
    def engine_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceV2EngineListArgs']]]]):
        pulumi.set(self, "engine_lists", value)

    @_builtins.property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance name
        """
        return pulumi.get(self, "instance_alias")

    @instance_alias.setter
    def instance_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_alias", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Purchase duration unit: Month, Year

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="primaryVswitchId")
    def primary_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary zone VswitchId
        """
        return pulumi.get(self, "primary_vswitch_id")

    @primary_vswitch_id.setter
    def primary_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="primaryZoneId")
    def primary_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary zone ZoneID
        """
        return pulumi.get(self, "primary_zone_id")

    @primary_zone_id.setter
    def primary_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="standbyVswitchId")
    def standby_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Standby zone VswitchId
        """
        return pulumi.get(self, "standby_vswitch_id")

    @standby_vswitch_id.setter
    def standby_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "standby_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="standbyZoneId")
    def standby_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Standby zone ZoneID
        """
        return pulumi.get(self, "standby_zone_id")

    @standby_zone_id.setter
    def standby_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "standby_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VpcId
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VswitchId
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID  of the resource
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:lindorm/instanceV2:InstanceV2")
class InstanceV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arbiter_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arbiter_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arch_version: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
                 cloud_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cloud_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceV2EngineListArgs', 'InstanceV2EngineListArgsDict']]]]] = None,
                 instance_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 standby_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 standby_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Lindorm Instance V2 resource.

        Cloud-native multi-model database.

        For information about Lindorm Instance V2 and how to use it, see [What is Instance V2](https://next.api.alibabacloud.com/document/hitsdb/2020-06-15/CreateLindormV2Instance).

        > **NOTE:** Available since v1.260.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_r8v_xl_p = alicloud.vpc.Network("defaultR8vXlP", cidr_block="172.16.0.0/16")
        default9umuzw_h = alicloud.vpc.Switch("default9umuzwH",
            vpc_id=default_r8v_xl_p.id,
            zone_id="cn-beijing-h",
            cidr_block="172.16.0.0/24")
        defaultg_of_ao3_l = alicloud.vpc.Switch("defaultgOFAo3L",
            vpc_id=default_r8v_xl_p.id,
            zone_id="cn-beijing-l",
            cidr_block="172.16.1.0/24")
        default_t_abr2p_j = alicloud.vpc.Switch("defaultTAbr2pJ",
            vpc_id=default_r8v_xl_p.id,
            zone_id="cn-beijing-j",
            cidr_block="172.16.2.0/24")
        default = alicloud.lindorm.InstanceV2("default",
            standby_zone_id="cn-beijing-l",
            engine_lists=[{
                "engine_type": "TABLE",
                "node_groups": [{
                    "node_count": 4,
                    "node_spec": "lindorm.g.2xlarge",
                    "resource_group_name": "cx-mz-rg",
                }],
            }],
            cloud_storage_size=400,
            primary_zone_id="cn-beijing-h",
            zone_id="cn-beijing-h",
            cloud_storage_type="PerformanceStorage",
            arch_version="2.0",
            vswitch_id=default9umuzw_h.id,
            standby_vswitch_id=defaultg_of_ao3_l.id,
            primary_vswitch_id=default9umuzw_h.id,
            arbiter_vswitch_id=default_t_abr2p_j.id,
            vpc_id=default_r8v_xl_p.id,
            instance_alias="preTest-MZ",
            payment_type="POSTPAY",
            arbiter_zone_id="cn-beijing-j",
            auto_renewal=False)
        ```

        ## Import

        Lindorm Instance V2 can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:lindorm/instanceV2:InstanceV2 example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arbiter_vswitch_id: Coordination Zone VswitchId
        :param pulumi.Input[_builtins.str] arbiter_zone_id: Coordination Zone ZoneId
        :param pulumi.Input[_builtins.str] arch_version: Deployment Scenario
               
               > **NOTE:**  Enumeration value
               
               > **NOTE:**  - 1.0 Single AZ
               
               > **NOTE:**  - 2.0 Multi-AZ Basic
               
               > **NOTE:**  - 3.0 Multi-AZ High Availability Edition
               
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] auto_renew_duration: Automatic renewal duration. Unit: Month.
               
               Value range: `1` to **12 * *.
               
               > **NOTE:**  This item takes effect only when `AutoRenewal` is **true.
               
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.bool] auto_renewal: Whether the instance is automatically renewed. Enumerated values:
        :param pulumi.Input[_builtins.int] cloud_storage_size: > **NOTE:**  Cloud storage capacity in GB
        :param pulumi.Input[_builtins.str] cloud_storage_type: > **NOTE:** >
               
               > **NOTE:**  - StandardStorage: Standard cloud storage
               
               > **NOTE:**  - PerformanceStorage: performance-based cloud storage
               
               > **NOTE:** - capacity storage: Capacity-based cloud storage
        :param pulumi.Input[_builtins.str] deletion_protection: Whether to enable deletion protection
        :param pulumi.Input[_builtins.int] duration: The specified duration when the resource is purchased. Only the subscription instances are valid.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceV2EngineListArgs', 'InstanceV2EngineListArgsDict']]]] engine_lists: Engine List See `engine_list` below.
        :param pulumi.Input[_builtins.str] instance_alias: Instance name
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] pricing_cycle: Purchase duration unit: Month, Year
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] primary_vswitch_id: Primary zone VswitchId
        :param pulumi.Input[_builtins.str] primary_zone_id: Primary zone ZoneID
        :param pulumi.Input[_builtins.str] standby_vswitch_id: Standby zone VswitchId
        :param pulumi.Input[_builtins.str] standby_zone_id: Standby zone ZoneID
        :param pulumi.Input[_builtins.str] vpc_id: VpcId
        :param pulumi.Input[_builtins.str] vswitch_id: VswitchId
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Lindorm Instance V2 resource.

        Cloud-native multi-model database.

        For information about Lindorm Instance V2 and how to use it, see [What is Instance V2](https://next.api.alibabacloud.com/document/hitsdb/2020-06-15/CreateLindormV2Instance).

        > **NOTE:** Available since v1.260.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_r8v_xl_p = alicloud.vpc.Network("defaultR8vXlP", cidr_block="172.16.0.0/16")
        default9umuzw_h = alicloud.vpc.Switch("default9umuzwH",
            vpc_id=default_r8v_xl_p.id,
            zone_id="cn-beijing-h",
            cidr_block="172.16.0.0/24")
        defaultg_of_ao3_l = alicloud.vpc.Switch("defaultgOFAo3L",
            vpc_id=default_r8v_xl_p.id,
            zone_id="cn-beijing-l",
            cidr_block="172.16.1.0/24")
        default_t_abr2p_j = alicloud.vpc.Switch("defaultTAbr2pJ",
            vpc_id=default_r8v_xl_p.id,
            zone_id="cn-beijing-j",
            cidr_block="172.16.2.0/24")
        default = alicloud.lindorm.InstanceV2("default",
            standby_zone_id="cn-beijing-l",
            engine_lists=[{
                "engine_type": "TABLE",
                "node_groups": [{
                    "node_count": 4,
                    "node_spec": "lindorm.g.2xlarge",
                    "resource_group_name": "cx-mz-rg",
                }],
            }],
            cloud_storage_size=400,
            primary_zone_id="cn-beijing-h",
            zone_id="cn-beijing-h",
            cloud_storage_type="PerformanceStorage",
            arch_version="2.0",
            vswitch_id=default9umuzw_h.id,
            standby_vswitch_id=defaultg_of_ao3_l.id,
            primary_vswitch_id=default9umuzw_h.id,
            arbiter_vswitch_id=default_t_abr2p_j.id,
            vpc_id=default_r8v_xl_p.id,
            instance_alias="preTest-MZ",
            payment_type="POSTPAY",
            arbiter_zone_id="cn-beijing-j",
            auto_renewal=False)
        ```

        ## Import

        Lindorm Instance V2 can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:lindorm/instanceV2:InstanceV2 example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arbiter_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arbiter_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arch_version: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
                 cloud_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cloud_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceV2EngineListArgs', 'InstanceV2EngineListArgsDict']]]]] = None,
                 instance_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 standby_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 standby_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceV2Args.__new__(InstanceV2Args)

            __props__.__dict__["arbiter_vswitch_id"] = arbiter_vswitch_id
            __props__.__dict__["arbiter_zone_id"] = arbiter_zone_id
            if arch_version is None and not opts.urn:
                raise TypeError("Missing required property 'arch_version'")
            __props__.__dict__["arch_version"] = arch_version
            __props__.__dict__["auto_renew_duration"] = auto_renew_duration
            __props__.__dict__["auto_renewal"] = auto_renewal
            __props__.__dict__["cloud_storage_size"] = cloud_storage_size
            __props__.__dict__["cloud_storage_type"] = cloud_storage_type
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["duration"] = duration
            if engine_lists is None and not opts.urn:
                raise TypeError("Missing required property 'engine_lists'")
            __props__.__dict__["engine_lists"] = engine_lists
            if instance_alias is None and not opts.urn:
                raise TypeError("Missing required property 'instance_alias'")
            __props__.__dict__["instance_alias"] = instance_alias
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["primary_vswitch_id"] = primary_vswitch_id
            __props__.__dict__["primary_zone_id"] = primary_zone_id
            __props__.__dict__["standby_vswitch_id"] = standby_vswitch_id
            __props__.__dict__["standby_zone_id"] = standby_zone_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["region_id"] = None
        super(InstanceV2, __self__).__init__(
            'alicloud:lindorm/instanceV2:InstanceV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arbiter_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            arbiter_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            arch_version: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew_duration: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
            cloud_storage_size: Optional[pulumi.Input[_builtins.int]] = None,
            cloud_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
            duration: Optional[pulumi.Input[_builtins.int]] = None,
            engine_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceV2EngineListArgs', 'InstanceV2EngineListArgsDict']]]]] = None,
            instance_alias: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            primary_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            primary_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            standby_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            standby_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceV2':
        """
        Get an existing InstanceV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arbiter_vswitch_id: Coordination Zone VswitchId
        :param pulumi.Input[_builtins.str] arbiter_zone_id: Coordination Zone ZoneId
        :param pulumi.Input[_builtins.str] arch_version: Deployment Scenario
               
               > **NOTE:**  Enumeration value
               
               > **NOTE:**  - 1.0 Single AZ
               
               > **NOTE:**  - 2.0 Multi-AZ Basic
               
               > **NOTE:**  - 3.0 Multi-AZ High Availability Edition
               
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] auto_renew_duration: Automatic renewal duration. Unit: Month.
               
               Value range: `1` to **12 * *.
               
               > **NOTE:**  This item takes effect only when `AutoRenewal` is **true.
               
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.bool] auto_renewal: Whether the instance is automatically renewed. Enumerated values:
        :param pulumi.Input[_builtins.int] cloud_storage_size: > **NOTE:**  Cloud storage capacity in GB
        :param pulumi.Input[_builtins.str] cloud_storage_type: > **NOTE:** >
               
               > **NOTE:**  - StandardStorage: Standard cloud storage
               
               > **NOTE:**  - PerformanceStorage: performance-based cloud storage
               
               > **NOTE:** - capacity storage: Capacity-based cloud storage
        :param pulumi.Input[_builtins.str] deletion_protection: Whether to enable deletion protection
        :param pulumi.Input[_builtins.int] duration: The specified duration when the resource is purchased. Only the subscription instances are valid.
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceV2EngineListArgs', 'InstanceV2EngineListArgsDict']]]] engine_lists: Engine List See `engine_list` below.
        :param pulumi.Input[_builtins.str] instance_alias: Instance name
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] pricing_cycle: Purchase duration unit: Month, Year
               
               > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        :param pulumi.Input[_builtins.str] primary_vswitch_id: Primary zone VswitchId
        :param pulumi.Input[_builtins.str] primary_zone_id: Primary zone ZoneID
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] standby_vswitch_id: Standby zone VswitchId
        :param pulumi.Input[_builtins.str] standby_zone_id: Standby zone ZoneID
        :param pulumi.Input[_builtins.str] vpc_id: VpcId
        :param pulumi.Input[_builtins.str] vswitch_id: VswitchId
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceV2State.__new__(_InstanceV2State)

        __props__.__dict__["arbiter_vswitch_id"] = arbiter_vswitch_id
        __props__.__dict__["arbiter_zone_id"] = arbiter_zone_id
        __props__.__dict__["arch_version"] = arch_version
        __props__.__dict__["auto_renew_duration"] = auto_renew_duration
        __props__.__dict__["auto_renewal"] = auto_renewal
        __props__.__dict__["cloud_storage_size"] = cloud_storage_size
        __props__.__dict__["cloud_storage_type"] = cloud_storage_type
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["duration"] = duration
        __props__.__dict__["engine_lists"] = engine_lists
        __props__.__dict__["instance_alias"] = instance_alias
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["primary_vswitch_id"] = primary_vswitch_id
        __props__.__dict__["primary_zone_id"] = primary_zone_id
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["standby_vswitch_id"] = standby_vswitch_id
        __props__.__dict__["standby_zone_id"] = standby_zone_id
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return InstanceV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="arbiterVswitchId")
    def arbiter_vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Coordination Zone VswitchId
        """
        return pulumi.get(self, "arbiter_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="arbiterZoneId")
    def arbiter_zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Coordination Zone ZoneId
        """
        return pulumi.get(self, "arbiter_zone_id")

    @_builtins.property
    @pulumi.getter(name="archVersion")
    def arch_version(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment Scenario

        > **NOTE:**  Enumeration value

        > **NOTE:**  - 1.0 Single AZ

        > **NOTE:**  - 2.0 Multi-AZ Basic

        > **NOTE:**  - 3.0 Multi-AZ High Availability Edition


        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "arch_version")

    @_builtins.property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Automatic renewal duration. Unit: Month.

        Value range: `1` to **12 * *.

        > **NOTE:**  This item takes effect only when `AutoRenewal` is **true.


        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "auto_renew_duration")

    @_builtins.property
    @pulumi.getter(name="autoRenewal")
    def auto_renewal(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the instance is automatically renewed. Enumerated values:
        """
        return pulumi.get(self, "auto_renewal")

    @_builtins.property
    @pulumi.getter(name="cloudStorageSize")
    def cloud_storage_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        > **NOTE:**  Cloud storage capacity in GB
        """
        return pulumi.get(self, "cloud_storage_size")

    @_builtins.property
    @pulumi.getter(name="cloudStorageType")
    def cloud_storage_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        > **NOTE:** >

        > **NOTE:**  - StandardStorage: Standard cloud storage

        > **NOTE:**  - PerformanceStorage: performance-based cloud storage

        > **NOTE:** - capacity storage: Capacity-based cloud storage
        """
        return pulumi.get(self, "cloud_storage_type")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to enable deletion protection
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The specified duration when the resource is purchased. Only the subscription instances are valid.

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="engineLists")
    def engine_lists(self) -> pulumi.Output[Sequence['outputs.InstanceV2EngineList']]:
        """
        Engine List See `engine_list` below.
        """
        return pulumi.get(self, "engine_lists")

    @_builtins.property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> pulumi.Output[_builtins.str]:
        """
        Instance name
        """
        return pulumi.get(self, "instance_alias")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Purchase duration unit: Month, Year

        > **NOTE:** The parameter is immutable after resource creation. It only applies during resource creation and has no effect when modified post-creation.
        """
        return pulumi.get(self, "pricing_cycle")

    @_builtins.property
    @pulumi.getter(name="primaryVswitchId")
    def primary_vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Primary zone VswitchId
        """
        return pulumi.get(self, "primary_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="primaryZoneId")
    def primary_zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Primary zone ZoneID
        """
        return pulumi.get(self, "primary_zone_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="standbyVswitchId")
    def standby_vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Standby zone VswitchId
        """
        return pulumi.get(self, "standby_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="standbyZoneId")
    def standby_zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Standby zone ZoneID
        """
        return pulumi.get(self, "standby_zone_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        VpcId
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        VswitchId
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID  of the resource
        """
        return pulumi.get(self, "zone_id")

