# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EtlArgs', 'Etl']

@pulumi.input_type
class EtlArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 etl_name: pulumi.Input[_builtins.str],
                 etl_sinks: pulumi.Input[Sequence[pulumi.Input['EtlEtlSinkArgs']]],
                 logstore: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 script: pulumi.Input[_builtins.str],
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 etl_type: Optional[pulumi.Input[_builtins.str]] = None,
                 from_time: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_encrypted_access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_access_key_id_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kms_encryption_access_key_secret_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.int]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 to_time: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Etl resource.
        :param pulumi.Input[_builtins.str] display_name: Log service etl job alias.
        :param pulumi.Input[_builtins.str] etl_name: The name of the log etl job.
        :param pulumi.Input[Sequence[pulumi.Input['EtlEtlSinkArgs']]] etl_sinks: Target logstore configuration for delivery after data processing. See `etl_sinks` below.
        :param pulumi.Input[_builtins.str] logstore: The source logstore of the processing job.
        :param pulumi.Input[_builtins.str] project: The name of the project where the etl job is located.
        :param pulumi.Input[_builtins.str] script: Processing operation grammar.
        :param pulumi.Input[_builtins.str] access_key_id: Source logstore access key id.
        :param pulumi.Input[_builtins.str] access_key_secret: Source logstore access key secret.
        :param pulumi.Input[_builtins.int] create_time: The etl job create time.
        :param pulumi.Input[_builtins.str] description: Description of the log etl job.
        :param pulumi.Input[_builtins.str] etl_type: Log service etl type, the default value is `ETL`.
        :param pulumi.Input[_builtins.int] from_time: The start time of the processing job, if not set the value is 0, indicates to start processing from the oldest data.
        :param pulumi.Input[_builtins.str] kms_encrypted_access_key_id: An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        :param pulumi.Input[_builtins.str] kms_encrypted_access_key_secret: An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_access_key_id_context: An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_access_key_secret_context: An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] lang: The language of the etl job.
        :param pulumi.Input[_builtins.int] last_modified_time: ETL job last modified time.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Advanced parameter configuration of processing operations.
        :param pulumi.Input[_builtins.str] role_arn: Sts role info under source logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        :param pulumi.Input[_builtins.str] schedule: Job scheduling type, the default value is Resident.
        :param pulumi.Input[_builtins.str] status: Log project tags. the default value is RUNNING, Only 4 values are supported: `STARTING`，`RUNNING`，`STOPPING`，`STOPPED`.
        :param pulumi.Input[_builtins.int] to_time: Deadline of processing job, if not set the value is 0, indicates that new data will be processed continuously.
        :param pulumi.Input[_builtins.int] version: Log etl job version. the default value is `2`.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "etl_name", etl_name)
        pulumi.set(__self__, "etl_sinks", etl_sinks)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "script", script)
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if access_key_secret is not None:
            pulumi.set(__self__, "access_key_secret", access_key_secret)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etl_type is not None:
            pulumi.set(__self__, "etl_type", etl_type)
        if from_time is not None:
            pulumi.set(__self__, "from_time", from_time)
        if kms_encrypted_access_key_id is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_id", kms_encrypted_access_key_id)
        if kms_encrypted_access_key_secret is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_secret", kms_encrypted_access_key_secret)
        if kms_encryption_access_key_id_context is not None:
            pulumi.set(__self__, "kms_encryption_access_key_id_context", kms_encryption_access_key_id_context)
        if kms_encryption_access_key_secret_context is not None:
            pulumi.set(__self__, "kms_encryption_access_key_secret_context", kms_encryption_access_key_secret_context)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if to_time is not None:
            pulumi.set(__self__, "to_time", to_time)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Log service etl job alias.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="etlName")
    def etl_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the log etl job.
        """
        return pulumi.get(self, "etl_name")

    @etl_name.setter
    def etl_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "etl_name", value)

    @_builtins.property
    @pulumi.getter(name="etlSinks")
    def etl_sinks(self) -> pulumi.Input[Sequence[pulumi.Input['EtlEtlSinkArgs']]]:
        """
        Target logstore configuration for delivery after data processing. See `etl_sinks` below.
        """
        return pulumi.get(self, "etl_sinks")

    @etl_sinks.setter
    def etl_sinks(self, value: pulumi.Input[Sequence[pulumi.Input['EtlEtlSinkArgs']]]):
        pulumi.set(self, "etl_sinks", value)

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> pulumi.Input[_builtins.str]:
        """
        The source logstore of the processing job.
        """
        return pulumi.get(self, "logstore")

    @logstore.setter
    def logstore(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "logstore", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project where the etl job is located.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def script(self) -> pulumi.Input[_builtins.str]:
        """
        Processing operation grammar.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "script", value)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source logstore access key id.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="accessKeySecret")
    def access_key_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source logstore access key secret.
        """
        return pulumi.get(self, "access_key_secret")

    @access_key_secret.setter
    def access_key_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_secret", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The etl job create time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the log etl job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="etlType")
    def etl_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log service etl type, the default value is `ETL`.
        """
        return pulumi.get(self, "etl_type")

    @etl_type.setter
    def etl_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etl_type", value)

    @_builtins.property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The start time of the processing job, if not set the value is 0, indicates to start processing from the oldest data.
        """
        return pulumi.get(self, "from_time")

    @from_time.setter
    def from_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "from_time", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedAccessKeyId")
    def kms_encrypted_access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_id")

    @kms_encrypted_access_key_id.setter
    def kms_encrypted_access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedAccessKeySecret")
    def kms_encrypted_access_key_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_secret")

    @kms_encrypted_access_key_secret.setter
    def kms_encrypted_access_key_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_access_key_secret", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionAccessKeyIdContext")
    def kms_encryption_access_key_id_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encryption_access_key_id_context")

    @kms_encryption_access_key_id_context.setter
    def kms_encryption_access_key_id_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_access_key_id_context", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionAccessKeySecretContext")
    def kms_encryption_access_key_secret_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encryption_access_key_secret_context")

    @kms_encryption_access_key_secret_context.setter
    def kms_encryption_access_key_secret_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_access_key_secret_context", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the etl job.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ETL job last modified time.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Advanced parameter configuration of processing operations.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sts role info under source logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job scheduling type, the default value is Resident.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log project tags. the default value is RUNNING, Only 4 values are supported: `STARTING`，`RUNNING`，`STOPPING`，`STOPPED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="toTime")
    def to_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Deadline of processing job, if not set the value is 0, indicates that new data will be processed continuously.
        """
        return pulumi.get(self, "to_time")

    @to_time.setter
    def to_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "to_time", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Log etl job version. the default value is `2`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _EtlState:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 etl_name: Optional[pulumi.Input[_builtins.str]] = None,
                 etl_sinks: Optional[pulumi.Input[Sequence[pulumi.Input['EtlEtlSinkArgs']]]] = None,
                 etl_type: Optional[pulumi.Input[_builtins.str]] = None,
                 from_time: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_encrypted_access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_access_key_id_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kms_encryption_access_key_secret_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.int]] = None,
                 logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 script: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 to_time: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Etl resources.
        :param pulumi.Input[_builtins.str] access_key_id: Source logstore access key id.
        :param pulumi.Input[_builtins.str] access_key_secret: Source logstore access key secret.
        :param pulumi.Input[_builtins.int] create_time: The etl job create time.
        :param pulumi.Input[_builtins.str] description: Description of the log etl job.
        :param pulumi.Input[_builtins.str] display_name: Log service etl job alias.
        :param pulumi.Input[_builtins.str] etl_name: The name of the log etl job.
        :param pulumi.Input[Sequence[pulumi.Input['EtlEtlSinkArgs']]] etl_sinks: Target logstore configuration for delivery after data processing. See `etl_sinks` below.
        :param pulumi.Input[_builtins.str] etl_type: Log service etl type, the default value is `ETL`.
        :param pulumi.Input[_builtins.int] from_time: The start time of the processing job, if not set the value is 0, indicates to start processing from the oldest data.
        :param pulumi.Input[_builtins.str] kms_encrypted_access_key_id: An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        :param pulumi.Input[_builtins.str] kms_encrypted_access_key_secret: An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_access_key_id_context: An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_access_key_secret_context: An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] lang: The language of the etl job.
        :param pulumi.Input[_builtins.int] last_modified_time: ETL job last modified time.
        :param pulumi.Input[_builtins.str] logstore: The source logstore of the processing job.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Advanced parameter configuration of processing operations.
        :param pulumi.Input[_builtins.str] project: The name of the project where the etl job is located.
        :param pulumi.Input[_builtins.str] role_arn: Sts role info under source logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        :param pulumi.Input[_builtins.str] schedule: Job scheduling type, the default value is Resident.
        :param pulumi.Input[_builtins.str] script: Processing operation grammar.
        :param pulumi.Input[_builtins.str] status: Log project tags. the default value is RUNNING, Only 4 values are supported: `STARTING`，`RUNNING`，`STOPPING`，`STOPPED`.
        :param pulumi.Input[_builtins.int] to_time: Deadline of processing job, if not set the value is 0, indicates that new data will be processed continuously.
        :param pulumi.Input[_builtins.int] version: Log etl job version. the default value is `2`.
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if access_key_secret is not None:
            pulumi.set(__self__, "access_key_secret", access_key_secret)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etl_name is not None:
            pulumi.set(__self__, "etl_name", etl_name)
        if etl_sinks is not None:
            pulumi.set(__self__, "etl_sinks", etl_sinks)
        if etl_type is not None:
            pulumi.set(__self__, "etl_type", etl_type)
        if from_time is not None:
            pulumi.set(__self__, "from_time", from_time)
        if kms_encrypted_access_key_id is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_id", kms_encrypted_access_key_id)
        if kms_encrypted_access_key_secret is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_secret", kms_encrypted_access_key_secret)
        if kms_encryption_access_key_id_context is not None:
            pulumi.set(__self__, "kms_encryption_access_key_id_context", kms_encryption_access_key_id_context)
        if kms_encryption_access_key_secret_context is not None:
            pulumi.set(__self__, "kms_encryption_access_key_secret_context", kms_encryption_access_key_secret_context)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if logstore is not None:
            pulumi.set(__self__, "logstore", logstore)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if to_time is not None:
            pulumi.set(__self__, "to_time", to_time)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source logstore access key id.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="accessKeySecret")
    def access_key_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source logstore access key secret.
        """
        return pulumi.get(self, "access_key_secret")

    @access_key_secret.setter
    def access_key_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key_secret", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The etl job create time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the log etl job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log service etl job alias.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="etlName")
    def etl_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the log etl job.
        """
        return pulumi.get(self, "etl_name")

    @etl_name.setter
    def etl_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etl_name", value)

    @_builtins.property
    @pulumi.getter(name="etlSinks")
    def etl_sinks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EtlEtlSinkArgs']]]]:
        """
        Target logstore configuration for delivery after data processing. See `etl_sinks` below.
        """
        return pulumi.get(self, "etl_sinks")

    @etl_sinks.setter
    def etl_sinks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EtlEtlSinkArgs']]]]):
        pulumi.set(self, "etl_sinks", value)

    @_builtins.property
    @pulumi.getter(name="etlType")
    def etl_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log service etl type, the default value is `ETL`.
        """
        return pulumi.get(self, "etl_type")

    @etl_type.setter
    def etl_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etl_type", value)

    @_builtins.property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The start time of the processing job, if not set the value is 0, indicates to start processing from the oldest data.
        """
        return pulumi.get(self, "from_time")

    @from_time.setter
    def from_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "from_time", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedAccessKeyId")
    def kms_encrypted_access_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_id")

    @kms_encrypted_access_key_id.setter
    def kms_encrypted_access_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_access_key_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedAccessKeySecret")
    def kms_encrypted_access_key_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_secret")

    @kms_encrypted_access_key_secret.setter
    def kms_encrypted_access_key_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_access_key_secret", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionAccessKeyIdContext")
    def kms_encryption_access_key_id_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encryption_access_key_id_context")

    @kms_encryption_access_key_id_context.setter
    def kms_encryption_access_key_id_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_access_key_id_context", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionAccessKeySecretContext")
    def kms_encryption_access_key_secret_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encryption_access_key_secret_context")

    @kms_encryption_access_key_secret_context.setter
    def kms_encryption_access_key_secret_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_access_key_secret_context", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the etl job.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ETL job last modified time.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source logstore of the processing job.
        """
        return pulumi.get(self, "logstore")

    @logstore.setter
    def logstore(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logstore", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Advanced parameter configuration of processing operations.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project where the etl job is located.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sts role info under source logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job scheduling type, the default value is Resident.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Processing operation grammar.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log project tags. the default value is RUNNING, Only 4 values are supported: `STARTING`，`RUNNING`，`STOPPING`，`STOPPED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="toTime")
    def to_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Deadline of processing job, if not set the value is 0, indicates that new data will be processed continuously.
        """
        return pulumi.get(self, "to_time")

    @to_time.setter
    def to_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "to_time", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Log etl job version. the default value is `2`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("alicloud:log/etl:Etl")
class Etl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 etl_name: Optional[pulumi.Input[_builtins.str]] = None,
                 etl_sinks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EtlEtlSinkArgs', 'EtlEtlSinkArgsDict']]]]] = None,
                 etl_type: Optional[pulumi.Input[_builtins.str]] = None,
                 from_time: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_encrypted_access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_access_key_id_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kms_encryption_access_key_secret_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.int]] = None,
                 logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 script: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 to_time: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        The data transformation of the log service is a hosted, highly available, and scalable data processing service,
        which is widely applicable to scenarios such as data regularization, enrichment, distribution, aggregation, and index reconstruction.
        [Refer to details](https://www.alibabacloud.com/help/zh/doc-detail/125384.htm).

        > **NOTE:** This resource is no longer maintained. It is recommended to use the new resource alicloud_sls_etl.
        [Refer to details](https://www.alibabacloud.com/help/zh/doc-detail/125384.htm).

        > **NOTE:** Available since v1.120.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            project_name=f"terraform-example-{default['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project_name=example.project_name,
            logstore_name="example-store",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example2 = alicloud.log.Store("example2",
            project_name=example.project_name,
            logstore_name="example-store2",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example3 = alicloud.log.Store("example3",
            project_name=example.project_name,
            logstore_name="example-store3",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_etl = alicloud.log.Etl("example",
            etl_name="terraform-example",
            project=example.project_name,
            display_name="terraform-example",
            description="terraform-example",
            access_key_id="access_key_id",
            access_key_secret="access_key_secret",
            script="e_set('new','key')",
            logstore=example_store.logstore_name,
            etl_sinks=[
                {
                    "name": "target_name",
                    "access_key_id": "example2_access_key_id",
                    "access_key_secret": "example2_access_key_secret",
                    "endpoint": "cn-hangzhou.log.aliyuncs.com",
                    "project": example.project_name,
                    "logstore": example2.logstore_name,
                },
                {
                    "name": "target_name2",
                    "access_key_id": "example3_access_key_id",
                    "access_key_secret": "example3_access_key_secret",
                    "endpoint": "cn-hangzhou.log.aliyuncs.com",
                    "project": example.project_name,
                    "logstore": example3.logstore_name,
                },
            ])
        ```

        ## Import

        Log etl can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:log/etl:Etl example tf-log-project:tf-log-etl-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_id: Source logstore access key id.
        :param pulumi.Input[_builtins.str] access_key_secret: Source logstore access key secret.
        :param pulumi.Input[_builtins.int] create_time: The etl job create time.
        :param pulumi.Input[_builtins.str] description: Description of the log etl job.
        :param pulumi.Input[_builtins.str] display_name: Log service etl job alias.
        :param pulumi.Input[_builtins.str] etl_name: The name of the log etl job.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EtlEtlSinkArgs', 'EtlEtlSinkArgsDict']]]] etl_sinks: Target logstore configuration for delivery after data processing. See `etl_sinks` below.
        :param pulumi.Input[_builtins.str] etl_type: Log service etl type, the default value is `ETL`.
        :param pulumi.Input[_builtins.int] from_time: The start time of the processing job, if not set the value is 0, indicates to start processing from the oldest data.
        :param pulumi.Input[_builtins.str] kms_encrypted_access_key_id: An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        :param pulumi.Input[_builtins.str] kms_encrypted_access_key_secret: An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_access_key_id_context: An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_access_key_secret_context: An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] lang: The language of the etl job.
        :param pulumi.Input[_builtins.int] last_modified_time: ETL job last modified time.
        :param pulumi.Input[_builtins.str] logstore: The source logstore of the processing job.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Advanced parameter configuration of processing operations.
        :param pulumi.Input[_builtins.str] project: The name of the project where the etl job is located.
        :param pulumi.Input[_builtins.str] role_arn: Sts role info under source logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        :param pulumi.Input[_builtins.str] schedule: Job scheduling type, the default value is Resident.
        :param pulumi.Input[_builtins.str] script: Processing operation grammar.
        :param pulumi.Input[_builtins.str] status: Log project tags. the default value is RUNNING, Only 4 values are supported: `STARTING`，`RUNNING`，`STOPPING`，`STOPPED`.
        :param pulumi.Input[_builtins.int] to_time: Deadline of processing job, if not set the value is 0, indicates that new data will be processed continuously.
        :param pulumi.Input[_builtins.int] version: Log etl job version. the default value is `2`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EtlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The data transformation of the log service is a hosted, highly available, and scalable data processing service,
        which is widely applicable to scenarios such as data regularization, enrichment, distribution, aggregation, and index reconstruction.
        [Refer to details](https://www.alibabacloud.com/help/zh/doc-detail/125384.htm).

        > **NOTE:** This resource is no longer maintained. It is recommended to use the new resource alicloud_sls_etl.
        [Refer to details](https://www.alibabacloud.com/help/zh/doc-detail/125384.htm).

        > **NOTE:** Available since v1.120.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            project_name=f"terraform-example-{default['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project_name=example.project_name,
            logstore_name="example-store",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example2 = alicloud.log.Store("example2",
            project_name=example.project_name,
            logstore_name="example-store2",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example3 = alicloud.log.Store("example3",
            project_name=example.project_name,
            logstore_name="example-store3",
            retention_period=3650,
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        example_etl = alicloud.log.Etl("example",
            etl_name="terraform-example",
            project=example.project_name,
            display_name="terraform-example",
            description="terraform-example",
            access_key_id="access_key_id",
            access_key_secret="access_key_secret",
            script="e_set('new','key')",
            logstore=example_store.logstore_name,
            etl_sinks=[
                {
                    "name": "target_name",
                    "access_key_id": "example2_access_key_id",
                    "access_key_secret": "example2_access_key_secret",
                    "endpoint": "cn-hangzhou.log.aliyuncs.com",
                    "project": example.project_name,
                    "logstore": example2.logstore_name,
                },
                {
                    "name": "target_name2",
                    "access_key_id": "example3_access_key_id",
                    "access_key_secret": "example3_access_key_secret",
                    "endpoint": "cn-hangzhou.log.aliyuncs.com",
                    "project": example.project_name,
                    "logstore": example3.logstore_name,
                },
            ])
        ```

        ## Import

        Log etl can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:log/etl:Etl example tf-log-project:tf-log-etl-name
        ```

        :param str resource_name: The name of the resource.
        :param EtlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EtlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 etl_name: Optional[pulumi.Input[_builtins.str]] = None,
                 etl_sinks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EtlEtlSinkArgs', 'EtlEtlSinkArgsDict']]]]] = None,
                 etl_type: Optional[pulumi.Input[_builtins.str]] = None,
                 from_time: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_encrypted_access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_access_key_id_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kms_encryption_access_key_secret_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.int]] = None,
                 logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 script: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 to_time: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EtlArgs.__new__(EtlArgs)

            __props__.__dict__["access_key_id"] = None if access_key_id is None else pulumi.Output.secret(access_key_id)
            __props__.__dict__["access_key_secret"] = None if access_key_secret is None else pulumi.Output.secret(access_key_secret)
            __props__.__dict__["create_time"] = create_time
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if etl_name is None and not opts.urn:
                raise TypeError("Missing required property 'etl_name'")
            __props__.__dict__["etl_name"] = etl_name
            if etl_sinks is None and not opts.urn:
                raise TypeError("Missing required property 'etl_sinks'")
            __props__.__dict__["etl_sinks"] = etl_sinks
            __props__.__dict__["etl_type"] = etl_type
            __props__.__dict__["from_time"] = from_time
            __props__.__dict__["kms_encrypted_access_key_id"] = kms_encrypted_access_key_id
            __props__.__dict__["kms_encrypted_access_key_secret"] = kms_encrypted_access_key_secret
            __props__.__dict__["kms_encryption_access_key_id_context"] = kms_encryption_access_key_id_context
            __props__.__dict__["kms_encryption_access_key_secret_context"] = kms_encryption_access_key_secret_context
            __props__.__dict__["lang"] = lang
            __props__.__dict__["last_modified_time"] = last_modified_time
            if logstore is None and not opts.urn:
                raise TypeError("Missing required property 'logstore'")
            __props__.__dict__["logstore"] = logstore
            __props__.__dict__["parameters"] = parameters
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["schedule"] = schedule
            if script is None and not opts.urn:
                raise TypeError("Missing required property 'script'")
            __props__.__dict__["script"] = script
            __props__.__dict__["status"] = status
            __props__.__dict__["to_time"] = to_time
            __props__.__dict__["version"] = version
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessKeyId", "accessKeySecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Etl, __self__).__init__(
            'alicloud:log/etl:Etl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            etl_name: Optional[pulumi.Input[_builtins.str]] = None,
            etl_sinks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EtlEtlSinkArgs', 'EtlEtlSinkArgsDict']]]]] = None,
            etl_type: Optional[pulumi.Input[_builtins.str]] = None,
            from_time: Optional[pulumi.Input[_builtins.int]] = None,
            kms_encrypted_access_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encrypted_access_key_secret: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encryption_access_key_id_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            kms_encryption_access_key_secret_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified_time: Optional[pulumi.Input[_builtins.int]] = None,
            logstore: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            schedule: Optional[pulumi.Input[_builtins.str]] = None,
            script: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            to_time: Optional[pulumi.Input[_builtins.int]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'Etl':
        """
        Get an existing Etl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key_id: Source logstore access key id.
        :param pulumi.Input[_builtins.str] access_key_secret: Source logstore access key secret.
        :param pulumi.Input[_builtins.int] create_time: The etl job create time.
        :param pulumi.Input[_builtins.str] description: Description of the log etl job.
        :param pulumi.Input[_builtins.str] display_name: Log service etl job alias.
        :param pulumi.Input[_builtins.str] etl_name: The name of the log etl job.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EtlEtlSinkArgs', 'EtlEtlSinkArgsDict']]]] etl_sinks: Target logstore configuration for delivery after data processing. See `etl_sinks` below.
        :param pulumi.Input[_builtins.str] etl_type: Log service etl type, the default value is `ETL`.
        :param pulumi.Input[_builtins.int] from_time: The start time of the processing job, if not set the value is 0, indicates to start processing from the oldest data.
        :param pulumi.Input[_builtins.str] kms_encrypted_access_key_id: An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        :param pulumi.Input[_builtins.str] kms_encrypted_access_key_secret: An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_access_key_id_context: An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_access_key_secret_context: An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        :param pulumi.Input[_builtins.str] lang: The language of the etl job.
        :param pulumi.Input[_builtins.int] last_modified_time: ETL job last modified time.
        :param pulumi.Input[_builtins.str] logstore: The source logstore of the processing job.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Advanced parameter configuration of processing operations.
        :param pulumi.Input[_builtins.str] project: The name of the project where the etl job is located.
        :param pulumi.Input[_builtins.str] role_arn: Sts role info under source logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        :param pulumi.Input[_builtins.str] schedule: Job scheduling type, the default value is Resident.
        :param pulumi.Input[_builtins.str] script: Processing operation grammar.
        :param pulumi.Input[_builtins.str] status: Log project tags. the default value is RUNNING, Only 4 values are supported: `STARTING`，`RUNNING`，`STOPPING`，`STOPPED`.
        :param pulumi.Input[_builtins.int] to_time: Deadline of processing job, if not set the value is 0, indicates that new data will be processed continuously.
        :param pulumi.Input[_builtins.int] version: Log etl job version. the default value is `2`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EtlState.__new__(_EtlState)

        __props__.__dict__["access_key_id"] = access_key_id
        __props__.__dict__["access_key_secret"] = access_key_secret
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["etl_name"] = etl_name
        __props__.__dict__["etl_sinks"] = etl_sinks
        __props__.__dict__["etl_type"] = etl_type
        __props__.__dict__["from_time"] = from_time
        __props__.__dict__["kms_encrypted_access_key_id"] = kms_encrypted_access_key_id
        __props__.__dict__["kms_encrypted_access_key_secret"] = kms_encrypted_access_key_secret
        __props__.__dict__["kms_encryption_access_key_id_context"] = kms_encryption_access_key_id_context
        __props__.__dict__["kms_encryption_access_key_secret_context"] = kms_encryption_access_key_secret_context
        __props__.__dict__["lang"] = lang
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["logstore"] = logstore
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["project"] = project
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["script"] = script
        __props__.__dict__["status"] = status
        __props__.__dict__["to_time"] = to_time
        __props__.__dict__["version"] = version
        return Etl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Source logstore access key id.
        """
        return pulumi.get(self, "access_key_id")

    @_builtins.property
    @pulumi.getter(name="accessKeySecret")
    def access_key_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Source logstore access key secret.
        """
        return pulumi.get(self, "access_key_secret")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        The etl job create time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the log etl job.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Log service etl job alias.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="etlName")
    def etl_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the log etl job.
        """
        return pulumi.get(self, "etl_name")

    @_builtins.property
    @pulumi.getter(name="etlSinks")
    def etl_sinks(self) -> pulumi.Output[Sequence['outputs.EtlEtlSink']]:
        """
        Target logstore configuration for delivery after data processing. See `etl_sinks` below.
        """
        return pulumi.get(self, "etl_sinks")

    @_builtins.property
    @pulumi.getter(name="etlType")
    def etl_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Log service etl type, the default value is `ETL`.
        """
        return pulumi.get(self, "etl_type")

    @_builtins.property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The start time of the processing job, if not set the value is 0, indicates to start processing from the oldest data.
        """
        return pulumi.get(self, "from_time")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedAccessKeyId")
    def kms_encrypted_access_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_id")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedAccessKeySecret")
    def kms_encrypted_access_key_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_secret")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionAccessKeyIdContext")
    def kms_encryption_access_key_id_context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_access_key_id` before creating or updating an instance with `kms_encrypted_access_key_id`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encryption_access_key_id_context")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionAccessKeySecretContext")
    def kms_encryption_access_key_secret_context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_access_key_secret` before creating or updating an instance with `kms_encrypted_access_key_secret`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set. When it is changed, the instance will reboot to make the change take effect.
        """
        return pulumi.get(self, "kms_encryption_access_key_secret_context")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The language of the etl job.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[_builtins.int]:
        """
        ETL job last modified time.
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> pulumi.Output[_builtins.str]:
        """
        The source logstore of the processing job.
        """
        return pulumi.get(self, "logstore")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Advanced parameter configuration of processing operations.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project where the etl job is located.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sts role info under source logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret, kms_encryption_access_key_id_context, kms_encryption_access_key_secret_context)` to use KMS to get the key pair.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Job scheduling type, the default value is Resident.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def script(self) -> pulumi.Output[_builtins.str]:
        """
        Processing operation grammar.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Log project tags. the default value is RUNNING, Only 4 values are supported: `STARTING`，`RUNNING`，`STOPPING`，`STOPPED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="toTime")
    def to_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Deadline of processing job, if not set the value is 0, indicates that new data will be processed continuously.
        """
        return pulumi.get(self, "to_time")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Log etl job version. the default value is `2`.
        """
        return pulumi.get(self, "version")

