# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AlertAnnotation',
    'AlertGroupConfiguration',
    'AlertJoinConfiguration',
    'AlertLabel',
    'AlertNotificationList',
    'AlertPolicyConfiguration',
    'AlertQueryList',
    'AlertSchedule',
    'AlertSeverityConfiguration',
    'AlertTemplateConfiguration',
    'EtlEtlSink',
    'OssExportConfigColumn',
    'OssShipperParquetConfig',
    'StoreEncryptConf',
    'StoreEncryptConfUserCmkInfo',
    'StoreIndexFieldSearch',
    'StoreIndexFieldSearchJsonKey',
    'StoreIndexFullText',
    'StoreShard',
    'GetProjectsProjectResult',
    'GetStoresStoreResult',
]

@pulumi.output_type
class AlertAnnotation(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: Annotations's key for new alert.
        :param _builtins.str value: Annotations's value for new alert.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Annotations's key for new alert.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Annotations's value for new alert.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AlertGroupConfiguration(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 fields: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str type: Group configuration type, including no_group, labels_auto, custom.
        """
        pulumi.set(__self__, "type", type)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Group configuration type, including no_group, labels_auto, custom.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "fields")


@pulumi.output_type
class AlertJoinConfiguration(dict):
    def __init__(__self__, *,
                 condition: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str condition: Join condition.
        :param _builtins.str type: Join type, including cross_join, inner_join, left_join, right_join, full_join, left_exclude, right_exclude, concat, no_join.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        Join condition.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Join type, including cross_join, inner_join, left_join, right_join, full_join, left_exclude, right_exclude, concat, no_join.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AlertLabel(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: Labels's key for new alert.
        :param _builtins.str value: Labels's value for new alert.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Labels's key for new alert.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Labels's value for new alert.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AlertNotificationList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailLists":
            suggest = "email_lists"
        elif key == "mobileLists":
            suggest = "mobile_lists"
        elif key == "serviceUri":
            suggest = "service_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertNotificationList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertNotificationList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertNotificationList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: _builtins.str,
                 type: _builtins.str,
                 email_lists: Optional[Sequence[_builtins.str]] = None,
                 mobile_lists: Optional[Sequence[_builtins.str]] = None,
                 service_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str content: Notice content of alarm.
        :param _builtins.str type: Notification type. support Email, SMS, DingTalk, MessageCenter.
        :param Sequence[_builtins.str] email_lists: Email address list.
        :param Sequence[_builtins.str] mobile_lists: SMS sending mobile number.
        :param _builtins.str service_uri: Request address.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "type", type)
        if email_lists is not None:
            pulumi.set(__self__, "email_lists", email_lists)
        if mobile_lists is not None:
            pulumi.set(__self__, "mobile_lists", mobile_lists)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Notice content of alarm.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Notification type. support Email, SMS, DingTalk, MessageCenter.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="emailLists")
    def email_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        Email address list.
        """
        return pulumi.get(self, "email_lists")

    @_builtins.property
    @pulumi.getter(name="mobileLists")
    def mobile_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        SMS sending mobile number.
        """
        return pulumi.get(self, "mobile_lists")

    @_builtins.property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[_builtins.str]:
        """
        Request address.
        """
        return pulumi.get(self, "service_uri")


@pulumi.output_type
class AlertPolicyConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertPolicyId":
            suggest = "alert_policy_id"
        elif key == "repeatInterval":
            suggest = "repeat_interval"
        elif key == "actionPolicyId":
            suggest = "action_policy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_policy_id: _builtins.str,
                 repeat_interval: _builtins.str,
                 action_policy_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str alert_policy_id: Alert Policy Id.
        :param _builtins.str repeat_interval: Repeat interval used by alert policy, 1h, 1m.e.g.
        :param _builtins.str action_policy_id: Action Policy Id.
        """
        pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        pulumi.set(__self__, "repeat_interval", repeat_interval)
        if action_policy_id is not None:
            pulumi.set(__self__, "action_policy_id", action_policy_id)

    @_builtins.property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> _builtins.str:
        """
        Alert Policy Id.
        """
        return pulumi.get(self, "alert_policy_id")

    @_builtins.property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> _builtins.str:
        """
        Repeat interval used by alert policy, 1h, 1m.e.g.
        """
        return pulumi.get(self, "repeat_interval")

    @_builtins.property
    @pulumi.getter(name="actionPolicyId")
    def action_policy_id(self) -> Optional[_builtins.str]:
        """
        Action Policy Id.
        """
        return pulumi.get(self, "action_policy_id")


@pulumi.output_type
class AlertQueryList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartTitle":
            suggest = "chart_title"
        elif key == "dashboardId":
            suggest = "dashboard_id"
        elif key == "powerSqlMode":
            suggest = "power_sql_mode"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "storeType":
            suggest = "store_type"
        elif key == "timeSpanType":
            suggest = "time_span_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertQueryList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertQueryList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertQueryList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end: _builtins.str,
                 query: _builtins.str,
                 start: _builtins.str,
                 chart_title: Optional[_builtins.str] = None,
                 dashboard_id: Optional[_builtins.str] = None,
                 logstore: Optional[_builtins.str] = None,
                 power_sql_mode: Optional[_builtins.str] = None,
                 project: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 role_arn: Optional[_builtins.str] = None,
                 store: Optional[_builtins.str] = None,
                 store_type: Optional[_builtins.str] = None,
                 time_span_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str end: End time. example: 20s.
        :param _builtins.str query: Query corresponding to chart. example: * AND aliyun.
        :param _builtins.str start: Begin time. example: -60s.
        :param _builtins.str chart_title: Chart title, optional from 1.161.0+.
        :param _builtins.str dashboard_id: Query dashboard id.
        :param _builtins.str logstore: Query logstore, use store for new alert, Deprecated from 1.161.0+.
        :param _builtins.str power_sql_mode: default disable, whether to use power sql. support auto, enable, disable.
        :param _builtins.str project: Query project.
        :param _builtins.str region: Query project region.
        :param _builtins.str role_arn: Query project store's ARN.
        :param _builtins.str store: Query store for new alert.
        :param _builtins.str store_type: Query store type for new alert, including log,metric,meta.
        :param _builtins.str time_span_type: default Custom. No need to configure this parameter.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "start", start)
        if chart_title is not None:
            pulumi.set(__self__, "chart_title", chart_title)
        if dashboard_id is not None:
            pulumi.set(__self__, "dashboard_id", dashboard_id)
        if logstore is not None:
            pulumi.set(__self__, "logstore", logstore)
        if power_sql_mode is not None:
            pulumi.set(__self__, "power_sql_mode", power_sql_mode)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if store is not None:
            pulumi.set(__self__, "store", store)
        if store_type is not None:
            pulumi.set(__self__, "store_type", store_type)
        if time_span_type is not None:
            pulumi.set(__self__, "time_span_type", time_span_type)

    @_builtins.property
    @pulumi.getter
    def end(self) -> _builtins.str:
        """
        End time. example: 20s.
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        Query corresponding to chart. example: * AND aliyun.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        """
        Begin time. example: -60s.
        """
        return pulumi.get(self, "start")

    @_builtins.property
    @pulumi.getter(name="chartTitle")
    def chart_title(self) -> Optional[_builtins.str]:
        """
        Chart title, optional from 1.161.0+.
        """
        return pulumi.get(self, "chart_title")

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[_builtins.str]:
        """
        Query dashboard id.
        """
        return pulumi.get(self, "dashboard_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated from 1.161.0+, use store""")
    def logstore(self) -> Optional[_builtins.str]:
        """
        Query logstore, use store for new alert, Deprecated from 1.161.0+.
        """
        return pulumi.get(self, "logstore")

    @_builtins.property
    @pulumi.getter(name="powerSqlMode")
    def power_sql_mode(self) -> Optional[_builtins.str]:
        """
        default disable, whether to use power sql. support auto, enable, disable.
        """
        return pulumi.get(self, "power_sql_mode")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        """
        Query project.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Query project region.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[_builtins.str]:
        """
        Query project store's ARN.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def store(self) -> Optional[_builtins.str]:
        """
        Query store for new alert.
        """
        return pulumi.get(self, "store")

    @_builtins.property
    @pulumi.getter(name="storeType")
    def store_type(self) -> Optional[_builtins.str]:
        """
        Query store type for new alert, including log,metric,meta.
        """
        return pulumi.get(self, "store_type")

    @_builtins.property
    @pulumi.getter(name="timeSpanType")
    def time_span_type(self) -> Optional[_builtins.str]:
        """
        default Custom. No need to configure this parameter.
        """
        return pulumi.get(self, "time_span_type")


@pulumi.output_type
class AlertSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "runImmediately":
            suggest = "run_immediately"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 cron_expression: Optional[_builtins.str] = None,
                 day_of_week: Optional[_builtins.int] = None,
                 delay: Optional[_builtins.int] = None,
                 hour: Optional[_builtins.int] = None,
                 interval: Optional[_builtins.str] = None,
                 run_immediately: Optional[_builtins.bool] = None,
                 time_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: including FixedRate,Hourly,Daily,Weekly,Cron.
        :param _builtins.str cron_expression: Cron expression when type is Cron.
        :param _builtins.int day_of_week: Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
        :param _builtins.int hour: Hour of day when type is Weekly/Daily.
        :param _builtins.str interval: Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
        :param _builtins.str time_zone: Time zone for schedule.
        """
        pulumi.set(__self__, "type", type)
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if run_immediately is not None:
            pulumi.set(__self__, "run_immediately", run_immediately)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        including FixedRate,Hourly,Daily,Weekly,Cron.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[_builtins.str]:
        """
        Cron expression when type is Cron.
        """
        return pulumi.get(self, "cron_expression")

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[_builtins.int]:
        """
        Day of week when type is Weekly, including 0,1,2,3,4,5,6, 0 for Sunday, 1 for Monday
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter
    def hour(self) -> Optional[_builtins.int]:
        """
        Hour of day when type is Weekly/Daily.
        """
        return pulumi.get(self, "hour")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.str]:
        """
        Execution interval. 60 seconds minimum, such as 60s, 1h. used when type is FixedRate.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="runImmediately")
    def run_immediately(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "run_immediately")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        Time zone for schedule.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class AlertSeverityConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evalCondition":
            suggest = "eval_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertSeverityConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertSeverityConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertSeverityConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eval_condition: Mapping[str, _builtins.str],
                 severity: _builtins.int):
        """
        :param Mapping[str, _builtins.str] eval_condition: Severity when this condition is met.
        :param _builtins.int severity: Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
        """
        pulumi.set(__self__, "eval_condition", eval_condition)
        pulumi.set(__self__, "severity", severity)

    @_builtins.property
    @pulumi.getter(name="evalCondition")
    def eval_condition(self) -> Mapping[str, _builtins.str]:
        """
        Severity when this condition is met.
        """
        return pulumi.get(self, "eval_condition")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.int:
        """
        Severity for new alert, including 2,4,6,8,10 for Report,Low,Medium,High,Critical.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class AlertTemplateConfiguration(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 type: _builtins.str,
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 lang: Optional[_builtins.str] = None,
                 tokens: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str id: Alert template id.
        :param _builtins.str type: Alert template type including `sys`, `user`.
        :param Mapping[str, _builtins.str] annotations: Alert template annotations.
        :param _builtins.str lang: Alert template language including `cn`, `en`.
        :param Mapping[str, _builtins.str] tokens: Alert template tokens.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Alert template id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Alert template type including `sys`, `user`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Alert template annotations.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[_builtins.str]:
        """
        Alert template language including `cn`, `en`.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter
    def tokens(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Alert template tokens.
        """
        return pulumi.get(self, "tokens")


@pulumi.output_type
class EtlEtlSink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "accessKeySecret":
            suggest = "access_key_secret"
        elif key == "kmsEncryptedAccessKeyId":
            suggest = "kms_encrypted_access_key_id"
        elif key == "kmsEncryptedAccessKeySecret":
            suggest = "kms_encrypted_access_key_secret"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EtlEtlSink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EtlEtlSink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EtlEtlSink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: _builtins.str,
                 logstore: _builtins.str,
                 name: _builtins.str,
                 project: _builtins.str,
                 access_key_id: Optional[_builtins.str] = None,
                 access_key_secret: Optional[_builtins.str] = None,
                 datasets: Optional[Sequence[_builtins.str]] = None,
                 kms_encrypted_access_key_id: Optional[_builtins.str] = None,
                 kms_encrypted_access_key_secret: Optional[_builtins.str] = None,
                 role_arn: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint: Delivery target logstore region.
        :param _builtins.str logstore: Delivery target logstore.
        :param _builtins.str name: Delivery target name.
        :param _builtins.str project: The project where the target logstore is delivered.
        :param _builtins.str access_key_id: Delivery target logstore access key id.
        :param _builtins.str access_key_secret: Delivery target logstore access key secret.
        :param Sequence[_builtins.str] datasets: LogETL datasets.
               
               > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
        :param _builtins.str kms_encrypted_access_key_id: An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        :param _builtins.str kms_encrypted_access_key_secret: An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        :param _builtins.str role_arn: Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret)` to use KMS to get the key pair.
        :param _builtins.str type: ETL sinks type, the default value is AliyunLOG.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project", project)
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if access_key_secret is not None:
            pulumi.set(__self__, "access_key_secret", access_key_secret)
        if datasets is not None:
            pulumi.set(__self__, "datasets", datasets)
        if kms_encrypted_access_key_id is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_id", kms_encrypted_access_key_id)
        if kms_encrypted_access_key_secret is not None:
            pulumi.set(__self__, "kms_encrypted_access_key_secret", kms_encrypted_access_key_secret)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        Delivery target logstore region.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> _builtins.str:
        """
        Delivery target logstore.
        """
        return pulumi.get(self, "logstore")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Delivery target name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The project where the target logstore is delivered.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[_builtins.str]:
        """
        Delivery target logstore access key id.
        """
        return pulumi.get(self, "access_key_id")

    @_builtins.property
    @pulumi.getter(name="accessKeySecret")
    def access_key_secret(self) -> Optional[_builtins.str]:
        """
        Delivery target logstore access key secret.
        """
        return pulumi.get(self, "access_key_secret")

    @_builtins.property
    @pulumi.getter
    def datasets(self) -> Optional[Sequence[_builtins.str]]:
        """
        LogETL datasets.

        > **Note:** `from_time` and `to_time` no modification allowed after successful creation.
        """
        return pulumi.get(self, "datasets")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedAccessKeyId")
    def kms_encrypted_access_key_id(self) -> Optional[_builtins.str]:
        """
        An KMS encrypts access key id used to a log etl job. If the `access_key_id` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_id")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedAccessKeySecret")
    def kms_encrypted_access_key_secret(self) -> Optional[_builtins.str]:
        """
        An KMS encrypts access key secret used to a log etl job. If the `access_key_secret` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_access_key_secret")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[_builtins.str]:
        """
        Sts role info under delivery target logstore. `role_arn` and `(access_key_id, access_key_secret)` fill in at most one. If you do not fill in both, then you must fill in `(kms_encrypted_access_key_id, kms_encrypted_access_key_secret)` to use KMS to get the key pair.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        ETL sinks type, the default value is AliyunLOG.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OssExportConfigColumn(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str name: The name of the key.
        :param _builtins.str type: Type of configuration name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of configuration name.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OssShipperParquetConfig(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class StoreEncryptConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptType":
            suggest = "encrypt_type"
        elif key == "userCmkInfo":
            suggest = "user_cmk_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreEncryptConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreEncryptConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreEncryptConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[_builtins.bool] = None,
                 encrypt_type: Optional[_builtins.str] = None,
                 user_cmk_info: Optional['outputs.StoreEncryptConfUserCmkInfo'] = None):
        """
        :param _builtins.bool enable: Enable encryption. Default false.
        :param _builtins.str encrypt_type: Supported encryption type, only supports `default`(AES), `m4`.
        :param 'StoreEncryptConfUserCmkInfoArgs' user_cmk_info: User bring your own key (BYOK) encryption Refer to details, the format is as follows. See user_cmk_info below. `{ "cmk_key_id": "your_cmk_key_id", "arn": "your_role_arn", "region_id": "you_cmk_region_id" }`. See `user_cmk_info` below.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if encrypt_type is not None:
            pulumi.set(__self__, "encrypt_type", encrypt_type)
        if user_cmk_info is not None:
            pulumi.set(__self__, "user_cmk_info", user_cmk_info)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Enable encryption. Default false.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> Optional[_builtins.str]:
        """
        Supported encryption type, only supports `default`(AES), `m4`.
        """
        return pulumi.get(self, "encrypt_type")

    @_builtins.property
    @pulumi.getter(name="userCmkInfo")
    def user_cmk_info(self) -> Optional['outputs.StoreEncryptConfUserCmkInfo']:
        """
        User bring your own key (BYOK) encryption Refer to details, the format is as follows. See user_cmk_info below. `{ "cmk_key_id": "your_cmk_key_id", "arn": "your_role_arn", "region_id": "you_cmk_region_id" }`. See `user_cmk_info` below.
        """
        return pulumi.get(self, "user_cmk_info")


@pulumi.output_type
class StoreEncryptConfUserCmkInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cmkKeyId":
            suggest = "cmk_key_id"
        elif key == "regionId":
            suggest = "region_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreEncryptConfUserCmkInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreEncryptConfUserCmkInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreEncryptConfUserCmkInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: Optional[_builtins.str] = None,
                 cmk_key_id: Optional[_builtins.str] = None,
                 region_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str arn: Role arn.
        :param _builtins.str cmk_key_id: User master key id.
        :param _builtins.str region_id: Region id where the user master key id is located.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cmk_key_id is not None:
            pulumi.set(__self__, "cmk_key_id", cmk_key_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[_builtins.str]:
        """
        Role arn.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="cmkKeyId")
    def cmk_key_id(self) -> Optional[_builtins.str]:
        """
        User master key id.
        """
        return pulumi.get(self, "cmk_key_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[_builtins.str]:
        """
        Region id where the user master key id is located.
        """
        return pulumi.get(self, "region_id")


@pulumi.output_type
class StoreIndexFieldSearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "enableAnalytics":
            suggest = "enable_analytics"
        elif key == "includeChinese":
            suggest = "include_chinese"
        elif key == "jsonKeys":
            suggest = "json_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreIndexFieldSearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreIndexFieldSearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreIndexFieldSearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 alias: Optional[_builtins.str] = None,
                 case_sensitive: Optional[_builtins.bool] = None,
                 enable_analytics: Optional[_builtins.bool] = None,
                 include_chinese: Optional[_builtins.bool] = None,
                 json_keys: Optional[Sequence['outputs.StoreIndexFieldSearchJsonKey']] = None,
                 token: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The field name, which is unique in the same log store.
        :param _builtins.str alias: The alias of one field
        :param _builtins.bool case_sensitive: Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        :param _builtins.bool enable_analytics: Whether to enable field analytics. Default to true.
        :param _builtins.bool include_chinese: Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        :param Sequence['StoreIndexFieldSearchJsonKeyArgs'] json_keys: Use nested index when type is json
        :param _builtins.str token: The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        :param _builtins.str type: The type of one field. Valid values: ["long", "text", "double", "json"]. Default to "long".
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if enable_analytics is not None:
            pulumi.set(__self__, "enable_analytics", enable_analytics)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if json_keys is not None:
            pulumi.set(__self__, "json_keys", json_keys)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The field name, which is unique in the same log store.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[_builtins.str]:
        """
        The alias of one field
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[_builtins.bool]:
        """
        Whether the case sensitive for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "case_sensitive")

    @_builtins.property
    @pulumi.getter(name="enableAnalytics")
    def enable_analytics(self) -> Optional[_builtins.bool]:
        """
        Whether to enable field analytics. Default to true.
        """
        return pulumi.get(self, "enable_analytics")

    @_builtins.property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[_builtins.bool]:
        """
        Whether includes the chinese for the field. Default to false. It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "include_chinese")

    @_builtins.property
    @pulumi.getter(name="jsonKeys")
    def json_keys(self) -> Optional[Sequence['outputs.StoreIndexFieldSearchJsonKey']]:
        """
        Use nested index when type is json
        """
        return pulumi.get(self, "json_keys")

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[_builtins.str]:
        """
        The string of several split words, like "\\r", "#". It is valid when "type" is "text" or "json".
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of one field. Valid values: ["long", "text", "double", "json"]. Default to "long".
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StoreIndexFieldSearchJsonKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "docValue":
            suggest = "doc_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreIndexFieldSearchJsonKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreIndexFieldSearchJsonKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreIndexFieldSearchJsonKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 alias: Optional[_builtins.str] = None,
                 doc_value: Optional[_builtins.bool] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: When using the json_keys field, this field is required.
        :param _builtins.str alias: The alias of one field.
        :param _builtins.bool doc_value: Whether to enable statistics. default to true.
               
               > **Note:** At least one of the "full_text" and "field_search" should be specified.
        :param _builtins.str type: The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if doc_value is not None:
            pulumi.set(__self__, "doc_value", doc_value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        When using the json_keys field, this field is required.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[_builtins.str]:
        """
        The alias of one field.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter(name="docValue")
    def doc_value(self) -> Optional[_builtins.bool]:
        """
        Whether to enable statistics. default to true.

        > **Note:** At least one of the "full_text" and "field_search" should be specified.
        """
        return pulumi.get(self, "doc_value")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of one field. Valid values: ["long", "text", "double"]. Default to "long"
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StoreIndexFullText(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "includeChinese":
            suggest = "include_chinese"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreIndexFullText. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreIndexFullText.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreIndexFullText.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_sensitive: Optional[_builtins.bool] = None,
                 include_chinese: Optional[_builtins.bool] = None,
                 token: Optional[_builtins.str] = None):
        """
        :param _builtins.bool case_sensitive: Whether the case sensitive. Default to false.
        :param _builtins.bool include_chinese: Whether includes the chinese. Default to false.
        :param _builtins.str token: The string of several split words, like "\\r", "#"
        """
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @_builtins.property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[_builtins.bool]:
        """
        Whether the case sensitive. Default to false.
        """
        return pulumi.get(self, "case_sensitive")

    @_builtins.property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[_builtins.bool]:
        """
        Whether includes the chinese. Default to false.
        """
        return pulumi.get(self, "include_chinese")

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[_builtins.str]:
        """
        The string of several split words, like "\\r", "#"
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class StoreShard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "beginKey":
            suggest = "begin_key"
        elif key == "endKey":
            suggest = "end_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StoreShard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StoreShard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StoreShard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 begin_key: Optional[_builtins.str] = None,
                 end_key: Optional[_builtins.str] = None,
                 id: Optional[_builtins.int] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str begin_key: The begin value of the shard range(MD5), included in the shard range.
        :param _builtins.str end_key: The end value of the shard range(MD5), not included in shard range.
        :param _builtins.int id: The ID of the shard.
        :param _builtins.str status: Shard status, only two status of `readwrite` and `readonly`.
        """
        if begin_key is not None:
            pulumi.set(__self__, "begin_key", begin_key)
        if end_key is not None:
            pulumi.set(__self__, "end_key", end_key)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="beginKey")
    def begin_key(self) -> Optional[_builtins.str]:
        """
        The begin value of the shard range(MD5), included in the shard range.
        """
        return pulumi.get(self, "begin_key")

    @_builtins.property
    @pulumi.getter(name="endKey")
    def end_key(self) -> Optional[_builtins.str]:
        """
        The end value of the shard range(MD5), not included in shard range.
        """
        return pulumi.get(self, "end_key")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        The ID of the shard.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Shard status, only two status of `readwrite` and `readonly`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 last_modify_time: _builtins.str,
                 owner: _builtins.str,
                 policy: _builtins.str,
                 project_name: _builtins.str,
                 region: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str description: The description of the project.
        :param _builtins.str id: The ID of the project.
        :param _builtins.str last_modify_time: The last modify time of project.
        :param _builtins.str owner: The owner of project.
        :param _builtins.str policy: The policy of project.
        :param _builtins.str project_name: The name of the project.
        :param _builtins.str region: The region of project.
        :param _builtins.str status: The status of project.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_modify_time", last_modify_time)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the project.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastModifyTime")
    def last_modify_time(self) -> _builtins.str:
        """
        The last modify time of project.
        """
        return pulumi.get(self, "last_modify_time")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        The owner of project.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The policy of project.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        """
        The name of the project.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region of project.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of project.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetStoresStoreResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 store_name: _builtins.str):
        """
        :param _builtins.str id: The ID of the store.
        :param _builtins.str store_name: The name of the store.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "store_name", store_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the store.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="storeName")
    def store_name(self) -> _builtins.str:
        """
        The name of the store.
        """
        return pulumi.get(self, "store_name")


