# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TunnelQuotaTimerArgs', 'TunnelQuotaTimer']

@pulumi.input_type
class TunnelQuotaTimerArgs:
    def __init__(__self__, *,
                 nickname: pulumi.Input[_builtins.str],
                 quota_timers: Optional[pulumi.Input[Sequence[pulumi.Input['TunnelQuotaTimerQuotaTimerArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TunnelQuotaTimer resource.
        :param pulumi.Input[_builtins.str] nickname: The nickname of the exclusive Resource Group (Tunnel Quota) for the level - 1 data transmission service.
        :param pulumi.Input[Sequence[pulumi.Input['TunnelQuotaTimerQuotaTimerArgs']]] quota_timers: Time-Sharing configuration
               
               > **NOTE:** -- The same reserved Quota resource group supports up to 48 time intervals. The minimum duration of a time interval is 30 minutes. -- After the current data transmission service is configured for time-sharing, if you need to perform a downgrade operation on the data transmission service (package year and month), please reduce the time-sharing concurrency first. -- The effective time of the time-sharing configuration is 0 to 5 minutes, and the billing will be calculated according to the actual effective time. -- Please make sure to set the time range completely from 00:00 to 24:00
               See `quota_timer` below.
        :param pulumi.Input[_builtins.str] time_zone: Time zone, reference: Asia/Shanghai
               In general, the system will automatically generate the time zone according to the region without configuration.
        """
        pulumi.set(__self__, "nickname", nickname)
        if quota_timers is not None:
            pulumi.set(__self__, "quota_timers", quota_timers)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> pulumi.Input[_builtins.str]:
        """
        The nickname of the exclusive Resource Group (Tunnel Quota) for the level - 1 data transmission service.
        """
        return pulumi.get(self, "nickname")

    @nickname.setter
    def nickname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nickname", value)

    @_builtins.property
    @pulumi.getter(name="quotaTimers")
    def quota_timers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TunnelQuotaTimerQuotaTimerArgs']]]]:
        """
        Time-Sharing configuration

        > **NOTE:** -- The same reserved Quota resource group supports up to 48 time intervals. The minimum duration of a time interval is 30 minutes. -- After the current data transmission service is configured for time-sharing, if you need to perform a downgrade operation on the data transmission service (package year and month), please reduce the time-sharing concurrency first. -- The effective time of the time-sharing configuration is 0 to 5 minutes, and the billing will be calculated according to the actual effective time. -- Please make sure to set the time range completely from 00:00 to 24:00
        See `quota_timer` below.
        """
        return pulumi.get(self, "quota_timers")

    @quota_timers.setter
    def quota_timers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TunnelQuotaTimerQuotaTimerArgs']]]]):
        pulumi.set(self, "quota_timers", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time zone, reference: Asia/Shanghai
        In general, the system will automatically generate the time zone according to the region without configuration.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _TunnelQuotaTimerState:
    def __init__(__self__, *,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_timers: Optional[pulumi.Input[Sequence[pulumi.Input['TunnelQuotaTimerQuotaTimerArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TunnelQuotaTimer resources.
        :param pulumi.Input[_builtins.str] nickname: The nickname of the exclusive Resource Group (Tunnel Quota) for the level - 1 data transmission service.
        :param pulumi.Input[Sequence[pulumi.Input['TunnelQuotaTimerQuotaTimerArgs']]] quota_timers: Time-Sharing configuration
               
               > **NOTE:** -- The same reserved Quota resource group supports up to 48 time intervals. The minimum duration of a time interval is 30 minutes. -- After the current data transmission service is configured for time-sharing, if you need to perform a downgrade operation on the data transmission service (package year and month), please reduce the time-sharing concurrency first. -- The effective time of the time-sharing configuration is 0 to 5 minutes, and the billing will be calculated according to the actual effective time. -- Please make sure to set the time range completely from 00:00 to 24:00
               See `quota_timer` below.
        :param pulumi.Input[_builtins.str] time_zone: Time zone, reference: Asia/Shanghai
               In general, the system will automatically generate the time zone according to the region without configuration.
        """
        if nickname is not None:
            pulumi.set(__self__, "nickname", nickname)
        if quota_timers is not None:
            pulumi.set(__self__, "quota_timers", quota_timers)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The nickname of the exclusive Resource Group (Tunnel Quota) for the level - 1 data transmission service.
        """
        return pulumi.get(self, "nickname")

    @nickname.setter
    def nickname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nickname", value)

    @_builtins.property
    @pulumi.getter(name="quotaTimers")
    def quota_timers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TunnelQuotaTimerQuotaTimerArgs']]]]:
        """
        Time-Sharing configuration

        > **NOTE:** -- The same reserved Quota resource group supports up to 48 time intervals. The minimum duration of a time interval is 30 minutes. -- After the current data transmission service is configured for time-sharing, if you need to perform a downgrade operation on the data transmission service (package year and month), please reduce the time-sharing concurrency first. -- The effective time of the time-sharing configuration is 0 to 5 minutes, and the billing will be calculated according to the actual effective time. -- Please make sure to set the time range completely from 00:00 to 24:00
        See `quota_timer` below.
        """
        return pulumi.get(self, "quota_timers")

    @quota_timers.setter
    def quota_timers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TunnelQuotaTimerQuotaTimerArgs']]]]):
        pulumi.set(self, "quota_timers", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time zone, reference: Asia/Shanghai
        In general, the system will automatically generate the time zone according to the region without configuration.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.type_token("alicloud:maxcompute/tunnelQuotaTimer:TunnelQuotaTimer")
class TunnelQuotaTimer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_timers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TunnelQuotaTimerQuotaTimerArgs', 'TunnelQuotaTimerQuotaTimerArgsDict']]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Max Compute Tunnel Quota Timer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:maxcompute/tunnelQuotaTimer:TunnelQuotaTimer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] nickname: The nickname of the exclusive Resource Group (Tunnel Quota) for the level - 1 data transmission service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TunnelQuotaTimerQuotaTimerArgs', 'TunnelQuotaTimerQuotaTimerArgsDict']]]] quota_timers: Time-Sharing configuration
               
               > **NOTE:** -- The same reserved Quota resource group supports up to 48 time intervals. The minimum duration of a time interval is 30 minutes. -- After the current data transmission service is configured for time-sharing, if you need to perform a downgrade operation on the data transmission service (package year and month), please reduce the time-sharing concurrency first. -- The effective time of the time-sharing configuration is 0 to 5 minutes, and the billing will be calculated according to the actual effective time. -- Please make sure to set the time range completely from 00:00 to 24:00
               See `quota_timer` below.
        :param pulumi.Input[_builtins.str] time_zone: Time zone, reference: Asia/Shanghai
               In general, the system will automatically generate the time zone according to the region without configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TunnelQuotaTimerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Max Compute Tunnel Quota Timer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:maxcompute/tunnelQuotaTimer:TunnelQuotaTimer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param TunnelQuotaTimerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TunnelQuotaTimerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_timers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TunnelQuotaTimerQuotaTimerArgs', 'TunnelQuotaTimerQuotaTimerArgsDict']]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TunnelQuotaTimerArgs.__new__(TunnelQuotaTimerArgs)

            if nickname is None and not opts.urn:
                raise TypeError("Missing required property 'nickname'")
            __props__.__dict__["nickname"] = nickname
            __props__.__dict__["quota_timers"] = quota_timers
            __props__.__dict__["time_zone"] = time_zone
        super(TunnelQuotaTimer, __self__).__init__(
            'alicloud:maxcompute/tunnelQuotaTimer:TunnelQuotaTimer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            nickname: Optional[pulumi.Input[_builtins.str]] = None,
            quota_timers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TunnelQuotaTimerQuotaTimerArgs', 'TunnelQuotaTimerQuotaTimerArgsDict']]]]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'TunnelQuotaTimer':
        """
        Get an existing TunnelQuotaTimer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] nickname: The nickname of the exclusive Resource Group (Tunnel Quota) for the level - 1 data transmission service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TunnelQuotaTimerQuotaTimerArgs', 'TunnelQuotaTimerQuotaTimerArgsDict']]]] quota_timers: Time-Sharing configuration
               
               > **NOTE:** -- The same reserved Quota resource group supports up to 48 time intervals. The minimum duration of a time interval is 30 minutes. -- After the current data transmission service is configured for time-sharing, if you need to perform a downgrade operation on the data transmission service (package year and month), please reduce the time-sharing concurrency first. -- The effective time of the time-sharing configuration is 0 to 5 minutes, and the billing will be calculated according to the actual effective time. -- Please make sure to set the time range completely from 00:00 to 24:00
               See `quota_timer` below.
        :param pulumi.Input[_builtins.str] time_zone: Time zone, reference: Asia/Shanghai
               In general, the system will automatically generate the time zone according to the region without configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TunnelQuotaTimerState.__new__(_TunnelQuotaTimerState)

        __props__.__dict__["nickname"] = nickname
        __props__.__dict__["quota_timers"] = quota_timers
        __props__.__dict__["time_zone"] = time_zone
        return TunnelQuotaTimer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> pulumi.Output[_builtins.str]:
        """
        The nickname of the exclusive Resource Group (Tunnel Quota) for the level - 1 data transmission service.
        """
        return pulumi.get(self, "nickname")

    @_builtins.property
    @pulumi.getter(name="quotaTimers")
    def quota_timers(self) -> pulumi.Output[Optional[Sequence['outputs.TunnelQuotaTimerQuotaTimer']]]:
        """
        Time-Sharing configuration

        > **NOTE:** -- The same reserved Quota resource group supports up to 48 time intervals. The minimum duration of a time interval is 30 minutes. -- After the current data transmission service is configured for time-sharing, if you need to perform a downgrade operation on the data transmission service (package year and month), please reduce the time-sharing concurrency first. -- The effective time of the time-sharing configuration is 0 to 5 minutes, and the billing will be calculated according to the actual effective time. -- Please make sure to set the time range completely from 00:00 to 24:00
        See `quota_timer` below.
        """
        return pulumi.get(self, "quota_timers")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time zone, reference: Asia/Shanghai
        In general, the system will automatically generate the time zone according to the region without configuration.
        """
        return pulumi.get(self, "time_zone")

