# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GlobalSecurityIpGroupArgs', 'GlobalSecurityIpGroup']

@pulumi.input_type
class GlobalSecurityIpGroupArgs:
    def __init__(__self__, *,
                 global_ig_name: pulumi.Input[_builtins.str],
                 global_security_ip_list: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a GlobalSecurityIpGroup resource.
        :param pulumi.Input[_builtins.str] global_ig_name: The name of the IP whitelist template.
        :param pulumi.Input[_builtins.str] global_security_ip_list: The IP address in the whitelist template.
               
               > **NOTE:** Separate multiple IP addresses with commas (,). You can create up to 1000 IP addresses or CIDR blocks for all IP address whitelists.
        """
        pulumi.set(__self__, "global_ig_name", global_ig_name)
        pulumi.set(__self__, "global_security_ip_list", global_security_ip_list)

    @_builtins.property
    @pulumi.getter(name="globalIgName")
    def global_ig_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the IP whitelist template.
        """
        return pulumi.get(self, "global_ig_name")

    @global_ig_name.setter
    def global_ig_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "global_ig_name", value)

    @_builtins.property
    @pulumi.getter(name="globalSecurityIpList")
    def global_security_ip_list(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address in the whitelist template.

        > **NOTE:** Separate multiple IP addresses with commas (,). You can create up to 1000 IP addresses or CIDR blocks for all IP address whitelists.
        """
        return pulumi.get(self, "global_security_ip_list")

    @global_security_ip_list.setter
    def global_security_ip_list(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "global_security_ip_list", value)


@pulumi.input_type
class _GlobalSecurityIpGroupState:
    def __init__(__self__, *,
                 global_ig_name: Optional[pulumi.Input[_builtins.str]] = None,
                 global_security_ip_list: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GlobalSecurityIpGroup resources.
        :param pulumi.Input[_builtins.str] global_ig_name: The name of the IP whitelist template.
        :param pulumi.Input[_builtins.str] global_security_ip_list: The IP address in the whitelist template.
               
               > **NOTE:** Separate multiple IP addresses with commas (,). You can create up to 1000 IP addresses or CIDR blocks for all IP address whitelists.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        """
        if global_ig_name is not None:
            pulumi.set(__self__, "global_ig_name", global_ig_name)
        if global_security_ip_list is not None:
            pulumi.set(__self__, "global_security_ip_list", global_security_ip_list)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter(name="globalIgName")
    def global_ig_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IP whitelist template.
        """
        return pulumi.get(self, "global_ig_name")

    @global_ig_name.setter
    def global_ig_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_ig_name", value)

    @_builtins.property
    @pulumi.getter(name="globalSecurityIpList")
    def global_security_ip_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address in the whitelist template.

        > **NOTE:** Separate multiple IP addresses with commas (,). You can create up to 1000 IP addresses or CIDR blocks for all IP address whitelists.
        """
        return pulumi.get(self, "global_security_ip_list")

    @global_security_ip_list.setter
    def global_security_ip_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_security_ip_list", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)


@pulumi.type_token("alicloud:mongodb/globalSecurityIpGroup:GlobalSecurityIpGroup")
class GlobalSecurityIpGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 global_ig_name: Optional[pulumi.Input[_builtins.str]] = None,
                 global_security_ip_list: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Mongodb Global Security IP Group resource.

        Whitelist Template Resources.

        For information about Mongodb Global Security IP Group and how to use it, see [What is Global Security IP Group](https://next.api.alibabacloud.com/document/Dds/2015-12-01/CreateGlobalSecurityIPGroup).

        > **NOTE:** Available since v1.257.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraformexample"
        default = alicloud.mongodb.GlobalSecurityIpGroup("default",
            global_ig_name=name,
            global_security_ip_list="192.168.1.1,192.168.1.2,192.168.1.3")
        ```

        ## Import

        Mongodb Global Security IP Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:mongodb/globalSecurityIpGroup:GlobalSecurityIpGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] global_ig_name: The name of the IP whitelist template.
        :param pulumi.Input[_builtins.str] global_security_ip_list: The IP address in the whitelist template.
               
               > **NOTE:** Separate multiple IP addresses with commas (,). You can create up to 1000 IP addresses or CIDR blocks for all IP address whitelists.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GlobalSecurityIpGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Mongodb Global Security IP Group resource.

        Whitelist Template Resources.

        For information about Mongodb Global Security IP Group and how to use it, see [What is Global Security IP Group](https://next.api.alibabacloud.com/document/Dds/2015-12-01/CreateGlobalSecurityIPGroup).

        > **NOTE:** Available since v1.257.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraformexample"
        default = alicloud.mongodb.GlobalSecurityIpGroup("default",
            global_ig_name=name,
            global_security_ip_list="192.168.1.1,192.168.1.2,192.168.1.3")
        ```

        ## Import

        Mongodb Global Security IP Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:mongodb/globalSecurityIpGroup:GlobalSecurityIpGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GlobalSecurityIpGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalSecurityIpGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 global_ig_name: Optional[pulumi.Input[_builtins.str]] = None,
                 global_security_ip_list: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalSecurityIpGroupArgs.__new__(GlobalSecurityIpGroupArgs)

            if global_ig_name is None and not opts.urn:
                raise TypeError("Missing required property 'global_ig_name'")
            __props__.__dict__["global_ig_name"] = global_ig_name
            if global_security_ip_list is None and not opts.urn:
                raise TypeError("Missing required property 'global_security_ip_list'")
            __props__.__dict__["global_security_ip_list"] = global_security_ip_list
            __props__.__dict__["region_id"] = None
        super(GlobalSecurityIpGroup, __self__).__init__(
            'alicloud:mongodb/globalSecurityIpGroup:GlobalSecurityIpGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            global_ig_name: Optional[pulumi.Input[_builtins.str]] = None,
            global_security_ip_list: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'GlobalSecurityIpGroup':
        """
        Get an existing GlobalSecurityIpGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] global_ig_name: The name of the IP whitelist template.
        :param pulumi.Input[_builtins.str] global_security_ip_list: The IP address in the whitelist template.
               
               > **NOTE:** Separate multiple IP addresses with commas (,). You can create up to 1000 IP addresses or CIDR blocks for all IP address whitelists.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalSecurityIpGroupState.__new__(_GlobalSecurityIpGroupState)

        __props__.__dict__["global_ig_name"] = global_ig_name
        __props__.__dict__["global_security_ip_list"] = global_security_ip_list
        __props__.__dict__["region_id"] = region_id
        return GlobalSecurityIpGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="globalIgName")
    def global_ig_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the IP whitelist template.
        """
        return pulumi.get(self, "global_ig_name")

    @_builtins.property
    @pulumi.getter(name="globalSecurityIpList")
    def global_security_ip_list(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address in the whitelist template.

        > **NOTE:** Separate multiple IP addresses with commas (,). You can create up to 1000 IP addresses or CIDR blocks for all IP address whitelists.
        """
        return pulumi.get(self, "global_security_ip_list")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

