# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_specification: pulumi.Input[_builtins.str],
                 cluster_type: pulumi.Input[_builtins.str],
                 cluster_version: pulumi.Input[_builtins.str],
                 instance_count: pulumi.Input[_builtins.int],
                 net_type: pulumi.Input[_builtins.str],
                 pub_network_flow: pulumi.Input[_builtins.str],
                 acl_entry_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_alias_name: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 mse_version: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 private_slb_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 pub_slb_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 request_pars: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_code: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] cluster_specification: The engine specification of MSE Cluster. **NOTE:** From version 1.188.0, `cluster_specification` can be modified. If you were an international user, please use the specification version ending with `_200_c`.Valid values:
               - Professional Edition
               - `MSE_SC_1_2_60_c`: 1C2G
               - `MSE_SC_2_4_60_c`: 2C4G
               - `MSE_SC_4_8_60_c`: 4C8G
               - `MSE_SC_8_16_60_c`: 8C16G
               - `MSE_SC_16_32_60_c`:16C32G
               - `MSE_SC_1_2_200_c`: 1C2G
               - `MSE_SC_2_4_200_c`: 2C4G
               - `MSE_SC_4_8_200_c`: 4C8G
               - `MSE_SC_8_16_200_c`: 8C16G
               - `MSE_SC_16_32_200_c`:16C32G
               - Developer Edition
               - `MSE_SC_1_2_60_c`: 1C2G
               - `MSE_SC_2_4_60_c`: 2C4G
               - `MSE_SC_1_2_200_c`: 1C2G
               - `MSE_SC_2_4_200_c`: 2C4G
               - Serverless Edition
               - `MSE_SC_SERVERLESS`: Available since v1.232.0
        :param pulumi.Input[_builtins.str] cluster_type: The type of MSE Cluster.
        :param pulumi.Input[_builtins.str] cluster_version: The version of MSE Cluster. See [details](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createcluster)
        :param pulumi.Input[_builtins.int] instance_count: The count of instance. **NOTE:** From version 1.188.0, `instance_count` can be modified.
        :param pulumi.Input[_builtins.str] net_type: The type of network. Valid values: `privatenet` and `pubnet` and `both`(Available since v1.232.0).
        :param pulumi.Input[_builtins.str] pub_network_flow: The public network bandwidth.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acl_entry_lists: The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
        :param pulumi.Input[_builtins.str] cluster_alias_name: The alias of MSE Cluster.
        :param pulumi.Input[_builtins.str] connection_type: The connection type. Valid values: `slb`,`single_eni`(Available since v1.232.0). If your region is one of `ap-southeast-6、us-west-1、eu-central-1、us-east-1、ap-southeast-1`,and your cluster's mse_version is `mse_dev`,please use `single_eni`.
        :param pulumi.Input[_builtins.str] disk_type: The type of Disk.
        :param pulumi.Input[_builtins.str] mse_version: The version of MSE. Valid values: `mse_dev` or `mse_pro` or `mse_serverless`(Available since v1.232.0).
        :param pulumi.Input[_builtins.str] payment_type: Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo.
        :param pulumi.Input[_builtins.str] private_slb_specification: The specification of private network SLB.
        :param pulumi.Input[_builtins.str] pub_slb_specification: The specification of public network SLB. Serverless Instance could ignore this parameter.
        :param pulumi.Input[_builtins.str] request_pars: The extended request parameters in the JSON format.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] version_code: The version code of MSE Cluster. You can keep the instance version up to date by setting the value to `LATEST` (Available since v1.257.0).
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The id of VSwitch.
        """
        pulumi.set(__self__, "cluster_specification", cluster_specification)
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "net_type", net_type)
        pulumi.set(__self__, "pub_network_flow", pub_network_flow)
        if acl_entry_lists is not None:
            pulumi.set(__self__, "acl_entry_lists", acl_entry_lists)
        if cluster_alias_name is not None:
            pulumi.set(__self__, "cluster_alias_name", cluster_alias_name)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if mse_version is not None:
            pulumi.set(__self__, "mse_version", mse_version)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if private_slb_specification is not None:
            pulumi.set(__self__, "private_slb_specification", private_slb_specification)
        if pub_slb_specification is not None:
            pulumi.set(__self__, "pub_slb_specification", pub_slb_specification)
        if request_pars is not None:
            pulumi.set(__self__, "request_pars", request_pars)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_code is not None:
            pulumi.set(__self__, "version_code", version_code)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="clusterSpecification")
    def cluster_specification(self) -> pulumi.Input[_builtins.str]:
        """
        The engine specification of MSE Cluster. **NOTE:** From version 1.188.0, `cluster_specification` can be modified. If you were an international user, please use the specification version ending with `_200_c`.Valid values:
        - Professional Edition
        - `MSE_SC_1_2_60_c`: 1C2G
        - `MSE_SC_2_4_60_c`: 2C4G
        - `MSE_SC_4_8_60_c`: 4C8G
        - `MSE_SC_8_16_60_c`: 8C16G
        - `MSE_SC_16_32_60_c`:16C32G
        - `MSE_SC_1_2_200_c`: 1C2G
        - `MSE_SC_2_4_200_c`: 2C4G
        - `MSE_SC_4_8_200_c`: 4C8G
        - `MSE_SC_8_16_200_c`: 8C16G
        - `MSE_SC_16_32_200_c`:16C32G
        - Developer Edition
        - `MSE_SC_1_2_60_c`: 1C2G
        - `MSE_SC_2_4_60_c`: 2C4G
        - `MSE_SC_1_2_200_c`: 1C2G
        - `MSE_SC_2_4_200_c`: 2C4G
        - Serverless Edition
        - `MSE_SC_SERVERLESS`: Available since v1.232.0
        """
        return pulumi.get(self, "cluster_specification")

    @cluster_specification.setter
    def cluster_specification(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_specification", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of MSE Cluster.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of MSE Cluster. See [details](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createcluster)
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Input[_builtins.int]:
        """
        The count of instance. **NOTE:** From version 1.188.0, `instance_count` can be modified.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of network. Valid values: `privatenet` and `pubnet` and `both`(Available since v1.232.0).
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "net_type", value)

    @_builtins.property
    @pulumi.getter(name="pubNetworkFlow")
    def pub_network_flow(self) -> pulumi.Input[_builtins.str]:
        """
        The public network bandwidth.
        """
        return pulumi.get(self, "pub_network_flow")

    @pub_network_flow.setter
    def pub_network_flow(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pub_network_flow", value)

    @_builtins.property
    @pulumi.getter(name="aclEntryLists")
    def acl_entry_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
        """
        return pulumi.get(self, "acl_entry_lists")

    @acl_entry_lists.setter
    def acl_entry_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "acl_entry_lists", value)

    @_builtins.property
    @pulumi.getter(name="clusterAliasName")
    def cluster_alias_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alias of MSE Cluster.
        """
        return pulumi.get(self, "cluster_alias_name")

    @cluster_alias_name.setter
    def cluster_alias_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_alias_name", value)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection type. Valid values: `slb`,`single_eni`(Available since v1.232.0). If your region is one of `ap-southeast-6、us-west-1、eu-central-1、us-east-1、ap-southeast-1`,and your cluster's mse_version is `mse_dev`,please use `single_eni`.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_type", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Disk.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter(name="mseVersion")
    def mse_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of MSE. Valid values: `mse_dev` or `mse_pro` or `mse_serverless`(Available since v1.232.0).
        """
        return pulumi.get(self, "mse_version")

    @mse_version.setter
    def mse_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mse_version", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="privateSlbSpecification")
    def private_slb_specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of private network SLB.
        """
        return pulumi.get(self, "private_slb_specification")

    @private_slb_specification.setter
    def private_slb_specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_slb_specification", value)

    @_builtins.property
    @pulumi.getter(name="pubSlbSpecification")
    def pub_slb_specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of public network SLB. Serverless Instance could ignore this parameter.
        """
        return pulumi.get(self, "pub_slb_specification")

    @pub_slb_specification.setter
    def pub_slb_specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pub_slb_specification", value)

    @_builtins.property
    @pulumi.getter(name="requestPars")
    def request_pars(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended request parameters in the JSON format.
        """
        return pulumi.get(self, "request_pars")

    @request_pars.setter
    def request_pars(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_pars", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group of the resource.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version code of MSE Cluster. You can keep the instance version up to date by setting the value to `LATEST` (Available since v1.257.0).
        """
        return pulumi.get(self, "version_code")

    @version_code.setter
    def version_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_code", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 acl_entry_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 app_version: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_alias_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 mse_version: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 private_slb_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 pub_network_flow: Optional[pulumi.Input[_builtins.str]] = None,
                 pub_slb_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 request_pars: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_code: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acl_entry_lists: The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
        :param pulumi.Input[_builtins.str] app_version: (Available since v1.205.0) The application version.
        :param pulumi.Input[_builtins.str] cluster_alias_name: The alias of MSE Cluster.
        :param pulumi.Input[_builtins.str] cluster_id: (Available since v1.162.0) The cluster id of Cluster.
        :param pulumi.Input[_builtins.str] cluster_specification: The engine specification of MSE Cluster. **NOTE:** From version 1.188.0, `cluster_specification` can be modified. If you were an international user, please use the specification version ending with `_200_c`.Valid values:
               - Professional Edition
               - `MSE_SC_1_2_60_c`: 1C2G
               - `MSE_SC_2_4_60_c`: 2C4G
               - `MSE_SC_4_8_60_c`: 4C8G
               - `MSE_SC_8_16_60_c`: 8C16G
               - `MSE_SC_16_32_60_c`:16C32G
               - `MSE_SC_1_2_200_c`: 1C2G
               - `MSE_SC_2_4_200_c`: 2C4G
               - `MSE_SC_4_8_200_c`: 4C8G
               - `MSE_SC_8_16_200_c`: 8C16G
               - `MSE_SC_16_32_200_c`:16C32G
               - Developer Edition
               - `MSE_SC_1_2_60_c`: 1C2G
               - `MSE_SC_2_4_60_c`: 2C4G
               - `MSE_SC_1_2_200_c`: 1C2G
               - `MSE_SC_2_4_200_c`: 2C4G
               - Serverless Edition
               - `MSE_SC_SERVERLESS`: Available since v1.232.0
        :param pulumi.Input[_builtins.str] cluster_type: The type of MSE Cluster.
        :param pulumi.Input[_builtins.str] cluster_version: The version of MSE Cluster. See [details](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createcluster)
        :param pulumi.Input[_builtins.str] connection_type: The connection type. Valid values: `slb`,`single_eni`(Available since v1.232.0). If your region is one of `ap-southeast-6、us-west-1、eu-central-1、us-east-1、ap-southeast-1`,and your cluster's mse_version is `mse_dev`,please use `single_eni`.
        :param pulumi.Input[_builtins.str] disk_type: The type of Disk.
        :param pulumi.Input[_builtins.int] instance_count: The count of instance. **NOTE:** From version 1.188.0, `instance_count` can be modified.
        :param pulumi.Input[_builtins.str] mse_version: The version of MSE. Valid values: `mse_dev` or `mse_pro` or `mse_serverless`(Available since v1.232.0).
        :param pulumi.Input[_builtins.str] net_type: The type of network. Valid values: `privatenet` and `pubnet` and `both`(Available since v1.232.0).
        :param pulumi.Input[_builtins.str] payment_type: Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo.
        :param pulumi.Input[_builtins.str] private_slb_specification: The specification of private network SLB.
        :param pulumi.Input[_builtins.str] pub_network_flow: The public network bandwidth.
        :param pulumi.Input[_builtins.str] pub_slb_specification: The specification of public network SLB. Serverless Instance could ignore this parameter.
        :param pulumi.Input[_builtins.str] request_pars: The extended request parameters in the JSON format.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group of the resource.
        :param pulumi.Input[_builtins.str] status: The status of MSE Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] version_code: The version code of MSE Cluster. You can keep the instance version up to date by setting the value to `LATEST` (Available since v1.257.0).
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The id of VSwitch.
        """
        if acl_entry_lists is not None:
            pulumi.set(__self__, "acl_entry_lists", acl_entry_lists)
        if app_version is not None:
            pulumi.set(__self__, "app_version", app_version)
        if cluster_alias_name is not None:
            pulumi.set(__self__, "cluster_alias_name", cluster_alias_name)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_specification is not None:
            pulumi.set(__self__, "cluster_specification", cluster_specification)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if mse_version is not None:
            pulumi.set(__self__, "mse_version", mse_version)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if private_slb_specification is not None:
            pulumi.set(__self__, "private_slb_specification", private_slb_specification)
        if pub_network_flow is not None:
            pulumi.set(__self__, "pub_network_flow", pub_network_flow)
        if pub_slb_specification is not None:
            pulumi.set(__self__, "pub_slb_specification", pub_slb_specification)
        if request_pars is not None:
            pulumi.set(__self__, "request_pars", request_pars)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_code is not None:
            pulumi.set(__self__, "version_code", version_code)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="aclEntryLists")
    def acl_entry_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
        """
        return pulumi.get(self, "acl_entry_lists")

    @acl_entry_lists.setter
    def acl_entry_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "acl_entry_lists", value)

    @_builtins.property
    @pulumi.getter(name="appVersion")
    def app_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.205.0) The application version.
        """
        return pulumi.get(self, "app_version")

    @app_version.setter
    def app_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_version", value)

    @_builtins.property
    @pulumi.getter(name="clusterAliasName")
    def cluster_alias_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alias of MSE Cluster.
        """
        return pulumi.get(self, "cluster_alias_name")

    @cluster_alias_name.setter
    def cluster_alias_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_alias_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.162.0) The cluster id of Cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterSpecification")
    def cluster_specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The engine specification of MSE Cluster. **NOTE:** From version 1.188.0, `cluster_specification` can be modified. If you were an international user, please use the specification version ending with `_200_c`.Valid values:
        - Professional Edition
        - `MSE_SC_1_2_60_c`: 1C2G
        - `MSE_SC_2_4_60_c`: 2C4G
        - `MSE_SC_4_8_60_c`: 4C8G
        - `MSE_SC_8_16_60_c`: 8C16G
        - `MSE_SC_16_32_60_c`:16C32G
        - `MSE_SC_1_2_200_c`: 1C2G
        - `MSE_SC_2_4_200_c`: 2C4G
        - `MSE_SC_4_8_200_c`: 4C8G
        - `MSE_SC_8_16_200_c`: 8C16G
        - `MSE_SC_16_32_200_c`:16C32G
        - Developer Edition
        - `MSE_SC_1_2_60_c`: 1C2G
        - `MSE_SC_2_4_60_c`: 2C4G
        - `MSE_SC_1_2_200_c`: 1C2G
        - `MSE_SC_2_4_200_c`: 2C4G
        - Serverless Edition
        - `MSE_SC_SERVERLESS`: Available since v1.232.0
        """
        return pulumi.get(self, "cluster_specification")

    @cluster_specification.setter
    def cluster_specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_specification", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of MSE Cluster.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of MSE Cluster. See [details](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createcluster)
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection type. Valid values: `slb`,`single_eni`(Available since v1.232.0). If your region is one of `ap-southeast-6、us-west-1、eu-central-1、us-east-1、ap-southeast-1`,and your cluster's mse_version is `mse_dev`,please use `single_eni`.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_type", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Disk.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The count of instance. **NOTE:** From version 1.188.0, `instance_count` can be modified.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="mseVersion")
    def mse_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of MSE. Valid values: `mse_dev` or `mse_pro` or `mse_serverless`(Available since v1.232.0).
        """
        return pulumi.get(self, "mse_version")

    @mse_version.setter
    def mse_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mse_version", value)

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of network. Valid values: `privatenet` and `pubnet` and `both`(Available since v1.232.0).
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="privateSlbSpecification")
    def private_slb_specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of private network SLB.
        """
        return pulumi.get(self, "private_slb_specification")

    @private_slb_specification.setter
    def private_slb_specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_slb_specification", value)

    @_builtins.property
    @pulumi.getter(name="pubNetworkFlow")
    def pub_network_flow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public network bandwidth.
        """
        return pulumi.get(self, "pub_network_flow")

    @pub_network_flow.setter
    def pub_network_flow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pub_network_flow", value)

    @_builtins.property
    @pulumi.getter(name="pubSlbSpecification")
    def pub_slb_specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of public network SLB. Serverless Instance could ignore this parameter.
        """
        return pulumi.get(self, "pub_slb_specification")

    @pub_slb_specification.setter
    def pub_slb_specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pub_slb_specification", value)

    @_builtins.property
    @pulumi.getter(name="requestPars")
    def request_pars(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended request parameters in the JSON format.
        """
        return pulumi.get(self, "request_pars")

    @request_pars.setter
    def request_pars(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_pars", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group of the resource.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of MSE Cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version code of MSE Cluster. You can keep the instance version up to date by setting the value to `LATEST` (Available since v1.257.0).
        """
        return pulumi.get(self, "version_code")

    @version_code.setter
    def version_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_code", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:mse/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_entry_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_alias_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 mse_version: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 private_slb_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 pub_network_flow: Optional[pulumi.Input[_builtins.str]] = None,
                 pub_slb_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 request_pars: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_code: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        MSE Cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:mse/cluster:Cluster example mse-cn-0d9xxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acl_entry_lists: The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
        :param pulumi.Input[_builtins.str] cluster_alias_name: The alias of MSE Cluster.
        :param pulumi.Input[_builtins.str] cluster_specification: The engine specification of MSE Cluster. **NOTE:** From version 1.188.0, `cluster_specification` can be modified. If you were an international user, please use the specification version ending with `_200_c`.Valid values:
               - Professional Edition
               - `MSE_SC_1_2_60_c`: 1C2G
               - `MSE_SC_2_4_60_c`: 2C4G
               - `MSE_SC_4_8_60_c`: 4C8G
               - `MSE_SC_8_16_60_c`: 8C16G
               - `MSE_SC_16_32_60_c`:16C32G
               - `MSE_SC_1_2_200_c`: 1C2G
               - `MSE_SC_2_4_200_c`: 2C4G
               - `MSE_SC_4_8_200_c`: 4C8G
               - `MSE_SC_8_16_200_c`: 8C16G
               - `MSE_SC_16_32_200_c`:16C32G
               - Developer Edition
               - `MSE_SC_1_2_60_c`: 1C2G
               - `MSE_SC_2_4_60_c`: 2C4G
               - `MSE_SC_1_2_200_c`: 1C2G
               - `MSE_SC_2_4_200_c`: 2C4G
               - Serverless Edition
               - `MSE_SC_SERVERLESS`: Available since v1.232.0
        :param pulumi.Input[_builtins.str] cluster_type: The type of MSE Cluster.
        :param pulumi.Input[_builtins.str] cluster_version: The version of MSE Cluster. See [details](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createcluster)
        :param pulumi.Input[_builtins.str] connection_type: The connection type. Valid values: `slb`,`single_eni`(Available since v1.232.0). If your region is one of `ap-southeast-6、us-west-1、eu-central-1、us-east-1、ap-southeast-1`,and your cluster's mse_version is `mse_dev`,please use `single_eni`.
        :param pulumi.Input[_builtins.str] disk_type: The type of Disk.
        :param pulumi.Input[_builtins.int] instance_count: The count of instance. **NOTE:** From version 1.188.0, `instance_count` can be modified.
        :param pulumi.Input[_builtins.str] mse_version: The version of MSE. Valid values: `mse_dev` or `mse_pro` or `mse_serverless`(Available since v1.232.0).
        :param pulumi.Input[_builtins.str] net_type: The type of network. Valid values: `privatenet` and `pubnet` and `both`(Available since v1.232.0).
        :param pulumi.Input[_builtins.str] payment_type: Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo.
        :param pulumi.Input[_builtins.str] private_slb_specification: The specification of private network SLB.
        :param pulumi.Input[_builtins.str] pub_network_flow: The public network bandwidth.
        :param pulumi.Input[_builtins.str] pub_slb_specification: The specification of public network SLB. Serverless Instance could ignore this parameter.
        :param pulumi.Input[_builtins.str] request_pars: The extended request parameters in the JSON format.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] version_code: The version code of MSE Cluster. You can keep the instance version up to date by setting the value to `LATEST` (Available since v1.257.0).
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The id of VSwitch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        MSE Cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:mse/cluster:Cluster example mse-cn-0d9xxxx
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_entry_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_alias_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 mse_version: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 private_slb_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 pub_network_flow: Optional[pulumi.Input[_builtins.str]] = None,
                 pub_slb_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 request_pars: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version_code: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["acl_entry_lists"] = acl_entry_lists
            __props__.__dict__["cluster_alias_name"] = cluster_alias_name
            if cluster_specification is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_specification'")
            __props__.__dict__["cluster_specification"] = cluster_specification
            if cluster_type is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_type'")
            __props__.__dict__["cluster_type"] = cluster_type
            if cluster_version is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_version'")
            __props__.__dict__["cluster_version"] = cluster_version
            __props__.__dict__["connection_type"] = connection_type
            __props__.__dict__["disk_type"] = disk_type
            if instance_count is None and not opts.urn:
                raise TypeError("Missing required property 'instance_count'")
            __props__.__dict__["instance_count"] = instance_count
            __props__.__dict__["mse_version"] = mse_version
            if net_type is None and not opts.urn:
                raise TypeError("Missing required property 'net_type'")
            __props__.__dict__["net_type"] = net_type
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["private_slb_specification"] = private_slb_specification
            if pub_network_flow is None and not opts.urn:
                raise TypeError("Missing required property 'pub_network_flow'")
            __props__.__dict__["pub_network_flow"] = pub_network_flow
            __props__.__dict__["pub_slb_specification"] = pub_slb_specification
            __props__.__dict__["request_pars"] = request_pars
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version_code"] = version_code
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["app_version"] = None
            __props__.__dict__["cluster_id"] = None
            __props__.__dict__["status"] = None
        super(Cluster, __self__).__init__(
            'alicloud:mse/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_entry_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            app_version: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_alias_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_specification: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
            connection_type: Optional[pulumi.Input[_builtins.str]] = None,
            disk_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_count: Optional[pulumi.Input[_builtins.int]] = None,
            mse_version: Optional[pulumi.Input[_builtins.str]] = None,
            net_type: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            private_slb_specification: Optional[pulumi.Input[_builtins.str]] = None,
            pub_network_flow: Optional[pulumi.Input[_builtins.str]] = None,
            pub_slb_specification: Optional[pulumi.Input[_builtins.str]] = None,
            request_pars: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version_code: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acl_entry_lists: The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
        :param pulumi.Input[_builtins.str] app_version: (Available since v1.205.0) The application version.
        :param pulumi.Input[_builtins.str] cluster_alias_name: The alias of MSE Cluster.
        :param pulumi.Input[_builtins.str] cluster_id: (Available since v1.162.0) The cluster id of Cluster.
        :param pulumi.Input[_builtins.str] cluster_specification: The engine specification of MSE Cluster. **NOTE:** From version 1.188.0, `cluster_specification` can be modified. If you were an international user, please use the specification version ending with `_200_c`.Valid values:
               - Professional Edition
               - `MSE_SC_1_2_60_c`: 1C2G
               - `MSE_SC_2_4_60_c`: 2C4G
               - `MSE_SC_4_8_60_c`: 4C8G
               - `MSE_SC_8_16_60_c`: 8C16G
               - `MSE_SC_16_32_60_c`:16C32G
               - `MSE_SC_1_2_200_c`: 1C2G
               - `MSE_SC_2_4_200_c`: 2C4G
               - `MSE_SC_4_8_200_c`: 4C8G
               - `MSE_SC_8_16_200_c`: 8C16G
               - `MSE_SC_16_32_200_c`:16C32G
               - Developer Edition
               - `MSE_SC_1_2_60_c`: 1C2G
               - `MSE_SC_2_4_60_c`: 2C4G
               - `MSE_SC_1_2_200_c`: 1C2G
               - `MSE_SC_2_4_200_c`: 2C4G
               - Serverless Edition
               - `MSE_SC_SERVERLESS`: Available since v1.232.0
        :param pulumi.Input[_builtins.str] cluster_type: The type of MSE Cluster.
        :param pulumi.Input[_builtins.str] cluster_version: The version of MSE Cluster. See [details](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createcluster)
        :param pulumi.Input[_builtins.str] connection_type: The connection type. Valid values: `slb`,`single_eni`(Available since v1.232.0). If your region is one of `ap-southeast-6、us-west-1、eu-central-1、us-east-1、ap-southeast-1`,and your cluster's mse_version is `mse_dev`,please use `single_eni`.
        :param pulumi.Input[_builtins.str] disk_type: The type of Disk.
        :param pulumi.Input[_builtins.int] instance_count: The count of instance. **NOTE:** From version 1.188.0, `instance_count` can be modified.
        :param pulumi.Input[_builtins.str] mse_version: The version of MSE. Valid values: `mse_dev` or `mse_pro` or `mse_serverless`(Available since v1.232.0).
        :param pulumi.Input[_builtins.str] net_type: The type of network. Valid values: `privatenet` and `pubnet` and `both`(Available since v1.232.0).
        :param pulumi.Input[_builtins.str] payment_type: Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo.
        :param pulumi.Input[_builtins.str] private_slb_specification: The specification of private network SLB.
        :param pulumi.Input[_builtins.str] pub_network_flow: The public network bandwidth.
        :param pulumi.Input[_builtins.str] pub_slb_specification: The specification of public network SLB. Serverless Instance could ignore this parameter.
        :param pulumi.Input[_builtins.str] request_pars: The extended request parameters in the JSON format.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group of the resource.
        :param pulumi.Input[_builtins.str] status: The status of MSE Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] version_code: The version code of MSE Cluster. You can keep the instance version up to date by setting the value to `LATEST` (Available since v1.257.0).
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The id of VSwitch.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["acl_entry_lists"] = acl_entry_lists
        __props__.__dict__["app_version"] = app_version
        __props__.__dict__["cluster_alias_name"] = cluster_alias_name
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_specification"] = cluster_specification
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["cluster_version"] = cluster_version
        __props__.__dict__["connection_type"] = connection_type
        __props__.__dict__["disk_type"] = disk_type
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["mse_version"] = mse_version
        __props__.__dict__["net_type"] = net_type
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["private_slb_specification"] = private_slb_specification
        __props__.__dict__["pub_network_flow"] = pub_network_flow
        __props__.__dict__["pub_slb_specification"] = pub_slb_specification
        __props__.__dict__["request_pars"] = request_pars
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version_code"] = version_code
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclEntryLists")
    def acl_entry_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The whitelist. **NOTE:** This attribute is invalid when the value of `pub_network_flow` is `0` and the value of `net_type` is `privatenet`.
        """
        return pulumi.get(self, "acl_entry_lists")

    @_builtins.property
    @pulumi.getter(name="appVersion")
    def app_version(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.205.0) The application version.
        """
        return pulumi.get(self, "app_version")

    @_builtins.property
    @pulumi.getter(name="clusterAliasName")
    def cluster_alias_name(self) -> pulumi.Output[_builtins.str]:
        """
        The alias of MSE Cluster.
        """
        return pulumi.get(self, "cluster_alias_name")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.162.0) The cluster id of Cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterSpecification")
    def cluster_specification(self) -> pulumi.Output[_builtins.str]:
        """
        The engine specification of MSE Cluster. **NOTE:** From version 1.188.0, `cluster_specification` can be modified. If you were an international user, please use the specification version ending with `_200_c`.Valid values:
        - Professional Edition
        - `MSE_SC_1_2_60_c`: 1C2G
        - `MSE_SC_2_4_60_c`: 2C4G
        - `MSE_SC_4_8_60_c`: 4C8G
        - `MSE_SC_8_16_60_c`: 8C16G
        - `MSE_SC_16_32_60_c`:16C32G
        - `MSE_SC_1_2_200_c`: 1C2G
        - `MSE_SC_2_4_200_c`: 2C4G
        - `MSE_SC_4_8_200_c`: 4C8G
        - `MSE_SC_8_16_200_c`: 8C16G
        - `MSE_SC_16_32_200_c`:16C32G
        - Developer Edition
        - `MSE_SC_1_2_60_c`: 1C2G
        - `MSE_SC_2_4_60_c`: 2C4G
        - `MSE_SC_1_2_200_c`: 1C2G
        - `MSE_SC_2_4_200_c`: 2C4G
        - Serverless Edition
        - `MSE_SC_SERVERLESS`: Available since v1.232.0
        """
        return pulumi.get(self, "cluster_specification")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of MSE Cluster.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of MSE Cluster. See [details](https://www.alibabacloud.com/help/en/mse/developer-reference/api-mse-2019-05-31-createcluster)
        """
        return pulumi.get(self, "cluster_version")

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Output[_builtins.str]:
        """
        The connection type. Valid values: `slb`,`single_eni`(Available since v1.232.0). If your region is one of `ap-southeast-6、us-west-1、eu-central-1、us-east-1、ap-southeast-1`,and your cluster's mse_version is `mse_dev`,please use `single_eni`.
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of Disk.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[_builtins.int]:
        """
        The count of instance. **NOTE:** From version 1.188.0, `instance_count` can be modified.
        """
        return pulumi.get(self, "instance_count")

    @_builtins.property
    @pulumi.getter(name="mseVersion")
    def mse_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of MSE. Valid values: `mse_dev` or `mse_pro` or `mse_serverless`(Available since v1.232.0).
        """
        return pulumi.get(self, "mse_version")

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of network. Valid values: `privatenet` and `pubnet` and `both`(Available since v1.232.0).
        """
        return pulumi.get(self, "net_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="privateSlbSpecification")
    def private_slb_specification(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The specification of private network SLB.
        """
        return pulumi.get(self, "private_slb_specification")

    @_builtins.property
    @pulumi.getter(name="pubNetworkFlow")
    def pub_network_flow(self) -> pulumi.Output[_builtins.str]:
        """
        The public network bandwidth.
        """
        return pulumi.get(self, "pub_network_flow")

    @_builtins.property
    @pulumi.getter(name="pubSlbSpecification")
    def pub_slb_specification(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The specification of public network SLB. Serverless Instance could ignore this parameter.
        """
        return pulumi.get(self, "pub_slb_specification")

    @_builtins.property
    @pulumi.getter(name="requestPars")
    def request_pars(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The extended request parameters in the JSON format.
        """
        return pulumi.get(self, "request_pars")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource group of the resource.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of MSE Cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> pulumi.Output[_builtins.str]:
        """
        The version code of MSE Cluster. You can keep the instance version up to date by setting the value to `LATEST` (Available since v1.257.0).
        """
        return pulumi.get(self, "version_code")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The id of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

