# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccessRulesResult',
    'AwaitableGetAccessRulesResult',
    'get_access_rules',
    'get_access_rules_output',
]

@pulumi.output_type
class GetAccessRulesResult:
    """
    A collection of values returned by getAccessRules.
    """
    def __init__(__self__, access_group_name=None, id=None, ids=None, output_file=None, rules=None, rw_access=None, source_cidr_ip=None, user_access=None):
        if access_group_name and not isinstance(access_group_name, str):
            raise TypeError("Expected argument 'access_group_name' to be a str")
        pulumi.set(__self__, "access_group_name", access_group_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if rw_access and not isinstance(rw_access, str):
            raise TypeError("Expected argument 'rw_access' to be a str")
        pulumi.set(__self__, "rw_access", rw_access)
        if source_cidr_ip and not isinstance(source_cidr_ip, str):
            raise TypeError("Expected argument 'source_cidr_ip' to be a str")
        pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)
        if user_access and not isinstance(user_access, str):
            raise TypeError("Expected argument 'user_access' to be a str")
        pulumi.set(__self__, "user_access", user_access)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> _builtins.str:
        return pulumi.get(self, "access_group_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of rule IDs, Each element set to `access_rule_id` (Each element formats as `<access_group_name>:<access_rule_id>` before 1.53.0).
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetAccessRulesRuleResult']:
        """
        A list of AccessRules. Each element contains the following attributes:
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="rwAccess")
    def rw_access(self) -> Optional[_builtins.str]:
        """
        RWAccess of the AccessRule.
        """
        return pulumi.get(self, "rw_access")

    @_builtins.property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> Optional[_builtins.str]:
        """
        SourceCidrIp of the AccessRule.
        """
        return pulumi.get(self, "source_cidr_ip")

    @_builtins.property
    @pulumi.getter(name="userAccess")
    def user_access(self) -> Optional[_builtins.str]:
        """
        UserAccess of the AccessRule
        """
        return pulumi.get(self, "user_access")


class AwaitableGetAccessRulesResult(GetAccessRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessRulesResult(
            access_group_name=self.access_group_name,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            rules=self.rules,
            rw_access=self.rw_access,
            source_cidr_ip=self.source_cidr_ip,
            user_access=self.user_access)


def get_access_rules(access_group_name: Optional[_builtins.str] = None,
                     ids: Optional[Sequence[_builtins.str]] = None,
                     output_file: Optional[_builtins.str] = None,
                     rw_access: Optional[_builtins.str] = None,
                     source_cidr_ip: Optional[_builtins.str] = None,
                     user_access: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessRulesResult:
    """
    This data source provides AccessRule available to the user.

    > **NOTE**: Available in 1.35.0+


    :param _builtins.str access_group_name: Filter results by a specific AccessGroupName.
    :param Sequence[_builtins.str] ids: A list of rule IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str rw_access: Filter results by a specific RWAccess.
    :param _builtins.str source_cidr_ip: Filter results by a specific SourceCidrIp.
    :param _builtins.str user_access: Filter results by a specific UserAccess.
    """
    __args__ = dict()
    __args__['accessGroupName'] = access_group_name
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['rwAccess'] = rw_access
    __args__['sourceCidrIp'] = source_cidr_ip
    __args__['userAccess'] = user_access
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:nas/getAccessRules:getAccessRules', __args__, opts=opts, typ=GetAccessRulesResult).value

    return AwaitableGetAccessRulesResult(
        access_group_name=pulumi.get(__ret__, 'access_group_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        rules=pulumi.get(__ret__, 'rules'),
        rw_access=pulumi.get(__ret__, 'rw_access'),
        source_cidr_ip=pulumi.get(__ret__, 'source_cidr_ip'),
        user_access=pulumi.get(__ret__, 'user_access'))
def get_access_rules_output(access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                            ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            rw_access: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            source_cidr_ip: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            user_access: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessRulesResult]:
    """
    This data source provides AccessRule available to the user.

    > **NOTE**: Available in 1.35.0+


    :param _builtins.str access_group_name: Filter results by a specific AccessGroupName.
    :param Sequence[_builtins.str] ids: A list of rule IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str rw_access: Filter results by a specific RWAccess.
    :param _builtins.str source_cidr_ip: Filter results by a specific SourceCidrIp.
    :param _builtins.str user_access: Filter results by a specific UserAccess.
    """
    __args__ = dict()
    __args__['accessGroupName'] = access_group_name
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['rwAccess'] = rw_access
    __args__['sourceCidrIp'] = source_cidr_ip
    __args__['userAccess'] = user_access
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:nas/getAccessRules:getAccessRules', __args__, opts=opts, typ=GetAccessRulesResult)
    return __ret__.apply(lambda __response__: GetAccessRulesResult(
        access_group_name=pulumi.get(__response__, 'access_group_name'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        rules=pulumi.get(__response__, 'rules'),
        rw_access=pulumi.get(__response__, 'rw_access'),
        source_cidr_ip=pulumi.get(__response__, 'source_cidr_ip'),
        user_access=pulumi.get(__response__, 'user_access')))
