# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ListenerAdditionalCertificateAttachmentArgs', 'ListenerAdditionalCertificateAttachment']

@pulumi.input_type
class ListenerAdditionalCertificateAttachmentArgs:
    def __init__(__self__, *,
                 certificate_id: pulumi.Input[_builtins.str],
                 listener_id: pulumi.Input[_builtins.str],
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ListenerAdditionalCertificateAttachment resource.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of additional certificates.
        :param pulumi.Input[_builtins.str] listener_id: The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        """
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "listener_id", listener_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of additional certificates.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[_builtins.str]:
        """
        The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)


@pulumi.input_type
class _ListenerAdditionalCertificateAttachmentState:
    def __init__(__self__, *,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ListenerAdditionalCertificateAttachment resources.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of additional certificates.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.str] listener_id: The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of additional certificates.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:nlb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment")
class ListenerAdditionalCertificateAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a NLB Listener Additional Certificate Attachment resource.

        For information about NLB Listener Additional Certificate Attachment and how to use it, see [What is Listener Additional Certificate Attachment](https://www.alibabacloud.com/help/en/server-load-balancer/latest/nlb-instances-change).

        > **NOTE:** Available since v1.209.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.nlb.get_zones()
        create_vpc = alicloud.vpc.Network("create_vpc", cidr_block="172.16.0.0/12")
        create_vsw_j = alicloud.vpc.Switch("create_vsw_j",
            vpc_id=create_vpc.id,
            zone_id=default.zones[0].id,
            cidr_block="172.16.1.0/24")
        create_vsw_k = alicloud.vpc.Switch("create_vsw_k",
            vpc_id=create_vpc.id,
            zone_id=default.zones[1].id,
            cidr_block="172.16.2.0/24")
        lb = alicloud.nlb.LoadBalancer("lb",
            address_ip_version="Ipv4",
            zone_mappings=[
                {
                    "vswitch_id": create_vsw_j.id,
                    "zone_id": create_vsw_j.zone_id,
                },
                {
                    "vswitch_id": create_vsw_k.id,
                    "zone_id": create_vsw_k.zone_id,
                },
            ],
            load_balancer_type="Network",
            load_balancer_name=name,
            vpc_id=create_vpc.id,
            address_type="Internet")
        create_sg = alicloud.nlb.ServerGroup("create_sg",
            address_ip_version="Ipv4",
            scheduler="Wrr",
            health_check={},
            server_group_type="Instance",
            vpc_id=create_vpc.id,
            protocol="TCPSSL",
            server_group_name=name)
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        ssl0 = alicloud.cas.ServiceCertificate("ssl0",
            cert=\"\"\"-----BEGIN CERTIFICATE-----
        MIIDhDCCAmwCCQCwJW4JChLBqTANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMC
        Q04xEDAOBgNVBAgMB0JlaWppbmcxEDAOBgNVBAcMB0JlaWppbmcxDDAKBgNVBAoM
        A0FsaTEPMA0GA1UECwwGQWxpeXVuMRIwEAYDVQQDDAlUZXJyYWZvcm0xHTAbBgkq
        hkiG9w0BCQEWDjEyM0BhbGl5dW0uY29tMB4XDTI0MTIyNTA3MjQ0OFoXDTI3MTIy
        NTA3MjQ0OFowgYMxCzAJBgNVBAYTAkNOMRAwDgYDVQQIDAdCZWlqaW5nMRAwDgYD
        VQQHDAdCZWlqaW5nMQwwCgYDVQQKDANBbGkxDzANBgNVBAsMBkFsaXl1bjESMBAG
        A1UEAwwJVGVycmFmb3JtMR0wGwYJKoZIhvcNAQkBFg4xMjNAYWxpeXVtLmNvbTCC
        ASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK4UufXydtJZeW6lX9VahVIk
        ifblYCVkFcFoderF2FtD5AeMZJ+v+chHc7RiV+U7P3o0Fzk+cg7OL9dSEYBrwHK4
        9yCwU/Mv+I/KsS8GjrRMOPjbrYvI0GjheEPJcILbt29tygrxX2PwV6FqWNknbGpk
        Ej8L9zTL977IHBmgw8A2AeKlqV64s8ydAgGbWO3NTK64OlEJJNR+J+75uYskNT3s
        8DqaQV/IWlGAiUmGVeorWkrAWCfx2zSwI9jU8pNHtSF7PyxlbRy1ir2Lv1WnQKHf
        Bnhr/wXwKOL5IJRVZ144Z9TdcoPo4GbFmYMSTwYFIbjYZ3yxoygeXMk0UXPZxVsC
        AwEAATANBgkqhkiG9w0BAQsFAAOCAQEAVPA+Q0/5T6VzVw+MFXjCxXH1mWgd767w
        YWX4tvdGsTDkK6/ESm8m9GDp5F3p7Degk0isr9XkyzkWo/nPEPWQOeYR0kNTvpwY
        mKz9/aJwxalHS6O/8K2Ed6pZcXW0SUfjdH0/9YHw+vu4i2cQGTICzrKuEvyck40y
        fQocvFyw6O7W+tewLA4ntTuC6HhEQbC0p7zxGc3LSuayBgJrJiOAnGvFu+/OFQi+
        zEXi1xt8uQR6q5DQDsfqNCxpRKsCmU+POzNg2Y31GDMv4ZPerou5jXa1gh8/TVBT
        IX3OTy5aL4Ue8nBip3bVw+V/9L9xhmXbex6IMwwvrWI4OfMt6ECifQ==
        -----END CERTIFICATE-----
        \"\"\",
            certificate_name=std.join(separator="-",
                input=[
                    name,
                    default_integer["result"],
                    0,
                ]).result,
            key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIIEogIBAAKCAQEArhS59fJ20ll5bqVf1VqFUiSJ9uVgJWQVwWh16sXYW0PkB4xk
        n6/5yEdztGJX5Ts/ejQXOT5yDs4v11IRgGvAcrj3ILBT8y/4j8qxLwaOtEw4+Nut
        i8jQaOF4Q8lwgtu3b23KCvFfY/BXoWpY2SdsamQSPwv3NMv3vsgcGaDDwDYB4qWp
        XrizzJ0CAZtY7c1Mrrg6UQkk1H4n7vm5iyQ1PezwOppBX8haUYCJSYZV6itaSsBY
        J/HbNLAj2NTyk0e1IXs/LGVtHLWKvYu/VadAod8GeGv/BfAo4vkglFVnXjhn1N1y
        g+jgZsWZgxJPBgUhuNhnfLGjKB5cyTRRc9nFWwIDAQABAoIBAC0D2Q6bc1RzpK4S
        /5QZQ055el+o8tLYbbPEwnFCVe9LwASfrkmI5OuAZpAnuhjh2ElOfQ7lcfMYKFDi
        vPnbYzmHUQhX8G17YygzvtutM2u2JilcDSWPeS0V2NaWmYyNKoMa/dsUjZk3RkHM
        UUteIW/ljr5U5sj1UYw5DOMnqlbicy2cPPY4g1QKGW5t3p5Lxw5ojgqynzi8EKMq
        j0apEoTXxmciOrwwiP2ynRTEN77+FUZkTvmxmSPoIfNTycDPRr4aUwVHV2d5FHPn
        d1MdjSoUPbHdOLfynwXqTz9OlvMSUDrBvs6k5ripGY9qvh9PrOdj7zLXVRQXUuOR
        YwoVHKECgYEA1NzNGifjW5cdcbkzc86QA9TM7yAyBmgnopzlm+dFIhxtJmydxN4V
        820x1Lkfe2vLCyYQ6fcEKAtjC9qdw+E2uzHAbtvnR4JseF3z1D82xw3MgGT9l3zc
        mMrgKmdCGGLWi6hboylX+2GBMVl2R0aRZrZje67jZcDXd06mlvW257ECgYEA0Vv1
        X3Ubn8XA3AA1ybem8fWNwEXfcYP1lJq0cX1gUXlpQvxWN61//aFZUCJZw5cEPArQ
        rEqhT81VCqXGO/by6D3fJD+4P8D6v6szJK2AGvXkZMfnJwAbHcOyGlxMin1CTJss
        ZID0XI9xmbedm7Wi40+qXz8q4rs25kft9YjfzMsCgYBSPfE8vtaYJ52nt7+Kae+4
        mzqG1XCeixVtPaN1BfjvAf6mDucyDgB7KeBL6S6ht/ceGpoEW30On7+n79JuwRAt
        aT6JVotYVKrmIp63jajzZYByxxI3unVcz12m5HhkBaQRF344XxvwMy8ASyloxnod
        LjDns52GTeix3wB8aPk/MQKBgGOQRwXpjISUKB64HtxacZN6ArqgwB2c8uqEFDIw
        vOCiS7Pmix4ZbdfxpqbcXzIMHKBtSEXXjBWGgd35bmfQDj7yRa9Yekgff2Ati7ny
        pQytSbu/8abzfvHNwmKU6HWoEiKaXSdCyHNIaG8BCnwlilxt44k+YifHftlO9dSi
        DkS3AoGAYmF++8uEvQot5Yma4GraY+7ZyfWNLwClsOsrN2g19Vycg16fJk0olwDx
        2kRWKqNn99HJJwiLie1nvsDRJLbmzmI91Pttpu/EYFDJ8OYQOr1OhhPwwTygf+7S
        1o2RTXu3gKNG6fxOtHFatws3IzvovOASYyJR5XP2sIJURLOrSN0=
        -----END RSA PRIVATE KEY-----
        \"\"\")
        create_listener = alicloud.nlb.Listener("create_listener",
            listener_port=443,
            server_group_id=create_sg.id,
            load_balancer_id=lb.id,
            listener_protocol="TCPSSL",
            certificate_ids=[ssl0.id.apply(lambda id: f"{id}-cn-hangzhou")],
            ca_certificate_ids=[])
        ssl = alicloud.cas.ServiceCertificate("ssl",
            cert=\"\"\"-----BEGIN CERTIFICATE-----
        MIIDRjCCAq+gAwIBAgIJAJn3ox4K13PoMA0GCSqGSIb3DQEBBQUAMHYxCzAJBgNV
        BAYTAkNOMQswCQYDVQQIEwJCSjELMAkGA1UEBxMCQkoxDDAKBgNVBAoTA0FMSTEP
        MA0GA1UECxMGQUxJWVVOMQ0wCwYDVQQDEwR0ZXN0MR8wHQYJKoZIhvcNAQkBFhB0
        ZXN0QGhvdG1haWwuY29tMB4XDTE0MTEyNDA2MDQyNVoXDTI0MTEyMTA2MDQyNVow
        djELMAkGA1UEBhMCQ04xCzAJBgNVBAgTAkJKMQswCQYDVQQHEwJCSjEMMAoGA1UE
        ChMDQUxJMQ8wDQYDVQQLEwZBTElZVU4xDTALBgNVBAMTBHRlc3QxHzAdBgkqhkiG
        9w0BCQEWEHRlc3RAaG90bWFpbC5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJ
        AoGBAM7SS3e9+Nj0HKAsRuIDNSsS3UK6b+62YQb2uuhKrp1HMrOx61WSDR2qkAnB
        coG00Uz38EE+9DLYNUVQBK7aSgLP5M1Ak4wr4GqGyCgjejzzh3DshUzLCCy2rook
        KOyRTlPX+Q5l7rE1fcSNzgepcae5i2sE1XXXzLRIDIvQxcspAgMBAAGjgdswgdgw
        HQYDVR0OBBYEFBdy+OuMsvbkV7R14f0OyoLoh2z4MIGoBgNVHSMEgaAwgZ2AFBdy
        +OuMsvbkV7R14f0OyoLoh2z4oXqkeDB2MQswCQYDVQQGEwJDTjELMAkGA1UECBMC
        QkoxCzAJBgNVBAcTAkJKMQwwCgYDVQQKEwNBTEkxDzANBgNVBAsTBkFMSVlVTjEN
        MAsGA1UEAxMEdGVzdDEfMB0GCSqGSIb3DQEJARYQdGVzdEBob3RtYWlsLmNvbYIJ
        AJn3ox4K13PoMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADgYEAY7KOsnyT
        cQzfhiiG7ASjiPakw5wXoycHt5GCvLG5htp2TKVzgv9QTliA3gtfv6oV4zRZx7X1
        Ofi6hVgErtHaXJheuPVeW6eAW8mHBoEfvDAfU3y9waYrtUevSl07643bzKL6v+Qd
        DUBTxOAvSYfXTtI90EAxEG/bJJyOm5LqoiA=
        -----END CERTIFICATE-----
        \"\"\",
            certificate_name=std.join(separator="-",
                input=[
                    name,
                    default_integer["result"],
                    1,
                ]).result,
            key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIICXAIBAAKBgQDO0kt3vfjY9BygLEbiAzUrEt1Cum/utmEG9rroSq6dRzKzsetV
        kg0dqpAJwXKBtNFM9/BBPvQy2DVFUASu2koCz+TNQJOMK+BqhsgoI3o884dw7IVM
        ywgstq6KJCjskU5T1/kOZe6xNX3Ejc4HqXGnuYtrBNV118y0SAyL0MXLKQIDAQAB
        AoGAfe3NxbsGKhN42o4bGsKZPQDfeCHMxayGp5bTd10BtQIE/ST4BcJH+ihAS7Bd
        6FwQlKzivNd4GP1MckemklCXfsVckdL94e8ZbJl23GdWul3v8V+KndJHqv5zVJmP
        hwWoKimwIBTb2s0ctVryr2f18N4hhyFw1yGp0VxclGHkjgECQQD9CvllsnOwHpP4
        MdrDHbdb29QrobKyKW8pPcDd+sth+kP6Y8MnCVuAKXCKj5FeIsgVtfluPOsZjPzz
        71QQWS1dAkEA0T0KXO8gaBQwJhIoo/w6hy5JGZnrNSpOPp5xvJuMAafs2eyvmhJm
        Ev9SN/Pf2VYa1z6FEnBaLOVD6hf6YQIsPQJAX/CZPoW6dzwgvimo1/GcY6eleiWE
        qygqjWhsh71e/3bz7yuEAnj5yE3t7Zshcp+dXR3xxGo0eSuLfLFxHgGxwQJAAxf8
        9DzQ5NkPkTCJi0sqbl8/03IUKTgT6hcbpWdDXa7m8J3wRr3o5nUB+TPQ5nzAbthM
        zWX931YQeACcwhxvHQJBAN5mTzzJD4w4Ma6YTaNHyXakdYfyAWrOkPIWZxfhMfXe
        DrlNdiysTI4Dd1dLeErVpjsckAaOW/JDG5PCSwkaMxk=
        -----END RSA PRIVATE KEY-----
        \"\"\")
        default_listener_additional_certificate_attachment = alicloud.nlb.ListenerAdditionalCertificateAttachment("default",
            certificate_id=ssl.id,
            listener_id=create_listener.id)
        ```

        ## Import

        NLB Listener Additional Certificate Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nlb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment example <listener_id>:<certificate_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of additional certificates.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.str] listener_id: The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerAdditionalCertificateAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a NLB Listener Additional Certificate Attachment resource.

        For information about NLB Listener Additional Certificate Attachment and how to use it, see [What is Listener Additional Certificate Attachment](https://www.alibabacloud.com/help/en/server-load-balancer/latest/nlb-instances-change).

        > **NOTE:** Available since v1.209.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.nlb.get_zones()
        create_vpc = alicloud.vpc.Network("create_vpc", cidr_block="172.16.0.0/12")
        create_vsw_j = alicloud.vpc.Switch("create_vsw_j",
            vpc_id=create_vpc.id,
            zone_id=default.zones[0].id,
            cidr_block="172.16.1.0/24")
        create_vsw_k = alicloud.vpc.Switch("create_vsw_k",
            vpc_id=create_vpc.id,
            zone_id=default.zones[1].id,
            cidr_block="172.16.2.0/24")
        lb = alicloud.nlb.LoadBalancer("lb",
            address_ip_version="Ipv4",
            zone_mappings=[
                {
                    "vswitch_id": create_vsw_j.id,
                    "zone_id": create_vsw_j.zone_id,
                },
                {
                    "vswitch_id": create_vsw_k.id,
                    "zone_id": create_vsw_k.zone_id,
                },
            ],
            load_balancer_type="Network",
            load_balancer_name=name,
            vpc_id=create_vpc.id,
            address_type="Internet")
        create_sg = alicloud.nlb.ServerGroup("create_sg",
            address_ip_version="Ipv4",
            scheduler="Wrr",
            health_check={},
            server_group_type="Instance",
            vpc_id=create_vpc.id,
            protocol="TCPSSL",
            server_group_name=name)
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        ssl0 = alicloud.cas.ServiceCertificate("ssl0",
            cert=\"\"\"-----BEGIN CERTIFICATE-----
        MIIDhDCCAmwCCQCwJW4JChLBqTANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMC
        Q04xEDAOBgNVBAgMB0JlaWppbmcxEDAOBgNVBAcMB0JlaWppbmcxDDAKBgNVBAoM
        A0FsaTEPMA0GA1UECwwGQWxpeXVuMRIwEAYDVQQDDAlUZXJyYWZvcm0xHTAbBgkq
        hkiG9w0BCQEWDjEyM0BhbGl5dW0uY29tMB4XDTI0MTIyNTA3MjQ0OFoXDTI3MTIy
        NTA3MjQ0OFowgYMxCzAJBgNVBAYTAkNOMRAwDgYDVQQIDAdCZWlqaW5nMRAwDgYD
        VQQHDAdCZWlqaW5nMQwwCgYDVQQKDANBbGkxDzANBgNVBAsMBkFsaXl1bjESMBAG
        A1UEAwwJVGVycmFmb3JtMR0wGwYJKoZIhvcNAQkBFg4xMjNAYWxpeXVtLmNvbTCC
        ASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK4UufXydtJZeW6lX9VahVIk
        ifblYCVkFcFoderF2FtD5AeMZJ+v+chHc7RiV+U7P3o0Fzk+cg7OL9dSEYBrwHK4
        9yCwU/Mv+I/KsS8GjrRMOPjbrYvI0GjheEPJcILbt29tygrxX2PwV6FqWNknbGpk
        Ej8L9zTL977IHBmgw8A2AeKlqV64s8ydAgGbWO3NTK64OlEJJNR+J+75uYskNT3s
        8DqaQV/IWlGAiUmGVeorWkrAWCfx2zSwI9jU8pNHtSF7PyxlbRy1ir2Lv1WnQKHf
        Bnhr/wXwKOL5IJRVZ144Z9TdcoPo4GbFmYMSTwYFIbjYZ3yxoygeXMk0UXPZxVsC
        AwEAATANBgkqhkiG9w0BAQsFAAOCAQEAVPA+Q0/5T6VzVw+MFXjCxXH1mWgd767w
        YWX4tvdGsTDkK6/ESm8m9GDp5F3p7Degk0isr9XkyzkWo/nPEPWQOeYR0kNTvpwY
        mKz9/aJwxalHS6O/8K2Ed6pZcXW0SUfjdH0/9YHw+vu4i2cQGTICzrKuEvyck40y
        fQocvFyw6O7W+tewLA4ntTuC6HhEQbC0p7zxGc3LSuayBgJrJiOAnGvFu+/OFQi+
        zEXi1xt8uQR6q5DQDsfqNCxpRKsCmU+POzNg2Y31GDMv4ZPerou5jXa1gh8/TVBT
        IX3OTy5aL4Ue8nBip3bVw+V/9L9xhmXbex6IMwwvrWI4OfMt6ECifQ==
        -----END CERTIFICATE-----
        \"\"\",
            certificate_name=std.join(separator="-",
                input=[
                    name,
                    default_integer["result"],
                    0,
                ]).result,
            key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIIEogIBAAKCAQEArhS59fJ20ll5bqVf1VqFUiSJ9uVgJWQVwWh16sXYW0PkB4xk
        n6/5yEdztGJX5Ts/ejQXOT5yDs4v11IRgGvAcrj3ILBT8y/4j8qxLwaOtEw4+Nut
        i8jQaOF4Q8lwgtu3b23KCvFfY/BXoWpY2SdsamQSPwv3NMv3vsgcGaDDwDYB4qWp
        XrizzJ0CAZtY7c1Mrrg6UQkk1H4n7vm5iyQ1PezwOppBX8haUYCJSYZV6itaSsBY
        J/HbNLAj2NTyk0e1IXs/LGVtHLWKvYu/VadAod8GeGv/BfAo4vkglFVnXjhn1N1y
        g+jgZsWZgxJPBgUhuNhnfLGjKB5cyTRRc9nFWwIDAQABAoIBAC0D2Q6bc1RzpK4S
        /5QZQ055el+o8tLYbbPEwnFCVe9LwASfrkmI5OuAZpAnuhjh2ElOfQ7lcfMYKFDi
        vPnbYzmHUQhX8G17YygzvtutM2u2JilcDSWPeS0V2NaWmYyNKoMa/dsUjZk3RkHM
        UUteIW/ljr5U5sj1UYw5DOMnqlbicy2cPPY4g1QKGW5t3p5Lxw5ojgqynzi8EKMq
        j0apEoTXxmciOrwwiP2ynRTEN77+FUZkTvmxmSPoIfNTycDPRr4aUwVHV2d5FHPn
        d1MdjSoUPbHdOLfynwXqTz9OlvMSUDrBvs6k5ripGY9qvh9PrOdj7zLXVRQXUuOR
        YwoVHKECgYEA1NzNGifjW5cdcbkzc86QA9TM7yAyBmgnopzlm+dFIhxtJmydxN4V
        820x1Lkfe2vLCyYQ6fcEKAtjC9qdw+E2uzHAbtvnR4JseF3z1D82xw3MgGT9l3zc
        mMrgKmdCGGLWi6hboylX+2GBMVl2R0aRZrZje67jZcDXd06mlvW257ECgYEA0Vv1
        X3Ubn8XA3AA1ybem8fWNwEXfcYP1lJq0cX1gUXlpQvxWN61//aFZUCJZw5cEPArQ
        rEqhT81VCqXGO/by6D3fJD+4P8D6v6szJK2AGvXkZMfnJwAbHcOyGlxMin1CTJss
        ZID0XI9xmbedm7Wi40+qXz8q4rs25kft9YjfzMsCgYBSPfE8vtaYJ52nt7+Kae+4
        mzqG1XCeixVtPaN1BfjvAf6mDucyDgB7KeBL6S6ht/ceGpoEW30On7+n79JuwRAt
        aT6JVotYVKrmIp63jajzZYByxxI3unVcz12m5HhkBaQRF344XxvwMy8ASyloxnod
        LjDns52GTeix3wB8aPk/MQKBgGOQRwXpjISUKB64HtxacZN6ArqgwB2c8uqEFDIw
        vOCiS7Pmix4ZbdfxpqbcXzIMHKBtSEXXjBWGgd35bmfQDj7yRa9Yekgff2Ati7ny
        pQytSbu/8abzfvHNwmKU6HWoEiKaXSdCyHNIaG8BCnwlilxt44k+YifHftlO9dSi
        DkS3AoGAYmF++8uEvQot5Yma4GraY+7ZyfWNLwClsOsrN2g19Vycg16fJk0olwDx
        2kRWKqNn99HJJwiLie1nvsDRJLbmzmI91Pttpu/EYFDJ8OYQOr1OhhPwwTygf+7S
        1o2RTXu3gKNG6fxOtHFatws3IzvovOASYyJR5XP2sIJURLOrSN0=
        -----END RSA PRIVATE KEY-----
        \"\"\")
        create_listener = alicloud.nlb.Listener("create_listener",
            listener_port=443,
            server_group_id=create_sg.id,
            load_balancer_id=lb.id,
            listener_protocol="TCPSSL",
            certificate_ids=[ssl0.id.apply(lambda id: f"{id}-cn-hangzhou")],
            ca_certificate_ids=[])
        ssl = alicloud.cas.ServiceCertificate("ssl",
            cert=\"\"\"-----BEGIN CERTIFICATE-----
        MIIDRjCCAq+gAwIBAgIJAJn3ox4K13PoMA0GCSqGSIb3DQEBBQUAMHYxCzAJBgNV
        BAYTAkNOMQswCQYDVQQIEwJCSjELMAkGA1UEBxMCQkoxDDAKBgNVBAoTA0FMSTEP
        MA0GA1UECxMGQUxJWVVOMQ0wCwYDVQQDEwR0ZXN0MR8wHQYJKoZIhvcNAQkBFhB0
        ZXN0QGhvdG1haWwuY29tMB4XDTE0MTEyNDA2MDQyNVoXDTI0MTEyMTA2MDQyNVow
        djELMAkGA1UEBhMCQ04xCzAJBgNVBAgTAkJKMQswCQYDVQQHEwJCSjEMMAoGA1UE
        ChMDQUxJMQ8wDQYDVQQLEwZBTElZVU4xDTALBgNVBAMTBHRlc3QxHzAdBgkqhkiG
        9w0BCQEWEHRlc3RAaG90bWFpbC5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJ
        AoGBAM7SS3e9+Nj0HKAsRuIDNSsS3UK6b+62YQb2uuhKrp1HMrOx61WSDR2qkAnB
        coG00Uz38EE+9DLYNUVQBK7aSgLP5M1Ak4wr4GqGyCgjejzzh3DshUzLCCy2rook
        KOyRTlPX+Q5l7rE1fcSNzgepcae5i2sE1XXXzLRIDIvQxcspAgMBAAGjgdswgdgw
        HQYDVR0OBBYEFBdy+OuMsvbkV7R14f0OyoLoh2z4MIGoBgNVHSMEgaAwgZ2AFBdy
        +OuMsvbkV7R14f0OyoLoh2z4oXqkeDB2MQswCQYDVQQGEwJDTjELMAkGA1UECBMC
        QkoxCzAJBgNVBAcTAkJKMQwwCgYDVQQKEwNBTEkxDzANBgNVBAsTBkFMSVlVTjEN
        MAsGA1UEAxMEdGVzdDEfMB0GCSqGSIb3DQEJARYQdGVzdEBob3RtYWlsLmNvbYIJ
        AJn3ox4K13PoMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADgYEAY7KOsnyT
        cQzfhiiG7ASjiPakw5wXoycHt5GCvLG5htp2TKVzgv9QTliA3gtfv6oV4zRZx7X1
        Ofi6hVgErtHaXJheuPVeW6eAW8mHBoEfvDAfU3y9waYrtUevSl07643bzKL6v+Qd
        DUBTxOAvSYfXTtI90EAxEG/bJJyOm5LqoiA=
        -----END CERTIFICATE-----
        \"\"\",
            certificate_name=std.join(separator="-",
                input=[
                    name,
                    default_integer["result"],
                    1,
                ]).result,
            key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIICXAIBAAKBgQDO0kt3vfjY9BygLEbiAzUrEt1Cum/utmEG9rroSq6dRzKzsetV
        kg0dqpAJwXKBtNFM9/BBPvQy2DVFUASu2koCz+TNQJOMK+BqhsgoI3o884dw7IVM
        ywgstq6KJCjskU5T1/kOZe6xNX3Ejc4HqXGnuYtrBNV118y0SAyL0MXLKQIDAQAB
        AoGAfe3NxbsGKhN42o4bGsKZPQDfeCHMxayGp5bTd10BtQIE/ST4BcJH+ihAS7Bd
        6FwQlKzivNd4GP1MckemklCXfsVckdL94e8ZbJl23GdWul3v8V+KndJHqv5zVJmP
        hwWoKimwIBTb2s0ctVryr2f18N4hhyFw1yGp0VxclGHkjgECQQD9CvllsnOwHpP4
        MdrDHbdb29QrobKyKW8pPcDd+sth+kP6Y8MnCVuAKXCKj5FeIsgVtfluPOsZjPzz
        71QQWS1dAkEA0T0KXO8gaBQwJhIoo/w6hy5JGZnrNSpOPp5xvJuMAafs2eyvmhJm
        Ev9SN/Pf2VYa1z6FEnBaLOVD6hf6YQIsPQJAX/CZPoW6dzwgvimo1/GcY6eleiWE
        qygqjWhsh71e/3bz7yuEAnj5yE3t7Zshcp+dXR3xxGo0eSuLfLFxHgGxwQJAAxf8
        9DzQ5NkPkTCJi0sqbl8/03IUKTgT6hcbpWdDXa7m8J3wRr3o5nUB+TPQ5nzAbthM
        zWX931YQeACcwhxvHQJBAN5mTzzJD4w4Ma6YTaNHyXakdYfyAWrOkPIWZxfhMfXe
        DrlNdiysTI4Dd1dLeErVpjsckAaOW/JDG5PCSwkaMxk=
        -----END RSA PRIVATE KEY-----
        \"\"\")
        default_listener_additional_certificate_attachment = alicloud.nlb.ListenerAdditionalCertificateAttachment("default",
            certificate_id=ssl.id,
            listener_id=create_listener.id)
        ```

        ## Import

        NLB Listener Additional Certificate Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nlb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment example <listener_id>:<certificate_id>
        ```

        :param str resource_name: The name of the resource.
        :param ListenerAdditionalCertificateAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerAdditionalCertificateAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerAdditionalCertificateAttachmentArgs.__new__(ListenerAdditionalCertificateAttachmentArgs)

            if certificate_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_id'")
            __props__.__dict__["certificate_id"] = certificate_id
            __props__.__dict__["dry_run"] = dry_run
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            __props__.__dict__["status"] = None
        super(ListenerAdditionalCertificateAttachment, __self__).__init__(
            'alicloud:nlb/listenerAdditionalCertificateAttachment:ListenerAdditionalCertificateAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ListenerAdditionalCertificateAttachment':
        """
        Get an existing ListenerAdditionalCertificateAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_id: The ID of additional certificates.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run, without performing the actual request. Valid values:
        :param pulumi.Input[_builtins.str] listener_id: The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerAdditionalCertificateAttachmentState.__new__(_ListenerAdditionalCertificateAttachmentState)

        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["status"] = status
        return ListenerAdditionalCertificateAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of additional certificates.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to perform a dry run, without performing the actual request. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        The listener ID. You must specify the ID of a listener that uses SSL over TCP.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

