# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 address_type: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 zone_mappings: pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]],
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 cross_zone_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_config: Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_config: Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']] = None,
                 modification_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[_builtins.str] address_type: The type of IPv4 address used by the NLB instance. Valid values:
               - `Internet`: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - `Intranet`: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.
               
               > **NOTE:**   To enable a public IPv6 address for an NLB instance, call the [EnableLoadBalancerIpv6Internet](https://www.alibabacloud.com/help/en/doc-detail/445878.html) operation.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC where the NLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]] zone_mappings: Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        :param pulumi.Input[_builtins.str] address_ip_version: The protocol version. Valid values:
               
               - **ipv4:** IPv4. This is the default value.
               - **DualStack:** dual stack.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the EIP bandwidth plan that is associated with the Internet-facing NLB instance.
        :param pulumi.Input[_builtins.int] cps: The speed limit of new connections per second processed by NLB instances in each VIP. Value range: `0` to `1000000`.
               
               - *0** means no speed limit.
        :param pulumi.Input[_builtins.bool] cross_zone_enabled: Specifies whether to enable cross-zone load balancing for the NLB instance. Valid values:
        :param pulumi.Input['LoadBalancerDeletionProtectionConfigArgs'] deletion_protection_config: Specifies whether to enable deletion protection. Default value: `false`. See `deletion_protection_config` below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] deletion_protection_reason: The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        :param pulumi.Input[_builtins.str] ipv6_address_type: The type of IPv6 address used by the NLB instance. Valid values:
               - `Internet`: a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - `Intranet`: a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the VPC where the NLB instance is deployed.
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the NLB instance.
               The value must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The value must start with a letter.
        :param pulumi.Input[_builtins.str] load_balancer_type: The type of the Server Load Balancer (SLB) instance. Set the value to `network`, which specifies NLB.
        :param pulumi.Input['LoadBalancerModificationProtectionConfigArgs'] modification_protection_config: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. See `modification_protection_config` below.
        :param pulumi.Input[_builtins.str] modification_protection_reason: The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        :param pulumi.Input[_builtins.str] modification_protection_status: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
               - `NonProtection`: Does not enable the configuration read-only mode. You cannot set the `modification_protection_reason`. If the `modification_protection_reason` is set, the value is cleared.
               - `ConsoleProtection`: Enables the configuration read-only mode. You can set the `modification_protection_reason`.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               You can log on to the [Resource Management console](https://resourcemanager.console.aliyun.com/resource-groups) to view resource group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The security group to which the network-based SLB instance belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: List of labels.
        """
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_mappings", zone_mappings)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if bandwidth_package_id is not None:
            pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        if cps is not None:
            pulumi.set(__self__, "cps", cps)
        if cross_zone_enabled is not None:
            pulumi.set(__self__, "cross_zone_enabled", cross_zone_enabled)
        if deletion_protection_config is not None:
            pulumi.set(__self__, "deletion_protection_config", deletion_protection_config)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deletion_protection_reason is not None:
            pulumi.set(__self__, "deletion_protection_reason", deletion_protection_reason)
        if ipv6_address_type is not None:
            pulumi.set(__self__, "ipv6_address_type", ipv6_address_type)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if modification_protection_config is not None:
            pulumi.set(__self__, "modification_protection_config", modification_protection_config)
        if modification_protection_reason is not None:
            pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        if modification_protection_status is not None:
            pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of IPv4 address used by the NLB instance. Valid values:
        - `Internet`: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
        - `Intranet`: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.

        > **NOTE:**   To enable a public IPv6 address for an NLB instance, call the [EnableLoadBalancerIpv6Internet](https://www.alibabacloud.com/help/en/doc-detail/445878.html) operation.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC where the NLB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]:
        """
        Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        return pulumi.get(self, "zone_mappings")

    @zone_mappings.setter
    def zone_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]):
        pulumi.set(self, "zone_mappings", value)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol version. Valid values:

        - **ipv4:** IPv4. This is the default value.
        - **DualStack:** dual stack.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EIP bandwidth plan that is associated with the Internet-facing NLB instance.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @bandwidth_package_id.setter
    def bandwidth_package_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_package_id", value)

    @_builtins.property
    @pulumi.getter
    def cps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The speed limit of new connections per second processed by NLB instances in each VIP. Value range: `0` to `1000000`.

        - *0** means no speed limit.
        """
        return pulumi.get(self, "cps")

    @cps.setter
    def cps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cps", value)

    @_builtins.property
    @pulumi.getter(name="crossZoneEnabled")
    def cross_zone_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable cross-zone load balancing for the NLB instance. Valid values:
        """
        return pulumi.get(self, "cross_zone_enabled")

    @cross_zone_enabled.setter
    def cross_zone_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_zone_enabled", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionConfig")
    def deletion_protection_config(self) -> Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']]:
        """
        Specifies whether to enable deletion protection. Default value: `false`. See `deletion_protection_config` below.
        """
        return pulumi.get(self, "deletion_protection_config")

    @deletion_protection_config.setter
    def deletion_protection_config(self, value: Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']]):
        pulumi.set(self, "deletion_protection_config", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionReason")
    def deletion_protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        """
        return pulumi.get(self, "deletion_protection_reason")

    @deletion_protection_reason.setter
    def deletion_protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressType")
    def ipv6_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of IPv6 address used by the NLB instance. Valid values:
        - `Internet`: a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
        - `Intranet`: a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the VPC where the NLB instance is deployed.
        """
        return pulumi.get(self, "ipv6_address_type")

    @ipv6_address_type.setter
    def ipv6_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NLB instance.
        The value must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The value must start with a letter.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_name", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Server Load Balancer (SLB) instance. Set the value to `network`, which specifies NLB.
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_type", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionConfig")
    def modification_protection_config(self) -> Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']]:
        """
        Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. See `modification_protection_config` below.
        """
        return pulumi.get(self, "modification_protection_config")

    @modification_protection_config.setter
    def modification_protection_config(self, value: Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']]):
        pulumi.set(self, "modification_protection_config", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_reason")

    @modification_protection_reason.setter
    def modification_protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modification_protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
        - `NonProtection`: Does not enable the configuration read-only mode. You cannot set the `modification_protection_reason`. If the `modification_protection_reason` is set, the value is cleared.
        - `ConsoleProtection`: Enables the configuration read-only mode. You can set the `modification_protection_reason`.
        """
        return pulumi.get(self, "modification_protection_status")

    @modification_protection_status.setter
    def modification_protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modification_protection_status", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the new resource group.
        You can log on to the [Resource Management console](https://resourcemanager.console.aliyun.com/resource-groups) to view resource group IDs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The security group to which the network-based SLB instance belongs.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        List of labels.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_zone_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_config: Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_business_status: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_config: Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']] = None,
                 modification_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input[_builtins.str] address_ip_version: The protocol version. Valid values:
               
               - **ipv4:** IPv4. This is the default value.
               - **DualStack:** dual stack.
        :param pulumi.Input[_builtins.str] address_type: The type of IPv4 address used by the NLB instance. Valid values:
               - `Internet`: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - `Intranet`: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.
               
               > **NOTE:**   To enable a public IPv6 address for an NLB instance, call the [EnableLoadBalancerIpv6Internet](https://www.alibabacloud.com/help/en/doc-detail/445878.html) operation.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the EIP bandwidth plan that is associated with the Internet-facing NLB instance.
        :param pulumi.Input[_builtins.int] cps: The speed limit of new connections per second processed by NLB instances in each VIP. Value range: `0` to `1000000`.
               
               - *0** means no speed limit.
        :param pulumi.Input[_builtins.str] create_time: Resource creation time, using Greenwich Mean Time, formating' yyyy-MM-ddTHH:mm:ssZ '.
        :param pulumi.Input[_builtins.bool] cross_zone_enabled: Specifies whether to enable cross-zone load balancing for the NLB instance. Valid values:
        :param pulumi.Input['LoadBalancerDeletionProtectionConfigArgs'] deletion_protection_config: Specifies whether to enable deletion protection. Default value: `false`. See `deletion_protection_config` below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] deletion_protection_reason: The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        :param pulumi.Input[_builtins.str] dns_name: The domain name of the NLB instance.
        :param pulumi.Input[_builtins.str] ipv6_address_type: The type of IPv6 address used by the NLB instance. Valid values:
               - `Internet`: a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - `Intranet`: a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the VPC where the NLB instance is deployed.
        :param pulumi.Input[_builtins.str] load_balancer_business_status: The business status of the NLB instance.
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the NLB instance.
               The value must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The value must start with a letter.
        :param pulumi.Input[_builtins.str] load_balancer_type: The type of the Server Load Balancer (SLB) instance. Set the value to `network`, which specifies NLB.
        :param pulumi.Input['LoadBalancerModificationProtectionConfigArgs'] modification_protection_config: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. See `modification_protection_config` below.
        :param pulumi.Input[_builtins.str] modification_protection_reason: The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        :param pulumi.Input[_builtins.str] modification_protection_status: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
               - `NonProtection`: Does not enable the configuration read-only mode. You cannot set the `modification_protection_reason`. If the `modification_protection_reason` is set, the value is cleared.
               - `ConsoleProtection`: Enables the configuration read-only mode. You can set the `modification_protection_reason`.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the NLB instance is deployed.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               You can log on to the [Resource Management console](https://resourcemanager.console.aliyun.com/resource-groups) to view resource group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The security group to which the network-based SLB instance belongs.
        :param pulumi.Input[_builtins.str] status: Zone Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: List of labels.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC where the NLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]] zone_mappings: Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if bandwidth_package_id is not None:
            pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        if cps is not None:
            pulumi.set(__self__, "cps", cps)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_zone_enabled is not None:
            pulumi.set(__self__, "cross_zone_enabled", cross_zone_enabled)
        if deletion_protection_config is not None:
            pulumi.set(__self__, "deletion_protection_config", deletion_protection_config)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if deletion_protection_reason is not None:
            pulumi.set(__self__, "deletion_protection_reason", deletion_protection_reason)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if ipv6_address_type is not None:
            pulumi.set(__self__, "ipv6_address_type", ipv6_address_type)
        if load_balancer_business_status is not None:
            pulumi.set(__self__, "load_balancer_business_status", load_balancer_business_status)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if modification_protection_config is not None:
            pulumi.set(__self__, "modification_protection_config", modification_protection_config)
        if modification_protection_reason is not None:
            pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        if modification_protection_status is not None:
            pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_mappings is not None:
            pulumi.set(__self__, "zone_mappings", zone_mappings)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol version. Valid values:

        - **ipv4:** IPv4. This is the default value.
        - **DualStack:** dual stack.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of IPv4 address used by the NLB instance. Valid values:
        - `Internet`: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
        - `Intranet`: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.

        > **NOTE:**   To enable a public IPv6 address for an NLB instance, call the [EnableLoadBalancerIpv6Internet](https://www.alibabacloud.com/help/en/doc-detail/445878.html) operation.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EIP bandwidth plan that is associated with the Internet-facing NLB instance.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @bandwidth_package_id.setter
    def bandwidth_package_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_package_id", value)

    @_builtins.property
    @pulumi.getter
    def cps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The speed limit of new connections per second processed by NLB instances in each VIP. Value range: `0` to `1000000`.

        - *0** means no speed limit.
        """
        return pulumi.get(self, "cps")

    @cps.setter
    def cps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cps", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource creation time, using Greenwich Mean Time, formating' yyyy-MM-ddTHH:mm:ssZ '.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="crossZoneEnabled")
    def cross_zone_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable cross-zone load balancing for the NLB instance. Valid values:
        """
        return pulumi.get(self, "cross_zone_enabled")

    @cross_zone_enabled.setter
    def cross_zone_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_zone_enabled", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionConfig")
    def deletion_protection_config(self) -> Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']]:
        """
        Specifies whether to enable deletion protection. Default value: `false`. See `deletion_protection_config` below.
        """
        return pulumi.get(self, "deletion_protection_config")

    @deletion_protection_config.setter
    def deletion_protection_config(self, value: Optional[pulumi.Input['LoadBalancerDeletionProtectionConfigArgs']]):
        pulumi.set(self, "deletion_protection_config", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtectionReason")
    def deletion_protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        """
        return pulumi.get(self, "deletion_protection_reason")

    @deletion_protection_reason.setter
    def deletion_protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of the NLB instance.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressType")
    def ipv6_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of IPv6 address used by the NLB instance. Valid values:
        - `Internet`: a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
        - `Intranet`: a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the VPC where the NLB instance is deployed.
        """
        return pulumi.get(self, "ipv6_address_type")

    @ipv6_address_type.setter
    def ipv6_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerBusinessStatus")
    def load_balancer_business_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The business status of the NLB instance.
        """
        return pulumi.get(self, "load_balancer_business_status")

    @load_balancer_business_status.setter
    def load_balancer_business_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_business_status", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NLB instance.
        The value must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The value must start with a letter.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_name", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Server Load Balancer (SLB) instance. Set the value to `network`, which specifies NLB.
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_type", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionConfig")
    def modification_protection_config(self) -> Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']]:
        """
        Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. See `modification_protection_config` below.
        """
        return pulumi.get(self, "modification_protection_config")

    @modification_protection_config.setter
    def modification_protection_config(self, value: Optional[pulumi.Input['LoadBalancerModificationProtectionConfigArgs']]):
        pulumi.set(self, "modification_protection_config", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_reason")

    @modification_protection_reason.setter
    def modification_protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modification_protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
        - `NonProtection`: Does not enable the configuration read-only mode. You cannot set the `modification_protection_reason`. If the `modification_protection_reason` is set, the value is cleared.
        - `ConsoleProtection`: Enables the configuration read-only mode. You can set the `modification_protection_reason`.
        """
        return pulumi.get(self, "modification_protection_status")

    @modification_protection_status.setter
    def modification_protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modification_protection_status", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the NLB instance is deployed.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the new resource group.
        You can log on to the [Resource Management console](https://resourcemanager.console.aliyun.com/resource-groups) to view resource group IDs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The security group to which the network-based SLB instance belongs.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        List of labels.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC where the NLB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]]:
        """
        Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        return pulumi.get(self, "zone_mappings")

    @zone_mappings.setter
    def zone_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerZoneMappingArgs']]]]):
        pulumi.set(self, "zone_mappings", value)


@pulumi.type_token("alicloud:nlb/loadBalancer:LoadBalancer")
class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 cross_zone_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_config: Optional[pulumi.Input[Union['LoadBalancerDeletionProtectionConfigArgs', 'LoadBalancerDeletionProtectionConfigArgsDict']]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_config: Optional[pulumi.Input[Union['LoadBalancerModificationProtectionConfigArgs', 'LoadBalancerModificationProtectionConfigArgsDict']]] = None,
                 modification_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerZoneMappingArgs', 'LoadBalancerZoneMappingArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Network Load Balancer (NLB) Load Balancer resource.

        For information about Network Load Balancer (NLB) Load Balancer and how to use it, see [What is Load Balancer](https://www.alibabacloud.com/help/en/server-load-balancer/latest/api-nlb-2022-04-30-createloadbalancer).

        > **NOTE:** Available since v1.191.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.nlb.get_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default1 = alicloud.vpc.Switch("default1",
            vswitch_name=name,
            cidr_block="10.4.1.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[1].id)
        default_load_balancer = alicloud.nlb.LoadBalancer("default",
            load_balancer_name=name,
            resource_group_id=default.ids[0],
            load_balancer_type="Network",
            address_type="Internet",
            address_ip_version="Ipv4",
            vpc_id=default_network.id,
            tags={
                "Created": "TF",
                "For": "example",
            },
            zone_mappings=[
                {
                    "vswitch_id": default_switch.id,
                    "zone_id": default_get_zones.zones[0].id,
                },
                {
                    "vswitch_id": default1.id,
                    "zone_id": default_get_zones.zones[1].id,
                },
            ])
        ```

        DualStack Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        zone = config.get_object("zone")
        if zone is None:
            zone = [
                "cn-beijing-i",
                "cn-beijing-k",
                "cn-beijing-l",
            ]
        vpc = alicloud.vpc.Network("vpc",
            vpc_name=name,
            cidr_block="10.2.0.0/16",
            enable_ipv6=True)
        vsw = []
        for range in [{"value": i} for i in range(0, 2)]:
            vsw.append(alicloud.vpc.Switch(f"vsw-{range['value']}",
                enable_ipv6=True,
                ipv6_cidr_block_mask=f"1{range['value']}",
                vswitch_name=f"vsw-{range['value']}-for-nlb",
                vpc_id=vpc.id,
                cidr_block=f"10.2.1{range['value']}.0/24",
                zone_id=zone[range["value"]]))
        default = alicloud.vpc.Ipv6Gateway("default",
            ipv6_gateway_name=name,
            vpc_id=vpc.id)
        nlb = alicloud.nlb.LoadBalancer("nlb",
            load_balancer_name=name,
            load_balancer_type="Network",
            address_type="Intranet",
            address_ip_version="DualStack",
            ipv6_address_type="Internet",
            vpc_id=vpc.id,
            cross_zone_enabled=False,
            tags={
                "Created": "TF",
                "For": "example",
            },
            zone_mappings=[
                {
                    "vswitch_id": vsw[0].id,
                    "zone_id": zone[0],
                },
                {
                    "vswitch_id": vsw[1].id,
                    "zone_id": zone[1],
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```

        ## Import

        Network Load Balancer (NLB) Load Balancer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nlb/loadBalancer:LoadBalancer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_ip_version: The protocol version. Valid values:
               
               - **ipv4:** IPv4. This is the default value.
               - **DualStack:** dual stack.
        :param pulumi.Input[_builtins.str] address_type: The type of IPv4 address used by the NLB instance. Valid values:
               - `Internet`: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - `Intranet`: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.
               
               > **NOTE:**   To enable a public IPv6 address for an NLB instance, call the [EnableLoadBalancerIpv6Internet](https://www.alibabacloud.com/help/en/doc-detail/445878.html) operation.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the EIP bandwidth plan that is associated with the Internet-facing NLB instance.
        :param pulumi.Input[_builtins.int] cps: The speed limit of new connections per second processed by NLB instances in each VIP. Value range: `0` to `1000000`.
               
               - *0** means no speed limit.
        :param pulumi.Input[_builtins.bool] cross_zone_enabled: Specifies whether to enable cross-zone load balancing for the NLB instance. Valid values:
        :param pulumi.Input[Union['LoadBalancerDeletionProtectionConfigArgs', 'LoadBalancerDeletionProtectionConfigArgsDict']] deletion_protection_config: Specifies whether to enable deletion protection. Default value: `false`. See `deletion_protection_config` below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] deletion_protection_reason: The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        :param pulumi.Input[_builtins.str] ipv6_address_type: The type of IPv6 address used by the NLB instance. Valid values:
               - `Internet`: a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - `Intranet`: a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the VPC where the NLB instance is deployed.
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the NLB instance.
               The value must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The value must start with a letter.
        :param pulumi.Input[_builtins.str] load_balancer_type: The type of the Server Load Balancer (SLB) instance. Set the value to `network`, which specifies NLB.
        :param pulumi.Input[Union['LoadBalancerModificationProtectionConfigArgs', 'LoadBalancerModificationProtectionConfigArgsDict']] modification_protection_config: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. See `modification_protection_config` below.
        :param pulumi.Input[_builtins.str] modification_protection_reason: The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        :param pulumi.Input[_builtins.str] modification_protection_status: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
               - `NonProtection`: Does not enable the configuration read-only mode. You cannot set the `modification_protection_reason`. If the `modification_protection_reason` is set, the value is cleared.
               - `ConsoleProtection`: Enables the configuration read-only mode. You can set the `modification_protection_reason`.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               You can log on to the [Resource Management console](https://resourcemanager.console.aliyun.com/resource-groups) to view resource group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The security group to which the network-based SLB instance belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: List of labels.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC where the NLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerZoneMappingArgs', 'LoadBalancerZoneMappingArgsDict']]]] zone_mappings: Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Network Load Balancer (NLB) Load Balancer resource.

        For information about Network Load Balancer (NLB) Load Balancer and how to use it, see [What is Load Balancer](https://www.alibabacloud.com/help/en/server-load-balancer/latest/api-nlb-2022-04-30-createloadbalancer).

        > **NOTE:** Available since v1.191.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.nlb.get_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default1 = alicloud.vpc.Switch("default1",
            vswitch_name=name,
            cidr_block="10.4.1.0/24",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[1].id)
        default_load_balancer = alicloud.nlb.LoadBalancer("default",
            load_balancer_name=name,
            resource_group_id=default.ids[0],
            load_balancer_type="Network",
            address_type="Internet",
            address_ip_version="Ipv4",
            vpc_id=default_network.id,
            tags={
                "Created": "TF",
                "For": "example",
            },
            zone_mappings=[
                {
                    "vswitch_id": default_switch.id,
                    "zone_id": default_get_zones.zones[0].id,
                },
                {
                    "vswitch_id": default1.id,
                    "zone_id": default_get_zones.zones[1].id,
                },
            ])
        ```

        DualStack Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        zone = config.get_object("zone")
        if zone is None:
            zone = [
                "cn-beijing-i",
                "cn-beijing-k",
                "cn-beijing-l",
            ]
        vpc = alicloud.vpc.Network("vpc",
            vpc_name=name,
            cidr_block="10.2.0.0/16",
            enable_ipv6=True)
        vsw = []
        for range in [{"value": i} for i in range(0, 2)]:
            vsw.append(alicloud.vpc.Switch(f"vsw-{range['value']}",
                enable_ipv6=True,
                ipv6_cidr_block_mask=f"1{range['value']}",
                vswitch_name=f"vsw-{range['value']}-for-nlb",
                vpc_id=vpc.id,
                cidr_block=f"10.2.1{range['value']}.0/24",
                zone_id=zone[range["value"]]))
        default = alicloud.vpc.Ipv6Gateway("default",
            ipv6_gateway_name=name,
            vpc_id=vpc.id)
        nlb = alicloud.nlb.LoadBalancer("nlb",
            load_balancer_name=name,
            load_balancer_type="Network",
            address_type="Intranet",
            address_ip_version="DualStack",
            ipv6_address_type="Internet",
            vpc_id=vpc.id,
            cross_zone_enabled=False,
            tags={
                "Created": "TF",
                "For": "example",
            },
            zone_mappings=[
                {
                    "vswitch_id": vsw[0].id,
                    "zone_id": zone[0],
                },
                {
                    "vswitch_id": vsw[1].id,
                    "zone_id": zone[1],
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[default]))
        ```

        ## Import

        Network Load Balancer (NLB) Load Balancer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nlb/loadBalancer:LoadBalancer example <id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cps: Optional[pulumi.Input[_builtins.int]] = None,
                 cross_zone_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_config: Optional[pulumi.Input[Union['LoadBalancerDeletionProtectionConfigArgs', 'LoadBalancerDeletionProtectionConfigArgsDict']]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_config: Optional[pulumi.Input[Union['LoadBalancerModificationProtectionConfigArgs', 'LoadBalancerModificationProtectionConfigArgsDict']]] = None,
                 modification_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerZoneMappingArgs', 'LoadBalancerZoneMappingArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["address_ip_version"] = address_ip_version
            if address_type is None and not opts.urn:
                raise TypeError("Missing required property 'address_type'")
            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["bandwidth_package_id"] = bandwidth_package_id
            __props__.__dict__["cps"] = cps
            __props__.__dict__["cross_zone_enabled"] = cross_zone_enabled
            __props__.__dict__["deletion_protection_config"] = deletion_protection_config
            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            __props__.__dict__["deletion_protection_reason"] = deletion_protection_reason
            __props__.__dict__["ipv6_address_type"] = ipv6_address_type
            __props__.__dict__["load_balancer_name"] = load_balancer_name
            __props__.__dict__["load_balancer_type"] = load_balancer_type
            __props__.__dict__["modification_protection_config"] = modification_protection_config
            __props__.__dict__["modification_protection_reason"] = modification_protection_reason
            __props__.__dict__["modification_protection_status"] = modification_protection_status
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if zone_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'zone_mappings'")
            __props__.__dict__["zone_mappings"] = zone_mappings
            __props__.__dict__["create_time"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["load_balancer_business_status"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(LoadBalancer, __self__).__init__(
            'alicloud:nlb/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            address_type: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth_package_id: Optional[pulumi.Input[_builtins.str]] = None,
            cps: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            cross_zone_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            deletion_protection_config: Optional[pulumi.Input[Union['LoadBalancerDeletionProtectionConfigArgs', 'LoadBalancerDeletionProtectionConfigArgsDict']]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            deletion_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
            dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_address_type: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_business_status: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
            modification_protection_config: Optional[pulumi.Input[Union['LoadBalancerModificationProtectionConfigArgs', 'LoadBalancerModificationProtectionConfigArgsDict']]] = None,
            modification_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
            modification_protection_status: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerZoneMappingArgs', 'LoadBalancerZoneMappingArgsDict']]]]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_ip_version: The protocol version. Valid values:
               
               - **ipv4:** IPv4. This is the default value.
               - **DualStack:** dual stack.
        :param pulumi.Input[_builtins.str] address_type: The type of IPv4 address used by the NLB instance. Valid values:
               - `Internet`: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - `Intranet`: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.
               
               > **NOTE:**   To enable a public IPv6 address for an NLB instance, call the [EnableLoadBalancerIpv6Internet](https://www.alibabacloud.com/help/en/doc-detail/445878.html) operation.
        :param pulumi.Input[_builtins.str] bandwidth_package_id: The ID of the EIP bandwidth plan that is associated with the Internet-facing NLB instance.
        :param pulumi.Input[_builtins.int] cps: The speed limit of new connections per second processed by NLB instances in each VIP. Value range: `0` to `1000000`.
               
               - *0** means no speed limit.
        :param pulumi.Input[_builtins.str] create_time: Resource creation time, using Greenwich Mean Time, formating' yyyy-MM-ddTHH:mm:ssZ '.
        :param pulumi.Input[_builtins.bool] cross_zone_enabled: Specifies whether to enable cross-zone load balancing for the NLB instance. Valid values:
        :param pulumi.Input[Union['LoadBalancerDeletionProtectionConfigArgs', 'LoadBalancerDeletionProtectionConfigArgsDict']] deletion_protection_config: Specifies whether to enable deletion protection. Default value: `false`. See `deletion_protection_config` below.
        :param pulumi.Input[_builtins.bool] deletion_protection_enabled: Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] deletion_protection_reason: The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        :param pulumi.Input[_builtins.str] dns_name: The domain name of the NLB instance.
        :param pulumi.Input[_builtins.str] ipv6_address_type: The type of IPv6 address used by the NLB instance. Valid values:
               - `Internet`: a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
               - `Intranet`: a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the VPC where the NLB instance is deployed.
        :param pulumi.Input[_builtins.str] load_balancer_business_status: The business status of the NLB instance.
        :param pulumi.Input[_builtins.str] load_balancer_name: The name of the NLB instance.
               The value must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The value must start with a letter.
        :param pulumi.Input[_builtins.str] load_balancer_type: The type of the Server Load Balancer (SLB) instance. Set the value to `network`, which specifies NLB.
        :param pulumi.Input[Union['LoadBalancerModificationProtectionConfigArgs', 'LoadBalancerModificationProtectionConfigArgsDict']] modification_protection_config: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. See `modification_protection_config` below.
        :param pulumi.Input[_builtins.str] modification_protection_reason: The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        :param pulumi.Input[_builtins.str] modification_protection_status: Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
               - `NonProtection`: Does not enable the configuration read-only mode. You cannot set the `modification_protection_reason`. If the `modification_protection_reason` is set, the value is cleared.
               - `ConsoleProtection`: Enables the configuration read-only mode. You can set the `modification_protection_reason`.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.str] region_id: The ID of the region where the NLB instance is deployed.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the new resource group.
               You can log on to the [Resource Management console](https://resourcemanager.console.aliyun.com/resource-groups) to view resource group IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The security group to which the network-based SLB instance belongs.
        :param pulumi.Input[_builtins.str] status: Zone Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: List of labels.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC where the NLB instance is deployed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerZoneMappingArgs', 'LoadBalancerZoneMappingArgsDict']]]] zone_mappings: Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["address_ip_version"] = address_ip_version
        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["bandwidth_package_id"] = bandwidth_package_id
        __props__.__dict__["cps"] = cps
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cross_zone_enabled"] = cross_zone_enabled
        __props__.__dict__["deletion_protection_config"] = deletion_protection_config
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["deletion_protection_reason"] = deletion_protection_reason
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["ipv6_address_type"] = ipv6_address_type
        __props__.__dict__["load_balancer_business_status"] = load_balancer_business_status
        __props__.__dict__["load_balancer_name"] = load_balancer_name
        __props__.__dict__["load_balancer_type"] = load_balancer_type
        __props__.__dict__["modification_protection_config"] = modification_protection_config
        __props__.__dict__["modification_protection_reason"] = modification_protection_reason
        __props__.__dict__["modification_protection_status"] = modification_protection_status
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone_mappings"] = zone_mappings
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol version. Valid values:

        - **ipv4:** IPv4. This is the default value.
        - **DualStack:** dual stack.
        """
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of IPv4 address used by the NLB instance. Valid values:
        - `Internet`: The NLB instance uses a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
        - `Intranet`: The NLB instance uses a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the virtual private cloud (VPC) where the NLB instance is deployed.

        > **NOTE:**   To enable a public IPv6 address for an NLB instance, call the [EnableLoadBalancerIpv6Internet](https://www.alibabacloud.com/help/en/doc-detail/445878.html) operation.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the EIP bandwidth plan that is associated with the Internet-facing NLB instance.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @_builtins.property
    @pulumi.getter
    def cps(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The speed limit of new connections per second processed by NLB instances in each VIP. Value range: `0` to `1000000`.

        - *0** means no speed limit.
        """
        return pulumi.get(self, "cps")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Resource creation time, using Greenwich Mean Time, formating' yyyy-MM-ddTHH:mm:ssZ '.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossZoneEnabled")
    def cross_zone_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable cross-zone load balancing for the NLB instance. Valid values:
        """
        return pulumi.get(self, "cross_zone_enabled")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionConfig")
    def deletion_protection_config(self) -> pulumi.Output['outputs.LoadBalancerDeletionProtectionConfig']:
        """
        Specifies whether to enable deletion protection. Default value: `false`. See `deletion_protection_config` below.
        """
        return pulumi.get(self, "deletion_protection_config")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable deletion protection. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="deletionProtectionReason")
    def deletion_protection_reason(self) -> pulumi.Output[_builtins.str]:
        """
        The reason why the deletion protection feature is enabled or disabled. The `deletion_protection_reason` takes effect only when `deletion_protection_enabled` is set to `true`.
        """
        return pulumi.get(self, "deletion_protection_reason")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name of the NLB instance.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressType")
    def ipv6_address_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of IPv6 address used by the NLB instance. Valid values:
        - `Internet`: a public IP address. The domain name of the NLB instance is resolved to the public IP address. Therefore, the NLB instance can be accessed over the Internet.
        - `Intranet`: a private IP address. The domain name of the NLB instance is resolved to the private IP address. Therefore, the NLB instance can be accessed over the VPC where the NLB instance is deployed.
        """
        return pulumi.get(self, "ipv6_address_type")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBusinessStatus")
    def load_balancer_business_status(self) -> pulumi.Output[_builtins.str]:
        """
        The business status of the NLB instance.
        """
        return pulumi.get(self, "load_balancer_business_status")

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the NLB instance.
        The value must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\\_), and hyphens (-). The value must start with a letter.
        """
        return pulumi.get(self, "load_balancer_name")

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Server Load Balancer (SLB) instance. Set the value to `network`, which specifies NLB.
        """
        return pulumi.get(self, "load_balancer_type")

    @_builtins.property
    @pulumi.getter(name="modificationProtectionConfig")
    def modification_protection_config(self) -> pulumi.Output['outputs.LoadBalancerModificationProtectionConfig']:
        """
        Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. See `modification_protection_config` below.
        """
        return pulumi.get(self, "modification_protection_config")

    @_builtins.property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> pulumi.Output[_builtins.str]:
        """
        The reason why the configuration read-only mode is enabled. The `modification_protection_reason` takes effect only when `modification_protection_status` is set to `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_reason")

    @_builtins.property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to enable the configuration read-only mode. Default value: `NonProtection`. Valid values:
        - `NonProtection`: Does not enable the configuration read-only mode. You cannot set the `modification_protection_reason`. If the `modification_protection_reason` is set, the value is cleared.
        - `ConsoleProtection`: Enables the configuration read-only mode. You can set the `modification_protection_reason`.
        """
        return pulumi.get(self, "modification_protection_status")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where the NLB instance is deployed.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the new resource group.
        You can log on to the [Resource Management console](https://resourcemanager.console.aliyun.com/resource-groups) to view resource group IDs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The security group to which the network-based SLB instance belongs.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Zone Status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        List of labels.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC where the NLB instance is deployed.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> pulumi.Output[Sequence['outputs.LoadBalancerZoneMapping']]:
        """
        Available Area Configuration List. You must add at least two zones. You can add a maximum of 10 zones. See `zone_mappings` below.
        """
        return pulumi.get(self, "zone_mappings")

