# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessPointArgs', 'AccessPoint']

@pulumi.input_type
class AccessPointArgs:
    def __init__(__self__, *,
                 access_point_name: pulumi.Input[_builtins.str],
                 bucket: pulumi.Input[_builtins.str],
                 network_origin: pulumi.Input[_builtins.str],
                 public_access_block_configuration: Optional[pulumi.Input['AccessPointPublicAccessBlockConfigurationArgs']] = None,
                 vpc_configuration: Optional[pulumi.Input['AccessPointVpcConfigurationArgs']] = None):
        """
        The set of arguments for constructing a AccessPoint resource.
        :param pulumi.Input[_builtins.str] access_point_name: The name of the access point
        :param pulumi.Input[_builtins.str] bucket: The Bucket to which the current access point belongs.
        :param pulumi.Input[_builtins.str] network_origin: Access point network source. The valid values are as follows: 
               - vpc: only the specified VPC ID can be used to access the access point.
               - internet: the access point can be accessed through both external and internal Endpoint.
        :param pulumi.Input['AccessPointPublicAccessBlockConfigurationArgs'] public_access_block_configuration: Configuration of Access Point Blocking Public Access See `public_access_block_configuration` below.
        :param pulumi.Input['AccessPointVpcConfigurationArgs'] vpc_configuration: If the Network Origin is vpc, the VPC source information is saved here. See `vpc_configuration` below.
        """
        pulumi.set(__self__, "access_point_name", access_point_name)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "network_origin", network_origin)
        if public_access_block_configuration is not None:
            pulumi.set(__self__, "public_access_block_configuration", public_access_block_configuration)
        if vpc_configuration is not None:
            pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @_builtins.property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the access point
        """
        return pulumi.get(self, "access_point_name")

    @access_point_name.setter
    def access_point_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_point_name", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The Bucket to which the current access point belongs.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="networkOrigin")
    def network_origin(self) -> pulumi.Input[_builtins.str]:
        """
        Access point network source. The valid values are as follows: 
        - vpc: only the specified VPC ID can be used to access the access point.
        - internet: the access point can be accessed through both external and internal Endpoint.
        """
        return pulumi.get(self, "network_origin")

    @network_origin.setter
    def network_origin(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_origin", value)

    @_builtins.property
    @pulumi.getter(name="publicAccessBlockConfiguration")
    def public_access_block_configuration(self) -> Optional[pulumi.Input['AccessPointPublicAccessBlockConfigurationArgs']]:
        """
        Configuration of Access Point Blocking Public Access See `public_access_block_configuration` below.
        """
        return pulumi.get(self, "public_access_block_configuration")

    @public_access_block_configuration.setter
    def public_access_block_configuration(self, value: Optional[pulumi.Input['AccessPointPublicAccessBlockConfigurationArgs']]):
        pulumi.set(self, "public_access_block_configuration", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> Optional[pulumi.Input['AccessPointVpcConfigurationArgs']]:
        """
        If the Network Origin is vpc, the VPC source information is saved here. See `vpc_configuration` below.
        """
        return pulumi.get(self, "vpc_configuration")

    @vpc_configuration.setter
    def vpc_configuration(self, value: Optional[pulumi.Input['AccessPointVpcConfigurationArgs']]):
        pulumi.set(self, "vpc_configuration", value)


@pulumi.input_type
class _AccessPointState:
    def __init__(__self__, *,
                 access_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 network_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 public_access_block_configuration: Optional[pulumi.Input['AccessPointPublicAccessBlockConfigurationArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_configuration: Optional[pulumi.Input['AccessPointVpcConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering AccessPoint resources.
        :param pulumi.Input[_builtins.str] access_point_name: The name of the access point
        :param pulumi.Input[_builtins.str] bucket: The Bucket to which the current access point belongs.
        :param pulumi.Input[_builtins.str] network_origin: Access point network source. The valid values are as follows: 
               - vpc: only the specified VPC ID can be used to access the access point.
               - internet: the access point can be accessed through both external and internal Endpoint.
        :param pulumi.Input['AccessPointPublicAccessBlockConfigurationArgs'] public_access_block_configuration: Configuration of Access Point Blocking Public Access See `public_access_block_configuration` below.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input['AccessPointVpcConfigurationArgs'] vpc_configuration: If the Network Origin is vpc, the VPC source information is saved here. See `vpc_configuration` below.
        """
        if access_point_name is not None:
            pulumi.set(__self__, "access_point_name", access_point_name)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if network_origin is not None:
            pulumi.set(__self__, "network_origin", network_origin)
        if public_access_block_configuration is not None:
            pulumi.set(__self__, "public_access_block_configuration", public_access_block_configuration)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_configuration is not None:
            pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @_builtins.property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the access point
        """
        return pulumi.get(self, "access_point_name")

    @access_point_name.setter
    def access_point_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_point_name", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Bucket to which the current access point belongs.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="networkOrigin")
    def network_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access point network source. The valid values are as follows: 
        - vpc: only the specified VPC ID can be used to access the access point.
        - internet: the access point can be accessed through both external and internal Endpoint.
        """
        return pulumi.get(self, "network_origin")

    @network_origin.setter
    def network_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_origin", value)

    @_builtins.property
    @pulumi.getter(name="publicAccessBlockConfiguration")
    def public_access_block_configuration(self) -> Optional[pulumi.Input['AccessPointPublicAccessBlockConfigurationArgs']]:
        """
        Configuration of Access Point Blocking Public Access See `public_access_block_configuration` below.
        """
        return pulumi.get(self, "public_access_block_configuration")

    @public_access_block_configuration.setter
    def public_access_block_configuration(self, value: Optional[pulumi.Input['AccessPointPublicAccessBlockConfigurationArgs']]):
        pulumi.set(self, "public_access_block_configuration", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> Optional[pulumi.Input['AccessPointVpcConfigurationArgs']]:
        """
        If the Network Origin is vpc, the VPC source information is saved here. See `vpc_configuration` below.
        """
        return pulumi.get(self, "vpc_configuration")

    @vpc_configuration.setter
    def vpc_configuration(self, value: Optional[pulumi.Input['AccessPointVpcConfigurationArgs']]):
        pulumi.set(self, "vpc_configuration", value)


@pulumi.type_token("alicloud:oss/accessPoint:AccessPoint")
class AccessPoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 network_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 public_access_block_configuration: Optional[pulumi.Input[Union['AccessPointPublicAccessBlockConfigurationArgs', 'AccessPointPublicAccessBlockConfigurationArgsDict']]] = None,
                 vpc_configuration: Optional[pulumi.Input[Union['AccessPointVpcConfigurationArgs', 'AccessPointVpcConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Provides a OSS Access Point resource.

        You can create multiple Access points for buckets and configure different Access control permissions and network control policies for different Access points.

        For information about OSS Access Point and how to use it, see [What is Access Point](https://www.alibabacloud.com/help/en/oss/developer-reference/createaccesspoint).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        create_bucket = alicloud.oss.Bucket("CreateBucket", storage_class="Standard")
        default = alicloud.oss.AccessPoint("default",
            access_point_name=name,
            bucket=create_bucket.bucket,
            vpc_configuration={
                "vpc_id": "vpc-abcexample",
            },
            network_origin="vpc",
            public_access_block_configuration={
                "block_public_access": True,
            })
        ```

        ## Import

        OSS Access Point can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/accessPoint:AccessPoint example <bucket>:<access_point_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_point_name: The name of the access point
        :param pulumi.Input[_builtins.str] bucket: The Bucket to which the current access point belongs.
        :param pulumi.Input[_builtins.str] network_origin: Access point network source. The valid values are as follows: 
               - vpc: only the specified VPC ID can be used to access the access point.
               - internet: the access point can be accessed through both external and internal Endpoint.
        :param pulumi.Input[Union['AccessPointPublicAccessBlockConfigurationArgs', 'AccessPointPublicAccessBlockConfigurationArgsDict']] public_access_block_configuration: Configuration of Access Point Blocking Public Access See `public_access_block_configuration` below.
        :param pulumi.Input[Union['AccessPointVpcConfigurationArgs', 'AccessPointVpcConfigurationArgsDict']] vpc_configuration: If the Network Origin is vpc, the VPC source information is saved here. See `vpc_configuration` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessPointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a OSS Access Point resource.

        You can create multiple Access points for buckets and configure different Access control permissions and network control policies for different Access points.

        For information about OSS Access Point and how to use it, see [What is Access Point](https://www.alibabacloud.com/help/en/oss/developer-reference/createaccesspoint).

        > **NOTE:** Available since v1.240.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        create_bucket = alicloud.oss.Bucket("CreateBucket", storage_class="Standard")
        default = alicloud.oss.AccessPoint("default",
            access_point_name=name,
            bucket=create_bucket.bucket,
            vpc_configuration={
                "vpc_id": "vpc-abcexample",
            },
            network_origin="vpc",
            public_access_block_configuration={
                "block_public_access": True,
            })
        ```

        ## Import

        OSS Access Point can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oss/accessPoint:AccessPoint example <bucket>:<access_point_name>
        ```

        :param str resource_name: The name of the resource.
        :param AccessPointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessPointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 network_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 public_access_block_configuration: Optional[pulumi.Input[Union['AccessPointPublicAccessBlockConfigurationArgs', 'AccessPointPublicAccessBlockConfigurationArgsDict']]] = None,
                 vpc_configuration: Optional[pulumi.Input[Union['AccessPointVpcConfigurationArgs', 'AccessPointVpcConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessPointArgs.__new__(AccessPointArgs)

            if access_point_name is None and not opts.urn:
                raise TypeError("Missing required property 'access_point_name'")
            __props__.__dict__["access_point_name"] = access_point_name
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if network_origin is None and not opts.urn:
                raise TypeError("Missing required property 'network_origin'")
            __props__.__dict__["network_origin"] = network_origin
            __props__.__dict__["public_access_block_configuration"] = public_access_block_configuration
            __props__.__dict__["vpc_configuration"] = vpc_configuration
            __props__.__dict__["status"] = None
        super(AccessPoint, __self__).__init__(
            'alicloud:oss/accessPoint:AccessPoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_point_name: Optional[pulumi.Input[_builtins.str]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            network_origin: Optional[pulumi.Input[_builtins.str]] = None,
            public_access_block_configuration: Optional[pulumi.Input[Union['AccessPointPublicAccessBlockConfigurationArgs', 'AccessPointPublicAccessBlockConfigurationArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_configuration: Optional[pulumi.Input[Union['AccessPointVpcConfigurationArgs', 'AccessPointVpcConfigurationArgsDict']]] = None) -> 'AccessPoint':
        """
        Get an existing AccessPoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_point_name: The name of the access point
        :param pulumi.Input[_builtins.str] bucket: The Bucket to which the current access point belongs.
        :param pulumi.Input[_builtins.str] network_origin: Access point network source. The valid values are as follows: 
               - vpc: only the specified VPC ID can be used to access the access point.
               - internet: the access point can be accessed through both external and internal Endpoint.
        :param pulumi.Input[Union['AccessPointPublicAccessBlockConfigurationArgs', 'AccessPointPublicAccessBlockConfigurationArgsDict']] public_access_block_configuration: Configuration of Access Point Blocking Public Access See `public_access_block_configuration` below.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Union['AccessPointVpcConfigurationArgs', 'AccessPointVpcConfigurationArgsDict']] vpc_configuration: If the Network Origin is vpc, the VPC source information is saved here. See `vpc_configuration` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessPointState.__new__(_AccessPointState)

        __props__.__dict__["access_point_name"] = access_point_name
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["network_origin"] = network_origin
        __props__.__dict__["public_access_block_configuration"] = public_access_block_configuration
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_configuration"] = vpc_configuration
        return AccessPoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the access point
        """
        return pulumi.get(self, "access_point_name")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The Bucket to which the current access point belongs.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="networkOrigin")
    def network_origin(self) -> pulumi.Output[_builtins.str]:
        """
        Access point network source. The valid values are as follows: 
        - vpc: only the specified VPC ID can be used to access the access point.
        - internet: the access point can be accessed through both external and internal Endpoint.
        """
        return pulumi.get(self, "network_origin")

    @_builtins.property
    @pulumi.getter(name="publicAccessBlockConfiguration")
    def public_access_block_configuration(self) -> pulumi.Output[Optional['outputs.AccessPointPublicAccessBlockConfiguration']]:
        """
        Configuration of Access Point Blocking Public Access See `public_access_block_configuration` below.
        """
        return pulumi.get(self, "public_access_block_configuration")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> pulumi.Output[Optional['outputs.AccessPointVpcConfiguration']]:
        """
        If the Network Origin is vpc, the VPC source information is saved here. See `vpc_configuration` below.
        """
        return pulumi.get(self, "vpc_configuration")

