# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccessPointPublicAccessBlockConfiguration',
    'AccessPointVpcConfiguration',
    'BucketAccessMonitor',
    'BucketCnameCertificate',
    'BucketCorsCorsRule',
    'BucketCorsRule',
    'BucketLifecycleRule',
    'BucketLifecycleRuleAbortMultipartUpload',
    'BucketLifecycleRuleExpiration',
    'BucketLifecycleRuleFilter',
    'BucketLifecycleRuleFilterNot',
    'BucketLifecycleRuleFilterNotTag',
    'BucketLifecycleRuleNoncurrentVersionExpiration',
    'BucketLifecycleRuleNoncurrentVersionTransition',
    'BucketLifecycleRuleTransition',
    'BucketLogging',
    'BucketRefererConfig',
    'BucketReplicationDestination',
    'BucketReplicationEncryptionConfiguration',
    'BucketReplicationPrefixSet',
    'BucketReplicationProgress',
    'BucketReplicationRtc',
    'BucketReplicationSourceSelectionCriteria',
    'BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjects',
    'BucketServerSideEncryptionRule',
    'BucketTransferAcceleration',
    'BucketVersioning',
    'BucketWebsite',
    'BucketWebsiteErrorDocument',
    'BucketWebsiteIndexDocument',
    'BucketWebsiteRoutingRules',
    'BucketWebsiteRoutingRulesRoutingRule',
    'BucketWebsiteRoutingRulesRoutingRuleCondition',
    'BucketWebsiteRoutingRulesRoutingRuleConditionIncludeHeader',
    'BucketWebsiteRoutingRulesRoutingRuleLuaConfig',
    'BucketWebsiteRoutingRulesRoutingRuleRedirect',
    'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorAuth',
    'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeaders',
    'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeadersSet',
    'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternates',
    'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternatesMirrorMultiAlternate',
    'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeaders',
    'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeadersReturnHeader',
    'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorTaggings',
    'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorTaggingsTagging',
    'GetBucketObjectsObjectResult',
    'GetBucketsBucketResult',
    'GetBucketsBucketCorsRuleResult',
    'GetBucketsBucketLifecycleRuleResult',
    'GetBucketsBucketLifecycleRuleExpirationResult',
    'GetBucketsBucketLoggingResult',
    'GetBucketsBucketRefererConfigResult',
    'GetBucketsBucketServerSideEncryptionRuleResult',
    'GetBucketsBucketVersioningResult',
    'GetBucketsBucketWebsiteResult',
    'GetInstanceAttachmentsAttachmentResult',
    'GetInstancesInstanceResult',
    'GetTablesTableResult',
    'GetTablesTableDefinedColumnResult',
    'GetTablesTablePrimaryKeyResult',
]

@pulumi.output_type
class AccessPointPublicAccessBlockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockPublicAccess":
            suggest = "block_public_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointPublicAccessBlockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_public_access: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool block_public_access: Block public access enabled for access point
        """
        if block_public_access is not None:
            pulumi.set(__self__, "block_public_access", block_public_access)

    @_builtins.property
    @pulumi.getter(name="blockPublicAccess")
    def block_public_access(self) -> Optional[_builtins.bool]:
        """
        Block public access enabled for access point
        """
        return pulumi.get(self, "block_public_access")


@pulumi.output_type
class AccessPointVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str vpc_id: The vpc ID is required only when the value of NetworkOrigin is VPC.
        """
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The vpc ID is required only when the value of NetworkOrigin is VPC.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class BucketAccessMonitor(dict):
    def __init__(__self__, *,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str status: The access monitor state of a bucket. If you want to manage objects based on the last access time of the objects, specifies the status to `Enabled`. Valid values: `Enabled` and `Disabled`.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The access monitor state of a bucket. If you want to manage objects based on the last access time of the objects, specifies the status to `Enabled`. Valid values: `Enabled` and `Disabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketCnameCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certId":
            suggest = "cert_id"
        elif key == "creationDate":
            suggest = "creation_date"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "validEndDate":
            suggest = "valid_end_date"
        elif key == "validStartDate":
            suggest = "valid_start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCnameCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCnameCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCnameCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_id: Optional[_builtins.str] = None,
                 certificate: Optional[_builtins.str] = None,
                 creation_date: Optional[_builtins.str] = None,
                 fingerprint: Optional[_builtins.str] = None,
                 private_key: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 valid_end_date: Optional[_builtins.str] = None,
                 valid_start_date: Optional[_builtins.str] = None):
        """
        :param _builtins.str cert_id: Certificate Identifier
        :param _builtins.str certificate: The certificate public key.
        :param _builtins.str creation_date: Certificate creation time
        :param _builtins.str fingerprint: Certificate Fingerprint
        :param _builtins.str private_key: The certificate private key.
        :param _builtins.str status: Cname status
        :param _builtins.str type: Certificate Type
        :param _builtins.str valid_end_date: Certificate validity period end time
        :param _builtins.str valid_start_date: Certificate validity period start time
        """
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if valid_end_date is not None:
            pulumi.set(__self__, "valid_end_date", valid_end_date)
        if valid_start_date is not None:
            pulumi.set(__self__, "valid_start_date", valid_start_date)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[_builtins.str]:
        """
        Certificate Identifier
        """
        return pulumi.get(self, "cert_id")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[_builtins.str]:
        """
        The certificate public key.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[_builtins.str]:
        """
        Certificate creation time
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[_builtins.str]:
        """
        Certificate Fingerprint
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[_builtins.str]:
        """
        The certificate private key.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Cname status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Certificate Type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="validEndDate")
    def valid_end_date(self) -> Optional[_builtins.str]:
        """
        Certificate validity period end time
        """
        return pulumi.get(self, "valid_end_date")

    @_builtins.property
    @pulumi.getter(name="validStartDate")
    def valid_start_date(self) -> Optional[_builtins.str]:
        """
        Certificate validity period start time
        """
        return pulumi.get(self, "valid_start_date")


@pulumi.output_type
class BucketCorsCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[_builtins.str],
                 allowed_headers: Optional[Sequence[_builtins.str]] = None,
                 allowed_origins: Optional[Sequence[_builtins.str]] = None,
                 expose_headers: Optional[Sequence[_builtins.str]] = None,
                 max_age_seconds: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] allowed_methods: The cross-origin request method that is allowed. Valid values: GET, PUT, DELETE, POST, and HEAD.
        :param Sequence[_builtins.str] allowed_headers: Specifies whether the headers specified by Access-Control-Request-Headers in the OPTIONS preflight request are allowed. You can use only one asterisk (*) as the wildcard for allowed header. .
        :param Sequence[_builtins.str] allowed_origins: The origins from which cross-origin requests are allowed. .
        :param Sequence[_builtins.str] expose_headers: The response headers for allowed access requests from applications, such as an XMLHttpRequest object in JavaScript. .
        :param _builtins.int max_age_seconds: The period of time within which the browser can cache the response to an OPTIONS preflight request for the specified resource. Unit: seconds.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        The cross-origin request method that is allowed. Valid values: GET, PUT, DELETE, POST, and HEAD.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies whether the headers specified by Access-Control-Request-Headers in the OPTIONS preflight request are allowed. You can use only one asterisk (*) as the wildcard for allowed header. .
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[Sequence[_builtins.str]]:
        """
        The origins from which cross-origin requests are allowed. .
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        The response headers for allowed access requests from applications, such as an XMLHttpRequest object in JavaScript. .
        """
        return pulumi.get(self, "expose_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[_builtins.int]:
        """
        The period of time within which the browser can cache the response to an OPTIONS preflight request for the specified resource. Unit: seconds.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class BucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 allowed_headers: Optional[Sequence[_builtins.str]] = None,
                 expose_headers: Optional[Sequence[_builtins.str]] = None,
                 max_age_seconds: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] allowed_methods: Specifies which methods are allowed. Can be GET, PUT, POST, DELETE or HEAD.
        :param Sequence[_builtins.str] allowed_origins: Specifies which origins are allowed.
        :param Sequence[_builtins.str] allowed_headers: Specifies which headers are allowed.
        :param Sequence[_builtins.str] expose_headers: Specifies expose header in the response.
        :param _builtins.int max_age_seconds: Specifies time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        Specifies which methods are allowed. Can be GET, PUT, POST, DELETE or HEAD.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        Specifies which origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies which headers are allowed.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies expose header in the response.
        """
        return pulumi.get(self, "expose_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class BucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortMultipartUploads":
            suggest = "abort_multipart_uploads"
        elif key == "noncurrentVersionExpirations":
            suggest = "noncurrent_version_expirations"
        elif key == "noncurrentVersionTransitions":
            suggest = "noncurrent_version_transitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 abort_multipart_uploads: Optional[Sequence['outputs.BucketLifecycleRuleAbortMultipartUpload']] = None,
                 expirations: Optional[Sequence['outputs.BucketLifecycleRuleExpiration']] = None,
                 filter: Optional['outputs.BucketLifecycleRuleFilter'] = None,
                 id: Optional[_builtins.str] = None,
                 noncurrent_version_expirations: Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionExpiration']] = None,
                 noncurrent_version_transitions: Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']] = None,
                 prefix: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 transitions: Optional[Sequence['outputs.BucketLifecycleRuleTransition']] = None):
        """
        :param _builtins.bool enabled: Specifies lifecycle rule status.
        :param Sequence['BucketLifecycleRuleAbortMultipartUploadArgs'] abort_multipart_uploads: Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
        :param Sequence['BucketLifecycleRuleExpirationArgs'] expirations: Specifies a period in the object's expire. See `expiration` below.
        :param 'BucketLifecycleRuleFilterArgs' filter: Configuration block used to identify objects that a Lifecycle rule applies to. See `filter` below.
               
               `NOTE`: At least one of expiration, transitions, abort_multipart_upload, noncurrent_version_expiration and noncurrent_version_transition should be configured.
        :param _builtins.str id: Unique identifier for the rule. If omitted, OSS bucket will assign a unique name.
        :param Sequence['BucketLifecycleRuleNoncurrentVersionExpirationArgs'] noncurrent_version_expirations: Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
        :param Sequence['BucketLifecycleRuleNoncurrentVersionTransitionArgs'] noncurrent_version_transitions: Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
        :param _builtins.str prefix: The prefix in the names of the objects to which the lifecycle rule does not apply.
        :param Mapping[str, _builtins.str] tags: Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
        :param Sequence['BucketLifecycleRuleTransitionArgs'] transitions: Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_multipart_uploads is not None:
            pulumi.set(__self__, "abort_multipart_uploads", abort_multipart_uploads)
        if expirations is not None:
            pulumi.set(__self__, "expirations", expirations)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expirations is not None:
            pulumi.set(__self__, "noncurrent_version_expirations", noncurrent_version_expirations)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="abortMultipartUploads")
    def abort_multipart_uploads(self) -> Optional[Sequence['outputs.BucketLifecycleRuleAbortMultipartUpload']]:
        """
        Specifies the number of days after initiating a multipart upload when the multipart upload must be completed. See `abort_multipart_upload` below.
        """
        return pulumi.get(self, "abort_multipart_uploads")

    @_builtins.property
    @pulumi.getter
    def expirations(self) -> Optional[Sequence['outputs.BucketLifecycleRuleExpiration']]:
        """
        Specifies a period in the object's expire. See `expiration` below.
        """
        return pulumi.get(self, "expirations")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BucketLifecycleRuleFilter']:
        """
        Configuration block used to identify objects that a Lifecycle rule applies to. See `filter` below.

        `NOTE`: At least one of expiration, transitions, abort_multipart_upload, noncurrent_version_expiration and noncurrent_version_transition should be configured.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique identifier for the rule. If omitted, OSS bucket will assign a unique name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="noncurrentVersionExpirations")
    def noncurrent_version_expirations(self) -> Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionExpiration']]:
        """
        Specifies when noncurrent object versions expire. See `noncurrent_version_expiration` below.
        """
        return pulumi.get(self, "noncurrent_version_expirations")

    @_builtins.property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']]:
        """
        Specifies when noncurrent object versions transitions. See `noncurrent_version_transition` below.
        """
        return pulumi.get(self, "noncurrent_version_transitions")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        The prefix in the names of the objects to which the lifecycle rule does not apply.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleTransition']]:
        """
        Specifies the time when an object is converted to the IA or archive storage class during a valid life cycle. See `transitions` below.
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class BucketLifecycleRuleAbortMultipartUpload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdBeforeDate":
            suggest = "created_before_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleAbortMultipartUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleAbortMultipartUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleAbortMultipartUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_before_date: Optional[_builtins.str] = None,
                 days: Optional[_builtins.int] = None):
        """
        :param _builtins.str created_before_date: Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        :param _builtins.int days: Specifies the number of days noncurrent object versions transition.
        """
        if created_before_date is not None:
            pulumi.set(__self__, "created_before_date", created_before_date)
        if days is not None:
            pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter(name="createdBeforeDate")
    def created_before_date(self) -> Optional[_builtins.str]:
        """
        Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        """
        return pulumi.get(self, "created_before_date")

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdBeforeDate":
            suggest = "created_before_date"
        elif key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_before_date: Optional[_builtins.str] = None,
                 date: Optional[_builtins.str] = None,
                 days: Optional[_builtins.int] = None,
                 expired_object_delete_marker: Optional[_builtins.bool] = None):
        """
        :param _builtins.str created_before_date: Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        :param _builtins.str date: Specifies the date after which you want the corresponding action to take effect. The value obeys ISO8601 format like `2017-03-09`.
        :param _builtins.int days: Specifies the number of days noncurrent object versions transition.
        :param _builtins.bool expired_object_delete_marker: On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct OSS to delete expired object delete markers. This cannot be specified with Days, Date or CreatedBeforeDate in a Lifecycle Expiration Policy.
               
               `NOTE`: One and only one of "date", "days", "created_before_date" and "expired_object_delete_marker" can be specified in one expiration configuration.
        """
        if created_before_date is not None:
            pulumi.set(__self__, "created_before_date", created_before_date)
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @_builtins.property
    @pulumi.getter(name="createdBeforeDate")
    def created_before_date(self) -> Optional[_builtins.str]:
        """
        Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        """
        return pulumi.get(self, "created_before_date")

    @_builtins.property
    @pulumi.getter
    def date(self) -> Optional[_builtins.str]:
        """
        Specifies the date after which you want the corresponding action to take effect. The value obeys ISO8601 format like `2017-03-09`.
        """
        return pulumi.get(self, "date")

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[_builtins.bool]:
        """
        On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct OSS to delete expired object delete markers. This cannot be specified with Days, Date or CreatedBeforeDate in a Lifecycle Expiration Policy.

        `NOTE`: One and only one of "date", "days", "created_before_date" and "expired_object_delete_marker" can be specified in one expiration configuration.
        """
        return pulumi.get(self, "expired_object_delete_marker")


@pulumi.output_type
class BucketLifecycleRuleFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "not":
            suggest = "not_"
        elif key == "objectSizeGreaterThan":
            suggest = "object_size_greater_than"
        elif key == "objectSizeLessThan":
            suggest = "object_size_less_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 not_: Optional['outputs.BucketLifecycleRuleFilterNot'] = None,
                 object_size_greater_than: Optional[_builtins.int] = None,
                 object_size_less_than: Optional[_builtins.int] = None):
        """
        :param 'BucketLifecycleRuleFilterNotArgs' not_: The condition that is matched by objects to which the lifecycle rule does not apply. See `not` below.
        :param _builtins.int object_size_greater_than: Minimum object size (in bytes) to which the rule applies.
        :param _builtins.int object_size_less_than: Maximum object size (in bytes) to which the rule applies.
        """
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if object_size_greater_than is not None:
            pulumi.set(__self__, "object_size_greater_than", object_size_greater_than)
        if object_size_less_than is not None:
            pulumi.set(__self__, "object_size_less_than", object_size_less_than)

    @_builtins.property
    @pulumi.getter(name="not")
    def not_(self) -> Optional['outputs.BucketLifecycleRuleFilterNot']:
        """
        The condition that is matched by objects to which the lifecycle rule does not apply. See `not` below.
        """
        return pulumi.get(self, "not_")

    @_builtins.property
    @pulumi.getter(name="objectSizeGreaterThan")
    def object_size_greater_than(self) -> Optional[_builtins.int]:
        """
        Minimum object size (in bytes) to which the rule applies.
        """
        return pulumi.get(self, "object_size_greater_than")

    @_builtins.property
    @pulumi.getter(name="objectSizeLessThan")
    def object_size_less_than(self) -> Optional[_builtins.int]:
        """
        Maximum object size (in bytes) to which the rule applies.
        """
        return pulumi.get(self, "object_size_less_than")


@pulumi.output_type
class BucketLifecycleRuleFilterNot(dict):
    def __init__(__self__, *,
                 prefix: Optional[_builtins.str] = None,
                 tag: Optional['outputs.BucketLifecycleRuleFilterNotTag'] = None):
        """
        :param _builtins.str prefix: The prefix in the names of the objects to which the lifecycle rule does not apply.
        :param 'BucketLifecycleRuleFilterNotTagArgs' tag: The tag of the objects to which the lifecycle rule does not apply. See `tag` below.
        """
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        The prefix in the names of the objects to which the lifecycle rule does not apply.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional['outputs.BucketLifecycleRuleFilterNotTag']:
        """
        The tag of the objects to which the lifecycle rule does not apply. See `tag` below.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class BucketLifecycleRuleFilterNotTag(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The key of the tag that is specified for the objects.
        :param _builtins.str value: The value of the tag that is specified for the objects.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key of the tag that is specified for the objects.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the tag that is specified for the objects.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionExpiration(dict):
    def __init__(__self__, *,
                 days: _builtins.int):
        """
        :param _builtins.int days: Specifies the number of days noncurrent object versions transition.
        """
        pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"
        elif key == "isAccessTime":
            suggest = "is_access_time"
        elif key == "returnToStdWhenVisit":
            suggest = "return_to_std_when_visit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleNoncurrentVersionTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: _builtins.int,
                 storage_class: _builtins.str,
                 is_access_time: Optional[_builtins.bool] = None,
                 return_to_std_when_visit: Optional[_builtins.bool] = None):
        """
        :param _builtins.int days: Specifies the number of days noncurrent object versions transition.
        :param _builtins.str storage_class: The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        :param _builtins.bool is_access_time: Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        :param _builtins.bool return_to_std_when_visit: Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "storage_class", storage_class)
        if is_access_time is not None:
            pulumi.set(__self__, "is_access_time", is_access_time)
        if return_to_std_when_visit is not None:
            pulumi.set(__self__, "return_to_std_when_visit", return_to_std_when_visit)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter(name="isAccessTime")
    def is_access_time(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        """
        return pulumi.get(self, "is_access_time")

    @_builtins.property
    @pulumi.getter(name="returnToStdWhenVisit")
    def return_to_std_when_visit(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        return pulumi.get(self, "return_to_std_when_visit")


@pulumi.output_type
class BucketLifecycleRuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"
        elif key == "createdBeforeDate":
            suggest = "created_before_date"
        elif key == "isAccessTime":
            suggest = "is_access_time"
        elif key == "returnToStdWhenVisit":
            suggest = "return_to_std_when_visit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class: _builtins.str,
                 created_before_date: Optional[_builtins.str] = None,
                 days: Optional[_builtins.int] = None,
                 is_access_time: Optional[_builtins.bool] = None,
                 return_to_std_when_visit: Optional[_builtins.bool] = None):
        """
        :param _builtins.str storage_class: The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        :param _builtins.str created_before_date: Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        :param _builtins.int days: Specifies the number of days noncurrent object versions transition.
        :param _builtins.bool is_access_time: Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        :param _builtins.bool return_to_std_when_visit: Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        if created_before_date is not None:
            pulumi.set(__self__, "created_before_date", created_before_date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if is_access_time is not None:
            pulumi.set(__self__, "is_access_time", is_access_time)
        if return_to_std_when_visit is not None:
            pulumi.set(__self__, "return_to_std_when_visit", return_to_std_when_visit)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter(name="createdBeforeDate")
    def created_before_date(self) -> Optional[_builtins.str]:
        """
        Specifies the time before which the rules take effect. The date must conform to the ISO8601 format and always be UTC 00:00. For example: 2002-10-11T00:00:00.000Z indicates that parts created before 2002-10-11T00:00:00.000Z are deleted, and parts created after this time (including this time) are not deleted.
        """
        return pulumi.get(self, "created_before_date")

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days noncurrent object versions transition.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter(name="isAccessTime")
    def is_access_time(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the lifecycle rule applies to objects based on their last access time. If set to `true`, the rule applies to objects based on their last access time; if set to `false`, the rule applies to objects based on their last modified time. If configure the rule based on the last access time, please enable `access_monitor` first.
        """
        return pulumi.get(self, "is_access_time")

    @_builtins.property
    @pulumi.getter(name="returnToStdWhenVisit")
    def return_to_std_when_visit(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to convert the storage class of non-Standard objects back to Standard after the objects are accessed. It takes effect only when the IsAccessTime parameter is set to true. If set to `true`, converts the storage class of the objects to Standard; if set to `false`, does not convert the storage class of the objects to Standard.
        """
        return pulumi.get(self, "return_to_std_when_visit")


@pulumi.output_type
class BucketLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetBucket":
            suggest = "target_bucket"
        elif key == "targetPrefix":
            suggest = "target_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_bucket: _builtins.str,
                 target_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str target_bucket: The name of the bucket that will receive the log objects.
        :param _builtins.str target_prefix: To specify a key prefix for log objects.
        """
        pulumi.set(__self__, "target_bucket", target_bucket)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> _builtins.str:
        """
        The name of the bucket that will receive the log objects.
        """
        return pulumi.get(self, "target_bucket")

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[_builtins.str]:
        """
        To specify a key prefix for log objects.
        """
        return pulumi.get(self, "target_prefix")


@pulumi.output_type
class BucketRefererConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowEmpty":
            suggest = "allow_empty"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRefererConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRefererConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRefererConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 referers: Sequence[_builtins.str],
                 allow_empty: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] referers: The list of referer.
        :param _builtins.bool allow_empty: Allows referer to be empty. Defaults false.
        """
        pulumi.set(__self__, "referers", referers)
        if allow_empty is not None:
            pulumi.set(__self__, "allow_empty", allow_empty)

    @_builtins.property
    @pulumi.getter
    def referers(self) -> Sequence[_builtins.str]:
        """
        The list of referer.
        """
        return pulumi.get(self, "referers")

    @_builtins.property
    @pulumi.getter(name="allowEmpty")
    def allow_empty(self) -> Optional[_builtins.bool]:
        """
        Allows referer to be empty. Defaults false.
        """
        return pulumi.get(self, "allow_empty")


@pulumi.output_type
class BucketReplicationDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transferType":
            suggest = "transfer_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: _builtins.str,
                 location: _builtins.str,
                 transfer_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: The destination bucket to which the data is replicated.
        :param _builtins.str location: The region in which the destination bucket is located.
        :param _builtins.str transfer_type: The link used to transfer data in data replication.. Can be `internal` or `oss_acc`. Defaults to `internal`.
               
               `NOTE`: You can set transfer_type to oss_acc only when you create cross-region replication (CRR) rules.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location", location)
        if transfer_type is not None:
            pulumi.set(__self__, "transfer_type", transfer_type)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The destination bucket to which the data is replicated.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The region in which the destination bucket is located.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="transferType")
    def transfer_type(self) -> Optional[_builtins.str]:
        """
        The link used to transfer data in data replication.. Can be `internal` or `oss_acc`. Defaults to `internal`.

        `NOTE`: You can set transfer_type to oss_acc only when you create cross-region replication (CRR) rules.
        """
        return pulumi.get(self, "transfer_type")


@pulumi.output_type
class BucketReplicationEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaKmsKeyId":
            suggest = "replica_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replica_kms_key_id: _builtins.str):
        """
        :param _builtins.str replica_kms_key_id: The CMK ID used in SSE-KMS.
               
               `NOTE`: If the status of sse_kms_encrypted_objects is set to Enabled, you must specify the replica_kms_key_id.
        """
        pulumi.set(__self__, "replica_kms_key_id", replica_kms_key_id)

    @_builtins.property
    @pulumi.getter(name="replicaKmsKeyId")
    def replica_kms_key_id(self) -> _builtins.str:
        """
        The CMK ID used in SSE-KMS.

        `NOTE`: If the status of sse_kms_encrypted_objects is set to Enabled, you must specify the replica_kms_key_id.
        """
        return pulumi.get(self, "replica_kms_key_id")


@pulumi.output_type
class BucketReplicationPrefixSet(dict):
    def __init__(__self__, *,
                 prefixes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] prefixes: The list of object key name prefix identifying one or more objects to which the rule applies.
               
               `NOTE`: The prefix must be less than or equal to 1024 characters in length.
        """
        pulumi.set(__self__, "prefixes", prefixes)

    @_builtins.property
    @pulumi.getter
    def prefixes(self) -> Sequence[_builtins.str]:
        """
        The list of object key name prefix identifying one or more objects to which the rule applies.

        `NOTE`: The prefix must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "prefixes")


@pulumi.output_type
class BucketReplicationProgress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "historicalObject":
            suggest = "historical_object"
        elif key == "newObject":
            suggest = "new_object"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationProgress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationProgress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationProgress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 historical_object: Optional[_builtins.str] = None,
                 new_object: Optional[_builtins.str] = None):
        """
        :param _builtins.str historical_object: The percentage of the replicated historical data. This element is valid only when historical_object_replication is set to enabled.
        :param _builtins.str new_object: The time used to distinguish new data from historical data. Data that is written to the source bucket before the time is replicated to the destination bucket as new data. The value of this element is in GMT.
        """
        if historical_object is not None:
            pulumi.set(__self__, "historical_object", historical_object)
        if new_object is not None:
            pulumi.set(__self__, "new_object", new_object)

    @_builtins.property
    @pulumi.getter(name="historicalObject")
    def historical_object(self) -> Optional[_builtins.str]:
        """
        The percentage of the replicated historical data. This element is valid only when historical_object_replication is set to enabled.
        """
        return pulumi.get(self, "historical_object")

    @_builtins.property
    @pulumi.getter(name="newObject")
    def new_object(self) -> Optional[_builtins.str]:
        """
        The time used to distinguish new data from historical data. Data that is written to the source bucket before the time is replicated to the destination bucket as new data. The value of this element is in GMT.
        """
        return pulumi.get(self, "new_object")


@pulumi.output_type
class BucketReplicationRtc(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Specifies whether to enable the RTC feature. Set to `true` to enable or `false` to disable. This argument is required when the rtc block is defined.
        :param _builtins.str status: The current status of the RTC feature. This attribute is read-only and is only populated when `enabled` is set to `true`. Possible values are:
        """
        pulumi.set(__self__, "enabled", enabled)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Specifies whether to enable the RTC feature. Set to `true` to enable or `false` to disable. This argument is required when the rtc block is defined.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The current status of the RTC feature. This attribute is read-only and is only populated when `enabled` is set to `true`. Possible values are:
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketReplicationSourceSelectionCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseKmsEncryptedObjects":
            suggest = "sse_kms_encrypted_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketReplicationSourceSelectionCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketReplicationSourceSelectionCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketReplicationSourceSelectionCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_kms_encrypted_objects: Optional['outputs.BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjects'] = None):
        """
        :param 'BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjectsArgs' sse_kms_encrypted_objects: Filter source objects encrypted by using SSE-KMS. See `sse_kms_encrypted_objects` below.
        """
        if sse_kms_encrypted_objects is not None:
            pulumi.set(__self__, "sse_kms_encrypted_objects", sse_kms_encrypted_objects)

    @_builtins.property
    @pulumi.getter(name="sseKmsEncryptedObjects")
    def sse_kms_encrypted_objects(self) -> Optional['outputs.BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjects']:
        """
        Filter source objects encrypted by using SSE-KMS. See `sse_kms_encrypted_objects` below.
        """
        return pulumi.get(self, "sse_kms_encrypted_objects")


@pulumi.output_type
class BucketReplicationSourceSelectionCriteriaSseKmsEncryptedObjects(dict):
    def __init__(__self__, *,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str status: The status of the data replication task. Can be starting, doing and closing.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the data replication task. Can be starting, doing and closing.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketServerSideEncryptionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseAlgorithm":
            suggest = "sse_algorithm"
        elif key == "kmsDataEncryption":
            suggest = "kms_data_encryption"
        elif key == "kmsMasterKeyId":
            suggest = "kms_master_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketServerSideEncryptionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketServerSideEncryptionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketServerSideEncryptionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_algorithm: _builtins.str,
                 kms_data_encryption: Optional[_builtins.str] = None,
                 kms_master_key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str sse_algorithm: The server-side encryption algorithm to use. Possible values: `AES256` and `KMS`.
        :param _builtins.str kms_data_encryption: The algorithm used to encrypt objects. If this element is not specified, objects are encrypted with AES256. This element is valid only when the value of SSEAlgorithm is set to KMS. Valid values: `SM4`.
        :param _builtins.str kms_master_key_id: The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_data_encryption is not None:
            pulumi.set(__self__, "kms_data_encryption", kms_data_encryption)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @_builtins.property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> _builtins.str:
        """
        The server-side encryption algorithm to use. Possible values: `AES256` and `KMS`.
        """
        return pulumi.get(self, "sse_algorithm")

    @_builtins.property
    @pulumi.getter(name="kmsDataEncryption")
    def kms_data_encryption(self) -> Optional[_builtins.str]:
        """
        The algorithm used to encrypt objects. If this element is not specified, objects are encrypted with AES256. This element is valid only when the value of SSEAlgorithm is set to KMS. Valid values: `SM4`.
        """
        return pulumi.get(self, "kms_data_encryption")

    @_builtins.property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[_builtins.str]:
        """
        The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
        """
        return pulumi.get(self, "kms_master_key_id")


@pulumi.output_type
class BucketTransferAcceleration(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Specifies the accelerate status of a bucket.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Specifies the accelerate status of a bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BucketVersioning(dict):
    def __init__(__self__, *,
                 status: _builtins.str):
        """
        :param _builtins.str status: Specifies the versioning state of a bucket. Valid values: `Enabled` and `Suspended`.
        """
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the versioning state of a bucket. Valid values: `Enabled` and `Suspended`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class BucketWebsite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexDocument":
            suggest = "index_document"
        elif key == "errorDocument":
            suggest = "error_document"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_document: _builtins.str,
                 error_document: Optional[_builtins.str] = None):
        """
        :param _builtins.str index_document: Alicloud OSS returns this index document when requests are made to the root domain or any of the subfolders.
        :param _builtins.str error_document: An absolute path to the document to return in case of a 4XX error.
        """
        pulumi.set(__self__, "index_document", index_document)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> _builtins.str:
        """
        Alicloud OSS returns this index document when requests are made to the root domain or any of the subfolders.
        """
        return pulumi.get(self, "index_document")

    @_builtins.property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[_builtins.str]:
        """
        An absolute path to the document to return in case of a 4XX error.
        """
        return pulumi.get(self, "error_document")


@pulumi.output_type
class BucketWebsiteErrorDocument(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpStatus":
            suggest = "http_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteErrorDocument. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteErrorDocument.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteErrorDocument.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_status: Optional[_builtins.int] = None,
                 key: Optional[_builtins.str] = None):
        """
        :param _builtins.int http_status: The HTTP status code when the error page is returned. The default 404.
        :param _builtins.str key: The error page file. If the Object accessed does not exist, this error page is returned.
        """
        if http_status is not None:
            pulumi.set(__self__, "http_status", http_status)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter(name="httpStatus")
    def http_status(self) -> Optional[_builtins.int]:
        """
        The HTTP status code when the error page is returned. The default 404.
        """
        return pulumi.get(self, "http_status")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The error page file. If the Object accessed does not exist, this error page is returned.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class BucketWebsiteIndexDocument(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supportSubDir":
            suggest = "support_sub_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteIndexDocument. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteIndexDocument.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteIndexDocument.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 suffix: Optional[_builtins.str] = None,
                 support_sub_dir: Optional[_builtins.bool] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str suffix: The default home page.
        :param _builtins.bool support_sub_dir: Whether to jump to the default home page of a subdirectory when accessing a subdirectory.
        :param _builtins.str type: After the default homepage is set, the behavior when an Object that ends with a non-forward slash (/) is accessed and the Object does not exist.
        """
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)
        if support_sub_dir is not None:
            pulumi.set(__self__, "support_sub_dir", support_sub_dir)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def suffix(self) -> Optional[_builtins.str]:
        """
        The default home page.
        """
        return pulumi.get(self, "suffix")

    @_builtins.property
    @pulumi.getter(name="supportSubDir")
    def support_sub_dir(self) -> Optional[_builtins.bool]:
        """
        Whether to jump to the default home page of a subdirectory when accessing a subdirectory.
        """
        return pulumi.get(self, "support_sub_dir")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        After the default homepage is set, the behavior when an Object that ends with a non-forward slash (/) is accessed and the Object does not exist.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class BucketWebsiteRoutingRules(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routingRules":
            suggest = "routing_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteRoutingRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteRoutingRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteRoutingRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 routing_rules: Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRule']] = None):
        """
        :param Sequence['BucketWebsiteRoutingRulesRoutingRuleArgs'] routing_rules: Specify a jump rule or a mirroring back-to-origin rule, with a maximum of 20 routing rules. See `routing_rule` below.
        """
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)

    @_builtins.property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRule']]:
        """
        Specify a jump rule or a mirroring back-to-origin rule, with a maximum of 20 routing rules. See `routing_rule` below.
        """
        return pulumi.get(self, "routing_rules")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "luaConfig":
            suggest = "lua_config"
        elif key == "ruleNumber":
            suggest = "rule_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteRoutingRulesRoutingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteRoutingRulesRoutingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteRoutingRulesRoutingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleCondition'] = None,
                 lua_config: Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleLuaConfig'] = None,
                 redirect: Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirect'] = None,
                 rule_number: Optional[_builtins.int] = None):
        """
        :param 'BucketWebsiteRoutingRulesRoutingRuleConditionArgs' condition: Save the criteria that the rule needs to match. See `condition` below.
        :param 'BucketWebsiteRoutingRulesRoutingRuleLuaConfigArgs' lua_config: The Lua script configuration to be executed. See `lua_config` below.
        :param 'BucketWebsiteRoutingRulesRoutingRuleRedirectArgs' redirect: Specifies the action to perform after this rule is matched. See `redirect` below.
        :param _builtins.int rule_number: The sequence number of the matching and executing jump rules. OSS matches rules according to this sequence number. If the match is successful, the rule is executed and subsequent rules are not executed.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if lua_config is not None:
            pulumi.set(__self__, "lua_config", lua_config)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if rule_number is not None:
            pulumi.set(__self__, "rule_number", rule_number)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleCondition']:
        """
        Save the criteria that the rule needs to match. See `condition` below.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="luaConfig")
    def lua_config(self) -> Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleLuaConfig']:
        """
        The Lua script configuration to be executed. See `lua_config` below.
        """
        return pulumi.get(self, "lua_config")

    @_builtins.property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirect']:
        """
        Specifies the action to perform after this rule is matched. See `redirect` below.
        """
        return pulumi.get(self, "redirect")

    @_builtins.property
    @pulumi.getter(name="ruleNumber")
    def rule_number(self) -> Optional[_builtins.int]:
        """
        The sequence number of the matching and executing jump rules. OSS matches rules according to this sequence number. If the match is successful, the rule is executed and subsequent rules are not executed.
        """
        return pulumi.get(self, "rule_number")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpErrorCodeReturnedEquals":
            suggest = "http_error_code_returned_equals"
        elif key == "includeHeaders":
            suggest = "include_headers"
        elif key == "keyPrefixEquals":
            suggest = "key_prefix_equals"
        elif key == "keySuffixEquals":
            suggest = "key_suffix_equals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteRoutingRulesRoutingRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_error_code_returned_equals: Optional[_builtins.str] = None,
                 include_headers: Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRuleConditionIncludeHeader']] = None,
                 key_prefix_equals: Optional[_builtins.str] = None,
                 key_suffix_equals: Optional[_builtins.str] = None):
        """
        :param _builtins.str http_error_code_returned_equals: When the specified Object is accessed, this status is returned to match this rule. This field must be 404 when the jump rule is mirrored back to the source.
        :param Sequence['BucketWebsiteRoutingRulesRoutingRuleConditionIncludeHeaderArgs'] include_headers: This rule can only be matched if the request contains the specified Header and the value is the specified value. You can specify up to 10 containers. See `include_headers` below.
        :param _builtins.str key_prefix_equals: Only objects that match this prefix can match this rule.
        :param _builtins.str key_suffix_equals: Only objects that match this suffix can match this rule.
        """
        if http_error_code_returned_equals is not None:
            pulumi.set(__self__, "http_error_code_returned_equals", http_error_code_returned_equals)
        if include_headers is not None:
            pulumi.set(__self__, "include_headers", include_headers)
        if key_prefix_equals is not None:
            pulumi.set(__self__, "key_prefix_equals", key_prefix_equals)
        if key_suffix_equals is not None:
            pulumi.set(__self__, "key_suffix_equals", key_suffix_equals)

    @_builtins.property
    @pulumi.getter(name="httpErrorCodeReturnedEquals")
    def http_error_code_returned_equals(self) -> Optional[_builtins.str]:
        """
        When the specified Object is accessed, this status is returned to match this rule. This field must be 404 when the jump rule is mirrored back to the source.
        """
        return pulumi.get(self, "http_error_code_returned_equals")

    @_builtins.property
    @pulumi.getter(name="includeHeaders")
    def include_headers(self) -> Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRuleConditionIncludeHeader']]:
        """
        This rule can only be matched if the request contains the specified Header and the value is the specified value. You can specify up to 10 containers. See `include_headers` below.
        """
        return pulumi.get(self, "include_headers")

    @_builtins.property
    @pulumi.getter(name="keyPrefixEquals")
    def key_prefix_equals(self) -> Optional[_builtins.str]:
        """
        Only objects that match this prefix can match this rule.
        """
        return pulumi.get(self, "key_prefix_equals")

    @_builtins.property
    @pulumi.getter(name="keySuffixEquals")
    def key_suffix_equals(self) -> Optional[_builtins.str]:
        """
        Only objects that match this suffix can match this rule.
        """
        return pulumi.get(self, "key_suffix_equals")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleConditionIncludeHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endsWith":
            suggest = "ends_with"
        elif key == "startsWith":
            suggest = "starts_with"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteRoutingRulesRoutingRuleConditionIncludeHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleConditionIncludeHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleConditionIncludeHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ends_with: Optional[_builtins.str] = None,
                 equals: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 starts_with: Optional[_builtins.str] = None):
        """
        :param _builtins.str ends_with: This rule can only be matched if the request contains the Header specified by Key and the value ends with this value.
        :param _builtins.str equals: This rule can only be matched if the request contains the Header specified by Key and the value is the specified value.
        :param _builtins.str starts_with: This rule can only be matched if the request contains the Header specified by Key and the value starts with this value.
        """
        if ends_with is not None:
            pulumi.set(__self__, "ends_with", ends_with)
        if equals is not None:
            pulumi.set(__self__, "equals", equals)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if starts_with is not None:
            pulumi.set(__self__, "starts_with", starts_with)

    @_builtins.property
    @pulumi.getter(name="endsWith")
    def ends_with(self) -> Optional[_builtins.str]:
        """
        This rule can only be matched if the request contains the Header specified by Key and the value ends with this value.
        """
        return pulumi.get(self, "ends_with")

    @_builtins.property
    @pulumi.getter
    def equals(self) -> Optional[_builtins.str]:
        """
        This rule can only be matched if the request contains the Header specified by Key and the value is the specified value.
        """
        return pulumi.get(self, "equals")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="startsWith")
    def starts_with(self) -> Optional[_builtins.str]:
        """
        This rule can only be matched if the request contains the Header specified by Key and the value starts with this value.
        """
        return pulumi.get(self, "starts_with")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleLuaConfig(dict):
    def __init__(__self__, *,
                 script: Optional[_builtins.str] = None):
        """
        :param _builtins.str script: The Lua script name.
        """
        if script is not None:
            pulumi.set(__self__, "script", script)

    @_builtins.property
    @pulumi.getter
    def script(self) -> Optional[_builtins.str]:
        """
        The Lua script name.
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableReplacePrefix":
            suggest = "enable_replace_prefix"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "httpRedirectCode":
            suggest = "http_redirect_code"
        elif key == "mirrorAllowGetImageInfo":
            suggest = "mirror_allow_get_image_info"
        elif key == "mirrorAllowHeadObject":
            suggest = "mirror_allow_head_object"
        elif key == "mirrorAllowVideoSnapshot":
            suggest = "mirror_allow_video_snapshot"
        elif key == "mirrorAsyncStatus":
            suggest = "mirror_async_status"
        elif key == "mirrorAuth":
            suggest = "mirror_auth"
        elif key == "mirrorCheckMd5":
            suggest = "mirror_check_md5"
        elif key == "mirrorDstRegion":
            suggest = "mirror_dst_region"
        elif key == "mirrorDstSlaveVpcId":
            suggest = "mirror_dst_slave_vpc_id"
        elif key == "mirrorDstVpcId":
            suggest = "mirror_dst_vpc_id"
        elif key == "mirrorFollowRedirect":
            suggest = "mirror_follow_redirect"
        elif key == "mirrorHeaders":
            suggest = "mirror_headers"
        elif key == "mirrorIsExpressTunnel":
            suggest = "mirror_is_express_tunnel"
        elif key == "mirrorMultiAlternates":
            suggest = "mirror_multi_alternates"
        elif key == "mirrorPassOriginalSlashes":
            suggest = "mirror_pass_original_slashes"
        elif key == "mirrorPassQueryString":
            suggest = "mirror_pass_query_string"
        elif key == "mirrorProxyPass":
            suggest = "mirror_proxy_pass"
        elif key == "mirrorReturnHeaders":
            suggest = "mirror_return_headers"
        elif key == "mirrorRole":
            suggest = "mirror_role"
        elif key == "mirrorSaveOssMeta":
            suggest = "mirror_save_oss_meta"
        elif key == "mirrorSni":
            suggest = "mirror_sni"
        elif key == "mirrorSwitchAllErrors":
            suggest = "mirror_switch_all_errors"
        elif key == "mirrorTaggings":
            suggest = "mirror_taggings"
        elif key == "mirrorTunnelId":
            suggest = "mirror_tunnel_id"
        elif key == "mirrorUrl":
            suggest = "mirror_url"
        elif key == "mirrorUrlProbe":
            suggest = "mirror_url_probe"
        elif key == "mirrorUrlSlave":
            suggest = "mirror_url_slave"
        elif key == "mirrorUserLastModified":
            suggest = "mirror_user_last_modified"
        elif key == "mirrorUsingRole":
            suggest = "mirror_using_role"
        elif key == "passQueryString":
            suggest = "pass_query_string"
        elif key == "redirectType":
            suggest = "redirect_type"
        elif key == "replaceKeyPrefixWith":
            suggest = "replace_key_prefix_with"
        elif key == "replaceKeyWith":
            suggest = "replace_key_with"
        elif key == "transparentMirrorResponseCodes":
            suggest = "transparent_mirror_response_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteRoutingRulesRoutingRuleRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_replace_prefix: Optional[_builtins.bool] = None,
                 host_name: Optional[_builtins.str] = None,
                 http_redirect_code: Optional[_builtins.str] = None,
                 mirror_allow_get_image_info: Optional[_builtins.bool] = None,
                 mirror_allow_head_object: Optional[_builtins.bool] = None,
                 mirror_allow_video_snapshot: Optional[_builtins.bool] = None,
                 mirror_async_status: Optional[_builtins.int] = None,
                 mirror_auth: Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorAuth'] = None,
                 mirror_check_md5: Optional[_builtins.bool] = None,
                 mirror_dst_region: Optional[_builtins.str] = None,
                 mirror_dst_slave_vpc_id: Optional[_builtins.str] = None,
                 mirror_dst_vpc_id: Optional[_builtins.str] = None,
                 mirror_follow_redirect: Optional[_builtins.bool] = None,
                 mirror_headers: Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeaders'] = None,
                 mirror_is_express_tunnel: Optional[_builtins.bool] = None,
                 mirror_multi_alternates: Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternates'] = None,
                 mirror_pass_original_slashes: Optional[_builtins.bool] = None,
                 mirror_pass_query_string: Optional[_builtins.bool] = None,
                 mirror_proxy_pass: Optional[_builtins.bool] = None,
                 mirror_return_headers: Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeaders'] = None,
                 mirror_role: Optional[_builtins.str] = None,
                 mirror_save_oss_meta: Optional[_builtins.bool] = None,
                 mirror_sni: Optional[_builtins.bool] = None,
                 mirror_switch_all_errors: Optional[_builtins.bool] = None,
                 mirror_taggings: Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorTaggings'] = None,
                 mirror_tunnel_id: Optional[_builtins.str] = None,
                 mirror_url: Optional[_builtins.str] = None,
                 mirror_url_probe: Optional[_builtins.str] = None,
                 mirror_url_slave: Optional[_builtins.str] = None,
                 mirror_user_last_modified: Optional[_builtins.bool] = None,
                 mirror_using_role: Optional[_builtins.bool] = None,
                 pass_query_string: Optional[_builtins.bool] = None,
                 protocol: Optional[_builtins.str] = None,
                 redirect_type: Optional[_builtins.str] = None,
                 replace_key_prefix_with: Optional[_builtins.str] = None,
                 replace_key_with: Optional[_builtins.str] = None,
                 transparent_mirror_response_codes: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enable_replace_prefix: If this field is set to true, the prefix of Object is replaced with the value specified by ReplaceKeyPrefixWith. If this field is not specified or is blank, the Object prefix is truncated.
        :param _builtins.str host_name: The domain name during the jump. The domain name must comply with the domain name specification.
        :param _builtins.str http_redirect_code: The status code returned during the jump. It takes effect only when the RedirectType is set to External or AliCDN.
        :param _builtins.bool mirror_allow_get_image_info: Image back-to-source allows getting Image information
        :param _builtins.bool mirror_allow_head_object: Whether to allow HeadObject in image back-to-source
        :param _builtins.bool mirror_allow_video_snapshot: Mirror back-to-source allows support for video frame truncation
        :param _builtins.int mirror_async_status: The status code of the mirror back-to-source trigger asynchronous pull mode.
        :param 'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorAuthArgs' mirror_auth: Image back Source station authentication information See `mirror_auth` below.
        :param _builtins.bool mirror_check_md5: Whether to check the MD5 of the source body. It takes effect only when the RedirectType is set to Mirror.
        :param _builtins.str mirror_dst_region: Mirrored back-to-source high-speed Channel vpregion
        :param _builtins.str mirror_dst_slave_vpc_id: Mirroring back-to-source high-speed Channel standby station VpcId
        :param _builtins.str mirror_dst_vpc_id: Mirror back-to-source high-speed Channel VpcId
        :param _builtins.bool mirror_follow_redirect: If the result of the image back-to-source acquisition is 3xx, whether to continue to jump to the specified Location to obtain data. It takes effect only when the RedirectType is set to Mirror.
        :param 'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeadersArgs' mirror_headers: Specifies the Header carried when the image returns to the source. It takes effect only when the RedirectType is set to Mirror. See `mirror_headers` below.
        :param _builtins.bool mirror_is_express_tunnel: Whether it is a mirror back-to-source high-speed Channel
        :param 'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternatesArgs' mirror_multi_alternates: Mirror back-to-source multi-source station configuration container. **NOTE:**: If you want to clean one configuration, you must set the configuration to empty value, removing from code cannot make effect. See `mirror_multi_alternates` below.
        :param _builtins.bool mirror_pass_original_slashes: Transparent transmission/to source Station
        :param _builtins.bool mirror_pass_query_string: Same as PassQueryString and takes precedence over PassQueryString. It takes effect only when the RedirectType is set to Mirror.
        :param _builtins.bool mirror_proxy_pass: Whether mirroring back to source does not save data
        :param 'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeadersArgs' mirror_return_headers: The container that saves the image back to the source and returns the response header rule. **NOTE:**: If you want to clean one configuration, you must set the configuration to empty value, removing from code cannot make effect. See `mirror_return_headers` below.
        :param _builtins.str mirror_role: Roles used when mirroring back-to-source
        :param _builtins.bool mirror_save_oss_meta: Mirror back-to-source back-to-source OSS automatically saves user metadata
        :param _builtins.bool mirror_sni: Transparent transmission of SNI
        :param _builtins.bool mirror_switch_all_errors: It is used to judge the status of active-standby switching. The judgment logic of active-standby switching is that the source station returns an error. If MirrorSwitchAllErrors is true, it is considered a failure except the following status code: 200,206,301,302,303,307,404; If false, only the source Station Returns 5xx or times out is considered a failure.
        :param 'BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorTaggingsArgs' mirror_taggings: Save the label according to the parameters when saving the file from the mirror back to the source. **NOTE:**: If you want to clean one configuration, you must set the configuration to empty value, removing from code cannot make effect. See `mirror_taggings` below.
        :param _builtins.str mirror_tunnel_id: Mirror back-to-source leased line back-to-source tunnel ID
        :param _builtins.str mirror_url: The address of the origin of the image. It takes effect only when the RedirectType is set to Mirror. The origin address must start with http:// or https:// and end with a forward slash (/). OSS takes the Object name after the Origin address to form the origin URL.
        :param _builtins.str mirror_url_probe: Mirror back-to-source Master-backup back-to-source switching decision URL
        :param _builtins.str mirror_url_slave: Mirror back-to-source primary backup back-to-source backup station URL
        :param _builtins.bool mirror_user_last_modified: Whether the source station LastModifiedTime is used for the image back-to-source save file.
        :param _builtins.bool mirror_using_role: Whether to use role for mirroring back to source
        :param _builtins.bool pass_query_string: Whether to carry the request parameters when executing the jump or mirror back-to-source rule. Did the user carry the request parameters when requesting OSS? a = B & c = d, and set PassQueryString to true. If the rule is a 302 jump, this request parameter is added to the Location header of the jump. For example Location:example.com? a = B & c = d, and the jump type is mirrored back-to-origin, this request parameter is also carried in the back-to-origin request initiated. Values: true, false (default)
        :param _builtins.str protocol: The protocol at the time of the jump. It takes effect only when the RedirectType is set to External or AliCDN.
        :param _builtins.str redirect_type: Specifies the type of jump. The value range is as follows: Mirror: Mirror back to the source. External: External redirects, that is, OSS returns a 3xx request to redirect to another address. AliCDN: Alibaba Cloud CDN jump, mainly used for Alibaba Cloud CDN. Unlike External, OSS adds an additional Header. After recognizing this Header, Alibaba Cloud CDN redirects the data to the specified address and returns the obtained data to the user instead of returning the 3xx Redirection request to the user.
        :param _builtins.str replace_key_prefix_with: The prefix of the Object name will be replaced with this value during Redirect. If the prefix is empty, this string is inserted in front of the Object name.
        :param _builtins.str replace_key_with: During redirection, the Object name is replaced with the value specified by ReplaceKeyWith. You can set variables in ReplaceKeyWith. Currently, the supported variable is ${key}, which indicates the name of the Object in the request.
        :param _builtins.str transparent_mirror_response_codes: Mirror back-to-source transparent source station response code list
        """
        if enable_replace_prefix is not None:
            pulumi.set(__self__, "enable_replace_prefix", enable_replace_prefix)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if http_redirect_code is not None:
            pulumi.set(__self__, "http_redirect_code", http_redirect_code)
        if mirror_allow_get_image_info is not None:
            pulumi.set(__self__, "mirror_allow_get_image_info", mirror_allow_get_image_info)
        if mirror_allow_head_object is not None:
            pulumi.set(__self__, "mirror_allow_head_object", mirror_allow_head_object)
        if mirror_allow_video_snapshot is not None:
            pulumi.set(__self__, "mirror_allow_video_snapshot", mirror_allow_video_snapshot)
        if mirror_async_status is not None:
            pulumi.set(__self__, "mirror_async_status", mirror_async_status)
        if mirror_auth is not None:
            pulumi.set(__self__, "mirror_auth", mirror_auth)
        if mirror_check_md5 is not None:
            pulumi.set(__self__, "mirror_check_md5", mirror_check_md5)
        if mirror_dst_region is not None:
            pulumi.set(__self__, "mirror_dst_region", mirror_dst_region)
        if mirror_dst_slave_vpc_id is not None:
            pulumi.set(__self__, "mirror_dst_slave_vpc_id", mirror_dst_slave_vpc_id)
        if mirror_dst_vpc_id is not None:
            pulumi.set(__self__, "mirror_dst_vpc_id", mirror_dst_vpc_id)
        if mirror_follow_redirect is not None:
            pulumi.set(__self__, "mirror_follow_redirect", mirror_follow_redirect)
        if mirror_headers is not None:
            pulumi.set(__self__, "mirror_headers", mirror_headers)
        if mirror_is_express_tunnel is not None:
            pulumi.set(__self__, "mirror_is_express_tunnel", mirror_is_express_tunnel)
        if mirror_multi_alternates is not None:
            pulumi.set(__self__, "mirror_multi_alternates", mirror_multi_alternates)
        if mirror_pass_original_slashes is not None:
            pulumi.set(__self__, "mirror_pass_original_slashes", mirror_pass_original_slashes)
        if mirror_pass_query_string is not None:
            pulumi.set(__self__, "mirror_pass_query_string", mirror_pass_query_string)
        if mirror_proxy_pass is not None:
            pulumi.set(__self__, "mirror_proxy_pass", mirror_proxy_pass)
        if mirror_return_headers is not None:
            pulumi.set(__self__, "mirror_return_headers", mirror_return_headers)
        if mirror_role is not None:
            pulumi.set(__self__, "mirror_role", mirror_role)
        if mirror_save_oss_meta is not None:
            pulumi.set(__self__, "mirror_save_oss_meta", mirror_save_oss_meta)
        if mirror_sni is not None:
            pulumi.set(__self__, "mirror_sni", mirror_sni)
        if mirror_switch_all_errors is not None:
            pulumi.set(__self__, "mirror_switch_all_errors", mirror_switch_all_errors)
        if mirror_taggings is not None:
            pulumi.set(__self__, "mirror_taggings", mirror_taggings)
        if mirror_tunnel_id is not None:
            pulumi.set(__self__, "mirror_tunnel_id", mirror_tunnel_id)
        if mirror_url is not None:
            pulumi.set(__self__, "mirror_url", mirror_url)
        if mirror_url_probe is not None:
            pulumi.set(__self__, "mirror_url_probe", mirror_url_probe)
        if mirror_url_slave is not None:
            pulumi.set(__self__, "mirror_url_slave", mirror_url_slave)
        if mirror_user_last_modified is not None:
            pulumi.set(__self__, "mirror_user_last_modified", mirror_user_last_modified)
        if mirror_using_role is not None:
            pulumi.set(__self__, "mirror_using_role", mirror_using_role)
        if pass_query_string is not None:
            pulumi.set(__self__, "pass_query_string", pass_query_string)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if redirect_type is not None:
            pulumi.set(__self__, "redirect_type", redirect_type)
        if replace_key_prefix_with is not None:
            pulumi.set(__self__, "replace_key_prefix_with", replace_key_prefix_with)
        if replace_key_with is not None:
            pulumi.set(__self__, "replace_key_with", replace_key_with)
        if transparent_mirror_response_codes is not None:
            pulumi.set(__self__, "transparent_mirror_response_codes", transparent_mirror_response_codes)

    @_builtins.property
    @pulumi.getter(name="enableReplacePrefix")
    def enable_replace_prefix(self) -> Optional[_builtins.bool]:
        """
        If this field is set to true, the prefix of Object is replaced with the value specified by ReplaceKeyPrefixWith. If this field is not specified or is blank, the Object prefix is truncated.
        """
        return pulumi.get(self, "enable_replace_prefix")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[_builtins.str]:
        """
        The domain name during the jump. The domain name must comply with the domain name specification.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="httpRedirectCode")
    def http_redirect_code(self) -> Optional[_builtins.str]:
        """
        The status code returned during the jump. It takes effect only when the RedirectType is set to External or AliCDN.
        """
        return pulumi.get(self, "http_redirect_code")

    @_builtins.property
    @pulumi.getter(name="mirrorAllowGetImageInfo")
    def mirror_allow_get_image_info(self) -> Optional[_builtins.bool]:
        """
        Image back-to-source allows getting Image information
        """
        return pulumi.get(self, "mirror_allow_get_image_info")

    @_builtins.property
    @pulumi.getter(name="mirrorAllowHeadObject")
    def mirror_allow_head_object(self) -> Optional[_builtins.bool]:
        """
        Whether to allow HeadObject in image back-to-source
        """
        return pulumi.get(self, "mirror_allow_head_object")

    @_builtins.property
    @pulumi.getter(name="mirrorAllowVideoSnapshot")
    def mirror_allow_video_snapshot(self) -> Optional[_builtins.bool]:
        """
        Mirror back-to-source allows support for video frame truncation
        """
        return pulumi.get(self, "mirror_allow_video_snapshot")

    @_builtins.property
    @pulumi.getter(name="mirrorAsyncStatus")
    def mirror_async_status(self) -> Optional[_builtins.int]:
        """
        The status code of the mirror back-to-source trigger asynchronous pull mode.
        """
        return pulumi.get(self, "mirror_async_status")

    @_builtins.property
    @pulumi.getter(name="mirrorAuth")
    def mirror_auth(self) -> Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorAuth']:
        """
        Image back Source station authentication information See `mirror_auth` below.
        """
        return pulumi.get(self, "mirror_auth")

    @_builtins.property
    @pulumi.getter(name="mirrorCheckMd5")
    def mirror_check_md5(self) -> Optional[_builtins.bool]:
        """
        Whether to check the MD5 of the source body. It takes effect only when the RedirectType is set to Mirror.
        """
        return pulumi.get(self, "mirror_check_md5")

    @_builtins.property
    @pulumi.getter(name="mirrorDstRegion")
    def mirror_dst_region(self) -> Optional[_builtins.str]:
        """
        Mirrored back-to-source high-speed Channel vpregion
        """
        return pulumi.get(self, "mirror_dst_region")

    @_builtins.property
    @pulumi.getter(name="mirrorDstSlaveVpcId")
    def mirror_dst_slave_vpc_id(self) -> Optional[_builtins.str]:
        """
        Mirroring back-to-source high-speed Channel standby station VpcId
        """
        return pulumi.get(self, "mirror_dst_slave_vpc_id")

    @_builtins.property
    @pulumi.getter(name="mirrorDstVpcId")
    def mirror_dst_vpc_id(self) -> Optional[_builtins.str]:
        """
        Mirror back-to-source high-speed Channel VpcId
        """
        return pulumi.get(self, "mirror_dst_vpc_id")

    @_builtins.property
    @pulumi.getter(name="mirrorFollowRedirect")
    def mirror_follow_redirect(self) -> Optional[_builtins.bool]:
        """
        If the result of the image back-to-source acquisition is 3xx, whether to continue to jump to the specified Location to obtain data. It takes effect only when the RedirectType is set to Mirror.
        """
        return pulumi.get(self, "mirror_follow_redirect")

    @_builtins.property
    @pulumi.getter(name="mirrorHeaders")
    def mirror_headers(self) -> Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeaders']:
        """
        Specifies the Header carried when the image returns to the source. It takes effect only when the RedirectType is set to Mirror. See `mirror_headers` below.
        """
        return pulumi.get(self, "mirror_headers")

    @_builtins.property
    @pulumi.getter(name="mirrorIsExpressTunnel")
    def mirror_is_express_tunnel(self) -> Optional[_builtins.bool]:
        """
        Whether it is a mirror back-to-source high-speed Channel
        """
        return pulumi.get(self, "mirror_is_express_tunnel")

    @_builtins.property
    @pulumi.getter(name="mirrorMultiAlternates")
    def mirror_multi_alternates(self) -> Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternates']:
        """
        Mirror back-to-source multi-source station configuration container. **NOTE:**: If you want to clean one configuration, you must set the configuration to empty value, removing from code cannot make effect. See `mirror_multi_alternates` below.
        """
        return pulumi.get(self, "mirror_multi_alternates")

    @_builtins.property
    @pulumi.getter(name="mirrorPassOriginalSlashes")
    def mirror_pass_original_slashes(self) -> Optional[_builtins.bool]:
        """
        Transparent transmission/to source Station
        """
        return pulumi.get(self, "mirror_pass_original_slashes")

    @_builtins.property
    @pulumi.getter(name="mirrorPassQueryString")
    def mirror_pass_query_string(self) -> Optional[_builtins.bool]:
        """
        Same as PassQueryString and takes precedence over PassQueryString. It takes effect only when the RedirectType is set to Mirror.
        """
        return pulumi.get(self, "mirror_pass_query_string")

    @_builtins.property
    @pulumi.getter(name="mirrorProxyPass")
    def mirror_proxy_pass(self) -> Optional[_builtins.bool]:
        """
        Whether mirroring back to source does not save data
        """
        return pulumi.get(self, "mirror_proxy_pass")

    @_builtins.property
    @pulumi.getter(name="mirrorReturnHeaders")
    def mirror_return_headers(self) -> Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeaders']:
        """
        The container that saves the image back to the source and returns the response header rule. **NOTE:**: If you want to clean one configuration, you must set the configuration to empty value, removing from code cannot make effect. See `mirror_return_headers` below.
        """
        return pulumi.get(self, "mirror_return_headers")

    @_builtins.property
    @pulumi.getter(name="mirrorRole")
    def mirror_role(self) -> Optional[_builtins.str]:
        """
        Roles used when mirroring back-to-source
        """
        return pulumi.get(self, "mirror_role")

    @_builtins.property
    @pulumi.getter(name="mirrorSaveOssMeta")
    def mirror_save_oss_meta(self) -> Optional[_builtins.bool]:
        """
        Mirror back-to-source back-to-source OSS automatically saves user metadata
        """
        return pulumi.get(self, "mirror_save_oss_meta")

    @_builtins.property
    @pulumi.getter(name="mirrorSni")
    def mirror_sni(self) -> Optional[_builtins.bool]:
        """
        Transparent transmission of SNI
        """
        return pulumi.get(self, "mirror_sni")

    @_builtins.property
    @pulumi.getter(name="mirrorSwitchAllErrors")
    def mirror_switch_all_errors(self) -> Optional[_builtins.bool]:
        """
        It is used to judge the status of active-standby switching. The judgment logic of active-standby switching is that the source station returns an error. If MirrorSwitchAllErrors is true, it is considered a failure except the following status code: 200,206,301,302,303,307,404; If false, only the source Station Returns 5xx or times out is considered a failure.
        """
        return pulumi.get(self, "mirror_switch_all_errors")

    @_builtins.property
    @pulumi.getter(name="mirrorTaggings")
    def mirror_taggings(self) -> Optional['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorTaggings']:
        """
        Save the label according to the parameters when saving the file from the mirror back to the source. **NOTE:**: If you want to clean one configuration, you must set the configuration to empty value, removing from code cannot make effect. See `mirror_taggings` below.
        """
        return pulumi.get(self, "mirror_taggings")

    @_builtins.property
    @pulumi.getter(name="mirrorTunnelId")
    def mirror_tunnel_id(self) -> Optional[_builtins.str]:
        """
        Mirror back-to-source leased line back-to-source tunnel ID
        """
        return pulumi.get(self, "mirror_tunnel_id")

    @_builtins.property
    @pulumi.getter(name="mirrorUrl")
    def mirror_url(self) -> Optional[_builtins.str]:
        """
        The address of the origin of the image. It takes effect only when the RedirectType is set to Mirror. The origin address must start with http:// or https:// and end with a forward slash (/). OSS takes the Object name after the Origin address to form the origin URL.
        """
        return pulumi.get(self, "mirror_url")

    @_builtins.property
    @pulumi.getter(name="mirrorUrlProbe")
    def mirror_url_probe(self) -> Optional[_builtins.str]:
        """
        Mirror back-to-source Master-backup back-to-source switching decision URL
        """
        return pulumi.get(self, "mirror_url_probe")

    @_builtins.property
    @pulumi.getter(name="mirrorUrlSlave")
    def mirror_url_slave(self) -> Optional[_builtins.str]:
        """
        Mirror back-to-source primary backup back-to-source backup station URL
        """
        return pulumi.get(self, "mirror_url_slave")

    @_builtins.property
    @pulumi.getter(name="mirrorUserLastModified")
    def mirror_user_last_modified(self) -> Optional[_builtins.bool]:
        """
        Whether the source station LastModifiedTime is used for the image back-to-source save file.
        """
        return pulumi.get(self, "mirror_user_last_modified")

    @_builtins.property
    @pulumi.getter(name="mirrorUsingRole")
    def mirror_using_role(self) -> Optional[_builtins.bool]:
        """
        Whether to use role for mirroring back to source
        """
        return pulumi.get(self, "mirror_using_role")

    @_builtins.property
    @pulumi.getter(name="passQueryString")
    def pass_query_string(self) -> Optional[_builtins.bool]:
        """
        Whether to carry the request parameters when executing the jump or mirror back-to-source rule. Did the user carry the request parameters when requesting OSS? a = B & c = d, and set PassQueryString to true. If the rule is a 302 jump, this request parameter is added to the Location header of the jump. For example Location:example.com? a = B & c = d, and the jump type is mirrored back-to-origin, this request parameter is also carried in the back-to-origin request initiated. Values: true, false (default)
        """
        return pulumi.get(self, "pass_query_string")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol at the time of the jump. It takes effect only when the RedirectType is set to External or AliCDN.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> Optional[_builtins.str]:
        """
        Specifies the type of jump. The value range is as follows: Mirror: Mirror back to the source. External: External redirects, that is, OSS returns a 3xx request to redirect to another address. AliCDN: Alibaba Cloud CDN jump, mainly used for Alibaba Cloud CDN. Unlike External, OSS adds an additional Header. After recognizing this Header, Alibaba Cloud CDN redirects the data to the specified address and returns the obtained data to the user instead of returning the 3xx Redirection request to the user.
        """
        return pulumi.get(self, "redirect_type")

    @_builtins.property
    @pulumi.getter(name="replaceKeyPrefixWith")
    def replace_key_prefix_with(self) -> Optional[_builtins.str]:
        """
        The prefix of the Object name will be replaced with this value during Redirect. If the prefix is empty, this string is inserted in front of the Object name.
        """
        return pulumi.get(self, "replace_key_prefix_with")

    @_builtins.property
    @pulumi.getter(name="replaceKeyWith")
    def replace_key_with(self) -> Optional[_builtins.str]:
        """
        During redirection, the Object name is replaced with the value specified by ReplaceKeyWith. You can set variables in ReplaceKeyWith. Currently, the supported variable is ${key}, which indicates the name of the Object in the request.
        """
        return pulumi.get(self, "replace_key_with")

    @_builtins.property
    @pulumi.getter(name="transparentMirrorResponseCodes")
    def transparent_mirror_response_codes(self) -> Optional[_builtins.str]:
        """
        Mirror back-to-source transparent source station response code list
        """
        return pulumi.get(self, "transparent_mirror_response_codes")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorAuth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "accessKeySecret":
            suggest = "access_key_secret"
        elif key == "authType":
            suggest = "auth_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: Optional[_builtins.str] = None,
                 access_key_secret: Optional[_builtins.str] = None,
                 auth_type: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key_id: Mirror back-to-source source Station back-to-source AK
        :param _builtins.str access_key_secret: Mirroring back to the source station back to the source SK will be automatically desensitized when obtaining the configuration.
        :param _builtins.str auth_type: Authentication type of mirror return Source
        :param _builtins.str region: Signature Region
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if access_key_secret is not None:
            pulumi.set(__self__, "access_key_secret", access_key_secret)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[_builtins.str]:
        """
        Mirror back-to-source source Station back-to-source AK
        """
        return pulumi.get(self, "access_key_id")

    @_builtins.property
    @pulumi.getter(name="accessKeySecret")
    def access_key_secret(self) -> Optional[_builtins.str]:
        """
        Mirroring back to the source station back to the source SK will be automatically desensitized when obtaining the configuration.
        """
        return pulumi.get(self, "access_key_secret")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Authentication type of mirror return Source
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Signature Region
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeaders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passAll":
            suggest = "pass_all"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pass_all: Optional[_builtins.bool] = None,
                 passes: Optional[Sequence[_builtins.str]] = None,
                 removes: Optional[Sequence[_builtins.str]] = None,
                 sets: Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeadersSet']] = None):
        """
        :param _builtins.bool pass_all: Indicates whether other headers except the following headers are transmitted to the source site. It takes effect only when the RedirectType is set to Mirror. content-length, authorization2, authorization, range, date, and other headers Headers whose names start with oss-/x-oss-/x-drs-
        :param Sequence[_builtins.str] passes: Pass through the specified Header to the source site. It takes effect only when the RedirectType is set to Mirror. Each Header is up to 1024 bytes in length and has A character set of 0 to 9, a to Z, A to z, and dashes (-).
        :param Sequence[_builtins.str] removes: Do not pass the specified Header to the source site. It takes effect only when the RedirectType is set to Mirror. Each Header is up to 1024 bytes in length and has A character set of 0 to 9, a to Z, A to z, and dashes (-).
        :param Sequence['BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeadersSetArgs'] sets: Set a Header to send to the source site. Regardless of whether the request contains the specified Header, these headers will be set when returning to the source site. It takes effect only when the RedirectType is set to Mirror. See `set` below.
        """
        if pass_all is not None:
            pulumi.set(__self__, "pass_all", pass_all)
        if passes is not None:
            pulumi.set(__self__, "passes", passes)
        if removes is not None:
            pulumi.set(__self__, "removes", removes)
        if sets is not None:
            pulumi.set(__self__, "sets", sets)

    @_builtins.property
    @pulumi.getter(name="passAll")
    def pass_all(self) -> Optional[_builtins.bool]:
        """
        Indicates whether other headers except the following headers are transmitted to the source site. It takes effect only when the RedirectType is set to Mirror. content-length, authorization2, authorization, range, date, and other headers Headers whose names start with oss-/x-oss-/x-drs-
        """
        return pulumi.get(self, "pass_all")

    @_builtins.property
    @pulumi.getter
    def passes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Pass through the specified Header to the source site. It takes effect only when the RedirectType is set to Mirror. Each Header is up to 1024 bytes in length and has A character set of 0 to 9, a to Z, A to z, and dashes (-).
        """
        return pulumi.get(self, "passes")

    @_builtins.property
    @pulumi.getter
    def removes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Do not pass the specified Header to the source site. It takes effect only when the RedirectType is set to Mirror. Each Header is up to 1024 bytes in length and has A character set of 0 to 9, a to Z, A to z, and dashes (-).
        """
        return pulumi.get(self, "removes")

    @_builtins.property
    @pulumi.getter
    def sets(self) -> Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeadersSet']]:
        """
        Set a Header to send to the source site. Regardless of whether the request contains the specified Header, these headers will be set when returning to the source site. It takes effect only when the RedirectType is set to Mirror. See `set` below.
        """
        return pulumi.get(self, "sets")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorHeadersSet(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: Set the value of the Header to 1024 bytes at most. \\r\\n. It takes effect only when the RedirectType is set to Mirror.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Set the value of the Header to 1024 bytes at most. \\r\\n. It takes effect only when the RedirectType is set to Mirror.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternates(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mirrorMultiAlternates":
            suggest = "mirror_multi_alternates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mirror_multi_alternates: Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternatesMirrorMultiAlternate']] = None):
        """
        :param Sequence['BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternatesMirrorMultiAlternateArgs'] mirror_multi_alternates: Mirror back-to-source multi-source station configuration list See `mirror_multi_alternate` below.
        """
        if mirror_multi_alternates is not None:
            pulumi.set(__self__, "mirror_multi_alternates", mirror_multi_alternates)

    @_builtins.property
    @pulumi.getter(name="mirrorMultiAlternates")
    def mirror_multi_alternates(self) -> Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternatesMirrorMultiAlternate']]:
        """
        Mirror back-to-source multi-source station configuration list See `mirror_multi_alternate` below.
        """
        return pulumi.get(self, "mirror_multi_alternates")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternatesMirrorMultiAlternate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mirrorMultiAlternateDstRegion":
            suggest = "mirror_multi_alternate_dst_region"
        elif key == "mirrorMultiAlternateNumber":
            suggest = "mirror_multi_alternate_number"
        elif key == "mirrorMultiAlternateUrl":
            suggest = "mirror_multi_alternate_url"
        elif key == "mirrorMultiAlternateVpcId":
            suggest = "mirror_multi_alternate_vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternatesMirrorMultiAlternate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternatesMirrorMultiAlternate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorMultiAlternatesMirrorMultiAlternate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mirror_multi_alternate_dst_region: Optional[_builtins.str] = None,
                 mirror_multi_alternate_number: Optional[_builtins.int] = None,
                 mirror_multi_alternate_url: Optional[_builtins.str] = None,
                 mirror_multi_alternate_vpc_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str mirror_multi_alternate_dst_region: Mirroring back-to-source multi-station Region
        :param _builtins.int mirror_multi_alternate_number: Image back-to-source multi-source station serial number
        :param _builtins.str mirror_multi_alternate_url: Mirroring back-to-source multi-source site URL
        :param _builtins.str mirror_multi_alternate_vpc_id: Mirroring back-to-source multi-source VpcId
        """
        if mirror_multi_alternate_dst_region is not None:
            pulumi.set(__self__, "mirror_multi_alternate_dst_region", mirror_multi_alternate_dst_region)
        if mirror_multi_alternate_number is not None:
            pulumi.set(__self__, "mirror_multi_alternate_number", mirror_multi_alternate_number)
        if mirror_multi_alternate_url is not None:
            pulumi.set(__self__, "mirror_multi_alternate_url", mirror_multi_alternate_url)
        if mirror_multi_alternate_vpc_id is not None:
            pulumi.set(__self__, "mirror_multi_alternate_vpc_id", mirror_multi_alternate_vpc_id)

    @_builtins.property
    @pulumi.getter(name="mirrorMultiAlternateDstRegion")
    def mirror_multi_alternate_dst_region(self) -> Optional[_builtins.str]:
        """
        Mirroring back-to-source multi-station Region
        """
        return pulumi.get(self, "mirror_multi_alternate_dst_region")

    @_builtins.property
    @pulumi.getter(name="mirrorMultiAlternateNumber")
    def mirror_multi_alternate_number(self) -> Optional[_builtins.int]:
        """
        Image back-to-source multi-source station serial number
        """
        return pulumi.get(self, "mirror_multi_alternate_number")

    @_builtins.property
    @pulumi.getter(name="mirrorMultiAlternateUrl")
    def mirror_multi_alternate_url(self) -> Optional[_builtins.str]:
        """
        Mirroring back-to-source multi-source site URL
        """
        return pulumi.get(self, "mirror_multi_alternate_url")

    @_builtins.property
    @pulumi.getter(name="mirrorMultiAlternateVpcId")
    def mirror_multi_alternate_vpc_id(self) -> Optional[_builtins.str]:
        """
        Mirroring back-to-source multi-source VpcId
        """
        return pulumi.get(self, "mirror_multi_alternate_vpc_id")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeaders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "returnHeaders":
            suggest = "return_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 return_headers: Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeadersReturnHeader']] = None):
        """
        :param Sequence['BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeadersReturnHeaderArgs'] return_headers: The list of response header rules for mirroring back-to-source return. See `return_header` below.
        """
        if return_headers is not None:
            pulumi.set(__self__, "return_headers", return_headers)

    @_builtins.property
    @pulumi.getter(name="returnHeaders")
    def return_headers(self) -> Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeadersReturnHeader']]:
        """
        The list of response header rules for mirroring back-to-source return. See `return_header` below.
        """
        return pulumi.get(self, "return_headers")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorReturnHeadersReturnHeader(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: Set the value of the Header to 1024 bytes at most. \\r\\n. It takes effect only when the RedirectType is set to Mirror.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Set the value of the Header to 1024 bytes at most. \\r\\n. It takes effect only when the RedirectType is set to Mirror.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorTaggings(dict):
    def __init__(__self__, *,
                 taggings: Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorTaggingsTagging']] = None):
        """
        :param Sequence['BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorTaggingsTaggingArgs'] taggings: Image back-to-source save label rule list See `taggings` below.
        """
        if taggings is not None:
            pulumi.set(__self__, "taggings", taggings)

    @_builtins.property
    @pulumi.getter
    def taggings(self) -> Optional[Sequence['outputs.BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorTaggingsTagging']]:
        """
        Image back-to-source save label rule list See `taggings` below.
        """
        return pulumi.get(self, "taggings")


@pulumi.output_type
class BucketWebsiteRoutingRulesRoutingRuleRedirectMirrorTaggingsTagging(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: Set the value of the Header to 1024 bytes at most. \\r\\n. It takes effect only when the RedirectType is set to Mirror.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Set the value of the Header to 1024 bytes at most. \\r\\n. It takes effect only when the RedirectType is set to Mirror.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetBucketObjectsObjectResult(dict):
    def __init__(__self__, *,
                 acl: _builtins.str,
                 cache_control: _builtins.str,
                 content_disposition: _builtins.str,
                 content_encoding: _builtins.str,
                 content_length: _builtins.str,
                 content_md5: _builtins.str,
                 content_type: _builtins.str,
                 etag: _builtins.str,
                 expires: _builtins.str,
                 key: _builtins.str,
                 last_modification_time: _builtins.str,
                 server_side_encryption: _builtins.str,
                 sse_kms_key_id: _builtins.str,
                 storage_class: _builtins.str):
        """
        :param _builtins.str acl: Object access control list. Possible values: `default`, `private`, `public-read` and `public-read-write`.
        :param _builtins.str cache_control: Caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param _builtins.str content_disposition: Presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param _builtins.str content_encoding: Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param _builtins.str content_length: Size of the object in bytes.
        :param _builtins.str content_md5: MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
        :param _builtins.str content_type: Standard MIME type describing the format of the object data, e.g. "application/octet-stream".
        :param _builtins.str etag: ETag generated for the object (MD5 sum of the object content).
        :param _builtins.str expires: Expiration date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        :param _builtins.str key: Object key.
        :param _builtins.str last_modification_time: Last modification time of the object.
        :param _builtins.str server_side_encryption: Server-side encryption of the object in OSS. It can be empty or `AES256`.
        :param _builtins.str sse_kms_key_id: If present, specifies the ID of the Key Management Service(KMS) master encryption key that was used for the object.
        :param _builtins.str storage_class: Object storage type. Possible values: `Standard`, `IA`, `Archive` and `ColdArchive`.
        """
        pulumi.set(__self__, "acl", acl)
        pulumi.set(__self__, "cache_control", cache_control)
        pulumi.set(__self__, "content_disposition", content_disposition)
        pulumi.set(__self__, "content_encoding", content_encoding)
        pulumi.set(__self__, "content_length", content_length)
        pulumi.set(__self__, "content_md5", content_md5)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "expires", expires)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "last_modification_time", last_modification_time)
        pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        pulumi.set(__self__, "sse_kms_key_id", sse_kms_key_id)
        pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> _builtins.str:
        """
        Object access control list. Possible values: `default`, `private`, `public-read` and `public-read-write`.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> _builtins.str:
        """
        Caching behavior along the request/reply chain. Read [RFC2616 Cache-Control](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "cache_control")

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> _builtins.str:
        """
        Presentational information for the object. Read [RFC2616 Content-Disposition](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "content_disposition")

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> _builtins.str:
        """
        Content encodings that have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Read [RFC2616 Content-Encoding](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "content_encoding")

    @_builtins.property
    @pulumi.getter(name="contentLength")
    def content_length(self) -> _builtins.str:
        """
        Size of the object in bytes.
        """
        return pulumi.get(self, "content_length")

    @_builtins.property
    @pulumi.getter(name="contentMd5")
    def content_md5(self) -> _builtins.str:
        """
        MD5 value of the content. Read [MD5](https://www.alibabacloud.com/help/doc-detail/31978.htm) for computing method.
        """
        return pulumi.get(self, "content_md5")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        Standard MIME type describing the format of the object data, e.g. "application/octet-stream".
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        ETag generated for the object (MD5 sum of the object content).
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def expires(self) -> _builtins.str:
        """
        Expiration date for the the request/response. Read [RFC2616 Expires](https://www.ietf.org/rfc/rfc2616.txt) for further details.
        """
        return pulumi.get(self, "expires")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Object key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="lastModificationTime")
    def last_modification_time(self) -> _builtins.str:
        """
        Last modification time of the object.
        """
        return pulumi.get(self, "last_modification_time")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> _builtins.str:
        """
        Server-side encryption of the object in OSS. It can be empty or `AES256`.
        """
        return pulumi.get(self, "server_side_encryption")

    @_builtins.property
    @pulumi.getter(name="sseKmsKeyId")
    def sse_kms_key_id(self) -> _builtins.str:
        """
        If present, specifies the ID of the Key Management Service(KMS) master encryption key that was used for the object.
        """
        return pulumi.get(self, "sse_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Object storage type. Possible values: `Standard`, `IA`, `Archive` and `ColdArchive`.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class GetBucketsBucketResult(dict):
    def __init__(__self__, *,
                 acl: _builtins.str,
                 cors_rules: Sequence['outputs.GetBucketsBucketCorsRuleResult'],
                 creation_date: _builtins.str,
                 extranet_endpoint: _builtins.str,
                 intranet_endpoint: _builtins.str,
                 lifecycle_rules: Sequence['outputs.GetBucketsBucketLifecycleRuleResult'],
                 location: _builtins.str,
                 logging: 'outputs.GetBucketsBucketLoggingResult',
                 name: _builtins.str,
                 owner: _builtins.str,
                 policy: _builtins.str,
                 redundancy_type: _builtins.str,
                 referer_config: 'outputs.GetBucketsBucketRefererConfigResult',
                 server_side_encryption_rule: 'outputs.GetBucketsBucketServerSideEncryptionRuleResult',
                 storage_class: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 versioning: 'outputs.GetBucketsBucketVersioningResult',
                 website: 'outputs.GetBucketsBucketWebsiteResult'):
        """
        :param _builtins.str acl: Bucket access control list. Possible values: `private`, `public-read` and `public-read-write`.
        :param Sequence['GetBucketsBucketCorsRuleArgs'] cors_rules: A list of CORS rule configurations. Each element contains the following attributes:
        :param _builtins.str creation_date: Bucket creation date.
        :param _builtins.str extranet_endpoint: Internet domain name for accessing the bucket from outside.
        :param _builtins.str intranet_endpoint: Intranet domain name for accessing the bucket from an ECS instance in the same region.
        :param Sequence['GetBucketsBucketLifecycleRuleArgs'] lifecycle_rules: A list CORS of lifecycle configurations. When Lifecycle is enabled, OSS automatically deletes the objects or transitions the objects (to another storage class) corresponding the lifecycle rules on a regular basis. Each element contains the following attributes:
        :param _builtins.str location: Region of the data center where the bucket is located.
        :param 'GetBucketsBucketLoggingArgs' logging: A list of one element containing configuration parameters used for storing access log information. It contains the following attributes:
        :param _builtins.str name: Bucket name.
        :param _builtins.str owner: Bucket owner.
        :param _builtins.str policy: The policies configured for a specified bucket.
        :param _builtins.str redundancy_type: Redundancy type. Possible values: `LRS`, and `ZRS`.
        :param 'GetBucketsBucketRefererConfigArgs' referer_config: A list of one element containing referer configuration. It contains the following attributes:
        :param 'GetBucketsBucketServerSideEncryptionRuleArgs' server_side_encryption_rule: A configuration of default encryption for a bucket. It contains the following attributes:
        :param _builtins.str storage_class: Object storage type. Possible values: `Standard`, `IA`, `Archive` and `ColdArchive`.
        :param Mapping[str, _builtins.str] tags: A mapping of tags.
        :param 'GetBucketsBucketVersioningArgs' versioning: If present , the versioning state has been set on the bucket. It contains the following attribute.
        :param 'GetBucketsBucketWebsiteArgs' website: A list of one element containing configuration parameters used when the bucket is used as a website. It contains the following attributes:
        """
        pulumi.set(__self__, "acl", acl)
        pulumi.set(__self__, "cors_rules", cors_rules)
        pulumi.set(__self__, "creation_date", creation_date)
        pulumi.set(__self__, "extranet_endpoint", extranet_endpoint)
        pulumi.set(__self__, "intranet_endpoint", intranet_endpoint)
        pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "logging", logging)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "redundancy_type", redundancy_type)
        pulumi.set(__self__, "referer_config", referer_config)
        pulumi.set(__self__, "server_side_encryption_rule", server_side_encryption_rule)
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "versioning", versioning)
        pulumi.set(__self__, "website", website)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> _builtins.str:
        """
        Bucket access control list. Possible values: `private`, `public-read` and `public-read-write`.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Sequence['outputs.GetBucketsBucketCorsRuleResult']:
        """
        A list of CORS rule configurations. Each element contains the following attributes:
        """
        return pulumi.get(self, "cors_rules")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> _builtins.str:
        """
        Bucket creation date.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter(name="extranetEndpoint")
    def extranet_endpoint(self) -> _builtins.str:
        """
        Internet domain name for accessing the bucket from outside.
        """
        return pulumi.get(self, "extranet_endpoint")

    @_builtins.property
    @pulumi.getter(name="intranetEndpoint")
    def intranet_endpoint(self) -> _builtins.str:
        """
        Intranet domain name for accessing the bucket from an ECS instance in the same region.
        """
        return pulumi.get(self, "intranet_endpoint")

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Sequence['outputs.GetBucketsBucketLifecycleRuleResult']:
        """
        A list CORS of lifecycle configurations. When Lifecycle is enabled, OSS automatically deletes the objects or transitions the objects (to another storage class) corresponding the lifecycle rules on a regular basis. Each element contains the following attributes:
        """
        return pulumi.get(self, "lifecycle_rules")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Region of the data center where the bucket is located.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> 'outputs.GetBucketsBucketLoggingResult':
        """
        A list of one element containing configuration parameters used for storing access log information. It contains the following attributes:
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Bucket name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        Bucket owner.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The policies configured for a specified bucket.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> _builtins.str:
        """
        Redundancy type. Possible values: `LRS`, and `ZRS`.
        """
        return pulumi.get(self, "redundancy_type")

    @_builtins.property
    @pulumi.getter(name="refererConfig")
    def referer_config(self) -> 'outputs.GetBucketsBucketRefererConfigResult':
        """
        A list of one element containing referer configuration. It contains the following attributes:
        """
        return pulumi.get(self, "referer_config")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionRule")
    def server_side_encryption_rule(self) -> 'outputs.GetBucketsBucketServerSideEncryptionRuleResult':
        """
        A configuration of default encryption for a bucket. It contains the following attributes:
        """
        return pulumi.get(self, "server_side_encryption_rule")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        Object storage type. Possible values: `Standard`, `IA`, `Archive` and `ColdArchive`.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> 'outputs.GetBucketsBucketVersioningResult':
        """
        If present , the versioning state has been set on the bucket. It contains the following attribute.
        """
        return pulumi.get(self, "versioning")

    @_builtins.property
    @pulumi.getter
    def website(self) -> 'outputs.GetBucketsBucketWebsiteResult':
        """
        A list of one element containing configuration parameters used when the bucket is used as a website. It contains the following attributes:
        """
        return pulumi.get(self, "website")


@pulumi.output_type
class GetBucketsBucketCorsRuleResult(dict):
    def __init__(__self__, *,
                 allowed_headers: Sequence[_builtins.str],
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 expose_headers: Sequence[_builtins.str],
                 max_age_seconds: _builtins.int):
        """
        :param Sequence[_builtins.str] allowed_headers: Control whether the headers specified by Access-Control-Request-Headers in the OPTIONS prefetch command are allowed. Each header specified by Access-Control-Request-Headers must match a value in AllowedHeader. Each rule allows up to one wildcard “*” .
        :param Sequence[_builtins.str] allowed_methods: Specify the allowed methods for cross-domain requests. Possible values: `GET`, `PUT`, `DELETE`, `POST` and `HEAD`.
        :param Sequence[_builtins.str] allowed_origins: The origins allowed for cross-domain requests. Multiple elements can be used to specify multiple allowed origins. Each rule allows up to one wildcard "\\*". If "\\*" is specified, cross-domain requests of all origins are allowed.
        :param Sequence[_builtins.str] expose_headers: Specify the response headers allowing users to access from an application (for example, a Javascript XMLHttpRequest object). The wildcard "\\*" is not allowed.
        :param _builtins.int max_age_seconds: Specify the cache time for the returned result of a browser prefetch (OPTIONS) request to a specific resource.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "expose_headers", expose_headers)
        pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[_builtins.str]:
        """
        Control whether the headers specified by Access-Control-Request-Headers in the OPTIONS prefetch command are allowed. Each header specified by Access-Control-Request-Headers must match a value in AllowedHeader. Each rule allows up to one wildcard “*” .
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        Specify the allowed methods for cross-domain requests. Possible values: `GET`, `PUT`, `DELETE`, `POST` and `HEAD`.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        The origins allowed for cross-domain requests. Multiple elements can be used to specify multiple allowed origins. Each rule allows up to one wildcard "\\*". If "\\*" is specified, cross-domain requests of all origins are allowed.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Sequence[_builtins.str]:
        """
        Specify the response headers allowing users to access from an application (for example, a Javascript XMLHttpRequest object). The wildcard "\\*" is not allowed.
        """
        return pulumi.get(self, "expose_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> _builtins.int:
        """
        Specify the cache time for the returned result of a browser prefetch (OPTIONS) request to a specific resource.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class GetBucketsBucketLifecycleRuleResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 expiration: 'outputs.GetBucketsBucketLifecycleRuleExpirationResult',
                 id: _builtins.str,
                 prefix: _builtins.str):
        """
        :param _builtins.bool enabled: Indicate whether the rule is enabled or not.
        :param 'GetBucketsBucketLifecycleRuleExpirationArgs' expiration: A list of one element containing expiration attributes of an object. It contains the following attributes:
        :param _builtins.str id: Unique ID of the rule.
        :param _builtins.str prefix: Prefix applicable to a rule. Only those objects with a matching prefix can be affected by the rule.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "expiration", expiration)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Indicate whether the rule is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> 'outputs.GetBucketsBucketLifecycleRuleExpirationResult':
        """
        A list of one element containing expiration attributes of an object. It contains the following attributes:
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique ID of the rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        Prefix applicable to a rule. Only those objects with a matching prefix can be affected by the rule.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetBucketsBucketLifecycleRuleExpirationResult(dict):
    def __init__(__self__, *,
                 date: _builtins.str,
                 days: _builtins.int):
        """
        :param _builtins.str date: Date after which the rule to take effect. The format is like 2017-03-09.
        :param _builtins.int days: Indicate the number of days after the last object update until the rules take effect.
        """
        pulumi.set(__self__, "date", date)
        pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def date(self) -> _builtins.str:
        """
        Date after which the rule to take effect. The format is like 2017-03-09.
        """
        return pulumi.get(self, "date")

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Indicate the number of days after the last object update until the rules take effect.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class GetBucketsBucketLoggingResult(dict):
    def __init__(__self__, *,
                 target_bucket: _builtins.str,
                 target_prefix: _builtins.str):
        """
        :param _builtins.str target_bucket: Bucket for storing access logs.
        :param _builtins.str target_prefix: Prefix of the saved access log file paths.
        """
        pulumi.set(__self__, "target_bucket", target_bucket)
        pulumi.set(__self__, "target_prefix", target_prefix)

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> _builtins.str:
        """
        Bucket for storing access logs.
        """
        return pulumi.get(self, "target_bucket")

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> _builtins.str:
        """
        Prefix of the saved access log file paths.
        """
        return pulumi.get(self, "target_prefix")


@pulumi.output_type
class GetBucketsBucketRefererConfigResult(dict):
    def __init__(__self__, *,
                 allow_empty: _builtins.bool,
                 referers: Sequence[_builtins.str]):
        """
        :param _builtins.bool allow_empty: Indicate whether the access request referer field can be empty.
        :param Sequence[_builtins.str] referers: Referer access whitelist.
        """
        pulumi.set(__self__, "allow_empty", allow_empty)
        pulumi.set(__self__, "referers", referers)

    @_builtins.property
    @pulumi.getter(name="allowEmpty")
    def allow_empty(self) -> _builtins.bool:
        """
        Indicate whether the access request referer field can be empty.
        """
        return pulumi.get(self, "allow_empty")

    @_builtins.property
    @pulumi.getter
    def referers(self) -> Sequence[_builtins.str]:
        """
        Referer access whitelist.
        """
        return pulumi.get(self, "referers")


@pulumi.output_type
class GetBucketsBucketServerSideEncryptionRuleResult(dict):
    def __init__(__self__, *,
                 kms_master_key_id: _builtins.str,
                 sse_algorithm: _builtins.str):
        """
        :param _builtins.str kms_master_key_id: The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
        :param _builtins.str sse_algorithm: The server-side encryption algorithm to use.
        """
        pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)

    @_builtins.property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> _builtins.str:
        """
        The alibaba cloud KMS master key ID used for the SSE-KMS encryption.
        """
        return pulumi.get(self, "kms_master_key_id")

    @_builtins.property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> _builtins.str:
        """
        The server-side encryption algorithm to use.
        """
        return pulumi.get(self, "sse_algorithm")


@pulumi.output_type
class GetBucketsBucketVersioningResult(dict):
    def __init__(__self__, *,
                 status: _builtins.str):
        """
        :param _builtins.str status: A bucket versioning state. Possible values:`Enabled` and `Suspended`.
        """
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        A bucket versioning state. Possible values:`Enabled` and `Suspended`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetBucketsBucketWebsiteResult(dict):
    def __init__(__self__, *,
                 error_document: _builtins.str,
                 index_document: _builtins.str):
        """
        :param _builtins.str error_document: Key of the HTML document containing the error page.
        :param _builtins.str index_document: Key of the HTML document containing the home page.
        """
        pulumi.set(__self__, "error_document", error_document)
        pulumi.set(__self__, "index_document", index_document)

    @_builtins.property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> _builtins.str:
        """
        Key of the HTML document containing the error page.
        """
        return pulumi.get(self, "error_document")

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> _builtins.str:
        """
        Key of the HTML document containing the home page.
        """
        return pulumi.get(self, "index_document")


@pulumi.output_type
class GetInstanceAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 domain: _builtins.str,
                 endpoint: _builtins.str,
                 id: _builtins.str,
                 instance_name: _builtins.str,
                 region: _builtins.str,
                 vpc_id: _builtins.str,
                 vpc_name: _builtins.str):
        """
        :param _builtins.str domain: The domain of the instance attachment.
        :param _builtins.str endpoint: The access endpoint of the instance attachment.
        :param _builtins.str id: The resource ID, the value is same as "instance_name".
        :param _builtins.str instance_name: The name of OTS instance.
        :param _builtins.str region: The region of the instance attachment.
        :param _builtins.str vpc_id: The ID of attaching VPC to instance.
        :param _builtins.str vpc_name: The name of attaching VPC to instance.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain of the instance attachment.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The access endpoint of the instance attachment.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The resource ID, the value is same as "instance_name".
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The name of OTS instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region of the instance attachment.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of attaching VPC to instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> _builtins.str:
        """
        The name of attaching VPC to instance.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 cluster_type: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 entity_quota: _builtins.int,
                 id: _builtins.str,
                 name: _builtins.str,
                 network: _builtins.str,
                 network_source_acls: Sequence[_builtins.str],
                 network_type_acls: Sequence[_builtins.str],
                 policy: _builtins.str,
                 policy_version: _builtins.int,
                 resource_group_id: _builtins.str,
                 status: _builtins.str,
                 table_quota: _builtins.int,
                 tags: Mapping[str, _builtins.str],
                 user_id: _builtins.str):
        """
        :param _builtins.str cluster_type: The cluster type of the instance. Possible values: `SSD`, `HYBRID`.
        :param _builtins.str create_time: The create time of the instance.
        :param _builtins.str description: The description of the instance.
        :param _builtins.int entity_quota: (Removed since v1.221.0) The instance quota which indicating the maximum number of tables.
        :param _builtins.str id: ID of the instance.
        :param _builtins.str name: Instance name.
        :param _builtins.str network: (Removed since v1.221.0) The network type of the instance. Possible values: `NORMAL`, `VPC`, `VPC_CONSOLE`.
        :param Sequence[_builtins.str] network_source_acls: (Available since v1.221.0) The set of request sources that are allowed access. Possible values: `TRUST_PROXY`.
        :param Sequence[_builtins.str] network_type_acls: (Available since v1.221.0) The set of network types that are allowed access. Possible values: `CLASSIC`, `VPC`, `INTERNET`.
        :param _builtins.str policy: (Available since v1.221.0) instance policy, json string.
        :param _builtins.int policy_version: (Available since v1.221.0) instance policy version.
        :param _builtins.str resource_group_id: (Available since v1.221.0) The resource group the instance belongs to.
        :param _builtins.str status: Instance status. Possible values: `Running`, `Disabled`, `Deleting`.
        :param _builtins.int table_quota: (Available since v1.221.0) The instance quota which indicating the maximum number of tables.
        :param Mapping[str, _builtins.str] tags: A map of tags assigned to the instance. It must be in the format:
               ```python
               import pulumi
               import pulumi_alicloud as alicloud
               
               instances_ds = alicloud.ots.get_instances(tags={
                   "tagKey1": "tagValue1",
                   "tagKey2": "tagValue2",
               })
               ```
        :param _builtins.str user_id: The user id of the instance.
        """
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "entity_quota", entity_quota)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "network_source_acls", network_source_acls)
        pulumi.set(__self__, "network_type_acls", network_type_acls)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "policy_version", policy_version)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "table_quota", table_quota)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> _builtins.str:
        """
        The cluster type of the instance. Possible values: `SSD`, `HYBRID`.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The create time of the instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entityQuota")
    def entity_quota(self) -> _builtins.int:
        """
        (Removed since v1.221.0) The instance quota which indicating the maximum number of tables.
        """
        return pulumi.get(self, "entity_quota")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        (Removed since v1.221.0) The network type of the instance. Possible values: `NORMAL`, `VPC`, `VPC_CONSOLE`.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="networkSourceAcls")
    def network_source_acls(self) -> Sequence[_builtins.str]:
        """
        (Available since v1.221.0) The set of request sources that are allowed access. Possible values: `TRUST_PROXY`.
        """
        return pulumi.get(self, "network_source_acls")

    @_builtins.property
    @pulumi.getter(name="networkTypeAcls")
    def network_type_acls(self) -> Sequence[_builtins.str]:
        """
        (Available since v1.221.0) The set of network types that are allowed access. Possible values: `CLASSIC`, `VPC`, `INTERNET`.
        """
        return pulumi.get(self, "network_type_acls")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        (Available since v1.221.0) instance policy, json string.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="policyVersion")
    def policy_version(self) -> _builtins.int:
        """
        (Available since v1.221.0) instance policy version.
        """
        return pulumi.get(self, "policy_version")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        (Available since v1.221.0) The resource group the instance belongs to.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Instance status. Possible values: `Running`, `Disabled`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tableQuota")
    def table_quota(self) -> _builtins.int:
        """
        (Available since v1.221.0) The instance quota which indicating the maximum number of tables.
        """
        return pulumi.get(self, "table_quota")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the instance. It must be in the format:
        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        instances_ds = alicloud.ots.get_instances(tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
        ```
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        The user id of the instance.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetTablesTableResult(dict):
    def __init__(__self__, *,
                 defined_columns: Sequence['outputs.GetTablesTableDefinedColumnResult'],
                 id: _builtins.str,
                 instance_name: _builtins.str,
                 max_version: _builtins.int,
                 primary_keys: Sequence['outputs.GetTablesTablePrimaryKeyResult'],
                 table_name: _builtins.str,
                 time_to_live: _builtins.int):
        """
        :param _builtins.str id: ID of the table. The value is `<instance_name>:<table_name>`.
        :param _builtins.str instance_name: The name of OTS instance.
        :param _builtins.int max_version: The maximum number of versions stored in this table.
        :param Sequence['GetTablesTablePrimaryKeyArgs'] primary_keys: The property of `TableMeta` which indicates the structure information of a table.
        :param _builtins.str table_name: The table name of the OTS which could not be changed.
        :param _builtins.int time_to_live: The retention time of data stored in this table.
        """
        pulumi.set(__self__, "defined_columns", defined_columns)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "max_version", max_version)
        pulumi.set(__self__, "primary_keys", primary_keys)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "time_to_live", time_to_live)

    @_builtins.property
    @pulumi.getter(name="definedColumns")
    def defined_columns(self) -> Sequence['outputs.GetTablesTableDefinedColumnResult']:
        return pulumi.get(self, "defined_columns")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the table. The value is `<instance_name>:<table_name>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The name of OTS instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="maxVersion")
    def max_version(self) -> _builtins.int:
        """
        The maximum number of versions stored in this table.
        """
        return pulumi.get(self, "max_version")

    @_builtins.property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Sequence['outputs.GetTablesTablePrimaryKeyResult']:
        """
        The property of `TableMeta` which indicates the structure information of a table.
        """
        return pulumi.get(self, "primary_keys")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> _builtins.str:
        """
        The table name of the OTS which could not be changed.
        """
        return pulumi.get(self, "table_name")

    @_builtins.property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> _builtins.int:
        """
        The retention time of data stored in this table.
        """
        return pulumi.get(self, "time_to_live")


@pulumi.output_type
class GetTablesTableDefinedColumnResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetTablesTablePrimaryKeyResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


