# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TableArgs', 'Table']

@pulumi.input_type
class TableArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[_builtins.str],
                 max_version: pulumi.Input[_builtins.int],
                 primary_keys: pulumi.Input[Sequence[pulumi.Input['TablePrimaryKeyArgs']]],
                 table_name: pulumi.Input[_builtins.str],
                 time_to_live: pulumi.Input[_builtins.int],
                 allow_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 defined_columns: Optional[pulumi.Input[Sequence[pulumi.Input['TableDefinedColumnArgs']]]] = None,
                 deviation_cell_version_in_sec: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_sse: Optional[pulumi.Input[_builtins.bool]] = None,
                 sse_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_role_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Table resource.
        :param pulumi.Input[_builtins.str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[_builtins.int] max_version: The maximum number of versions stored in this table. The valid value is 1-2147483647.
        :param pulumi.Input[Sequence[pulumi.Input['TablePrimaryKeyArgs']]] primary_keys: The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
        :param pulumi.Input[_builtins.str] table_name: The table name of the OTS instance. If changed, a new table would be created.
        :param pulumi.Input[_builtins.int] time_to_live: The retention time of data stored in this table (unit: second). The value maximum is 2147483647 and -1 means never expired.
        :param pulumi.Input[_builtins.bool] allow_update: Whether allow data update operations. Default value is true. Skipping the resource state refresh step may result in unnecessary execution plan when upgrading from an earlier version.
        :param pulumi.Input[Sequence[pulumi.Input['TableDefinedColumnArgs']]] defined_columns: The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
        :param pulumi.Input[_builtins.str] deviation_cell_version_in_sec: The max version offset of the table. The valid value is 1-9223372036854775807. Defaults to 86400.
        :param pulumi.Input[_builtins.bool] enable_sse: Whether enable OTS server side encryption. Default value is false.
        :param pulumi.Input[_builtins.str] sse_key_id: . The key ID of secret. `sse_key_id` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        :param pulumi.Input[_builtins.str] sse_key_type: The key type of OTS server side encryption. `SSE_KMS_SERVICE`, `SSE_BYOK` is allowed.
        :param pulumi.Input[_builtins.str] sse_role_arn: The arn of role that can access kms service. `sse_role_arn` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        """
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "max_version", max_version)
        pulumi.set(__self__, "primary_keys", primary_keys)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "time_to_live", time_to_live)
        if allow_update is not None:
            pulumi.set(__self__, "allow_update", allow_update)
        if defined_columns is not None:
            pulumi.set(__self__, "defined_columns", defined_columns)
        if deviation_cell_version_in_sec is not None:
            pulumi.set(__self__, "deviation_cell_version_in_sec", deviation_cell_version_in_sec)
        if enable_sse is not None:
            pulumi.set(__self__, "enable_sse", enable_sse)
        if sse_key_id is not None:
            pulumi.set(__self__, "sse_key_id", sse_key_id)
        if sse_key_type is not None:
            pulumi.set(__self__, "sse_key_type", sse_key_type)
        if sse_role_arn is not None:
            pulumi.set(__self__, "sse_role_arn", sse_role_arn)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the OTS instance in which table will located.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="maxVersion")
    def max_version(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum number of versions stored in this table. The valid value is 1-2147483647.
        """
        return pulumi.get(self, "max_version")

    @max_version.setter
    def max_version(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_version", value)

    @_builtins.property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> pulumi.Input[Sequence[pulumi.Input['TablePrimaryKeyArgs']]]:
        """
        The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
        """
        return pulumi.get(self, "primary_keys")

    @primary_keys.setter
    def primary_keys(self, value: pulumi.Input[Sequence[pulumi.Input['TablePrimaryKeyArgs']]]):
        pulumi.set(self, "primary_keys", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[_builtins.str]:
        """
        The table name of the OTS instance. If changed, a new table would be created.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table_name", value)

    @_builtins.property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> pulumi.Input[_builtins.int]:
        """
        The retention time of data stored in this table (unit: second). The value maximum is 2147483647 and -1 means never expired.
        """
        return pulumi.get(self, "time_to_live")

    @time_to_live.setter
    def time_to_live(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "time_to_live", value)

    @_builtins.property
    @pulumi.getter(name="allowUpdate")
    def allow_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether allow data update operations. Default value is true. Skipping the resource state refresh step may result in unnecessary execution plan when upgrading from an earlier version.
        """
        return pulumi.get(self, "allow_update")

    @allow_update.setter
    def allow_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_update", value)

    @_builtins.property
    @pulumi.getter(name="definedColumns")
    def defined_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableDefinedColumnArgs']]]]:
        """
        The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
        """
        return pulumi.get(self, "defined_columns")

    @defined_columns.setter
    def defined_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableDefinedColumnArgs']]]]):
        pulumi.set(self, "defined_columns", value)

    @_builtins.property
    @pulumi.getter(name="deviationCellVersionInSec")
    def deviation_cell_version_in_sec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The max version offset of the table. The valid value is 1-9223372036854775807. Defaults to 86400.
        """
        return pulumi.get(self, "deviation_cell_version_in_sec")

    @deviation_cell_version_in_sec.setter
    def deviation_cell_version_in_sec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deviation_cell_version_in_sec", value)

    @_builtins.property
    @pulumi.getter(name="enableSse")
    def enable_sse(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable OTS server side encryption. Default value is false.
        """
        return pulumi.get(self, "enable_sse")

    @enable_sse.setter
    def enable_sse(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_sse", value)

    @_builtins.property
    @pulumi.getter(name="sseKeyId")
    def sse_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . The key ID of secret. `sse_key_id` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        """
        return pulumi.get(self, "sse_key_id")

    @sse_key_id.setter
    def sse_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sse_key_id", value)

    @_builtins.property
    @pulumi.getter(name="sseKeyType")
    def sse_key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key type of OTS server side encryption. `SSE_KMS_SERVICE`, `SSE_BYOK` is allowed.
        """
        return pulumi.get(self, "sse_key_type")

    @sse_key_type.setter
    def sse_key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sse_key_type", value)

    @_builtins.property
    @pulumi.getter(name="sseRoleArn")
    def sse_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The arn of role that can access kms service. `sse_role_arn` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        """
        return pulumi.get(self, "sse_role_arn")

    @sse_role_arn.setter
    def sse_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sse_role_arn", value)


@pulumi.input_type
class _TableState:
    def __init__(__self__, *,
                 allow_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 defined_columns: Optional[pulumi.Input[Sequence[pulumi.Input['TableDefinedColumnArgs']]]] = None,
                 deviation_cell_version_in_sec: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_sse: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_version: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input['TablePrimaryKeyArgs']]]] = None,
                 sse_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_to_live: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Table resources.
        :param pulumi.Input[_builtins.bool] allow_update: Whether allow data update operations. Default value is true. Skipping the resource state refresh step may result in unnecessary execution plan when upgrading from an earlier version.
        :param pulumi.Input[Sequence[pulumi.Input['TableDefinedColumnArgs']]] defined_columns: The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
        :param pulumi.Input[_builtins.str] deviation_cell_version_in_sec: The max version offset of the table. The valid value is 1-9223372036854775807. Defaults to 86400.
        :param pulumi.Input[_builtins.bool] enable_sse: Whether enable OTS server side encryption. Default value is false.
        :param pulumi.Input[_builtins.str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[_builtins.int] max_version: The maximum number of versions stored in this table. The valid value is 1-2147483647.
        :param pulumi.Input[Sequence[pulumi.Input['TablePrimaryKeyArgs']]] primary_keys: The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
        :param pulumi.Input[_builtins.str] sse_key_id: . The key ID of secret. `sse_key_id` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        :param pulumi.Input[_builtins.str] sse_key_type: The key type of OTS server side encryption. `SSE_KMS_SERVICE`, `SSE_BYOK` is allowed.
        :param pulumi.Input[_builtins.str] sse_role_arn: The arn of role that can access kms service. `sse_role_arn` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        :param pulumi.Input[_builtins.str] table_name: The table name of the OTS instance. If changed, a new table would be created.
        :param pulumi.Input[_builtins.int] time_to_live: The retention time of data stored in this table (unit: second). The value maximum is 2147483647 and -1 means never expired.
        """
        if allow_update is not None:
            pulumi.set(__self__, "allow_update", allow_update)
        if defined_columns is not None:
            pulumi.set(__self__, "defined_columns", defined_columns)
        if deviation_cell_version_in_sec is not None:
            pulumi.set(__self__, "deviation_cell_version_in_sec", deviation_cell_version_in_sec)
        if enable_sse is not None:
            pulumi.set(__self__, "enable_sse", enable_sse)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if max_version is not None:
            pulumi.set(__self__, "max_version", max_version)
        if primary_keys is not None:
            pulumi.set(__self__, "primary_keys", primary_keys)
        if sse_key_id is not None:
            pulumi.set(__self__, "sse_key_id", sse_key_id)
        if sse_key_type is not None:
            pulumi.set(__self__, "sse_key_type", sse_key_type)
        if sse_role_arn is not None:
            pulumi.set(__self__, "sse_role_arn", sse_role_arn)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if time_to_live is not None:
            pulumi.set(__self__, "time_to_live", time_to_live)

    @_builtins.property
    @pulumi.getter(name="allowUpdate")
    def allow_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether allow data update operations. Default value is true. Skipping the resource state refresh step may result in unnecessary execution plan when upgrading from an earlier version.
        """
        return pulumi.get(self, "allow_update")

    @allow_update.setter
    def allow_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_update", value)

    @_builtins.property
    @pulumi.getter(name="definedColumns")
    def defined_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableDefinedColumnArgs']]]]:
        """
        The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
        """
        return pulumi.get(self, "defined_columns")

    @defined_columns.setter
    def defined_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableDefinedColumnArgs']]]]):
        pulumi.set(self, "defined_columns", value)

    @_builtins.property
    @pulumi.getter(name="deviationCellVersionInSec")
    def deviation_cell_version_in_sec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The max version offset of the table. The valid value is 1-9223372036854775807. Defaults to 86400.
        """
        return pulumi.get(self, "deviation_cell_version_in_sec")

    @deviation_cell_version_in_sec.setter
    def deviation_cell_version_in_sec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deviation_cell_version_in_sec", value)

    @_builtins.property
    @pulumi.getter(name="enableSse")
    def enable_sse(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable OTS server side encryption. Default value is false.
        """
        return pulumi.get(self, "enable_sse")

    @enable_sse.setter
    def enable_sse(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_sse", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OTS instance in which table will located.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="maxVersion")
    def max_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of versions stored in this table. The valid value is 1-2147483647.
        """
        return pulumi.get(self, "max_version")

    @max_version.setter
    def max_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_version", value)

    @_builtins.property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TablePrimaryKeyArgs']]]]:
        """
        The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
        """
        return pulumi.get(self, "primary_keys")

    @primary_keys.setter
    def primary_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TablePrimaryKeyArgs']]]]):
        pulumi.set(self, "primary_keys", value)

    @_builtins.property
    @pulumi.getter(name="sseKeyId")
    def sse_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . The key ID of secret. `sse_key_id` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        """
        return pulumi.get(self, "sse_key_id")

    @sse_key_id.setter
    def sse_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sse_key_id", value)

    @_builtins.property
    @pulumi.getter(name="sseKeyType")
    def sse_key_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key type of OTS server side encryption. `SSE_KMS_SERVICE`, `SSE_BYOK` is allowed.
        """
        return pulumi.get(self, "sse_key_type")

    @sse_key_type.setter
    def sse_key_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sse_key_type", value)

    @_builtins.property
    @pulumi.getter(name="sseRoleArn")
    def sse_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The arn of role that can access kms service. `sse_role_arn` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        """
        return pulumi.get(self, "sse_role_arn")

    @sse_role_arn.setter
    def sse_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sse_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The table name of the OTS instance. If changed, a new table would be created.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_name", value)

    @_builtins.property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The retention time of data stored in this table (unit: second). The value maximum is 2147483647 and -1 means never expired.
        """
        return pulumi.get(self, "time_to_live")

    @time_to_live.setter
    def time_to_live(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_to_live", value)


@pulumi.type_token("alicloud:ots/table:Table")
class Table(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 defined_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableDefinedColumnArgs', 'TableDefinedColumnArgsDict']]]]] = None,
                 deviation_cell_version_in_sec: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_sse: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_version: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TablePrimaryKeyArgs', 'TablePrimaryKeyArgsDict']]]]] = None,
                 sse_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_to_live: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides an OTS table resource.

        > **NOTE:** From Provider version 1.10.0, the provider field 'ots_instance_name' has been deprecated and
        you should use resource alicloud_ots_table's new field 'instance_name' and 'table_name' to re-import this resource.

        > **NOTE:** Available since v1.9.2.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_instance = alicloud.ots.Instance("default",
            name=f"{name}-{default['result']}",
            description=name,
            accessed_by="Any",
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_table = alicloud.ots.Table("default",
            instance_name=default_instance.name,
            table_name="tf_example",
            time_to_live=-1,
            max_version=1,
            enable_sse=True,
            sse_key_type="SSE_KMS_SERVICE",
            primary_keys=[
                {
                    "name": "pk1",
                    "type": "Integer",
                },
                {
                    "name": "pk2",
                    "type": "String",
                },
                {
                    "name": "pk3",
                    "type": "Binary",
                },
            ],
            defined_columns=[
                {
                    "name": "col1",
                    "type": "Integer",
                },
                {
                    "name": "col2",
                    "type": "String",
                },
                {
                    "name": "col3",
                    "type": "Binary",
                },
            ])
        ```

        ## Import

        OTS table can be imported using id, e.g.

        ```sh
        $ pulumi import alicloud:ots/table:Table table my-ots:ots_table
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_update: Whether allow data update operations. Default value is true. Skipping the resource state refresh step may result in unnecessary execution plan when upgrading from an earlier version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableDefinedColumnArgs', 'TableDefinedColumnArgsDict']]]] defined_columns: The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
        :param pulumi.Input[_builtins.str] deviation_cell_version_in_sec: The max version offset of the table. The valid value is 1-9223372036854775807. Defaults to 86400.
        :param pulumi.Input[_builtins.bool] enable_sse: Whether enable OTS server side encryption. Default value is false.
        :param pulumi.Input[_builtins.str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[_builtins.int] max_version: The maximum number of versions stored in this table. The valid value is 1-2147483647.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TablePrimaryKeyArgs', 'TablePrimaryKeyArgsDict']]]] primary_keys: The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
        :param pulumi.Input[_builtins.str] sse_key_id: . The key ID of secret. `sse_key_id` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        :param pulumi.Input[_builtins.str] sse_key_type: The key type of OTS server side encryption. `SSE_KMS_SERVICE`, `SSE_BYOK` is allowed.
        :param pulumi.Input[_builtins.str] sse_role_arn: The arn of role that can access kms service. `sse_role_arn` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        :param pulumi.Input[_builtins.str] table_name: The table name of the OTS instance. If changed, a new table would be created.
        :param pulumi.Input[_builtins.int] time_to_live: The retention time of data stored in this table (unit: second). The value maximum is 2147483647 and -1 means never expired.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an OTS table resource.

        > **NOTE:** From Provider version 1.10.0, the provider field 'ots_instance_name' has been deprecated and
        you should use resource alicloud_ots_table's new field 'instance_name' and 'table_name' to re-import this resource.

        > **NOTE:** Available since v1.9.2.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_instance = alicloud.ots.Instance("default",
            name=f"{name}-{default['result']}",
            description=name,
            accessed_by="Any",
            tags={
                "Created": "TF",
                "For": "example",
            })
        default_table = alicloud.ots.Table("default",
            instance_name=default_instance.name,
            table_name="tf_example",
            time_to_live=-1,
            max_version=1,
            enable_sse=True,
            sse_key_type="SSE_KMS_SERVICE",
            primary_keys=[
                {
                    "name": "pk1",
                    "type": "Integer",
                },
                {
                    "name": "pk2",
                    "type": "String",
                },
                {
                    "name": "pk3",
                    "type": "Binary",
                },
            ],
            defined_columns=[
                {
                    "name": "col1",
                    "type": "Integer",
                },
                {
                    "name": "col2",
                    "type": "String",
                },
                {
                    "name": "col3",
                    "type": "Binary",
                },
            ])
        ```

        ## Import

        OTS table can be imported using id, e.g.

        ```sh
        $ pulumi import alicloud:ots/table:Table table my-ots:ots_table
        ```

        :param str resource_name: The name of the resource.
        :param TableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 defined_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableDefinedColumnArgs', 'TableDefinedColumnArgsDict']]]]] = None,
                 deviation_cell_version_in_sec: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_sse: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_version: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TablePrimaryKeyArgs', 'TablePrimaryKeyArgsDict']]]]] = None,
                 sse_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                 sse_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_to_live: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableArgs.__new__(TableArgs)

            __props__.__dict__["allow_update"] = allow_update
            __props__.__dict__["defined_columns"] = defined_columns
            __props__.__dict__["deviation_cell_version_in_sec"] = deviation_cell_version_in_sec
            __props__.__dict__["enable_sse"] = enable_sse
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            if max_version is None and not opts.urn:
                raise TypeError("Missing required property 'max_version'")
            __props__.__dict__["max_version"] = max_version
            if primary_keys is None and not opts.urn:
                raise TypeError("Missing required property 'primary_keys'")
            __props__.__dict__["primary_keys"] = primary_keys
            __props__.__dict__["sse_key_id"] = sse_key_id
            __props__.__dict__["sse_key_type"] = sse_key_type
            __props__.__dict__["sse_role_arn"] = sse_role_arn
            if table_name is None and not opts.urn:
                raise TypeError("Missing required property 'table_name'")
            __props__.__dict__["table_name"] = table_name
            if time_to_live is None and not opts.urn:
                raise TypeError("Missing required property 'time_to_live'")
            __props__.__dict__["time_to_live"] = time_to_live
        super(Table, __self__).__init__(
            'alicloud:ots/table:Table',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_update: Optional[pulumi.Input[_builtins.bool]] = None,
            defined_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableDefinedColumnArgs', 'TableDefinedColumnArgsDict']]]]] = None,
            deviation_cell_version_in_sec: Optional[pulumi.Input[_builtins.str]] = None,
            enable_sse: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            max_version: Optional[pulumi.Input[_builtins.int]] = None,
            primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TablePrimaryKeyArgs', 'TablePrimaryKeyArgsDict']]]]] = None,
            sse_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            sse_key_type: Optional[pulumi.Input[_builtins.str]] = None,
            sse_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            table_name: Optional[pulumi.Input[_builtins.str]] = None,
            time_to_live: Optional[pulumi.Input[_builtins.int]] = None) -> 'Table':
        """
        Get an existing Table resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_update: Whether allow data update operations. Default value is true. Skipping the resource state refresh step may result in unnecessary execution plan when upgrading from an earlier version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableDefinedColumnArgs', 'TableDefinedColumnArgsDict']]]] defined_columns: The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
        :param pulumi.Input[_builtins.str] deviation_cell_version_in_sec: The max version offset of the table. The valid value is 1-9223372036854775807. Defaults to 86400.
        :param pulumi.Input[_builtins.bool] enable_sse: Whether enable OTS server side encryption. Default value is false.
        :param pulumi.Input[_builtins.str] instance_name: The name of the OTS instance in which table will located.
        :param pulumi.Input[_builtins.int] max_version: The maximum number of versions stored in this table. The valid value is 1-2147483647.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TablePrimaryKeyArgs', 'TablePrimaryKeyArgsDict']]]] primary_keys: The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
        :param pulumi.Input[_builtins.str] sse_key_id: . The key ID of secret. `sse_key_id` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        :param pulumi.Input[_builtins.str] sse_key_type: The key type of OTS server side encryption. `SSE_KMS_SERVICE`, `SSE_BYOK` is allowed.
        :param pulumi.Input[_builtins.str] sse_role_arn: The arn of role that can access kms service. `sse_role_arn` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        :param pulumi.Input[_builtins.str] table_name: The table name of the OTS instance. If changed, a new table would be created.
        :param pulumi.Input[_builtins.int] time_to_live: The retention time of data stored in this table (unit: second). The value maximum is 2147483647 and -1 means never expired.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableState.__new__(_TableState)

        __props__.__dict__["allow_update"] = allow_update
        __props__.__dict__["defined_columns"] = defined_columns
        __props__.__dict__["deviation_cell_version_in_sec"] = deviation_cell_version_in_sec
        __props__.__dict__["enable_sse"] = enable_sse
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["max_version"] = max_version
        __props__.__dict__["primary_keys"] = primary_keys
        __props__.__dict__["sse_key_id"] = sse_key_id
        __props__.__dict__["sse_key_type"] = sse_key_type
        __props__.__dict__["sse_role_arn"] = sse_role_arn
        __props__.__dict__["table_name"] = table_name
        __props__.__dict__["time_to_live"] = time_to_live
        return Table(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowUpdate")
    def allow_update(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether allow data update operations. Default value is true. Skipping the resource state refresh step may result in unnecessary execution plan when upgrading from an earlier version.
        """
        return pulumi.get(self, "allow_update")

    @_builtins.property
    @pulumi.getter(name="definedColumns")
    def defined_columns(self) -> pulumi.Output[Optional[Sequence['outputs.TableDefinedColumn']]]:
        """
        The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
        """
        return pulumi.get(self, "defined_columns")

    @_builtins.property
    @pulumi.getter(name="deviationCellVersionInSec")
    def deviation_cell_version_in_sec(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The max version offset of the table. The valid value is 1-9223372036854775807. Defaults to 86400.
        """
        return pulumi.get(self, "deviation_cell_version_in_sec")

    @_builtins.property
    @pulumi.getter(name="enableSse")
    def enable_sse(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether enable OTS server side encryption. Default value is false.
        """
        return pulumi.get(self, "enable_sse")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OTS instance in which table will located.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="maxVersion")
    def max_version(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of versions stored in this table. The valid value is 1-2147483647.
        """
        return pulumi.get(self, "max_version")

    @_builtins.property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> pulumi.Output[Sequence['outputs.TablePrimaryKey']]:
        """
        The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
        """
        return pulumi.get(self, "primary_keys")

    @_builtins.property
    @pulumi.getter(name="sseKeyId")
    def sse_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        . The key ID of secret. `sse_key_id` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        """
        return pulumi.get(self, "sse_key_id")

    @_builtins.property
    @pulumi.getter(name="sseKeyType")
    def sse_key_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key type of OTS server side encryption. `SSE_KMS_SERVICE`, `SSE_BYOK` is allowed.
        """
        return pulumi.get(self, "sse_key_type")

    @_builtins.property
    @pulumi.getter(name="sseRoleArn")
    def sse_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The arn of role that can access kms service. `sse_role_arn` is valid only when `sse_key_type` is set to `SSE_BYOK`.
        """
        return pulumi.get(self, "sse_role_arn")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[_builtins.str]:
        """
        The table name of the OTS instance. If changed, a new table would be created.
        """
        return pulumi.get(self, "table_name")

    @_builtins.property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> pulumi.Output[_builtins.int]:
        """
        The retention time of data stored in this table (unit: second). The value maximum is 2147483647 and -1 means never expired.
        """
        return pulumi.get(self, "time_to_live")

