# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FlowPipelineArgs', 'FlowPipeline']

@pulumi.input_type
class FlowPipelineArgs:
    def __init__(__self__, *,
                 manifest: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a FlowPipeline resource.
        :param pulumi.Input[_builtins.str] manifest: The pipeline definition. For more information, see the sample pipeline definition).
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        pulumi.set(__self__, "manifest", manifest)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def manifest(self) -> pulumi.Input[_builtins.str]:
        """
        The pipeline definition. For more information, see the sample pipeline definition).
        """
        return pulumi.get(self, "manifest")

    @manifest.setter
    def manifest(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "manifest", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _FlowPipelineState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 manifest: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlowPipeline resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] manifest: The pipeline definition. For more information, see the sample pipeline definition).
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if manifest is not None:
            pulumi.set(__self__, "manifest", manifest)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def manifest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pipeline definition. For more information, see the sample pipeline definition).
        """
        return pulumi.get(self, "manifest")

    @manifest.setter
    def manifest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manifest", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("alicloud:pai/flowPipeline:FlowPipeline")
class FlowPipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 manifest: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Pai Flow Pipeline resource.

        For information about Pai Flow Pipeline and how to use it, see [What is Pipeline](https://www.alibabacloud.com/help/en/pai/developer-reference/api-paiflow-2021-02-02-createpipeline).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.get_account()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_wj_qd1e = alicloud.pai.WorkspaceWorkspace("defaultWjQD1e",
            description=name,
            display_name=name,
            workspace_name=name,
            env_types=["dev"])
        default_flow_pipeline = alicloud.pai.FlowPipeline("default",
            workspace_id=default_wj_qd1e.id,
            manifest=f\"\"\"apiVersion: \\"core/v1\\"
        metadata:
          provider: \\"{default.id}\\"
          version: \\"v1\\"
          identifier: \\"my_pipeline\\"
          name: \\"source-transform\\"
          uuid: \\"terraformuuid{default_integer["result"]}\\"
          annotations: {{}}
          labels: {{}}
        spec:
          inputs:
            artifacts: []
            parameters:
            - name: \\"execution_maxcompute\\"
              type: \\"Map\\"
              value:
                spec:
                  endpoint: \\"http://service.cn.maxcompute.aliyun-inc.com/api\\"
                  odpsProject: \\"test_i****\\"
          outputs:
            artifacts: []
            parameters: []
          arguments:
            artifacts: []
            parameters: []
          dependencies: []
          initContainers: []
          sideCarContainers: []
          pipelines:
          - apiVersion: \\"core/v1\\"
            metadata:
              provider: \\"pai\\"
              version: \\"v1\\"
              identifier: \\"data_source\\"
              name: \\"data-source\\"
              uuid: \\"2ftahdnzcod2rt6u9q\\"
              displayName: \\"读数据表-1\\"
              annotations: {{}}
              labels: {{}}
            spec:
              inputs:
                artifacts: []
                parameters: []
              outputs:
                artifacts: []
                parameters: []
              arguments:
                artifacts: []
                parameters:
                - name: \\"inputTableName\\"
                  value: \\"pai_online_project.wumai_data\\"
                - name: \\"execution\\"
                  from: \\"{{{{inputs.parameters.execution_maxcompute}}}}\\"
              dependencies: []
              initContainers: []
              sideCarContainers: []
              pipelines: []
              volumes: []
          - apiVersion: \\"core/v1\\"
            metadata:
              provider: \\"pai\\"
              version: \\"v1\\"
              identifier: \\"type_transform\\"
              name: \\"type-transform\\"
              uuid: \\"gacnnnl4ksvbabfh6l\\"
              displayName: \\"类型转换-1\\"
              annotations: {{}}
              labels: {{}}
            spec:
              inputs:
                artifacts: []
                parameters: []
              outputs:
                artifacts: []
                parameters: []
              arguments:
                artifacts:
                - name: \\"inputTable\\"
                  from: \\"{{{{pipelines.data_source.outputs.artifacts.outputTable}}}}\\"
                parameters:
                - name: \\"cols_to_double\\"
                  value: \\"time,hour,pm2,pm10,so2,co,no2\\"
                - name: \\"execution\\"
                  from: \\"{{{{inputs.parameters.execution_maxcompute}}}}\\"
              dependencies:
              - \\"data_source\\"
              initContainers: []
              sideCarContainers: []
              pipelines: []
              volumes: []
          volumes: []
        \"\"\")
        ```

        ## Import

        Pai Flow Pipeline can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/flowPipeline:FlowPipeline example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] manifest: The pipeline definition. For more information, see the sample pipeline definition).
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlowPipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Pai Flow Pipeline resource.

        For information about Pai Flow Pipeline and how to use it, see [What is Pipeline](https://www.alibabacloud.com/help/en/pai/developer-reference/api-paiflow-2021-02-02-createpipeline).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.get_account()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_wj_qd1e = alicloud.pai.WorkspaceWorkspace("defaultWjQD1e",
            description=name,
            display_name=name,
            workspace_name=name,
            env_types=["dev"])
        default_flow_pipeline = alicloud.pai.FlowPipeline("default",
            workspace_id=default_wj_qd1e.id,
            manifest=f\"\"\"apiVersion: \\"core/v1\\"
        metadata:
          provider: \\"{default.id}\\"
          version: \\"v1\\"
          identifier: \\"my_pipeline\\"
          name: \\"source-transform\\"
          uuid: \\"terraformuuid{default_integer["result"]}\\"
          annotations: {{}}
          labels: {{}}
        spec:
          inputs:
            artifacts: []
            parameters:
            - name: \\"execution_maxcompute\\"
              type: \\"Map\\"
              value:
                spec:
                  endpoint: \\"http://service.cn.maxcompute.aliyun-inc.com/api\\"
                  odpsProject: \\"test_i****\\"
          outputs:
            artifacts: []
            parameters: []
          arguments:
            artifacts: []
            parameters: []
          dependencies: []
          initContainers: []
          sideCarContainers: []
          pipelines:
          - apiVersion: \\"core/v1\\"
            metadata:
              provider: \\"pai\\"
              version: \\"v1\\"
              identifier: \\"data_source\\"
              name: \\"data-source\\"
              uuid: \\"2ftahdnzcod2rt6u9q\\"
              displayName: \\"读数据表-1\\"
              annotations: {{}}
              labels: {{}}
            spec:
              inputs:
                artifacts: []
                parameters: []
              outputs:
                artifacts: []
                parameters: []
              arguments:
                artifacts: []
                parameters:
                - name: \\"inputTableName\\"
                  value: \\"pai_online_project.wumai_data\\"
                - name: \\"execution\\"
                  from: \\"{{{{inputs.parameters.execution_maxcompute}}}}\\"
              dependencies: []
              initContainers: []
              sideCarContainers: []
              pipelines: []
              volumes: []
          - apiVersion: \\"core/v1\\"
            metadata:
              provider: \\"pai\\"
              version: \\"v1\\"
              identifier: \\"type_transform\\"
              name: \\"type-transform\\"
              uuid: \\"gacnnnl4ksvbabfh6l\\"
              displayName: \\"类型转换-1\\"
              annotations: {{}}
              labels: {{}}
            spec:
              inputs:
                artifacts: []
                parameters: []
              outputs:
                artifacts: []
                parameters: []
              arguments:
                artifacts:
                - name: \\"inputTable\\"
                  from: \\"{{{{pipelines.data_source.outputs.artifacts.outputTable}}}}\\"
                parameters:
                - name: \\"cols_to_double\\"
                  value: \\"time,hour,pm2,pm10,so2,co,no2\\"
                - name: \\"execution\\"
                  from: \\"{{{{inputs.parameters.execution_maxcompute}}}}\\"
              dependencies:
              - \\"data_source\\"
              initContainers: []
              sideCarContainers: []
              pipelines: []
              volumes: []
          volumes: []
        \"\"\")
        ```

        ## Import

        Pai Flow Pipeline can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/flowPipeline:FlowPipeline example <id>
        ```

        :param str resource_name: The name of the resource.
        :param FlowPipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowPipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 manifest: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowPipelineArgs.__new__(FlowPipelineArgs)

            if manifest is None and not opts.urn:
                raise TypeError("Missing required property 'manifest'")
            __props__.__dict__["manifest"] = manifest
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["create_time"] = None
        super(FlowPipeline, __self__).__init__(
            'alicloud:pai/flowPipeline:FlowPipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            manifest: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlowPipeline':
        """
        Get an existing FlowPipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] manifest: The pipeline definition. For more information, see the sample pipeline definition).
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlowPipelineState.__new__(_FlowPipelineState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["manifest"] = manifest
        __props__.__dict__["workspace_id"] = workspace_id
        return FlowPipeline(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def manifest(self) -> pulumi.Output[_builtins.str]:
        """
        The pipeline definition. For more information, see the sample pipeline definition).
        """
        return pulumi.get(self, "manifest")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

