# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ZonalAccountArgs', 'ZonalAccount']

@pulumi.input_type
class ZonalAccountArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 db_cluster_id: pulumi.Input[_builtins.str],
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ZonalAccount resource.
        :param pulumi.Input[_builtins.str] account_name: Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster in which account belongs.
        :param pulumi.Input[_builtins.str] account_description: Account description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
        :param pulumi.Input[_builtins.str] account_password: Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters.
        :param pulumi.Input[_builtins.str] account_type: Account type, Valid values are `Normal`, `Super`, Default to `Normal`.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if account_description is not None:
            pulumi.set(__self__, "account_description", account_description)
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Id of cluster in which account belongs.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
        """
        return pulumi.get(self, "account_description")

    @account_description.setter
    def account_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_description", value)

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters.
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_password", value)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account type, Valid values are `Normal`, `Super`, Default to `Normal`.
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)


@pulumi.input_type
class _ZonalAccountState:
    def __init__(__self__, *,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZonalAccount resources.
        :param pulumi.Input[_builtins.str] account_description: Account description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
        :param pulumi.Input[_builtins.str] account_name: Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
        :param pulumi.Input[_builtins.str] account_password: Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters.
        :param pulumi.Input[_builtins.str] account_type: Account type, Valid values are `Normal`, `Super`, Default to `Normal`.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster in which account belongs.
        """
        if account_description is not None:
            pulumi.set(__self__, "account_description", account_description)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if account_type is not None:
            pulumi.set(__self__, "account_type", account_type)
        if db_cluster_id is not None:
            pulumi.set(__self__, "db_cluster_id", db_cluster_id)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
        """
        return pulumi.get(self, "account_description")

    @account_description.setter
    def account_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_description", value)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters.
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_password", value)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account type, Valid values are `Normal`, `Super`, Default to `Normal`.
        """
        return pulumi.get(self, "account_type")

    @account_type.setter
    def account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_type", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of cluster in which account belongs.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_id", value)


@pulumi.type_token("alicloud:polardb/zonalAccount:ZonalAccount")
class ZonalAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PolarDB Zonal account resource and used to manage databases.

        > **NOTE:** Available since v1.262.0.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        # The advanced configuration for all nodes in the cluster except for the RW node, including db_node_class, hot_replica_mode, and imci_switch properties.
        db_cluster_nodes_configs = config.get_object("dbClusterNodesConfigs")
        if db_cluster_nodes_configs is None:
            db_cluster_nodes_configs = {
                "db_node_1": {
                    "dbNodeClass": "polar.mysql.x4.medium.c",
                    "dbNodeRole": "Writer",
                    "hotReplicaMode": None,
                    "imciSwitch": None,
                },
            }
        default = alicloud.ens.Network("default",
            network_name="terraform-example",
            description="LoadBalancerNetworkDescription_test",
            cidr_block="192.168.2.0/24",
            ens_region_id="tr-Istanbul-1")
        default_vswitch = alicloud.ens.Vswitch("default",
            description="LoadBalancerVSwitchDescription_test",
            cidr_block="192.168.2.0/24",
            vswitch_name="terraform-example",
            ens_region_id="tr-Istanbul-1",
            network_id=default.id)
        default_zonal_db_cluster = alicloud.polardb.ZonalDbCluster("default",
            db_node_class="polar.mysql.x4.medium.c",
            description="terraform-example",
            ens_region_id="tr-Istanbul-1",
            vpc_id=default.id,
            vswitch_id=default_vswitch.id,
            db_cluster_nodes_configs={node: json.dumps({k: v for k, v in config if v != None}) for node, config in db_cluster_nodes_configs})
        default_zonal_account = alicloud.polardb.ZonalAccount("default",
            db_cluster_id=default_zonal_db_cluster.id,
            account_name="terraform_example",
            account_password="Example1234")
        ```

        ## Import

        PolarDB Zonal account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/zonalAccount:ZonalAccount example "pc-12345:tf_account"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_description: Account description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
        :param pulumi.Input[_builtins.str] account_name: Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
        :param pulumi.Input[_builtins.str] account_password: Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters.
        :param pulumi.Input[_builtins.str] account_type: Account type, Valid values are `Normal`, `Super`, Default to `Normal`.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster in which account belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZonalAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PolarDB Zonal account resource and used to manage databases.

        > **NOTE:** Available since v1.262.0.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        # The advanced configuration for all nodes in the cluster except for the RW node, including db_node_class, hot_replica_mode, and imci_switch properties.
        db_cluster_nodes_configs = config.get_object("dbClusterNodesConfigs")
        if db_cluster_nodes_configs is None:
            db_cluster_nodes_configs = {
                "db_node_1": {
                    "dbNodeClass": "polar.mysql.x4.medium.c",
                    "dbNodeRole": "Writer",
                    "hotReplicaMode": None,
                    "imciSwitch": None,
                },
            }
        default = alicloud.ens.Network("default",
            network_name="terraform-example",
            description="LoadBalancerNetworkDescription_test",
            cidr_block="192.168.2.0/24",
            ens_region_id="tr-Istanbul-1")
        default_vswitch = alicloud.ens.Vswitch("default",
            description="LoadBalancerVSwitchDescription_test",
            cidr_block="192.168.2.0/24",
            vswitch_name="terraform-example",
            ens_region_id="tr-Istanbul-1",
            network_id=default.id)
        default_zonal_db_cluster = alicloud.polardb.ZonalDbCluster("default",
            db_node_class="polar.mysql.x4.medium.c",
            description="terraform-example",
            ens_region_id="tr-Istanbul-1",
            vpc_id=default.id,
            vswitch_id=default_vswitch.id,
            db_cluster_nodes_configs={node: json.dumps({k: v for k, v in config if v != None}) for node, config in db_cluster_nodes_configs})
        default_zonal_account = alicloud.polardb.ZonalAccount("default",
            db_cluster_id=default_zonal_db_cluster.id,
            account_name="terraform_example",
            account_password="Example1234")
        ```

        ## Import

        PolarDB Zonal account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/zonalAccount:ZonalAccount example "pc-12345:tf_account"
        ```

        :param str resource_name: The name of the resource.
        :param ZonalAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZonalAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_description: Optional[pulumi.Input[_builtins.str]] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 account_password: Optional[pulumi.Input[_builtins.str]] = None,
                 account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZonalAccountArgs.__new__(ZonalAccountArgs)

            __props__.__dict__["account_description"] = account_description
            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["account_password"] = None if account_password is None else pulumi.Output.secret(account_password)
            __props__.__dict__["account_type"] = account_type
            if db_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_id'")
            __props__.__dict__["db_cluster_id"] = db_cluster_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accountPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ZonalAccount, __self__).__init__(
            'alicloud:polardb/zonalAccount:ZonalAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_description: Optional[pulumi.Input[_builtins.str]] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            account_password: Optional[pulumi.Input[_builtins.str]] = None,
            account_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ZonalAccount':
        """
        Get an existing ZonalAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_description: Account description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
        :param pulumi.Input[_builtins.str] account_name: Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
        :param pulumi.Input[_builtins.str] account_password: Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters.
        :param pulumi.Input[_builtins.str] account_type: Account type, Valid values are `Normal`, `Super`, Default to `Normal`.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster in which account belongs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZonalAccountState.__new__(_ZonalAccountState)

        __props__.__dict__["account_description"] = account_description
        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["account_password"] = account_password
        __props__.__dict__["account_type"] = account_type
        __props__.__dict__["db_cluster_id"] = db_cluster_id
        return ZonalAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Account description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
        """
        return pulumi.get(self, "account_description")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Output[_builtins.str]:
        """
        Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters.
        """
        return pulumi.get(self, "account_password")

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> pulumi.Output[_builtins.str]:
        """
        Account type, Valid values are `Normal`, `Super`, Default to `Normal`.
        """
        return pulumi.get(self, "account_type")

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of cluster in which account belongs.
        """
        return pulumi.get(self, "db_cluster_id")

