# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ZonalDbClusterArgs', 'ZonalDbCluster']

@pulumi.input_type
class ZonalDbClusterArgs:
    def __init__(__self__, *,
                 db_cluster_nodes_configs: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 db_node_class: pulumi.Input[_builtins.str],
                 ens_region_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_category: Optional[pulumi.Input[_builtins.str]] = None,
                 db_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 db_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ZonalDbCluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_configs: Map of node needs to be created after DB cluster was launched.
        :param pulumi.Input[_builtins.str] db_node_class: The db_node_class of cluster node.Only effective when the cluster is created for the first time. After the cluster is started, the cluster specification is maintained through the node class.
        :param pulumi.Input[_builtins.str] ens_region_id: The Zone to launch the DB cluster.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the ENS VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The ENS virtual switch ID to launch DB instances in one VPC.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        :param pulumi.Input[_builtins.str] cluster_version: current DB Cluster revision Version.
        :param pulumi.Input[_builtins.str] creation_category: The edition of the PolarDB service. Valid values are `SENormal`.
        :param pulumi.Input[_builtins.str] db_minor_version: Database minor version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBMinorVersion`. This parameter takes effect only when `db_type` is MySQL and `db_version` is 8.0.
        :param pulumi.Input[_builtins.str] db_type: Database type. Value options: MySQL, Oracle, PostgreSQL.
        :param pulumi.Input[_builtins.str] db_version: Database version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBVersion`.
        :param pulumi.Input[_builtins.str] description: The description of cluster.
        :param pulumi.Input[_builtins.str] pay_type: Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        :param pulumi.Input[_builtins.str] renewal_status: Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        :param pulumi.Input[_builtins.int] storage_space: Storage space charged by space (monthly package). Unit: GB.
               > **NOTE:**  Valid values for PolarDB for MySQL Standard Edition: 20 to 32000. It is valid when pay_type are `PrePaid` ,`PostPaid`.
        :param pulumi.Input[_builtins.str] storage_type: The storage type of the cluster. Valid values are `ESSDPL1`, `ESSDPL0`.
        :param pulumi.Input[_builtins.str] target_minor_version: The Version Code of the target version, whose parameter values can be obtained from the [DescribeDBClusterVersionZonal](https://www.alibabacloud.com/help/en/polardb/api-polardb-2017-08-01-describedbclusterversionzonal) interface.
        :param pulumi.Input[_builtins.int] used_time: The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to `PostPaid`. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
        """
        pulumi.set(__self__, "db_cluster_nodes_configs", db_cluster_nodes_configs)
        pulumi.set(__self__, "db_node_class", db_node_class)
        pulumi.set(__self__, "ens_region_id", ens_region_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if creation_category is not None:
            pulumi.set(__self__, "creation_category", creation_category)
        if db_minor_version is not None:
            pulumi.set(__self__, "db_minor_version", db_minor_version)
        if db_type is not None:
            pulumi.set(__self__, "db_type", db_type)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if pay_type is not None:
            pulumi.set(__self__, "pay_type", pay_type)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if target_minor_version is not None:
            pulumi.set(__self__, "target_minor_version", target_minor_version)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)

    @_builtins.property
    @pulumi.getter(name="dbClusterNodesConfigs")
    def db_cluster_nodes_configs(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        Map of node needs to be created after DB cluster was launched.
        """
        return pulumi.get(self, "db_cluster_nodes_configs")

    @db_cluster_nodes_configs.setter
    def db_cluster_nodes_configs(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "db_cluster_nodes_configs", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> pulumi.Input[_builtins.str]:
        """
        The db_node_class of cluster node.Only effective when the cluster is created for the first time. After the cluster is started, the cluster specification is maintained through the node class.
        """
        return pulumi.get(self, "db_node_class")

    @db_node_class.setter
    def db_node_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_node_class", value)

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Zone to launch the DB cluster.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ens_region_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the ENS VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ENS virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        current DB Cluster revision Version.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="creationCategory")
    def creation_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition of the PolarDB service. Valid values are `SENormal`.
        """
        return pulumi.get(self, "creation_category")

    @creation_category.setter
    def creation_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_category", value)

    @_builtins.property
    @pulumi.getter(name="dbMinorVersion")
    def db_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database minor version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBMinorVersion`. This parameter takes effect only when `db_type` is MySQL and `db_version` is 8.0.
        """
        return pulumi.get(self, "db_minor_version")

    @db_minor_version.setter
    def db_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="dbType")
    def db_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database type. Value options: MySQL, Oracle, PostgreSQL.
        """
        return pulumi.get(self, "db_type")

    @db_type.setter
    def db_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_type", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBVersion`.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        """
        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pay_type", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Storage space charged by space (monthly package). Unit: GB.
        > **NOTE:**  Valid values for PolarDB for MySQL Standard Edition: 20 to 32000. It is valid when pay_type are `PrePaid` ,`PostPaid`.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_space", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type of the cluster. Valid values are `ESSDPL1`, `ESSDPL0`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Version Code of the target version, whose parameter values can be obtained from the [DescribeDBClusterVersionZonal](https://www.alibabacloud.com/help/en/polardb/api-polardb-2017-08-01-describedbclusterversionzonal) interface.
        """
        return pulumi.get(self, "target_minor_version")

    @target_minor_version.setter
    def target_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to `PostPaid`. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_time", value)


@pulumi.input_type
class _ZonalDbClusterState:
    def __init__(__self__, *,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_latest_version: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_category: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_nodes_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 db_cluster_nodes_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 db_cluster_nodes_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 db_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZonalDbCluster resources.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        :param pulumi.Input[_builtins.str] cluster_latest_version: PolarDB zonal cluster latest version.
        :param pulumi.Input[_builtins.str] cluster_version: current DB Cluster revision Version.
        :param pulumi.Input[_builtins.str] create_time: PolarDB zonal cluster creation time.
        :param pulumi.Input[_builtins.str] creation_category: The edition of the PolarDB service. Valid values are `SENormal`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_attributes: Cache of the relationship between node key and node ID for PolarDB zonal Cluster
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_configs: Map of node needs to be created after DB cluster was launched.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_ids: Cache of node ID for PolarDB zonal Cluster
        :param pulumi.Input[_builtins.str] db_minor_version: Database minor version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBMinorVersion`. This parameter takes effect only when `db_type` is MySQL and `db_version` is 8.0.
        :param pulumi.Input[_builtins.str] db_node_class: The db_node_class of cluster node.Only effective when the cluster is created for the first time. After the cluster is started, the cluster specification is maintained through the node class.
        :param pulumi.Input[_builtins.str] db_type: Database type. Value options: MySQL, Oracle, PostgreSQL.
        :param pulumi.Input[_builtins.str] db_version: Database version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBVersion`.
        :param pulumi.Input[_builtins.str] description: The description of cluster.
        :param pulumi.Input[_builtins.str] ens_region_id: The Zone to launch the DB cluster.
        :param pulumi.Input[_builtins.str] pay_type: Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        :param pulumi.Input[_builtins.str] region_id: PolarDB zonal cluster region
        :param pulumi.Input[_builtins.str] renewal_status: Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        :param pulumi.Input[_builtins.str] storage_pay_type: The billing method of the storage. Valid values `Prepaid`.
        :param pulumi.Input[_builtins.int] storage_space: Storage space charged by space (monthly package). Unit: GB.
               > **NOTE:**  Valid values for PolarDB for MySQL Standard Edition: 20 to 32000. It is valid when pay_type are `PrePaid` ,`PostPaid`.
        :param pulumi.Input[_builtins.str] storage_type: The storage type of the cluster. Valid values are `ESSDPL1`, `ESSDPL0`.
        :param pulumi.Input[_builtins.str] target_minor_version: The Version Code of the target version, whose parameter values can be obtained from the [DescribeDBClusterVersionZonal](https://www.alibabacloud.com/help/en/polardb/api-polardb-2017-08-01-describedbclusterversionzonal) interface.
        :param pulumi.Input[_builtins.int] used_time: The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to `PostPaid`. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the ENS VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The ENS virtual switch ID to launch DB instances in one VPC.
        """
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cluster_latest_version is not None:
            pulumi.set(__self__, "cluster_latest_version", cluster_latest_version)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creation_category is not None:
            pulumi.set(__self__, "creation_category", creation_category)
        if db_cluster_nodes_attributes is not None:
            pulumi.set(__self__, "db_cluster_nodes_attributes", db_cluster_nodes_attributes)
        if db_cluster_nodes_configs is not None:
            pulumi.set(__self__, "db_cluster_nodes_configs", db_cluster_nodes_configs)
        if db_cluster_nodes_ids is not None:
            pulumi.set(__self__, "db_cluster_nodes_ids", db_cluster_nodes_ids)
        if db_minor_version is not None:
            pulumi.set(__self__, "db_minor_version", db_minor_version)
        if db_node_class is not None:
            pulumi.set(__self__, "db_node_class", db_node_class)
        if db_type is not None:
            pulumi.set(__self__, "db_type", db_type)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ens_region_id is not None:
            pulumi.set(__self__, "ens_region_id", ens_region_id)
        if pay_type is not None:
            pulumi.set(__self__, "pay_type", pay_type)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if storage_pay_type is not None:
            pulumi.set(__self__, "storage_pay_type", storage_pay_type)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if target_minor_version is not None:
            pulumi.set(__self__, "target_minor_version", target_minor_version)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="clusterLatestVersion")
    def cluster_latest_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PolarDB zonal cluster latest version.
        """
        return pulumi.get(self, "cluster_latest_version")

    @cluster_latest_version.setter
    def cluster_latest_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_latest_version", value)

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        current DB Cluster revision Version.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PolarDB zonal cluster creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="creationCategory")
    def creation_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition of the PolarDB service. Valid values are `SENormal`.
        """
        return pulumi.get(self, "creation_category")

    @creation_category.setter
    def creation_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_category", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterNodesAttributes")
    def db_cluster_nodes_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Cache of the relationship between node key and node ID for PolarDB zonal Cluster
        """
        return pulumi.get(self, "db_cluster_nodes_attributes")

    @db_cluster_nodes_attributes.setter
    def db_cluster_nodes_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_cluster_nodes_attributes", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterNodesConfigs")
    def db_cluster_nodes_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of node needs to be created after DB cluster was launched.
        """
        return pulumi.get(self, "db_cluster_nodes_configs")

    @db_cluster_nodes_configs.setter
    def db_cluster_nodes_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_cluster_nodes_configs", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterNodesIds")
    def db_cluster_nodes_ids(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Cache of node ID for PolarDB zonal Cluster
        """
        return pulumi.get(self, "db_cluster_nodes_ids")

    @db_cluster_nodes_ids.setter
    def db_cluster_nodes_ids(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_cluster_nodes_ids", value)

    @_builtins.property
    @pulumi.getter(name="dbMinorVersion")
    def db_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database minor version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBMinorVersion`. This parameter takes effect only when `db_type` is MySQL and `db_version` is 8.0.
        """
        return pulumi.get(self, "db_minor_version")

    @db_minor_version.setter
    def db_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The db_node_class of cluster node.Only effective when the cluster is created for the first time. After the cluster is started, the cluster specification is maintained through the node class.
        """
        return pulumi.get(self, "db_node_class")

    @db_node_class.setter
    def db_node_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_node_class", value)

    @_builtins.property
    @pulumi.getter(name="dbType")
    def db_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database type. Value options: MySQL, Oracle, PostgreSQL.
        """
        return pulumi.get(self, "db_type")

    @db_type.setter
    def db_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_type", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBVersion`.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to launch the DB cluster.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ens_region_id", value)

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        """
        return pulumi.get(self, "pay_type")

    @pay_type.setter
    def pay_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pay_type", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PolarDB zonal cluster region
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="storagePayType")
    def storage_pay_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the storage. Valid values `Prepaid`.
        """
        return pulumi.get(self, "storage_pay_type")

    @storage_pay_type.setter
    def storage_pay_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_pay_type", value)

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Storage space charged by space (monthly package). Unit: GB.
        > **NOTE:**  Valid values for PolarDB for MySQL Standard Edition: 20 to 32000. It is valid when pay_type are `PrePaid` ,`PostPaid`.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_space", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type of the cluster. Valid values are `ESSDPL1`, `ESSDPL0`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Version Code of the target version, whose parameter values can be obtained from the [DescribeDBClusterVersionZonal](https://www.alibabacloud.com/help/en/polardb/api-polardb-2017-08-01-describedbclusterversionzonal) interface.
        """
        return pulumi.get(self, "target_minor_version")

    @target_minor_version.setter
    def target_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to `PostPaid`. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_time", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the ENS VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ENS virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:polardb/zonalDbCluster:ZonalDbCluster")
class ZonalDbCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_category: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_nodes_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 db_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an PolarDB zonal cluster resource. An PolarDB zonal cluster is an isolated database
        environment in the cloud. An PolarDB zonal cluster can contain multiple user-created
        databases.

        > **NOTE:** Available since v1.261.0.

        ## Example Usage

        Create a PolarDB MySQL zonal cluster

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        # The advanced configuration for all nodes in the cluster except for the RW node, including db_node_class, hot_replica_mode, and imci_switch properties.
        db_cluster_nodes_configs = config.get_object("dbClusterNodesConfigs")
        if db_cluster_nodes_configs is None:
            db_cluster_nodes_configs = {
                "db_node_1": {
                    "dbNodeClass": "polar.mysql.x4.medium.c",
                    "dbNodeRole": "Writer",
                    "hotReplicaMode": None,
                    "imciSwitch": None,
                },
                "db_node_2": {
                    "dbNodeClass": "polar.mysql.x4.medium.c",
                    "dbNodeRole": "Reader",
                    "hotReplicaMode": None,
                    "imciSwitch": None,
                },
            }
        default = alicloud.ens.Network("default",
            network_name="terraform-example",
            description="LoadBalancerNetworkDescription_test",
            cidr_block="192.168.2.0/24",
            ens_region_id="tr-Istanbul-1")
        default_vswitch = alicloud.ens.Vswitch("default",
            description="LoadBalancerVSwitchDescription_test",
            cidr_block="192.168.2.0/24",
            vswitch_name="terraform-example",
            ens_region_id="tr-Istanbul-1",
            network_id=default.id)
        default_zonal_db_cluster = alicloud.polardb.ZonalDbCluster("default",
            db_node_class="polar.mysql.x4.medium.c",
            description="terraform-example",
            ens_region_id="tr-Istanbul-1",
            vpc_id=default.id,
            vswitch_id=default_vswitch.id,
            db_cluster_nodes_configs={node: json.dumps({k: v for k, v in config if v != None}) for node, config in db_cluster_nodes_configs})
        ```

        ## Import

        PolarDB zonal cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/zonalDbCluster:ZonalDbCluster example pc-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        :param pulumi.Input[_builtins.str] cluster_version: current DB Cluster revision Version.
        :param pulumi.Input[_builtins.str] creation_category: The edition of the PolarDB service. Valid values are `SENormal`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_configs: Map of node needs to be created after DB cluster was launched.
        :param pulumi.Input[_builtins.str] db_minor_version: Database minor version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBMinorVersion`. This parameter takes effect only when `db_type` is MySQL and `db_version` is 8.0.
        :param pulumi.Input[_builtins.str] db_node_class: The db_node_class of cluster node.Only effective when the cluster is created for the first time. After the cluster is started, the cluster specification is maintained through the node class.
        :param pulumi.Input[_builtins.str] db_type: Database type. Value options: MySQL, Oracle, PostgreSQL.
        :param pulumi.Input[_builtins.str] db_version: Database version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBVersion`.
        :param pulumi.Input[_builtins.str] description: The description of cluster.
        :param pulumi.Input[_builtins.str] ens_region_id: The Zone to launch the DB cluster.
        :param pulumi.Input[_builtins.str] pay_type: Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        :param pulumi.Input[_builtins.str] renewal_status: Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        :param pulumi.Input[_builtins.int] storage_space: Storage space charged by space (monthly package). Unit: GB.
               > **NOTE:**  Valid values for PolarDB for MySQL Standard Edition: 20 to 32000. It is valid when pay_type are `PrePaid` ,`PostPaid`.
        :param pulumi.Input[_builtins.str] storage_type: The storage type of the cluster. Valid values are `ESSDPL1`, `ESSDPL0`.
        :param pulumi.Input[_builtins.str] target_minor_version: The Version Code of the target version, whose parameter values can be obtained from the [DescribeDBClusterVersionZonal](https://www.alibabacloud.com/help/en/polardb/api-polardb-2017-08-01-describedbclusterversionzonal) interface.
        :param pulumi.Input[_builtins.int] used_time: The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to `PostPaid`. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the ENS VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The ENS virtual switch ID to launch DB instances in one VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZonalDbClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an PolarDB zonal cluster resource. An PolarDB zonal cluster is an isolated database
        environment in the cloud. An PolarDB zonal cluster can contain multiple user-created
        databases.

        > **NOTE:** Available since v1.261.0.

        ## Example Usage

        Create a PolarDB MySQL zonal cluster

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        # The advanced configuration for all nodes in the cluster except for the RW node, including db_node_class, hot_replica_mode, and imci_switch properties.
        db_cluster_nodes_configs = config.get_object("dbClusterNodesConfigs")
        if db_cluster_nodes_configs is None:
            db_cluster_nodes_configs = {
                "db_node_1": {
                    "dbNodeClass": "polar.mysql.x4.medium.c",
                    "dbNodeRole": "Writer",
                    "hotReplicaMode": None,
                    "imciSwitch": None,
                },
                "db_node_2": {
                    "dbNodeClass": "polar.mysql.x4.medium.c",
                    "dbNodeRole": "Reader",
                    "hotReplicaMode": None,
                    "imciSwitch": None,
                },
            }
        default = alicloud.ens.Network("default",
            network_name="terraform-example",
            description="LoadBalancerNetworkDescription_test",
            cidr_block="192.168.2.0/24",
            ens_region_id="tr-Istanbul-1")
        default_vswitch = alicloud.ens.Vswitch("default",
            description="LoadBalancerVSwitchDescription_test",
            cidr_block="192.168.2.0/24",
            vswitch_name="terraform-example",
            ens_region_id="tr-Istanbul-1",
            network_id=default.id)
        default_zonal_db_cluster = alicloud.polardb.ZonalDbCluster("default",
            db_node_class="polar.mysql.x4.medium.c",
            description="terraform-example",
            ens_region_id="tr-Istanbul-1",
            vpc_id=default.id,
            vswitch_id=default_vswitch.id,
            db_cluster_nodes_configs={node: json.dumps({k: v for k, v in config if v != None}) for node, config in db_cluster_nodes_configs})
        ```

        ## Import

        PolarDB zonal cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/zonalDbCluster:ZonalDbCluster example pc-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param ZonalDbClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZonalDbClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_category: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_nodes_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 db_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pay_type: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 used_time: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZonalDbClusterArgs.__new__(ZonalDbClusterArgs)

            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["cluster_version"] = cluster_version
            __props__.__dict__["creation_category"] = creation_category
            if db_cluster_nodes_configs is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_nodes_configs'")
            __props__.__dict__["db_cluster_nodes_configs"] = db_cluster_nodes_configs
            __props__.__dict__["db_minor_version"] = db_minor_version
            if db_node_class is None and not opts.urn:
                raise TypeError("Missing required property 'db_node_class'")
            __props__.__dict__["db_node_class"] = db_node_class
            __props__.__dict__["db_type"] = db_type
            __props__.__dict__["db_version"] = db_version
            __props__.__dict__["description"] = description
            if ens_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'ens_region_id'")
            __props__.__dict__["ens_region_id"] = ens_region_id
            __props__.__dict__["pay_type"] = pay_type
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["storage_space"] = storage_space
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["target_minor_version"] = target_minor_version
            __props__.__dict__["used_time"] = used_time
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["cluster_latest_version"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["db_cluster_nodes_attributes"] = None
            __props__.__dict__["db_cluster_nodes_ids"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["storage_pay_type"] = None
        super(ZonalDbCluster, __self__).__init__(
            'alicloud:polardb/zonalDbCluster:ZonalDbCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            cluster_latest_version: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_version: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            creation_category: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_nodes_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            db_cluster_nodes_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            db_cluster_nodes_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            db_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
            db_node_class: Optional[pulumi.Input[_builtins.str]] = None,
            db_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_version: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            pay_type: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_pay_type: Optional[pulumi.Input[_builtins.str]] = None,
            storage_space: Optional[pulumi.Input[_builtins.int]] = None,
            storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            target_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
            used_time: Optional[pulumi.Input[_builtins.int]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ZonalDbCluster':
        """
        Get an existing ZonalDbCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        :param pulumi.Input[_builtins.str] cluster_latest_version: PolarDB zonal cluster latest version.
        :param pulumi.Input[_builtins.str] cluster_version: current DB Cluster revision Version.
        :param pulumi.Input[_builtins.str] create_time: PolarDB zonal cluster creation time.
        :param pulumi.Input[_builtins.str] creation_category: The edition of the PolarDB service. Valid values are `SENormal`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_attributes: Cache of the relationship between node key and node ID for PolarDB zonal Cluster
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_configs: Map of node needs to be created after DB cluster was launched.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_ids: Cache of node ID for PolarDB zonal Cluster
        :param pulumi.Input[_builtins.str] db_minor_version: Database minor version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBMinorVersion`. This parameter takes effect only when `db_type` is MySQL and `db_version` is 8.0.
        :param pulumi.Input[_builtins.str] db_node_class: The db_node_class of cluster node.Only effective when the cluster is created for the first time. After the cluster is started, the cluster specification is maintained through the node class.
        :param pulumi.Input[_builtins.str] db_type: Database type. Value options: MySQL, Oracle, PostgreSQL.
        :param pulumi.Input[_builtins.str] db_version: Database version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBVersion`.
        :param pulumi.Input[_builtins.str] description: The description of cluster.
        :param pulumi.Input[_builtins.str] ens_region_id: The Zone to launch the DB cluster.
        :param pulumi.Input[_builtins.str] pay_type: Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        :param pulumi.Input[_builtins.str] region_id: PolarDB zonal cluster region
        :param pulumi.Input[_builtins.str] renewal_status: Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        :param pulumi.Input[_builtins.str] storage_pay_type: The billing method of the storage. Valid values `Prepaid`.
        :param pulumi.Input[_builtins.int] storage_space: Storage space charged by space (monthly package). Unit: GB.
               > **NOTE:**  Valid values for PolarDB for MySQL Standard Edition: 20 to 32000. It is valid when pay_type are `PrePaid` ,`PostPaid`.
        :param pulumi.Input[_builtins.str] storage_type: The storage type of the cluster. Valid values are `ESSDPL1`, `ESSDPL0`.
        :param pulumi.Input[_builtins.str] target_minor_version: The Version Code of the target version, whose parameter values can be obtained from the [DescribeDBClusterVersionZonal](https://www.alibabacloud.com/help/en/polardb/api-polardb-2017-08-01-describedbclusterversionzonal) interface.
        :param pulumi.Input[_builtins.int] used_time: The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to `PostPaid`. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the ENS VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The ENS virtual switch ID to launch DB instances in one VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZonalDbClusterState.__new__(_ZonalDbClusterState)

        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["cluster_latest_version"] = cluster_latest_version
        __props__.__dict__["cluster_version"] = cluster_version
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["creation_category"] = creation_category
        __props__.__dict__["db_cluster_nodes_attributes"] = db_cluster_nodes_attributes
        __props__.__dict__["db_cluster_nodes_configs"] = db_cluster_nodes_configs
        __props__.__dict__["db_cluster_nodes_ids"] = db_cluster_nodes_ids
        __props__.__dict__["db_minor_version"] = db_minor_version
        __props__.__dict__["db_node_class"] = db_node_class
        __props__.__dict__["db_type"] = db_type
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["description"] = description
        __props__.__dict__["ens_region_id"] = ens_region_id
        __props__.__dict__["pay_type"] = pay_type
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["storage_pay_type"] = storage_pay_type
        __props__.__dict__["storage_space"] = storage_space
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["target_minor_version"] = target_minor_version
        __props__.__dict__["used_time"] = used_time
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return ZonalDbCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="clusterLatestVersion")
    def cluster_latest_version(self) -> pulumi.Output[_builtins.str]:
        """
        PolarDB zonal cluster latest version.
        """
        return pulumi.get(self, "cluster_latest_version")

    @_builtins.property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[_builtins.str]:
        """
        current DB Cluster revision Version.
        """
        return pulumi.get(self, "cluster_version")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        PolarDB zonal cluster creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="creationCategory")
    def creation_category(self) -> pulumi.Output[_builtins.str]:
        """
        The edition of the PolarDB service. Valid values are `SENormal`.
        """
        return pulumi.get(self, "creation_category")

    @_builtins.property
    @pulumi.getter(name="dbClusterNodesAttributes")
    def db_cluster_nodes_attributes(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Cache of the relationship between node key and node ID for PolarDB zonal Cluster
        """
        return pulumi.get(self, "db_cluster_nodes_attributes")

    @_builtins.property
    @pulumi.getter(name="dbClusterNodesConfigs")
    def db_cluster_nodes_configs(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of node needs to be created after DB cluster was launched.
        """
        return pulumi.get(self, "db_cluster_nodes_configs")

    @_builtins.property
    @pulumi.getter(name="dbClusterNodesIds")
    def db_cluster_nodes_ids(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Cache of node ID for PolarDB zonal Cluster
        """
        return pulumi.get(self, "db_cluster_nodes_ids")

    @_builtins.property
    @pulumi.getter(name="dbMinorVersion")
    def db_minor_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Database minor version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBMinorVersion`. This parameter takes effect only when `db_type` is MySQL and `db_version` is 8.0.
        """
        return pulumi.get(self, "db_minor_version")

    @_builtins.property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> pulumi.Output[_builtins.str]:
        """
        The db_node_class of cluster node.Only effective when the cluster is created for the first time. After the cluster is started, the cluster specification is maintained through the node class.
        """
        return pulumi.get(self, "db_node_class")

    @_builtins.property
    @pulumi.getter(name="dbType")
    def db_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Database type. Value options: MySQL, Oracle, PostgreSQL.
        """
        return pulumi.get(self, "db_type")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Database version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBVersion`.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of cluster.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Zone to launch the DB cluster.
        """
        return pulumi.get(self, "ens_region_id")

    @_builtins.property
    @pulumi.getter(name="payType")
    def pay_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        """
        return pulumi.get(self, "pay_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        PolarDB zonal cluster region
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="storagePayType")
    def storage_pay_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method of the storage. Valid values `Prepaid`.
        """
        return pulumi.get(self, "storage_pay_type")

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Storage space charged by space (monthly package). Unit: GB.
        > **NOTE:**  Valid values for PolarDB for MySQL Standard Edition: 20 to 32000. It is valid when pay_type are `PrePaid` ,`PostPaid`.
        """
        return pulumi.get(self, "storage_space")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The storage type of the cluster. Valid values are `ESSDPL1`, `ESSDPL0`.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Version Code of the target version, whose parameter values can be obtained from the [DescribeDBClusterVersionZonal](https://www.alibabacloud.com/help/en/polardb/api-polardb-2017-08-01-describedbclusterversionzonal) interface.
        """
        return pulumi.get(self, "target_minor_version")

    @_builtins.property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to `PostPaid`. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
        """
        return pulumi.get(self, "used_time")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the ENS VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ENS virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

