# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ZonalEndpointArgs', 'ZonalEndpoint']

@pulumi.input_type
class ZonalEndpointArgs:
    def __init__(__self__, *,
                 db_cluster_id: pulumi.Input[_builtins.str],
                 db_cluster_nodes_ids: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 auto_add_new_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 db_endpoint_description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 read_write_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ZonalEndpoint resource.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_ids: referenced from the db_cluster_nodes_ids attribute of alicloud_polardb_zonal_db_cluster..
        :param pulumi.Input[_builtins.str] auto_add_new_nodes: Whether the new node automatically joins the default cluster address. Valid values are `Enable`, `Disable`. When creating a new custom endpoint, default to `Enable`.
        :param pulumi.Input[_builtins.str] db_endpoint_description: The name of the endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] endpoint_config: The advanced settings of the endpoint of Apsara PolarDB clusters are in JSON format. Including the settings of consistency level, transaction splitting, connection pool, and offload reads from primary node. For more details, see the [description of EndpointConfig in the Request parameters table for details](https://www.alibabacloud.com/help/doc-detail/116593.htm).
        :param pulumi.Input[_builtins.str] endpoint_type: Type of the endpoint. Valid values are `Custom`, `Cluster`, `Primary`, default to `Custom`. However when creating a new endpoint, it also only can be `Custom`.
        :param pulumi.Input[_builtins.str] net_type: The network type of the endpoint address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nodes_keys: The list of backend nodes for the endpoint, with the attribute values derived from the map key of db_cluster_nodes_ids.
        :param pulumi.Input[_builtins.str] read_write_mode: Read or write mode. Valid values are `ReadWrite`, `ReadOnly`. When creating a new custom endpoint, default to `ReadOnly`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of ENS VPC where to use the DB.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of ENS virtual switch where to use the DB.
        """
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        pulumi.set(__self__, "db_cluster_nodes_ids", db_cluster_nodes_ids)
        if auto_add_new_nodes is not None:
            pulumi.set(__self__, "auto_add_new_nodes", auto_add_new_nodes)
        if db_endpoint_description is not None:
            pulumi.set(__self__, "db_endpoint_description", db_endpoint_description)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)
        if nodes_keys is not None:
            pulumi.set(__self__, "nodes_keys", nodes_keys)
        if read_write_mode is not None:
            pulumi.set(__self__, "read_write_mode", read_write_mode)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterNodesIds")
    def db_cluster_nodes_ids(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        referenced from the db_cluster_nodes_ids attribute of alicloud_polardb_zonal_db_cluster..
        """
        return pulumi.get(self, "db_cluster_nodes_ids")

    @db_cluster_nodes_ids.setter
    def db_cluster_nodes_ids(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "db_cluster_nodes_ids", value)

    @_builtins.property
    @pulumi.getter(name="autoAddNewNodes")
    def auto_add_new_nodes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the new node automatically joins the default cluster address. Valid values are `Enable`, `Disable`. When creating a new custom endpoint, default to `Enable`.
        """
        return pulumi.get(self, "auto_add_new_nodes")

    @auto_add_new_nodes.setter
    def auto_add_new_nodes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_add_new_nodes", value)

    @_builtins.property
    @pulumi.getter(name="dbEndpointDescription")
    def db_endpoint_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "db_endpoint_description")

    @db_endpoint_description.setter
    def db_endpoint_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_endpoint_description", value)

    @_builtins.property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The advanced settings of the endpoint of Apsara PolarDB clusters are in JSON format. Including the settings of consistency level, transaction splitting, connection pool, and offload reads from primary node. For more details, see the [description of EndpointConfig in the Request parameters table for details](https://www.alibabacloud.com/help/doc-detail/116593.htm).
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "endpoint_config", value)

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the endpoint. Valid values are `Custom`, `Cluster`, `Primary`, default to `Custom`. However when creating a new endpoint, it also only can be `Custom`.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_type", value)

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the endpoint address.
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_type", value)

    @_builtins.property
    @pulumi.getter(name="nodesKeys")
    def nodes_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of backend nodes for the endpoint, with the attribute values derived from the map key of db_cluster_nodes_ids.
        """
        return pulumi.get(self, "nodes_keys")

    @nodes_keys.setter
    def nodes_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nodes_keys", value)

    @_builtins.property
    @pulumi.getter(name="readWriteMode")
    def read_write_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Read or write mode. Valid values are `ReadWrite`, `ReadOnly`. When creating a new custom endpoint, default to `ReadOnly`.
        """
        return pulumi.get(self, "read_write_mode")

    @read_write_mode.setter
    def read_write_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "read_write_mode", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of ENS VPC where to use the DB.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of ENS virtual switch where to use the DB.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _ZonalEndpointState:
    def __init__(__self__, *,
                 auto_add_new_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_nodes_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 db_endpoint_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nodes_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 read_write_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZonalEndpoint resources.
        :param pulumi.Input[_builtins.str] auto_add_new_nodes: Whether the new node automatically joins the default cluster address. Valid values are `Enable`, `Disable`. When creating a new custom endpoint, default to `Enable`.
        :param pulumi.Input[_builtins.str] connection_prefix: Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_ids: referenced from the db_cluster_nodes_ids attribute of alicloud_polardb_zonal_db_cluster..
        :param pulumi.Input[_builtins.str] db_endpoint_description: The name of the endpoint.
        :param pulumi.Input[_builtins.str] db_endpoint_id: The ID of the cluster endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] endpoint_config: The advanced settings of the endpoint of Apsara PolarDB clusters are in JSON format. Including the settings of consistency level, transaction splitting, connection pool, and offload reads from primary node. For more details, see the [description of EndpointConfig in the Request parameters table for details](https://www.alibabacloud.com/help/doc-detail/116593.htm).
        :param pulumi.Input[_builtins.str] endpoint_type: Type of the endpoint. Valid values are `Custom`, `Cluster`, `Primary`, default to `Custom`. However when creating a new endpoint, it also only can be `Custom`.
        :param pulumi.Input[_builtins.str] net_type: The network type of the endpoint address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nodes: Node id list for endpoint configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nodes_keys: The list of backend nodes for the endpoint, with the attribute values derived from the map key of db_cluster_nodes_ids.
        :param pulumi.Input[_builtins.str] port: Port of the specified endpoint. Valid values: 3000 to 5999.
        :param pulumi.Input[_builtins.str] read_write_mode: Read or write mode. Valid values are `ReadWrite`, `ReadOnly`. When creating a new custom endpoint, default to `ReadOnly`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of ENS VPC where to use the DB.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of ENS virtual switch where to use the DB.
        """
        if auto_add_new_nodes is not None:
            pulumi.set(__self__, "auto_add_new_nodes", auto_add_new_nodes)
        if connection_prefix is not None:
            pulumi.set(__self__, "connection_prefix", connection_prefix)
        if db_cluster_id is not None:
            pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        if db_cluster_nodes_ids is not None:
            pulumi.set(__self__, "db_cluster_nodes_ids", db_cluster_nodes_ids)
        if db_endpoint_description is not None:
            pulumi.set(__self__, "db_endpoint_description", db_endpoint_description)
        if db_endpoint_id is not None:
            pulumi.set(__self__, "db_endpoint_id", db_endpoint_id)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if nodes_keys is not None:
            pulumi.set(__self__, "nodes_keys", nodes_keys)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if read_write_mode is not None:
            pulumi.set(__self__, "read_write_mode", read_write_mode)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="autoAddNewNodes")
    def auto_add_new_nodes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the new node automatically joins the default cluster address. Valid values are `Enable`, `Disable`. When creating a new custom endpoint, default to `Enable`.
        """
        return pulumi.get(self, "auto_add_new_nodes")

    @auto_add_new_nodes.setter
    def auto_add_new_nodes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_add_new_nodes", value)

    @_builtins.property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        """
        return pulumi.get(self, "connection_prefix")

    @connection_prefix.setter
    def connection_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @db_cluster_id.setter
    def db_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dbClusterNodesIds")
    def db_cluster_nodes_ids(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        referenced from the db_cluster_nodes_ids attribute of alicloud_polardb_zonal_db_cluster..
        """
        return pulumi.get(self, "db_cluster_nodes_ids")

    @db_cluster_nodes_ids.setter
    def db_cluster_nodes_ids(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_cluster_nodes_ids", value)

    @_builtins.property
    @pulumi.getter(name="dbEndpointDescription")
    def db_endpoint_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "db_endpoint_description")

    @db_endpoint_description.setter
    def db_endpoint_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_endpoint_description", value)

    @_builtins.property
    @pulumi.getter(name="dbEndpointId")
    def db_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the cluster endpoint.
        """
        return pulumi.get(self, "db_endpoint_id")

    @db_endpoint_id.setter
    def db_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The advanced settings of the endpoint of Apsara PolarDB clusters are in JSON format. Including the settings of consistency level, transaction splitting, connection pool, and offload reads from primary node. For more details, see the [description of EndpointConfig in the Request parameters table for details](https://www.alibabacloud.com/help/doc-detail/116593.htm).
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "endpoint_config", value)

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the endpoint. Valid values are `Custom`, `Cluster`, `Primary`, default to `Custom`. However when creating a new endpoint, it also only can be `Custom`.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_type", value)

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the endpoint address.
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_type", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Node id list for endpoint configuration.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="nodesKeys")
    def nodes_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of backend nodes for the endpoint, with the attribute values derived from the map key of db_cluster_nodes_ids.
        """
        return pulumi.get(self, "nodes_keys")

    @nodes_keys.setter
    def nodes_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nodes_keys", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Port of the specified endpoint. Valid values: 3000 to 5999.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="readWriteMode")
    def read_write_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Read or write mode. Valid values are `ReadWrite`, `ReadOnly`. When creating a new custom endpoint, default to `ReadOnly`.
        """
        return pulumi.get(self, "read_write_mode")

    @read_write_mode.setter
    def read_write_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "read_write_mode", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of ENS VPC where to use the DB.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of ENS virtual switch where to use the DB.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:polardb/zonalEndpoint:ZonalEndpoint")
class ZonalEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_add_new_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_nodes_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 db_endpoint_description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 read_write_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PolarDB Zonal endpoint resource to manage custom endpoint of PolarDB cluster.

        > **NOTE:** Available since v1.262.0.
        **NOTE:** The primary endpoint and the default cluster endpoint can not be created or deleted manually.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        # The advanced configuration for all nodes in the cluster except for the RW node, including db_node_class, hot_replica_mode, and imci_switch properties.
        db_cluster_nodes_configs = config.get_object("dbClusterNodesConfigs")
        if db_cluster_nodes_configs is None:
            db_cluster_nodes_configs = {
                "db_node_1": {
                    "dbNodeClass": "polar.mysql.x4.medium.c",
                    "dbNodeRole": "Writer",
                    "hotReplicaMode": None,
                    "imciSwitch": None,
                },
                "db_node_2": {
                    "dbNodeClass": "polar.mysql.x4.medium.c",
                    "dbNodeRole": "Reader",
                    "hotReplicaMode": None,
                    "imciSwitch": None,
                },
            }
        default = alicloud.ens.Network("default",
            network_name="terraform-example",
            description="LoadBalancerNetworkDescription_test",
            cidr_block="192.168.2.0/24",
            ens_region_id="tr-Istanbul-1")
        default_vswitch = alicloud.ens.Vswitch("default",
            description="LoadBalancerVSwitchDescription_test",
            cidr_block="192.168.2.0/24",
            vswitch_name="terraform-example",
            ens_region_id="tr-Istanbul-1",
            network_id=default.id)
        default_zonal_db_cluster = alicloud.polardb.ZonalDbCluster("default",
            db_node_class="polar.mysql.x4.medium.c",
            description="terraform-example",
            ens_region_id="tr-Istanbul-1",
            vpc_id=default.id,
            vswitch_id=default_vswitch.id,
            db_cluster_nodes_configs={node: json.dumps({k: v for k, v in config if v != None}) for node, config in db_cluster_nodes_configs})
        default_zonal_endpoint = alicloud.polardb.ZonalEndpoint("default",
            db_cluster_id=default_zonal_db_cluster.id,
            db_cluster_nodes_ids=default_zonal_db_cluster.db_cluster_nodes_ids,
            endpoint_config={},
            nodes_keys=[
                "db_node_1",
                "db_node_2",
            ],
            read_write_mode="ReadWrite")
        ```

        ## Import

        PolarDB Zonal endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/zonalEndpoint:ZonalEndpoint example pc-abc123456:pe-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_add_new_nodes: Whether the new node automatically joins the default cluster address. Valid values are `Enable`, `Disable`. When creating a new custom endpoint, default to `Enable`.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_ids: referenced from the db_cluster_nodes_ids attribute of alicloud_polardb_zonal_db_cluster..
        :param pulumi.Input[_builtins.str] db_endpoint_description: The name of the endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] endpoint_config: The advanced settings of the endpoint of Apsara PolarDB clusters are in JSON format. Including the settings of consistency level, transaction splitting, connection pool, and offload reads from primary node. For more details, see the [description of EndpointConfig in the Request parameters table for details](https://www.alibabacloud.com/help/doc-detail/116593.htm).
        :param pulumi.Input[_builtins.str] endpoint_type: Type of the endpoint. Valid values are `Custom`, `Cluster`, `Primary`, default to `Custom`. However when creating a new endpoint, it also only can be `Custom`.
        :param pulumi.Input[_builtins.str] net_type: The network type of the endpoint address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nodes_keys: The list of backend nodes for the endpoint, with the attribute values derived from the map key of db_cluster_nodes_ids.
        :param pulumi.Input[_builtins.str] read_write_mode: Read or write mode. Valid values are `ReadWrite`, `ReadOnly`. When creating a new custom endpoint, default to `ReadOnly`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of ENS VPC where to use the DB.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of ENS virtual switch where to use the DB.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZonalEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PolarDB Zonal endpoint resource to manage custom endpoint of PolarDB cluster.

        > **NOTE:** Available since v1.262.0.
        **NOTE:** The primary endpoint and the default cluster endpoint can not be created or deleted manually.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        # The advanced configuration for all nodes in the cluster except for the RW node, including db_node_class, hot_replica_mode, and imci_switch properties.
        db_cluster_nodes_configs = config.get_object("dbClusterNodesConfigs")
        if db_cluster_nodes_configs is None:
            db_cluster_nodes_configs = {
                "db_node_1": {
                    "dbNodeClass": "polar.mysql.x4.medium.c",
                    "dbNodeRole": "Writer",
                    "hotReplicaMode": None,
                    "imciSwitch": None,
                },
                "db_node_2": {
                    "dbNodeClass": "polar.mysql.x4.medium.c",
                    "dbNodeRole": "Reader",
                    "hotReplicaMode": None,
                    "imciSwitch": None,
                },
            }
        default = alicloud.ens.Network("default",
            network_name="terraform-example",
            description="LoadBalancerNetworkDescription_test",
            cidr_block="192.168.2.0/24",
            ens_region_id="tr-Istanbul-1")
        default_vswitch = alicloud.ens.Vswitch("default",
            description="LoadBalancerVSwitchDescription_test",
            cidr_block="192.168.2.0/24",
            vswitch_name="terraform-example",
            ens_region_id="tr-Istanbul-1",
            network_id=default.id)
        default_zonal_db_cluster = alicloud.polardb.ZonalDbCluster("default",
            db_node_class="polar.mysql.x4.medium.c",
            description="terraform-example",
            ens_region_id="tr-Istanbul-1",
            vpc_id=default.id,
            vswitch_id=default_vswitch.id,
            db_cluster_nodes_configs={node: json.dumps({k: v for k, v in config if v != None}) for node, config in db_cluster_nodes_configs})
        default_zonal_endpoint = alicloud.polardb.ZonalEndpoint("default",
            db_cluster_id=default_zonal_db_cluster.id,
            db_cluster_nodes_ids=default_zonal_db_cluster.db_cluster_nodes_ids,
            endpoint_config={},
            nodes_keys=[
                "db_node_1",
                "db_node_2",
            ],
            read_write_mode="ReadWrite")
        ```

        ## Import

        PolarDB Zonal endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:polardb/zonalEndpoint:ZonalEndpoint example pc-abc123456:pe-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param ZonalEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZonalEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_add_new_nodes: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_cluster_nodes_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 db_endpoint_description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 read_write_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZonalEndpointArgs.__new__(ZonalEndpointArgs)

            __props__.__dict__["auto_add_new_nodes"] = auto_add_new_nodes
            if db_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_id'")
            __props__.__dict__["db_cluster_id"] = db_cluster_id
            if db_cluster_nodes_ids is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_nodes_ids'")
            __props__.__dict__["db_cluster_nodes_ids"] = db_cluster_nodes_ids
            __props__.__dict__["db_endpoint_description"] = db_endpoint_description
            __props__.__dict__["endpoint_config"] = endpoint_config
            __props__.__dict__["endpoint_type"] = endpoint_type
            __props__.__dict__["net_type"] = net_type
            __props__.__dict__["nodes_keys"] = nodes_keys
            __props__.__dict__["read_write_mode"] = read_write_mode
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["connection_prefix"] = None
            __props__.__dict__["db_endpoint_id"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["port"] = None
        super(ZonalEndpoint, __self__).__init__(
            'alicloud:polardb/zonalEndpoint:ZonalEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_add_new_nodes: Optional[pulumi.Input[_builtins.str]] = None,
            connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_cluster_nodes_ids: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            db_endpoint_description: Optional[pulumi.Input[_builtins.str]] = None,
            db_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
            net_type: Optional[pulumi.Input[_builtins.str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            nodes_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            read_write_mode: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ZonalEndpoint':
        """
        Get an existing ZonalEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_add_new_nodes: Whether the new node automatically joins the default cluster address. Valid values are `Enable`, `Disable`. When creating a new custom endpoint, default to `Enable`.
        :param pulumi.Input[_builtins.str] connection_prefix: Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        :param pulumi.Input[_builtins.str] db_cluster_id: The Id of cluster that can run database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] db_cluster_nodes_ids: referenced from the db_cluster_nodes_ids attribute of alicloud_polardb_zonal_db_cluster..
        :param pulumi.Input[_builtins.str] db_endpoint_description: The name of the endpoint.
        :param pulumi.Input[_builtins.str] db_endpoint_id: The ID of the cluster endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] endpoint_config: The advanced settings of the endpoint of Apsara PolarDB clusters are in JSON format. Including the settings of consistency level, transaction splitting, connection pool, and offload reads from primary node. For more details, see the [description of EndpointConfig in the Request parameters table for details](https://www.alibabacloud.com/help/doc-detail/116593.htm).
        :param pulumi.Input[_builtins.str] endpoint_type: Type of the endpoint. Valid values are `Custom`, `Cluster`, `Primary`, default to `Custom`. However when creating a new endpoint, it also only can be `Custom`.
        :param pulumi.Input[_builtins.str] net_type: The network type of the endpoint address.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nodes: Node id list for endpoint configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nodes_keys: The list of backend nodes for the endpoint, with the attribute values derived from the map key of db_cluster_nodes_ids.
        :param pulumi.Input[_builtins.str] port: Port of the specified endpoint. Valid values: 3000 to 5999.
        :param pulumi.Input[_builtins.str] read_write_mode: Read or write mode. Valid values are `ReadWrite`, `ReadOnly`. When creating a new custom endpoint, default to `ReadOnly`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of ENS VPC where to use the DB.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of ENS virtual switch where to use the DB.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZonalEndpointState.__new__(_ZonalEndpointState)

        __props__.__dict__["auto_add_new_nodes"] = auto_add_new_nodes
        __props__.__dict__["connection_prefix"] = connection_prefix
        __props__.__dict__["db_cluster_id"] = db_cluster_id
        __props__.__dict__["db_cluster_nodes_ids"] = db_cluster_nodes_ids
        __props__.__dict__["db_endpoint_description"] = db_endpoint_description
        __props__.__dict__["db_endpoint_id"] = db_endpoint_id
        __props__.__dict__["endpoint_config"] = endpoint_config
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["net_type"] = net_type
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["nodes_keys"] = nodes_keys
        __props__.__dict__["port"] = port
        __props__.__dict__["read_write_mode"] = read_write_mode
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return ZonalEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoAddNewNodes")
    def auto_add_new_nodes(self) -> pulumi.Output[_builtins.str]:
        """
        Whether the new node automatically joins the default cluster address. Valid values are `Enable`, `Disable`. When creating a new custom endpoint, default to `Enable`.
        """
        return pulumi.get(self, "auto_add_new_nodes")

    @_builtins.property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
        """
        return pulumi.get(self, "connection_prefix")

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of cluster that can run database.
        """
        return pulumi.get(self, "db_cluster_id")

    @_builtins.property
    @pulumi.getter(name="dbClusterNodesIds")
    def db_cluster_nodes_ids(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        referenced from the db_cluster_nodes_ids attribute of alicloud_polardb_zonal_db_cluster..
        """
        return pulumi.get(self, "db_cluster_nodes_ids")

    @_builtins.property
    @pulumi.getter(name="dbEndpointDescription")
    def db_endpoint_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "db_endpoint_description")

    @_builtins.property
    @pulumi.getter(name="dbEndpointId")
    def db_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the cluster endpoint.
        """
        return pulumi.get(self, "db_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The advanced settings of the endpoint of Apsara PolarDB clusters are in JSON format. Including the settings of consistency level, transaction splitting, connection pool, and offload reads from primary node. For more details, see the [description of EndpointConfig in the Request parameters table for details](https://www.alibabacloud.com/help/doc-detail/116593.htm).
        """
        return pulumi.get(self, "endpoint_config")

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the endpoint. Valid values are `Custom`, `Cluster`, `Primary`, default to `Custom`. However when creating a new endpoint, it also only can be `Custom`.
        """
        return pulumi.get(self, "endpoint_type")

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> pulumi.Output[_builtins.str]:
        """
        The network type of the endpoint address.
        """
        return pulumi.get(self, "net_type")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Node id list for endpoint configuration.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="nodesKeys")
    def nodes_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of backend nodes for the endpoint, with the attribute values derived from the map key of db_cluster_nodes_ids.
        """
        return pulumi.get(self, "nodes_keys")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        Port of the specified endpoint. Valid values: 3000 to 5999.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="readWriteMode")
    def read_write_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Read or write mode. Valid values are `ReadWrite`, `ReadOnly`. When creating a new custom endpoint, default to `ReadOnly`.
        """
        return pulumi.get(self, "read_write_mode")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of ENS VPC where to use the DB.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of ENS virtual switch where to use the DB.
        """
        return pulumi.get(self, "vswitch_id")

