# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'EndpointIpConfig',
    'RuleAttachmentVpc',
    'RuleForwardIp',
    'ZoneAttachmentVpc',
    'ZoneUserInfo',
    'GetEndpointsEndpointResult',
    'GetEndpointsEndpointIpConfigResult',
    'GetResolverZonesZoneResult',
    'GetRulesRuleResult',
    'GetRulesRuleBindVpcResult',
    'GetRulesRuleForwardIpResult',
    'GetZoneRecordsRecordResult',
    'GetZonesZoneResult',
    'GetZonesZoneBindVpcResult',
]

@pulumi.output_type
class EndpointIpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlock":
            suggest = "cidr_block"
        elif key == "vswitchId":
            suggest = "vswitch_id"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointIpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointIpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointIpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str,
                 ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str cidr_block: The Subnet mask.
        :param _builtins.str vswitch_id: The Vswitch id.
        :param _builtins.str zone_id: The Zone ID.
        :param _builtins.str ip: The IP address within the parameter range of the subnet mask.  It is recommended to use the IP address assigned by the system.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        The Subnet mask.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The Vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The Zone ID.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        The IP address within the parameter range of the subnet mask.  It is recommended to use the IP address assigned by the system.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class RuleAttachmentVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionId":
            suggest = "region_id"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleAttachmentVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleAttachmentVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleAttachmentVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_id: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str region_id: The region of the vpc. If not set, the current region will instead of.
        :param _builtins.str vpc_id: The ID of the VPC.  **NOTE:** The VPC that can be associated with the forwarding rule must belong to the same region as the Endpoint.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region of the vpc. If not set, the current region will instead of.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC.  **NOTE:** The VPC that can be associated with the forwarding rule must belong to the same region as the Endpoint.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class RuleForwardIp(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str ip: The ip of the forwarding destination.
        :param _builtins.int port: The port of the forwarding destination.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The ip of the forwarding destination.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port of the forwarding destination.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ZoneAttachmentVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "regionId":
            suggest = "region_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneAttachmentVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneAttachmentVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneAttachmentVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: _builtins.str,
                 region_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str vpc_id: The Id of the vpc.
        :param _builtins.str region_id: The region of the vpc. If not set, the current region will instead of.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The Id of the vpc.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[_builtins.str]:
        """
        The region of the vpc. If not set, the current region will instead of.
        """
        return pulumi.get(self, "region_id")


@pulumi.output_type
class ZoneUserInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionIds":
            suggest = "region_ids"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneUserInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneUserInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneUserInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_ids: Optional[Sequence[_builtins.str]] = None,
                 user_id: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] region_ids: The list of the region IDs.
        :param _builtins.str user_id: The user ID belonging to the region is used for cross-account synchronization scenarios.
        """
        if region_ids is not None:
            pulumi.set(__self__, "region_ids", region_ids)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="regionIds")
    def region_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of the region IDs.
        """
        return pulumi.get(self, "region_ids")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[_builtins.str]:
        """
        The user ID belonging to the region is used for cross-account synchronization scenarios.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetEndpointsEndpointResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 endpoint_name: _builtins.str,
                 id: _builtins.str,
                 ip_configs: Sequence['outputs.GetEndpointsEndpointIpConfigResult'],
                 security_group_id: _builtins.str,
                 status: _builtins.str,
                 vpc_id: _builtins.str,
                 vpc_name: _builtins.str,
                 vpc_region_id: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str endpoint_name: The name of the resource.
        :param Sequence['GetEndpointsEndpointIpConfigArgs'] ip_configs: The Ip Configs.
        :param _builtins.str security_group_id: The ID of the Security Group.
        :param _builtins.str status: The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
        :param _builtins.str vpc_id: The VPC ID.
        :param _builtins.str vpc_name: The name of the VPC.
        :param _builtins.str vpc_region_id: The Region of the VPC.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_configs", ip_configs)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)
        pulumi.set(__self__, "vpc_region_id", vpc_region_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> _builtins.str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "endpoint_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> Sequence['outputs.GetEndpointsEndpointIpConfigResult']:
        """
        The Ip Configs.
        """
        return pulumi.get(self, "ip_configs")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The ID of the Security Group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> _builtins.str:
        """
        The name of the VPC.
        """
        return pulumi.get(self, "vpc_name")

    @_builtins.property
    @pulumi.getter(name="vpcRegionId")
    def vpc_region_id(self) -> _builtins.str:
        """
        The Region of the VPC.
        """
        return pulumi.get(self, "vpc_region_id")


@pulumi.output_type
class GetEndpointsEndpointIpConfigResult(dict):
    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 ip: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str cidr_block: The Subnet mask.
        :param _builtins.str ip: The IP address within the parameter range of the subnet mask. **NOTE:** It is recommended to use the IP address assigned by the system.
        :param _builtins.str vswitch_id: The Vswitch id.
        :param _builtins.str zone_id: The Zone ID.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        The Subnet mask.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP address within the parameter range of the subnet mask. **NOTE:** It is recommended to use the IP address assigned by the system.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The Vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The Zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetResolverZonesZoneResult(dict):
    def __init__(__self__, *,
                 status: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str status: The status of the Zone.
        :param _builtins.str zone_id: The zone ID.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Zone.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetRulesRuleResult(dict):
    def __init__(__self__, *,
                 bind_vpcs: Sequence['outputs.GetRulesRuleBindVpcResult'],
                 create_time: _builtins.str,
                 endpoint_id: _builtins.str,
                 endpoint_name: _builtins.str,
                 forward_ips: Sequence['outputs.GetRulesRuleForwardIpResult'],
                 id: _builtins.str,
                 rule_id: _builtins.str,
                 rule_name: _builtins.str,
                 type: _builtins.str,
                 zone_name: _builtins.str):
        """
        :param Sequence['GetRulesRuleBindVpcArgs'] bind_vpcs: The List of the VPC. See the following `Block bind_vpcs`. **NOTE:** Available in v1.158.0+.
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str endpoint_id: The ID of the Endpoint.
        :param _builtins.str endpoint_name: The Name of the Endpoint.
        :param _builtins.str id: The ID of the Rule.
        :param _builtins.str rule_id: The first ID of the resource.
        :param _builtins.str rule_name: The name of the resource.
        :param _builtins.str type: The type of the rule.
        :param _builtins.str zone_name: The name of the forwarding zone.
        """
        pulumi.set(__self__, "bind_vpcs", bind_vpcs)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "forward_ips", forward_ips)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter(name="bindVpcs")
    def bind_vpcs(self) -> Sequence['outputs.GetRulesRuleBindVpcResult']:
        """
        The List of the VPC. See the following `Block bind_vpcs`. **NOTE:** Available in v1.158.0+.
        """
        return pulumi.get(self, "bind_vpcs")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        The ID of the Endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> _builtins.str:
        """
        The Name of the Endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @_builtins.property
    @pulumi.getter(name="forwardIps")
    def forward_ips(self) -> Sequence['outputs.GetRulesRuleForwardIpResult']:
        return pulumi.get(self, "forward_ips")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> _builtins.str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the rule.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> _builtins.str:
        """
        The name of the forwarding zone.
        """
        return pulumi.get(self, "zone_name")


@pulumi.output_type
class GetRulesRuleBindVpcResult(dict):
    def __init__(__self__, *,
                 region_id: _builtins.str,
                 region_name: _builtins.str,
                 vpc_id: _builtins.str,
                 vpc_name: _builtins.str):
        """
        :param _builtins.str region_id: The region ID of the vpc.
        :param _builtins.str region_name: The Region Name of the vpc.
        :param _builtins.str vpc_id: The ID of the VPC.
        :param _builtins.str vpc_name: The Name of the VPC.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the vpc.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.str:
        """
        The Region Name of the vpc.
        """
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> _builtins.str:
        """
        The Name of the VPC.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class GetRulesRuleForwardIpResult(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 port: _builtins.int):
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        return pulumi.get(self, "port")


@pulumi.output_type
class GetZoneRecordsRecordResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 priority: _builtins.int,
                 record_id: _builtins.str,
                 remark: _builtins.str,
                 resource_record: _builtins.str,
                 rr: _builtins.str,
                 status: _builtins.str,
                 ttl: _builtins.int,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str id: The ID of the Private Zone Record.
        :param _builtins.int priority: The priority of the MX record.
        :param _builtins.str record_id: The ID of the Record.
        :param _builtins.str remark: The description of the Private Zone Record.
        :param _builtins.str resource_record: The hostname of the Private Zone Record.
        :param _builtins.str rr: The hostname of the Private Zone Record.
        :param _builtins.str status: The status of the Resolve record. Valid values:
               - `ENABLE`: Enable resolution.
               - `DISABLE`: Pause parsing.
        :param _builtins.int ttl: The time to live (TTL) of the Private Zone Record.
        :param _builtins.str type: The type of the Private Zone Record.
        :param _builtins.str value: The value of the Private Zone Record.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "record_id", record_id)
        pulumi.set(__self__, "remark", remark)
        pulumi.set(__self__, "resource_record", resource_record)
        pulumi.set(__self__, "rr", rr)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Private Zone Record.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority of the MX record.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="recordId")
    def record_id(self) -> _builtins.str:
        """
        The ID of the Record.
        """
        return pulumi.get(self, "record_id")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> _builtins.str:
        """
        The description of the Private Zone Record.
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter(name="resourceRecord")
    def resource_record(self) -> _builtins.str:
        """
        The hostname of the Private Zone Record.
        """
        return pulumi.get(self, "resource_record")

    @_builtins.property
    @pulumi.getter
    def rr(self) -> _builtins.str:
        """
        The hostname of the Private Zone Record.
        """
        return pulumi.get(self, "rr")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Resolve record. Valid values:
        - `ENABLE`: Enable resolution.
        - `DISABLE`: Pause parsing.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> _builtins.int:
        """
        The time to live (TTL) of the Private Zone Record.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the Private Zone Record.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the Private Zone Record.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 bind_vpcs: Sequence['outputs.GetZonesZoneBindVpcResult'],
                 create_timestamp: _builtins.int,
                 creation_time: _builtins.str,
                 id: _builtins.str,
                 is_ptr: _builtins.bool,
                 name: _builtins.str,
                 proxy_pattern: _builtins.str,
                 record_count: _builtins.int,
                 remark: _builtins.str,
                 resource_group_id: _builtins.str,
                 slave_dns: _builtins.bool,
                 update_time: _builtins.str,
                 update_timestamp: _builtins.int,
                 zone_id: _builtins.str,
                 zone_name: _builtins.str):
        """
        :param Sequence['GetZonesZoneBindVpcArgs'] bind_vpcs: The VPCs associated with the zone. **Note:** `bind_vpcs` takes effect only if `enable_details` is set to `true`.
        :param _builtins.int create_timestamp: The time when the zone was created.
        :param _builtins.str id: The ID of the Private Zone.
        :param _builtins.bool is_ptr: Indicates whether the zone is a reverse lookup zone.
        :param _builtins.str name: The Name of the Zone.
        :param _builtins.str proxy_pattern: Indicates whether the recursive resolution proxy for subdomain names is enabled.
        :param _builtins.int record_count: The number of Domain Name System (DNS) records added in the zone.
        :param _builtins.str remark: The description of the zone.
        :param _builtins.str resource_group_id: The ID of the resource group to which the zone belongs.
        :param _builtins.bool slave_dns: Indicates whether the secondary Domain Name System (DNS) feature is enabled for the zone. **Note:** `slave_dns` takes effect only if `enable_details` is set to `true`.
        :param _builtins.int update_timestamp: The time when the DNS record was updated.
        :param _builtins.str zone_id: The ID of the Zone.
        :param _builtins.str zone_name: The Name of the Private Zone.
        """
        pulumi.set(__self__, "bind_vpcs", bind_vpcs)
        pulumi.set(__self__, "create_timestamp", create_timestamp)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_ptr", is_ptr)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "proxy_pattern", proxy_pattern)
        pulumi.set(__self__, "record_count", record_count)
        pulumi.set(__self__, "remark", remark)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "slave_dns", slave_dns)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "update_timestamp", update_timestamp)
        pulumi.set(__self__, "zone_id", zone_id)
        pulumi.set(__self__, "zone_name", zone_name)

    @_builtins.property
    @pulumi.getter(name="bindVpcs")
    def bind_vpcs(self) -> Sequence['outputs.GetZonesZoneBindVpcResult']:
        """
        The VPCs associated with the zone. **Note:** `bind_vpcs` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "bind_vpcs")

    @_builtins.property
    @pulumi.getter(name="createTimestamp")
    def create_timestamp(self) -> _builtins.int:
        """
        The time when the zone was created.
        """
        return pulumi.get(self, "create_timestamp")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Private Zone.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isPtr")
    def is_ptr(self) -> _builtins.bool:
        """
        Indicates whether the zone is a reverse lookup zone.
        """
        return pulumi.get(self, "is_ptr")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name of the Zone.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="proxyPattern")
    def proxy_pattern(self) -> _builtins.str:
        """
        Indicates whether the recursive resolution proxy for subdomain names is enabled.
        """
        return pulumi.get(self, "proxy_pattern")

    @_builtins.property
    @pulumi.getter(name="recordCount")
    def record_count(self) -> _builtins.int:
        """
        The number of Domain Name System (DNS) records added in the zone.
        """
        return pulumi.get(self, "record_count")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> _builtins.str:
        """
        The description of the zone.
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group to which the zone belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="slaveDns")
    def slave_dns(self) -> _builtins.bool:
        """
        Indicates whether the secondary Domain Name System (DNS) feature is enabled for the zone. **Note:** `slave_dns` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "slave_dns")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="updateTimestamp")
    def update_timestamp(self) -> _builtins.int:
        """
        The time when the DNS record was updated.
        """
        return pulumi.get(self, "update_timestamp")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of the Zone.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> _builtins.str:
        """
        The Name of the Private Zone.
        """
        return pulumi.get(self, "zone_name")


@pulumi.output_type
class GetZonesZoneBindVpcResult(dict):
    def __init__(__self__, *,
                 region_id: _builtins.str,
                 region_name: _builtins.str,
                 vpc_id: _builtins.str,
                 vpc_name: _builtins.str):
        """
        :param _builtins.str region_id: The region ID of the VPC.
        :param _builtins.str region_name: The name of the region where the VPC resides.
        :param _builtins.str vpc_id: The ID of the VPC.
        :param _builtins.str vpc_name: The Name of the VPC.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the VPC.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.str:
        """
        The name of the region where the VPC resides.
        """
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> _builtins.str:
        """
        The Name of the VPC.
        """
        return pulumi.get(self, "vpc_name")


