# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRolePolicyAttachmentsResult',
    'AwaitableGetRolePolicyAttachmentsResult',
    'get_role_policy_attachments',
    'get_role_policy_attachments_output',
]

@pulumi.output_type
class GetRolePolicyAttachmentsResult:
    """
    A collection of values returned by getRolePolicyAttachments.
    """
    def __init__(__self__, attachments=None, id=None, ids=None, output_file=None, role_name=None):
        if attachments and not isinstance(attachments, list):
            raise TypeError("Expected argument 'attachments' to be a list")
        pulumi.set(__self__, "attachments", attachments)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if role_name and not isinstance(role_name, str):
            raise TypeError("Expected argument 'role_name' to be a str")
        pulumi.set(__self__, "role_name", role_name)

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.GetRolePolicyAttachmentsAttachmentResult']:
        """
        A list of Role Policy Attachment Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "attachments")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Role Policy Attachment IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> _builtins.str:
        return pulumi.get(self, "role_name")


class AwaitableGetRolePolicyAttachmentsResult(GetRolePolicyAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRolePolicyAttachmentsResult(
            attachments=self.attachments,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            role_name=self.role_name)


def get_role_policy_attachments(ids: Optional[Sequence[_builtins.str]] = None,
                                output_file: Optional[_builtins.str] = None,
                                role_name: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRolePolicyAttachmentsResult:
    """
    This data source provides Ram Role Policy Attachment available to the user.[What is Role Policy Attachment](https://next.api.alibabacloud.com/document/Ram/2015-05-01/AttachPolicyToRole)

    > **NOTE:** Available since v1.248.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    role = alicloud.ram.Role("role",
        name="roleName",
        document=\"\"\"    {
          \\"Statement\\": [
            {
              \\"Action\\": \\"sts:AssumeRole\\",
              \\"Effect\\": \\"Allow\\",
              \\"Principal\\": {
                \\"Service\\": [
                  \\"apigateway.aliyuncs.com\\", 
                  \\"ecs.aliyuncs.com\\"
                ]
              }
            }
          ],
          \\"Version\\": \\"1\\"
        }
    \"\"\",
        description="this is a role test.")
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    policy = alicloud.ram.Policy("policy",
        policy_name=f"tf-example-{default_integer['result']}",
        policy_document=\"\"\"  {
        \\"Statement\\": [
          {
            \\"Action\\": [
              \\"oss:ListObjects\\",
              \\"oss:GetObject\\"
            ],
            \\"Effect\\": \\"Allow\\",
            \\"Resource\\": [
              \\"acs:oss:*:*:mybucket\\",
              \\"acs:oss:*:*:mybucket/*\\"
            ]
          }
        ],
          \\"Version\\": \\"1\\"
      }
    \"\"\",
        description="this is a policy test")
    default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("default",
        policy_name=policy.policy_name,
        policy_type=policy.type,
        role_name=role.name)
    default = alicloud.ram.get_role_policy_attachments_output(ids=[default_role_policy_attachment.id],
        role_name=role.id)
    pulumi.export("alicloudRamRolePolicyAttachmentExampleId", default.attachments[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Role Policy Attachment IDs. The value is formulated as `role:<policy_name>:<policy_type>:<role_name>`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str role_name: The RAM role name.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['roleName'] = role_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ram/getRolePolicyAttachments:getRolePolicyAttachments', __args__, opts=opts, typ=GetRolePolicyAttachmentsResult).value

    return AwaitableGetRolePolicyAttachmentsResult(
        attachments=pulumi.get(__ret__, 'attachments'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        role_name=pulumi.get(__ret__, 'role_name'))
def get_role_policy_attachments_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                       output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       role_name: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRolePolicyAttachmentsResult]:
    """
    This data source provides Ram Role Policy Attachment available to the user.[What is Role Policy Attachment](https://next.api.alibabacloud.com/document/Ram/2015-05-01/AttachPolicyToRole)

    > **NOTE:** Available since v1.248.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    role = alicloud.ram.Role("role",
        name="roleName",
        document=\"\"\"    {
          \\"Statement\\": [
            {
              \\"Action\\": \\"sts:AssumeRole\\",
              \\"Effect\\": \\"Allow\\",
              \\"Principal\\": {
                \\"Service\\": [
                  \\"apigateway.aliyuncs.com\\", 
                  \\"ecs.aliyuncs.com\\"
                ]
              }
            }
          ],
          \\"Version\\": \\"1\\"
        }
    \"\"\",
        description="this is a role test.")
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    policy = alicloud.ram.Policy("policy",
        policy_name=f"tf-example-{default_integer['result']}",
        policy_document=\"\"\"  {
        \\"Statement\\": [
          {
            \\"Action\\": [
              \\"oss:ListObjects\\",
              \\"oss:GetObject\\"
            ],
            \\"Effect\\": \\"Allow\\",
            \\"Resource\\": [
              \\"acs:oss:*:*:mybucket\\",
              \\"acs:oss:*:*:mybucket/*\\"
            ]
          }
        ],
          \\"Version\\": \\"1\\"
      }
    \"\"\",
        description="this is a policy test")
    default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("default",
        policy_name=policy.policy_name,
        policy_type=policy.type,
        role_name=role.name)
    default = alicloud.ram.get_role_policy_attachments_output(ids=[default_role_policy_attachment.id],
        role_name=role.id)
    pulumi.export("alicloudRamRolePolicyAttachmentExampleId", default.attachments[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Role Policy Attachment IDs. The value is formulated as `role:<policy_name>:<policy_type>:<role_name>`.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str role_name: The RAM role name.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['roleName'] = role_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ram/getRolePolicyAttachments:getRolePolicyAttachments', __args__, opts=opts, typ=GetRolePolicyAttachmentsResult)
    return __ret__.apply(lambda __response__: GetRolePolicyAttachmentsResult(
        attachments=pulumi.get(__response__, 'attachments'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        role_name=pulumi.get(__response__, 'role_name')))
