# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PasswordPolicyArgs', 'PasswordPolicy']

@pulumi.input_type
class PasswordPolicyArgs:
    def __init__(__self__, *,
                 hard_expiry: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_login_attemps: Optional[pulumi.Input[_builtins.int]] = None,
                 max_password_age: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_password_different_character: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_password_length: Optional[pulumi.Input[_builtins.int]] = None,
                 password_not_contain_user_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_reuse_prevention: Optional[pulumi.Input[_builtins.int]] = None,
                 require_lowercase_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_numbers: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_symbols: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_uppercase_characters: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a PasswordPolicy resource.
        :param pulumi.Input[_builtins.bool] hard_expiry: Whether to restrict logon after the password expires. Value:
               - true: After the password expires, you cannot log in to the console. You must reset the password of the RAM user through the main account or a RAM user with administrator permissions to log on normally.
               - false (default): After the password expires, the RAM user can change the password and log on normally.
        :param pulumi.Input[_builtins.int] max_login_attemps: Password retry constraint. After entering the wrong password continuously for the set number of times, the account will be locked for one hour.
               Value range: 0~32.
               Default value: 0, which means that the password retry constraint is not enabled.
        :param pulumi.Input[_builtins.int] max_password_age: Password validity period.
               Value range: 0~1095. Unit: days.
               Default value: 0, which means never expires.
        :param pulumi.Input[_builtins.int] minimum_password_different_character: The minimum number of unique characters in the password.
               Valid values: 0 to 8.
               The default value is 0, which indicates that no limits are imposed on the number of unique characters in a password.
        :param pulumi.Input[_builtins.int] minimum_password_length: The minimum number of characters in the password.
               Valid values: 8 to 32. Default value: 8.
        :param pulumi.Input[_builtins.bool] password_not_contain_user_name: Whether the user name is not allowed in the password. Value:
               - true: The password cannot contain the user name.
               - false (default): The user name can be included in the password.
        :param pulumi.Input[_builtins.int] password_reuse_prevention: Historical password check policy.
               Do not use the previous N Passwords. The value range of N is 0 to 24.
               Default value: 0, indicating that the historical password check policy is not enabled.
        :param pulumi.Input[_builtins.bool] require_lowercase_characters: Specifies whether the password must contain lowercase letters. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_numbers: Specifies whether the password must contain digits. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_symbols: Specifies whether the password must contain special characters. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_uppercase_characters: Specifies whether the password must contain uppercase letters. Valid values:
               - true
               - false (default)
        """
        if hard_expiry is not None:
            pulumi.set(__self__, "hard_expiry", hard_expiry)
        if max_login_attemps is not None:
            pulumi.set(__self__, "max_login_attemps", max_login_attemps)
        if max_password_age is not None:
            pulumi.set(__self__, "max_password_age", max_password_age)
        if minimum_password_different_character is not None:
            pulumi.set(__self__, "minimum_password_different_character", minimum_password_different_character)
        if minimum_password_length is not None:
            pulumi.set(__self__, "minimum_password_length", minimum_password_length)
        if password_not_contain_user_name is not None:
            pulumi.set(__self__, "password_not_contain_user_name", password_not_contain_user_name)
        if password_reuse_prevention is not None:
            pulumi.set(__self__, "password_reuse_prevention", password_reuse_prevention)
        if require_lowercase_characters is not None:
            pulumi.set(__self__, "require_lowercase_characters", require_lowercase_characters)
        if require_numbers is not None:
            pulumi.set(__self__, "require_numbers", require_numbers)
        if require_symbols is not None:
            pulumi.set(__self__, "require_symbols", require_symbols)
        if require_uppercase_characters is not None:
            pulumi.set(__self__, "require_uppercase_characters", require_uppercase_characters)

    @_builtins.property
    @pulumi.getter(name="hardExpiry")
    def hard_expiry(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to restrict logon after the password expires. Value:
        - true: After the password expires, you cannot log in to the console. You must reset the password of the RAM user through the main account or a RAM user with administrator permissions to log on normally.
        - false (default): After the password expires, the RAM user can change the password and log on normally.
        """
        return pulumi.get(self, "hard_expiry")

    @hard_expiry.setter
    def hard_expiry(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hard_expiry", value)

    @_builtins.property
    @pulumi.getter(name="maxLoginAttemps")
    def max_login_attemps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Password retry constraint. After entering the wrong password continuously for the set number of times, the account will be locked for one hour.
        Value range: 0~32.
        Default value: 0, which means that the password retry constraint is not enabled.
        """
        return pulumi.get(self, "max_login_attemps")

    @max_login_attemps.setter
    def max_login_attemps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_login_attemps", value)

    @_builtins.property
    @pulumi.getter(name="maxPasswordAge")
    def max_password_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Password validity period.
        Value range: 0~1095. Unit: days.
        Default value: 0, which means never expires.
        """
        return pulumi.get(self, "max_password_age")

    @max_password_age.setter
    def max_password_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_password_age", value)

    @_builtins.property
    @pulumi.getter(name="minimumPasswordDifferentCharacter")
    def minimum_password_different_character(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of unique characters in the password.
        Valid values: 0 to 8.
        The default value is 0, which indicates that no limits are imposed on the number of unique characters in a password.
        """
        return pulumi.get(self, "minimum_password_different_character")

    @minimum_password_different_character.setter
    def minimum_password_different_character(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_password_different_character", value)

    @_builtins.property
    @pulumi.getter(name="minimumPasswordLength")
    def minimum_password_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of characters in the password.
        Valid values: 8 to 32. Default value: 8.
        """
        return pulumi.get(self, "minimum_password_length")

    @minimum_password_length.setter
    def minimum_password_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_password_length", value)

    @_builtins.property
    @pulumi.getter(name="passwordNotContainUserName")
    def password_not_contain_user_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the user name is not allowed in the password. Value:
        - true: The password cannot contain the user name.
        - false (default): The user name can be included in the password.
        """
        return pulumi.get(self, "password_not_contain_user_name")

    @password_not_contain_user_name.setter
    def password_not_contain_user_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_not_contain_user_name", value)

    @_builtins.property
    @pulumi.getter(name="passwordReusePrevention")
    def password_reuse_prevention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Historical password check policy.
        Do not use the previous N Passwords. The value range of N is 0 to 24.
        Default value: 0, indicating that the historical password check policy is not enabled.
        """
        return pulumi.get(self, "password_reuse_prevention")

    @password_reuse_prevention.setter
    def password_reuse_prevention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_reuse_prevention", value)

    @_builtins.property
    @pulumi.getter(name="requireLowercaseCharacters")
    def require_lowercase_characters(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the password must contain lowercase letters. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_lowercase_characters")

    @require_lowercase_characters.setter
    def require_lowercase_characters(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_lowercase_characters", value)

    @_builtins.property
    @pulumi.getter(name="requireNumbers")
    def require_numbers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the password must contain digits. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_numbers")

    @require_numbers.setter
    def require_numbers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_numbers", value)

    @_builtins.property
    @pulumi.getter(name="requireSymbols")
    def require_symbols(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the password must contain special characters. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_symbols")

    @require_symbols.setter
    def require_symbols(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_symbols", value)

    @_builtins.property
    @pulumi.getter(name="requireUppercaseCharacters")
    def require_uppercase_characters(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the password must contain uppercase letters. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_uppercase_characters")

    @require_uppercase_characters.setter
    def require_uppercase_characters(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_uppercase_characters", value)


@pulumi.input_type
class _PasswordPolicyState:
    def __init__(__self__, *,
                 hard_expiry: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_login_attemps: Optional[pulumi.Input[_builtins.int]] = None,
                 max_password_age: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_password_different_character: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_password_length: Optional[pulumi.Input[_builtins.int]] = None,
                 password_not_contain_user_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_reuse_prevention: Optional[pulumi.Input[_builtins.int]] = None,
                 require_lowercase_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_numbers: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_symbols: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_uppercase_characters: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering PasswordPolicy resources.
        :param pulumi.Input[_builtins.bool] hard_expiry: Whether to restrict logon after the password expires. Value:
               - true: After the password expires, you cannot log in to the console. You must reset the password of the RAM user through the main account or a RAM user with administrator permissions to log on normally.
               - false (default): After the password expires, the RAM user can change the password and log on normally.
        :param pulumi.Input[_builtins.int] max_login_attemps: Password retry constraint. After entering the wrong password continuously for the set number of times, the account will be locked for one hour.
               Value range: 0~32.
               Default value: 0, which means that the password retry constraint is not enabled.
        :param pulumi.Input[_builtins.int] max_password_age: Password validity period.
               Value range: 0~1095. Unit: days.
               Default value: 0, which means never expires.
        :param pulumi.Input[_builtins.int] minimum_password_different_character: The minimum number of unique characters in the password.
               Valid values: 0 to 8.
               The default value is 0, which indicates that no limits are imposed on the number of unique characters in a password.
        :param pulumi.Input[_builtins.int] minimum_password_length: The minimum number of characters in the password.
               Valid values: 8 to 32. Default value: 8.
        :param pulumi.Input[_builtins.bool] password_not_contain_user_name: Whether the user name is not allowed in the password. Value:
               - true: The password cannot contain the user name.
               - false (default): The user name can be included in the password.
        :param pulumi.Input[_builtins.int] password_reuse_prevention: Historical password check policy.
               Do not use the previous N Passwords. The value range of N is 0 to 24.
               Default value: 0, indicating that the historical password check policy is not enabled.
        :param pulumi.Input[_builtins.bool] require_lowercase_characters: Specifies whether the password must contain lowercase letters. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_numbers: Specifies whether the password must contain digits. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_symbols: Specifies whether the password must contain special characters. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_uppercase_characters: Specifies whether the password must contain uppercase letters. Valid values:
               - true
               - false (default)
        """
        if hard_expiry is not None:
            pulumi.set(__self__, "hard_expiry", hard_expiry)
        if max_login_attemps is not None:
            pulumi.set(__self__, "max_login_attemps", max_login_attemps)
        if max_password_age is not None:
            pulumi.set(__self__, "max_password_age", max_password_age)
        if minimum_password_different_character is not None:
            pulumi.set(__self__, "minimum_password_different_character", minimum_password_different_character)
        if minimum_password_length is not None:
            pulumi.set(__self__, "minimum_password_length", minimum_password_length)
        if password_not_contain_user_name is not None:
            pulumi.set(__self__, "password_not_contain_user_name", password_not_contain_user_name)
        if password_reuse_prevention is not None:
            pulumi.set(__self__, "password_reuse_prevention", password_reuse_prevention)
        if require_lowercase_characters is not None:
            pulumi.set(__self__, "require_lowercase_characters", require_lowercase_characters)
        if require_numbers is not None:
            pulumi.set(__self__, "require_numbers", require_numbers)
        if require_symbols is not None:
            pulumi.set(__self__, "require_symbols", require_symbols)
        if require_uppercase_characters is not None:
            pulumi.set(__self__, "require_uppercase_characters", require_uppercase_characters)

    @_builtins.property
    @pulumi.getter(name="hardExpiry")
    def hard_expiry(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to restrict logon after the password expires. Value:
        - true: After the password expires, you cannot log in to the console. You must reset the password of the RAM user through the main account or a RAM user with administrator permissions to log on normally.
        - false (default): After the password expires, the RAM user can change the password and log on normally.
        """
        return pulumi.get(self, "hard_expiry")

    @hard_expiry.setter
    def hard_expiry(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hard_expiry", value)

    @_builtins.property
    @pulumi.getter(name="maxLoginAttemps")
    def max_login_attemps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Password retry constraint. After entering the wrong password continuously for the set number of times, the account will be locked for one hour.
        Value range: 0~32.
        Default value: 0, which means that the password retry constraint is not enabled.
        """
        return pulumi.get(self, "max_login_attemps")

    @max_login_attemps.setter
    def max_login_attemps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_login_attemps", value)

    @_builtins.property
    @pulumi.getter(name="maxPasswordAge")
    def max_password_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Password validity period.
        Value range: 0~1095. Unit: days.
        Default value: 0, which means never expires.
        """
        return pulumi.get(self, "max_password_age")

    @max_password_age.setter
    def max_password_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_password_age", value)

    @_builtins.property
    @pulumi.getter(name="minimumPasswordDifferentCharacter")
    def minimum_password_different_character(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of unique characters in the password.
        Valid values: 0 to 8.
        The default value is 0, which indicates that no limits are imposed on the number of unique characters in a password.
        """
        return pulumi.get(self, "minimum_password_different_character")

    @minimum_password_different_character.setter
    def minimum_password_different_character(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_password_different_character", value)

    @_builtins.property
    @pulumi.getter(name="minimumPasswordLength")
    def minimum_password_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of characters in the password.
        Valid values: 8 to 32. Default value: 8.
        """
        return pulumi.get(self, "minimum_password_length")

    @minimum_password_length.setter
    def minimum_password_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_password_length", value)

    @_builtins.property
    @pulumi.getter(name="passwordNotContainUserName")
    def password_not_contain_user_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the user name is not allowed in the password. Value:
        - true: The password cannot contain the user name.
        - false (default): The user name can be included in the password.
        """
        return pulumi.get(self, "password_not_contain_user_name")

    @password_not_contain_user_name.setter
    def password_not_contain_user_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_not_contain_user_name", value)

    @_builtins.property
    @pulumi.getter(name="passwordReusePrevention")
    def password_reuse_prevention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Historical password check policy.
        Do not use the previous N Passwords. The value range of N is 0 to 24.
        Default value: 0, indicating that the historical password check policy is not enabled.
        """
        return pulumi.get(self, "password_reuse_prevention")

    @password_reuse_prevention.setter
    def password_reuse_prevention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "password_reuse_prevention", value)

    @_builtins.property
    @pulumi.getter(name="requireLowercaseCharacters")
    def require_lowercase_characters(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the password must contain lowercase letters. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_lowercase_characters")

    @require_lowercase_characters.setter
    def require_lowercase_characters(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_lowercase_characters", value)

    @_builtins.property
    @pulumi.getter(name="requireNumbers")
    def require_numbers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the password must contain digits. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_numbers")

    @require_numbers.setter
    def require_numbers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_numbers", value)

    @_builtins.property
    @pulumi.getter(name="requireSymbols")
    def require_symbols(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the password must contain special characters. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_symbols")

    @require_symbols.setter
    def require_symbols(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_symbols", value)

    @_builtins.property
    @pulumi.getter(name="requireUppercaseCharacters")
    def require_uppercase_characters(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the password must contain uppercase letters. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_uppercase_characters")

    @require_uppercase_characters.setter
    def require_uppercase_characters(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "require_uppercase_characters", value)


@pulumi.type_token("alicloud:ram/passwordPolicy:PasswordPolicy")
class PasswordPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hard_expiry: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_login_attemps: Optional[pulumi.Input[_builtins.int]] = None,
                 max_password_age: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_password_different_character: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_password_length: Optional[pulumi.Input[_builtins.int]] = None,
                 password_not_contain_user_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_reuse_prevention: Optional[pulumi.Input[_builtins.int]] = None,
                 require_lowercase_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_numbers: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_symbols: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_uppercase_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Import

        RAM Password Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/passwordPolicy:PasswordPolicy example <id>.
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] hard_expiry: Whether to restrict logon after the password expires. Value:
               - true: After the password expires, you cannot log in to the console. You must reset the password of the RAM user through the main account or a RAM user with administrator permissions to log on normally.
               - false (default): After the password expires, the RAM user can change the password and log on normally.
        :param pulumi.Input[_builtins.int] max_login_attemps: Password retry constraint. After entering the wrong password continuously for the set number of times, the account will be locked for one hour.
               Value range: 0~32.
               Default value: 0, which means that the password retry constraint is not enabled.
        :param pulumi.Input[_builtins.int] max_password_age: Password validity period.
               Value range: 0~1095. Unit: days.
               Default value: 0, which means never expires.
        :param pulumi.Input[_builtins.int] minimum_password_different_character: The minimum number of unique characters in the password.
               Valid values: 0 to 8.
               The default value is 0, which indicates that no limits are imposed on the number of unique characters in a password.
        :param pulumi.Input[_builtins.int] minimum_password_length: The minimum number of characters in the password.
               Valid values: 8 to 32. Default value: 8.
        :param pulumi.Input[_builtins.bool] password_not_contain_user_name: Whether the user name is not allowed in the password. Value:
               - true: The password cannot contain the user name.
               - false (default): The user name can be included in the password.
        :param pulumi.Input[_builtins.int] password_reuse_prevention: Historical password check policy.
               Do not use the previous N Passwords. The value range of N is 0 to 24.
               Default value: 0, indicating that the historical password check policy is not enabled.
        :param pulumi.Input[_builtins.bool] require_lowercase_characters: Specifies whether the password must contain lowercase letters. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_numbers: Specifies whether the password must contain digits. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_symbols: Specifies whether the password must contain special characters. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_uppercase_characters: Specifies whether the password must contain uppercase letters. Valid values:
               - true
               - false (default)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PasswordPolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        RAM Password Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/passwordPolicy:PasswordPolicy example <id>.
        ```

        :param str resource_name: The name of the resource.
        :param PasswordPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PasswordPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hard_expiry: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_login_attemps: Optional[pulumi.Input[_builtins.int]] = None,
                 max_password_age: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_password_different_character: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_password_length: Optional[pulumi.Input[_builtins.int]] = None,
                 password_not_contain_user_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 password_reuse_prevention: Optional[pulumi.Input[_builtins.int]] = None,
                 require_lowercase_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_numbers: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_symbols: Optional[pulumi.Input[_builtins.bool]] = None,
                 require_uppercase_characters: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PasswordPolicyArgs.__new__(PasswordPolicyArgs)

            __props__.__dict__["hard_expiry"] = hard_expiry
            __props__.__dict__["max_login_attemps"] = max_login_attemps
            __props__.__dict__["max_password_age"] = max_password_age
            __props__.__dict__["minimum_password_different_character"] = minimum_password_different_character
            __props__.__dict__["minimum_password_length"] = minimum_password_length
            __props__.__dict__["password_not_contain_user_name"] = password_not_contain_user_name
            __props__.__dict__["password_reuse_prevention"] = password_reuse_prevention
            __props__.__dict__["require_lowercase_characters"] = require_lowercase_characters
            __props__.__dict__["require_numbers"] = require_numbers
            __props__.__dict__["require_symbols"] = require_symbols
            __props__.__dict__["require_uppercase_characters"] = require_uppercase_characters
        super(PasswordPolicy, __self__).__init__(
            'alicloud:ram/passwordPolicy:PasswordPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            hard_expiry: Optional[pulumi.Input[_builtins.bool]] = None,
            max_login_attemps: Optional[pulumi.Input[_builtins.int]] = None,
            max_password_age: Optional[pulumi.Input[_builtins.int]] = None,
            minimum_password_different_character: Optional[pulumi.Input[_builtins.int]] = None,
            minimum_password_length: Optional[pulumi.Input[_builtins.int]] = None,
            password_not_contain_user_name: Optional[pulumi.Input[_builtins.bool]] = None,
            password_reuse_prevention: Optional[pulumi.Input[_builtins.int]] = None,
            require_lowercase_characters: Optional[pulumi.Input[_builtins.bool]] = None,
            require_numbers: Optional[pulumi.Input[_builtins.bool]] = None,
            require_symbols: Optional[pulumi.Input[_builtins.bool]] = None,
            require_uppercase_characters: Optional[pulumi.Input[_builtins.bool]] = None) -> 'PasswordPolicy':
        """
        Get an existing PasswordPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] hard_expiry: Whether to restrict logon after the password expires. Value:
               - true: After the password expires, you cannot log in to the console. You must reset the password of the RAM user through the main account or a RAM user with administrator permissions to log on normally.
               - false (default): After the password expires, the RAM user can change the password and log on normally.
        :param pulumi.Input[_builtins.int] max_login_attemps: Password retry constraint. After entering the wrong password continuously for the set number of times, the account will be locked for one hour.
               Value range: 0~32.
               Default value: 0, which means that the password retry constraint is not enabled.
        :param pulumi.Input[_builtins.int] max_password_age: Password validity period.
               Value range: 0~1095. Unit: days.
               Default value: 0, which means never expires.
        :param pulumi.Input[_builtins.int] minimum_password_different_character: The minimum number of unique characters in the password.
               Valid values: 0 to 8.
               The default value is 0, which indicates that no limits are imposed on the number of unique characters in a password.
        :param pulumi.Input[_builtins.int] minimum_password_length: The minimum number of characters in the password.
               Valid values: 8 to 32. Default value: 8.
        :param pulumi.Input[_builtins.bool] password_not_contain_user_name: Whether the user name is not allowed in the password. Value:
               - true: The password cannot contain the user name.
               - false (default): The user name can be included in the password.
        :param pulumi.Input[_builtins.int] password_reuse_prevention: Historical password check policy.
               Do not use the previous N Passwords. The value range of N is 0 to 24.
               Default value: 0, indicating that the historical password check policy is not enabled.
        :param pulumi.Input[_builtins.bool] require_lowercase_characters: Specifies whether the password must contain lowercase letters. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_numbers: Specifies whether the password must contain digits. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_symbols: Specifies whether the password must contain special characters. Valid values:
               - true
               - false (default)
        :param pulumi.Input[_builtins.bool] require_uppercase_characters: Specifies whether the password must contain uppercase letters. Valid values:
               - true
               - false (default)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PasswordPolicyState.__new__(_PasswordPolicyState)

        __props__.__dict__["hard_expiry"] = hard_expiry
        __props__.__dict__["max_login_attemps"] = max_login_attemps
        __props__.__dict__["max_password_age"] = max_password_age
        __props__.__dict__["minimum_password_different_character"] = minimum_password_different_character
        __props__.__dict__["minimum_password_length"] = minimum_password_length
        __props__.__dict__["password_not_contain_user_name"] = password_not_contain_user_name
        __props__.__dict__["password_reuse_prevention"] = password_reuse_prevention
        __props__.__dict__["require_lowercase_characters"] = require_lowercase_characters
        __props__.__dict__["require_numbers"] = require_numbers
        __props__.__dict__["require_symbols"] = require_symbols
        __props__.__dict__["require_uppercase_characters"] = require_uppercase_characters
        return PasswordPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="hardExpiry")
    def hard_expiry(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to restrict logon after the password expires. Value:
        - true: After the password expires, you cannot log in to the console. You must reset the password of the RAM user through the main account or a RAM user with administrator permissions to log on normally.
        - false (default): After the password expires, the RAM user can change the password and log on normally.
        """
        return pulumi.get(self, "hard_expiry")

    @_builtins.property
    @pulumi.getter(name="maxLoginAttemps")
    def max_login_attemps(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Password retry constraint. After entering the wrong password continuously for the set number of times, the account will be locked for one hour.
        Value range: 0~32.
        Default value: 0, which means that the password retry constraint is not enabled.
        """
        return pulumi.get(self, "max_login_attemps")

    @_builtins.property
    @pulumi.getter(name="maxPasswordAge")
    def max_password_age(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Password validity period.
        Value range: 0~1095. Unit: days.
        Default value: 0, which means never expires.
        """
        return pulumi.get(self, "max_password_age")

    @_builtins.property
    @pulumi.getter(name="minimumPasswordDifferentCharacter")
    def minimum_password_different_character(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The minimum number of unique characters in the password.
        Valid values: 0 to 8.
        The default value is 0, which indicates that no limits are imposed on the number of unique characters in a password.
        """
        return pulumi.get(self, "minimum_password_different_character")

    @_builtins.property
    @pulumi.getter(name="minimumPasswordLength")
    def minimum_password_length(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum number of characters in the password.
        Valid values: 8 to 32. Default value: 8.
        """
        return pulumi.get(self, "minimum_password_length")

    @_builtins.property
    @pulumi.getter(name="passwordNotContainUserName")
    def password_not_contain_user_name(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the user name is not allowed in the password. Value:
        - true: The password cannot contain the user name.
        - false (default): The user name can be included in the password.
        """
        return pulumi.get(self, "password_not_contain_user_name")

    @_builtins.property
    @pulumi.getter(name="passwordReusePrevention")
    def password_reuse_prevention(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Historical password check policy.
        Do not use the previous N Passwords. The value range of N is 0 to 24.
        Default value: 0, indicating that the historical password check policy is not enabled.
        """
        return pulumi.get(self, "password_reuse_prevention")

    @_builtins.property
    @pulumi.getter(name="requireLowercaseCharacters")
    def require_lowercase_characters(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the password must contain lowercase letters. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_lowercase_characters")

    @_builtins.property
    @pulumi.getter(name="requireNumbers")
    def require_numbers(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the password must contain digits. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_numbers")

    @_builtins.property
    @pulumi.getter(name="requireSymbols")
    def require_symbols(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the password must contain special characters. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_symbols")

    @_builtins.property
    @pulumi.getter(name="requireUppercaseCharacters")
    def require_uppercase_characters(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the password must contain uppercase letters. Valid values:
        - true
        - false (default)
        """
        return pulumi.get(self, "require_uppercase_characters")

