# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RoleArgs', 'Role']

@pulumi.input_type
class RoleArgs:
    def __init__(__self__, *,
                 assume_role_policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 document: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Role resource.
        :param pulumi.Input[_builtins.str] assume_role_policy_document: The trust policy that specifies one or more trusted entities to assume the RAM role. The trusted entities can be Alibaba Cloud accounts, Alibaba Cloud services, or identity providers (IdPs).
        :param pulumi.Input[_builtins.str] description: The description of the RAM role.
        :param pulumi.Input[_builtins.str] document: Field `document` has been deprecated from provider version 1.252.0. New field `assume_role_policy_document` instead.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Role. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] max_session_duration: The maximum session time of the RAM role. Default value: `3600`. Valid values: `3600` to `43200`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.252.0. New field `role_name` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ram_users: Field `ram_users` has been deprecated from provider version 1.49.0. New field `document` instead.
        :param pulumi.Input[_builtins.str] role_name: The name of the RAM role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: Field `services` has been deprecated from provider version 1.49.0. New field `document` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags for the role.
        :param pulumi.Input[_builtins.str] version: Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        if assume_role_policy_document is not None:
            pulumi.set(__self__, "assume_role_policy_document", assume_role_policy_document)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if document is not None:
            warnings.warn("""Field 'document' has been deprecated from provider version 1.252.0. New field 'assume_role_policy_document' instead.""", DeprecationWarning)
            pulumi.log.warn("""document is deprecated: Field 'document' has been deprecated from provider version 1.252.0. New field 'assume_role_policy_document' instead.""")
        if document is not None:
            pulumi.set(__self__, "document", document)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if max_session_duration is not None:
            pulumi.set(__self__, "max_session_duration", max_session_duration)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.252.0. New field 'role_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.252.0. New field 'role_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ram_users is not None:
            warnings.warn("""Field 'ram_users' has been deprecated from provider version 1.49.0. New field 'document' instead.""", DeprecationWarning)
            pulumi.log.warn("""ram_users is deprecated: Field 'ram_users' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
        if ram_users is not None:
            pulumi.set(__self__, "ram_users", ram_users)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if services is not None:
            warnings.warn("""Field 'services' has been deprecated from provider version 1.49.0. New field 'document' instead.""", DeprecationWarning)
            pulumi.log.warn("""services is deprecated: Field 'services' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            warnings.warn("""Field 'version' has been deprecated from provider version 1.49.0. New field 'document' instead.""", DeprecationWarning)
            pulumi.log.warn("""version is deprecated: Field 'version' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="assumeRolePolicyDocument")
    def assume_role_policy_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The trust policy that specifies one or more trusted entities to assume the RAM role. The trusted entities can be Alibaba Cloud accounts, Alibaba Cloud services, or identity providers (IdPs).
        """
        return pulumi.get(self, "assume_role_policy_document")

    @assume_role_policy_document.setter
    def assume_role_policy_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role_policy_document", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the RAM role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'document' has been deprecated from provider version 1.252.0. New field 'assume_role_policy_document' instead.""")
    def document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `document` has been deprecated from provider version 1.252.0. New field `assume_role_policy_document` instead.
        """
        return pulumi.get(self, "document")

    @document.setter
    def document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "document", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to force delete the Role. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="maxSessionDuration")
    def max_session_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum session time of the RAM role. Default value: `3600`. Valid values: `3600` to `43200`.
        """
        return pulumi.get(self, "max_session_duration")

    @max_session_duration.setter
    def max_session_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_session_duration", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.252.0. New field 'role_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.252.0. New field `role_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ramUsers")
    @_utilities.deprecated("""Field 'ram_users' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
    def ram_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field `ram_users` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "ram_users")

    @ram_users.setter
    def ram_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ram_users", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'services' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field `services` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of tags for the role.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'version' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _RoleState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 assume_role_policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 document: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Role resources.
        :param pulumi.Input[_builtins.str] arn: The Alibaba Cloud Resource Name (ARN) of the RAM role.
        :param pulumi.Input[_builtins.str] assume_role_policy_document: The trust policy that specifies one or more trusted entities to assume the RAM role. The trusted entities can be Alibaba Cloud accounts, Alibaba Cloud services, or identity providers (IdPs).
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.252.0) The time when the RAM role was created.
        :param pulumi.Input[_builtins.str] description: The description of the RAM role.
        :param pulumi.Input[_builtins.str] document: Field `document` has been deprecated from provider version 1.252.0. New field `assume_role_policy_document` instead.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Role. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] max_session_duration: The maximum session time of the RAM role. Default value: `3600`. Valid values: `3600` to `43200`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.252.0. New field `role_name` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ram_users: Field `ram_users` has been deprecated from provider version 1.49.0. New field `document` instead.
        :param pulumi.Input[_builtins.str] role_id: The ID of the RAM role.
        :param pulumi.Input[_builtins.str] role_name: The name of the RAM role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: Field `services` has been deprecated from provider version 1.49.0. New field `document` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags for the role.
        :param pulumi.Input[_builtins.str] version: Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if assume_role_policy_document is not None:
            pulumi.set(__self__, "assume_role_policy_document", assume_role_policy_document)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if document is not None:
            warnings.warn("""Field 'document' has been deprecated from provider version 1.252.0. New field 'assume_role_policy_document' instead.""", DeprecationWarning)
            pulumi.log.warn("""document is deprecated: Field 'document' has been deprecated from provider version 1.252.0. New field 'assume_role_policy_document' instead.""")
        if document is not None:
            pulumi.set(__self__, "document", document)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if max_session_duration is not None:
            pulumi.set(__self__, "max_session_duration", max_session_duration)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.252.0. New field 'role_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.252.0. New field 'role_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ram_users is not None:
            warnings.warn("""Field 'ram_users' has been deprecated from provider version 1.49.0. New field 'document' instead.""", DeprecationWarning)
            pulumi.log.warn("""ram_users is deprecated: Field 'ram_users' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
        if ram_users is not None:
            pulumi.set(__self__, "ram_users", ram_users)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if services is not None:
            warnings.warn("""Field 'services' has been deprecated from provider version 1.49.0. New field 'document' instead.""", DeprecationWarning)
            pulumi.log.warn("""services is deprecated: Field 'services' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            warnings.warn("""Field 'version' has been deprecated from provider version 1.49.0. New field 'document' instead.""", DeprecationWarning)
            pulumi.log.warn("""version is deprecated: Field 'version' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Alibaba Cloud Resource Name (ARN) of the RAM role.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="assumeRolePolicyDocument")
    def assume_role_policy_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The trust policy that specifies one or more trusted entities to assume the RAM role. The trusted entities can be Alibaba Cloud accounts, Alibaba Cloud services, or identity providers (IdPs).
        """
        return pulumi.get(self, "assume_role_policy_document")

    @assume_role_policy_document.setter
    def assume_role_policy_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assume_role_policy_document", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.252.0) The time when the RAM role was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the RAM role.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'document' has been deprecated from provider version 1.252.0. New field 'assume_role_policy_document' instead.""")
    def document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `document` has been deprecated from provider version 1.252.0. New field `assume_role_policy_document` instead.
        """
        return pulumi.get(self, "document")

    @document.setter
    def document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "document", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to force delete the Role. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="maxSessionDuration")
    def max_session_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum session time of the RAM role. Default value: `3600`. Valid values: `3600` to `43200`.
        """
        return pulumi.get(self, "max_session_duration")

    @max_session_duration.setter
    def max_session_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_session_duration", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.252.0. New field 'role_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.252.0. New field `role_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ramUsers")
    @_utilities.deprecated("""Field 'ram_users' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
    def ram_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field `ram_users` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "ram_users")

    @ram_users.setter
    def ram_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ram_users", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the RAM role.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the RAM role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'services' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Field `services` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of tags for the role.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'version' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("alicloud:ram/role:Role")
class Role(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role_policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 document: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RAM Role resource.

        For information about RAM Role and how to use it, see [What is Role](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ram-2015-05-01-createrole).

        > **NOTE:** Available since v1.0.0.

        > **NOTE:** When you want to destroy this resource forcefully(means remove all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_role = alicloud.ram.Role("default",
            role_name=f"terraform-example-{default['result']}",
            assume_role_policy_document=\"\"\"  {
            \\"Statement\\": [
              {
                \\"Action\\": \\"sts:AssumeRole\\",
                \\"Effect\\": \\"Allow\\",
                \\"Principal\\": {
                  \\"Service\\": [
                    \\"apigateway.aliyuncs.com\\",
                    \\"ecs.aliyuncs.com\\"
                  ]
                }
              }
            ],
            \\"Version\\": \\"1\\"
          }
        \"\"\",
            description="this is a role test.")
        ```

        ## Import

        RAM Role can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/role:Role example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] assume_role_policy_document: The trust policy that specifies one or more trusted entities to assume the RAM role. The trusted entities can be Alibaba Cloud accounts, Alibaba Cloud services, or identity providers (IdPs).
        :param pulumi.Input[_builtins.str] description: The description of the RAM role.
        :param pulumi.Input[_builtins.str] document: Field `document` has been deprecated from provider version 1.252.0. New field `assume_role_policy_document` instead.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Role. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] max_session_duration: The maximum session time of the RAM role. Default value: `3600`. Valid values: `3600` to `43200`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.252.0. New field `role_name` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ram_users: Field `ram_users` has been deprecated from provider version 1.49.0. New field `document` instead.
        :param pulumi.Input[_builtins.str] role_name: The name of the RAM role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: Field `services` has been deprecated from provider version 1.49.0. New field `document` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags for the role.
        :param pulumi.Input[_builtins.str] version: Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RoleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RAM Role resource.

        For information about RAM Role and how to use it, see [What is Role](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ram-2015-05-01-createrole).

        > **NOTE:** Available since v1.0.0.

        > **NOTE:** When you want to destroy this resource forcefully(means remove all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_role = alicloud.ram.Role("default",
            role_name=f"terraform-example-{default['result']}",
            assume_role_policy_document=\"\"\"  {
            \\"Statement\\": [
              {
                \\"Action\\": \\"sts:AssumeRole\\",
                \\"Effect\\": \\"Allow\\",
                \\"Principal\\": {
                  \\"Service\\": [
                    \\"apigateway.aliyuncs.com\\",
                    \\"ecs.aliyuncs.com\\"
                  ]
                }
              }
            ],
            \\"Version\\": \\"1\\"
          }
        \"\"\",
            description="this is a role test.")
        ```

        ## Import

        RAM Role can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/role:Role example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role_policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 document: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleArgs.__new__(RoleArgs)

            __props__.__dict__["assume_role_policy_document"] = assume_role_policy_document
            __props__.__dict__["description"] = description
            __props__.__dict__["document"] = document
            __props__.__dict__["force"] = force
            __props__.__dict__["max_session_duration"] = max_session_duration
            __props__.__dict__["name"] = name
            __props__.__dict__["ram_users"] = ram_users
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["services"] = services
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version"] = version
            __props__.__dict__["arn"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["role_id"] = None
        super(Role, __self__).__init__(
            'alicloud:ram/role:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            assume_role_policy_document: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            document: Optional[pulumi.Input[_builtins.str]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            max_session_duration: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ram_users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            role_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Role':
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Alibaba Cloud Resource Name (ARN) of the RAM role.
        :param pulumi.Input[_builtins.str] assume_role_policy_document: The trust policy that specifies one or more trusted entities to assume the RAM role. The trusted entities can be Alibaba Cloud accounts, Alibaba Cloud services, or identity providers (IdPs).
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.252.0) The time when the RAM role was created.
        :param pulumi.Input[_builtins.str] description: The description of the RAM role.
        :param pulumi.Input[_builtins.str] document: Field `document` has been deprecated from provider version 1.252.0. New field `assume_role_policy_document` instead.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Role. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] max_session_duration: The maximum session time of the RAM role. Default value: `3600`. Valid values: `3600` to `43200`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.252.0. New field `role_name` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ram_users: Field `ram_users` has been deprecated from provider version 1.49.0. New field `document` instead.
        :param pulumi.Input[_builtins.str] role_id: The ID of the RAM role.
        :param pulumi.Input[_builtins.str] role_name: The name of the RAM role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: Field `services` has been deprecated from provider version 1.49.0. New field `document` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags for the role.
        :param pulumi.Input[_builtins.str] version: Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleState.__new__(_RoleState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["assume_role_policy_document"] = assume_role_policy_document
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["document"] = document
        __props__.__dict__["force"] = force
        __props__.__dict__["max_session_duration"] = max_session_duration
        __props__.__dict__["name"] = name
        __props__.__dict__["ram_users"] = ram_users
        __props__.__dict__["role_id"] = role_id
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["services"] = services
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        return Role(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Alibaba Cloud Resource Name (ARN) of the RAM role.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="assumeRolePolicyDocument")
    def assume_role_policy_document(self) -> pulumi.Output[_builtins.str]:
        """
        The trust policy that specifies one or more trusted entities to assume the RAM role. The trusted entities can be Alibaba Cloud accounts, Alibaba Cloud services, or identity providers (IdPs).
        """
        return pulumi.get(self, "assume_role_policy_document")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.252.0) The time when the RAM role was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the RAM role.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'document' has been deprecated from provider version 1.252.0. New field 'assume_role_policy_document' instead.""")
    def document(self) -> pulumi.Output[_builtins.str]:
        """
        Field `document` has been deprecated from provider version 1.252.0. New field `assume_role_policy_document` instead.
        """
        return pulumi.get(self, "document")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to force delete the Role. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="maxSessionDuration")
    def max_session_duration(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum session time of the RAM role. Default value: `3600`. Valid values: `3600` to `43200`.
        """
        return pulumi.get(self, "max_session_duration")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.252.0. New field 'role_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.252.0. New field `role_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ramUsers")
    @_utilities.deprecated("""Field 'ram_users' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
    def ram_users(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Field `ram_users` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "ram_users")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the RAM role.
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the RAM role.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'services' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
    def services(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Field `services` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The list of tags for the role.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'version' has been deprecated from provider version 1.49.0. New field 'document' instead.""")
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "version")

