# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomArgs', 'Custom']

@pulumi.input_type
class CustomArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_extra_param: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDataDiskArgs']]]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 support_case: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input['CustomSystemDiskArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Custom resource.
        :param pulumi.Input[_builtins.str] instance_type: The type of the created RDS Custom dedicated host instance.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the virtual switch. The zone in which the vSwitch is located must correspond to the zone ID entered in ZoneId.
               The network type InstanceNetworkType must be VPC.
        :param pulumi.Input[_builtins.int] amount: Represents the number of instances created
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Value range:
        :param pulumi.Input[_builtins.bool] auto_renew: Whether the instance is automatically renewed. Valid values: true/false. The default is false.
        :param pulumi.Input[_builtins.str] create_extra_param: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] create_mode: Whether to allow joining the ACK cluster. When this parameter is set to `1`, the created instance can be added to the ACK cluster through The `AttachRCInstances` API to efficiently manage container applications.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDataDiskArgs']]] data_disks: Data disk See `data_disk` below.
        :param pulumi.Input[_builtins.str] deployment_set_id: The ID of the deployment set.
        :param pulumi.Input[_builtins.str] description: Instance description. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] direction: Instance configuration type, value range:
               
               > **NOTE:**  This parameter does not need to be uploaded, and the system can automatically determine whether to upgrade or downgrade. If you want to upload, please follow the following logic rules.
               - `Up` (default): upgrade the instance specification. Please ensure that your account balance is sufficient.
               - `Down`: Downgrade instance specifications. When the instance type set to InstanceType is lower than the current instance type, set Direction = down.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to pre-check the operation of creating an instance. Valid values:
        :param pulumi.Input[_builtins.bool] force: Whether to forcibly release the running instance. Value: true/false
        :param pulumi.Input[_builtins.bool] force_stop: Whether to force shutdown. Value range:
        :param pulumi.Input[_builtins.str] host_name: The instance host name.
        :param pulumi.Input[_builtins.str] image_id: The ID of the image used by the instance.
        :param pulumi.Input[_builtins.str] instance_charge_type: The Payment type. Currently, only `Prepaid` (package year and month) types are supported.
        :param pulumi.Input[_builtins.str] internet_charge_type: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] io_optimized: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] key_pair_name: The key pair name. Only flyer names are supported.
        :param pulumi.Input[_builtins.str] password: The account and password of the instance.
        :param pulumi.Input[_builtins.int] period: Prepaid renewal duration, unit: Month/Year.
        :param pulumi.Input[_builtins.str] period_unit: The unit of duration of the year-to-month billing method. Value range:
               - `Year`: Year
               - `Month` (default): Month
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Reserved parameters are not supported.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Security group list
        :param pulumi.Input[_builtins.str] spot_strategy: The bidding strategy for pay-as-you-go instances. This parameter takes effect when the value of `InstanceChargeType` is set to **PostPaid. Value range:
               - `NoSpot`: normal pay-as-you-go instances.
               - `SpotAsPriceGo`: The system automatically bids and follows the actual price in the current market.
               
               Default value: **NoSpot * *.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] support_case: Supported scenarios: createMode:supportCase, for example: NATIVE("0", "eni"),RCK("1", "rck"),ACK_EDGE("1", "edge");
        :param pulumi.Input['CustomSystemDiskArgs'] system_disk: System disk specifications. See `system_disk` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if create_extra_param is not None:
            pulumi.set(__self__, "create_extra_param", create_extra_param)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if force_stop is not None:
            pulumi.set(__self__, "force_stop", force_stop)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if io_optimized is not None:
            pulumi.set(__self__, "io_optimized", io_optimized)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_case is not None:
            pulumi.set(__self__, "support_case", support_case)
        if system_disk is not None:
            pulumi.set(__self__, "system_disk", system_disk)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the created RDS Custom dedicated host instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the virtual switch. The zone in which the vSwitch is located must correspond to the zone ID entered in ZoneId.
        The network type InstanceNetworkType must be VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Represents the number of instances created
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "amount", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. Value range:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the instance is automatically renewed. Valid values: true/false. The default is false.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="createExtraParam")
    def create_extra_param(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "create_extra_param")

    @create_extra_param.setter
    def create_extra_param(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_extra_param", value)

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to allow joining the ACK cluster. When this parameter is set to `1`, the created instance can be added to the ACK cluster through The `AttachRCInstances` API to efficiently manage container applications.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDataDiskArgs']]]]:
        """
        Data disk See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the deployment set.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_set_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance description. It must be 2 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance configuration type, value range:

        > **NOTE:**  This parameter does not need to be uploaded, and the system can automatically determine whether to upgrade or downgrade. If you want to upload, please follow the following logic rules.
        - `Up` (default): upgrade the instance specification. Please ensure that your account balance is sufficient.
        - `Down`: Downgrade instance specifications. When the instance type set to InstanceType is lower than the current instance type, set Direction = down.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pre-check the operation of creating an instance. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to forcibly release the running instance. Value: true/false
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="forceStop")
    def force_stop(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to force shutdown. Value range:
        """
        return pulumi.get(self, "force_stop")

    @force_stop.setter
    def force_stop(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_stop", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance host name.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the image used by the instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Payment type. Currently, only `Prepaid` (package year and month) types are supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "io_optimized")

    @io_optimized.setter
    def io_optimized(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "io_optimized", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key pair name. Only flyer names are supported.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account and password of the instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Prepaid renewal duration, unit: Month/Year.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of duration of the year-to-month billing method. Value range:
        - `Year`: Year
        - `Month` (default): Month
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Security group list
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bidding strategy for pay-as-you-go instances. This parameter takes effect when the value of `InstanceChargeType` is set to **PostPaid. Value range:
        - `NoSpot`: normal pay-as-you-go instances.
        - `SpotAsPriceGo`: The system automatically bids and follows the actual price in the current market.

        Default value: **NoSpot * *.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="supportCase")
    def support_case(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supported scenarios: createMode:supportCase, for example: NATIVE("0", "eni"),RCK("1", "rck"),ACK_EDGE("1", "edge");
        """
        return pulumi.get(self, "support_case")

    @support_case.setter
    def support_case(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "support_case", value)

    @_builtins.property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> Optional[pulumi.Input['CustomSystemDiskArgs']]:
        """
        System disk specifications. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: Optional[pulumi.Input['CustomSystemDiskArgs']]):
        pulumi.set(self, "system_disk", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID  of the resource
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _CustomState:
    def __init__(__self__, *,
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_extra_param: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDataDiskArgs']]]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 support_case: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input['CustomSystemDiskArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Custom resources.
        :param pulumi.Input[_builtins.int] amount: Represents the number of instances created
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Value range:
        :param pulumi.Input[_builtins.bool] auto_renew: Whether the instance is automatically renewed. Valid values: true/false. The default is false.
        :param pulumi.Input[_builtins.str] create_extra_param: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] create_mode: Whether to allow joining the ACK cluster. When this parameter is set to `1`, the created instance can be added to the ACK cluster through The `AttachRCInstances` API to efficiently manage container applications.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDataDiskArgs']]] data_disks: Data disk See `data_disk` below.
        :param pulumi.Input[_builtins.str] deployment_set_id: The ID of the deployment set.
        :param pulumi.Input[_builtins.str] description: Instance description. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] direction: Instance configuration type, value range:
               
               > **NOTE:**  This parameter does not need to be uploaded, and the system can automatically determine whether to upgrade or downgrade. If you want to upload, please follow the following logic rules.
               - `Up` (default): upgrade the instance specification. Please ensure that your account balance is sufficient.
               - `Down`: Downgrade instance specifications. When the instance type set to InstanceType is lower than the current instance type, set Direction = down.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to pre-check the operation of creating an instance. Valid values:
        :param pulumi.Input[_builtins.bool] force: Whether to forcibly release the running instance. Value: true/false
        :param pulumi.Input[_builtins.bool] force_stop: Whether to force shutdown. Value range:
        :param pulumi.Input[_builtins.str] host_name: The instance host name.
        :param pulumi.Input[_builtins.str] image_id: The ID of the image used by the instance.
        :param pulumi.Input[_builtins.str] instance_charge_type: The Payment type. Currently, only `Prepaid` (package year and month) types are supported.
        :param pulumi.Input[_builtins.str] instance_type: The type of the created RDS Custom dedicated host instance.
        :param pulumi.Input[_builtins.str] internet_charge_type: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] io_optimized: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] key_pair_name: The key pair name. Only flyer names are supported.
        :param pulumi.Input[_builtins.str] password: The account and password of the instance.
        :param pulumi.Input[_builtins.int] period: Prepaid renewal duration, unit: Month/Year.
        :param pulumi.Input[_builtins.str] period_unit: The unit of duration of the year-to-month billing method. Value range:
               - `Year`: Year
               - `Month` (default): Month
        :param pulumi.Input[_builtins.str] region_id: The region ID. Callable DescribeRegions to get.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Reserved parameters are not supported.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Security group list
        :param pulumi.Input[_builtins.str] spot_strategy: The bidding strategy for pay-as-you-go instances. This parameter takes effect when the value of `InstanceChargeType` is set to **PostPaid. Value range:
               - `NoSpot`: normal pay-as-you-go instances.
               - `SpotAsPriceGo`: The system automatically bids and follows the actual price in the current market.
               
               Default value: **NoSpot * *.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] support_case: Supported scenarios: createMode:supportCase, for example: NATIVE("0", "eni"),RCK("1", "rck"),ACK_EDGE("1", "edge");
        :param pulumi.Input['CustomSystemDiskArgs'] system_disk: System disk specifications. See `system_disk` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the virtual switch. The zone in which the vSwitch is located must correspond to the zone ID entered in ZoneId.
               The network type InstanceNetworkType must be VPC.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if create_extra_param is not None:
            pulumi.set(__self__, "create_extra_param", create_extra_param)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if force_stop is not None:
            pulumi.set(__self__, "force_stop", force_stop)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if io_optimized is not None:
            pulumi.set(__self__, "io_optimized", io_optimized)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_case is not None:
            pulumi.set(__self__, "support_case", support_case)
        if system_disk is not None:
            pulumi.set(__self__, "system_disk", system_disk)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Represents the number of instances created
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "amount", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pay automatically. Value range:
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the instance is automatically renewed. Valid values: true/false. The default is false.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="createExtraParam")
    def create_extra_param(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "create_extra_param")

    @create_extra_param.setter
    def create_extra_param(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_extra_param", value)

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to allow joining the ACK cluster. When this parameter is set to `1`, the created instance can be added to the ACK cluster through The `AttachRCInstances` API to efficiently manage container applications.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDataDiskArgs']]]]:
        """
        Data disk See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the deployment set.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_set_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance description. It must be 2 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance configuration type, value range:

        > **NOTE:**  This parameter does not need to be uploaded, and the system can automatically determine whether to upgrade or downgrade. If you want to upload, please follow the following logic rules.
        - `Up` (default): upgrade the instance specification. Please ensure that your account balance is sufficient.
        - `Down`: Downgrade instance specifications. When the instance type set to InstanceType is lower than the current instance type, set Direction = down.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to pre-check the operation of creating an instance. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to forcibly release the running instance. Value: true/false
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="forceStop")
    def force_stop(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to force shutdown. Value range:
        """
        return pulumi.get(self, "force_stop")

    @force_stop.setter
    def force_stop(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_stop", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance host name.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the image used by the instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Payment type. Currently, only `Prepaid` (package year and month) types are supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the created RDS Custom dedicated host instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "io_optimized")

    @io_optimized.setter
    def io_optimized(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "io_optimized", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key pair name. Only flyer names are supported.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account and password of the instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Prepaid renewal duration, unit: Month/Year.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of duration of the year-to-month billing method. Value range:
        - `Year`: Year
        - `Month` (default): Month
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID. Callable DescribeRegions to get.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Security group list
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bidding strategy for pay-as-you-go instances. This parameter takes effect when the value of `InstanceChargeType` is set to **PostPaid. Value range:
        - `NoSpot`: normal pay-as-you-go instances.
        - `SpotAsPriceGo`: The system automatically bids and follows the actual price in the current market.

        Default value: **NoSpot * *.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="supportCase")
    def support_case(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supported scenarios: createMode:supportCase, for example: NATIVE("0", "eni"),RCK("1", "rck"),ACK_EDGE("1", "edge");
        """
        return pulumi.get(self, "support_case")

    @support_case.setter
    def support_case(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "support_case", value)

    @_builtins.property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> Optional[pulumi.Input['CustomSystemDiskArgs']]:
        """
        System disk specifications. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: Optional[pulumi.Input['CustomSystemDiskArgs']]):
        pulumi.set(self, "system_disk", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual switch. The zone in which the vSwitch is located must correspond to the zone ID entered in ZoneId.
        The network type InstanceNetworkType must be VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID  of the resource
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:rds/custom:Custom")
class Custom(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_extra_param: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDataDiskArgs', 'CustomDataDiskArgsDict']]]]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 support_case: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input[Union['CustomSystemDiskArgs', 'CustomSystemDiskArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RDS Custom resource.

        Dedicated RDS User host.

        For information about RDS Custom and how to use it, see [What is Custom](https://next.api.alibabacloud.com/document/Rds/2014-08-15/RunRCInstances).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        cluster_id = config.get("clusterId")
        if cluster_id is None:
            cluster_id = "c18c40b2b336840e2b2bbf8ab291758e2"
        deploymentsetid = config.get("deploymentsetid")
        if deploymentsetid is None:
            deploymentsetid = "ds-2ze78ef5kyj9eveue92m"
        vswtich_id = config.get("vswtich-id")
        if vswtich_id is None:
            vswtich_id = "example_vswitch"
        vpc_name = config.get("vpcName")
        if vpc_name is None:
            vpc_name = "beijing111"
        example_region_id = config.get("exampleRegionId")
        if example_region_id is None:
            example_region_id = "cn-beijing"
        description = config.get("description")
        if description is None:
            description = "ran_1-08_rccreatenodepool_api"
        example_zone_id = config.get("exampleZoneId")
        if example_zone_id is None:
            example_zone_id = "cn-beijing-h"
        securitygroup_name = config.get("securitygroupName")
        if securitygroup_name is None:
            securitygroup_name = "rds_custom_init_sg_cn_beijing"
        default = alicloud.resourcemanager.get_resource_groups()
        vpc_id = alicloud.vpc.Network("vpcId", vpc_name=vpc_name)
        v_switch_id = alicloud.vpc.Switch("vSwitchId",
            vpc_id=vpc_id.id,
            zone_id=example_zone_id,
            vswitch_name=vswtich_id,
            cidr_block="172.16.5.0/24")
        security_group_id = alicloud.ecs.SecurityGroup("securityGroupId",
            vpc_id=vpc_id.id,
            security_group_name=securitygroup_name)
        deployment_set = alicloud.ecs.EcsDeploymentSet("deploymentSet")
        key_pair_name = alicloud.ecs.EcsKeyPair("KeyPairName", key_pair_name=v_switch_id.id)
        default_custom = alicloud.rds.Custom("default",
            amount=1,
            auto_renew=False,
            period=1,
            auto_pay=True,
            instance_type="mysql.x2.xlarge.6cm",
            data_disks=[{
                "category": "cloud_essd",
                "size": 50,
                "performance_level": "PL1",
            }],
            status="Running",
            security_group_ids=[security_group_id.id],
            io_optimized="optimized",
            description=description,
            key_pair_name=key_pair_name.id,
            zone_id=example_zone_id,
            instance_charge_type="Prepaid",
            internet_max_bandwidth_out=0,
            image_id="aliyun_2_1903_x64_20G_alibase_20240628.vhd",
            security_enhancement_strategy="Active",
            period_unit="Month",
            password="jingyiTEST@123",
            system_disk={
                "size": "40",
                "category": "cloud_essd",
            },
            host_name="1743386110",
            create_mode="0",
            spot_strategy="NoSpot",
            vswitch_id=v_switch_id.id,
            support_case="eni",
            deployment_set_id=deploymentsetid,
            dry_run=False)
        ```

        ## Import

        RDS Custom can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/custom:Custom example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] amount: Represents the number of instances created
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Value range:
        :param pulumi.Input[_builtins.bool] auto_renew: Whether the instance is automatically renewed. Valid values: true/false. The default is false.
        :param pulumi.Input[_builtins.str] create_extra_param: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] create_mode: Whether to allow joining the ACK cluster. When this parameter is set to `1`, the created instance can be added to the ACK cluster through The `AttachRCInstances` API to efficiently manage container applications.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDataDiskArgs', 'CustomDataDiskArgsDict']]]] data_disks: Data disk See `data_disk` below.
        :param pulumi.Input[_builtins.str] deployment_set_id: The ID of the deployment set.
        :param pulumi.Input[_builtins.str] description: Instance description. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] direction: Instance configuration type, value range:
               
               > **NOTE:**  This parameter does not need to be uploaded, and the system can automatically determine whether to upgrade or downgrade. If you want to upload, please follow the following logic rules.
               - `Up` (default): upgrade the instance specification. Please ensure that your account balance is sufficient.
               - `Down`: Downgrade instance specifications. When the instance type set to InstanceType is lower than the current instance type, set Direction = down.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to pre-check the operation of creating an instance. Valid values:
        :param pulumi.Input[_builtins.bool] force: Whether to forcibly release the running instance. Value: true/false
        :param pulumi.Input[_builtins.bool] force_stop: Whether to force shutdown. Value range:
        :param pulumi.Input[_builtins.str] host_name: The instance host name.
        :param pulumi.Input[_builtins.str] image_id: The ID of the image used by the instance.
        :param pulumi.Input[_builtins.str] instance_charge_type: The Payment type. Currently, only `Prepaid` (package year and month) types are supported.
        :param pulumi.Input[_builtins.str] instance_type: The type of the created RDS Custom dedicated host instance.
        :param pulumi.Input[_builtins.str] internet_charge_type: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] io_optimized: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] key_pair_name: The key pair name. Only flyer names are supported.
        :param pulumi.Input[_builtins.str] password: The account and password of the instance.
        :param pulumi.Input[_builtins.int] period: Prepaid renewal duration, unit: Month/Year.
        :param pulumi.Input[_builtins.str] period_unit: The unit of duration of the year-to-month billing method. Value range:
               - `Year`: Year
               - `Month` (default): Month
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Reserved parameters are not supported.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Security group list
        :param pulumi.Input[_builtins.str] spot_strategy: The bidding strategy for pay-as-you-go instances. This parameter takes effect when the value of `InstanceChargeType` is set to **PostPaid. Value range:
               - `NoSpot`: normal pay-as-you-go instances.
               - `SpotAsPriceGo`: The system automatically bids and follows the actual price in the current market.
               
               Default value: **NoSpot * *.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] support_case: Supported scenarios: createMode:supportCase, for example: NATIVE("0", "eni"),RCK("1", "rck"),ACK_EDGE("1", "edge");
        :param pulumi.Input[Union['CustomSystemDiskArgs', 'CustomSystemDiskArgsDict']] system_disk: System disk specifications. See `system_disk` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the virtual switch. The zone in which the vSwitch is located must correspond to the zone ID entered in ZoneId.
               The network type InstanceNetworkType must be VPC.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RDS Custom resource.

        Dedicated RDS User host.

        For information about RDS Custom and how to use it, see [What is Custom](https://next.api.alibabacloud.com/document/Rds/2014-08-15/RunRCInstances).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        cluster_id = config.get("clusterId")
        if cluster_id is None:
            cluster_id = "c18c40b2b336840e2b2bbf8ab291758e2"
        deploymentsetid = config.get("deploymentsetid")
        if deploymentsetid is None:
            deploymentsetid = "ds-2ze78ef5kyj9eveue92m"
        vswtich_id = config.get("vswtich-id")
        if vswtich_id is None:
            vswtich_id = "example_vswitch"
        vpc_name = config.get("vpcName")
        if vpc_name is None:
            vpc_name = "beijing111"
        example_region_id = config.get("exampleRegionId")
        if example_region_id is None:
            example_region_id = "cn-beijing"
        description = config.get("description")
        if description is None:
            description = "ran_1-08_rccreatenodepool_api"
        example_zone_id = config.get("exampleZoneId")
        if example_zone_id is None:
            example_zone_id = "cn-beijing-h"
        securitygroup_name = config.get("securitygroupName")
        if securitygroup_name is None:
            securitygroup_name = "rds_custom_init_sg_cn_beijing"
        default = alicloud.resourcemanager.get_resource_groups()
        vpc_id = alicloud.vpc.Network("vpcId", vpc_name=vpc_name)
        v_switch_id = alicloud.vpc.Switch("vSwitchId",
            vpc_id=vpc_id.id,
            zone_id=example_zone_id,
            vswitch_name=vswtich_id,
            cidr_block="172.16.5.0/24")
        security_group_id = alicloud.ecs.SecurityGroup("securityGroupId",
            vpc_id=vpc_id.id,
            security_group_name=securitygroup_name)
        deployment_set = alicloud.ecs.EcsDeploymentSet("deploymentSet")
        key_pair_name = alicloud.ecs.EcsKeyPair("KeyPairName", key_pair_name=v_switch_id.id)
        default_custom = alicloud.rds.Custom("default",
            amount=1,
            auto_renew=False,
            period=1,
            auto_pay=True,
            instance_type="mysql.x2.xlarge.6cm",
            data_disks=[{
                "category": "cloud_essd",
                "size": 50,
                "performance_level": "PL1",
            }],
            status="Running",
            security_group_ids=[security_group_id.id],
            io_optimized="optimized",
            description=description,
            key_pair_name=key_pair_name.id,
            zone_id=example_zone_id,
            instance_charge_type="Prepaid",
            internet_max_bandwidth_out=0,
            image_id="aliyun_2_1903_x64_20G_alibase_20240628.vhd",
            security_enhancement_strategy="Active",
            period_unit="Month",
            password="jingyiTEST@123",
            system_disk={
                "size": "40",
                "category": "cloud_essd",
            },
            host_name="1743386110",
            create_mode="0",
            spot_strategy="NoSpot",
            vswitch_id=v_switch_id.id,
            support_case="eni",
            deployment_set_id=deploymentsetid,
            dry_run=False)
        ```

        ## Import

        RDS Custom can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/custom:Custom example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CustomArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_extra_param: Optional[pulumi.Input[_builtins.str]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDataDiskArgs', 'CustomDataDiskArgsDict']]]]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_stop: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 support_case: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input[Union['CustomSystemDiskArgs', 'CustomSystemDiskArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomArgs.__new__(CustomArgs)

            __props__.__dict__["amount"] = amount
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["create_extra_param"] = create_extra_param
            __props__.__dict__["create_mode"] = create_mode
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["deployment_set_id"] = deployment_set_id
            __props__.__dict__["description"] = description
            __props__.__dict__["direction"] = direction
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["force"] = force
            __props__.__dict__["force_stop"] = force_stop
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["io_optimized"] = io_optimized
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["password"] = password
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["status"] = status
            __props__.__dict__["support_case"] = support_case
            __props__.__dict__["system_disk"] = system_disk
            __props__.__dict__["tags"] = tags
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["region_id"] = None
        super(Custom, __self__).__init__(
            'alicloud:rds/custom:Custom',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amount: Optional[pulumi.Input[_builtins.int]] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            create_extra_param: Optional[pulumi.Input[_builtins.str]] = None,
            create_mode: Optional[pulumi.Input[_builtins.str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDataDiskArgs', 'CustomDataDiskArgsDict']]]]] = None,
            deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            direction: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            force_stop: Optional[pulumi.Input[_builtins.bool]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
            io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
            key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            support_case: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk: Optional[pulumi.Input[Union['CustomSystemDiskArgs', 'CustomSystemDiskArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Custom':
        """
        Get an existing Custom resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] amount: Represents the number of instances created
        :param pulumi.Input[_builtins.bool] auto_pay: Whether to pay automatically. Value range:
        :param pulumi.Input[_builtins.bool] auto_renew: Whether the instance is automatically renewed. Valid values: true/false. The default is false.
        :param pulumi.Input[_builtins.str] create_extra_param: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] create_mode: Whether to allow joining the ACK cluster. When this parameter is set to `1`, the created instance can be added to the ACK cluster through The `AttachRCInstances` API to efficiently manage container applications.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDataDiskArgs', 'CustomDataDiskArgsDict']]]] data_disks: Data disk See `data_disk` below.
        :param pulumi.Input[_builtins.str] deployment_set_id: The ID of the deployment set.
        :param pulumi.Input[_builtins.str] description: Instance description. It must be 2 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[_builtins.str] direction: Instance configuration type, value range:
               
               > **NOTE:**  This parameter does not need to be uploaded, and the system can automatically determine whether to upgrade or downgrade. If you want to upload, please follow the following logic rules.
               - `Up` (default): upgrade the instance specification. Please ensure that your account balance is sufficient.
               - `Down`: Downgrade instance specifications. When the instance type set to InstanceType is lower than the current instance type, set Direction = down.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to pre-check the operation of creating an instance. Valid values:
        :param pulumi.Input[_builtins.bool] force: Whether to forcibly release the running instance. Value: true/false
        :param pulumi.Input[_builtins.bool] force_stop: Whether to force shutdown. Value range:
        :param pulumi.Input[_builtins.str] host_name: The instance host name.
        :param pulumi.Input[_builtins.str] image_id: The ID of the image used by the instance.
        :param pulumi.Input[_builtins.str] instance_charge_type: The Payment type. Currently, only `Prepaid` (package year and month) types are supported.
        :param pulumi.Input[_builtins.str] instance_type: The type of the created RDS Custom dedicated host instance.
        :param pulumi.Input[_builtins.str] internet_charge_type: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] io_optimized: Reserved parameters are not supported.
        :param pulumi.Input[_builtins.str] key_pair_name: The key pair name. Only flyer names are supported.
        :param pulumi.Input[_builtins.str] password: The account and password of the instance.
        :param pulumi.Input[_builtins.int] period: Prepaid renewal duration, unit: Month/Year.
        :param pulumi.Input[_builtins.str] period_unit: The unit of duration of the year-to-month billing method. Value range:
               - `Year`: Year
               - `Month` (default): Month
        :param pulumi.Input[_builtins.str] region_id: The region ID. Callable DescribeRegions to get.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Reserved parameters are not supported.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Security group list
        :param pulumi.Input[_builtins.str] spot_strategy: The bidding strategy for pay-as-you-go instances. This parameter takes effect when the value of `InstanceChargeType` is set to **PostPaid. Value range:
               - `NoSpot`: normal pay-as-you-go instances.
               - `SpotAsPriceGo`: The system automatically bids and follows the actual price in the current market.
               
               Default value: **NoSpot * *.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] support_case: Supported scenarios: createMode:supportCase, for example: NATIVE("0", "eni"),RCK("1", "rck"),ACK_EDGE("1", "edge");
        :param pulumi.Input[Union['CustomSystemDiskArgs', 'CustomSystemDiskArgsDict']] system_disk: System disk specifications. See `system_disk` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the virtual switch. The zone in which the vSwitch is located must correspond to the zone ID entered in ZoneId.
               The network type InstanceNetworkType must be VPC.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomState.__new__(_CustomState)

        __props__.__dict__["amount"] = amount
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["create_extra_param"] = create_extra_param
        __props__.__dict__["create_mode"] = create_mode
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["deployment_set_id"] = deployment_set_id
        __props__.__dict__["description"] = description
        __props__.__dict__["direction"] = direction
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["force"] = force
        __props__.__dict__["force_stop"] = force_stop
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["io_optimized"] = io_optimized
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["status"] = status
        __props__.__dict__["support_case"] = support_case
        __props__.__dict__["system_disk"] = system_disk
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return Custom(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Represents the number of instances created
        """
        return pulumi.get(self, "amount")

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to pay automatically. Value range:
        """
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the instance is automatically renewed. Valid values: true/false. The default is false.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="createExtraParam")
    def create_extra_param(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "create_extra_param")

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to allow joining the ACK cluster. When this parameter is set to `1`, the created instance can be added to the ACK cluster through The `AttachRCInstances` API to efficiently manage container applications.
        """
        return pulumi.get(self, "create_mode")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.CustomDataDisk']]]:
        """
        Data disk See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the deployment set.
        """
        return pulumi.get(self, "deployment_set_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance description. It must be 2 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance configuration type, value range:

        > **NOTE:**  This parameter does not need to be uploaded, and the system can automatically determine whether to upgrade or downgrade. If you want to upload, please follow the following logic rules.
        - `Up` (default): upgrade the instance specification. Please ensure that your account balance is sufficient.
        - `Down`: Downgrade instance specifications. When the instance type set to InstanceType is lower than the current instance type, set Direction = down.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to pre-check the operation of creating an instance. Valid values:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to forcibly release the running instance. Value: true/false
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="forceStop")
    def force_stop(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to force shutdown. Value range:
        """
        return pulumi.get(self, "force_stop")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance host name.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the image used by the instance.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Payment type. Currently, only `Prepaid` (package year and month) types are supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the created RDS Custom dedicated host instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @_builtins.property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "io_optimized")

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key pair name. Only flyer names are supported.
        """
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The account and password of the instance.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Prepaid renewal duration, unit: Month/Year.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unit of duration of the year-to-month billing method. Value range:
        - `Year`: Year
        - `Month` (default): Month
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID. Callable DescribeRegions to get.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Reserved parameters are not supported.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Security group list
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The bidding strategy for pay-as-you-go instances. This parameter takes effect when the value of `InstanceChargeType` is set to **PostPaid. Value range:
        - `NoSpot`: normal pay-as-you-go instances.
        - `SpotAsPriceGo`: The system automatically bids and follows the actual price in the current market.

        Default value: **NoSpot * *.
        """
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="supportCase")
    def support_case(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Supported scenarios: createMode:supportCase, for example: NATIVE("0", "eni"),RCK("1", "rck"),ACK_EDGE("1", "edge");
        """
        return pulumi.get(self, "support_case")

    @_builtins.property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> pulumi.Output[Optional['outputs.CustomSystemDisk']]:
        """
        System disk specifications. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the virtual switch. The zone in which the vSwitch is located must correspond to the zone ID entered in ZoneId.
        The network type InstanceNetworkType must be VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The zone ID  of the resource
        """
        return pulumi.get(self, "zone_id")

