# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeliveryChannelArgs', 'DeliveryChannel']

@pulumi.input_type
class DeliveryChannelArgs:
    def __init__(__self__, *,
                 delivery_channel_filter: pulumi.Input['DeliveryChannelDeliveryChannelFilterArgs'],
                 delivery_channel_name: pulumi.Input[_builtins.str],
                 delivery_channel_description: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_change_delivery: Optional[pulumi.Input['DeliveryChannelResourceChangeDeliveryArgs']] = None,
                 resource_snapshot_delivery: Optional[pulumi.Input['DeliveryChannelResourceSnapshotDeliveryArgs']] = None):
        """
        The set of arguments for constructing a DeliveryChannel resource.
        :param pulumi.Input['DeliveryChannelDeliveryChannelFilterArgs'] delivery_channel_filter: The effective scope of the delivery channel. See `delivery_channel_filter` below.
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[_builtins.str] delivery_channel_description: The description of the delivery channel.
        :param pulumi.Input['DeliveryChannelResourceChangeDeliveryArgs'] resource_change_delivery: The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        :param pulumi.Input['DeliveryChannelResourceSnapshotDeliveryArgs'] resource_snapshot_delivery: The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        pulumi.set(__self__, "delivery_channel_filter", delivery_channel_filter)
        pulumi.set(__self__, "delivery_channel_name", delivery_channel_name)
        if delivery_channel_description is not None:
            pulumi.set(__self__, "delivery_channel_description", delivery_channel_description)
        if resource_change_delivery is not None:
            pulumi.set(__self__, "resource_change_delivery", resource_change_delivery)
        if resource_snapshot_delivery is not None:
            pulumi.set(__self__, "resource_snapshot_delivery", resource_snapshot_delivery)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelFilter")
    def delivery_channel_filter(self) -> pulumi.Input['DeliveryChannelDeliveryChannelFilterArgs']:
        """
        The effective scope of the delivery channel. See `delivery_channel_filter` below.
        """
        return pulumi.get(self, "delivery_channel_filter")

    @delivery_channel_filter.setter
    def delivery_channel_filter(self, value: pulumi.Input['DeliveryChannelDeliveryChannelFilterArgs']):
        pulumi.set(self, "delivery_channel_filter", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_name")

    @delivery_channel_name.setter
    def delivery_channel_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "delivery_channel_name", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelDescription")
    def delivery_channel_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_description")

    @delivery_channel_description.setter
    def delivery_channel_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_description", value)

    @_builtins.property
    @pulumi.getter(name="resourceChangeDelivery")
    def resource_change_delivery(self) -> Optional[pulumi.Input['DeliveryChannelResourceChangeDeliveryArgs']]:
        """
        The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        """
        return pulumi.get(self, "resource_change_delivery")

    @resource_change_delivery.setter
    def resource_change_delivery(self, value: Optional[pulumi.Input['DeliveryChannelResourceChangeDeliveryArgs']]):
        pulumi.set(self, "resource_change_delivery", value)

    @_builtins.property
    @pulumi.getter(name="resourceSnapshotDelivery")
    def resource_snapshot_delivery(self) -> Optional[pulumi.Input['DeliveryChannelResourceSnapshotDeliveryArgs']]:
        """
        The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        return pulumi.get(self, "resource_snapshot_delivery")

    @resource_snapshot_delivery.setter
    def resource_snapshot_delivery(self, value: Optional[pulumi.Input['DeliveryChannelResourceSnapshotDeliveryArgs']]):
        pulumi.set(self, "resource_snapshot_delivery", value)


@pulumi.input_type
class _DeliveryChannelState:
    def __init__(__self__, *,
                 delivery_channel_description: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_filter: Optional[pulumi.Input['DeliveryChannelDeliveryChannelFilterArgs']] = None,
                 delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_change_delivery: Optional[pulumi.Input['DeliveryChannelResourceChangeDeliveryArgs']] = None,
                 resource_snapshot_delivery: Optional[pulumi.Input['DeliveryChannelResourceSnapshotDeliveryArgs']] = None):
        """
        Input properties used for looking up and filtering DeliveryChannel resources.
        :param pulumi.Input[_builtins.str] delivery_channel_description: The description of the delivery channel.
        :param pulumi.Input['DeliveryChannelDeliveryChannelFilterArgs'] delivery_channel_filter: The effective scope of the delivery channel. See `delivery_channel_filter` below.
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input['DeliveryChannelResourceChangeDeliveryArgs'] resource_change_delivery: The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        :param pulumi.Input['DeliveryChannelResourceSnapshotDeliveryArgs'] resource_snapshot_delivery: The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        if delivery_channel_description is not None:
            pulumi.set(__self__, "delivery_channel_description", delivery_channel_description)
        if delivery_channel_filter is not None:
            pulumi.set(__self__, "delivery_channel_filter", delivery_channel_filter)
        if delivery_channel_name is not None:
            pulumi.set(__self__, "delivery_channel_name", delivery_channel_name)
        if resource_change_delivery is not None:
            pulumi.set(__self__, "resource_change_delivery", resource_change_delivery)
        if resource_snapshot_delivery is not None:
            pulumi.set(__self__, "resource_snapshot_delivery", resource_snapshot_delivery)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelDescription")
    def delivery_channel_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_description")

    @delivery_channel_description.setter
    def delivery_channel_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_description", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelFilter")
    def delivery_channel_filter(self) -> Optional[pulumi.Input['DeliveryChannelDeliveryChannelFilterArgs']]:
        """
        The effective scope of the delivery channel. See `delivery_channel_filter` below.
        """
        return pulumi.get(self, "delivery_channel_filter")

    @delivery_channel_filter.setter
    def delivery_channel_filter(self, value: Optional[pulumi.Input['DeliveryChannelDeliveryChannelFilterArgs']]):
        pulumi.set(self, "delivery_channel_filter", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_name")

    @delivery_channel_name.setter
    def delivery_channel_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceChangeDelivery")
    def resource_change_delivery(self) -> Optional[pulumi.Input['DeliveryChannelResourceChangeDeliveryArgs']]:
        """
        The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        """
        return pulumi.get(self, "resource_change_delivery")

    @resource_change_delivery.setter
    def resource_change_delivery(self, value: Optional[pulumi.Input['DeliveryChannelResourceChangeDeliveryArgs']]):
        pulumi.set(self, "resource_change_delivery", value)

    @_builtins.property
    @pulumi.getter(name="resourceSnapshotDelivery")
    def resource_snapshot_delivery(self) -> Optional[pulumi.Input['DeliveryChannelResourceSnapshotDeliveryArgs']]:
        """
        The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        return pulumi.get(self, "resource_snapshot_delivery")

    @resource_snapshot_delivery.setter
    def resource_snapshot_delivery(self, value: Optional[pulumi.Input['DeliveryChannelResourceSnapshotDeliveryArgs']]):
        pulumi.set(self, "resource_snapshot_delivery", value)


@pulumi.type_token("alicloud:resourcemanager/deliveryChannel:DeliveryChannel")
class DeliveryChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_channel_description: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_filter: Optional[pulumi.Input[Union['DeliveryChannelDeliveryChannelFilterArgs', 'DeliveryChannelDeliveryChannelFilterArgsDict']]] = None,
                 delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_change_delivery: Optional[pulumi.Input[Union['DeliveryChannelResourceChangeDeliveryArgs', 'DeliveryChannelResourceChangeDeliveryArgsDict']]] = None,
                 resource_snapshot_delivery: Optional[pulumi.Input[Union['DeliveryChannelResourceSnapshotDeliveryArgs', 'DeliveryChannelResourceSnapshotDeliveryArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Resource Manager Delivery Channel resource.

        Delivery channel resources of current account.

        For information about Resource Manager Delivery Channel and how to use it, see [What is Delivery Channel](https://next.api.alibabacloud.com/document/ResourceCenter/2022-12-01/CreateDeliveryChannel).

        > **NOTE:** Available since v1.262.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.DeliveryChannel("default",
            resource_change_delivery={
                "sls_properties": {
                    "oversized_data_oss_target_arn": "acs:oss:cn-hangzhou:1511928242963727:resourcecenter-aone-example-delivery-oss",
                },
                "target_arn": "acs:log:cn-hangzhou:1511928242963727:project/delivery-aone-example/logstore/resourcecenter-delivery-aone-example-sls",
            },
            delivery_channel_name="delivery_channel_resource_spec_example",
            delivery_channel_description="delivery_channel_resource_spec_example",
            delivery_channel_filter={
                "resource_types": [
                    "ACS::ECS::Instance",
                    "ACS::ECS::Disk",
                    "ACS::VPC::VPC",
                ],
            },
            resource_snapshot_delivery={
                "delivery_time": "16:00Z",
                "target_arn": "acs:log:cn-hangzhou:1511928242963727:project/delivery-aone-example/logstore/resourcecenter-delivery-aone-example-sls",
                "target_type": "SLS",
                "custom_expression": "select * from resources limit 10;",
                "sls_properties": {
                    "oversized_data_oss_target_arn": "acs:oss:cn-hangzhou:1511928242963727:resourcecenter-aone-example-delivery-oss",
                },
            })
        ```

        ## Import

        Resource Manager Delivery Channel can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/deliveryChannel:DeliveryChannel example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] delivery_channel_description: The description of the delivery channel.
        :param pulumi.Input[Union['DeliveryChannelDeliveryChannelFilterArgs', 'DeliveryChannelDeliveryChannelFilterArgsDict']] delivery_channel_filter: The effective scope of the delivery channel. See `delivery_channel_filter` below.
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[Union['DeliveryChannelResourceChangeDeliveryArgs', 'DeliveryChannelResourceChangeDeliveryArgsDict']] resource_change_delivery: The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        :param pulumi.Input[Union['DeliveryChannelResourceSnapshotDeliveryArgs', 'DeliveryChannelResourceSnapshotDeliveryArgsDict']] resource_snapshot_delivery: The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeliveryChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Resource Manager Delivery Channel resource.

        Delivery channel resources of current account.

        For information about Resource Manager Delivery Channel and how to use it, see [What is Delivery Channel](https://next.api.alibabacloud.com/document/ResourceCenter/2022-12-01/CreateDeliveryChannel).

        > **NOTE:** Available since v1.262.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.DeliveryChannel("default",
            resource_change_delivery={
                "sls_properties": {
                    "oversized_data_oss_target_arn": "acs:oss:cn-hangzhou:1511928242963727:resourcecenter-aone-example-delivery-oss",
                },
                "target_arn": "acs:log:cn-hangzhou:1511928242963727:project/delivery-aone-example/logstore/resourcecenter-delivery-aone-example-sls",
            },
            delivery_channel_name="delivery_channel_resource_spec_example",
            delivery_channel_description="delivery_channel_resource_spec_example",
            delivery_channel_filter={
                "resource_types": [
                    "ACS::ECS::Instance",
                    "ACS::ECS::Disk",
                    "ACS::VPC::VPC",
                ],
            },
            resource_snapshot_delivery={
                "delivery_time": "16:00Z",
                "target_arn": "acs:log:cn-hangzhou:1511928242963727:project/delivery-aone-example/logstore/resourcecenter-delivery-aone-example-sls",
                "target_type": "SLS",
                "custom_expression": "select * from resources limit 10;",
                "sls_properties": {
                    "oversized_data_oss_target_arn": "acs:oss:cn-hangzhou:1511928242963727:resourcecenter-aone-example-delivery-oss",
                },
            })
        ```

        ## Import

        Resource Manager Delivery Channel can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/deliveryChannel:DeliveryChannel example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DeliveryChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeliveryChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_channel_description: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_filter: Optional[pulumi.Input[Union['DeliveryChannelDeliveryChannelFilterArgs', 'DeliveryChannelDeliveryChannelFilterArgsDict']]] = None,
                 delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_change_delivery: Optional[pulumi.Input[Union['DeliveryChannelResourceChangeDeliveryArgs', 'DeliveryChannelResourceChangeDeliveryArgsDict']]] = None,
                 resource_snapshot_delivery: Optional[pulumi.Input[Union['DeliveryChannelResourceSnapshotDeliveryArgs', 'DeliveryChannelResourceSnapshotDeliveryArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeliveryChannelArgs.__new__(DeliveryChannelArgs)

            __props__.__dict__["delivery_channel_description"] = delivery_channel_description
            if delivery_channel_filter is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_channel_filter'")
            __props__.__dict__["delivery_channel_filter"] = delivery_channel_filter
            if delivery_channel_name is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_channel_name'")
            __props__.__dict__["delivery_channel_name"] = delivery_channel_name
            __props__.__dict__["resource_change_delivery"] = resource_change_delivery
            __props__.__dict__["resource_snapshot_delivery"] = resource_snapshot_delivery
        super(DeliveryChannel, __self__).__init__(
            'alicloud:resourcemanager/deliveryChannel:DeliveryChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delivery_channel_description: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_channel_filter: Optional[pulumi.Input[Union['DeliveryChannelDeliveryChannelFilterArgs', 'DeliveryChannelDeliveryChannelFilterArgsDict']]] = None,
            delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_change_delivery: Optional[pulumi.Input[Union['DeliveryChannelResourceChangeDeliveryArgs', 'DeliveryChannelResourceChangeDeliveryArgsDict']]] = None,
            resource_snapshot_delivery: Optional[pulumi.Input[Union['DeliveryChannelResourceSnapshotDeliveryArgs', 'DeliveryChannelResourceSnapshotDeliveryArgsDict']]] = None) -> 'DeliveryChannel':
        """
        Get an existing DeliveryChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] delivery_channel_description: The description of the delivery channel.
        :param pulumi.Input[Union['DeliveryChannelDeliveryChannelFilterArgs', 'DeliveryChannelDeliveryChannelFilterArgsDict']] delivery_channel_filter: The effective scope of the delivery channel. See `delivery_channel_filter` below.
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[Union['DeliveryChannelResourceChangeDeliveryArgs', 'DeliveryChannelResourceChangeDeliveryArgsDict']] resource_change_delivery: The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        :param pulumi.Input[Union['DeliveryChannelResourceSnapshotDeliveryArgs', 'DeliveryChannelResourceSnapshotDeliveryArgsDict']] resource_snapshot_delivery: The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeliveryChannelState.__new__(_DeliveryChannelState)

        __props__.__dict__["delivery_channel_description"] = delivery_channel_description
        __props__.__dict__["delivery_channel_filter"] = delivery_channel_filter
        __props__.__dict__["delivery_channel_name"] = delivery_channel_name
        __props__.__dict__["resource_change_delivery"] = resource_change_delivery
        __props__.__dict__["resource_snapshot_delivery"] = resource_snapshot_delivery
        return DeliveryChannel(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelDescription")
    def delivery_channel_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_description")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelFilter")
    def delivery_channel_filter(self) -> pulumi.Output['outputs.DeliveryChannelDeliveryChannelFilter']:
        """
        The effective scope of the delivery channel. See `delivery_channel_filter` below.
        """
        return pulumi.get(self, "delivery_channel_filter")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_name")

    @_builtins.property
    @pulumi.getter(name="resourceChangeDelivery")
    def resource_change_delivery(self) -> pulumi.Output[Optional['outputs.DeliveryChannelResourceChangeDelivery']]:
        """
        The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        """
        return pulumi.get(self, "resource_change_delivery")

    @_builtins.property
    @pulumi.getter(name="resourceSnapshotDelivery")
    def resource_snapshot_delivery(self) -> pulumi.Output[Optional['outputs.DeliveryChannelResourceSnapshotDelivery']]:
        """
        The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        return pulumi.get(self, "resource_snapshot_delivery")

