# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MessageContactArgs', 'MessageContact']

@pulumi.input_type
class MessageContactArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[_builtins.str],
                 message_contact_name: pulumi.Input[_builtins.str],
                 message_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 title: pulumi.Input[_builtins.str],
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MessageContact resource.
        :param pulumi.Input[_builtins.str] email_address: The email address of the contact.
               After you specify an email address, you need to call SendEmailVerificationForMessageContact to send verification information to the email address. After the verification is passed, the email address takes effect.
        :param pulumi.Input[_builtins.str] message_contact_name: The name of the contact.
               The name must be unique in your resource directory.
               The name must be 2 to 12 characters in length and can contain only letters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] message_types: The types of messages received by the contact.
        :param pulumi.Input[_builtins.str] title: The job title of the contact.Valid values:
               - FinanceDirector
               - TechnicalDirector
               - MaintenanceDirector
               - CEO
               - ProjectDirector
               - Other
        :param pulumi.Input[_builtins.str] phone_number: The mobile phone number of the contact.
               
               Specify the mobile phone number in the `-` format.
               
               > **NOTE:**  Only mobile phone numbers in the `86-` format in the Chinese mainland are supported.
               
               After you specify a mobile phone number, you need to call SendPhoneVerificationForMessageContact to send verification information to the mobile phone number. After the verification is passed, the mobile phone number takes effect.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "message_contact_name", message_contact_name)
        pulumi.set(__self__, "message_types", message_types)
        pulumi.set(__self__, "title", title)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)

    @_builtins.property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[_builtins.str]:
        """
        The email address of the contact.
        After you specify an email address, you need to call SendEmailVerificationForMessageContact to send verification information to the email address. After the verification is passed, the email address takes effect.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email_address", value)

    @_builtins.property
    @pulumi.getter(name="messageContactName")
    def message_contact_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the contact.
        The name must be unique in your resource directory.
        The name must be 2 to 12 characters in length and can contain only letters.
        """
        return pulumi.get(self, "message_contact_name")

    @message_contact_name.setter
    def message_contact_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "message_contact_name", value)

    @_builtins.property
    @pulumi.getter(name="messageTypes")
    def message_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The types of messages received by the contact.
        """
        return pulumi.get(self, "message_types")

    @message_types.setter
    def message_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "message_types", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        """
        The job title of the contact.Valid values:
        - FinanceDirector
        - TechnicalDirector
        - MaintenanceDirector
        - CEO
        - ProjectDirector
        - Other
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mobile phone number of the contact.

        Specify the mobile phone number in the `-` format.

        > **NOTE:**  Only mobile phone numbers in the `86-` format in the Chinese mainland are supported.

        After you specify a mobile phone number, you need to call SendPhoneVerificationForMessageContact to send verification information to the mobile phone number. After the verification is passed, the mobile phone number takes effect.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class _MessageContactState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 message_contact_name: Optional[pulumi.Input[_builtins.str]] = None,
                 message_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MessageContact resources.
        :param pulumi.Input[_builtins.str] create_time: The time when the contact was created.
        :param pulumi.Input[_builtins.str] email_address: The email address of the contact.
               After you specify an email address, you need to call SendEmailVerificationForMessageContact to send verification information to the email address. After the verification is passed, the email address takes effect.
        :param pulumi.Input[_builtins.str] message_contact_name: The name of the contact.
               The name must be unique in your resource directory.
               The name must be 2 to 12 characters in length and can contain only letters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] message_types: The types of messages received by the contact.
        :param pulumi.Input[_builtins.str] phone_number: The mobile phone number of the contact.
               
               Specify the mobile phone number in the `-` format.
               
               > **NOTE:**  Only mobile phone numbers in the `86-` format in the Chinese mainland are supported.
               
               After you specify a mobile phone number, you need to call SendPhoneVerificationForMessageContact to send verification information to the mobile phone number. After the verification is passed, the mobile phone number takes effect.
        :param pulumi.Input[_builtins.str] status: The status of the contact.
        :param pulumi.Input[_builtins.str] title: The job title of the contact.Valid values:
               - FinanceDirector
               - TechnicalDirector
               - MaintenanceDirector
               - CEO
               - ProjectDirector
               - Other
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if message_contact_name is not None:
            pulumi.set(__self__, "message_contact_name", message_contact_name)
        if message_types is not None:
            pulumi.set(__self__, "message_types", message_types)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the contact was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address of the contact.
        After you specify an email address, you need to call SendEmailVerificationForMessageContact to send verification information to the email address. After the verification is passed, the email address takes effect.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_address", value)

    @_builtins.property
    @pulumi.getter(name="messageContactName")
    def message_contact_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the contact.
        The name must be unique in your resource directory.
        The name must be 2 to 12 characters in length and can contain only letters.
        """
        return pulumi.get(self, "message_contact_name")

    @message_contact_name.setter
    def message_contact_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_contact_name", value)

    @_builtins.property
    @pulumi.getter(name="messageTypes")
    def message_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The types of messages received by the contact.
        """
        return pulumi.get(self, "message_types")

    @message_types.setter
    def message_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "message_types", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mobile phone number of the contact.

        Specify the mobile phone number in the `-` format.

        > **NOTE:**  Only mobile phone numbers in the `86-` format in the Chinese mainland are supported.

        After you specify a mobile phone number, you need to call SendPhoneVerificationForMessageContact to send verification information to the mobile phone number. After the verification is passed, the mobile phone number takes effect.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "phone_number", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the contact.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The job title of the contact.Valid values:
        - FinanceDirector
        - TechnicalDirector
        - MaintenanceDirector
        - CEO
        - ProjectDirector
        - Other
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.type_token("alicloud:resourcemanager/messageContact:MessageContact")
class MessageContact(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 message_contact_name: Optional[pulumi.Input[_builtins.str]] = None,
                 message_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Resource Manager Message Contact resource.

        Message contact for Resource Directory account.

        For information about Resource Manager Message Contact and how to use it, see [What is Message Contact](https://next.api.alibabacloud.com/document/ResourceDirectoryMaster/2022-04-19/AddMessageContact).

        > **NOTE:** Available since v1.259.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.MessageContact("default",
            message_types=["AccountExpenses"],
            phone_number="86-18626811111",
            title="TechnicalDirector",
            email_address="resourceexample@126.com",
            message_contact_name="example")
        ```

        ## Import

        Resource Manager Message Contact can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/messageContact:MessageContact example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] email_address: The email address of the contact.
               After you specify an email address, you need to call SendEmailVerificationForMessageContact to send verification information to the email address. After the verification is passed, the email address takes effect.
        :param pulumi.Input[_builtins.str] message_contact_name: The name of the contact.
               The name must be unique in your resource directory.
               The name must be 2 to 12 characters in length and can contain only letters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] message_types: The types of messages received by the contact.
        :param pulumi.Input[_builtins.str] phone_number: The mobile phone number of the contact.
               
               Specify the mobile phone number in the `-` format.
               
               > **NOTE:**  Only mobile phone numbers in the `86-` format in the Chinese mainland are supported.
               
               After you specify a mobile phone number, you need to call SendPhoneVerificationForMessageContact to send verification information to the mobile phone number. After the verification is passed, the mobile phone number takes effect.
        :param pulumi.Input[_builtins.str] title: The job title of the contact.Valid values:
               - FinanceDirector
               - TechnicalDirector
               - MaintenanceDirector
               - CEO
               - ProjectDirector
               - Other
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MessageContactArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Resource Manager Message Contact resource.

        Message contact for Resource Directory account.

        For information about Resource Manager Message Contact and how to use it, see [What is Message Contact](https://next.api.alibabacloud.com/document/ResourceDirectoryMaster/2022-04-19/AddMessageContact).

        > **NOTE:** Available since v1.259.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.MessageContact("default",
            message_types=["AccountExpenses"],
            phone_number="86-18626811111",
            title="TechnicalDirector",
            email_address="resourceexample@126.com",
            message_contact_name="example")
        ```

        ## Import

        Resource Manager Message Contact can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/messageContact:MessageContact example <id>
        ```

        :param str resource_name: The name of the resource.
        :param MessageContactArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MessageContactArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 message_contact_name: Optional[pulumi.Input[_builtins.str]] = None,
                 message_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 phone_number: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MessageContactArgs.__new__(MessageContactArgs)

            if email_address is None and not opts.urn:
                raise TypeError("Missing required property 'email_address'")
            __props__.__dict__["email_address"] = email_address
            if message_contact_name is None and not opts.urn:
                raise TypeError("Missing required property 'message_contact_name'")
            __props__.__dict__["message_contact_name"] = message_contact_name
            if message_types is None and not opts.urn:
                raise TypeError("Missing required property 'message_types'")
            __props__.__dict__["message_types"] = message_types
            __props__.__dict__["phone_number"] = phone_number
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(MessageContact, __self__).__init__(
            'alicloud:resourcemanager/messageContact:MessageContact',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            email_address: Optional[pulumi.Input[_builtins.str]] = None,
            message_contact_name: Optional[pulumi.Input[_builtins.str]] = None,
            message_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            phone_number: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            title: Optional[pulumi.Input[_builtins.str]] = None) -> 'MessageContact':
        """
        Get an existing MessageContact resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The time when the contact was created.
        :param pulumi.Input[_builtins.str] email_address: The email address of the contact.
               After you specify an email address, you need to call SendEmailVerificationForMessageContact to send verification information to the email address. After the verification is passed, the email address takes effect.
        :param pulumi.Input[_builtins.str] message_contact_name: The name of the contact.
               The name must be unique in your resource directory.
               The name must be 2 to 12 characters in length and can contain only letters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] message_types: The types of messages received by the contact.
        :param pulumi.Input[_builtins.str] phone_number: The mobile phone number of the contact.
               
               Specify the mobile phone number in the `-` format.
               
               > **NOTE:**  Only mobile phone numbers in the `86-` format in the Chinese mainland are supported.
               
               After you specify a mobile phone number, you need to call SendPhoneVerificationForMessageContact to send verification information to the mobile phone number. After the verification is passed, the mobile phone number takes effect.
        :param pulumi.Input[_builtins.str] status: The status of the contact.
        :param pulumi.Input[_builtins.str] title: The job title of the contact.Valid values:
               - FinanceDirector
               - TechnicalDirector
               - MaintenanceDirector
               - CEO
               - ProjectDirector
               - Other
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MessageContactState.__new__(_MessageContactState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["email_address"] = email_address
        __props__.__dict__["message_contact_name"] = message_contact_name
        __props__.__dict__["message_types"] = message_types
        __props__.__dict__["phone_number"] = phone_number
        __props__.__dict__["status"] = status
        __props__.__dict__["title"] = title
        return MessageContact(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the contact was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Output[_builtins.str]:
        """
        The email address of the contact.
        After you specify an email address, you need to call SendEmailVerificationForMessageContact to send verification information to the email address. After the verification is passed, the email address takes effect.
        """
        return pulumi.get(self, "email_address")

    @_builtins.property
    @pulumi.getter(name="messageContactName")
    def message_contact_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the contact.
        The name must be unique in your resource directory.
        The name must be 2 to 12 characters in length and can contain only letters.
        """
        return pulumi.get(self, "message_contact_name")

    @_builtins.property
    @pulumi.getter(name="messageTypes")
    def message_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The types of messages received by the contact.
        """
        return pulumi.get(self, "message_types")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mobile phone number of the contact.

        Specify the mobile phone number in the `-` format.

        > **NOTE:**  Only mobile phone numbers in the `86-` format in the Chinese mainland are supported.

        After you specify a mobile phone number, you need to call SendPhoneVerificationForMessageContact to send verification information to the mobile phone number. After the verification is passed, the mobile phone number takes effect.
        """
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the contact.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Output[_builtins.str]:
        """
        The job title of the contact.Valid values:
        - FinanceDirector
        - TechnicalDirector
        - MaintenanceDirector
        - CEO
        - ProjectDirector
        - Other
        """
        return pulumi.get(self, "title")

