# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MultiAccountDeliveryChannelArgs', 'MultiAccountDeliveryChannel']

@pulumi.input_type
class MultiAccountDeliveryChannelArgs:
    def __init__(__self__, *,
                 delivery_channel_description: pulumi.Input[_builtins.str],
                 delivery_channel_filter: pulumi.Input['MultiAccountDeliveryChannelDeliveryChannelFilterArgs'],
                 multi_account_delivery_channel_name: pulumi.Input[_builtins.str],
                 resource_change_delivery: Optional[pulumi.Input['MultiAccountDeliveryChannelResourceChangeDeliveryArgs']] = None,
                 resource_snapshot_delivery: Optional[pulumi.Input['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs']] = None):
        """
        The set of arguments for constructing a MultiAccountDeliveryChannel resource.
        :param pulumi.Input[_builtins.str] delivery_channel_description: The description of the delivery channel.
        :param pulumi.Input['MultiAccountDeliveryChannelDeliveryChannelFilterArgs'] delivery_channel_filter: The effective scope of the delivery channel. See `delivery_channel_filter` below.
        :param pulumi.Input[_builtins.str] multi_account_delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input['MultiAccountDeliveryChannelResourceChangeDeliveryArgs'] resource_change_delivery: The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        :param pulumi.Input['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs'] resource_snapshot_delivery: The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        pulumi.set(__self__, "delivery_channel_description", delivery_channel_description)
        pulumi.set(__self__, "delivery_channel_filter", delivery_channel_filter)
        pulumi.set(__self__, "multi_account_delivery_channel_name", multi_account_delivery_channel_name)
        if resource_change_delivery is not None:
            pulumi.set(__self__, "resource_change_delivery", resource_change_delivery)
        if resource_snapshot_delivery is not None:
            pulumi.set(__self__, "resource_snapshot_delivery", resource_snapshot_delivery)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelDescription")
    def delivery_channel_description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_description")

    @delivery_channel_description.setter
    def delivery_channel_description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "delivery_channel_description", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelFilter")
    def delivery_channel_filter(self) -> pulumi.Input['MultiAccountDeliveryChannelDeliveryChannelFilterArgs']:
        """
        The effective scope of the delivery channel. See `delivery_channel_filter` below.
        """
        return pulumi.get(self, "delivery_channel_filter")

    @delivery_channel_filter.setter
    def delivery_channel_filter(self, value: pulumi.Input['MultiAccountDeliveryChannelDeliveryChannelFilterArgs']):
        pulumi.set(self, "delivery_channel_filter", value)

    @_builtins.property
    @pulumi.getter(name="multiAccountDeliveryChannelName")
    def multi_account_delivery_channel_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "multi_account_delivery_channel_name")

    @multi_account_delivery_channel_name.setter
    def multi_account_delivery_channel_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "multi_account_delivery_channel_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceChangeDelivery")
    def resource_change_delivery(self) -> Optional[pulumi.Input['MultiAccountDeliveryChannelResourceChangeDeliveryArgs']]:
        """
        The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        """
        return pulumi.get(self, "resource_change_delivery")

    @resource_change_delivery.setter
    def resource_change_delivery(self, value: Optional[pulumi.Input['MultiAccountDeliveryChannelResourceChangeDeliveryArgs']]):
        pulumi.set(self, "resource_change_delivery", value)

    @_builtins.property
    @pulumi.getter(name="resourceSnapshotDelivery")
    def resource_snapshot_delivery(self) -> Optional[pulumi.Input['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs']]:
        """
        The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        return pulumi.get(self, "resource_snapshot_delivery")

    @resource_snapshot_delivery.setter
    def resource_snapshot_delivery(self, value: Optional[pulumi.Input['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs']]):
        pulumi.set(self, "resource_snapshot_delivery", value)


@pulumi.input_type
class _MultiAccountDeliveryChannelState:
    def __init__(__self__, *,
                 delivery_channel_description: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_filter: Optional[pulumi.Input['MultiAccountDeliveryChannelDeliveryChannelFilterArgs']] = None,
                 multi_account_delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_change_delivery: Optional[pulumi.Input['MultiAccountDeliveryChannelResourceChangeDeliveryArgs']] = None,
                 resource_snapshot_delivery: Optional[pulumi.Input['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs']] = None):
        """
        Input properties used for looking up and filtering MultiAccountDeliveryChannel resources.
        :param pulumi.Input[_builtins.str] delivery_channel_description: The description of the delivery channel.
        :param pulumi.Input['MultiAccountDeliveryChannelDeliveryChannelFilterArgs'] delivery_channel_filter: The effective scope of the delivery channel. See `delivery_channel_filter` below.
        :param pulumi.Input[_builtins.str] multi_account_delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input['MultiAccountDeliveryChannelResourceChangeDeliveryArgs'] resource_change_delivery: The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        :param pulumi.Input['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs'] resource_snapshot_delivery: The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        if delivery_channel_description is not None:
            pulumi.set(__self__, "delivery_channel_description", delivery_channel_description)
        if delivery_channel_filter is not None:
            pulumi.set(__self__, "delivery_channel_filter", delivery_channel_filter)
        if multi_account_delivery_channel_name is not None:
            pulumi.set(__self__, "multi_account_delivery_channel_name", multi_account_delivery_channel_name)
        if resource_change_delivery is not None:
            pulumi.set(__self__, "resource_change_delivery", resource_change_delivery)
        if resource_snapshot_delivery is not None:
            pulumi.set(__self__, "resource_snapshot_delivery", resource_snapshot_delivery)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelDescription")
    def delivery_channel_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_description")

    @delivery_channel_description.setter
    def delivery_channel_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_description", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelFilter")
    def delivery_channel_filter(self) -> Optional[pulumi.Input['MultiAccountDeliveryChannelDeliveryChannelFilterArgs']]:
        """
        The effective scope of the delivery channel. See `delivery_channel_filter` below.
        """
        return pulumi.get(self, "delivery_channel_filter")

    @delivery_channel_filter.setter
    def delivery_channel_filter(self, value: Optional[pulumi.Input['MultiAccountDeliveryChannelDeliveryChannelFilterArgs']]):
        pulumi.set(self, "delivery_channel_filter", value)

    @_builtins.property
    @pulumi.getter(name="multiAccountDeliveryChannelName")
    def multi_account_delivery_channel_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "multi_account_delivery_channel_name")

    @multi_account_delivery_channel_name.setter
    def multi_account_delivery_channel_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_account_delivery_channel_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceChangeDelivery")
    def resource_change_delivery(self) -> Optional[pulumi.Input['MultiAccountDeliveryChannelResourceChangeDeliveryArgs']]:
        """
        The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        """
        return pulumi.get(self, "resource_change_delivery")

    @resource_change_delivery.setter
    def resource_change_delivery(self, value: Optional[pulumi.Input['MultiAccountDeliveryChannelResourceChangeDeliveryArgs']]):
        pulumi.set(self, "resource_change_delivery", value)

    @_builtins.property
    @pulumi.getter(name="resourceSnapshotDelivery")
    def resource_snapshot_delivery(self) -> Optional[pulumi.Input['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs']]:
        """
        The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        return pulumi.get(self, "resource_snapshot_delivery")

    @resource_snapshot_delivery.setter
    def resource_snapshot_delivery(self, value: Optional[pulumi.Input['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs']]):
        pulumi.set(self, "resource_snapshot_delivery", value)


@pulumi.type_token("alicloud:resourcemanager/multiAccountDeliveryChannel:MultiAccountDeliveryChannel")
class MultiAccountDeliveryChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_channel_description: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_filter: Optional[pulumi.Input[Union['MultiAccountDeliveryChannelDeliveryChannelFilterArgs', 'MultiAccountDeliveryChannelDeliveryChannelFilterArgsDict']]] = None,
                 multi_account_delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_change_delivery: Optional[pulumi.Input[Union['MultiAccountDeliveryChannelResourceChangeDeliveryArgs', 'MultiAccountDeliveryChannelResourceChangeDeliveryArgsDict']]] = None,
                 resource_snapshot_delivery: Optional[pulumi.Input[Union['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs', 'MultiAccountDeliveryChannelResourceSnapshotDeliveryArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Resource Manager Multi Account Delivery Channel resource.

        Multi-account Resource Delivery Channel.

        For information about Resource Manager Multi Account Delivery Channel and how to use it, see [What is Multi Account Delivery Channel](https://next.api.alibabacloud.com/document/ResourceCenter/2022-12-01/CreateMultiAccountDeliveryChannel).

        > **NOTE:** Available since v1.262.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultu_hq8_cu = alicloud.resourcemanager.Folder("defaultuHQ8Cu", folder_name="folder-aone-example-1")
        defaultio_i16p = alicloud.resourcemanager.Folder("defaultioI16p", folder_name="folder-aone-example-2")
        default55_uum4 = alicloud.resourcemanager.Folder("default55Uum4", folder_name="folder-aone-example-3")
        defaulti_ej_ebe = alicloud.resourcemanager.Folder("defaultiEjEbe", folder_name="folder-aone-example-4")
        defaultd_nl2_tn = alicloud.resourcemanager.Folder("defaultdNL2TN", folder_name="folder-aone-example-5")
        default = alicloud.resourcemanager.MultiAccountDeliveryChannel("default",
            resource_change_delivery={
                "sls_properties": {
                    "oversized_data_oss_target_arn": "acs:oss:cn-hangzhou:1511928242963727:resourcecenter-aone-example-delivery-oss",
                },
                "target_arn": "acs:log:cn-hangzhou:1511928242963727:project/delivery-aone-example/logstore/resourcecenter-delivery-aone-example-sls",
            },
            delivery_channel_description="multi_delivery_channel_resource_spec_mq_example",
            multi_account_delivery_channel_name="multi_delivery_channel_resource_spec_mq_example",
            delivery_channel_filter={
                "account_scopes": [
                    defaultu_hq8_cu.id,
                    defaultio_i16p.id,
                    default55_uum4.id,
                ],
                "resource_types": [
                    "ACS::ACK::Cluster",
                    "ACS::ActionTrail::Trail",
                    "ACS::BPStudio::Application",
                ],
            },
            resource_snapshot_delivery={
                "delivery_time": "16:00Z",
                "target_arn": "acs:log:cn-hangzhou:1511928242963727:project/delivery-aone-example/logstore/resourcecenter-delivery-aone-example-sls",
                "target_type": "SLS",
                "custom_expression": "select * from resources limit 10;",
                "sls_properties": {
                    "oversized_data_oss_target_arn": "acs:oss:cn-hangzhou:1511928242963727:resourcecenter-aone-example-delivery-oss",
                },
            })
        ```

        ## Import

        Resource Manager Multi Account Delivery Channel can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/multiAccountDeliveryChannel:MultiAccountDeliveryChannel example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] delivery_channel_description: The description of the delivery channel.
        :param pulumi.Input[Union['MultiAccountDeliveryChannelDeliveryChannelFilterArgs', 'MultiAccountDeliveryChannelDeliveryChannelFilterArgsDict']] delivery_channel_filter: The effective scope of the delivery channel. See `delivery_channel_filter` below.
        :param pulumi.Input[_builtins.str] multi_account_delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[Union['MultiAccountDeliveryChannelResourceChangeDeliveryArgs', 'MultiAccountDeliveryChannelResourceChangeDeliveryArgsDict']] resource_change_delivery: The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        :param pulumi.Input[Union['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs', 'MultiAccountDeliveryChannelResourceSnapshotDeliveryArgsDict']] resource_snapshot_delivery: The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MultiAccountDeliveryChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Resource Manager Multi Account Delivery Channel resource.

        Multi-account Resource Delivery Channel.

        For information about Resource Manager Multi Account Delivery Channel and how to use it, see [What is Multi Account Delivery Channel](https://next.api.alibabacloud.com/document/ResourceCenter/2022-12-01/CreateMultiAccountDeliveryChannel).

        > **NOTE:** Available since v1.262.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultu_hq8_cu = alicloud.resourcemanager.Folder("defaultuHQ8Cu", folder_name="folder-aone-example-1")
        defaultio_i16p = alicloud.resourcemanager.Folder("defaultioI16p", folder_name="folder-aone-example-2")
        default55_uum4 = alicloud.resourcemanager.Folder("default55Uum4", folder_name="folder-aone-example-3")
        defaulti_ej_ebe = alicloud.resourcemanager.Folder("defaultiEjEbe", folder_name="folder-aone-example-4")
        defaultd_nl2_tn = alicloud.resourcemanager.Folder("defaultdNL2TN", folder_name="folder-aone-example-5")
        default = alicloud.resourcemanager.MultiAccountDeliveryChannel("default",
            resource_change_delivery={
                "sls_properties": {
                    "oversized_data_oss_target_arn": "acs:oss:cn-hangzhou:1511928242963727:resourcecenter-aone-example-delivery-oss",
                },
                "target_arn": "acs:log:cn-hangzhou:1511928242963727:project/delivery-aone-example/logstore/resourcecenter-delivery-aone-example-sls",
            },
            delivery_channel_description="multi_delivery_channel_resource_spec_mq_example",
            multi_account_delivery_channel_name="multi_delivery_channel_resource_spec_mq_example",
            delivery_channel_filter={
                "account_scopes": [
                    defaultu_hq8_cu.id,
                    defaultio_i16p.id,
                    default55_uum4.id,
                ],
                "resource_types": [
                    "ACS::ACK::Cluster",
                    "ACS::ActionTrail::Trail",
                    "ACS::BPStudio::Application",
                ],
            },
            resource_snapshot_delivery={
                "delivery_time": "16:00Z",
                "target_arn": "acs:log:cn-hangzhou:1511928242963727:project/delivery-aone-example/logstore/resourcecenter-delivery-aone-example-sls",
                "target_type": "SLS",
                "custom_expression": "select * from resources limit 10;",
                "sls_properties": {
                    "oversized_data_oss_target_arn": "acs:oss:cn-hangzhou:1511928242963727:resourcecenter-aone-example-delivery-oss",
                },
            })
        ```

        ## Import

        Resource Manager Multi Account Delivery Channel can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/multiAccountDeliveryChannel:MultiAccountDeliveryChannel example <id>
        ```

        :param str resource_name: The name of the resource.
        :param MultiAccountDeliveryChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MultiAccountDeliveryChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_channel_description: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_filter: Optional[pulumi.Input[Union['MultiAccountDeliveryChannelDeliveryChannelFilterArgs', 'MultiAccountDeliveryChannelDeliveryChannelFilterArgsDict']]] = None,
                 multi_account_delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_change_delivery: Optional[pulumi.Input[Union['MultiAccountDeliveryChannelResourceChangeDeliveryArgs', 'MultiAccountDeliveryChannelResourceChangeDeliveryArgsDict']]] = None,
                 resource_snapshot_delivery: Optional[pulumi.Input[Union['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs', 'MultiAccountDeliveryChannelResourceSnapshotDeliveryArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MultiAccountDeliveryChannelArgs.__new__(MultiAccountDeliveryChannelArgs)

            if delivery_channel_description is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_channel_description'")
            __props__.__dict__["delivery_channel_description"] = delivery_channel_description
            if delivery_channel_filter is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_channel_filter'")
            __props__.__dict__["delivery_channel_filter"] = delivery_channel_filter
            if multi_account_delivery_channel_name is None and not opts.urn:
                raise TypeError("Missing required property 'multi_account_delivery_channel_name'")
            __props__.__dict__["multi_account_delivery_channel_name"] = multi_account_delivery_channel_name
            __props__.__dict__["resource_change_delivery"] = resource_change_delivery
            __props__.__dict__["resource_snapshot_delivery"] = resource_snapshot_delivery
        super(MultiAccountDeliveryChannel, __self__).__init__(
            'alicloud:resourcemanager/multiAccountDeliveryChannel:MultiAccountDeliveryChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delivery_channel_description: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_channel_filter: Optional[pulumi.Input[Union['MultiAccountDeliveryChannelDeliveryChannelFilterArgs', 'MultiAccountDeliveryChannelDeliveryChannelFilterArgsDict']]] = None,
            multi_account_delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_change_delivery: Optional[pulumi.Input[Union['MultiAccountDeliveryChannelResourceChangeDeliveryArgs', 'MultiAccountDeliveryChannelResourceChangeDeliveryArgsDict']]] = None,
            resource_snapshot_delivery: Optional[pulumi.Input[Union['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs', 'MultiAccountDeliveryChannelResourceSnapshotDeliveryArgsDict']]] = None) -> 'MultiAccountDeliveryChannel':
        """
        Get an existing MultiAccountDeliveryChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] delivery_channel_description: The description of the delivery channel.
        :param pulumi.Input[Union['MultiAccountDeliveryChannelDeliveryChannelFilterArgs', 'MultiAccountDeliveryChannelDeliveryChannelFilterArgsDict']] delivery_channel_filter: The effective scope of the delivery channel. See `delivery_channel_filter` below.
        :param pulumi.Input[_builtins.str] multi_account_delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[Union['MultiAccountDeliveryChannelResourceChangeDeliveryArgs', 'MultiAccountDeliveryChannelResourceChangeDeliveryArgsDict']] resource_change_delivery: The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        :param pulumi.Input[Union['MultiAccountDeliveryChannelResourceSnapshotDeliveryArgs', 'MultiAccountDeliveryChannelResourceSnapshotDeliveryArgsDict']] resource_snapshot_delivery: The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MultiAccountDeliveryChannelState.__new__(_MultiAccountDeliveryChannelState)

        __props__.__dict__["delivery_channel_description"] = delivery_channel_description
        __props__.__dict__["delivery_channel_filter"] = delivery_channel_filter
        __props__.__dict__["multi_account_delivery_channel_name"] = multi_account_delivery_channel_name
        __props__.__dict__["resource_change_delivery"] = resource_change_delivery
        __props__.__dict__["resource_snapshot_delivery"] = resource_snapshot_delivery
        return MultiAccountDeliveryChannel(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelDescription")
    def delivery_channel_description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_description")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelFilter")
    def delivery_channel_filter(self) -> pulumi.Output['outputs.MultiAccountDeliveryChannelDeliveryChannelFilter']:
        """
        The effective scope of the delivery channel. See `delivery_channel_filter` below.
        """
        return pulumi.get(self, "delivery_channel_filter")

    @_builtins.property
    @pulumi.getter(name="multiAccountDeliveryChannelName")
    def multi_account_delivery_channel_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "multi_account_delivery_channel_name")

    @_builtins.property
    @pulumi.getter(name="resourceChangeDelivery")
    def resource_change_delivery(self) -> pulumi.Output[Optional['outputs.MultiAccountDeliveryChannelResourceChangeDelivery']]:
        """
        The configurations for delivery of resource configuration change events. See `resource_change_delivery` below.
        """
        return pulumi.get(self, "resource_change_delivery")

    @_builtins.property
    @pulumi.getter(name="resourceSnapshotDelivery")
    def resource_snapshot_delivery(self) -> pulumi.Output[Optional['outputs.MultiAccountDeliveryChannelResourceSnapshotDelivery']]:
        """
        The configurations for delivery of scheduled resource snapshots. See `resource_snapshot_delivery` below.
        """
        return pulumi.get(self, "resource_snapshot_delivery")

